;;;--------------------------------------------------------------------------
;;  ͼ
;;   7 DEC 1993
;;   :ѩ, ƽ
;; ------------------------------------------------------------------------
;;   DESCRIPTION
;;   Insert a frame according to user definition and propotion
;;   with both paper space and modelspace support
;;-------------------------------------------------------------------------
;;   REVISION  HISTORY
;;   15 DEC 1993 Bug removed
;;   20 MAY 1995 Change dialog box layout and add image
;;-------------------------------------------------------------------------
(_@ld "dcllib")
(_@ld "clqlib")

(defun title0 (/ p_a p_c viewcp x1 y1 pc p_a1 pn1 what_next n_list m_list di
                 sal sl a0_list a1_list a2_list a3_list a4_list f0_list f1_list
                 f2_list f3_list sl_list d_list ss_in handle_list sl_sel
                 pop1_in p_list edit_in check_in defaults show_list set_status
                 do_frame)
;-----------------------------
  ;(setq sal 1)
  (if title_data
    (mapcar 'set '(ver_hor sz lb1 lb2 Long Width sal di sl) title_data)
    (setq ver_hor nil sz 1 lb1 T lb2 T Long 841 Width 594 sal (TGetPScale) di 0 sl 6)
  )
  (setq ps (= 0 (getvar "tilemode"))
        p_list '((841 1189)(594 841)(420 594)(297 420)(210 297))
        a0_list '(1189 1338 1487 1635 1784 1932 2081 2230 2387)
        a1_list '(841 1051 1261 1472 1682 1892 2102)
        a2_list '(594 743 892 1041 1189 1338 1487 1635 1784 1932 2081)
        a3_list '(420 631 841 1051 1261 1472 1682 1892)
        a4_list '(297 445 594)
        f0_list '("1/8" "1/4" "3/8" "1/2" "5/8" "3/4" "7/8" "1")
        f1_list '("1/4" "1/2" "3/4" "1" "5/4" "3/2")
        f2_list '("1/4" "1/2" "3/4" "1" "5/4" "3/2" "7/4" "2" "9/4" "9/2")
        f3_list '("1/2" "1" "3/2" "2" "5/2" "3" "7/2")
        f4_list '("1/2" "1")
        sl_list '(1000 500 300 250 200 150 100 50 30 25 20 10 5))
;-----------------------------
  (defun check_in (input format kk /)
    (if (and (distof input 2)(> (atof input) 0))
      (progn (rs_error) input)
      (progn
        (set_tile "error" (strcat "Ч" format ""))
        (mode_tile kk 2)
        nil))
  )
;-----------------------------
  (defun handle_list(/ d0 ln)
    (cond
      ((= sz 0)(setq ln 8  n_list f0_list m_list a0_list))
      ((= sz 1)(setq ln 6  n_list f1_list m_list a1_list))
      ((= sz 2)(setq ln 10 n_list f2_list m_list a2_list))
      ((= sz 3)(setq ln 7  n_list f3_list m_list a3_list))
      (T (setq ln 2 n_list f4_list m_list a4_list)))
    ln
  )
;-----------------------------
  (defun set_status()
    (set_tile "size_sel" (strcat "A" (itoa sz)))
    (set_tile "label1" (if lb1 "1" "0"))
    (set_tile "label2" (if lb2 "1" "0"))
    (set_tile "type_sel" (if ver_hor "ver" "hor"))
    (set_tile "psp" (if ps "1" "0"))
    (set_tile "l_size" (itoa Long))
    (set_tile "w_size" (itoa Width))
    (set_tile "dim_list" (itoa di))
    
    (if ps
      (progn
        (setq sal 1 sl 1)
	(set_tile "scal" "1")
	(set_tile "scal_list" "1")
	(mode_tile "scal" 1)
	(mode_tile "scal_list" 1)
	)
      (progn
        ;(setq sal (TGetPScale))
	(set_tile "scal" (itoa sal))
	(set_tile "scal_list" (itoa sl))
	))
      
  )

  (defun defaults(/ d0 d2 d3 i)
    (set_status)
    (setq d3 (handle_list) d0 (strcat "A" (itoa sz))
          d_list (list d0) i 0)
    (repeat d3
      (setq d2 (nth i n_list) i (1+ i)
            d_list (if (= i 0) d_list
        (append d_list (list (strcat d0 "+" d2)))))
    )
    (show_list "dim_list" d_list)
    (set_tile "dim_list" "0")
    (do_frame)
  )
;-----------------------------
  (defun show_list(k1 l1)
    (start_list k1)
    (mapcar 'add_list l1)
    (end_list)
  )

;;;----------------------------------------------------------------------;
;;; Preview drawing frame within the imagebox
  (defun do_frame ()
   (setq p1 '(0 0) p_a 25 p_c '(10 5) viewcp (getvar "viewctr")
         pc (if (< sz 3)(car p_c)(cadr p_c))
         x1 (* (float Width) sal)
         y1 (* (float Long) sal)
         pc (* (float pc) sal)
         ins_scl sal
         p_a1 (* (float p_a) sal))
   (setvar "tilemode" (if ps 0 1))
   (if ver_hor
     (progn
      (setq p2 (list 0 y1) p3 (list x1 y1) p4 (list x1 0))
      (if (/= sz 4)
        (setq pn1 (list pc pc) pn2 (list (- x1 pc) pc)
              pn3 (list (- x1 pc)(- y1 p_a1))
              pn4 (list pc (- y1 p_a1)))
        (setq pn1 (list p_a1 pc) pn2 (list (- x1 pc) pc)
              pn3 (list (- x1 pc)(- y1 pc))
              pn4 (list p_a1 (- y1 pc))))
    )
    (setq p2 (list 0 x1) p3 (list y1 x1) p4 (list y1 0)
          pn1 (list p_a1 pc) pn2 (list (- y1 pc) pc)
          pn3 (list (- y1 pc)(- x1 pc))
          pn4 (list p_a1 (- x1 pc)))
  )
    (setq plist (list nil p1 p2 p2 p3 p3 p4 p4 p1
                     pn1 pn2 pn2 pn3 pn3 pn4 pn4 pn1))
    (start_image "show_ig")
    (fill_image 0 0 winx winy -2)
    (foreach sublt (apply 'cline_cir plist) (apply 'vector_image sublt))
    (end_image)
  )
;-----------------------------
  (defun ss_in(/ d1 d2 d3 i)
    (setq sz (atoi (substr $value 2 1)) d0 (nth sz p_list)
          Width (car d0) Long (cadr d0)
          d_list (list $value) i 0 d3 (handle_list))
    (repeat d3
      (setq d2 (nth i n_list) i (1+ i) d_list (if (= i 0) d_list
              (append d_list (list (strcat $value "+" d2)))))
    )
    (show_list "dim_list" d_list)
    (set_tile "dim_list" "0")
    (set_tile "w_size" (itoa Width))
    (set_tile "l_size" (itoa Long))
    (do_frame)
  )

  (defun edit_in(n val / ppt k1)
    (cond ((= n 1) (setq ppt "ͼ" k1 "l_size"))
          ((= n 2) (setq ppt "ͼ" k1 "w_size"))
          ((= n 3) (setq ppt "" k1 "scal"))
    )
    (if (check_in val ppt k1)
      (cond
        ((= n 1) (setq long (atoi val)))
        ((= n 2) (setq width (atoi val)))
        ((= n 3) (setq sal (atoi val) ))
      )
    )
   (do_frame)
  )

  (defun list_in(/ a1)
    (setq di (atoi $value))
    (handle_list)
    (setq Long  (nth di m_list))
    (set_tile "l_size" (itoa Long))
    (do_frame)
  )

  (defun sl_sel()
    (setq sl (atoi $value) sal (nth sl sl_list))
    (set_tile "scal" (itoa sal))
    (do_frame)
  )
;--------MAIN FUNCTION-------------
;changed by dongyi 2000.8.16 begin from here    **************************
  
  (if ;;(and (not til_id)
	   (< (setq til_id (load_dialog (strcat _prefix
                                 "title.dcl"))) 0)
   ; )
  (exit))
  (setq what_next 5)
    (if (not (new_dialog "title" til_id))(exit))
    (setq winx (dimx_tile "show_ig") winy (dimy_tile "show_ig"))
    (transws winx winy)
    (defaults)
    (action_tile "size_sel" "(ss_in)")
    (action_tile "label1"   "(setq lb1 (= $value \"1\"))")
    (action_tile "label2"   "(setq lb2 (= $value \"1\"))")
    (action_tile "type_sel" "(setq ver_hor (= $value \"ver\"))(do_frame)")
    (action_tile "psp" "(setq ps (= $value \"1\"))")
    (action_tile "l_size" "(edit_in 1 $value)")    ; edit_box ͼ
    (action_tile "w_size" "(edit_in 2 $value)")    ;          ͼ
    (action_tile "dim_list" "(List_in)")           ; list_box
    (action_tile "scal" "(edit_in 3 $value)")      ; edit_box
    (action_tile "scal_list" "(sl_sel)")           ; popup
    (action_tile "preview" "(done_dialog 2)")
;   (action_tile "cancel" "(done_dialog 0)")
    (action_tile "help" "(do_help \"ddtitle\")")
    (setq what_next (start_dialog))
;--------------------------------------
; draw the frame
  ;changed by dongyi 2000.8.16 end    **************************
  (if (/= what_next 0)
  (progn
  (setq title_data (list ver_hor sz lb1 lb2 Long Width sal di sl))
  (command ".zoom" "C" viewcp (* (cadr p3) 1.2))
  (begin "ͼ")
  (command ".pline" pn1 "w" sal sal pn2 pn3 pn4 "c")
  (setq ssti (ssadd (entlast)))
  (command ".pline" p1 "w" 0 0 p2 p3 p4 "c")
  (ssadd (entlast) ssti)
  (setq p1 pn1 p2 pn3 p3 (list (* 0.5 sal long) (* 0.5 sal width)))
  
  )
  )
  what_next
)

;ʵͼ
(defun c:title (/ ver_hor Long Width sz ps lb1 lb2 ins_scl ssti p1 p2 p3 p4
                  pn2 pn3 pn4 bExit)
  (setq bExit 2)
  (while (= bExit 2)
     (progn 
        (setq bExit (title0))
        ;(princ bExit)
        (cond 
           ((= bExit 1) 
                (progn
                (if (findshx "hztxt.shx")
                  (progn
                  (if lb1
                    (progn
                    (command ".insert" "_LABEL2" pn2 ins_scl ins_scl 0)
                    (setq ssti (ssadd (entlast) ssti))
                    )
                  )
                  (if lb2
                    (progn
                    (command ".insert" "_LABEL1"
                             (if (and ver_hor (/= sz 4)) pn3 pn4) ins_scl ins_scl
                             (if (and ver_hor (/= sz 4)) 0 (angtos1 _pi2)))
                    (setq ssti (ssadd (entlast) ssti))
                    )
                  )
                  )
                )
                ;;(princ "\nȡ: ")
                (end)
                ;;(setvar "orthomode" 0)
                ;;(command ".move" ssti "" p3)
                (TDragTitle ssti)
                )
            )
            ((= bExit 2)
                (progn
                (princ "\nȡ: ")
                (setvar "orthomode" 0)
                (command ".move" ssti "" p3)
                (dstop2)
                (setq p4 (mapcar '- (getvar "lastpoint") p3) h (getvar "viewsize")
                      h (cond ((< h 2e4) 300.) ((< h 2e5) 3000.) (t 30000.)))
                (command ".erase" ssti "" 
                         ;;".limits" (mapcar '+ p1 p4) (mapcar '+ p2 p4)
                         ".grid" h)
                (princ "\nʾ: ʾȫͼʱ,  ZOOM A")
                (end)
                )
            )
        )
    )

  )
  (princ)
)

;ͼ
(defun c:titlei (/ ver_hor Long Width sz ps lb1 lb2 ins_scl ssti p1 p2 p3 p4
                   pn2 pn3 pn4 h)
  (if (title0)
    (progn
    (princ "\nȡ: ")
    (setvar "orthomode" 0)
    (command ".move" ssti "" p3)
    (dstop2)
    (setq p4 (mapcar '- (getvar "lastpoint") p3) h (getvar "viewsize")
          h (cond ((< h 2e4) 300.) ((< h 2e5) 3000.) (t 30000.)))
    (command ".erase" ssti "" ".limits" (mapcar '+ p1 p4) (mapcar '+ p2 p4)
             ".grid" h)
    (princ "\nʾ: ʾȫͼʱ,  ZOOM A")
    (end)
    )
  )(princ)
)

