(defun _revpl (lt)
  (setq	lt (mapcar '(lambda (x)
		      (if (numberp x)
			(- x)
			x
		      )
		    )
		   lt
	   )
  )
  (reverse lt)
)
(defun text_edge (e1 / lt p0 p1 p2 a0 dp)
  (setq lt (entget e1))
  (princ "\n End in text_edge!")
  (if (= (cdr (assoc 0 lt)) "TEXT")
    (setq p0 (trans (cdr (assoc 10 lt)) e1 1)
	  a0 (cdr (assoc 50 lt))
	  lt (textbox lt)
	  dp (mapcar '- (cadr lt) (car lt))
	  p1 (mapcar '+ p0 (car lt))
	  p1 (polar p0 (+ (angle p0 p1) a0) (distance p0 p1))
	  p2 (polar p1 a0 (car dp))
	  lt (list p1
		   p2
		   (polar p2 (+ a0 _pi2) (cadr dp))
		   (polar p1 (+ a0 _pi2) (cadr dp))
		   p1
	     )
	  lt (vr_offset lt (list (* 0.25 (cadr dp))))
    )
  )
)
(defun #wdedge (e1 / wid edata cp ang a1 a2 lt info)
  (setq edata (entget e1))
  (cond	((setq wid (xdout e1 "wthick"))
	 (setq wid (mapcar '(lambda (x) (* 0.5 x)) wid)
	       cp  (cdr (assoc 10 edata))
	       ang (cdr (assoc 50 edata))
	       a1  (cdr (assoc 41 edata))
	       a2  (cdr (assoc 42 edata))
	       lt  (xdout e1 "wpline")
	       a2  (if (< a2 100)
		     (abs a2)
		     a2
		   )
	 )
	 (if lt
	   (setq info (rtow cp ang a1 a2 lt))
	   (setq info (list (polar cp ang (* 0.5 a1))
			    (polar cp ang (* -0.5 a1))
		      )
	   )
	 )
	 (list (vr_offset info wid)
	       (vr_offset info (mapcar '(lambda (x) (- x)) wid))
	 )
	)
	((= (cdr (assoc 8 edata)) (glayer "Ŵ"))
	 (setq wid  (* 0.5 (cdr (assoc 41 edata)))
	       cp   (cdr (assoc 10 edata))
	       ang  (+ (cdr (assoc 50 edata)) _pi2)
	       a2   (cdr (assoc 42 edata))
	       info (list cp (polar cp ang a2))
	 )
	 (list (vr_offset info (list wid))
	       (vr_offset info (list (- wid)))
	 )
	)
  )
)
(defun clmn_edge (e1 / cp r p1 p2 lt a rx ry wzq)
  (setq edata (entget e1))
  (if (and (wcmatch (cdr (assoc 8 edata)) (glayer "*"))
	   (setq wzq (cdr (assoc 2 edata)))
      )
    (cond ((or (= wzq "_YZH") (= wzq "_3DYZ"))
	   (setq cp (cdr (assoc 10 edata))
		 r  (* 0.5 (cdr (assoc 41 edata)))
		 p1 (polar cp 0 r)
		 p2 (polar cp pi r)
		 lt (list p1 1.0 p2 1.0 p1)
	   )
	  )
	  (T
	   (setq cp (cdr (assoc 10 edata))
		 a  (cdr (assoc 50 edata))
		 rx (cdr (assoc 41 edata))
		 ry (cdr (assoc 42 edata))
		 lt '((0.5 0.5 0)
		      (-0.5 0.5 0)
		      (-0.5 -0.5 0)
		      (0.5 -0.5 0)
		      (0.5 0.5 0)
		     )
	   )
	   (vr_setscl (list rx ry 1.0) '(0 0 1) a cp)
	   (mapcar 'vr_sclp lt)
	  )
    )
  )
)
(defun _2dseg1 (e1 z / edata ecs lt1)
  (setq	edata (entget e1)
	ecs   (cdr (assoc 210 edata))
  )

  (if (or (not ecs) (equal ecs (trans '(0 0 1) 1 0 T) 1e-4))
    (progn
      (princ "\n Begin in _2dseg1!")
      (setq rjaa e1)
      (if (setq lt1 (vr_poly e1))
	(progn
	  (if (not z)
	    (setq z (caddar lt1))
	  )
	  (setq	lt1 (mapcar '(lambda (x)
			       (if (numberp x)
				 x
				 (setq x (trans x e1 1)
				       x (list (car x) (cadr x) z)
				 )
			       )
			     )
			    lt1
		    )
	  )
	)
      )
    )
  )
  (princ "\n End in _2dseg1!")
)
(defun _blksegs	(e0 / edata nm x y z ecs lt1 lt)
  (setq	edata (entget e0)
	nm    (cdr (assoc 0 edata))
  )
  (princ "\n End in _blksegs!")
  (if (= nm "INSERT")
    (progn
      (setq x (cdr (assoc 41 edata))
	    y (cdr (assoc 42 edata))
	    z (cdr (assoc 43 edata))
      )
      (vr_setscl (list x y z)
		 (cdr (assoc 210 edata))
		 (cdr (assoc 50 edata))
		 (trans (cdr (assoc 10 edata)) e0 0)
      )
      (setq
	e0 (cdr (assoc -2 (tblsearch "BLOCK" (cdr (assoc 2 edata)))))
      )
      (while e0
	(setq edata (entget e0)
	      ecs   (cdr (assoc 210 edata))
	)
	(if (and (or (not ecs)
		     (equal ecs '(0 0 1) 1e-4)
		     (equal ecs '(0 0 -1) 1e-4)
		 )
		 (setq lt1 (vr_poly e0))
	    )
	  (progn (if (not (equal x y 1e-4))
		   (setq lt1 (vr_mesh lt1))
		 )
		 (setq lt1 (mapcar '(lambda (x)
				      (if (numberp x)
					x
					(trans (vr_sclp (trans x ecs 0)) 0 1)
				      )
				    )
				   lt1
			   )
		       lt  (cons lt1 lt)
		 )
	  )
	)
	(setq e0 (entnext e0))
      )
      lt
    )
  )
)
(defun _autobd (lt_bd / first p0 lt1 lt i dd d_min i_min wzq)
  (setq lt_bd (vr_bpoly lt_bd))
  (while lt_bd
    (initget "A")
    (setq
      p0 (getpoint "\nȡ߽߰Χڲ/ A-ʾȫ/ <˳>: "
	 )
    )
    (cond
      ((= p0 "A") (foreach x lt_bd (vr_drpl x 0 4)))
      (p0
       (setq lt1 nil
	     i 0
	     i_min nil
       )
       (foreach	lt lt_bd
	 (setq dd (car (vr_ptopl p0 lt)))
	 (if (and dd (< dd 0) (or (not i_min) (> dd d_min)))
	   (setq d_min dd
		 i_min i
	   )
	 )
	 (setq i (1+ i))
       )
       (if i_min
	 (progn
	   (setq lt (nth i_min lt_bd))
	   (vr_drpl lt 0)
	   (if (setq wzq (getpoint "\nȡһ㻭˱߽ <>: "))
	     (progn (vr_drpl lt 0) (vr_drpl lt))
	     (vr_drpl lt 0)
	   )
	 )
	 (princ "\n* ޷ѵ߽.")
       )
      )
      (T (setq lt_bd nil))
    )
  )
)
(defun c:autopl	(/ filt ss e1 i lt_bd tf_whole wzq)
  (begin "ʱ")
  (princ "\nѡΧ <˳>: ")
  (setq	filt '((-4 . "<or")
	       (0 . "LINE,ARC,CIRCLE,LWPOLYLINE,INSERT,TEXT")
	       (-4 . "<and")
	       (0 . "POLYLINE")
	       (-4 . "<")
	       (70 . 16)
	       (-4 . "and>")
	       (-4 . "or>")
	      )
  )
  (if (setq ss (ssget filt))
    (progn
      (if (ssget "p" (list (cons 8 (glayer "Ŵ,"))))
	(progn (initget "Yes No")
	       (setq
		 wzq (getkword
		       "\nǷŴӵʵ(Yes/No)? <Yes>: "
		     )
	       )
	       (setq tf_whole (/= wzq "No"))
	)
      )
      (setq i 0)
      (while (setq e1 (ssname ss i))
	(setq i (1+ i))
	(cond ((setq wzq (_2dseg1 e1 0)) (setq lt_bd (cons wzq lt_bd)))
	      ((and tf_whole (setq wzq (#wdedge e1)))
	       (setq wzq   (append (car wzq)
				   (_revpl (cadr wzq))
				   (list (caar wzq))
			   )
		     lt_bd (cons wzq lt_bd)
	       )
	      )
	      ((and tf_whole (setq wzq (clmn_edge e1)))
	       (setq lt_bd (cons wzq lt_bd))
	      )
	      ((setq wzq (_blksegs e1)) (setq lt_bd (append wzq lt_bd)))
	      ((setq wzq (text_edge e1)) (setq lt_bd (cons wzq lt_bd)))
	)
      )
      (_autobd lt_bd)
    )
  )
  (end)
)
(defun c:autowl	(/ segs_ins ss e1 i lt_bd tf_whole wzq)
  (begin "ʱ")
  (setq	segs_ins '((-4 . "<or")
		   (0 . "LINE,ARC,CIRCLE,LWPOLYLINE,INSERT")
		   (-4 . "<and")
		   (0 . "POLYLINE")
		   (-4 . "<")
		   (70 . 16)
		   (-4 . "and>")
		   (-4 . "or>")
		  )
  )
  (princ "\nѡΧ <˳>: ")
  (if (setq ss (ssget
		 (cons (cons 8 (glayer "ǽ,Ŵ,,̨")) segs_ins)
	       )
      )
    (progn
      (setq i 0)
      (while (setq e1 (ssname ss i))
	(setq i (1+ i))
	(cond ((setq wzq (vr_poly e1)) (setq lt_bd (cons wzq lt_bd)))
	      ((setq wzq (#wdedge e1))
	       (setq wzq   (append (car wzq)
				   (_revpl (cadr wzq))
				   (list (caar wzq))
			   )
		     lt_bd (cons wzq lt_bd)
	       )
	      )
	      ((setq wzq (clmn_edge e1)) (setq lt_bd (cons wzq lt_bd)))
	)
      )
      (_autobd lt_bd)
    )
  )
  (end)
)
(defun c:erautol (/ ss)
  (princ "\nѡȡҪı <˳>: ")
  (if (setq ss (ssget (list (cons 8 (glayer "ʱ")))))
    (command ".erase" ss "")
  )
)