Win32 App
OpenGLApp
Simple Template for creating OpenGL application
-
Ev!l0iD, 2oo2
e-mail: eviloid@mail.ru
web: http://eviloid.hut.ru
[*BEGINPRO*]
[*BEGINTXT*]
OpenGLApp.Asm
; =========================
; Simple OpenGL Application
; =========================

Include OpenGLApp.Inc

; Implementation ========================================
.Code

; entry point
Start:

  invoke GetModuleHandle, NULL
  mov hInstance, eax

  invoke GetCommandLine
  mov CommandLine, eax

  invoke WinMain, hInstance, NULL, CommandLine, SW_SHOWDEFAULT
  invoke ExitProcess, eax

;========================================================
WinMain Proc hInst:HINSTANCE, hPrevInst:HINSTANCE, CmdLine:LPSTR, CmdShow:DWORD
;{
  LOCAL wc:WNDCLASSEX
  LOCAL msg:MSG
  LOCAL hwnd:HWND
  LOCAL bQuit:BOOL

  mov bQuit, FALSE

  mov wc.cbSize, sizeof WNDCLASSEX
  mov wc.style, CS_OWNDC
  mov wc.lpfnWndProc, offset WndProc
  mov wc.cbClsExtra, NULL
  mov wc.cbWndExtra, NULL
  m2m wc.hInstance, hInstance

  invoke GetStockObject, BLACK_BRUSH
  mov wc.hbrBackground, eax

  mov wc.lpszMenuName, NULL
  mov wc.lpszClassName, offset ClassName

  invoke LoadIcon, hInstance, IDC_ICON1
  mov wc.hIcon, eax
  mov wc.hIconSm, eax

  invoke LoadCursor,NULL,IDC_ARROW
  mov wc.hCursor,eax

  invoke RegisterClassEx, addr wc
  invoke CreateWindowEx,NULL, addr ClassName, addr AppName,
                        WS_OVERLAPPEDWINDOW,
                        CW_USEDEFAULT, CW_USEDEFAULT,
                        256, 256, NULL, NULL,
                        hInst, NULL
  mov hwnd,eax

  invoke ShowWindow, eax, SW_SHOWNORMAL
  invoke UpdateWindow, hwnd
  invoke EnableOpenGL, hwnd

  .while !( bQuit )
  ;{
;    invoke GetMessage, addr msg, NULL, 0, 0
    invoke PeekMessage, addr msg, NULL, 0, 0, PM_REMOVE
; handle or dispatch messages
    .if ( eax )
    ;{
      .if ( msg.message == WM_QUIT )
      ;{
        mov bQuit, TRUE
      ;}
      .else
      ;{
        invoke TranslateMessage, addr msg
        invoke DispatchMessage, addr msg
      ;}
      .endif
     ;}
     .else
     ;{

; ...OpenGL animation code goes here...

     ;}
     .endif
  ;}
  .endw

  invoke DisableOpenGL, hwnd

;  mov eax,msg.wParam
;  ret
  return msg.wParam
;}
WinMain EndP

;========================================================
WndProc Proc hWnd:HWND, uMsg:UINT, wParam:WPARAM, lParam:LPARAM
;{
  LOCAL Rect:RECT

  .if ( uMsg == WM_DESTROY )
  ;{
  GetOutaHere:
    invoke PostQuitMessage, NULL
  ;}
  .elseif ( uMsg == WM_CREATE )
  ;{

  ;}
  .elseif ( uMsg == WM_SIZE )
  ;{
    invoke  GetClientRect, hWnd, addr Rect
    invoke  glViewport, 0, 0, Rect.right, Rect.bottom
  ;}
  .elseif ( uMsg == WM_KEYDOWN )
  ;{
    .if ( wParam == VK_ESCAPE)
    ;{
      jmp GetOutaHere
    ;}
    .endif
  ;}
  .else
  ;{
    invoke DefWindowProc, hWnd, uMsg, wParam, lParam
    ret
  ;}
  .endif

;  xor eax,eax
;  ret
  return 0
;}
WndProc EndP

;========================================================
EnableOpenGL Proc hWnd:HWND
;{
  LOCAL iFormat:dword
  LOCAL pfd:PIXELFORMATDESCRIPTOR

;  get the device context (DC)
  invoke GetDC, hWnd
  mov hDC, eax

;  set the pixel format for the DC
  lea edi, pfd
  xor eax, eax
  mov ecx, sizeof pfd / sizeof DWORD
  rep stosd                   ; zero pfd structure

  mov pfd.nSize, sizeof pfd
  mov pfd.nVersion, 1
  mov pfd.dwFlags, PFD_DRAW_TO_WINDOW or PFD_SUPPORT_OPENGL or PFD_DOUBLEBUFFER
  mov pfd.iPixelType, PFD_TYPE_RGBA
  mov pfd.cColorBits, 24
  mov pfd.cDepthBits, 16
  mov pfd.iLayerType, PFD_MAIN_PLANE
  invoke ChoosePixelFormat, hDC, addr pfd
  mov iFormat, eax
  invoke SetPixelFormat, hDC, iFormat, addr pfd

;  create and enable the render context (RC)
  invoke wglCreateContext, hDC
  mov hRC, eax
  invoke wglMakeCurrent, hDC, hRC
  ret
;}
EnableOpenGL EndP

;========================================================
DisableOpenGL Proc hWnd:HWND
;{
  invoke wglMakeCurrent, NULL, NULL
  invoke wglDeleteContext, hRC
  invoke ReleaseDC, hWnd, hDC
  ret
;}
DisableOpenGL EndP

;========================================================
End Start
[*ENDTXT*]
[*BEGINTXT*]
OpenGLApp.Inc
.586
.Model Flat,StdCall   ; 32 bit memory model
Option Scoped         ; local labels are enabled, global labels inside
                      ; PROC should be defined with double colons (LABEL::)
Option CaseMap:None   ; case sensitive

Include windows.inc
Include user32.inc
Include kernel32.inc
Include gdi32.inc

Include OpenGL\gl.def  ; (C) hardCode 1999-2000
Include OpenGL\glu.def ; http://bizarrecreations.webjump.com

IncludeLib user32.lib
IncludeLib kernel32.lib
IncludeLib opengl32.lib
IncludeLib glu32.lib
IncludeLib gdi32.lib

; PROTOS ================================================
WinMain Proto :DWORD,:DWORD,:DWORD,:DWORD
WndProc Proto :DWORD,:DWORD,:DWORD,:DWORD
EnableOpenGL Proto :DWORD
DisableOpenGL Proto :DWORD

; Read-only data ========================================
.Const

ClassName db "OGLMainWinClass", 0
AppName db "OpenGL App", 0

IDC_ICON1 equ 500

; Initialized data ======================================
.Data

; Non-initialized data ==================================
.Data?

hInstance HINSTANCE ?
CommandLine LPSTR ?
hDC HDC ?
hRC HGLRC ?
[*ENDTXT*]
[*BEGINTXT*]
OpenGLApp.Rc
#define IDC_ICON1 500
IDC_ICON1 ICON DISCARDABLE Res\ogl.ico
[*ENDTXT*]
[*ENDPRO*]
[*BEGINBIN*]
Res\ogl.ico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[*ENDBIN*]
