/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize.evaluation;

import proguard.classfile.Clazz;
import proguard.classfile.Member;
import proguard.classfile.Method;
import proguard.classfile.ProgramMethod;
import proguard.classfile.attribute.Attribute;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.constant.ClassConstant;
import proguard.classfile.constant.Constant;
import proguard.classfile.constant.StringConstant;
import proguard.classfile.constant.visitor.ConstantVisitor;
import proguard.classfile.editor.CodeAttributeEditor;
import proguard.classfile.instruction.BranchInstruction;
import proguard.classfile.instruction.ConstantInstruction;
import proguard.classfile.instruction.Instruction;
import proguard.classfile.instruction.InstructionFactory;
import proguard.classfile.instruction.SimpleInstruction;
import proguard.classfile.instruction.SwitchInstruction;
import proguard.classfile.instruction.VariableInstruction;
import proguard.classfile.instruction.visitor.InstructionVisitor;
import proguard.classfile.util.AllParameterVisitor;
import proguard.classfile.util.ClassUtil;
import proguard.classfile.util.DescriptorClassEnumeration;
import proguard.classfile.util.SimplifiedVisitor;
import proguard.classfile.visitor.ParameterVisitor;
import proguard.classfile.visitor.ReferencedMemberVisitor;
import proguard.evaluation.value.InstructionOffsetValue;
import proguard.evaluation.value.ReferenceValue;
import proguard.optimize.evaluation.PartialEvaluator;
import proguard.optimize.info.SimpleEnumMarker;

public class SimpleEnumUseSimplifier
extends SimplifiedVisitor
implements AttributeVisitor,
InstructionVisitor,
ConstantVisitor,
ParameterVisitor {
    private static final boolean DEBUG = false;
    private final InstructionVisitor extraInstructionVisitor;
    private final PartialEvaluator partialEvaluator;
    private final CodeAttributeEditor codeAttributeEditor = new CodeAttributeEditor(true, true);
    private final ConstantVisitor nullParameterFixer = new ReferencedMemberVisitor(new AllParameterVisitor(this));
    private Clazz invocationClazz;
    private Method invocationMethod;
    private CodeAttribute invocationCodeAttribute;
    private int invocationOffset;
    private boolean isSimpleEnum;

    public SimpleEnumUseSimplifier() {
        this(new PartialEvaluator(), null);
    }

    public SimpleEnumUseSimplifier(PartialEvaluator partialEvaluator, InstructionVisitor instructionVisitor) {
        this.partialEvaluator = partialEvaluator;
        this.extraInstructionVisitor = instructionVisitor;
    }

    @Override
    public void visitAnyAttribute(Clazz clazz, Attribute attribute) {
    }

    @Override
    public void visitCodeAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute) {
        if (SimpleEnumMarker.isSimpleEnum(clazz) && (method.getAccessFlags() & 8) == 0) {
            return;
        }
        this.partialEvaluator.visitCodeAttribute(clazz, method, codeAttribute);
        int n = codeAttribute.u4codeLength;
        this.codeAttributeEditor.reset(n);
        for (int i = 0; i < n; ++i) {
            if (!this.partialEvaluator.isTraced(i)) continue;
            Instruction instruction = InstructionFactory.create(codeAttribute.code, i);
            instruction.accept(clazz, method, codeAttribute, i, this);
        }
        this.codeAttributeEditor.visitCodeAttribute(clazz, method, codeAttribute);
    }

    @Override
    public void visitSimpleInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, SimpleInstruction simpleInstruction) {
        switch (simpleInstruction.opcode) {
            case 50: {
                if (!this.isPushingSimpleEnum(n)) break;
                this.replaceInstruction(clazz, n, simpleInstruction, new SimpleInstruction(46));
                break;
            }
            case 83: {
                if (!this.isPoppingSimpleEnumArray(n, 2)) break;
                this.replaceInstruction(clazz, n, simpleInstruction, new SimpleInstruction(79));
                this.replaceNullStackEntryProducers(clazz, method, codeAttribute, n);
                break;
            }
            case -80: {
                if (!this.isReturningSimpleEnum(clazz, method)) break;
                this.replaceInstruction(clazz, n, simpleInstruction, new SimpleInstruction(-84));
                this.replaceNullStackEntryProducers(clazz, method, codeAttribute, n);
            }
        }
    }

    @Override
    public void visitVariableInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, VariableInstruction variableInstruction) {
        int n2 = variableInstruction.variableIndex;
        switch (variableInstruction.opcode) {
            case 25: 
            case 42: 
            case 43: 
            case 44: 
            case 45: {
                if (!this.isPushingSimpleEnum(n)) break;
                this.replaceInstruction(clazz, n, variableInstruction, new VariableInstruction(21, n2));
                this.replaceNullVariableProducers(clazz, method, codeAttribute, n, n2);
                break;
            }
            case 58: 
            case 75: 
            case 76: 
            case 77: 
            case 78: {
                if (this.partialEvaluator.isSubroutineStart(n) || !this.isPoppingSimpleEnum(n)) break;
                this.replaceInstruction(clazz, n, variableInstruction, new VariableInstruction(54, n2));
                this.replaceNullStackEntryProducers(clazz, method, codeAttribute, n);
            }
        }
    }

    @Override
    public void visitConstantInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, ConstantInstruction constantInstruction) {
        switch (constantInstruction.opcode) {
            case -77: 
            case -75: {
                this.invocationClazz = clazz;
                this.invocationMethod = method;
                this.invocationCodeAttribute = codeAttribute;
                this.invocationOffset = n;
                clazz.constantPoolEntryAccept(constantInstruction.constantIndex, this.nullParameterFixer);
                break;
            }
            case -74: {
                String string = clazz.getRefName(constantInstruction.constantIndex);
                String string2 = clazz.getRefType(constantInstruction.constantIndex);
                int n2 = ClassUtil.internalMethodParameterSize(string2);
                if (this.isPoppingSimpleEnum(n, n2)) {
                    this.replaceSupportedMethod(clazz, n, constantInstruction, string, string2);
                }
            }
            case -73: 
            case -72: 
            case -71: {
                this.invocationClazz = clazz;
                this.invocationMethod = method;
                this.invocationCodeAttribute = codeAttribute;
                this.invocationOffset = n;
                clazz.constantPoolEntryAccept(constantInstruction.constantIndex, this.nullParameterFixer);
                break;
            }
            case -67: {
                int n3 = constantInstruction.constantIndex;
                if (!this.isReferencingSimpleEnum(clazz, n3) || ClassUtil.isInternalArrayType(clazz.getClassName(n3))) break;
                this.replaceInstruction(clazz, n, constantInstruction, new SimpleInstruction(-68, 10));
                break;
            }
            case -64: {
                if (!this.isPoppingSimpleEnum(n)) break;
                this.deleteInstruction(clazz, n, constantInstruction);
                this.replaceNullStackEntryProducers(clazz, method, codeAttribute, n);
                break;
            }
            case -63: {
                if (!this.isPoppingSimpleEnum(n)) break;
                this.replaceInstruction(clazz, n, constantInstruction, new SimpleInstruction(4));
                this.replaceNullStackEntryProducers(clazz, method, codeAttribute, n);
            }
        }
    }

    @Override
    public void visitBranchInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, BranchInstruction branchInstruction) {
        switch (branchInstruction.opcode) {
            case -91: {
                if (!this.isPoppingSimpleEnum(n)) break;
                this.replaceInstruction(clazz, n, branchInstruction, new BranchInstruction(-97, branchInstruction.branchOffset));
                break;
            }
            case -90: {
                if (!this.isPoppingSimpleEnum(n)) break;
                this.replaceInstruction(clazz, n, branchInstruction, new BranchInstruction(-96, branchInstruction.branchOffset));
                break;
            }
            case -58: {
                if (!this.isPoppingSimpleEnum(n)) break;
                this.replaceInstruction(clazz, n, branchInstruction, new BranchInstruction(-103, branchInstruction.branchOffset));
                break;
            }
            case -57: {
                if (!this.isPoppingSimpleEnum(n)) break;
                this.replaceInstruction(clazz, n, branchInstruction, new BranchInstruction(-102, branchInstruction.branchOffset));
            }
        }
    }

    @Override
    public void visitAnySwitchInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, SwitchInstruction switchInstruction) {
    }

    @Override
    public void visitAnyConstant(Clazz clazz, Constant constant) {
    }

    @Override
    public void visitStringConstant(Clazz clazz, StringConstant stringConstant) {
        this.isSimpleEnum = this.isSimpleEnum(stringConstant.referencedClass);
    }

    @Override
    public void visitClassConstant(Clazz clazz, ClassConstant classConstant) {
        this.isSimpleEnum = this.isSimpleEnum(classConstant.referencedClass);
    }

    @Override
    public void visitParameter(Clazz clazz, Member member, int n, int n2, int n3, int n4, String string, Clazz clazz2) {
        if (!ClassUtil.isInternalPrimitiveType(string.charAt(0)) && this.isSimpleEnum(clazz2)) {
            int n5 = n4 - n3 - 1;
            this.replaceNullStackEntryProducers(this.invocationClazz, this.invocationMethod, this.invocationCodeAttribute, this.invocationOffset, n5);
        }
    }

    private boolean isReferencingSimpleEnum(Clazz clazz, int n) {
        this.isSimpleEnum = false;
        clazz.constantPoolEntryAccept(n, this);
        return this.isSimpleEnum;
    }

    private boolean isReturningSimpleEnum(Clazz clazz, Method method) {
        Clazz[] clazzArray;
        String string = method.getDescriptor(clazz);
        String string2 = ClassUtil.internalMethodReturnType(string);
        if (ClassUtil.isInternalClassType(string2) && !ClassUtil.isInternalArrayType(string2) && (clazzArray = ((ProgramMethod)method).referencedClasses) != null) {
            int n = new DescriptorClassEnumeration(string).classCount() - 1;
            Clazz clazz2 = clazzArray[n];
            return this.isSimpleEnum(clazz2);
        }
        return false;
    }

    private boolean isPushingSimpleEnum(int n) {
        ReferenceValue referenceValue = this.partialEvaluator.getStackAfter(n).getTop(0).referenceValue();
        Clazz clazz = referenceValue.getReferencedClass();
        return this.isSimpleEnum(clazz) && !ClassUtil.isInternalArrayType(referenceValue.getType());
    }

    private boolean isPoppingSimpleEnum(int n) {
        return this.isPoppingSimpleEnum(n, 0);
    }

    private boolean isPoppingSimpleEnum(int n, int n2) {
        ReferenceValue referenceValue = this.partialEvaluator.getStackBefore(n).getTop(n2).referenceValue();
        return this.isSimpleEnum(referenceValue.getReferencedClass()) && !ClassUtil.isInternalArrayType(referenceValue.getType());
    }

    private boolean isPoppingSimpleEnumType(int n, int n2) {
        ReferenceValue referenceValue = this.partialEvaluator.getStackBefore(n).getTop(n2).referenceValue();
        return this.isSimpleEnum(referenceValue.getReferencedClass());
    }

    private boolean isPoppingSimpleEnumArray(int n, int n2) {
        ReferenceValue referenceValue = this.partialEvaluator.getStackBefore(n).getTop(n2).referenceValue();
        return this.isSimpleEnum(referenceValue.getReferencedClass()) && ClassUtil.internalArrayTypeDimensionCount(referenceValue.getType()) == 1;
    }

    private boolean isSimpleEnum(Clazz clazz) {
        return clazz != null && SimpleEnumMarker.isSimpleEnum(clazz);
    }

    private void replaceSupportedMethod(Clazz clazz, int n, Instruction instruction, String string, String string2) {
        if (string.equals("ordinal") && string2.equals("()I")) {
            Instruction[] instructionArray = new Instruction[]{new SimpleInstruction(4), new SimpleInstruction(100)};
            this.replaceInstructions(clazz, n, instruction, instructionArray);
        }
    }

    private void replaceInstructions(Clazz clazz, int n, Instruction instruction, Instruction[] instructionArray) {
        this.codeAttributeEditor.replaceInstruction(n, instructionArray);
        if (this.extraInstructionVisitor != null) {
            instruction.accept(clazz, null, null, n, this.extraInstructionVisitor);
        }
    }

    private void replaceInstruction(Clazz clazz, int n, Instruction instruction, Instruction instruction2) {
        int n2 = instruction.stackPopCount(clazz) - instruction2.stackPopCount(clazz);
        this.insertPopInstructions(n, n2);
        this.codeAttributeEditor.replaceInstruction(n, instruction2);
        if (this.extraInstructionVisitor != null) {
            instruction.accept(clazz, null, null, n, this.extraInstructionVisitor);
        }
    }

    private void deleteInstruction(Clazz clazz, int n, Instruction instruction) {
        this.codeAttributeEditor.deleteInstruction(n);
        if (this.extraInstructionVisitor != null) {
            instruction.accept(clazz, null, null, n, this.extraInstructionVisitor);
        }
    }

    private void insertPopInstructions(int n, int n2) {
        switch (n2) {
            case 0: {
                break;
            }
            case 1: {
                SimpleInstruction simpleInstruction = new SimpleInstruction(87);
                this.codeAttributeEditor.insertBeforeInstruction(n, simpleInstruction);
                break;
            }
            case 2: {
                SimpleInstruction simpleInstruction = new SimpleInstruction(88);
                this.codeAttributeEditor.insertBeforeInstruction(n, simpleInstruction);
                break;
            }
            default: {
                Instruction[] instructionArray = new Instruction[n2 / 2 + n2 % 2];
                SimpleInstruction simpleInstruction = new SimpleInstruction(88);
                for (int i = 0; i < n2 / 2; ++i) {
                    instructionArray[i] = simpleInstruction;
                }
                if (n2 % 2 == 1) {
                    simpleInstruction = new SimpleInstruction(87);
                    instructionArray[n2 / 2] = simpleInstruction;
                }
                this.codeAttributeEditor.insertBeforeInstruction(n, instructionArray);
                break;
            }
        }
    }

    private void replaceNullStackEntryProducers(Clazz clazz, Method method, CodeAttribute codeAttribute, int n) {
        this.replaceNullStackEntryProducers(clazz, method, codeAttribute, n, 0);
    }

    private void replaceNullStackEntryProducers(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, int n2) {
        InstructionOffsetValue instructionOffsetValue = this.partialEvaluator.getStackBefore(n).getTopActualProducerValue(n2).instructionOffsetValue();
        for (int i = 0; i < instructionOffsetValue.instructionOffsetCount(); ++i) {
            int n3 = instructionOffsetValue.instructionOffset(i);
            if (n3 < 0 || codeAttribute.code[n3] != 1) continue;
            this.replaceInstruction(clazz, n3, new SimpleInstruction(1), new SimpleInstruction(3));
        }
    }

    private void replaceNullVariableProducers(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, int n2) {
        InstructionOffsetValue instructionOffsetValue = this.partialEvaluator.getVariablesBefore(n).getProducerValue(n2).instructionOffsetValue();
        for (int i = 0; i < instructionOffsetValue.instructionOffsetCount(); ++i) {
            int n3 = instructionOffsetValue.instructionOffset(i);
            if (n3 < 0 || this.partialEvaluator.getVariablesAfter(n3).getValue(n2).referenceValue().isNull() != 1) continue;
            this.replaceInstruction(clazz, n3, new VariableInstruction(58, n2), new VariableInstruction(54, n2));
            this.replaceNullStackEntryProducers(clazz, method, codeAttribute, n3);
        }
    }
}

