/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize.evaluation;

import proguard.classfile.Clazz;
import proguard.classfile.Field;
import proguard.classfile.Method;
import proguard.classfile.ProgramClass;
import proguard.classfile.ProgramField;
import proguard.classfile.ProgramMethod;
import proguard.classfile.attribute.Attribute;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.attribute.LocalVariableInfo;
import proguard.classfile.attribute.LocalVariableTableAttribute;
import proguard.classfile.attribute.LocalVariableTypeInfo;
import proguard.classfile.attribute.LocalVariableTypeTableAttribute;
import proguard.classfile.attribute.SignatureAttribute;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.attribute.visitor.LocalVariableInfoVisitor;
import proguard.classfile.attribute.visitor.LocalVariableTypeInfoVisitor;
import proguard.classfile.constant.ClassConstant;
import proguard.classfile.constant.Constant;
import proguard.classfile.constant.InvokeDynamicConstant;
import proguard.classfile.constant.StringConstant;
import proguard.classfile.constant.visitor.ConstantVisitor;
import proguard.classfile.editor.ConstantPoolEditor;
import proguard.classfile.util.ClassUtil;
import proguard.classfile.util.DescriptorClassEnumeration;
import proguard.classfile.util.InternalTypeEnumeration;
import proguard.classfile.util.SimplifiedVisitor;
import proguard.classfile.visitor.ClassVisitor;
import proguard.classfile.visitor.MemberVisitor;
import proguard.optimize.info.FieldOptimizationInfo;
import proguard.optimize.info.SimpleEnumMarker;

public class SimpleEnumDescriptorSimplifier
extends SimplifiedVisitor
implements ClassVisitor,
ConstantVisitor,
MemberVisitor,
AttributeVisitor,
LocalVariableInfoVisitor,
LocalVariableTypeInfoVisitor {
    private static final boolean DEBUG = false;

    @Override
    public void visitProgramClass(ProgramClass programClass) {
        programClass.fieldsAccept(this);
        programClass.methodsAccept(this);
        programClass.constantPoolEntriesAccept(this);
    }

    @Override
    public void visitAnyConstant(Clazz clazz, Constant constant) {
    }

    @Override
    public void visitStringConstant(Clazz clazz, StringConstant stringConstant) {
        String string;
        Clazz clazz2 = stringConstant.referencedClass;
        if (this.isSimpleEnum(clazz2) && ClassUtil.isInternalArrayType(string = stringConstant.getString(clazz))) {
            ConstantPoolEditor constantPoolEditor = new ConstantPoolEditor((ProgramClass)clazz);
            String string2 = this.simplifyDescriptor(string, clazz2);
            stringConstant.u2stringIndex = constantPoolEditor.addUtf8Constant(string2);
            stringConstant.referencedClass = null;
        }
    }

    @Override
    public void visitInvokeDynamicConstant(Clazz clazz, InvokeDynamicConstant invokeDynamicConstant) {
        String string;
        String string2 = invokeDynamicConstant.getType(clazz);
        if (!string2.equals(string = this.simplifyDescriptor(string2, invokeDynamicConstant.referencedClasses))) {
            ConstantPoolEditor constantPoolEditor = new ConstantPoolEditor((ProgramClass)clazz);
            invokeDynamicConstant.u2nameAndTypeIndex = constantPoolEditor.addNameAndTypeConstant(invokeDynamicConstant.getName(clazz), string);
            invokeDynamicConstant.referencedClasses = this.simplifyReferencedClasses(string2, invokeDynamicConstant.referencedClasses);
        }
    }

    @Override
    public void visitClassConstant(Clazz clazz, ClassConstant classConstant) {
        String string;
        Clazz clazz2 = classConstant.referencedClass;
        if (this.isSimpleEnum(clazz2) && ClassUtil.isInternalArrayType(string = classConstant.getName(clazz))) {
            ConstantPoolEditor constantPoolEditor = new ConstantPoolEditor((ProgramClass)clazz);
            String string2 = this.simplifyDescriptor(string, clazz2);
            classConstant.u2nameIndex = constantPoolEditor.addUtf8Constant(string2);
            classConstant.referencedClass = null;
        }
    }

    @Override
    public void visitProgramField(ProgramClass programClass, ProgramField programField) {
        String string;
        String string2 = programField.getDescriptor(programClass);
        if (!string2.equals(string = this.simplifyDescriptor(string2, programField.referencedClass))) {
            String string3 = programField.getName(programClass);
            String string4 = string3 + '$' + Long.toHexString(Math.abs(string2.hashCode()));
            ConstantPoolEditor constantPoolEditor = new ConstantPoolEditor(programClass);
            programField.u2nameIndex = constantPoolEditor.addUtf8Constant(string4);
            programField.u2descriptorIndex = constantPoolEditor.addUtf8Constant(string);
            programField.referencedClass = null;
            FieldOptimizationInfo fieldOptimizationInfo = FieldOptimizationInfo.getFieldOptimizationInfo(programField);
            if (fieldOptimizationInfo != null) {
                fieldOptimizationInfo.resetValue(programClass, programField);
            }
            programField.attributesAccept(programClass, this);
        }
    }

    @Override
    public void visitProgramMethod(ProgramClass programClass, ProgramMethod programMethod) {
        programMethod.attributesAccept(programClass, this);
        String string = programMethod.getDescriptor(programClass);
        String string2 = this.simplifyDescriptor(string, programMethod.referencedClasses);
        if (!string.equals(string2)) {
            String string3;
            String string4 = string3 = programMethod.getName(programClass);
            if (!string3.equals("<init>")) {
                string4 = string4 + '$' + Long.toHexString(Math.abs(string.hashCode()));
            }
            ConstantPoolEditor constantPoolEditor = new ConstantPoolEditor(programClass);
            if (!string4.equals(string3)) {
                programMethod.u2nameIndex = constantPoolEditor.addUtf8Constant(string4);
            }
            programMethod.u2descriptorIndex = constantPoolEditor.addUtf8Constant(string2);
            programMethod.referencedClasses = this.simplifyReferencedClasses(string, programMethod.referencedClasses);
        }
    }

    @Override
    public void visitAnyAttribute(Clazz clazz, Attribute attribute) {
    }

    @Override
    public void visitCodeAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute) {
        codeAttribute.attributesAccept(clazz, method, this);
    }

    @Override
    public void visitLocalVariableTableAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute, LocalVariableTableAttribute localVariableTableAttribute) {
        localVariableTableAttribute.localVariablesAccept(clazz, method, codeAttribute, this);
    }

    @Override
    public void visitLocalVariableTypeTableAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute, LocalVariableTypeTableAttribute localVariableTypeTableAttribute) {
        localVariableTypeTableAttribute.localVariablesAccept(clazz, method, codeAttribute, this);
    }

    @Override
    public void visitSignatureAttribute(Clazz clazz, Field field, SignatureAttribute signatureAttribute) {
        String string;
        String string2;
        if (signatureAttribute.referencedClasses != null && signatureAttribute.referencedClasses.length > 0 && !(string2 = signatureAttribute.getSignature(clazz)).equals(string = this.simplifyDescriptor(string2, signatureAttribute.referencedClasses[0]))) {
            signatureAttribute.u2signatureIndex = new ConstantPoolEditor((ProgramClass)clazz).addUtf8Constant(string);
            signatureAttribute.referencedClasses[0] = null;
        }
    }

    @Override
    public void visitSignatureAttribute(Clazz clazz, Method method, SignatureAttribute signatureAttribute) {
        String string;
        String string2 = signatureAttribute.getSignature(clazz);
        if (!string2.equals(string = this.simplifyDescriptor(string2, signatureAttribute.referencedClasses))) {
            signatureAttribute.u2signatureIndex = new ConstantPoolEditor((ProgramClass)clazz).addUtf8Constant(string);
        }
    }

    @Override
    public void visitLocalVariableInfo(Clazz clazz, Method method, CodeAttribute codeAttribute, LocalVariableInfo localVariableInfo) {
        String string;
        String string2 = localVariableInfo.getDescriptor(clazz);
        if (!string2.equals(string = this.simplifyDescriptor(string2, localVariableInfo.referencedClass))) {
            localVariableInfo.u2descriptorIndex = new ConstantPoolEditor((ProgramClass)clazz).addUtf8Constant(string);
            localVariableInfo.referencedClass = null;
        }
    }

    @Override
    public void visitLocalVariableTypeInfo(Clazz clazz, Method method, CodeAttribute codeAttribute, LocalVariableTypeInfo localVariableTypeInfo) {
        String string;
        String string2;
        if (localVariableTypeInfo.referencedClasses != null && localVariableTypeInfo.referencedClasses.length > 0 && !(string2 = localVariableTypeInfo.getSignature(clazz)).equals(string = this.simplifyDescriptor(string2, localVariableTypeInfo.referencedClasses[0]))) {
            localVariableTypeInfo.u2signatureIndex = new ConstantPoolEditor((ProgramClass)clazz).addUtf8Constant(string);
            localVariableTypeInfo.referencedClasses[0] = null;
        }
    }

    private String simplifyDescriptor(String string, Clazz clazz) {
        return this.isSimpleEnum(clazz) ? string.substring(0, ClassUtil.internalArrayTypeDimensionCount(string)) + 'I' : string;
    }

    private String simplifyDescriptor(String string, Clazz[] clazzArray) {
        if (clazzArray != null) {
            Clazz clazz;
            int n;
            InternalTypeEnumeration internalTypeEnumeration = new InternalTypeEnumeration(string);
            int n2 = 0;
            StringBuffer stringBuffer = new StringBuffer(string.length());
            String string2 = internalTypeEnumeration.formalTypeParameters();
            int n3 = new DescriptorClassEnumeration(string2).classCount();
            for (n = 0; n < n3; ++n) {
                if (!this.isSimpleEnum(clazz = clazzArray[n2++])) continue;
                string2 = string2.substring(0, ClassUtil.internalArrayTypeDimensionCount(string2)) + "java/lang/Integer";
            }
            stringBuffer.append(string2);
            stringBuffer.append('(');
            while (internalTypeEnumeration.hasMoreTypes()) {
                string2 = internalTypeEnumeration.nextType();
                n3 = new DescriptorClassEnumeration(string2).classCount();
                for (n = 0; n < n3; ++n) {
                    if (!this.isSimpleEnum(clazz = clazzArray[n2++])) continue;
                    string2 = string2.substring(0, ClassUtil.internalArrayTypeDimensionCount(string2)) + 'I';
                }
                stringBuffer.append(string2);
            }
            stringBuffer.append(')');
            string2 = internalTypeEnumeration.returnType();
            n3 = new DescriptorClassEnumeration(string2).classCount();
            for (n = 0; n < n3; ++n) {
                if (!this.isSimpleEnum(clazz = clazzArray[n2++])) continue;
                string2 = string2.substring(0, ClassUtil.internalArrayTypeDimensionCount(string2)) + 'I';
            }
            stringBuffer.append(string2);
            string = stringBuffer.toString();
        }
        return string;
    }

    private Clazz[] simplifyReferencedClasses(String string, Clazz[] clazzArray) {
        if (clazzArray != null) {
            Clazz clazz;
            int n;
            InternalTypeEnumeration internalTypeEnumeration = new InternalTypeEnumeration(string);
            int n2 = 0;
            int n3 = 0;
            Clazz[] clazzArray2 = internalTypeEnumeration.formalTypeParameters();
            int n4 = new DescriptorClassEnumeration((String)clazzArray2).classCount();
            for (n = 0; n < n4; ++n) {
                clazz = clazzArray[n2++];
                clazzArray[n3++] = this.isSimpleEnum(clazz) ? null : clazz;
            }
            while (internalTypeEnumeration.hasMoreTypes()) {
                clazzArray2 = internalTypeEnumeration.nextType();
                n4 = new DescriptorClassEnumeration((String)clazzArray2).classCount();
                for (n = 0; n < n4; ++n) {
                    if (this.isSimpleEnum(clazz = clazzArray[n2++])) continue;
                    clazzArray[n3++] = clazz;
                }
            }
            clazzArray2 = internalTypeEnumeration.returnType();
            n4 = new DescriptorClassEnumeration((String)clazzArray2).classCount();
            for (n = 0; n < n4; ++n) {
                if (this.isSimpleEnum(clazz = clazzArray[n2++])) continue;
                clazzArray[n3++] = clazz;
            }
            if (n3 == 0) {
                clazzArray = null;
            } else if (n3 < n2) {
                clazzArray2 = new Clazz[n3];
                System.arraycopy(clazzArray, 0, clazzArray2, 0, n3);
                clazzArray = clazzArray2;
            }
        }
        return clazzArray;
    }

    private boolean isSimpleEnum(Clazz clazz) {
        return clazz != null && SimpleEnumMarker.isSimpleEnum(clazz);
    }
}

