
/*
 * Simulates clicking the "back" button
 */
function go_back(){
    var node = document.getElementById("backButton");   
    if (node != null){
        node.click();
    }        
}
/*
 * Simulates clicking the "continue" button
 */
function go_forward(){
    var node = document.getElementById("mainButton");   
    if (node == null && document.frames[0]){
        node = document.frames[0].document.getElementById("mainButton");  
        if (node != null){
            node.focus()
        }
    }
    if (node != null){
        node.click();   
    }
}

/*
 * Simulates clicking the "close" button
 */
function doClose() {
		if (self.macFinish){
				macFinish();
		}
		else{
			top.close();
		}
}

/*
 * Tells us whether or not we're running on IE5 (ouch)
 */
function isIE5(){
    var agent = window.navigator.userAgent;
    var msie = agent.indexOf("MSIE ");
    if (msie > 0){
        return (parseInt(agent.substring (msie+5, agent.indexOf (".", msie ))) == 5);
    }
    return false;
}


/*
 * Swallows the refresh key (F5) 
 */
function trapRefresh(e){
    switch(e.keyCode){
        case(37):         // Right arrow
          if (e.altKey){
            go_back();
          }
          break;
        case(39):         // Left arrow
          if (e.altKey){
            go_forward();
          }
          break;
        case(107):      // Plus  (broken)
        case(109):      // Minus (broken)
        case(116):      // F5
          e.keyCode = 0;
          break;
    }
}



/*
 * Forces title to be at most 2-lines
 */

function titleResize(){
   var node = document.getElementById("title");
   
   // Not sure this could ever be true.
   if (node == null){
       return;
   }
   
   
   
   // Consider this IE5 hack temporary.
   if (isIE5()){
        node.style.fontSize=30; 
        // Desperate throw for really long titles (excluding langs like Thai)
        if (node.outerText.length >= 145 && node.outerText.indexOf(' ') != -1){
        	var hack = document.getElementById("gcell");
        	if (hack != null){
        		hack.style.verticalAlign="top";
        	}
        }
        return;
   }
   
   var current = parseInt(node.style.fontSize);
   
   var height = node.offsetHeight;
   
   var contentHeight = node.parentElement.parentElement.parentElement.offsetHeight;
   
   if (contentHeight > 345){
        var diff = contentHeight - 345;
        resizeNode(node, height - diff);
        //alert(node.parentElement.parentElement.parentElement.offsetHeight);
        /*
        if (height > 48 && height < 96){
            resizeNode(node, 48);
        }
        else if (height > 96){
           resizeNode(node, 96);
        }
        else{
            node.parentNode.height = 48;
        }
    }
    else{
        if (height < 48){
            node.parentNode.height = 48;
        }
        else if (height > 96){
            resizeNode(node, 96);   
        } */
    } 
    else if (height > 96){ // guarantee 2 lines
        resizeNode(node, 96);
    }
    //resizeNode(node, 96);
}

function resizeNode(node, maxHeight){
    var current = parseInt(node.style.fontSize);
    while (node.offsetHeight > maxHeight+1){
        current -= 1;
        node.style.fontSize = current;
    }
    node.parentNode.height = maxHeight;
}


/*
 * Returns true if the Flash Player plugin is supported.
 */
function isFlashSupported(){
	if (window.navigator.plugins && navigator.plugins.length){
		return navigator.plugins["Shockwave Flash 6.0"] || navigator.plugins["Shockwave Flash"];
	}
	try{
		// IE style
		return Boolean(new ActiveXObject("ShockwaveFlash.ShockwaveFlash.6"));
	}
	catch(e){
		return false;
	}
}



/*
 * Displays the correct multimedia (bitmap or flash), depending on plugin support.
 */
function showMedia(){
	var flashNode = document.getElementById("flash");
	var imageNode = document.getElementById("graphic");

	if (flashNode && isFlashSupported()){
		flashNode.style.display="block";
	}
	else if (imageNode){
		imageNode.style.display="block";
	}
}     
