/*
 *
 * Lexmark Confidential
 * Lexmark Confidential
 * Lexmark Confidential
 *
 *  Mulitcast DNS core code
 *
 * $Id: mDNSUNP.h 7546 2005-02-02 03:28:29Z epasikat $
 *
 *  Description:
 *  This is Apple's mDNS platform code.
 *	Apple license is included.
 *
 *	NOTE:  This file is mostly unchanged from Apple and updates should be expected
 *	ANY CHANGES SHOULD BE MARKED WITH "LEXMOD" SO THEY CAN BE FOUND AND PORTED TO NEW VERSION AS RELEASED BY APPLE!!!!
 *	ANY CHANGES SHOULD BE MARKED WITH "LEXMOD" SO THEY CAN BE FOUND AND PORTED TO NEW VERSION AS RELEASED BY APPLE!!!!
 *	ANY CHANGES SHOULD BE MARKED WITH "LEXMOD" SO THEY CAN BE FOUND AND PORTED TO NEW VERSION AS RELEASED BY APPLE!!!!
 *	ANY CHANGES SHOULD BE MARKED WITH "LEXMOD" SO THEY CAN BE FOUND AND PORTED TO NEW VERSION AS RELEASED BY APPLE!!!!
 */
/*
 * Copyright (c) 2002-2003 Apple Computer, Inc. All rights reserved.
 *
 * @APPLE_LICENSE_HEADER_START@
 *
 * This file contains Original Code and/or Modifications of Original Code
 * as defined in and that are subject to the Apple Public Source License
 * Version 2.0 (the 'License'). You may not use this file except in
 * compliance with the License. Please obtain a copy of the License at
 * http://www.opensource.apple.com/apsl/ and read it before using this
 * file.
 *
 * The Original Code and all software distributed under the License are
 * distributed on an 'AS IS' basis, WITHOUT WARRANTY OF ANY KIND, EITHER
 * EXPRESS OR IMPLIED, AND APPLE HEREBY DISCLAIMS ALL SUCH WARRANTIES,
 * INCLUDING WITHOUT LIMITATION, ANY WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE, QUIET ENJOYMENT OR NON-INFRINGEMENT.
 * Please see the License for the specific language governing rights and
 * limitations under the License.
 *
 * @APPLE_LICENSE_HEADER_END@

    Change History (most recent first):

$Log: mDNSUNP.h,v $
*Revision 1.2  2003/12/02  14:25:32  bpullen
*Updated to panther version of mdns for ipv6 support
*
Revision 1.8  2003/08/12 19:56:26  cheshire
Update to APSL 2.0

Revision 1.7  2003/08/06 18:20:51  cheshire
Makefile cleanup

Revision 1.6  2003/07/02 21:19:59  cheshire
<rdar://problem/3313413> Update copyright notices, etc., in source code comments

Revision 1.5  2003/03/13 03:46:21  cheshire
Fixes to make the code build on Linux

Revision 1.4  2002/12/23 22:13:32  jgraessl

Reviewed by: Stuart Cheshire
Initial IPv6 support for mDNSResponder.

Revision 1.3  2002/09/21 20:44:53  zarzycki
Added APSL info

Revision 1.2  2002/09/19 04:20:44  cheshire
Remove high-ascii characters that confuse some systems

Revision 1.1  2002/09/17 06:24:35  cheshire
First checkin

*/

#ifndef __mDNSUNP_h
#define __mDNSUNP_h

#if LINUX
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <pthread.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <arpa/inet.h>
#include <errno.h>
#include <signal.h>
#define FD_PSET FD_SET
#else
#include "gl_types.h"               //global definitions of variable types etc..
#include "gl_defs.h"                //Hardware global definitions
#include "cer_glbl.h"               //error handling functions and defines
#include "stdio.h"
#include "stdlib.h"
#include "string.h"
#include "posix\inc\posix.h"
#include "posix\inc\pthread.h"
#include "signal.h"
#include "stdarg.h"
#include "debugout.h"
#include "net/target.h"
#include "net/inc/nu_net.h"
#include "posix_net\inc\inet\in.h"
#include "posix_net\inc\sys\socket.h"
#include "posix_net\inc\arpa\inet.h"
#include "posix_net\inc\sys\select.h"
#define u_char unsigned char
#define u_short unsigned short
#endif

#ifdef  __cplusplus
    extern "C" {
#endif

#define NOT_HAVE_SA_LEN

#ifdef NOT_HAVE_SOCKLEN_T
    typedef unsigned int socklen_t;
#endif

#if 0 /* LEXMOD - _SS_MAXSIZE is not defined but we don't want mdns to change sockaddr_storage */
#if !defined(_SS_MAXSIZE)
    #define sockaddr_storage sockaddr
#endif
#endif
#ifdef mDNSIPv6Support
#undef mDNSIPv6Support
#endif
#ifndef NOT_HAVE_SA_LEN
#define GET_SA_LEN(X) (sizeof(struct sockaddr) > ((struct sockaddr*)&(X))->sa_len ? \
                       sizeof(struct sockaddr) : ((struct sockaddr*)&(X))->sa_len   )
#else /* LEXMOD - added typecast for X to compile properly for non IPv6 builds due to removal of #define sockaddr_storage sockaddr */
#define GET_SA_LEN(X) (((struct sockaddr*)&(X))->sa_family == AF_INET ? sizeof(struct sockaddr_in) : sizeof(struct sockaddr))
#endif

#define IFI_NAME    16          /* same as IFNAMSIZ in <net/if.h> */
#define IFI_HADDR    8          /* allow for 64-bit EUI-64 in future */

// Renamed from my_in_pktinfo because in_pktinfo is used by Linux.

struct my_in_pktinfo {
    struct sockaddr_storage ipi_addr;
    int                     ipi_ifindex;            /* received interface index */
    char                    ipi_ifname[IFI_NAME];   /* received interface name  */
};

extern ssize_t recvfrom_flags(int fd, void *ptr, size_t nbytes, int *flagsp,
               struct sockaddr *sa, socklen_t *salenptr, struct my_in_pktinfo *pktp);

struct ifi_info {
  char    ifi_name[IFI_NAME];   /* interface name, null terminated */
  u_char  ifi_haddr[IFI_HADDR]; /* hardware address */
  u_short ifi_hlen;             /* #bytes in hardware address: 0, 6, 8 */
  short   ifi_flags;            /* IFF_xxx constants from <net/if.h> */
  short   ifi_myflags;          /* our own IFI_xxx flags */
  int     ifi_index;            /* interface index */
  struct sockaddr  *ifi_addr;   /* primary address */
  struct sockaddr  *ifi_brdaddr;/* broadcast address */
  struct sockaddr  *ifi_dstaddr;/* destination address */
  struct ifi_info  *ifi_next;   /* next of these structures */
};

#define IFI_ALIAS   1           /* ifi_addr is an alias */

extern struct ifi_info  *get_ifi_info(int family, int doaliases);
//extern struct ifi_info  *get_ifi_info_v6(); /* LEXMOD - added for acquiring ipv6 address of the machine */
extern void             free_ifi_info(struct ifi_info *);

#ifdef  __cplusplus
    }
#endif

#endif
