/*
 *
 * Lexmark Confidential
 * Lexmark Confidential
 * Lexmark Confidential
 *
 *  Mulitcast DNS core code
 *
 * $Id: mDNSUNP.c 6360 2004-10-12 06:13:35Z epasikat $
 *
 *  Description:
 *  This is Apple's mDNS platform code.
 *	Apple license is included.
 *
 *	NOTE:  This file is mostly unchanged from Apple and updates should be expected
 *	ANY CHANGES SHOULD BE MARKED WITH "LEXMOD" SO THEY CAN BE FOUND AND PORTED TO NEW VERSION AS RELEASED BY APPLE!!!!
 *	ANY CHANGES SHOULD BE MARKED WITH "LEXMOD" SO THEY CAN BE FOUND AND PORTED TO NEW VERSION AS RELEASED BY APPLE!!!!
 *	ANY CHANGES SHOULD BE MARKED WITH "LEXMOD" SO THEY CAN BE FOUND AND PORTED TO NEW VERSION AS RELEASED BY APPLE!!!!
 *	ANY CHANGES SHOULD BE MARKED WITH "LEXMOD" SO THEY CAN BE FOUND AND PORTED TO NEW VERSION AS RELEASED BY APPLE!!!!
 */

/*
 * Copyright (c) 2002-2003 Apple Computer, Inc. All rights reserved.
 *
 * @APPLE_LICENSE_HEADER_START@
 *
 * This file contains Original Code and/or Modifications of Original Code
 * as defined in and that are subject to the Apple Public Source License
 * Version 2.0 (the 'License'). You may not use this file except in
 * compliance with the License. Please obtain a copy of the License at
 * http://www.opensource.apple.com/apsl/ and read it before using this
 * file.
 *
 * The Original Code and all software distributed under the License are
 * distributed on an 'AS IS' basis, WITHOUT WARRANTY OF ANY KIND, EITHER
 * EXPRESS OR IMPLIED, AND APPLE HEREBY DISCLAIMS ALL SUCH WARRANTIES,
 * INCLUDING WITHOUT LIMITATION, ANY WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE, QUIET ENJOYMENT OR NON-INFRINGEMENT.
 * Please see the License for the specific language governing rights and
 * limitations under the License.
 *
 * @APPLE_LICENSE_HEADER_END@

    Change History (most recent first):

$Log: mDNSUNP.c,v $
*Revision 1.2  2003/12/02  14:25:32  bpullen
*Updated to panther version of mdns for ipv6 support
*
Revision 1.12  2003/09/02 20:47:13  cheshire
Fix signed/unsigned warning

Revision 1.11  2003/08/12 19:56:26  cheshire
Update to APSL 2.0

Revision 1.10  2003/08/06 18:20:51  cheshire
Makefile cleanup

Revision 1.9  2003/07/14 18:11:54  cheshire
Fix stricter compiler warnings

Revision 1.8  2003/07/02 21:19:59  cheshire
<rdar://problem/3313413> Update copyright notices, etc., in source code comments

Revision 1.7  2003/03/20 21:10:31  cheshire
Fixes done at IETF 56 to make mDNSProxyResponderPosix run on Solaris

Revision 1.6  2003/03/13 03:46:21  cheshire
Fixes to make the code build on Linux

Revision 1.5  2003/02/07 03:02:02  cheshire
Submitted by: Mitsutaka Watanabe
The code saying "index += 1;" was effectively making up random interface index values.
The right way to find the correct interface index is if_nametoindex();

Revision 1.4  2002/12/23 22:13:31  jgraessl

Reviewed by: Stuart Cheshire
Initial IPv6 support for mDNSResponder.

Revision 1.3  2002/09/21 20:44:53  zarzycki
Added APSL info

Revision 1.2  2002/09/19 04:20:44  cheshire
Remove high-ascii characters that confuse some systems

Revision 1.1  2002/09/17 06:24:34  cheshire
First checkin

*/
#include "mDNSUNP.h"

#if LINUX
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <pthread.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <arpa/inet.h>
#include <errno.h>
#include <signal.h>
#include <assert.h>
#include <unistd.h>
#include <fcntl.h>
#define FD_PSET FD_SET
#else
#include "gl_types.h"               //global definitions of variable types etc..
#include "gl_defs.h"                //Hardware global definitions
#include "cer_glbl.h"               //error handling functions and defines
#include "stdio.h"
#include "stdlib.h"
#include "string.h"
#include "posix\inc\posix.h"
#include "posix\inc\pthread.h"
#include "signal.h"
#include "stdarg.h"
#include "debugout.h"
#include "net/target.h"
#include "net/inc/nu_net.h"
#include "posix\inc\fcntl.h"
#include "posix_net\inc\inet\in.h"
#include "posix_net\inc\sys\socket.h"
#include "posix_net\inc\arpa\inet.h"
#include "posix_net\inc\sys\select.h"
#endif

#include "mem_debug.h"
#include "nukvac.h"
#include "vacvars.h"
#include "ThinNetDebug.h"

#define assert(X); if(!(X))TN_PrintDebug(StartUpLog, "---->asert failed @ %d", __LINE__);
/* LEXMOD - added for acquiring ipv6 address using proc file */
#define PROC_IFINET6_PATH "/proc/net/if_inet6"
#define IPV6_ANY_ADDR           0x0000U
#define IPV6_LOOPBACK_ADDR      0x0010U
#define IPV6_LINKLOCAL_ADDR     0x0020U
#define IPV6_SITELOCAL_ADDR     0x0040U
#define IPV6_COMPATv4_ADDR      0x0080U

struct ifi_info *get_ifi_info(int family, int doaliases)
{
	struct ifi_info *info;
	int vaclen;
	struct sockaddr_in *sa;

	/* we're only gonna have one! */
	do {
		info = netmalloc(sizeof(struct ifi_info));
	}while(info == NULL);
	memset(info, 0, sizeof(struct ifi_info));

	/* there can be only one */
	info->ifi_next = NULL;

	/* Name and uaa */
	vaclen = IFI_NAME;
	VAC_Read_Var(VHWC_NICIDSTR, info->ifi_name, &vaclen, 0);
	vaclen = IFI_HADDR;
	VAC_Read_Var(VMAC_UAA, (char*)info->ifi_haddr, &vaclen, 0);
	info->ifi_hlen = 6;
	
	/* flags and index! FIXME */
	info->ifi_index = 1;
	//info->ifi_flags |= IFF_UP;

	do{
		info->ifi_addr = netmalloc(sizeof(struct sockaddr_in));
	}while(info->ifi_addr == NULL);
	memset(info->ifi_addr, 0, sizeof(struct sockaddr_in));
	sa = (struct sockaddr_in*)info->ifi_addr;
	sa->sin_family = AF_INET;
	
	vaclen = 4;
	VAC_Read_Var(VIPADDRESS, (char*)&sa->sin_addr.s_addr, &vaclen, 0);

	return(info);	
}
/* end get_ifi_info3 */

/* include free_ifi_info */
void
free_ifi_info(struct ifi_info *ifihead)
{
    struct ifi_info *ifi, *ifinext;

    for (ifi = ifihead; ifi != NULL; ifi = ifinext) {
        if (ifi->ifi_addr != NULL)
            {
		netfree(ifi->ifi_addr);
		}
        if (ifi->ifi_brdaddr != NULL)
            netfree(ifi->ifi_brdaddr);
        if (ifi->ifi_dstaddr != NULL)
            netfree(ifi->ifi_dstaddr);
        ifinext = ifi->ifi_next;    /* can't fetch ifi_next after free() */
	netfree(ifi);                  /* the ifi_info{} itself */
    }
}
/* end free_ifi_info */
ssize_t
recvfrom_flags(int fd, void *ptr, size_t nbytes, int *flagsp,
               struct sockaddr *sa, socklen_t *salenptr, struct my_in_pktinfo *pktp)
{
	
	int vaclen;
	int rc = recvfrom(fd, ptr, nbytes, *flagsp, sa, salenptr);

	if(NULL != pktp) {
		memset(pktp, 0, sizeof(struct my_in_pktinfo));
		vaclen = IFI_NAME;
		VAC_Read_Var(VHWC_NICIDSTR, pktp->ipi_ifname, &vaclen, 0);
		pktp->ipi_ifindex = 1;
		
	}
	return rc;
}
