/*
 *
 * Lexmark Confidential
 * Lexmark Confidential
 * Lexmark Confidential
 *
 *  Mulitcast DNS responder
 *
 * $Id: responder.c 16309 2007-03-26 17:14:38Z bpullen $
 *
 *  Description:
 *  This is the main process for mdns.
 *  The basis for this portion of the code came from apple's Posix Rendezvous Responder
 *	As a result, I left the Apple license in.

*/

/*
 * Copyright (c) 2002 Apple Computer, Inc. All rights reserved.
 *
 * @APPLE_LICENSE_HEADER_START@
 *
 * The contents of this file constitute Original Code as defined in and
 * are subject to the Apple Public Source License Version 1.2 (the
 * "License").  You may not use this file except in compliance with the
 * License.  Please obtain a copy of the License at
 * http://www.apple.com/publicsource and read it before using this file.
 *
 * This Original Code and all software distributed under the License are
 * distributed on an "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, EITHER
 * EXPRESS OR IMPLIED, AND APPLE HEREBY DISCLAIMS ALL SUCH WARRANTIES,
 * INCLUDING WITHOUT LIMITATION, ANY WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE OR NON-INFRINGEMENT.  Please see the
 * License for the specific language governing rights and limitations
 * under the License.
 *
 * @APPLE_LICENSE_HEADER_END@
 */
/*
    File:       responder.c

    Contains:   Code to implement an mDNS responder on the Posix platform.

    Written by: Quinn

    Copyright:  Copyright (c) 2002 by Apple Computer, Inc., All Rights Reserved.

    Disclaimer: IMPORTANT:  This Apple software is supplied to you by Apple Computer, Inc.
                ("Apple") in consideration of your agreement to the following terms, and your
                use, installation, modification or redistribution of this Apple software
                constitutes acceptance of these terms.  If you do not agree with these terms,
                please do not use, install, modify or redistribute this Apple software.

                In consideration of your agreement to abide by the following terms, and subject
                to these terms, Apple grants you a personal, non-exclusive license, under Apple's
                copyrights in this original Apple software (the "Apple Software"), to use,
                reproduce, modify and redistribute the Apple Software, with or without
                modifications, in source and/or binary forms; provided that if you redistribute
                the Apple Software in its entirety and without modifications, you must retain
                this notice and the following text and disclaimers in all such redistributions of
                the Apple Software.  Neither the name, trademarks, service marks or logos of
                Apple Computer, Inc. may be used to endorse or promote products derived from the
                Apple Software without specific prior written permission from Apple.  Except as
                expressly stated in this notice, no other rights or licenses, express or implied,
                are granted by Apple herein, including but not limited to any patent rights that
                may be infringed by your derivative works or by other works in which the Apple
                Software may be incorporated.

                The Apple Software is provided by Apple on an "AS IS" basis.  APPLE MAKES NO
                WARRANTIES, EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION THE IMPLIED
                WARRANTIES OF NON-INFRINGEMENT, MERCHANTABILITY AND FITNESS FOR A PARTICULAR
                PURPOSE, REGARDING THE APPLE SOFTWARE OR ITS USE AND OPERATION ALONE OR IN
                COMBINATION WITH YOUR PRODUCTS.

                IN NO EVENT SHALL APPLE BE LIABLE FOR ANY SPECIAL, INDIRECT, INCIDENTAL OR
                CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE
                GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
                ARISING IN ANY WAY OUT OF THE USE, REPRODUCTION, MODIFICATION AND/OR DISTRIBUTION
                OF THE APPLE SOFTWARE, HOWEVER CAUSED AND WHETHER UNDER THEORY OF CONTRACT, TORT
                (INCLUDING NEGLIGENCE), STRICT LIABILITY OR OTHERWISE, EVEN IF APPLE HAS BEEN
                ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

    Change History (most recent first):

$Log: responder.c,v $
*Revision 1.45  2004/01/26  16:38:41  mls-lib
*Subversion r3554:
*
*Revision 1.44  2004/01/26  16:38:02  mls-lib
*Subversion r3551:
*
*Revision 1.43  2004/01/26  16:37:23  mls-lib
*Subversion r3548:
*
*Revision 1.42  2004/01/26  16:36:48  mls-lib
*Subversion r3545:
*
*Revision 1.41  2004/01/26  16:36:08  mls-lib
*Subversion r3542:
*
*Revision 1.40  2004/01/26  16:35:28  mls-lib
*Subversion r3539:
*
*Revision 1.39  2004/01/26  16:34:48  mls-lib
*Subversion r3536:
*
*Revision 1.38  2004/01/26  16:34:13  mls-lib
*Subversion r3533:
*
*Revision 1.37  2004/01/26  16:33:34  mls-lib
*Subversion r3530:
*
*Revision 1.36  2004/01/26  16:33:00  mls-lib
*Subversion r3527:
*
*Revision 1.35  2004/01/26  16:32:24  mls-lib
*Subversion r3524:
*
*Revision 1.34  2004/01/26  16:31:50  mls-lib
*Subversion r3521:
*
*Revision 1.33  2004/01/26  16:31:10  mls-lib
*Subversion r3518:
*
*Revision 1.32  2004/01/26  16:30:30  mls-lib
*Subversion r3515:
*
*Revision 1.31  2004/01/26  16:29:54  mls-lib
*Subversion r3512:
*
*Revision 1.30  2004/01/26  16:29:15  mls-lib
*Subversion r3509:
*
*Revision 1.29  2004/01/26  16:28:40  mls-lib
*Subversion r3506:
*
*Revision 1.28  2004/01/26  16:28:03  mls-lib
*Subversion r3503:
*
*Revision 1.27  2004/01/26  16:27:26  mls-lib
*Subversion r3499:
*
*Revision 1.26  2004/01/26  16:26:52  mls-lib
*Subversion r3496:
*
*Revision 1.25  2004/01/26  16:26:11  mls-lib
*Subversion r3491:
*
*Revision 1.24  2004/01/26  16:25:36  mls-lib
*Subversion r3487:
*
*Revision 1.23  2004/01/26  16:24:56  mls-lib
*Subversion r3483:
*
*Revision 1.22  2004/01/26  16:24:22  mls-lib
*Subversion r3480:
*
*Revision 1.21  2004/01/26  16:23:46  mls-lib
*Subversion r3477:
*
*Revision 1.20  2004/01/26  16:23:12  mls-lib
*Subversion r3474:
*
*Revision 1.19  2004/01/26  16:22:36  mls-lib
*Subversion r3471:
*
*Revision 1.18  2004/01/26  16:21:53  mls-lib
*Subversion r3468:
*
*Revision 1.17  2004/01/26  16:21:17  mls-lib
*Subversion r3465:
*
*Revision 1.16  2004/01/26  16:20:43  mls-lib
*Subversion r3462:
*
*Revision 1.15  2004/01/26  16:20:03  mls-lib
*Subversion r3459:
*
*Revision 1.14  2004/01/26  16:19:28  mls-lib
*Subversion r3456:
*
*Revision 1.13  2004/01/26  16:18:52  mls-lib
*Subversion r3453:
*
*Revision 1.12  2004/01/26  16:18:15  mls-lib
*Subversion r3450:
*
*Revision 1.11  2004/01/26  16:17:37  mls-lib
*Subversion r3447:
*
*Revision 1.10  2004/01/26  16:16:58  mls-lib
*Subversion r3443:
*
*Revision 1.9  2004/01/26  14:31:44  mls-lib
*Subversion r3443:
*
*Revision 1.8  2004/01/08  15:04:40  bpullen
*Removed old api stuff, the new version works well.
*
*Revision 1.7  2003/12/02  14:25:32  bpullen
*Updated to panther version of mdns for ipv6 support
*
*Revision 1.6  2003/07/31  14:51:27  bpullen
*Various tweaks to mdns and ddns
*
*Revision 1.3  2003/07/30  17:18:57  bpullen
*Added VIPDDNSACTIVE and changed ddns so host-config text is always written
*
*Revision 1.2  2003/07/29  14:36:27  bpullen
*Fixed buffer overflow on default name creation
*
*Revision 1.1  2003/07/21  18:45:54  bpullen
*.
*
*Revision 1.3  2003/07/09  20:51:06  bpullen
* Turned off some extranious debugging
*
*Revision 1.2  2003/07/09  18:43:32  bpullen
* Fixed path on route fork command
*
*Revision 1.1  2003/07/09  17:09:37  bpullen
*.
*
Revision 1.3  2002/09/21 20:44:53  zarzycki
Added APSL info

Revision 1.2  2002/09/19 04:20:44  cheshire
Remove high-ascii characters that confuse some systems

Revision 1.1  2002/09/17 06:24:35  cheshire
First checkin

*/

#include "mDNSClientAPI.h"// Defines the interface to the client layer above
#include "mDNSPosix.h"    // Defines the specific types needed to run mDNS on this platform


#if LINUX
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <pthread.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <arpa/inet.h>
#include <errno.h>
#include <signal.h>
#include <assert.h>
#include <unistd.h>
#include <fcntl.h>
#define FD_PSET FD_SET
#else
#include "gl_types.h"               //global definitions of variable types etc..
#include "gl_defs.h"                //Hardware global definitions
#include "cer_glbl.h"               //error handling functions and defines
#include "stdio.h"
#include "stdlib.h"
#include "string.h"
#include "posix\inc\posix.h"
#include "posix\inc\pthread.h"
#include "signal.h"
#include "stdarg.h"
#include "debugout.h"
#include "net/target.h"
#include "net/inc/nu_net.h"
#include "posix\inc\fcntl.h"
#include "posix_net\inc\inet\in.h"
#include "posix_net\inc\sys\socket.h"
#include "posix_net\inc\arpa\inet.h"
#include "posix_net\inc\sys\select.h"
#endif


#include "nukvac.h"
#include "vacvars.h"
#include "ErrExitAPI.h"
#include "StatusAPI_Interface.h"
#include "ThinNetDebug.h"
#include "sys_defines.h"
#include "mDNSPlatformFunctions.h"
#if 0
#define SYSLOG(x)  syslog x
#else
#define SYSLOG(x)
#endif

static mDNS mDNSStorage;       // mDNS core uses this to store its globals
static mDNS_PlatformSupport PlatformStorage;  // Stores this platform's globals
int Num_Ports = 1;
int reinit_interfaces = 0;
int reinit_port = -1;
int gPollVariables = 1;
int gMainPid = -1;

typedef struct PosixService PosixService;
typedef struct PortInfo PortInfo;

extern void mDNSPosixGetFDSet(mDNS *const m, int *nfds, fd_set *readfds, struct timeval *timeout);
extern void mDNSPosixProcessFDSet(mDNS *const m, fd_set *readfds);
extern int fork_and_run (int num_obj, ...);
void changeHostName(char* pstring);
static void DeregisterOurServices(PortInfo* portinfo);
void RegisterOnePort(PortInfo* ptr);
void SetServiceName(char* servicename, char* productid, int port);
static mStatus RegisterOneService(const char *  richTextHostName,
                                  const char *  serviceType,
                                  const mDNSu8  text[],
                                  mDNSu16       textLen,
                                  long          portNumber,
                                  PortInfo *    portinfo);


int ignore_name_write = 0;
int ignore_service_write = 0;



/* Service used to keep a handle on registered services
 * Note that this links back up to the port structure to folow
 * This allows us to find the relevant information from either port or service list*/
struct PosixService {
    ServiceRecordSet coreServ;
    PosixService *next;
    int serviceID;
    int registered;
    PortInfo *portinfo;
};

/* Portinfo structure used to store relevant information concerning port service advertisement
 * Note that this has a the first node of a link list of PosixService Structures! */
struct PortInfo {
	int portid;
	int portup;
	int advertised;
	int pson;
	char lpd_text[512];
	int lpd_len;
	char ipp_pdl_text[512];
	int ipp_pdl_len;
    char koshi_text[1024]; //memset is hard coded to 1024!!!
    int koshi_len;
	char servicename[240];
	PortInfo *next;
	PosixService *SRV;
};

/* Global pointer to a list of Port Structures
 * There will be only one for the INA case */
static PortInfo *PortList = NULL;

int LocalTxtPrintIPAddr(char *txtrecord,  unsigned int var, char* Label) {

	UINT8 ipaddr[4];
	int rc;
	int vaclen = sizeof(ipaddr);
	char *ptr;
		
	rc = VAC_Read_Var(var, (char*)ipaddr, &vaclen, 0);
	if(VAC_SUCCESS == rc) {
		ptr = &txtrecord[strlen(txtrecord)];
		sprintf(ptr + 1, "%s=%d.%d.%d.%d", Label, ipaddr[0], ipaddr[1], ipaddr[2], ipaddr[3]);
		*ptr = strlen(ptr + 1);
	}
	return rc;
}
int LocalTxtPrintOctet(char *txtrecord,  unsigned int var, char* Label, int size) {

	char *buff = NULL;
	int rc;
	int vaclen = size;
	char *ptr;
	char *tmp;
	int i;
	
	while(NULL == buff)
		buff = netmalloc(size);	
	rc = VAC_Read_Var(var, buff, &vaclen, 0);
	if(VAC_SUCCESS == rc) {
		ptr = &txtrecord[strlen(txtrecord)];
        sprintf(ptr + 1, "%s=", Label);
		tmp = ptr + 1 + strlen(ptr + 1);
		for(i=0; i<size; i++) {
			sprintf(tmp, "%02X", buff[i]);	
			tmp+=2;
		}
        *ptr = strlen(ptr + 1);
	}
	return rc;
}

#define FIRST_TRY_SIZE 32
int LocalTxtPrintString(char *txtrecord,  unsigned int var, char* Label) {

	char *strval = NULL;
	int rc;
	int vaclen = FIRST_TRY_SIZE;
	char *ptr;
	
	while(strval == NULL) 
		strval = netmalloc(vaclen);
	
	do {
		rc = VAC_Read_Var(var, strval, &vaclen, 0);

		if(VAC_ERR_LENGTH == rc) {

			vaclen = vaclen * 2;
			netfree(strval);
			strval = NULL;
			while(strval == NULL)
				strval = netmalloc(vaclen);
		}
	}while(rc == VAC_ERR_LENGTH);

	if(VAC_SUCCESS == rc) {
		ptr = &txtrecord[strlen(txtrecord)];
        sprintf(ptr + 1, "%s=%s", Label, strval);
		*ptr = strlen(ptr + 1);
	}

	netfree(strval);
	return rc;
}


/* This function will loop through the interface list reinitializing them and registering the host name */
/* Very usefull on ip address change or similar */
void restart_interfaces(mDNS* m) {
	NetworkInterfaceInfo *hr = mDNSNULL;
	char ourname[240];
	int vaclen, rc;
	
	vaclen = sizeof(ourname);
	rc = VAC_Read_Var(VIPNAME, ourname, &vaclen, 0);
	if(rc != VAC_SUCCESS) {
		ErrExitInfo(rc, 0, 0, "Unable to read VIPNAME");
	}
	/* Convert name to hostname */
	m->hostlabel.c[0] = strlen(ourname);
	memcpy(&m->hostlabel.c[1], ourname, strlen(ourname));

	mDNS_GenerateFQDN(m);
	mDNSPlatformPosixRefreshInterfaceList(m);
	// 3. Re-register all our host sets
	while (hr)
		{
		NetworkInterfaceInfo *set = hr;
		hr = hr->next;
		mDNS_RegisterInterface(m, set);
		}
}

/* List for variable changes from vacuum
 * Anyone think of a better way to do this? */
void vacvar_changed ( pStatusMessage Message, void* privateData) {

	static int name_changed = 0;
	static int ip_changed = 0;
	static int srv_changed = 0;
	static int mdns_changed = 0;

	if(Message->MessageType == PM_VACUUM_WRITE_TYPE) {
		switch(Message->Message) {
			/* if the name changes, write it set a flag so we can make the change later
			 * If the ignore_name_write flag is set, that means we wrote the name, so we don't need
			 * to do anything */
			case VIPNAME:
				if(!ignore_name_write) {
					name_changed = 1;
				}
				else {
					SYSLOG((LOG_DEBUG, "Ignoring name write"));
					ignore_name_write = 0;
				}
				break;
			case VIPADDRESS:
				ip_changed = 1;
				break;
			/* Throw up a flag (yuk!) if the mDNS name changes
			 * Again, ignore the write if we did the writing */
			case VCCS_LOCATION:
				srv_changed = 1;
				break;
			case VMDNSNAME:
				if(!ignore_service_write)
					srv_changed = 1;
				else {
					SYSLOG((LOG_DEBUG, "Ignoring service write"));
					ignore_service_write = 0;
				}
				break;
            case VPRT_CPD_KOSHI_SUPPORTED:
                //Koshi is not in NVRAM, so we need to kick off required work now! EWB
                reinit_port = 1;
                break;
			/* Once the NVRAM is saved, let's go do the required work!
			 * Well, actually we notify the main loop it should do the work */
			case VIPNVRAMSAVE:
				if(name_changed || ip_changed) {
					reinit_interfaces = 1;
					ip_changed = name_changed = 0;
					//kill(gMainPid, SIGALRM);
					SYSLOG((LOG_DEBUG, "ip or name changed"));
				}
				if(srv_changed) {
					/* This will become the port number when vmdnsname is indexed */
					reinit_port = 1;
					SYSLOG((LOG_DEBUG, "service name changed!"));
					srv_changed = 0;
					//kill(gMainPid, SIGALRM);
				}
				if(mdns_changed) {
					SYSLOG((LOG_DEBUG, "Alert main process with SIGALRM that it should check variables"));
					gPollVariables = 1;
					//kill(gMainPid, SIGALRM);
				}
				break;
			default:
				break;
		}
	}
}

/* This is just a place to register for alerts so it doesn't have to go in main */
void RegisterForAlerts() {

	SA_Add_Var_For_Alerts(vacvar_changed, VIPNAME, NULL);
	SA_Add_Var_For_Alerts(vacvar_changed, VIPNVRAMSAVE, NULL);
	SA_Add_Var_For_Alerts(vacvar_changed, VIPADDRESS, NULL);
	SA_Add_Var_For_Alerts(vacvar_changed, VMDNSNAME, NULL);
	SA_Add_Var_For_Alerts(vacvar_changed, VCCS_LOCATION, NULL);
	SA_Add_Var_For_Alerts(vacvar_changed, VMAC_CARD_STATUS, NULL);
    SA_Add_Var_For_Alerts(vacvar_changed, VPRT_CPD_KOSHI_SUPPORTED, NULL);
}

/* This is called any time we think data may have changed
 * This function checks to see if it is different
 * If it is, it is written back to NVRam */
void WriteDataBackToNVRam(mDNS *const m)
	{
		int rc, vaclen;
		char ourname[240];
		PortInfo* current;
		char servicename[240];

		vaclen = sizeof(ourname);
		rc = VAC_Read_Var(VIPNAME, ourname, &vaclen, 0);
		if(VAC_SUCCESS != rc) {
			ErrExitInfo(rc, 0, 0, "Unable to get our hostname");
		}

		/* Check to see if host name changed
		 * Since there is just one host name, this is easy!
		 * Well, we do have to do some conversion cuz mDNS stores
		 * the name as a pstring! */
		m->hostlabel.c[m->hostlabel.c[0]+1] = 0;
		if(strcmp((char*)&m->hostlabel.c[1], ourname) != 0)
		{
			/* We need to write our name back to nvram so it will be there next time */
			memset(ourname, 0, sizeof(ourname));
			memcpy(ourname, &m->hostlabel.c[1], m->hostlabel.c[0]);

			ignore_name_write = 1;
			vaclen = sizeof(ourname);
			SYSLOG((LOG_DEBUG, "About to write name \"%s\"", ourname));
			rc = VAC_Write_Var(VIPNAME, ourname, &vaclen, 0);
			if(VAC_SUCCESS != rc) {
				ErrExitInfo(rc, 0, 0, "Unable to write our hostname");
			}
			SYSLOG((LOG_DEBUG, "Done writing name!"));

		}

		/* Now we're gonna loop throught the port structures looking for a service name change*/
		current = PortList;
		while(current != NULL) {
                        vaclen = sizeof(servicename);
                        rc = VAC_Read_Var(VMDNSNAME, servicename, &vaclen, 0);
                        if(VAC_SUCCESS != rc)
	                        ErrExitInfo(rc, 0, 0, "Unable to read defaultname");
                        if(strcmp(servicename, current->servicename) != 0) {
                                ignore_service_write = 1;
                                 vaclen = strlen(current->servicename);
                                 rc = VAC_Write_Var(VMDNSNAME, current->servicename, &vaclen, 0);
                                 if(VAC_SUCCESS != rc)
                                               ErrExitInfo(rc, 0, 0, "Unable to write defaultname");
                         }
			current = current->next;
		}
	}


/* When the host name is changed by mDNS or registration is complete,
 * this function will be called.
 */
void ClientHostNameCallback(mDNS *const m, mStatus result)
	{

	switch (result)
		{
		case mStatus_NoError:

				/* Here we need to check if the name was changed during the process, if so
				   we need to write it back to Vacuum since it has stablized! TBC */
				   WriteDataBackToNVRam(m);

			break;
		case mStatus_NameConflict:
			break;
		default:
			break;
		}

	if (result == mStatus_NameConflict)
		{
			changeHostName((char*)&m->hostlabel.c);
		}
	}

/* ----------------------------------------------------------------------
 * Function    : changeServiceName()
 *
 * Purpose     : Renames mDNSservice name after a conflict is detected
 *
 * Description : Tacks on a (%d) to the end of the name intelligently, sort of
 *
 * Author      : Ben Pullen
 * Date        : Feb 4, 2003
 * -----------------------------------------------------------------------
 */
void changeServiceName(char* oursvcname)
{
	int length, place, count;
	int maxlen = 63;
	char temp[240];
	length = strlen(oursvcname);
	place = length;
	count = 0;

	if(place < 1)
	{
		sprintf(oursvcname, "(2)");
	}
	/* See if we have already modified this name */
	if(oursvcname[place-1] == ')')
	{
		place--;
		while(oursvcname[place-1] > 47 && oursvcname[place-1] < 58)
		{
			place--;
		}
		count = atoi(oursvcname+place) + 1;

		/* Check to see if we had a false hit */
		if(oursvcname[place-1] != '(')
		{
			place = length;
			count = 2;
		}
		else
			place -= 2;
	}
	else{
		place = length;
		count = 2;
	}
	sprintf(temp, " (%d)", count);
	if(place + strlen(temp) > maxlen){

			place = maxlen - strlen(temp);
	}
	sprintf(oursvcname+place, " (%d)", count);

}


/* ----------------------------------------------------------------------
 * Function    : changeHostName()
 *
 * Purpose     : Renames iphostname after a conflict is detected
 *
 * Description : Tacks on a -%d to the end of the name intelligently, sort of
 *
 * Author      : Ben Pullen
 * Date        : Feb 4, 2003 - updated 6-26-03 to use pstring as input
 * -----------------------------------------------------------------------
 */
void changeHostName(char* pstring)
{
	char ourname[240];
	int length, place, count;
	int maxlen = 15;
	char temp[240];


	/* initialize stuff, including copying pstring into a normal string to work with! */
	memset(ourname, 0, 240);
	memcpy(ourname, &pstring[1], pstring[0]);
	length = strlen(ourname);
	place = length;
	count = 0;

	/* Check to see if ourname ends in a number */
	while(ourname[place-1] > 47 && ourname[place-1] < 58)
	{
		place --;
	}
	if(place < length)
		count = atoi(ourname+place) + 1;
	/* check to see if we already have a '-' */
	if(ourname[place-1] == '-')
	{
		place--;
	}
	else{
		place = length;
		count = 2;
	}
	sprintf(temp, "-%d", count);
	if(place + strlen(temp) > maxlen)
	{
		place = maxlen - strlen(temp);
	}
	sprintf(ourname+place, "-%d", count);

	/* Now copy the name back into pstring */
	pstring[0] = strlen(ourname);
	memcpy(&pstring[1], ourname, pstring[0]);
}

/* This is just a quick and dirty way to deal with service name problems
 * We deregister any advertised services, change the service name, and reregister that port */
void handleServiceNameConflict(PosixService* SRV) {
	PortInfo* portinfo;

	if(!SRV)
		return;
	portinfo = SRV->portinfo;
	if(!portinfo)
		return;
	DeregisterOurServices(portinfo);
	changeServiceName(portinfo->servicename);
	/* WRITE INFO BACK TO NVRAM!! */
	RegisterOnePort(portinfo);

}

/* loop through all the port structures looking for this service! */
/* This is good because lots of the apple stuff sends back that coreServ
 * and we need to be able to track it down in our structures */
PosixService* matchService(ServiceRecordSet* coreServ)
{
	PortInfo* currentport = PortList;
	PosixService* currentserv;

	while(currentport != NULL) {
		currentserv = currentport->SRV;
		while(currentserv != NULL) {
			if(coreServ == &currentserv->coreServ) {
				SYSLOG((LOG_DEBUG, "Match found!"));
				return currentserv;
			}
			currentserv = currentserv->next;
		}
		currentport = currentport->next;
	}
	return NULL;
}

/* This is where we initialize the port information for a port*/
/* This function expects that certain things will be set already by initPortList */
void getPortInfo(PortInfo* current) {
	int i, rc, vaclen, portup;
	char productid[240], location[240], ourname[16];
	char *ptr;
    int KoshiSupported = 0;

	vaclen = sizeof(ourname);
	rc = VAC_Read_Var(VIPNAME, ourname, &vaclen, 0);
	if(rc != VAC_SUCCESS)
		ErrExitInfo(rc, 0, 0, "Unable to read VIPNAME");

	vaclen = sizeof(location);
	rc = VAC_Read_Var(VCCS_LOCATION, location, &vaclen, 0);
	if(rc != VAC_SUCCESS)
		ErrExitInfo(rc, 0, 0, "Unable to read VCCS_LOCATION");

	i = current->portid;

	portup = 1;
	current->portup = 1;
	current->advertised = 0;

	vaclen = sizeof(productid);
	rc = VAC_Read_Var(VPRT_PRODUCTID, productid, &vaclen, i);
	if(rc != VAC_SUCCESS)
		ErrExitInfo(rc, 0, 0, "Unable to read productid");

	SetServiceName(current->servicename, productid, i);
	if(portup) {
		SYSLOG((LOG_DEBUG, "port %d up", i));
		current->pson = 0;

	/* If we need to advertise ps printing, we'd better set some text */
	/* lpd text is different because we wish to give it priority */

        vaclen = sizeof(int);
        VAC_Read_Var(VPRT_CPD_KOSHI_SUPPORTED, (char*)&KoshiSupported, &vaclen, 1);
        if(KoshiSupported > 0)
        { 
            //Setup Fresh char array
            memset(current->koshi_text, 0, 1024);
            ptr = &current->koshi_text[0];

            if(KoshiSupported == 2)
            {//Activated
                sprintf(ptr+1, "ACTIVATED=TRUE");
            }
            else
            {//Capable but not Activated
                sprintf(ptr+1, "ACTIVATED=FALSE");
            }
            *ptr = strlen(ptr+1);

            //now add Mac Address
            LocalTxtPrintOctet(current->koshi_text, VMAC_UAA, "MAC", 6);

            //IpAddress
            LocalTxtPrintIPAddr(current->koshi_text, VIPADDRESS, "IPADDRESS");

            //device name
            LocalTxtPrintString(current->koshi_text, VMDNSNAME, "NAME");

            //device model
            ptr = &current->koshi_text[strlen(current->koshi_text)];
            sprintf(ptr+1, "MODEL=%s", productid);
            *ptr = strlen(ptr+1);

            current->koshi_len = (ptr + 1 + strlen(ptr + 1)) - current->koshi_text;

        }//EWB

        if(current->pson) {
			/* Now let's set the lpd text! */
			memset(current->lpd_text, 0, 512);
			ptr = &current->lpd_text[strlen(current->lpd_text)];
			sprintf(ptr+1, "product=(%s)", productid);
			*ptr = strlen(ptr+1);
			ptr = &current->lpd_text[strlen(current->lpd_text)];
			sprintf (ptr + 1, "note=%s", location);
			*ptr = strlen(ptr + 1);
			ptr = &current->lpd_text[strlen(current->lpd_text)];
			sprintf (ptr + 1, "pdl=application/postscript");
			*ptr = strlen(ptr + 1);
			ptr = &current->lpd_text[strlen(current->lpd_text)];
			sprintf (ptr + 1, "adminurl=http://%s.local.", ourname);
			*ptr = strlen(ptr + 1);
			ptr = &current->lpd_text[strlen(current->lpd_text)];
			sprintf (ptr + 1, "priority=0");
			*ptr = strlen(ptr + 1);
			sprintf (ptr + 1, "rp=prt%d", i-1);
			*ptr = strlen(ptr + 1);

			/* Set the length of the text to pass in! */
			current->lpd_len = (ptr + 1 + strlen(ptr + 1)) - current->lpd_text;
			SYSLOG((LOG_DEBUG, "lpd_len = %d", current->lpd_len));

			/* now the non lpd text! */
			/* Now let's set the lpd text! */
			memset(current->ipp_pdl_text, 0, 512);
			ptr = &current->ipp_pdl_text[strlen(current->ipp_pdl_text)];
			sprintf(ptr+1, "product=(%s)", productid);
			*ptr = strlen(ptr+1);
			ptr = &current->ipp_pdl_text[strlen(current->ipp_pdl_text)];
			sprintf (ptr + 1, "note=%s", location);
			*ptr = strlen(ptr + 1);
			ptr = &current->ipp_pdl_text[strlen(current->ipp_pdl_text)];
			sprintf (ptr + 1, "pdl=application/postscript");
			*ptr = strlen(ptr + 1);
			ptr = &current->ipp_pdl_text[strlen(current->ipp_pdl_text)];
			sprintf (ptr + 1, "adminurl=http://%s.local.", ourname);
			*ptr = strlen(ptr + 1);
			ptr = &current->ipp_pdl_text[strlen(current->ipp_pdl_text)];
			sprintf (ptr + 1, "priority=50");
			*ptr = strlen(ptr + 1);
			sprintf (ptr + 1, "rp=prt%d", i-1);
			*ptr = strlen(ptr + 1);

			/* Set the length of the text to pass in! */
			current->ipp_pdl_len = (ptr + 1 + strlen(ptr + 1)) - current->ipp_pdl_text;
		}
	}
}

/* This should only be called ONCE!*/
/* This goes through mallocing for a port list,sets a couple of pieces of info,
 * and calls getPortInfo to fill in details! */
void initPortList() {
	int i;
	PortInfo *current = NULL;

	for(i=0; i<Num_Ports; i++) {
		SYSLOG((LOG_DEBUG, "getting info for port %d", i+1));
		if(PortList == NULL) {
			PortList = netcalloc(1, sizeof(PortInfo));
			current = PortList;
		} else {
			current->next = netcalloc(1, sizeof(PortInfo));
			current = current->next;
		}
		current->portid = i+1;
		getPortInfo(current);
	}
}

/* on the ina, this code will only read the mdns name, restoring it to default if a blank string is read
 * on the ena, it will check to see if the default name is in use, if so, it will ensure the sanity of the default name */
/* Note, this will not ensure YOUR sanity upon reading this code. Pester me and maybe I'll make it better... Maybe */
void SetServiceName(char* servicename, char* productid, int port) {
	int rc, vaclen;

	/* otherwise, we just use the normal naming plan */
	vaclen = 240;
	rc = VAC_Read_Var(VMDNSNAME, servicename, &vaclen, 0);
	/* The last character can not be a period, blow it away if that's the case */
	while(servicename[strlen(servicename) - 1] == '.') 
	{
		servicename[strlen(servicename) - 1] = 0;
	}
	if(servicename[0] == 0) {
		memset(servicename, 0, 240);
		TN_PrintDebug(StatusLog, "Restoring default service name: %s", productid);
		strcpy(servicename, productid);
		ignore_service_write = 1;
		vaclen = sizeof(servicename);
		rc = VAC_Write_Var(VMDNSNAME, servicename, &vaclen, 0);
	}
}

static void RegistrationCallback(mDNS *const m, ServiceRecordSet *const thisRegistration, mStatus status)
    // mDNS core calls this routine to tell us about the status of
    // our registration.  The appropriate action to take depends
    // entirely on the value of status.
{
	PosixService* ptr;
    switch (status) {

        case mStatus_NoError:
            // Do nothing; our name was successfully registered.  We may
            // get more call backs in the future

			ptr = matchService(thisRegistration);
			if(ptr != NULL) {
				ptr->registered = 1;
				SYSLOG((LOG_DEBUG, "service registered"));
			} else
				SYSLOG((LOG_DEBUG, "NO!!!!"));

			/* see if we need to write any date back to nvram! */
			WriteDataBackToNVRam(m);
            break;

        case mStatus_NameConflict:
        	/* On service name conflice, let'call our handler and go on, that's why we wrote a handler (duh!)*/
			SYSLOG((LOG_DEBUG, "Name conflict!"));
            ptr = matchService(thisRegistration);
       		handleServiceNameConflict(ptr);
            break;

        case mStatus_MemFree:
            netfree(thisRegistration);
            break;

        default:
            break;
    }
}

/* RegiserAllPorts registers all ports  :D */
void RegisterAllPorts(){
	PortInfo *ptr = PortList;

	/* Loop through all the ports registering services */
	while(ptr != NULL) {
		RegisterOnePort(ptr);
		ptr = ptr->next;
	}
}

/* RegisterOnePort registers one port, d: */
void RegisterOnePort(PortInfo* ptr) {
	mStatus s;
    int vaclen;
    int KoshiSupported = 0;

	s = RegisterOneService(ptr->servicename, "_http._tcp.", NULL, 0, 80, ptr);
	SYSLOG((LOG_DEBUG, "registered http"));

    vaclen = sizeof(int);
	VAC_Read_Var(VPRT_CPD_KOSHI_SUPPORTED, (char*)&KoshiSupported, &vaclen, 1);
    if(KoshiSupported > 0)
    {
        s = RegisterOneService(ptr->servicename, "_lxkWebEnabled._tcp.",(unsigned char *) ptr->koshi_text, ptr->koshi_len, 9100, ptr);
    }//EWB
    
#if 0
	if(ptr->pson) {
		s = RegisterOneService(ptr->servicename, "_printer._tcp.", ptr->lpd_text, ptr->lpd_len, 515, ptr);
		SYSLOG((LOG_DEBUG, "registered lpd"));
		s = RegisterOneService(ptr->servicename, "_ipp._tcp.", ptr->ipp_pdl_text, ptr->ipp_pdl_len, 631, ptr);
		SYSLOG((LOG_DEBUG, "registered ipp"));
		s = RegisterOneService(ptr->servicename, "_pdl-datastream._tcp.", ptr->ipp_pdl_text, ptr->ipp_pdl_len, 9100, ptr);
		SYSLOG((LOG_DEBUG, "registered pdl-datastream"));
	}
#endif
}
static int gServiceID = 0;

/* This one pretty much came from apple
 * All I did was fit it into the whole port list idea */
static mStatus RegisterOneService(const char *  richTextHostName,
                                  const char *  serviceType,
                                  const mDNSu8  text[],
                                  mDNSu16       textLen,
                                  long          portNumber,
                                  PortInfo *    portinfo)
{
    mStatus             status;
    PosixService *      thisServ;
    mDNSOpaque16        port;
    domainlabel         name;
    domainname          type;
    domainname          domain;

    status = mStatus_NoError;
    thisServ = (PosixService *) netmalloc(sizeof(*thisServ));
    if (thisServ == NULL) {
        status = mStatus_NoMemoryErr;
    }
    if (status == mStatus_NoError) {
        MakeDomainLabelFromLiteralString(&name,  richTextHostName);
        MakeDomainNameFromDNSNameString(&type, serviceType);
        MakeDomainNameFromDNSNameString(&domain, "local.");
        port.b[0] = (portNumber >> 8) & 0x0FF;
        port.b[1] = (portNumber >> 0) & 0x0FF;;
        status = mDNS_RegisterService(&mDNSStorage, &thisServ->coreServ,
                &name, &type, &domain,				// Name, type, domain
                NULL, port, 						// Host and port
                text, textLen,						// TXT data, length
                NULL, 0,							// Subtypes
                mDNSInterface_Any,					// Interace ID
                RegistrationCallback, thisServ);	// Callback and context
    }
    if (status == mStatus_NoError) {
        thisServ->serviceID = gServiceID;
        gServiceID += 1;
        thisServ->portinfo = portinfo;
        thisServ->next = portinfo->SRV;
        portinfo->SRV = thisServ;

        if (gMDNSPlatformPosixVerboseLevel > 0) {
           		SYSLOG((LOG_DEBUG,
                    "%s: Registered service %d, name '%s', type '%s', port %ld\n",
                    gProgramName,
                    thisServ->serviceID,
                    richTextHostName,
                    serviceType,
                    portNumber));
        }
    } else {
        if (thisServ != NULL) {
            netfree(thisServ);
        }
    }
    return status;
}

/* This blows away all our services for a port */
/* Note, the port structure hangs around, just not the services */
static void DeregisterOurServices(PortInfo* portinfo)
{
    PosixService *thisServ;
    int thisServID;
    PosixService* ServiceList = portinfo->SRV;
    portinfo->SRV = NULL;

    while (ServiceList != NULL) {
        thisServ = ServiceList;
        ServiceList = thisServ->next;

        thisServID = thisServ->serviceID;

        mDNS_DeregisterService(&mDNSStorage, &thisServ->coreServ);
    }
}

void mDNSstop(void *arg)
{
	mDNSPlatformClose(&mDNSStorage);
}

/* This main is super hacked from Apple's example code! */
void *mDNSmain(void *args)
{
    mStatus status;

	/* Register for alerts from Vacuum */
	RegisterForAlerts();

	/* Create our port structure and default names */
	PortList = NULL;
	initPortList();

	/* This gets Apple's mDNS core going */
	do {
		status = mDNS_Init(&mDNSStorage, 
						&PlatformStorage, 
						mDNS_Init_NoCache, 
						mDNS_Init_ZeroCacheSize,
						mDNS_Init_AdvertiseLocalAddresses,
						mDNS_Init_NoInitCallback, 
						mDNS_Init_NoInitCallbackContext);
    	}while(status != mStatus_NoError);

	CleanupStackPush(mDNSstop, NULL,__FILE__, __LINE__);

	/* set our hostname callback function */
	mDNSStorage.MainCallback = (mDNSCallback*)ClientHostNameCallback;

	/* init and register all ports! */
	RegisterAllPorts();

    
	/* pop those pesky false port messages off! */
	reinit_port = -1;


	while (1)
		{
		int nfds = 0;
		fd_set readfds;
		struct timeval timeout;
		int result;


		// 1. Set up the fd_set as usual here.
		// This example client has no file descriptors of its own,
		// but a real application would call FD_SET to add them to the set here
		FD_ZERO(&readfds);

		// 2. Set up the timeout.
		timeout.tv_sec =  5;
		timeout.tv_usec = 0;

		// 3. Give the mDNSPosix layer a chance to add its information to the fd_set and timeout
		mDNSPosixGetFDSet(&mDNSStorage, &nfds, &readfds, &timeout);

		// 4. Call select as normal
		result = select(nfds, &readfds, NULL, NULL, &timeout);
		
		// 5. Call mDNSPosixProcessFDSet to let the mDNSPosix layer do its work
		mDNSPosixProcessFDSet(&mDNSStorage, &readfds);

		// 6. This example client has no other work it needs to be doing,
		// but a real client would do its work here
		// ... (do work) ...
		if(reinit_interfaces) {
			/* we noticed that our name or ip changed, so we'd better register them again!! */
			restart_interfaces(&mDNSStorage);
			reinit_interfaces = 0;
		}
		if(reinit_port > 0) {
			PortInfo* current = PortList;

			while(current != NULL)
			{
				SYSLOG((LOG_DEBUG, "Port %d about to be reinitialized", reinit_port));
				DeregisterOurServices(current);
				getPortInfo(current);
				RegisterOnePort(current);
				current = current->next;
			}
			reinit_port = -1;
		}

	}
	return NULL;
}
