<?xml version="1.0" encoding="iso-8859-1"?>
<!-- **************************************************************************
                  Copyright (c) 2007, Lexmark International, Inc.           
     THIS IS AN UNPUBLISHED WORK CONTAINING CONFIDENTIAL AND PROPRIETARY     
        INFORMATION WHICH IS THE PROPERTY OF LEXMARK INTERNATIONAL, INC.     
                                                                             
   ANY DISCLOSURE, USE, OR REPRODUCTION, WITHOUT WRITTEN AUTHORIZATION FROM  
              LEXMARK INTERNATIONAL, INC., IS STRICTLY PROHIBITED.           
*************************************************************************** -->
<!--
This file contains the transformations for non-dynamically generated screens. 
It applies the localization and control transforms without altering the
structure of the input document.
-->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
  <xsl:output method="html" />

  <!-- Localization -->
  <xsl:include href="jswloc.xsl" />
  <xsl:include href="localize.xsl" />

  <!-- Controls -->
  <xsl:include href="controls.xsl" />

  <!-- Direct copy of node & attributes -->
  <xsl:template match="@*|node()">
    <xsl:copy>
      <xsl:apply-templates select="@*|node()" />
    </xsl:copy>
  </xsl:template>

  <!-- Apply a workaround for IE5's lack of Function.call -->
  <xsl:template match="head">
    <xsl:copy>
      <xsl:apply-templates select="@*" />
      <xsl:element name="script">
        <xsl:attribute name="type">text/javascript</xsl:attribute>
        parent.ApplyFunctionCallWorkAround(Function.prototype);
      </xsl:element>
      <xsl:apply-templates select="node()" />
    </xsl:copy>  
  </xsl:template>
  
  <!-- Apply the LTR / RTL reading order to the document body and disable 
  drag & drop -->
  <xsl:template match="body">
    <xsl:copy>
      <xsl:call-template name="reading_order" />
      <xsl:attribute name="ondragstart">return false;</xsl:attribute>
      <xsl:apply-templates select="@*|node()" />
    </xsl:copy>
  </xsl:template>

</xsl:stylesheet>