//*****************************************************************************
//                  Copyright (c) 2007, Lexmark International, Inc.           
//     THIS IS AN UNPUBLISHED WORK CONTAINING CONFIDENTIAL AND PROPRIETARY     
//        INFORMATION WHICH IS THE PROPERTY OF LEXMARK INTERNATIONAL, INC.     
//                                                                             
//   ANY DISCLOSURE, USE, OR REPRODUCTION, WITHOUT WRITTEN AUTHORIZATION FROM  
//              LEXMARK INTERNATIONAL, INC., IS STRICTLY PROHIBITED.           
//*****************************************************************************
//
//  CommonJS.js uses the Get methods provided by the JSW Proxy which access
//  the job information. The job data obtained will subsequently be used to
//  draw the controls.  CommonJS.js will also initiate callbacks into the 
//  BB controller to handle the user clicks on the JSW or BB.
//
//****************************************************************************

// Create an empty object
var CommonJS = new Object();

//
//	GetComObject
//		A method that initializes the ComGateway variable which will allow
// 		access to the Gateway COM object.
//
function GetComObject()
{
	CommonJS.ComGateway = window.external;
}

//
// GetJobName
//      A method that calls the COM object's GetJobName method.
//  Return:
//      jobName             The name of the job currently being processed.
//
CommonJS.GetJobName = function()
{
	var jobName;

	GetComObject();
	
	// See if ComGateway is valid
	if (CommonJS.ComGateway != null)
	{
	    jobName = CommonJS.ComGateway.GetJobName();
	}
	
	return jobName;
}

//
// GetFriendlyName
//      A method that calls the COM object's GetFriendlyName method.
//  Return:
//      friendlyName        The unique name of the printer object.
//
CommonJS.GetFriendlyName = function()
{
	var friendlyName;
	
	GetComObject();
	
	// See if ComGateway is valid
	if (CommonJS.ComGateway != null)
	{
	    friendlyName = CommonJS.ComGateway.GetFriendlyName();
	}
	
	return friendlyName;
}

//
// GetJobType
//      A method that calls the COM object's GetJobType method.
//  Return:
//      jobType             The type of job being processed.
//
CommonJS.GetJobType = function()
{
	var jobType;
	
	GetComObject();
	
	// See if ComGateway is valid
	if (CommonJS.ComGateway != null)
	{
	    jobType = CommonJS.ComGateway.GetJobType();
	}

	return jobType;
}

//
// GetCurrentPage
//      A method that calls the COM object's GetCurrentPage method.
//  Return:
//      currentPage         The current page being printed.
//
CommonJS.GetCurrentPage = function()
{
	var currentPage;
	
	GetComObject();
	
	// See if ComGateway is valid
	if (CommonJS.ComGateway != null)
	{
	    currentPage = CommonJS.ComGateway.GetCurrentPage();
	}
	
	return currentPage;
}

//
// GetLowContainers
//      A method that calls the COM object's GetLowContainers method.
//  Return:
//      lowContainers         A string of container names that have a low ink
//                            level.
//
CommonJS.GetLowContainers = function()
{
    var lowContainers = "";
    GetComObject();
    
    // See if ComGateway is valid
	if (CommonJS.ComGateway != null)
	{
	    lowContainers = CommonJS.ComGateway.GetLowContainers();
	}
	
	return lowContainers;
}

//
// GetVeryLowContainers
//      A method that calls the COM object's GetVeryLowContainers method.
//  Return:
//      vLowContainers        A string of container names that have a very low
//                            ink level.
//
CommonJS.GetVeryLowContainers = function()
{
    var vLowContainers = "";
    GetComObject();
    
    // See if ComGateway is valid
	if (CommonJS.ComGateway != null)
	{
	    vLowContainers = CommonJS.ComGateway.GetVeryLowContainers();
	}
	
	return vLowContainers;
}

//
// GetPartNums
//      A method that calls the COM object's GetPartNums method.
//  Return:
//      partNums         A string of the container positions (e.g. 3) along
//                       with that container's part number (e.g. 33).
//
CommonJS.GetPartNums = function()
{
    var partNums = "";
    GetComObject();
    
    // See if ComGateway is valid
	if (CommonJS.ComGateway != null)
	{
	    partNums = CommonJS.ComGateway.GetPartNums();
	}
	
	return partNums;
}

//
// GetTotalPages
//      A method that calls the COM object's GetTotalPages method.
//  Return:
//      totalPages          The total number of pages in the current print job.
//
CommonJS.GetTotalPages = function()
{
	var totalPages;
	GetComObject();
	
	// See if ComGateway is valid
	if (CommonJS.ComGateway != null)
	{
	    totalPages = CommonJS.ComGateway.GetTotalPages();
	}
	
	return totalPages;
}

//
// GetCurrentCopy
//      A method that calls the COM object's GetCurrentCopy method.
//  Return:
//      currentCopy         The current number of copies of the job being
//                          printed.
//
CommonJS.GetCurrentCopy = function()
{
	var currentCopy;
	
	GetComObject();
	
	// See if ComGateway is valid
	if (CommonJS.ComGateway != null)
	{
	    currentCopy = CommonJS.ComGateway.GetCurrentCopy();
	}
	
	return currentCopy;
}

//
// GetTotalCopies
//      A method that calls the COM object's GetTotalCopies method.
//  Return:
//      totalCopies         The total number of copies in the current print
//                          job.
//
CommonJS.GetTotalCopies = function()
{
	var totalCopies;
	
	GetComObject();
	
	// See if ComGateway is valid
	if (CommonJS.ComGateway != null)
	{
	    totalCopies = CommonJS.ComGateway.GetTotalCopies();
	}
	
	return totalCopies;
}

//
// GetProgressPercent
//      A method that calls the COM object's GetProgressPercent method.
//  Return:
//      progressPercent    The current position of progress bar
// 						    ranging from 0 to 100
//
CommonJS.GetProgressPercent = function()
{
	var progressPercent;
	
	GetComObject();

	// See if ComGateway is valid
	if (CommonJS.ComGateway != null)
	{
	    progressPercent = CommonJS.ComGateway.GetProgressPercent();
	}

	return progressPercent;
}

//
// GetPortType
//      A method that calls the COM object's GetPortType method.
//  Return:
//      portType            The port type
//
CommonJS.GetPortType = function()
{
	var portType;
	
	GetComObject();
	
	// See if ComGateway is valid
	if (CommonJS.ComGateway != null)
	{
	    portType = CommonJS.ComGateway.GetPortType();
	}
	
	return portType;
}

// GetInkImage
//  A method that calls the COM object's GetInkImage method.
//  Params:
//    tankID  The numerical index (zero based) of the tank to show an image for. 
//  Return:
//    The name of the image file that represents the specified tank, or an empty
//    string if no such tank exists.
CommonJS.GetInkImage = function(tankID)
{
    GetComObject();
    var img = "";
    
	// See if ComGateway is valid
	if (CommonJS.ComGateway != null)
	{
		img = CommonJS.ComGateway.GetInkImage(tankID);
	}
	
	return img;
}

// GetShowPageInfo
//  A method that calls the COM object's GetShowPageInfo method.
//  Return:
//    True, if the page info controls should be shown.
CommonJS.GetShowPageInfo = function()
{
    GetComObject();
  
    var show = true;
    
	// See if ComGateway is valid
	if (CommonJS.ComGateway != null)
	{
		show = CommonJS.ComGateway.GetShowPageInfo();
	}  
	return show;
}

// GetCapBlack
//  A method that calls the COM object's GetCapBlack method.
//  Return:
//    True, if the page info controls should be shown.
CommonJS.GetCAPBlack = function()
{
    GetComObject();
  
    var ret = false;
    
	// See if ComGateway is valid
	if (CommonJS.ComGateway != null)
	{
		ret = CommonJS.ComGateway.GetCAPBlack();
	}  
	return ret;
}

// GetCapColor
//  A method that calls the COM object's GetCAPColor method.
//  Return:
//    True, if the page info controls should be shown.
CommonJS.GetCAPColor = function()
{
    GetComObject();
  
    var ret = false;
    
	// See if ComGateway is valid
	if (CommonJS.ComGateway != null)
	{
		ret = CommonJS.ComGateway.GetCAPColor();
	}  
	return ret;
}

// GetShowOrderInk
//  A method that calls the COM object's GetShowOrderInk method.
//  Return:
//    True, if the Order Ink button should be shown.
CommonJS.GetShowOrderInk = function()
{
    GetComObject();
    var showBtn = true;
    
	// See if ComGateway is valid
	if (CommonJS.ComGateway != null)
	{
		showBtn = CommonJS.ComGateway.GetShowOrderInk();
	}
	
	return showBtn;
}

// GetEnableNavigation
//  A method that calls the COM object's GetBBEnableNavigation method.
//  Return:
//    True, if the navigation buttons should be enabled.
CommonJS.GetEnableNavigation = function()
{
	var enableNav = false;

	GetComObject();

	// See if ComGateway is valid
	if (CommonJS.ComGateway != null)
	{
		enableNav = CommonJS.ComGateway.GetBBEnableNavigation();
	}
	
	return enableNav;
}

//
// JSWAction
//      A method that calls the COM object's JSWAction method.
//  Param:
//      status      The JSW job status.   
//
CommonJS.JSWAction = function(
    status)
{
	GetComObject();
	
	// See if ComGateway is valid
	if (CommonJS.ComGateway != null)
	{
	    CommonJS.ComGateway.JSWAction(status);
	}
}

//
// BBAction
//      A method that calls the COM object's BBAction method.
//  Param:
//      action			The action applied to the billboard.
//      actionId      	The action ID.
//
CommonJS.BBAction = function(
    action,
    actionId)
{
	GetComObject();
	
	// See if ComGateway is valid
	if (CommonJS.ComGateway != null)
	{
	    CommonJS.ComGateway.BBAction(action, actionId);
	}
}

//
// UILoaded
//     A method that calls the COM object's UILoaded method. It is used to
//     indicate that the various frames have all finished loading.
//
CommonJS.UILoaded = function()
{
    GetComObject();
    
    // See if ComGateway is valid
    if (CommonJS.ComGateway != null)
    {
        CommonJS.ComGateway.UILoaded();
    }
}

//
// MouseButtonClick
//     A method that calls the COM objects MouseButtonClick method. It is used
//     to initiate the dragging of the window.
// 
CommonJS.MouseButtonClick = function()
{
	GetComObject();

	// See if ComGateway is valid
	if (CommonJS.ComGateway != null)
	{
		 CommonJS.ComGateway.MouseButtonClick();
	}
}

//
// ResizeWindow
//     A method that calls the COM objects ResizeWindow method. It is used to
//     initiate the dragging of the window.
//  Param:
//      dlgSize		The desired dialog size.
// 
CommonJS.ResizeWindow = function(
	dlgSize)
{
	GetComObject();

	// See if ComGateway is valid
	if (CommonJS.ComGateway != null)
	{
		 CommonJS.ComGateway.ResizeWindow(dlgSize);
	}
}

//
// GetNumInkContainers
//     A method that calls the COM objects GetNumInkContainers method. It is 
//     used to determine the number of ink tanks / carts on the device.
//  Return:
//      The number of tanks / carts the device holds.
// 
CommonJS.GetNumInkContainers = function()
{
	GetComObject();

    var numContainers = 0;
    
	// See if ComGateway is valid
	if (CommonJS.ComGateway != null)
	{
		 numContainers = CommonJS.ComGateway.GetNumInkContainers();
	}
	
	return numContainers;
}

// GetInkPartID
//  A method that calls the COM object's GetInkPartID method.
//  Params:
//    tankID  The numerical index (zero based) of the tank. 
//  Return:
//    An ID representing the name of the part number for the specified tank.
CommonJS.GetInkPartID = function(tankID)
{
    GetComObject();
    var name = "";
    
	// See if ComGateway is valid
	if (CommonJS.ComGateway != null)
	{
		name = CommonJS.ComGateway.GetInkPartID(tankID);
	}
	
	return name;
}

//
// DisplayBillboard
//      A method that requests that the GUI display the Billboard. The small
//      window will be displayed if a filename is not provided or does not
//      exist.
//
DisplayBillboard = function()
{
	var fileName;
	var enableNav;
	var defaultDlgSize = 0;    // mini dlg
	var expandedDlgSize = 1;	// mini dlg + banner

	GetComObject();

	// See if ComGateway is valid
	if (CommonJS.ComGateway != null)
	{
		fileName = CommonJS.ComGateway.GetBBFileName();
		enableNav = CommonJS.ComGateway.GetBBEnableNavigation();
	}

	// If the filename doesn't exist or is empty, show the small window.
	if ((fileName == null) || (fileName == ""))
	{
		// Show the mini dlg
		CommonJS.ResizeWindow(defaultDlgSize);
	}
	else
	{
		// Show the expanded dlg
		CommonJS.ResizeWindow(expandedDlgSize);

		BBNavigation(enableNav, fileName);
	}
}

//
// UpdateInfo
//      A method that updates page/copy information, print/copy progress,
//      page/copy counts and/or the progress bar.
UpdateInfo = function()
{
	GetComObject();
	
	// Make sure that ComGateway is valid
	if (CommonJS.ComGateway != null)
	{
        // Update controls on the JSWFrame
	    var jswframe = window.JSWFrame;
        jswframe.UpdateJSWInfo();
	}   
}

//
// BBNavigation
//      A method that mimics WebBrowser and enables/disables the arrow buttons
//  Param:
// 		enableNav		Flag that represents whether or not the buttons should
// 						be enabled.
//      nextBBScreen   	The name of the next Billboard screen that is to be
// 						displayed.
//
BBNavigation = function(
	enableNav,
	nextBBScreen)
{
	var jswframe = window.JSWFrame;
	var bbframe = window.BillBoardFrame;

    // Get the buttons
    var backButton = jswframe.document.getElementById("LeftArrow");
    var forwardButton = jswframe.document.getElementById("RightArrow");

	// Navigate to the BB screen
	bbframe.location = nextBBScreen;

	// Enable/Disable the buttons, but guard against the inability to locate
	// the fwd / back buttons. This situation may occur if DisplayBillboard is
	// called before jsw.xml is fully loaded. If this occurs, the button states
	// will be initialized by jsw.xml's onload handler instead.
	if((backButton != null) && (backButton.enable != null))
	{
	    backButton.enable(enableNav);
	}
	
	if((forwardButton != null) && (forwardButton.enable != null))
	{
	    forwardButton.enable(enableNav);
	}
}

//
// oldJSWBgColor
//      Storage for the original JSW background color. Should only be used by 
//      SetJSWBgColor and RestoreJSWBgColor.
//
var oldJSWBgColor = null;

//
// SetJSWBgColor
//      A method that changes the background color of the JSWFrame. Stores a 
//      backup copy of the original JSWFrame background color in oldJSWBgColor.
//  Param:
// 		color   The new background color. Must be a valid html color string, 
//              such as 'white' or '#FF0000'
//
function SetJSWBgColor(color)
{
    if(oldJSWBgColor == null)
    {
        oldJSWBgColor = window.JSWFrame.document.body.style.backgroundColor;
    }
    window.JSWFrame.document.body.style.backgroundColor = color;
}

//
// SetJSWBgColor
//      A method that restores the original background color of the JSWFrame. 
//
function RestoreJSWBgColor()
{
    if(oldJSWBgColor != null)
    {
        window.JSWFrame.document.body.style.backgroundColor = oldJSWBgColor;
    }
}

