<?xml version="1.0" encoding="iso-8859-1"?>
<!--                Copyright (c) 2008, Lexmark International, Inc.
        THIS IS AN UNPUBLISHED WORK CONTAINING CONFIDENTIAL AND PROPRIETARY
           INFORMATION WHICH IS THE PROPERTY OF LEXMARK INTERNATIONAL, INC.
      ANY DISCLOSURE, USE, OR REPRODUCTION, WITHOUT WRITTEN AUTHORIZATION FROM
                 LEXMARK INTERNATIONAL, INC., IS STRICTLY PROHIBITED
-->

<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
  <xsl:output method="html"/>
  
  <!--==========================================================================
  =  Localization 
  ===========================================================================-->

  <!-- Resource path -->
  <xsl:variable name="resPath" select="/deviceDashboard/resourcePath" />
  
  <!-- Variable holding the localization document. -->
  <xsl:variable name="local_doc" select="document(concat($resPath, 'strings.xml'))" />

  <!-- Callable template for replacing a stringID with a localized string.
       params:
         stringID   The ID of the localized string.
  -->
  <xsl:template name="InsertLocalizedString">
    <xsl:param name="stringID" />
    <xsl:for-each select="$local_doc">
      <xsl:value-of select="key('StringLookup', $stringID)" />
    </xsl:for-each>
  </xsl:template>

  <!-- Key for performing lookups on the string table -->
  <xsl:key name="StringLookup" match="StringTable/strings/string" use="@id" />

  <!-- readingOrder variable: should contain either 'rtl' or 'ltr' -->
  <xsl:variable name="readingOrder">
    <xsl:value-of select="$local_doc/StringTable/readingorder/@value"/>
  </xsl:variable>

  <!-- alignWithReadingOrder variable: left for ltr, right for rtl -->
  <xsl:variable name="alignWithReadingOrder">
    <xsl:if test="$readingOrder = 'ltr'">
      <xsl:text>left</xsl:text>
    </xsl:if>
    <xsl:if test="$readingOrder = 'rtl'">
      <xsl:text>right</xsl:text>
    </xsl:if>
  </xsl:variable>

  <!-- alignAgainstReadingOrder variable: right for ltr, left for rtl -->
  <xsl:variable name="alignAgainstReadingOrder">
    <xsl:if test="$readingOrder = 'ltr'">
      <xsl:text>right</xsl:text>
    </xsl:if>
    <xsl:if test="$readingOrder = 'rtl'">
      <xsl:text>left</xsl:text>
    </xsl:if>
  </xsl:variable>

  <!-- imagePath variable: dependent on readingOrder -->
  <xsl:variable name="imagePath">
    <xsl:text>Images/</xsl:text>
    <xsl:value-of select="$readingOrder"/>
    <xsl:text>/</xsl:text>
  </xsl:variable>
  
  <!--==========================================================================
  =  Screen generation 
  ===========================================================================-->
  
  <!-- Config XML structure -->
  <xsl:template match="/deviceDashboard">
    <!-- Set up the basic HTML structure -->
    <html>
      <head>
        <title>
          <xsl:call-template name="InsertLocalizedString">
            <xsl:with-param name="stringID">DocTitle</xsl:with-param>
          </xsl:call-template>
        </title>
        <base>
          <xsl:attribute name="href">
            <xsl:value-of select="$resPath"/>
          </xsl:attribute>
        </base>
        <link type="text/css" rel="StyleSheet" href="dashboard.css" />
        <script type="text/javascript" src="dashboard.js"></script>
      </head>
      <!-- Disable drag & drop -->
      <body ondragstart="javascript:return false;" onload="javascript:this.focus();">
        <!-- If an ogreIndex was specified, add an onload handler to show the 
             appropriate element. -->
        <xsl:if test="/deviceDashboard/ogreIndex">
          <xsl:attribute name="onload">
            <xsl:text>javascript:showOgreControl(</xsl:text>
            <xsl:value-of select="/deviceDashboard/ogreIndex"/>
            <xsl:text>);</xsl:text>
          </xsl:attribute>
        </xsl:if>
        <!-- Generate the actual layout -->
        <!-- Apply document level RTL / LTR -->
        <xsl:attribute name="dir">
          <xsl:value-of select="$readingOrder" />
        </xsl:attribute>
        <!-- Insert the header -->
        <xsl:apply-templates select="header"/>
        <!-- Insert the task areas -->
        <xsl:apply-templates select="content"/>
      </body>
    </html>
  </xsl:template>

  <!-- Header portion of the screen. -->
  <xsl:template match="header">
    <span class="header">
      <xsl:attribute name="style">
        <xsl:text>background-image:url(</xsl:text>
        <xsl:value-of select="$imagePath"/>
        <xsl:value-of select="@image"/>
        <xsl:text>);</xsl:text>
      </xsl:attribute>
    </span>
    <!-- Device image -->
    <span>
      <xsl:attribute name="class">
        <xsl:text>device-</xsl:text>
        <xsl:value-of select="$readingOrder" />
      </xsl:attribute>
      <img>
        <xsl:attribute name="src">
          <xsl:value-of select="$imagePath"/>
          <xsl:value-of select="../device/@image"/>
        </xsl:attribute>
      </img>
    </span>
    <!-- Printer list -->
    <span>
      <xsl:attribute name="class">
        <xsl:text>printer-</xsl:text>
        <xsl:value-of select="$readingOrder" />
      </xsl:attribute>
      <xsl:apply-templates select="../printerList" />
    </span>
    <!-- OEM logo image -->
    <span>
      <xsl:attribute name="class">
        <xsl:text>logo-</xsl:text>
        <xsl:value-of select="$readingOrder" />
      </xsl:attribute>
      <img>
        <xsl:attribute name="src">
          <xsl:value-of select="$imagePath"/>
          <xsl:value-of select="logo/@image"/>
        </xsl:attribute>
      </img>
    </span>
  </xsl:template>

  <!-- Generate a combo box from the printer list, including the selected item and all necessary 
       javascript hooks. -->
  <xsl:template match="printerList">
    <select class="printer-select">
      <xsl:attribute name="onchange">
        <xsl:text>javascript:onPrinterSelected(this.options[this.selectedIndex].id);</xsl:text>
      </xsl:attribute>
      <xsl:for-each select="printer">
        <option>
          <xsl:attribute name="id">
            <xsl:value-of select="@id"/>
          </xsl:attribute>
          <xsl:if test="@selected">
            <xsl:attribute name="selected" />
          </xsl:if>
          <xsl:if test="$readingOrder = 'rtl'">
            <xsl:text>&#x202A;</xsl:text>
          </xsl:if>
          <xsl:value-of select="@name"/>
        </option>
      </xsl:for-each>
    </select>
  </xsl:template>

  <!-- Content portion of the screen. Includes all tasks. -->
  <xsl:template match="content">
    <div class="content">
      <!-- Insert the primary task group (big buttons). -->
      <xsl:apply-templates mode="main-area" select="taskGroup[@priority=0]" />
      <!-- Vertical padding space. -->
      <div class="main-secondary-spacer"></div>
      <!-- Insert the secondary task groups (tabbed area). -->
      <table cellspacing="0" style="width:100%;">
        <tr class="tab-container" id="tab-container">
          <xsl:apply-templates mode="tab-headings" select="taskGroup[@priority=1]" />
          <td class="tab-filler">
            <div class="null-content"></div>
          </td>
        </tr>
        <tr>
          <td class="tab-body">
            <xsl:attribute name="colspan">
              <xsl:value-of select="count(taskGroup[@priority=1]) + 1"/>
            </xsl:attribute>
            <xsl:apply-templates mode="tab-bodies" select="taskGroup[@priority=1]" />
          </td>
        </tr>
      </table>
      <!-- Insert the tertiary task groups (footer area). -->
      <table class="footer" cellspacing="0" cellpadding="0">
        <xsl:apply-templates mode="footer" select="taskGroup[@priority=2]" />
      </table>
    </div>
  </xsl:template>

  <!-- Main task group area. -->
  <xsl:template match="taskGroup" mode="main-area">
    <!-- Title text & secondary tasks (links) -->
    <table class="main-title-row" cellspacing="0">
      <tr>
        <!-- Row that expands to fill available vertical space. This is a 
             workaround for bottom aligning the text-->
        <td style="height:100%"></td>
      </tr>
      <tr>
        <td style="vertical-align:baseline;">
          <span class="main-title">
            <nobr>
              <xsl:call-template name="InsertLocalizedString">
                <xsl:with-param name="stringID"><xsl:value-of select="@name"/></xsl:with-param>
              </xsl:call-template>
            </nobr>
          </span>
        </td>
        <td style="width:100%"></td>
        <xsl:apply-templates select="task[@priority=1]" mode="primary-group-task-link"/>      
      </tr>
    </table>
    <!-- Up to two rows of big buttons-->
    <table style="width:100%;" cellspacing="0">
      <tr>
        <xsl:apply-templates select="task[@priority=0] | taskGroup[@priority=0]" mode="task-button">
          <xsl:with-param name="row">0</xsl:with-param>
        </xsl:apply-templates>
      </tr>
      <tr class="rbb-vertical-separator">
        <td></td>
      </tr>
      <tr>
        <xsl:apply-templates select="task[@priority=0] | taskGroup[@priority=0]" mode="task-button">
          <xsl:with-param name="row">1</xsl:with-param>
        </xsl:apply-templates>
      </tr>
    </table>
  </xsl:template>

  <!-- Links for the upper right of the main task area.-->
  <xsl:template match="task" mode="primary-group-task-link">
    <td style="vertical-align:baseline;" class="primary-group-task-link">
      <nobr>
        <xsl:call-template name="task-link" />
      </nobr>
    </td>
    <!-- Spacer, placed after all but the last link -->
    <xsl:if test="position() != last()">
      <td style="vertical-align:text-bottom;">
        <div class="pgtl-separator"></div>
      </td>
    </xsl:if>
  </xsl:template>

  <!-- Task link, including javascript hooks and an optional icon. 
       params: 
         showIcon  'no' to hide the icon, anything else to show it. Defaults to 'no'
  -->
  <xsl:template name="task-link">
    <xsl:param name="showIcon">no</xsl:param>
    <a>
      <xsl:attribute name="href">
        <xsl:text>javascript:onTaskClick('</xsl:text>
        <xsl:value-of select="@id"/>
        <xsl:text>');</xsl:text>
      </xsl:attribute>
      <xsl:if test="$showIcon != 'no' and @image">
        <img>
          <xsl:attribute name="src">
            <xsl:value-of select="$imagePath"/>
            <xsl:value-of select="@image"/>
          </xsl:attribute>
          <xsl:attribute name="class">
            <xsl:text>task-link-image-</xsl:text><xsl:value-of select="$readingOrder"/>
          </xsl:attribute>
        </img>
      </xsl:if>
      <xsl:call-template name="InsertLocalizedString">
        <xsl:with-param name="stringID"><xsl:value-of select="@name"/></xsl:with-param>
      </xsl:call-template>
    </a>
  </xsl:template>

  <!-- A row of big buttons.
       params: 
         row          The current row number - used to calculate which tasks to show.
         tasksPerRow  The number of tasks to show per row. Defaults to 2.
  -->
  <xsl:template match="task | taskGroup" mode="task-button">
    <xsl:param name="row" />
    <xsl:param name="tasksPerRow">2</xsl:param>
    <xsl:variable name="min" select="$row * $tasksPerRow"/>
    <xsl:variable name="max" select="($row + 1) * $tasksPerRow"/>
    <xsl:if test="(position() &gt; $min) and (position() &lt;= $max)">
      <td class="rbb-column">
        <xsl:choose>
          <xsl:when test="name() = 'task'">
            <xsl:call-template name="task-button" />           
          </xsl:when>
          <xsl:otherwise>
            <xsl:call-template name="task-button">
              <xsl:with-param name="isMenu">yes</xsl:with-param>
            </xsl:call-template>
            <xsl:call-template name="menu" />
          </xsl:otherwise>
        </xsl:choose>
      </td>
      <!-- Spacer, placed after all but the last button -->
      <xsl:if test="position() != (($row + 1) * $tasksPerRow)">
        <td class="rbb-separator"></td>
      </xsl:if>
    </xsl:if>
  </xsl:template>

  <!-- A big button. Includes all javascript hooks for behavior.
       params: 
         isMenu   'no' indicates a task button, anything else indicates this is
                  a menu button. Defaults to 'no'
  -->
  <xsl:template name="task-button">
    <xsl:param name="isMenu">no</xsl:param>
    <button>
      <xsl:attribute name="class">
        <xsl:text>rbb </xsl:text>
        <!-- Add class 'text-rtl' or 'text-ltr' -->
        <xsl:value-of select="concat('text-', $readingOrder)"/>
        <xsl:if test="@enabled != 'true'">
          <xsl:text> rbb-disabled</xsl:text>
        </xsl:if>
      </xsl:attribute>
      <xsl:attribute name="style">
        <xsl:text>background-image:url(</xsl:text>
        <xsl:value-of select="$imagePath"/>
        <xsl:text>rbb324.jpg);</xsl:text>
      </xsl:attribute>
      <xsl:if test="@enabled != 'true'">
        <!-- Apply the 'disabled' attribute to prevent clicks and alter the 
             appearance of the button. -->
        <xsl:attribute name="disabled"/>
      </xsl:if>
      <xsl:attribute name="id">
        <xsl:value-of select="generate-id(.)"/>
      </xsl:attribute>
      <xsl:attribute name="onmouseover">
        <xsl:text>onRbbMouseOver('</xsl:text>
        <xsl:value-of select="generate-id(.)"/>
        <xsl:text>');</xsl:text>
      </xsl:attribute>
      <xsl:attribute name="onmouseout">
        <xsl:text>onRbbMouseOut('</xsl:text>
        <xsl:value-of select="generate-id(.)"/>
        <xsl:text>');</xsl:text>
      </xsl:attribute>
      <xsl:choose>
        <xsl:when test="$isMenu = 'no'">
          <!-- Regular buttons get the standard onTaskClick handler -->
          <xsl:attribute name="onclick">
            <xsl:text>javascript:onTaskClick('</xsl:text>
            <xsl:value-of select="@id"/>
            <xsl:text>');document.body.focus();</xsl:text>
          </xsl:attribute>
        </xsl:when>
        <xsl:otherwise>
          <!-- Menu buttons get the showMenu handler for click events -->
          <xsl:attribute name="onclick">
            <xsl:text>javascript:showMenu('</xsl:text>
            <xsl:value-of select="generate-id(.)"/>
            <xsl:text>');</xsl:text>
          </xsl:attribute>
          <!-- Menu buttons also get the drop down arrow -->
          <div>
            <xsl:attribute name="class">
              <xsl:value-of select="concat('arrow-', $readingOrder)"/>
            </xsl:attribute>
            <img>
              <xsl:attribute name="src">
                <xsl:value-of select="$imagePath"/>
                <xsl:text>dnarrow.jpg</xsl:text>
              </xsl:attribute>
            </img>
          </div>
          <!-- Register this menu button for use with Ogre -->
          <xsl:call-template name="ogre-registration">
            <xsl:with-param name="id" select="generate-id(.)"/>
            <xsl:with-param name="func_name">showMenu</xsl:with-param>
          </xsl:call-template>
        </xsl:otherwise>
      </xsl:choose>
      <img>
        <xsl:attribute name="class">
          <xsl:value-of select="$readingOrder"/>
        </xsl:attribute>
        <xsl:attribute name="src">
          <xsl:value-of select="$imagePath"/>
          <xsl:value-of select="@image"/>
        </xsl:attribute>
      </img>
      <nobr>
        <span>
          <xsl:call-template name="InsertLocalizedString">
            <xsl:with-param name="stringID"><xsl:value-of select="@name"/></xsl:with-param>
          </xsl:call-template>
        </span>
      </nobr>
      <small>
        <xsl:call-template name="InsertLocalizedString">
          <xsl:with-param name="stringID"><xsl:value-of select="@description"/></xsl:with-param>
        </xsl:call-template>
      </small>
    </button>
  </xsl:template>

  <!-- A menu, for use with the menu button variant of task-button. Menus and 
       menu buttons are connected by ID. Menu button ID's are a unique value 
       that has been autogenerated by the XSL parser. Menus use the same ID, 
       prefixed with 'menu'. 
        __________________________________________
       |           | Item 1                       |
       | Invisible | Item 2                       |
       |  Filler   | Item 3                       |
       |  Space    | etc ...                      |
       |___________|______________________________|      
  -->
  <xsl:template name="menu">
    <table cellspacing="0" cellpadding="0" class="menu-container">
      <xsl:variable name="menuId">
        <xsl:value-of select="concat('menu', generate-id(.))"/>
      </xsl:variable>
      <xsl:attribute name="id">
        <xsl:value-of select="$menuId"/>
      </xsl:attribute>
      <xsl:attribute name="onlosecapture">
        <xsl:text>javascript:onMenuCaptureLost('</xsl:text>
        <xsl:value-of select="$menuId"/>
        <xsl:text>');</xsl:text>        
      </xsl:attribute>
      <xsl:attribute name="onclick">
        <xsl:text>javascript:onMenuClick('</xsl:text>
        <xsl:value-of select="$menuId"/>
        <xsl:text>');</xsl:text>        
      </xsl:attribute>
      <tr>
        <td style="width:100%"></td>
        <td>
          <div class="menu">
            <table cellspacing="0" style="width:100%">
              <xsl:apply-templates select="task" mode="menu-item" />
            </table>
          </div>
        </td>
      </tr>
    </table>
  </xsl:template>

  <!-- A menu item 
        ____________________________________
       |     |                              | 
       | Pad | Item text                    |
       |_____|______________________________|      
  -->
  <xsl:template match="task" mode="menu-item">
    <tr class="menu-item">
      <xsl:attribute name="id">
        <xsl:value-of select="generate-id(.)"/>
      </xsl:attribute>
      <xsl:attribute name="onmouseover">
        <xsl:text>javascript:onMenuItemMouseOver('</xsl:text>
        <xsl:value-of select="generate-id(.)"/>
        <xsl:text>');</xsl:text>
      </xsl:attribute>
      <xsl:attribute name="onmouseout">
        <xsl:text>javascript:onMenuItemMouseOut('</xsl:text>
        <xsl:value-of select="generate-id(.)"/>
        <xsl:text>');</xsl:text>
      </xsl:attribute>
      <xsl:attribute name="onclick">
        <xsl:text>javascript:onTaskClick('</xsl:text>
        <xsl:value-of select="@id"/>
        <xsl:text>');document.body.focus();</xsl:text>
      </xsl:attribute>
      <td class="menu-item-icon menu-item-icon-inactive">
        <xsl:if test="@image">
          <img>
            <xsl:attribute name="src">
              <xsl:value-of select="$imagePath"/>
              <xsl:value-of select="@image"/>
            </xsl:attribute>
          </img>
        </xsl:if>
      </td>
      <td class="menu-item-text">
        <nobr>
          <xsl:call-template name="InsertLocalizedString">
            <xsl:with-param name="stringID"><xsl:value-of select="@name"/></xsl:with-param>
          </xsl:call-template>
        </nobr>
      </td>
    </tr>
  </xsl:template>
  
  <!-- Tab headers. Includes all javascript hooks for behavior. Tab headers and 
       tab bodies are connected by ID. Tab header ID's are a unique value that 
       has been autogenerated by the XSL parser. Tab bodies use the same ID, 
       prefixed with 'tab'. 
  -->
  <xsl:template match="taskGroup" mode="tab-headings">
    <td>
      <xsl:attribute name="class">
        <!-- Add class 'tab-rtl' or 'tab-ltr' -->
        <xsl:value-of select="concat('tab-', $readingOrder)"/>
        <xsl:if test="position() = 1">
          <xsl:text> tab-active</xsl:text>
        </xsl:if>
      </xsl:attribute>
      <xsl:attribute name="id">
        <xsl:value-of select="generate-id(.)"/>
      </xsl:attribute>
      <xsl:attribute name="onclick">
        <xsl:text>javascript:onTabClick('</xsl:text>
        <xsl:value-of select="generate-id(.)"/>
        <xsl:text>');</xsl:text>
      </xsl:attribute>
      <xsl:attribute name="onmouseover">
        <xsl:text>javascript:onTabMouseOver('</xsl:text>
        <xsl:value-of select="generate-id(.)"/>
        <xsl:text>');</xsl:text>
      </xsl:attribute>
      <xsl:attribute name="onmouseout">
        <xsl:text>javascript:onTabMouseOut('</xsl:text>
        <xsl:value-of select="generate-id(.)"/>
        <xsl:text>');</xsl:text>
      </xsl:attribute>
      <xsl:attribute name="href">
        <xsl:text>javascript:function(){ return true; }</xsl:text>
      </xsl:attribute>
      <nobr>
        <xsl:call-template name="InsertLocalizedString">
          <xsl:with-param name="stringID"><xsl:value-of select="@name"/></xsl:with-param>
        </xsl:call-template>
       </nobr>
    </td>
    <!-- Register this tab for use with Ogre -->
    <xsl:call-template name="ogre-registration">
      <xsl:with-param name="id" select="generate-id(.)"/>
      <xsl:with-param name="func_name">activateTab</xsl:with-param>
    </xsl:call-template>
  </xsl:template>

  <!-- Tab bodies. Contains up to two columns of links. Tab headers and 
       tab bodies are connected by ID. Tab header ID's are a unique value that 
       has been autogenerated by the XSL parser. Tab bodies use the same ID, 
       prefixed with 'tab'. -->
  <xsl:template match="taskGroup" mode="tab-bodies">
    <table cellspacing="0" cellpadding="0">
      <xsl:attribute name="id">
        <xsl:value-of select="concat('tab', generate-id(.))"/>
      </xsl:attribute>
      <xsl:if test="position() != 1">
        <xsl:attribute name="style">display:none</xsl:attribute>
      </xsl:if>
      <tr>
        <td class="link-column">
          <xsl:apply-templates select="task" mode="secondary-group-task-link">
            <xsl:with-param name="column">0</xsl:with-param>
          </xsl:apply-templates>
        </td>
        <td class="link-column-spacer"></td>
        <td class="link-column">
          <xsl:apply-templates select="task" mode="secondary-group-task-link">
            <xsl:with-param name="column">1</xsl:with-param>
          </xsl:apply-templates>
        </td>
      </tr>
    </table>
  </xsl:template>

  <!-- Column of links.
       params:
         column           The current column number - used to calculate which 
                          tasks to show.
         tasksPerColumn   The number of tasks to show per column. Defaults to 5.
  -->
  <xsl:template match="task" mode="secondary-group-task-link">
    <xsl:param name="column" />
    <xsl:param name="tasksPerColumn">5</xsl:param>
    <xsl:variable name="min" select="$column * $tasksPerColumn" />
    <xsl:variable name="max" select="($column + 1) * $tasksPerColumn" />
    <xsl:if test="(position() &gt; $min) and (position() &lt;= $max)">
      <xsl:call-template name="task-link" />
      <br />
    </xsl:if>
  </xsl:template>

  <!-- Footer group. -->
  <xsl:template match="taskGroup" mode="footer">
    <tr>
      <td>
        <xsl:attribute name="align">
          <xsl:value-of select="$alignWithReadingOrder"/>
        </xsl:attribute>
        <table cellspacing="0" cellpadding="0">
          <tr>
            <xsl:apply-templates select="task[@priority=0]" mode="footer-task" />
          </tr>
        </table>
      </td>
      <td>
        <xsl:attribute name="align">
          <xsl:value-of select="$alignAgainstReadingOrder"/>
        </xsl:attribute>
        <table cellspacing="0" cellpadding="0">
          <tr>
            <xsl:apply-templates select="task[@priority=1]" mode="footer-task" />
          </tr>
        </table>
      </td>
    </tr>
  </xsl:template>

  <!-- Footer task. Shows as a link w/ icon -->
  <xsl:template match="task" mode="footer-task">
    <td>
      <xsl:attribute name="class">
        <xsl:choose>
          <xsl:when test="@tasktype">
            <xsl:value-of select="@tasktype"/>
            <xsl:text>-</xsl:text>
            <xsl:value-of select="$readingOrder"/>
          </xsl:when>
          <xsl:otherwise>
            <xsl:text>footer-cell</xsl:text>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:attribute>
      <nobr>
        <xsl:call-template name="task-link">
          <xsl:with-param name="showIcon">yes</xsl:with-param>
        </xsl:call-template>
      </nobr>
    </td>
    <!-- Spacer, placed after all but the last link -->
    <xsl:if test="position() != last()">
      <td class="footer-cell-spacer"></td>
    </xsl:if>
  </xsl:template>

  <!-- Register a control ID for use with Ogre.
       params:
         id         The ID of the element to register
         func_name  The name of the function to register for that element.
  -->
  <xsl:template name="ogre-registration">
    <xsl:param name="id" />
    <xsl:param name="func_name" />
    <!-- Skip ogre registration if Ogre is not enabled -->
    <xsl:if test="/deviceDashboard/ogreIndex">
      <script type="text/javascript">
        <xsl:text>registerOgreControl('</xsl:text>
        <xsl:value-of select="$id"/>
        <xsl:text>', '</xsl:text>
        <xsl:value-of select="$func_name"/>
        <xsl:text>');</xsl:text>
      </script>
    </xsl:if>
  </xsl:template>
</xsl:stylesheet>