// created by jay 0.7 (c) 1998 Axel.Schreiner@informatik.uni-osnabrueck.de

#line 2 "cs-parser.jay"
//
// cs-parser.jay: The Parser for the C# compiler
//
// Authors: Miguel de Icaza (miguel@gnome.org)
//          Ravi Pratap     (ravi@ximian.com)
//          Marek Safar	    (marek.safar@gmail.com)
//
// Dual Licensed under the terms of the GNU GPL and the MIT X11 license
//
// (C) 2001 Ximian, Inc (http://www.ximian.com)
// (C) 2004-2011 Novell, Inc
// Copyright 2011 Xamarin Inc.
//
// TODO:
//   (1) Figure out why error productions dont work.  `type-declaration' is a
//       great spot to put an `error' because you can reproduce it with this input:
//	 "public X { }"
//

using System.Text;
using System.IO;
using System;
using System.Collections.Generic;

namespace Mono.CSharp
{
	/// <summary>
	///    The C# Parser
	/// </summary>
	public class CSharpParser
	{
		[Flags]
		enum ParameterModifierType
		{
			Ref		= 1 << 1,
			Out		= 1 << 2,
			This	= 1 << 3,
			Params	= 1 << 4,
			Arglist	= 1 << 5,
			DefaultValue = 1 << 6,
			
			All = Ref | Out | This | Params | Arglist | DefaultValue
		}
		
		static readonly object ModifierNone = 0;
	
		NamespaceContainer current_namespace;
		TypeContainer current_container;
		TypeDefinition current_type;
		PropertyBase current_property;
		EventProperty current_event;
		EventField current_event_field;
		FieldBase current_field;
	
		/// <summary>
		///   Current block is used to add statements as we find
		///   them.  
		/// </summary>
		Block      current_block;
		
		BlockVariableDeclaration current_variable;

		Delegate   current_delegate;
		
		AnonymousMethodExpression current_anonymous_method;

		/// <summary>
		///   This is used by the unary_expression code to resolve
		///   a name against a parameter.  
		/// </summary>
		
		// FIXME: This is very ugly and it's very hard to reset it correctly
		// on all places, especially when some parameters are autogenerated.
		ParametersCompiled current_local_parameters;

		bool parsing_anonymous_method;
		
		bool async_block;

		///
		/// An out-of-band stack.
		///
		static Stack<object> oob_stack;

		///
		/// Controls the verbosity of the errors produced by the parser
		///
		int yacc_verbose_flag;

		/// 
		/// Used by the interactive shell, flags whether EOF was reached
		/// and an error was produced
		///
		public bool UnexpectedEOF;

		///
		/// The current file.
		///
		readonly CompilationSourceFile file;

		///
		/// Temporary Xml documentation cache.
		/// For enum types, we need one more temporary store.
		///
		string tmpComment;
		string enumTypeComment;
	       		
		/// Current attribute target
		string current_attr_target;
		
		ParameterModifierType valid_param_mod;
		
		bool default_parameter_used;

		/// When using the interactive parser, this holds the
		/// resulting expression
		public Class InteractiveResult;

		//
		// Keeps track of global data changes to undo on parser error
		//
		public Undo undo;
		
		Stack<Linq.QueryBlock> linq_clause_blocks;

		ModuleContainer module;
		
		readonly CompilerContext compiler;
		readonly LanguageVersion lang_version;
		readonly bool doc_support;
		readonly CompilerSettings settings;
		readonly Report report;
		
		//
		// Instead of allocating carrier array everytime we
		// share the bucket for very common constructs which can never
		// be recursive
		//
		static List<Parameter> parameters_bucket = new List<Parameter> (6);
		
		//
		// Full AST support members
		//
		LocationsBag lbag;
		List<Tuple<Modifiers, Location>> mod_locations;
		Location parameterModifierLocation, savedLocation, savedOpenLocation, savedCloseLocation;
		Location savedAttrParenOpenLocation, savedAttrParenCloseLocation, savedOperatorLocation;
		Stack<List<Location>> locationListStack = new Stack<List<Location>> (); // used for type parameters
		Stack<Location> opt_intoStack = new Stack<Location> ();

		bool HadAttributeParens;
		List<Location> attributeCommas = new List<Location> ();
		List<Location> attributeArgumentCommas = new List<Location> ();
		List<Location> parameterListCommas = new List<Location> ();
#line default

  /** error output stream.
      It should be changeable.
    */
  public System.IO.TextWriter ErrorOutput = System.Console.Out;

  /** simplified error message.
      @see <a href="#yyerror(java.lang.String, java.lang.String[])">yyerror</a>
    */
  public void yyerror (string message) {
    yyerror(message, null);
  }

  /* An EOF token */
  public int eof_token;

  /** (syntax) error message.
      Can be overwritten to control message format.
      @param message text to be displayed.
      @param expected vector of acceptable tokens, if available.
    */
  public void yyerror (string message, string[] expected) {
    if ((yacc_verbose_flag > 0) && (expected != null) && (expected.Length  > 0)) {
      ErrorOutput.Write (message+", expecting");
      for (int n = 0; n < expected.Length; ++ n)
        ErrorOutput.Write (" "+expected[n]);
        ErrorOutput.WriteLine ();
    } else
      ErrorOutput.WriteLine (message);
  }

  /** debugging support, requires the package jay.yydebug.
      Set to null to suppress debugging messages.
    */
//t  internal yydebug.yyDebug debug;

  protected const int yyFinal = 7;
//t // Put this array into a separate class so it is only initialized if debugging is actually used
//t // Use MarshalByRefObject to disable inlining
//t class YYRules : MarshalByRefObject {
//t  public static readonly string [] yyRule = {
//t    "$accept : compilation_unit",
//t    "compilation_unit : outer_declaration opt_EOF",
//t    "$$1 :",
//t    "compilation_unit : interactive_parsing $$1 opt_EOF",
//t    "compilation_unit : documentation_parsing",
//t    "outer_declaration : opt_extern_alias_directives opt_using_directives",
//t    "outer_declaration : opt_extern_alias_directives opt_using_directives namespace_or_type_declarations opt_attributes",
//t    "outer_declaration : opt_extern_alias_directives opt_using_directives attribute_sections",
//t    "outer_declaration : error",
//t    "opt_EOF :",
//t    "opt_EOF : EOF",
//t    "extern_alias_directives : extern_alias_directive",
//t    "extern_alias_directives : extern_alias_directives extern_alias_directive",
//t    "extern_alias_directive : EXTERN_ALIAS IDENTIFIER IDENTIFIER SEMICOLON",
//t    "extern_alias_directive : EXTERN_ALIAS error",
//t    "using_directives : using_directive",
//t    "using_directives : using_directives using_directive",
//t    "using_directive : using_namespace",
//t    "using_namespace : USING namespace_or_type_expr SEMICOLON",
//t    "using_namespace : USING IDENTIFIER ASSIGN namespace_or_type_expr SEMICOLON",
//t    "using_namespace : USING error",
//t    "$$2 :",
//t    "$$3 :",
//t    "namespace_declaration : opt_attributes NAMESPACE namespace_name $$2 OPEN_BRACE $$3 opt_extern_alias_directives opt_using_directives opt_namespace_or_type_declarations CLOSE_BRACE opt_semicolon",
//t    "namespace_name : IDENTIFIER",
//t    "namespace_name : namespace_name DOT IDENTIFIER",
//t    "namespace_name : error",
//t    "opt_semicolon :",
//t    "opt_semicolon : SEMICOLON",
//t    "opt_comma :",
//t    "opt_comma : COMMA",
//t    "opt_using_directives :",
//t    "opt_using_directives : using_directives",
//t    "opt_extern_alias_directives :",
//t    "opt_extern_alias_directives : extern_alias_directives",
//t    "opt_namespace_or_type_declarations :",
//t    "opt_namespace_or_type_declarations : namespace_or_type_declarations",
//t    "namespace_or_type_declarations : namespace_or_type_declaration",
//t    "namespace_or_type_declarations : namespace_or_type_declarations namespace_or_type_declaration",
//t    "namespace_or_type_declaration : type_declaration",
//t    "namespace_or_type_declaration : namespace_declaration",
//t    "namespace_or_type_declaration : attribute_sections CLOSE_BRACE",
//t    "type_declaration : class_declaration",
//t    "type_declaration : struct_declaration",
//t    "type_declaration : interface_declaration",
//t    "type_declaration : enum_declaration",
//t    "type_declaration : delegate_declaration",
//t    "opt_attributes :",
//t    "opt_attributes : attribute_sections",
//t    "attribute_sections : attribute_section",
//t    "attribute_sections : attribute_sections attribute_section",
//t    "$$4 :",
//t    "attribute_section : OPEN_BRACKET $$4 attribute_section_cont",
//t    "$$5 :",
//t    "attribute_section_cont : attribute_target COLON $$5 attribute_list opt_comma CLOSE_BRACKET",
//t    "attribute_section_cont : attribute_list opt_comma CLOSE_BRACKET",
//t    "attribute_target : IDENTIFIER",
//t    "attribute_target : EVENT",
//t    "attribute_target : RETURN",
//t    "attribute_target : error",
//t    "attribute_list : attribute",
//t    "attribute_list : attribute_list COMMA attribute",
//t    "$$6 :",
//t    "attribute : attribute_name $$6 opt_attribute_arguments",
//t    "attribute_name : namespace_or_type_expr",
//t    "opt_attribute_arguments :",
//t    "opt_attribute_arguments : OPEN_PARENS attribute_arguments CLOSE_PARENS",
//t    "attribute_arguments :",
//t    "attribute_arguments : positional_or_named_argument",
//t    "attribute_arguments : named_attribute_argument",
//t    "attribute_arguments : attribute_arguments COMMA positional_or_named_argument",
//t    "attribute_arguments : attribute_arguments COMMA named_attribute_argument",
//t    "positional_or_named_argument : expression",
//t    "positional_or_named_argument : named_argument",
//t    "$$7 :",
//t    "named_attribute_argument : IDENTIFIER ASSIGN $$7 expression",
//t    "named_argument : identifier_inside_body COLON opt_named_modifier expression",
//t    "opt_named_modifier :",
//t    "opt_named_modifier : REF",
//t    "opt_named_modifier : OUT",
//t    "opt_class_member_declarations :",
//t    "opt_class_member_declarations : class_member_declarations",
//t    "class_member_declarations : class_member_declaration",
//t    "class_member_declarations : class_member_declarations class_member_declaration",
//t    "class_member_declaration : constant_declaration",
//t    "class_member_declaration : field_declaration",
//t    "class_member_declaration : method_declaration",
//t    "class_member_declaration : property_declaration",
//t    "class_member_declaration : event_declaration",
//t    "class_member_declaration : indexer_declaration",
//t    "class_member_declaration : operator_declaration",
//t    "class_member_declaration : constructor_declaration",
//t    "class_member_declaration : destructor_declaration",
//t    "class_member_declaration : type_declaration",
//t    "class_member_declaration : attributes_without_members",
//t    "class_member_declaration : error",
//t    "$$8 :",
//t    "$$9 :",
//t    "$$10 :",
//t    "$$11 :",
//t    "$$12 :",
//t    "struct_declaration : opt_attributes opt_modifiers opt_partial STRUCT $$8 type_declaration_name $$9 opt_class_base opt_type_parameter_constraints_clauses $$10 OPEN_BRACE $$11 opt_class_member_declarations CLOSE_BRACE $$12 opt_semicolon",
//t    "struct_declaration : opt_attributes opt_modifiers opt_partial STRUCT error",
//t    "$$13 :",
//t    "constant_declaration : opt_attributes opt_modifiers CONST type IDENTIFIER $$13 constant_initializer opt_constant_declarators SEMICOLON",
//t    "opt_constant_declarators :",
//t    "opt_constant_declarators : constant_declarators",
//t    "constant_declarators : constant_declarator",
//t    "constant_declarators : constant_declarators constant_declarator",
//t    "constant_declarator : COMMA IDENTIFIER constant_initializer",
//t    "$$14 :",
//t    "constant_initializer : ASSIGN $$14 constant_initializer_expr",
//t    "constant_initializer : error",
//t    "constant_initializer_expr : constant_expression",
//t    "constant_initializer_expr : array_initializer",
//t    "$$15 :",
//t    "field_declaration : opt_attributes opt_modifiers member_type IDENTIFIER $$15 opt_field_initializer opt_field_declarators SEMICOLON",
//t    "$$16 :",
//t    "field_declaration : opt_attributes opt_modifiers FIXED simple_type IDENTIFIER $$16 fixed_field_size opt_fixed_field_declarators SEMICOLON",
//t    "field_declaration : opt_attributes opt_modifiers FIXED simple_type error SEMICOLON",
//t    "opt_field_initializer :",
//t    "$$17 :",
//t    "opt_field_initializer : ASSIGN $$17 variable_initializer",
//t    "opt_field_declarators :",
//t    "opt_field_declarators : field_declarators",
//t    "field_declarators : field_declarator",
//t    "field_declarators : field_declarators field_declarator",
//t    "field_declarator : COMMA IDENTIFIER",
//t    "$$18 :",
//t    "field_declarator : COMMA IDENTIFIER ASSIGN $$18 variable_initializer",
//t    "opt_fixed_field_declarators :",
//t    "opt_fixed_field_declarators : fixed_field_declarators",
//t    "fixed_field_declarators : fixed_field_declarator",
//t    "fixed_field_declarators : fixed_field_declarators fixed_field_declarator",
//t    "fixed_field_declarator : COMMA IDENTIFIER fixed_field_size",
//t    "$$19 :",
//t    "fixed_field_size : OPEN_BRACKET $$19 expression CLOSE_BRACKET",
//t    "fixed_field_size : OPEN_BRACKET error",
//t    "variable_initializer : expression",
//t    "variable_initializer : array_initializer",
//t    "variable_initializer : error",
//t    "$$20 :",
//t    "method_declaration : method_header $$20 method_body",
//t    "$$21 :",
//t    "$$22 :",
//t    "method_header : opt_attributes opt_modifiers member_type method_declaration_name OPEN_PARENS $$21 opt_formal_parameter_list CLOSE_PARENS $$22 opt_type_parameter_constraints_clauses",
//t    "$$23 :",
//t    "$$24 :",
//t    "$$25 :",
//t    "method_header : opt_attributes opt_modifiers PARTIAL VOID $$23 method_declaration_name OPEN_PARENS $$24 opt_formal_parameter_list CLOSE_PARENS $$25 opt_type_parameter_constraints_clauses",
//t    "method_header : opt_attributes opt_modifiers member_type modifiers method_declaration_name OPEN_PARENS opt_formal_parameter_list CLOSE_PARENS",
//t    "method_header : opt_attributes opt_modifiers member_type method_declaration_name error",
//t    "method_body : block",
//t    "method_body : SEMICOLON",
//t    "opt_formal_parameter_list :",
//t    "opt_formal_parameter_list : formal_parameter_list",
//t    "formal_parameter_list : fixed_parameters",
//t    "formal_parameter_list : fixed_parameters COMMA parameter_array",
//t    "formal_parameter_list : fixed_parameters COMMA arglist_modifier",
//t    "formal_parameter_list : parameter_array COMMA error",
//t    "formal_parameter_list : fixed_parameters COMMA parameter_array COMMA error",
//t    "formal_parameter_list : arglist_modifier COMMA error",
//t    "formal_parameter_list : fixed_parameters COMMA ARGLIST COMMA error",
//t    "formal_parameter_list : parameter_array",
//t    "formal_parameter_list : arglist_modifier",
//t    "formal_parameter_list : error",
//t    "fixed_parameters : fixed_parameter",
//t    "fixed_parameters : fixed_parameters COMMA fixed_parameter",
//t    "fixed_parameter : opt_attributes opt_parameter_modifier parameter_type IDENTIFIER",
//t    "fixed_parameter : opt_attributes opt_parameter_modifier parameter_type IDENTIFIER OPEN_BRACKET CLOSE_BRACKET",
//t    "fixed_parameter : attribute_sections error",
//t    "fixed_parameter : opt_attributes opt_parameter_modifier parameter_type error",
//t    "$$26 :",
//t    "fixed_parameter : opt_attributes opt_parameter_modifier parameter_type IDENTIFIER ASSIGN $$26 constant_expression",
//t    "opt_parameter_modifier :",
//t    "opt_parameter_modifier : parameter_modifiers",
//t    "parameter_modifiers : parameter_modifier",
//t    "parameter_modifiers : parameter_modifiers parameter_modifier",
//t    "parameter_modifier : REF",
//t    "parameter_modifier : OUT",
//t    "parameter_modifier : THIS",
//t    "parameter_array : opt_attributes params_modifier type IDENTIFIER",
//t    "parameter_array : opt_attributes params_modifier type IDENTIFIER ASSIGN constant_expression",
//t    "parameter_array : opt_attributes params_modifier type error",
//t    "params_modifier : PARAMS",
//t    "params_modifier : PARAMS parameter_modifier",
//t    "params_modifier : PARAMS params_modifier",
//t    "arglist_modifier : ARGLIST",
//t    "$$27 :",
//t    "$$28 :",
//t    "$$29 :",
//t    "property_declaration : opt_attributes opt_modifiers member_type member_declaration_name $$27 OPEN_BRACE $$28 accessor_declarations $$29 CLOSE_BRACE",
//t    "$$30 :",
//t    "$$31 :",
//t    "$$32 :",
//t    "indexer_declaration : opt_attributes opt_modifiers member_type indexer_declaration_name OPEN_BRACKET $$30 opt_formal_parameter_list CLOSE_BRACKET OPEN_BRACE $$31 accessor_declarations $$32 CLOSE_BRACE",
//t    "accessor_declarations : get_accessor_declaration",
//t    "accessor_declarations : get_accessor_declaration accessor_declarations",
//t    "accessor_declarations : set_accessor_declaration",
//t    "accessor_declarations : set_accessor_declaration accessor_declarations",
//t    "accessor_declarations : error",
//t    "$$33 :",
//t    "get_accessor_declaration : opt_attributes opt_modifiers GET $$33 accessor_body",
//t    "$$34 :",
//t    "set_accessor_declaration : opt_attributes opt_modifiers SET $$34 accessor_body",
//t    "accessor_body : block",
//t    "accessor_body : SEMICOLON",
//t    "accessor_body : error",
//t    "$$35 :",
//t    "$$36 :",
//t    "$$37 :",
//t    "$$38 :",
//t    "interface_declaration : opt_attributes opt_modifiers opt_partial INTERFACE $$35 type_declaration_name $$36 opt_class_base opt_type_parameter_constraints_clauses $$37 OPEN_BRACE opt_interface_member_declarations CLOSE_BRACE $$38 opt_semicolon",
//t    "interface_declaration : opt_attributes opt_modifiers opt_partial INTERFACE error",
//t    "opt_interface_member_declarations :",
//t    "opt_interface_member_declarations : interface_member_declarations",
//t    "interface_member_declarations : interface_member_declaration",
//t    "interface_member_declarations : interface_member_declarations interface_member_declaration",
//t    "interface_member_declaration : constant_declaration",
//t    "interface_member_declaration : field_declaration",
//t    "interface_member_declaration : method_declaration",
//t    "interface_member_declaration : property_declaration",
//t    "interface_member_declaration : event_declaration",
//t    "interface_member_declaration : indexer_declaration",
//t    "interface_member_declaration : operator_declaration",
//t    "interface_member_declaration : constructor_declaration",
//t    "interface_member_declaration : type_declaration",
//t    "$$39 :",
//t    "operator_declaration : opt_attributes opt_modifiers operator_declarator $$39 operator_body",
//t    "operator_body : block",
//t    "operator_body : SEMICOLON",
//t    "operator_type : type_expression_or_array",
//t    "operator_type : VOID",
//t    "$$40 :",
//t    "operator_declarator : operator_type OPERATOR overloadable_operator OPEN_PARENS $$40 opt_formal_parameter_list CLOSE_PARENS",
//t    "operator_declarator : conversion_operator_declarator",
//t    "overloadable_operator : BANG",
//t    "overloadable_operator : TILDE",
//t    "overloadable_operator : OP_INC",
//t    "overloadable_operator : OP_DEC",
//t    "overloadable_operator : TRUE",
//t    "overloadable_operator : FALSE",
//t    "overloadable_operator : PLUS",
//t    "overloadable_operator : MINUS",
//t    "overloadable_operator : STAR",
//t    "overloadable_operator : DIV",
//t    "overloadable_operator : PERCENT",
//t    "overloadable_operator : BITWISE_AND",
//t    "overloadable_operator : BITWISE_OR",
//t    "overloadable_operator : CARRET",
//t    "overloadable_operator : OP_SHIFT_LEFT",
//t    "overloadable_operator : OP_SHIFT_RIGHT",
//t    "overloadable_operator : OP_EQ",
//t    "overloadable_operator : OP_NE",
//t    "overloadable_operator : OP_GT",
//t    "overloadable_operator : OP_LT",
//t    "overloadable_operator : OP_GE",
//t    "overloadable_operator : OP_LE",
//t    "$$41 :",
//t    "conversion_operator_declarator : IMPLICIT OPERATOR type OPEN_PARENS $$41 opt_formal_parameter_list CLOSE_PARENS",
//t    "$$42 :",
//t    "conversion_operator_declarator : EXPLICIT OPERATOR type OPEN_PARENS $$42 opt_formal_parameter_list CLOSE_PARENS",
//t    "conversion_operator_declarator : IMPLICIT error",
//t    "conversion_operator_declarator : EXPLICIT error",
//t    "constructor_declaration : constructor_declarator constructor_body",
//t    "$$43 :",
//t    "$$44 :",
//t    "constructor_declarator : opt_attributes opt_modifiers IDENTIFIER $$43 OPEN_PARENS opt_formal_parameter_list CLOSE_PARENS $$44 opt_constructor_initializer",
//t    "constructor_body : block_prepared",
//t    "constructor_body : SEMICOLON",
//t    "opt_constructor_initializer :",
//t    "opt_constructor_initializer : constructor_initializer",
//t    "$$45 :",
//t    "constructor_initializer : COLON BASE OPEN_PARENS $$45 opt_argument_list CLOSE_PARENS",
//t    "$$46 :",
//t    "constructor_initializer : COLON THIS OPEN_PARENS $$46 opt_argument_list CLOSE_PARENS",
//t    "constructor_initializer : COLON error",
//t    "constructor_initializer : error",
//t    "$$47 :",
//t    "destructor_declaration : opt_attributes opt_modifiers TILDE $$47 IDENTIFIER OPEN_PARENS CLOSE_PARENS method_body",
//t    "$$48 :",
//t    "event_declaration : opt_attributes opt_modifiers EVENT type member_declaration_name $$48 opt_event_initializer opt_event_declarators SEMICOLON",
//t    "$$49 :",
//t    "$$50 :",
//t    "event_declaration : opt_attributes opt_modifiers EVENT type member_declaration_name OPEN_BRACE $$49 event_accessor_declarations $$50 CLOSE_BRACE",
//t    "opt_event_initializer :",
//t    "$$51 :",
//t    "opt_event_initializer : ASSIGN $$51 event_variable_initializer",
//t    "opt_event_declarators :",
//t    "opt_event_declarators : event_declarators",
//t    "event_declarators : event_declarator",
//t    "event_declarators : event_declarators event_declarator",
//t    "event_declarator : COMMA IDENTIFIER",
//t    "$$52 :",
//t    "event_declarator : COMMA IDENTIFIER ASSIGN $$52 event_variable_initializer",
//t    "$$53 :",
//t    "event_variable_initializer : $$53 variable_initializer",
//t    "event_accessor_declarations : add_accessor_declaration remove_accessor_declaration",
//t    "event_accessor_declarations : remove_accessor_declaration add_accessor_declaration",
//t    "event_accessor_declarations : add_accessor_declaration",
//t    "event_accessor_declarations : remove_accessor_declaration",
//t    "event_accessor_declarations : error",
//t    "$$54 :",
//t    "add_accessor_declaration : opt_attributes opt_modifiers ADD $$54 event_accessor_block",
//t    "$$55 :",
//t    "remove_accessor_declaration : opt_attributes opt_modifiers REMOVE $$55 event_accessor_block",
//t    "event_accessor_block : opt_semicolon",
//t    "event_accessor_block : block",
//t    "attributes_without_members : attribute_sections CLOSE_BRACE",
//t    "$$56 :",
//t    "$$57 :",
//t    "$$58 :",
//t    "enum_declaration : opt_attributes opt_modifiers ENUM type_declaration_name opt_enum_base $$56 OPEN_BRACE $$57 opt_enum_member_declarations $$58 CLOSE_BRACE opt_semicolon",
//t    "opt_enum_base :",
//t    "opt_enum_base : COLON type",
//t    "opt_enum_base : COLON error",
//t    "opt_enum_member_declarations :",
//t    "opt_enum_member_declarations : enum_member_declarations",
//t    "opt_enum_member_declarations : enum_member_declarations COMMA",
//t    "enum_member_declarations : enum_member_declaration",
//t    "enum_member_declarations : enum_member_declarations COMMA enum_member_declaration",
//t    "enum_member_declaration : opt_attributes IDENTIFIER",
//t    "$$59 :",
//t    "enum_member_declaration : opt_attributes IDENTIFIER $$59 ASSIGN constant_expression",
//t    "$$60 :",
//t    "$$61 :",
//t    "$$62 :",
//t    "delegate_declaration : opt_attributes opt_modifiers DELEGATE member_type type_declaration_name OPEN_PARENS $$60 opt_formal_parameter_list CLOSE_PARENS $$61 opt_type_parameter_constraints_clauses $$62 SEMICOLON",
//t    "opt_nullable :",
//t    "opt_nullable : INTERR_NULLABLE",
//t    "namespace_or_type_expr : member_name",
//t    "namespace_or_type_expr : qualified_alias_member IDENTIFIER opt_type_argument_list",
//t    "member_name : simple_name_expr",
//t    "member_name : namespace_or_type_expr DOT IDENTIFIER opt_type_argument_list",
//t    "simple_name_expr : IDENTIFIER opt_type_argument_list",
//t    "opt_type_argument_list :",
//t    "opt_type_argument_list : OP_GENERICS_LT type_arguments OP_GENERICS_GT",
//t    "opt_type_argument_list : OP_GENERICS_LT error",
//t    "type_arguments : type",
//t    "type_arguments : type_arguments COMMA type",
//t    "$$63 :",
//t    "type_declaration_name : IDENTIFIER $$63 opt_type_parameter_list",
//t    "member_declaration_name : method_declaration_name",
//t    "method_declaration_name : type_declaration_name",
//t    "method_declaration_name : explicit_interface IDENTIFIER opt_type_parameter_list",
//t    "indexer_declaration_name : THIS",
//t    "indexer_declaration_name : explicit_interface THIS",
//t    "explicit_interface : IDENTIFIER opt_type_argument_list DOT",
//t    "explicit_interface : qualified_alias_member IDENTIFIER opt_type_argument_list DOT",
//t    "explicit_interface : explicit_interface IDENTIFIER opt_type_argument_list DOT",
//t    "opt_type_parameter_list :",
//t    "opt_type_parameter_list : OP_GENERICS_LT_DECL type_parameters OP_GENERICS_GT",
//t    "type_parameters : type_parameter",
//t    "type_parameters : type_parameters COMMA type_parameter",
//t    "type_parameter : opt_attributes opt_type_parameter_variance IDENTIFIER",
//t    "type_parameter : error",
//t    "type_and_void : type_expression_or_array",
//t    "type_and_void : VOID",
//t    "member_type : type_and_void",
//t    "type : type_expression_or_array",
//t    "type : VOID",
//t    "simple_type : type_expression",
//t    "simple_type : VOID",
//t    "parameter_type : type_expression_or_array",
//t    "parameter_type : VOID",
//t    "type_expression_or_array : type_expression",
//t    "type_expression_or_array : type_expression rank_specifiers",
//t    "type_expression : namespace_or_type_expr opt_nullable",
//t    "type_expression : namespace_or_type_expr pointer_stars",
//t    "type_expression : builtin_types opt_nullable",
//t    "type_expression : builtin_types pointer_stars",
//t    "type_expression : VOID pointer_stars",
//t    "type_list : base_type_name",
//t    "type_list : type_list COMMA base_type_name",
//t    "base_type_name : type",
//t    "builtin_types : OBJECT",
//t    "builtin_types : STRING",
//t    "builtin_types : BOOL",
//t    "builtin_types : DECIMAL",
//t    "builtin_types : FLOAT",
//t    "builtin_types : DOUBLE",
//t    "builtin_types : integral_type",
//t    "integral_type : SBYTE",
//t    "integral_type : BYTE",
//t    "integral_type : SHORT",
//t    "integral_type : USHORT",
//t    "integral_type : INT",
//t    "integral_type : UINT",
//t    "integral_type : LONG",
//t    "integral_type : ULONG",
//t    "integral_type : CHAR",
//t    "primary_expression : primary_expression_or_type",
//t    "primary_expression : literal",
//t    "primary_expression : array_creation_expression",
//t    "primary_expression : parenthesized_expression",
//t    "primary_expression : default_value_expression",
//t    "primary_expression : invocation_expression",
//t    "primary_expression : element_access",
//t    "primary_expression : this_access",
//t    "primary_expression : base_access",
//t    "primary_expression : post_increment_expression",
//t    "primary_expression : post_decrement_expression",
//t    "primary_expression : object_or_delegate_creation_expression",
//t    "primary_expression : anonymous_type_expression",
//t    "primary_expression : typeof_expression",
//t    "primary_expression : sizeof_expression",
//t    "primary_expression : checked_expression",
//t    "primary_expression : unchecked_expression",
//t    "primary_expression : pointer_member_access",
//t    "primary_expression : anonymous_method_expression",
//t    "primary_expression : undocumented_expressions",
//t    "primary_expression_or_type : IDENTIFIER opt_type_argument_list",
//t    "primary_expression_or_type : IDENTIFIER GENERATE_COMPLETION",
//t    "primary_expression_or_type : member_access",
//t    "literal : boolean_literal",
//t    "literal : LITERAL",
//t    "literal : NULL",
//t    "boolean_literal : TRUE",
//t    "boolean_literal : FALSE",
//t    "open_parens_any : OPEN_PARENS",
//t    "open_parens_any : OPEN_PARENS_CAST",
//t    "close_parens : CLOSE_PARENS",
//t    "close_parens : COMPLETE_COMPLETION",
//t    "parenthesized_expression : OPEN_PARENS expression CLOSE_PARENS",
//t    "parenthesized_expression : OPEN_PARENS expression COMPLETE_COMPLETION",
//t    "member_access : primary_expression DOT IDENTIFIER opt_type_argument_list",
//t    "member_access : builtin_types DOT IDENTIFIER opt_type_argument_list",
//t    "member_access : BASE DOT IDENTIFIER opt_type_argument_list",
//t    "member_access : qualified_alias_member IDENTIFIER opt_type_argument_list",
//t    "member_access : primary_expression DOT GENERATE_COMPLETION",
//t    "member_access : primary_expression DOT IDENTIFIER GENERATE_COMPLETION",
//t    "member_access : builtin_types DOT GENERATE_COMPLETION",
//t    "member_access : builtin_types DOT IDENTIFIER GENERATE_COMPLETION",
//t    "invocation_expression : primary_expression open_parens_any opt_argument_list close_parens",
//t    "opt_object_or_collection_initializer :",
//t    "opt_object_or_collection_initializer : object_or_collection_initializer",
//t    "object_or_collection_initializer : OPEN_BRACE opt_member_initializer_list close_brace_or_complete_completion",
//t    "object_or_collection_initializer : OPEN_BRACE member_initializer_list COMMA CLOSE_BRACE",
//t    "opt_member_initializer_list :",
//t    "opt_member_initializer_list : member_initializer_list",
//t    "member_initializer_list : member_initializer",
//t    "member_initializer_list : member_initializer_list COMMA member_initializer",
//t    "member_initializer_list : member_initializer_list error",
//t    "member_initializer : IDENTIFIER ASSIGN initializer_value",
//t    "member_initializer : GENERATE_COMPLETION",
//t    "member_initializer : non_assignment_expression opt_COMPLETE_COMPLETION",
//t    "member_initializer : OPEN_BRACE expression_list CLOSE_BRACE",
//t    "member_initializer : OPEN_BRACE CLOSE_BRACE",
//t    "initializer_value : expression",
//t    "initializer_value : object_or_collection_initializer",
//t    "opt_argument_list :",
//t    "opt_argument_list : argument_list",
//t    "argument_list : argument_or_named_argument",
//t    "argument_list : argument_list COMMA argument",
//t    "argument_list : argument_list COMMA named_argument",
//t    "argument_list : argument_list COMMA error",
//t    "argument_list : COMMA error",
//t    "argument : expression",
//t    "argument : non_simple_argument",
//t    "argument_or_named_argument : argument",
//t    "argument_or_named_argument : named_argument",
//t    "non_simple_argument : REF variable_reference",
//t    "non_simple_argument : OUT variable_reference",
//t    "non_simple_argument : ARGLIST OPEN_PARENS argument_list CLOSE_PARENS",
//t    "non_simple_argument : ARGLIST OPEN_PARENS CLOSE_PARENS",
//t    "variable_reference : expression",
//t    "element_access : primary_expression OPEN_BRACKET_EXPR expression_list_arguments CLOSE_BRACKET",
//t    "element_access : primary_expression OPEN_BRACKET_EXPR expression_list_arguments error",
//t    "element_access : primary_expression OPEN_BRACKET_EXPR error",
//t    "expression_list : expression",
//t    "expression_list : expression_list COMMA expression",
//t    "expression_list : expression_list error",
//t    "expression_list_arguments : expression_list_argument",
//t    "expression_list_arguments : expression_list_arguments COMMA expression_list_argument",
//t    "expression_list_argument : expression",
//t    "expression_list_argument : named_argument",
//t    "this_access : THIS",
//t    "base_access : BASE OPEN_BRACKET_EXPR expression_list_arguments CLOSE_BRACKET",
//t    "base_access : BASE OPEN_BRACKET error",
//t    "post_increment_expression : primary_expression OP_INC",
//t    "post_decrement_expression : primary_expression OP_DEC",
//t    "object_or_delegate_creation_expression : NEW new_expr_type open_parens_any opt_argument_list CLOSE_PARENS opt_object_or_collection_initializer",
//t    "object_or_delegate_creation_expression : NEW new_expr_type object_or_collection_initializer",
//t    "array_creation_expression : NEW new_expr_type OPEN_BRACKET_EXPR expression_list CLOSE_BRACKET opt_rank_specifier opt_array_initializer",
//t    "array_creation_expression : NEW new_expr_type rank_specifiers opt_array_initializer",
//t    "array_creation_expression : NEW rank_specifier array_initializer",
//t    "array_creation_expression : NEW new_expr_type OPEN_BRACKET CLOSE_BRACKET OPEN_BRACKET_EXPR error CLOSE_BRACKET",
//t    "array_creation_expression : NEW new_expr_type error",
//t    "$$64 :",
//t    "new_expr_type : $$64 simple_type",
//t    "anonymous_type_expression : NEW OPEN_BRACE anonymous_type_parameters_opt_comma CLOSE_BRACE",
//t    "anonymous_type_parameters_opt_comma : anonymous_type_parameters_opt",
//t    "anonymous_type_parameters_opt_comma : anonymous_type_parameters COMMA",
//t    "anonymous_type_parameters_opt :",
//t    "anonymous_type_parameters_opt : anonymous_type_parameters",
//t    "anonymous_type_parameters : anonymous_type_parameter",
//t    "anonymous_type_parameters : anonymous_type_parameters COMMA anonymous_type_parameter",
//t    "anonymous_type_parameter : IDENTIFIER ASSIGN variable_initializer",
//t    "anonymous_type_parameter : IDENTIFIER",
//t    "anonymous_type_parameter : member_access",
//t    "anonymous_type_parameter : error",
//t    "opt_rank_specifier :",
//t    "opt_rank_specifier : rank_specifiers",
//t    "rank_specifiers : rank_specifier",
//t    "rank_specifiers : rank_specifier rank_specifiers",
//t    "rank_specifier : OPEN_BRACKET CLOSE_BRACKET",
//t    "rank_specifier : OPEN_BRACKET dim_separators CLOSE_BRACKET",
//t    "dim_separators : COMMA",
//t    "dim_separators : dim_separators COMMA",
//t    "opt_array_initializer :",
//t    "opt_array_initializer : array_initializer",
//t    "array_initializer : OPEN_BRACE CLOSE_BRACE",
//t    "array_initializer : OPEN_BRACE variable_initializer_list opt_comma CLOSE_BRACE",
//t    "variable_initializer_list : variable_initializer",
//t    "variable_initializer_list : variable_initializer_list COMMA variable_initializer",
//t    "$$65 :",
//t    "typeof_expression : TYPEOF $$65 open_parens_any typeof_type_expression CLOSE_PARENS",
//t    "typeof_type_expression : type_and_void",
//t    "typeof_type_expression : unbound_type_name",
//t    "typeof_type_expression : error",
//t    "unbound_type_name : identifier_inside_body generic_dimension",
//t    "unbound_type_name : qualified_alias_member identifier_inside_body generic_dimension",
//t    "unbound_type_name : unbound_type_name DOT identifier_inside_body",
//t    "unbound_type_name : unbound_type_name DOT identifier_inside_body generic_dimension",
//t    "unbound_type_name : namespace_or_type_expr DOT identifier_inside_body generic_dimension",
//t    "generic_dimension : GENERIC_DIMENSION",
//t    "qualified_alias_member : IDENTIFIER DOUBLE_COLON",
//t    "sizeof_expression : SIZEOF open_parens_any type CLOSE_PARENS",
//t    "checked_expression : CHECKED open_parens_any expression CLOSE_PARENS",
//t    "unchecked_expression : UNCHECKED open_parens_any expression CLOSE_PARENS",
//t    "pointer_member_access : primary_expression OP_PTR IDENTIFIER opt_type_argument_list",
//t    "$$66 :",
//t    "anonymous_method_expression : DELEGATE opt_anonymous_method_signature $$66 block",
//t    "$$67 :",
//t    "anonymous_method_expression : ASYNC DELEGATE opt_anonymous_method_signature $$67 block",
//t    "opt_anonymous_method_signature :",
//t    "opt_anonymous_method_signature : anonymous_method_signature",
//t    "$$68 :",
//t    "anonymous_method_signature : OPEN_PARENS $$68 opt_formal_parameter_list CLOSE_PARENS",
//t    "default_value_expression : DEFAULT open_parens_any type CLOSE_PARENS",
//t    "unary_expression : primary_expression",
//t    "unary_expression : BANG prefixed_unary_expression",
//t    "unary_expression : TILDE prefixed_unary_expression",
//t    "unary_expression : OPEN_PARENS_CAST type CLOSE_PARENS prefixed_unary_expression",
//t    "unary_expression : AWAIT prefixed_unary_expression",
//t    "prefixed_unary_expression : unary_expression",
//t    "prefixed_unary_expression : PLUS prefixed_unary_expression",
//t    "prefixed_unary_expression : MINUS prefixed_unary_expression",
//t    "prefixed_unary_expression : OP_INC prefixed_unary_expression",
//t    "prefixed_unary_expression : OP_DEC prefixed_unary_expression",
//t    "prefixed_unary_expression : STAR prefixed_unary_expression",
//t    "prefixed_unary_expression : BITWISE_AND prefixed_unary_expression",
//t    "multiplicative_expression : prefixed_unary_expression",
//t    "multiplicative_expression : multiplicative_expression STAR prefixed_unary_expression",
//t    "multiplicative_expression : multiplicative_expression DIV prefixed_unary_expression",
//t    "multiplicative_expression : multiplicative_expression PERCENT prefixed_unary_expression",
//t    "additive_expression : multiplicative_expression",
//t    "additive_expression : additive_expression PLUS multiplicative_expression",
//t    "additive_expression : additive_expression MINUS multiplicative_expression",
//t    "additive_expression : parenthesized_expression MINUS multiplicative_expression",
//t    "additive_expression : additive_expression AS type",
//t    "additive_expression : additive_expression IS type",
//t    "shift_expression : additive_expression",
//t    "shift_expression : shift_expression OP_SHIFT_LEFT additive_expression",
//t    "shift_expression : shift_expression OP_SHIFT_RIGHT additive_expression",
//t    "relational_expression : shift_expression",
//t    "relational_expression : relational_expression OP_LT shift_expression",
//t    "relational_expression : relational_expression OP_GT shift_expression",
//t    "relational_expression : relational_expression OP_LE shift_expression",
//t    "relational_expression : relational_expression OP_GE shift_expression",
//t    "equality_expression : relational_expression",
//t    "equality_expression : equality_expression OP_EQ relational_expression",
//t    "equality_expression : equality_expression OP_NE relational_expression",
//t    "and_expression : equality_expression",
//t    "and_expression : and_expression BITWISE_AND equality_expression",
//t    "exclusive_or_expression : and_expression",
//t    "exclusive_or_expression : exclusive_or_expression CARRET and_expression",
//t    "inclusive_or_expression : exclusive_or_expression",
//t    "inclusive_or_expression : inclusive_or_expression BITWISE_OR exclusive_or_expression",
//t    "conditional_and_expression : inclusive_or_expression",
//t    "conditional_and_expression : conditional_and_expression OP_AND inclusive_or_expression",
//t    "conditional_or_expression : conditional_and_expression",
//t    "conditional_or_expression : conditional_or_expression OP_OR conditional_and_expression",
//t    "null_coalescing_expression : conditional_or_expression",
//t    "null_coalescing_expression : conditional_or_expression OP_COALESCING null_coalescing_expression",
//t    "conditional_expression : null_coalescing_expression",
//t    "conditional_expression : null_coalescing_expression INTERR expression COLON expression_or_error",
//t    "conditional_expression : null_coalescing_expression INTERR expression error",
//t    "assignment_expression : prefixed_unary_expression ASSIGN expression",
//t    "assignment_expression : prefixed_unary_expression OP_MULT_ASSIGN expression",
//t    "assignment_expression : prefixed_unary_expression OP_DIV_ASSIGN expression",
//t    "assignment_expression : prefixed_unary_expression OP_MOD_ASSIGN expression",
//t    "assignment_expression : prefixed_unary_expression OP_ADD_ASSIGN expression",
//t    "assignment_expression : prefixed_unary_expression OP_SUB_ASSIGN expression",
//t    "assignment_expression : prefixed_unary_expression OP_SHIFT_LEFT_ASSIGN expression",
//t    "assignment_expression : prefixed_unary_expression OP_SHIFT_RIGHT_ASSIGN expression",
//t    "assignment_expression : prefixed_unary_expression OP_AND_ASSIGN expression",
//t    "assignment_expression : prefixed_unary_expression OP_OR_ASSIGN expression",
//t    "assignment_expression : prefixed_unary_expression OP_XOR_ASSIGN expression",
//t    "lambda_parameter_list : lambda_parameter",
//t    "lambda_parameter_list : lambda_parameter_list COMMA lambda_parameter",
//t    "lambda_parameter : parameter_modifier parameter_type identifier_inside_body",
//t    "lambda_parameter : parameter_type identifier_inside_body",
//t    "lambda_parameter : IDENTIFIER",
//t    "opt_lambda_parameter_list :",
//t    "opt_lambda_parameter_list : lambda_parameter_list",
//t    "lambda_expression_body : lambda_expression_body_simple",
//t    "lambda_expression_body : block",
//t    "$$69 :",
//t    "lambda_expression_body_simple : $$69 expression_or_error",
//t    "expression_or_error : expression",
//t    "expression_or_error : error",
//t    "$$70 :",
//t    "lambda_expression : IDENTIFIER ARROW $$70 lambda_expression_body",
//t    "$$71 :",
//t    "lambda_expression : ASYNC identifier_inside_body ARROW $$71 lambda_expression_body",
//t    "$$72 :",
//t    "$$73 :",
//t    "lambda_expression : OPEN_PARENS_LAMBDA $$72 opt_lambda_parameter_list CLOSE_PARENS ARROW $$73 lambda_expression_body",
//t    "$$74 :",
//t    "$$75 :",
//t    "lambda_expression : ASYNC OPEN_PARENS_LAMBDA $$74 opt_lambda_parameter_list CLOSE_PARENS ARROW $$75 lambda_expression_body",
//t    "expression : assignment_expression",
//t    "expression : non_assignment_expression",
//t    "non_assignment_expression : conditional_expression",
//t    "non_assignment_expression : lambda_expression",
//t    "non_assignment_expression : query_expression",
//t    "non_assignment_expression : ARGLIST",
//t    "undocumented_expressions : REFVALUE OPEN_PARENS non_assignment_expression COMMA type CLOSE_PARENS",
//t    "undocumented_expressions : REFTYPE open_parens_any expression CLOSE_PARENS",
//t    "undocumented_expressions : MAKEREF open_parens_any expression CLOSE_PARENS",
//t    "constant_expression : expression",
//t    "boolean_expression : expression",
//t    "$$76 :",
//t    "$$77 :",
//t    "$$78 :",
//t    "$$79 :",
//t    "class_declaration : opt_attributes opt_modifiers opt_partial CLASS $$76 type_declaration_name $$77 opt_class_base opt_type_parameter_constraints_clauses $$78 OPEN_BRACE opt_class_member_declarations CLOSE_BRACE $$79 opt_semicolon",
//t    "opt_partial :",
//t    "opt_partial : PARTIAL",
//t    "opt_modifiers :",
//t    "opt_modifiers : modifiers",
//t    "modifiers : modifier",
//t    "modifiers : modifiers modifier",
//t    "modifier : NEW",
//t    "modifier : PUBLIC",
//t    "modifier : PROTECTED",
//t    "modifier : INTERNAL",
//t    "modifier : PRIVATE",
//t    "modifier : ABSTRACT",
//t    "modifier : SEALED",
//t    "modifier : STATIC",
//t    "modifier : READONLY",
//t    "modifier : VIRTUAL",
//t    "modifier : OVERRIDE",
//t    "modifier : EXTERN",
//t    "modifier : VOLATILE",
//t    "modifier : UNSAFE",
//t    "modifier : ASYNC",
//t    "opt_class_base :",
//t    "opt_class_base : COLON type_list",
//t    "opt_class_base : COLON type_list error",
//t    "opt_type_parameter_constraints_clauses :",
//t    "opt_type_parameter_constraints_clauses : type_parameter_constraints_clauses",
//t    "type_parameter_constraints_clauses : type_parameter_constraints_clause",
//t    "type_parameter_constraints_clauses : type_parameter_constraints_clauses type_parameter_constraints_clause",
//t    "type_parameter_constraints_clause : WHERE IDENTIFIER COLON type_parameter_constraints",
//t    "type_parameter_constraints_clause : WHERE IDENTIFIER error",
//t    "type_parameter_constraints : type_parameter_constraint",
//t    "type_parameter_constraints : type_parameter_constraints COMMA type_parameter_constraint",
//t    "type_parameter_constraint : type",
//t    "type_parameter_constraint : NEW OPEN_PARENS CLOSE_PARENS",
//t    "type_parameter_constraint : CLASS",
//t    "type_parameter_constraint : STRUCT",
//t    "opt_type_parameter_variance :",
//t    "opt_type_parameter_variance : type_parameter_variance",
//t    "type_parameter_variance : OUT",
//t    "type_parameter_variance : IN",
//t    "$$80 :",
//t    "block : OPEN_BRACE $$80 opt_statement_list block_end",
//t    "block_end : CLOSE_BRACE",
//t    "block_end : COMPLETE_COMPLETION",
//t    "$$81 :",
//t    "block_prepared : OPEN_BRACE $$81 opt_statement_list CLOSE_BRACE",
//t    "block_prepared : CLOSE_BRACE",
//t    "opt_statement_list :",
//t    "opt_statement_list : statement_list",
//t    "statement_list : statement",
//t    "statement_list : statement_list statement",
//t    "statement : block_variable_declaration",
//t    "statement : valid_declaration_statement",
//t    "statement : labeled_statement",
//t    "statement : IDENTIFIER error",
//t    "statement : error",
//t    "interactive_statement_list : interactive_statement",
//t    "interactive_statement_list : interactive_statement_list interactive_statement",
//t    "interactive_statement : block_variable_declaration",
//t    "interactive_statement : interactive_valid_declaration_statement",
//t    "interactive_statement : labeled_statement",
//t    "valid_declaration_statement : block",
//t    "valid_declaration_statement : empty_statement",
//t    "valid_declaration_statement : expression_statement",
//t    "valid_declaration_statement : selection_statement",
//t    "valid_declaration_statement : iteration_statement",
//t    "valid_declaration_statement : jump_statement",
//t    "valid_declaration_statement : try_statement",
//t    "valid_declaration_statement : checked_statement",
//t    "valid_declaration_statement : unchecked_statement",
//t    "valid_declaration_statement : lock_statement",
//t    "valid_declaration_statement : using_statement",
//t    "valid_declaration_statement : unsafe_statement",
//t    "valid_declaration_statement : fixed_statement",
//t    "interactive_valid_declaration_statement : block",
//t    "interactive_valid_declaration_statement : empty_statement",
//t    "interactive_valid_declaration_statement : interactive_expression_statement",
//t    "interactive_valid_declaration_statement : selection_statement",
//t    "interactive_valid_declaration_statement : iteration_statement",
//t    "interactive_valid_declaration_statement : jump_statement",
//t    "interactive_valid_declaration_statement : try_statement",
//t    "interactive_valid_declaration_statement : checked_statement",
//t    "interactive_valid_declaration_statement : unchecked_statement",
//t    "interactive_valid_declaration_statement : lock_statement",
//t    "interactive_valid_declaration_statement : using_statement",
//t    "interactive_valid_declaration_statement : unsafe_statement",
//t    "interactive_valid_declaration_statement : fixed_statement",
//t    "embedded_statement : valid_declaration_statement",
//t    "embedded_statement : block_variable_declaration",
//t    "embedded_statement : labeled_statement",
//t    "embedded_statement : error",
//t    "empty_statement : SEMICOLON",
//t    "$$82 :",
//t    "labeled_statement : identifier_inside_body COLON $$82 statement",
//t    "variable_type : variable_type_simple",
//t    "variable_type : variable_type_simple rank_specifiers",
//t    "variable_type_simple : primary_expression_or_type opt_nullable",
//t    "variable_type_simple : primary_expression_or_type pointer_stars",
//t    "variable_type_simple : builtin_types opt_nullable",
//t    "variable_type_simple : builtin_types pointer_stars",
//t    "variable_type_simple : VOID pointer_stars",
//t    "variable_type_simple : VOID",
//t    "pointer_stars : pointer_star",
//t    "pointer_stars : pointer_star pointer_stars",
//t    "pointer_star : STAR",
//t    "identifier_inside_body : IDENTIFIER",
//t    "identifier_inside_body : AWAIT",
//t    "$$83 :",
//t    "block_variable_declaration : variable_type identifier_inside_body $$83 opt_local_variable_initializer opt_variable_declarators semicolon_or_handle_error_close_brace",
//t    "$$84 :",
//t    "block_variable_declaration : CONST variable_type identifier_inside_body $$84 const_variable_initializer opt_const_declarators SEMICOLON",
//t    "semicolon_or_handle_error_close_brace : SEMICOLON",
//t    "semicolon_or_handle_error_close_brace : CLOSE_BRACE",
//t    "opt_local_variable_initializer :",
//t    "opt_local_variable_initializer : ASSIGN block_variable_initializer",
//t    "opt_local_variable_initializer : ASSIGN error",
//t    "opt_local_variable_initializer : error",
//t    "opt_variable_declarators :",
//t    "opt_variable_declarators : variable_declarators",
//t    "opt_using_or_fixed_variable_declarators :",
//t    "opt_using_or_fixed_variable_declarators : variable_declarators",
//t    "variable_declarators : variable_declarator",
//t    "variable_declarators : variable_declarators variable_declarator",
//t    "variable_declarator : COMMA identifier_inside_body",
//t    "variable_declarator : COMMA identifier_inside_body ASSIGN block_variable_initializer",
//t    "const_variable_initializer :",
//t    "const_variable_initializer : ASSIGN constant_initializer_expr",
//t    "opt_const_declarators :",
//t    "opt_const_declarators : const_declarators",
//t    "const_declarators : const_declarator",
//t    "const_declarators : const_declarators const_declarator",
//t    "const_declarator : COMMA identifier_inside_body ASSIGN constant_initializer_expr",
//t    "block_variable_initializer : variable_initializer",
//t    "block_variable_initializer : STACKALLOC simple_type OPEN_BRACKET_EXPR expression CLOSE_BRACKET",
//t    "block_variable_initializer : STACKALLOC simple_type",
//t    "expression_statement : statement_expression SEMICOLON",
//t    "expression_statement : statement_expression COMPLETE_COMPLETION",
//t    "expression_statement : statement_expression CLOSE_BRACE",
//t    "interactive_expression_statement : interactive_statement_expression SEMICOLON",
//t    "interactive_expression_statement : interactive_statement_expression COMPLETE_COMPLETION",
//t    "statement_expression : expression",
//t    "interactive_statement_expression : expression",
//t    "interactive_statement_expression : error",
//t    "selection_statement : if_statement",
//t    "selection_statement : switch_statement",
//t    "if_statement : IF open_parens_any boolean_expression CLOSE_PARENS embedded_statement",
//t    "if_statement : IF open_parens_any boolean_expression CLOSE_PARENS embedded_statement ELSE embedded_statement",
//t    "if_statement : IF open_parens_any boolean_expression error",
//t    "$$85 :",
//t    "switch_statement : SWITCH open_parens_any expression CLOSE_PARENS OPEN_BRACE $$85 opt_switch_sections CLOSE_BRACE",
//t    "switch_statement : SWITCH open_parens_any expression error",
//t    "opt_switch_sections :",
//t    "opt_switch_sections : switch_sections",
//t    "switch_sections : switch_section",
//t    "switch_sections : switch_sections switch_section",
//t    "switch_sections : error",
//t    "$$86 :",
//t    "switch_section : switch_labels $$86 statement_list",
//t    "switch_labels : switch_label",
//t    "switch_labels : switch_labels switch_label",
//t    "switch_label : CASE constant_expression COLON",
//t    "switch_label : CASE constant_expression error",
//t    "switch_label : DEFAULT_COLON",
//t    "iteration_statement : while_statement",
//t    "iteration_statement : do_statement",
//t    "iteration_statement : for_statement",
//t    "iteration_statement : foreach_statement",
//t    "while_statement : WHILE open_parens_any boolean_expression CLOSE_PARENS embedded_statement",
//t    "while_statement : WHILE open_parens_any boolean_expression error",
//t    "do_statement : DO embedded_statement WHILE open_parens_any boolean_expression CLOSE_PARENS SEMICOLON",
//t    "do_statement : DO embedded_statement error",
//t    "do_statement : DO embedded_statement WHILE open_parens_any boolean_expression error",
//t    "$$87 :",
//t    "for_statement : FOR open_parens_any $$87 for_statement_cont",
//t    "$$88 :",
//t    "for_statement_cont : opt_for_initializer SEMICOLON $$88 for_statement_condition",
//t    "for_statement_cont : opt_for_initializer CLOSE_PARENS",
//t    "$$89 :",
//t    "for_statement_condition : opt_for_condition SEMICOLON $$89 for_statement_end",
//t    "for_statement_condition : boolean_expression CLOSE_PARENS",
//t    "for_statement_end : opt_for_iterator CLOSE_PARENS embedded_statement",
//t    "for_statement_end : error",
//t    "opt_for_initializer :",
//t    "opt_for_initializer : for_initializer",
//t    "$$90 :",
//t    "for_initializer : variable_type identifier_inside_body $$90 opt_local_variable_initializer opt_variable_declarators",
//t    "for_initializer : statement_expression_list",
//t    "opt_for_condition :",
//t    "opt_for_condition : boolean_expression",
//t    "opt_for_iterator :",
//t    "opt_for_iterator : for_iterator",
//t    "for_iterator : statement_expression_list",
//t    "statement_expression_list : statement_expression",
//t    "statement_expression_list : statement_expression_list COMMA statement_expression",
//t    "foreach_statement : FOREACH open_parens_any type error",
//t    "foreach_statement : FOREACH open_parens_any type identifier_inside_body error",
//t    "$$91 :",
//t    "foreach_statement : FOREACH open_parens_any type identifier_inside_body IN expression CLOSE_PARENS $$91 embedded_statement",
//t    "foreach_statement : FOREACH open_parens_any type identifier_inside_body error",
//t    "foreach_statement : FOREACH open_parens_any type error",
//t    "jump_statement : break_statement",
//t    "jump_statement : continue_statement",
//t    "jump_statement : goto_statement",
//t    "jump_statement : return_statement",
//t    "jump_statement : throw_statement",
//t    "jump_statement : yield_statement",
//t    "break_statement : BREAK SEMICOLON",
//t    "continue_statement : CONTINUE SEMICOLON",
//t    "continue_statement : CONTINUE error",
//t    "goto_statement : GOTO identifier_inside_body SEMICOLON",
//t    "goto_statement : GOTO CASE constant_expression SEMICOLON",
//t    "goto_statement : GOTO DEFAULT SEMICOLON",
//t    "return_statement : RETURN opt_expression SEMICOLON",
//t    "return_statement : RETURN error",
//t    "throw_statement : THROW opt_expression SEMICOLON",
//t    "throw_statement : THROW error",
//t    "yield_statement : identifier_inside_body RETURN opt_expression SEMICOLON",
//t    "yield_statement : identifier_inside_body BREAK SEMICOLON",
//t    "opt_expression :",
//t    "opt_expression : expression",
//t    "try_statement : TRY block catch_clauses",
//t    "try_statement : TRY block FINALLY block",
//t    "try_statement : TRY block catch_clauses FINALLY block",
//t    "try_statement : TRY block error",
//t    "catch_clauses : catch_clause",
//t    "catch_clauses : catch_clauses catch_clause",
//t    "opt_identifier :",
//t    "opt_identifier : identifier_inside_body",
//t    "catch_clause : CATCH block",
//t    "$$92 :",
//t    "catch_clause : CATCH open_parens_any type opt_identifier CLOSE_PARENS $$92 block_prepared",
//t    "catch_clause : CATCH open_parens_any error",
//t    "checked_statement : CHECKED block",
//t    "unchecked_statement : UNCHECKED block",
//t    "$$93 :",
//t    "unsafe_statement : UNSAFE $$93 block",
//t    "lock_statement : LOCK open_parens_any expression CLOSE_PARENS embedded_statement",
//t    "lock_statement : LOCK open_parens_any expression error",
//t    "$$94 :",
//t    "$$95 :",
//t    "fixed_statement : FIXED open_parens_any variable_type identifier_inside_body $$94 using_or_fixed_variable_initializer opt_using_or_fixed_variable_declarators CLOSE_PARENS $$95 embedded_statement",
//t    "$$96 :",
//t    "$$97 :",
//t    "using_statement : USING open_parens_any variable_type identifier_inside_body $$96 using_initialization CLOSE_PARENS $$97 embedded_statement",
//t    "using_statement : USING open_parens_any expression CLOSE_PARENS embedded_statement",
//t    "using_statement : USING open_parens_any expression error",
//t    "using_initialization : using_or_fixed_variable_initializer opt_using_or_fixed_variable_declarators",
//t    "using_initialization : error",
//t    "using_or_fixed_variable_initializer :",
//t    "using_or_fixed_variable_initializer : ASSIGN variable_initializer",
//t    "query_expression : first_from_clause query_body",
//t    "query_expression : nested_from_clause query_body",
//t    "query_expression : first_from_clause COMPLETE_COMPLETION",
//t    "query_expression : nested_from_clause COMPLETE_COMPLETION",
//t    "first_from_clause : FROM_FIRST identifier_inside_body IN expression",
//t    "first_from_clause : FROM_FIRST type identifier_inside_body IN expression",
//t    "nested_from_clause : FROM identifier_inside_body IN expression",
//t    "nested_from_clause : FROM type identifier_inside_body IN expression",
//t    "$$98 :",
//t    "from_clause : FROM identifier_inside_body IN $$98 expression_or_error",
//t    "$$99 :",
//t    "from_clause : FROM type identifier_inside_body IN $$99 expression_or_error",
//t    "query_body : query_body_clauses select_or_group_clause opt_query_continuation",
//t    "query_body : select_or_group_clause opt_query_continuation",
//t    "query_body : query_body_clauses COMPLETE_COMPLETION",
//t    "query_body : query_body_clauses error",
//t    "query_body : error",
//t    "$$100 :",
//t    "select_or_group_clause : SELECT $$100 expression_or_error",
//t    "$$101 :",
//t    "$$102 :",
//t    "select_or_group_clause : GROUP $$101 expression_or_error $$102 BY expression_or_error",
//t    "query_body_clauses : query_body_clause",
//t    "query_body_clauses : query_body_clauses query_body_clause",
//t    "query_body_clause : from_clause",
//t    "query_body_clause : let_clause",
//t    "query_body_clause : where_clause",
//t    "query_body_clause : join_clause",
//t    "query_body_clause : orderby_clause",
//t    "$$103 :",
//t    "let_clause : LET identifier_inside_body ASSIGN $$103 expression_or_error",
//t    "$$104 :",
//t    "where_clause : WHERE $$104 expression_or_error",
//t    "$$105 :",
//t    "$$106 :",
//t    "$$107 :",
//t    "join_clause : JOIN identifier_inside_body IN $$105 expression_or_error ON $$106 expression_or_error EQUALS $$107 expression_or_error opt_join_into",
//t    "$$108 :",
//t    "$$109 :",
//t    "$$110 :",
//t    "join_clause : JOIN type identifier_inside_body IN $$108 expression_or_error ON $$109 expression_or_error EQUALS $$110 expression_or_error opt_join_into",
//t    "opt_join_into :",
//t    "opt_join_into : INTO identifier_inside_body",
//t    "$$111 :",
//t    "orderby_clause : ORDERBY $$111 orderings",
//t    "orderings : order_by",
//t    "$$112 :",
//t    "orderings : order_by COMMA $$112 orderings_then_by",
//t    "orderings_then_by : then_by",
//t    "$$113 :",
//t    "orderings_then_by : orderings_then_by COMMA $$113 then_by",
//t    "order_by : expression",
//t    "order_by : expression ASCENDING",
//t    "order_by : expression DESCENDING",
//t    "then_by : expression",
//t    "then_by : expression ASCENDING",
//t    "then_by : expression DESCENDING",
//t    "opt_query_continuation :",
//t    "$$114 :",
//t    "opt_query_continuation : INTO identifier_inside_body $$114 query_body",
//t    "interactive_parsing : EVAL_STATEMENT_PARSER EOF",
//t    "interactive_parsing : EVAL_USING_DECLARATIONS_UNIT_PARSER using_directives opt_COMPLETE_COMPLETION",
//t    "$$115 :",
//t    "interactive_parsing : EVAL_STATEMENT_PARSER $$115 interactive_statement_list opt_COMPLETE_COMPLETION",
//t    "interactive_parsing : EVAL_COMPILATION_UNIT_PARSER interactive_compilation_unit",
//t    "interactive_compilation_unit : opt_extern_alias_directives opt_using_directives",
//t    "interactive_compilation_unit : opt_extern_alias_directives opt_using_directives namespace_or_type_declarations",
//t    "opt_COMPLETE_COMPLETION :",
//t    "opt_COMPLETE_COMPLETION : COMPLETE_COMPLETION",
//t    "close_brace_or_complete_completion : CLOSE_BRACE",
//t    "close_brace_or_complete_completion : COMPLETE_COMPLETION",
//t    "documentation_parsing : DOC_SEE doc_cref",
//t    "doc_cref : doc_type_declaration_name opt_doc_method_sig",
//t    "doc_cref : builtin_types opt_doc_method_sig",
//t    "doc_cref : builtin_types DOT IDENTIFIER opt_doc_method_sig",
//t    "doc_cref : doc_type_declaration_name DOT THIS",
//t    "$$116 :",
//t    "doc_cref : doc_type_declaration_name DOT THIS OPEN_BRACKET $$116 opt_doc_parameters CLOSE_BRACKET",
//t    "doc_cref : EXPLICIT OPERATOR type opt_doc_method_sig",
//t    "doc_cref : IMPLICIT OPERATOR type opt_doc_method_sig",
//t    "doc_cref : OPERATOR overloadable_operator opt_doc_method_sig",
//t    "doc_type_declaration_name : type_declaration_name",
//t    "doc_type_declaration_name : doc_type_declaration_name DOT type_declaration_name",
//t    "opt_doc_method_sig :",
//t    "$$117 :",
//t    "opt_doc_method_sig : OPEN_PARENS $$117 opt_doc_parameters CLOSE_PARENS",
//t    "opt_doc_parameters :",
//t    "opt_doc_parameters : doc_parameters",
//t    "doc_parameters : doc_parameter",
//t    "doc_parameters : doc_parameters COMMA doc_parameter",
//t    "doc_parameter : opt_parameter_modifier parameter_type",
//t  };
//t public static string getRule (int index) {
//t    return yyRule [index];
//t }
//t}
  protected static readonly string [] yyNames = {    
    "end-of-file",null,null,null,null,null,null,null,null,null,null,null,
    null,null,null,null,null,null,null,null,null,null,null,null,null,null,
    null,null,null,null,null,null,null,null,null,null,null,null,null,null,
    null,null,null,null,null,null,null,null,null,null,null,null,null,null,
    null,null,null,null,null,null,null,null,null,null,null,null,null,null,
    null,null,null,null,null,null,null,null,null,null,null,null,null,null,
    null,null,null,null,null,null,null,null,null,null,null,null,null,null,
    null,null,null,null,null,null,null,null,null,null,null,null,null,null,
    null,null,null,null,null,null,null,null,null,null,null,null,null,null,
    null,null,null,null,null,null,null,null,null,null,null,null,null,null,
    null,null,null,null,null,null,null,null,null,null,null,null,null,null,
    null,null,null,null,null,null,null,null,null,null,null,null,null,null,
    null,null,null,null,null,null,null,null,null,null,null,null,null,null,
    null,null,null,null,null,null,null,null,null,null,null,null,null,null,
    null,null,null,null,null,null,null,null,null,null,null,null,null,null,
    null,null,null,null,null,null,null,null,null,null,null,null,null,null,
    null,null,null,null,null,null,null,null,null,null,null,null,null,null,
    null,null,null,null,null,null,null,null,null,null,null,null,null,null,
    null,null,null,null,null,null,null,"EOF","NONE","ERROR",
    "FIRST_KEYWORD","ABSTRACT","AS","ADD","BASE","BOOL","BREAK","BYTE",
    "CASE","CATCH","CHAR","CHECKED","CLASS","CONST","CONTINUE","DECIMAL",
    "DEFAULT","DELEGATE","DO","DOUBLE","ELSE","ENUM","EVENT","EXPLICIT",
    "EXTERN","FALSE","FINALLY","FIXED","FLOAT","FOR","FOREACH","GOTO",
    "IF","IMPLICIT","IN","INT","INTERFACE","INTERNAL","IS","LOCK","LONG",
    "NAMESPACE","NEW","NULL","OBJECT","OPERATOR","OUT","OVERRIDE",
    "PARAMS","PRIVATE","PROTECTED","PUBLIC","READONLY","REF","RETURN",
    "REMOVE","SBYTE","SEALED","SHORT","SIZEOF","STACKALLOC","STATIC",
    "STRING","STRUCT","SWITCH","THIS","THROW","TRUE","TRY","TYPEOF",
    "UINT","ULONG","UNCHECKED","UNSAFE","USHORT","USING","VIRTUAL","VOID",
    "VOLATILE","WHERE","WHILE","ARGLIST","PARTIAL","ARROW","FROM",
    "FROM_FIRST","JOIN","ON","EQUALS","SELECT","GROUP","BY","LET",
    "ORDERBY","ASCENDING","DESCENDING","INTO","INTERR_NULLABLE",
    "EXTERN_ALIAS","REFVALUE","REFTYPE","MAKEREF","ASYNC","AWAIT","GET",
    "SET","LAST_KEYWORD","OPEN_BRACE","CLOSE_BRACE","OPEN_BRACKET",
    "CLOSE_BRACKET","OPEN_PARENS","CLOSE_PARENS","DOT","COMMA","COLON",
    "SEMICOLON","TILDE","PLUS","MINUS","BANG","ASSIGN","OP_LT","OP_GT",
    "BITWISE_AND","BITWISE_OR","STAR","PERCENT","DIV","CARRET","INTERR",
    "DOUBLE_COLON","OP_INC","OP_DEC","OP_SHIFT_LEFT","OP_SHIFT_RIGHT",
    "OP_LE","OP_GE","OP_EQ","OP_NE","OP_AND","OP_OR","OP_MULT_ASSIGN",
    "OP_DIV_ASSIGN","OP_MOD_ASSIGN","OP_ADD_ASSIGN","OP_SUB_ASSIGN",
    "OP_SHIFT_LEFT_ASSIGN","OP_SHIFT_RIGHT_ASSIGN","OP_AND_ASSIGN",
    "OP_XOR_ASSIGN","OP_OR_ASSIGN","OP_PTR","OP_COALESCING",
    "OP_GENERICS_LT","OP_GENERICS_LT_DECL","OP_GENERICS_GT","LITERAL",
    "IDENTIFIER","OPEN_PARENS_LAMBDA","OPEN_PARENS_CAST",
    "GENERIC_DIMENSION","DEFAULT_COLON","OPEN_BRACKET_EXPR",
    "EVAL_STATEMENT_PARSER","EVAL_COMPILATION_UNIT_PARSER",
    "EVAL_USING_DECLARATIONS_UNIT_PARSER","DOC_SEE","GENERATE_COMPLETION",
    "COMPLETE_COMPLETION","UMINUS",
  };

  /** index-checked interface to yyNames[].
      @param token single character or %token value.
      @return token name or [illegal] or [unknown].
    */
//t  public static string yyname (int token) {
//t    if ((token < 0) || (token > yyNames.Length)) return "[illegal]";
//t    string name;
//t    if ((name = yyNames[token]) != null) return name;
//t    return "[unknown]";
//t  }

  int yyExpectingState;
  /** computes list of expected tokens on error by tracing the tables.
      @param state for which to compute the list.
      @return list of token names.
    */
  protected int [] yyExpectingTokens (int state){
    int token, n, len = 0;
    bool[] ok = new bool[yyNames.Length];
    if ((n = yySindex[state]) != 0)
      for (token = n < 0 ? -n : 0;
           (token < yyNames.Length) && (n+token < yyTable.Length); ++ token)
        if (yyCheck[n+token] == token && !ok[token] && yyNames[token] != null) {
          ++ len;
          ok[token] = true;
        }
    if ((n = yyRindex[state]) != 0)
      for (token = n < 0 ? -n : 0;
           (token < yyNames.Length) && (n+token < yyTable.Length); ++ token)
        if (yyCheck[n+token] == token && !ok[token] && yyNames[token] != null) {
          ++ len;
          ok[token] = true;
        }
    int [] result = new int [len];
    for (n = token = 0; n < len;  ++ token)
      if (ok[token]) result[n++] = token;
    return result;
  }
  protected string[] yyExpecting (int state) {
    int [] tokens = yyExpectingTokens (state);
    string [] result = new string[tokens.Length];
    for (int n = 0; n < tokens.Length;  n++)
      result[n++] = yyNames[tokens [n]];
    return result;
  }

  /** the generated parser, with debugging messages.
      Maintains a state and a value stack, currently with fixed maximum size.
      @param yyLex scanner.
      @param yydebug debug message writer implementing yyDebug, or null.
      @return result of the last reduction, if any.
      @throws yyException on irrecoverable parse error.
    */
  internal Object yyparse (yyParser.yyInput yyLex, Object yyd)
				 {
//t    this.debug = (yydebug.yyDebug)yyd;
    return yyparse(yyLex);
  }

  /** initial size and increment of the state/value stack [default 256].
      This is not final so that it can be overwritten outside of invocations
      of yyparse().
    */
  protected int yyMax;

  /** executed at the beginning of a reduce action.
      Used as $$ = yyDefault($1), prior to the user-specified action, if any.
      Can be overwritten to provide deep copy, etc.
      @param first value for $1, or null.
      @return first.
    */
  protected Object yyDefault (Object first) {
    return first;
  }

	static int[] global_yyStates;
	static object[] global_yyVals;
	protected bool use_global_stacks;
	object[] yyVals;					// value stack
	object yyVal;						// value stack ptr
	int yyToken;						// current input
	int yyTop;

  /** the generated parser.
      Maintains a state and a value stack, currently with fixed maximum size.
      @param yyLex scanner.
      @return result of the last reduction, if any.
      @throws yyException on irrecoverable parse error.
    */
  internal Object yyparse (yyParser.yyInput yyLex)
  {
    if (yyMax <= 0) yyMax = 256;		// initial size
    int yyState = 0;                   // state stack ptr
    int [] yyStates;               	// state stack 
    yyVal = null;
    yyToken = -1;
    int yyErrorFlag = 0;				// #tks to shift
	if (use_global_stacks && global_yyStates != null) {
		yyVals = global_yyVals;
		yyStates = global_yyStates;
   } else {
		yyVals = new object [yyMax];
		yyStates = new int [yyMax];
		if (use_global_stacks) {
			global_yyVals = yyVals;
			global_yyStates = yyStates;
		}
	}

    /*yyLoop:*/ for (yyTop = 0;; ++ yyTop) {
      if (yyTop >= yyStates.Length) {			// dynamically increase
        global::System.Array.Resize (ref yyStates, yyStates.Length+yyMax);
        global::System.Array.Resize (ref yyVals, yyVals.Length+yyMax);
      }
      yyStates[yyTop] = yyState;
      yyVals[yyTop] = yyVal;
//t      if (debug != null) debug.push(yyState, yyVal);

      /*yyDiscarded:*/ while (true) {	// discarding a token does not change stack
        int yyN;
        if ((yyN = yyDefRed[yyState]) == 0) {	// else [default] reduce (yyN)
          if (yyToken < 0) {
            yyToken = yyLex.advance() ? yyLex.token() : 0;
//t            if (debug != null)
//t              debug.lex(yyState, yyToken, yyname(yyToken), yyLex.value());
          }
          if ((yyN = yySindex[yyState]) != 0 && ((yyN += yyToken) >= 0)
              && (yyN < yyTable.Length) && (yyCheck[yyN] == yyToken)) {
//t            if (debug != null)
//t              debug.shift(yyState, yyTable[yyN], yyErrorFlag-1);
            yyState = yyTable[yyN];		// shift to yyN
            yyVal = yyLex.value();
            yyToken = -1;
            if (yyErrorFlag > 0) -- yyErrorFlag;
            goto continue_yyLoop;
          }
          if ((yyN = yyRindex[yyState]) != 0 && (yyN += yyToken) >= 0
              && yyN < yyTable.Length && yyCheck[yyN] == yyToken)
            yyN = yyTable[yyN];			// reduce (yyN)
          else
            switch (yyErrorFlag) {
  
            case 0:
              yyExpectingState = yyState;
              // yyerror(String.Format ("syntax error, got token `{0}'", yyname (yyToken)), yyExpecting(yyState));
//t              if (debug != null) debug.error("syntax error");
              if (yyToken == 0 /*eof*/ || yyToken == eof_token) throw new yyParser.yyUnexpectedEof ();
              goto case 1;
            case 1: case 2:
              yyErrorFlag = 3;
              do {
                if ((yyN = yySindex[yyStates[yyTop]]) != 0
                    && (yyN += Token.yyErrorCode) >= 0 && yyN < yyTable.Length
                    && yyCheck[yyN] == Token.yyErrorCode) {
//t                  if (debug != null)
//t                    debug.shift(yyStates[yyTop], yyTable[yyN], 3);
                  yyState = yyTable[yyN];
                  yyVal = yyLex.value();
                  goto continue_yyLoop;
                }
//t                if (debug != null) debug.pop(yyStates[yyTop]);
              } while (-- yyTop >= 0);
//t              if (debug != null) debug.reject();
              throw new yyParser.yyException("irrecoverable syntax error");
  
            case 3:
              if (yyToken == 0) {
//t                if (debug != null) debug.reject();
                throw new yyParser.yyException("irrecoverable syntax error at end-of-file");
              }
//t              if (debug != null)
//t                debug.discard(yyState, yyToken, yyname(yyToken),
//t  							yyLex.value());
              yyToken = -1;
              goto continue_yyDiscarded;		// leave stack alone
            }
        }
        int yyV = yyTop + 1-yyLen[yyN];
//t        if (debug != null)
//t          debug.reduce(yyState, yyStates[yyV-1], yyN, YYRules.getRule (yyN), yyLen[yyN]);
        yyVal = yyV > yyTop ? null : yyVals[yyV]; // yyVal = yyDefault(yyV > yyTop ? null : yyVals[yyV]);
        switch (yyN) {
case 1:
#line 390 "cs-parser.jay"
  {
		Lexer.check_incorrect_doc_comment ();
	  }
  break;
case 2:
#line 391 "cs-parser.jay"
  { Lexer.CompleteOnEOF = false; }
  break;
case 6:
  case_6();
  break;
case 7:
#line 410 "cs-parser.jay"
  {
		module.AddAttributes ((Attributes) yyVals[0+yyTop], current_namespace);
	  }
  break;
case 8:
  case_8();
  break;
case 13:
  case_13();
  break;
case 14:
#line 455 "cs-parser.jay"
  {
		Error_SyntaxError (yyToken);
	  }
  break;
case 17:
  case_17();
  break;
case 18:
  case_18();
  break;
case 19:
  case_19();
  break;
case 20:
  case_20();
  break;
case 21:
  case_21();
  break;
case 22:
  case_22();
  break;
case 23:
  case_23();
  break;
case 24:
  case_24();
  break;
case 25:
  case_25();
  break;
case 26:
  case_26();
  break;
case 39:
  case_39();
  break;
case 40:
#line 621 "cs-parser.jay"
  {
		current_namespace.DeclarationFound = true;
	  }
  break;
case 41:
  case_41();
  break;
case 49:
  case_49();
  break;
case 50:
  case_50();
  break;
case 51:
  case_51();
  break;
case 52:
  case_52();
  break;
case 53:
  case_53();
  break;
case 54:
  case_54();
  break;
case 55:
  case_55();
  break;
case 56:
  case_56();
  break;
case 57:
#line 735 "cs-parser.jay"
  { yyVal = "event"; savedCloseLocation = GetLocation (yyVals[0+yyTop]); }
  break;
case 58:
#line 736 "cs-parser.jay"
  { yyVal = "return"; savedCloseLocation = GetLocation (yyVals[0+yyTop]); }
  break;
case 59:
  case_59();
  break;
case 60:
#line 753 "cs-parser.jay"
  {
		yyVal = new List<Attribute> (4) { (Attribute) yyVals[0+yyTop] };
	  }
  break;
case 61:
  case_61();
  break;
case 62:
#line 768 "cs-parser.jay"
  {
		++lexer.parsing_block;
	  }
  break;
case 63:
  case_63();
  break;
case 65:
#line 796 "cs-parser.jay"
  { yyVal = null; HadAttributeParens = false;  }
  break;
case 66:
  case_66();
  break;
case 67:
#line 808 "cs-parser.jay"
  { yyVal = null; }
  break;
case 68:
  case_68();
  break;
case 69:
  case_69();
  break;
case 70:
  case_70();
  break;
case 71:
  case_71();
  break;
case 72:
#line 852 "cs-parser.jay"
  {
	  	yyVal = new Argument ((Expression) yyVals[0+yyTop]);
	  }
  break;
case 74:
#line 860 "cs-parser.jay"
  {
		++lexer.parsing_block;
	  }
  break;
case 75:
  case_75();
  break;
case 76:
  case_76();
  break;
case 77:
#line 886 "cs-parser.jay"
  { yyVal = null; }
  break;
case 78:
#line 890 "cs-parser.jay"
  { 
		yyVal = Argument.AType.Ref;
	  }
  break;
case 79:
#line 894 "cs-parser.jay"
  { 
		yyVal = Argument.AType.Out;
	  }
  break;
case 82:
#line 906 "cs-parser.jay"
  {
		lexer.parsing_modifiers = true;
	  }
  break;
case 83:
#line 910 "cs-parser.jay"
  {
		lexer.parsing_modifiers = true;
	  }
  break;
case 95:
  case_95();
  break;
case 96:
#line 941 "cs-parser.jay"
  {
		lexer.ConstraintsParsing = true;
	  }
  break;
case 97:
  case_97();
  break;
case 98:
  case_98();
  break;
case 99:
  case_99();
  break;
case 100:
  case_100();
  break;
case 101:
  case_101();
  break;
case 102:
#line 984 "cs-parser.jay"
  {
		Error_SyntaxError (yyToken);
	  }
  break;
case 103:
  case_103();
  break;
case 104:
  case_104();
  break;
case 107:
#line 1025 "cs-parser.jay"
  {
		current_field.AddDeclarator ((FieldDeclarator) yyVals[0+yyTop]);
	  }
  break;
case 108:
#line 1029 "cs-parser.jay"
  {
		current_field.AddDeclarator ((FieldDeclarator) yyVals[0+yyTop]);
	  }
  break;
case 109:
  case_109();
  break;
case 110:
#line 1045 "cs-parser.jay"
  {
		++lexer.parsing_block;
	  }
  break;
case 111:
  case_111();
  break;
case 112:
  case_112();
  break;
case 115:
  case_115();
  break;
case 116:
  case_116();
  break;
case 117:
  case_117();
  break;
case 118:
  case_118();
  break;
case 119:
#line 1124 "cs-parser.jay"
  {
		report.Error (1641, GetLocation (yyVals[-1+yyTop]), "A fixed size buffer field must have the array size specifier after the field name");
	  }
  break;
case 121:
  case_121();
  break;
case 122:
  case_122();
  break;
case 125:
#line 1154 "cs-parser.jay"
  {
		current_field.AddDeclarator ((FieldDeclarator) yyVals[0+yyTop]);
	  }
  break;
case 126:
#line 1158 "cs-parser.jay"
  {
		current_field.AddDeclarator ((FieldDeclarator) yyVals[0+yyTop]);
	  }
  break;
case 127:
  case_127();
  break;
case 128:
#line 1171 "cs-parser.jay"
  {
		++lexer.parsing_block;
	  }
  break;
case 129:
  case_129();
  break;
case 132:
#line 1190 "cs-parser.jay"
  {
		current_field.AddDeclarator ((FieldDeclarator) yyVals[0+yyTop]);
	  }
  break;
case 133:
#line 1194 "cs-parser.jay"
  {
		current_field.AddDeclarator ((FieldDeclarator) yyVals[0+yyTop]);
	  }
  break;
case 134:
  case_134();
  break;
case 135:
#line 1210 "cs-parser.jay"
  {
		++lexer.parsing_block;
	  }
  break;
case 136:
  case_136();
  break;
case 137:
  case_137();
  break;
case 140:
  case_140();
  break;
case 141:
  case_141();
  break;
case 142:
  case_142();
  break;
case 143:
#line 1281 "cs-parser.jay"
  {
		valid_param_mod = ParameterModifierType.All;
	  }
  break;
case 144:
#line 1285 "cs-parser.jay"
  {
		lexer.ConstraintsParsing = true;
	  }
  break;
case 145:
  case_145();
  break;
case 146:
#line 1311 "cs-parser.jay"
  {
		lexer.parsing_generic_declaration = true;
	  }
  break;
case 147:
  case_147();
  break;
case 148:
#line 1321 "cs-parser.jay"
  {
		lexer.ConstraintsParsing = true;
	  }
  break;
case 149:
  case_149();
  break;
case 150:
  case_150();
  break;
case 151:
  case_151();
  break;
case 153:
#line 1386 "cs-parser.jay"
  { savedLocation = GetLocation (yyVals[0+yyTop]); yyVal = null; }
  break;
case 154:
#line 1390 "cs-parser.jay"
  { yyVal = ParametersCompiled.EmptyReadOnlyParameters; }
  break;
case 156:
  case_156();
  break;
case 157:
  case_157();
  break;
case 158:
  case_158();
  break;
case 159:
  case_159();
  break;
case 160:
  case_160();
  break;
case 161:
  case_161();
  break;
case 162:
  case_162();
  break;
case 163:
#line 1462 "cs-parser.jay"
  {
		yyVal = new ParametersCompiled (new Parameter[] { (Parameter) yyVals[0+yyTop] } );
	  }
  break;
case 164:
#line 1466 "cs-parser.jay"
  {
		yyVal = new ParametersCompiled (new Parameter [] { new ArglistParameter (GetLocation (yyVals[0+yyTop])) }, true);
	  }
  break;
case 165:
  case_165();
  break;
case 166:
  case_166();
  break;
case 167:
  case_167();
  break;
case 168:
  case_168();
  break;
case 169:
  case_169();
  break;
case 170:
  case_170();
  break;
case 171:
  case_171();
  break;
case 172:
#line 1547 "cs-parser.jay"
  {
	  	++lexer.parsing_block;
	  }
  break;
case 173:
  case_173();
  break;
case 174:
#line 1588 "cs-parser.jay"
  { yyVal = Parameter.Modifier.NONE; }
  break;
case 176:
#line 1596 "cs-parser.jay"
  {
		yyVal = yyVals[0+yyTop];
	  }
  break;
case 177:
  case_177();
  break;
case 178:
  case_178();
  break;
case 179:
  case_179();
  break;
case 180:
  case_180();
  break;
case 181:
  case_181();
  break;
case 182:
  case_182();
  break;
case 183:
  case_183();
  break;
case 184:
  case_184();
  break;
case 185:
  case_185();
  break;
case 186:
#line 1689 "cs-parser.jay"
  {
		Error_DuplicateParameterModifier (GetLocation (yyVals[-1+yyTop]), Parameter.Modifier.PARAMS);
	  }
  break;
case 187:
  case_187();
  break;
case 188:
  case_188();
  break;
case 189:
  case_189();
  break;
case 190:
  case_190();
  break;
case 191:
  case_191();
  break;
case 192:
#line 1743 "cs-parser.jay"
  {
	  	valid_param_mod = ParameterModifierType.Params | ParameterModifierType.DefaultValue;
	  }
  break;
case 193:
  case_193();
  break;
case 194:
#line 1772 "cs-parser.jay"
  {
		lexer.PropertyParsing = false;
	  }
  break;
case 195:
  case_195();
  break;
case 200:
  case_200();
  break;
case 201:
  case_201();
  break;
case 202:
  case_202();
  break;
case 203:
  case_203();
  break;
case 204:
  case_204();
  break;
case 206:
  case_206();
  break;
case 207:
  case_207();
  break;
case 208:
#line 1921 "cs-parser.jay"
  {
		lexer.ConstraintsParsing = true;
	  }
  break;
case 209:
  case_209();
  break;
case 210:
  case_210();
  break;
case 211:
  case_211();
  break;
case 212:
  case_212();
  break;
case 213:
#line 1960 "cs-parser.jay"
  {
		Error_SyntaxError (yyToken);	  
	  }
  break;
case 216:
#line 1972 "cs-parser.jay"
  {
		lexer.parsing_modifiers = true;
	  }
  break;
case 217:
#line 1976 "cs-parser.jay"
  {
		lexer.parsing_modifiers = true;
	  }
  break;
case 218:
#line 1983 "cs-parser.jay"
  {
		report.Error (525, GetLocation (yyVals[0+yyTop]), "Interfaces cannot contain fields or constants");
	  }
  break;
case 219:
#line 1987 "cs-parser.jay"
  {
		report.Error (525, GetLocation (yyVals[0+yyTop]), "Interfaces cannot contain fields or constants");
	  }
  break;
case 224:
#line 1995 "cs-parser.jay"
  {
	  	report.Error (567, GetLocation (yyVals[0+yyTop]), "Interfaces cannot contain operators");
	  }
  break;
case 225:
#line 1999 "cs-parser.jay"
  {
	  	report.Error (526, GetLocation (yyVals[0+yyTop]), "Interfaces cannot contain contructors");
	  }
  break;
case 226:
#line 2003 "cs-parser.jay"
  {
	  	report.Error (524, GetLocation (yyVals[0+yyTop]), "Interfaces cannot declare classes, structs, interfaces, delegates, or enumerations");
	  }
  break;
case 227:
#line 2009 "cs-parser.jay"
  {
	  }
  break;
case 228:
  case_228();
  break;
case 230:
#line 2042 "cs-parser.jay"
  { savedLocation = GetLocation (yyVals[0+yyTop]); yyVal = null; }
  break;
case 232:
  case_232();
  break;
case 233:
#line 2058 "cs-parser.jay"
  {
		valid_param_mod = ParameterModifierType.DefaultValue;
	  }
  break;
case 234:
  case_234();
  break;
case 236:
#line 2104 "cs-parser.jay"
  { yyVal = Operator.OpType.LogicalNot; savedOperatorLocation = GetLocation (yyVals[0+yyTop]); }
  break;
case 237:
#line 2105 "cs-parser.jay"
  { yyVal = Operator.OpType.OnesComplement; savedOperatorLocation = GetLocation (yyVals[0+yyTop]); }
  break;
case 238:
#line 2106 "cs-parser.jay"
  { yyVal = Operator.OpType.Increment; savedOperatorLocation = GetLocation (yyVals[0+yyTop]); }
  break;
case 239:
#line 2107 "cs-parser.jay"
  { yyVal = Operator.OpType.Decrement; savedOperatorLocation = GetLocation (yyVals[0+yyTop]); }
  break;
case 240:
#line 2108 "cs-parser.jay"
  { yyVal = Operator.OpType.True; savedOperatorLocation = GetLocation (yyVals[0+yyTop]); }
  break;
case 241:
#line 2109 "cs-parser.jay"
  { yyVal = Operator.OpType.False; savedOperatorLocation = GetLocation (yyVals[0+yyTop]); }
  break;
case 242:
#line 2111 "cs-parser.jay"
  { yyVal = Operator.OpType.Addition; savedOperatorLocation = GetLocation (yyVals[0+yyTop]); }
  break;
case 243:
#line 2112 "cs-parser.jay"
  { yyVal = Operator.OpType.Subtraction; savedOperatorLocation = GetLocation (yyVals[0+yyTop]); }
  break;
case 244:
#line 2114 "cs-parser.jay"
  { yyVal = Operator.OpType.Multiply; savedOperatorLocation = GetLocation (yyVals[0+yyTop]); }
  break;
case 245:
#line 2115 "cs-parser.jay"
  {  yyVal = Operator.OpType.Division; savedOperatorLocation = GetLocation (yyVals[0+yyTop]); }
  break;
case 246:
#line 2116 "cs-parser.jay"
  { yyVal = Operator.OpType.Modulus; savedOperatorLocation = GetLocation (yyVals[0+yyTop]); }
  break;
case 247:
#line 2117 "cs-parser.jay"
  { yyVal = Operator.OpType.BitwiseAnd; savedOperatorLocation = GetLocation (yyVals[0+yyTop]); }
  break;
case 248:
#line 2118 "cs-parser.jay"
  { yyVal = Operator.OpType.BitwiseOr; savedOperatorLocation = GetLocation (yyVals[0+yyTop]); }
  break;
case 249:
#line 2119 "cs-parser.jay"
  { yyVal = Operator.OpType.ExclusiveOr; savedOperatorLocation = GetLocation (yyVals[0+yyTop]); }
  break;
case 250:
#line 2120 "cs-parser.jay"
  { yyVal = Operator.OpType.LeftShift; savedOperatorLocation = GetLocation (yyVals[0+yyTop]); }
  break;
case 251:
#line 2121 "cs-parser.jay"
  { yyVal = Operator.OpType.RightShift; savedOperatorLocation = GetLocation (yyVals[0+yyTop]); }
  break;
case 252:
#line 2122 "cs-parser.jay"
  { yyVal = Operator.OpType.Equality; savedOperatorLocation = GetLocation (yyVals[0+yyTop]); }
  break;
case 253:
#line 2123 "cs-parser.jay"
  { yyVal = Operator.OpType.Inequality; savedOperatorLocation = GetLocation (yyVals[0+yyTop]); }
  break;
case 254:
#line 2124 "cs-parser.jay"
  { yyVal = Operator.OpType.GreaterThan; savedOperatorLocation = GetLocation (yyVals[0+yyTop]); }
  break;
case 255:
#line 2125 "cs-parser.jay"
  { yyVal = Operator.OpType.LessThan; savedOperatorLocation = GetLocation (yyVals[0+yyTop]); }
  break;
case 256:
#line 2126 "cs-parser.jay"
  { yyVal = Operator.OpType.GreaterThanOrEqual; savedOperatorLocation = GetLocation (yyVals[0+yyTop]); }
  break;
case 257:
#line 2127 "cs-parser.jay"
  { yyVal = Operator.OpType.LessThanOrEqual; savedOperatorLocation = GetLocation (yyVals[0+yyTop]); }
  break;
case 258:
#line 2134 "cs-parser.jay"
  {
		valid_param_mod = ParameterModifierType.DefaultValue;
	  }
  break;
case 259:
  case_259();
  break;
case 260:
#line 2153 "cs-parser.jay"
  {
		valid_param_mod = ParameterModifierType.DefaultValue;
	  }
  break;
case 261:
  case_261();
  break;
case 262:
  case_262();
  break;
case 263:
  case_263();
  break;
case 264:
  case_264();
  break;
case 265:
  case_265();
  break;
case 266:
  case_266();
  break;
case 267:
  case_267();
  break;
case 269:
#line 2259 "cs-parser.jay"
  { current_block = null; yyVal = null; }
  break;
case 272:
#line 2271 "cs-parser.jay"
  {
		++lexer.parsing_block;
	  }
  break;
case 273:
  case_273();
  break;
case 274:
#line 2281 "cs-parser.jay"
  {
		++lexer.parsing_block;
	  }
  break;
case 275:
  case_275();
  break;
case 276:
  case_276();
  break;
case 277:
  case_277();
  break;
case 278:
  case_278();
  break;
case 279:
  case_279();
  break;
case 280:
  case_280();
  break;
case 281:
  case_281();
  break;
case 282:
  case_282();
  break;
case 283:
  case_283();
  break;
case 284:
  case_284();
  break;
case 286:
#line 2397 "cs-parser.jay"
  {
	  	++lexer.parsing_block;
	  }
  break;
case 287:
  case_287();
  break;
case 290:
#line 2414 "cs-parser.jay"
  {
		current_event_field.AddDeclarator ((FieldDeclarator) yyVals[0+yyTop]);
	  }
  break;
case 291:
#line 2418 "cs-parser.jay"
  {
		current_event_field.AddDeclarator ((FieldDeclarator) yyVals[0+yyTop]);
	  }
  break;
case 292:
  case_292();
  break;
case 293:
#line 2431 "cs-parser.jay"
  {
		++lexer.parsing_block;
	  }
  break;
case 294:
  case_294();
  break;
case 295:
  case_295();
  break;
case 296:
#line 2456 "cs-parser.jay"
  {
		yyVal = yyVals[0+yyTop];
	  }
  break;
case 299:
  case_299();
  break;
case 300:
  case_300();
  break;
case 301:
  case_301();
  break;
case 302:
  case_302();
  break;
case 303:
  case_303();
  break;
case 304:
  case_304();
  break;
case 305:
  case_305();
  break;
case 306:
  case_306();
  break;
case 308:
  case_308();
  break;
case 309:
  case_309();
  break;
case 310:
  case_310();
  break;
case 311:
  case_311();
  break;
case 312:
  case_312();
  break;
case 314:
  case_314();
  break;
case 315:
  case_315();
  break;
case 318:
#line 2624 "cs-parser.jay"
  {
		lbag.AppendToMember (current_container, GetLocation (yyVals[0+yyTop]));
	  }
  break;
case 320:
  case_320();
  break;
case 321:
  case_321();
  break;
case 322:
  case_322();
  break;
case 323:
  case_323();
  break;
case 324:
#line 2682 "cs-parser.jay"
  {
		valid_param_mod = ParameterModifierType.Ref | ParameterModifierType.Out | ParameterModifierType.Params | ParameterModifierType.DefaultValue;
	  }
  break;
case 325:
  case_325();
  break;
case 326:
#line 2701 "cs-parser.jay"
  {
		lexer.ConstraintsParsing = false;
	  }
  break;
case 327:
  case_327();
  break;
case 329:
  case_329();
  break;
case 331:
  case_331();
  break;
case 333:
  case_333();
  break;
case 334:
  case_334();
  break;
case 336:
  case_336();
  break;
case 337:
  case_337();
  break;
case 338:
  case_338();
  break;
case 339:
  case_339();
  break;
case 340:
#line 2807 "cs-parser.jay"
  {
		lexer.parsing_generic_declaration = true;
	  }
  break;
case 341:
  case_341();
  break;
case 342:
  case_342();
  break;
case 344:
  case_344();
  break;
case 345:
  case_345();
  break;
case 346:
  case_346();
  break;
case 347:
  case_347();
  break;
case 348:
  case_348();
  break;
case 349:
  case_349();
  break;
case 351:
  case_351();
  break;
case 352:
  case_352();
  break;
case 353:
  case_353();
  break;
case 354:
  case_354();
  break;
case 355:
  case_355();
  break;
case 357:
#line 2929 "cs-parser.jay"
  {
		yyVal = new TypeExpression (compiler.BuiltinTypes.Void, GetLocation (yyVals[0+yyTop]));
	  }
  break;
case 358:
#line 2936 "cs-parser.jay"
  {
		lexer.parsing_generic_declaration = true;
	  }
  break;
case 360:
  case_360();
  break;
case 362:
  case_362();
  break;
case 364:
  case_364();
  break;
case 366:
#line 2974 "cs-parser.jay"
  {
		yyVal = new ComposedCast ((FullNamedExpression) yyVals[-1+yyTop], (ComposedTypeSpecifier) yyVals[0+yyTop]);
	  }
  break;
case 367:
  case_367();
  break;
case 368:
#line 2993 "cs-parser.jay"
  {
		yyVal = new ComposedCast ((ATypeNameExpression) yyVals[-1+yyTop], (ComposedTypeSpecifier) yyVals[0+yyTop]);
	  }
  break;
case 369:
  case_369();
  break;
case 370:
#line 3002 "cs-parser.jay"
  {
		yyVal = new ComposedCast ((FullNamedExpression) yyVals[-1+yyTop], (ComposedTypeSpecifier) yyVals[0+yyTop]);
	  }
  break;
case 371:
#line 3006 "cs-parser.jay"
  {
		yyVal = new ComposedCast (new TypeExpression (compiler.BuiltinTypes.Void, GetLocation (yyVals[-1+yyTop])), (ComposedTypeSpecifier) yyVals[0+yyTop]);
	  }
  break;
case 372:
  case_372();
  break;
case 373:
  case_373();
  break;
case 374:
  case_374();
  break;
case 375:
#line 3040 "cs-parser.jay"
  { yyVal = new TypeExpression (compiler.BuiltinTypes.Object, GetLocation (yyVals[0+yyTop])); }
  break;
case 376:
#line 3041 "cs-parser.jay"
  { yyVal = new TypeExpression (compiler.BuiltinTypes.String, GetLocation (yyVals[0+yyTop])); }
  break;
case 377:
#line 3042 "cs-parser.jay"
  { yyVal = new TypeExpression (compiler.BuiltinTypes.Bool, GetLocation (yyVals[0+yyTop])); }
  break;
case 378:
#line 3043 "cs-parser.jay"
  { yyVal = new TypeExpression (compiler.BuiltinTypes.Decimal, GetLocation (yyVals[0+yyTop])); }
  break;
case 379:
#line 3044 "cs-parser.jay"
  { yyVal = new TypeExpression (compiler.BuiltinTypes.Float, GetLocation (yyVals[0+yyTop])); }
  break;
case 380:
#line 3045 "cs-parser.jay"
  { yyVal = new TypeExpression (compiler.BuiltinTypes.Double, GetLocation (yyVals[0+yyTop])); }
  break;
case 382:
#line 3050 "cs-parser.jay"
  { yyVal = new TypeExpression (compiler.BuiltinTypes.SByte, GetLocation (yyVals[0+yyTop])); }
  break;
case 383:
#line 3051 "cs-parser.jay"
  { yyVal = new TypeExpression (compiler.BuiltinTypes.Byte, GetLocation (yyVals[0+yyTop])); }
  break;
case 384:
#line 3052 "cs-parser.jay"
  { yyVal = new TypeExpression (compiler.BuiltinTypes.Short, GetLocation (yyVals[0+yyTop])); }
  break;
case 385:
#line 3053 "cs-parser.jay"
  { yyVal = new TypeExpression (compiler.BuiltinTypes.UShort, GetLocation (yyVals[0+yyTop])); }
  break;
case 386:
#line 3054 "cs-parser.jay"
  { yyVal = new TypeExpression (compiler.BuiltinTypes.Int, GetLocation (yyVals[0+yyTop])); }
  break;
case 387:
#line 3055 "cs-parser.jay"
  { yyVal = new TypeExpression (compiler.BuiltinTypes.UInt, GetLocation (yyVals[0+yyTop])); }
  break;
case 388:
#line 3056 "cs-parser.jay"
  { yyVal = new TypeExpression (compiler.BuiltinTypes.Long, GetLocation (yyVals[0+yyTop])); }
  break;
case 389:
#line 3057 "cs-parser.jay"
  { yyVal = new TypeExpression (compiler.BuiltinTypes.ULong, GetLocation (yyVals[0+yyTop])); }
  break;
case 390:
#line 3058 "cs-parser.jay"
  { yyVal = new TypeExpression (compiler.BuiltinTypes.Char, GetLocation (yyVals[0+yyTop])); }
  break;
case 411:
  case_411();
  break;
case 412:
  case_412();
  break;
case 416:
#line 3105 "cs-parser.jay"
  { yyVal = new NullLiteral (GetLocation (yyVals[0+yyTop])); }
  break;
case 417:
#line 3109 "cs-parser.jay"
  { yyVal = new BoolLiteral (compiler.BuiltinTypes, true, GetLocation (yyVals[0+yyTop])); }
  break;
case 418:
#line 3110 "cs-parser.jay"
  { yyVal = new BoolLiteral (compiler.BuiltinTypes, false, GetLocation (yyVals[0+yyTop])); }
  break;
case 423:
  case_423();
  break;
case 424:
#line 3143 "cs-parser.jay"
  {
		yyVal = new ParenthesizedExpression ((Expression) yyVals[-1+yyTop]);
	  }
  break;
case 425:
  case_425();
  break;
case 426:
  case_426();
  break;
case 427:
  case_427();
  break;
case 428:
  case_428();
  break;
case 429:
#line 3178 "cs-parser.jay"
  {
		yyVal = new CompletionMemberAccess ((Expression) yyVals[-2+yyTop], null,GetLocation (yyVals[0+yyTop]));
	  }
  break;
case 430:
  case_430();
  break;
case 431:
#line 3186 "cs-parser.jay"
  {
		yyVal = new CompletionMemberAccess ((Expression) yyVals[-2+yyTop], null, lexer.Location);
	  }
  break;
case 432:
  case_432();
  break;
case 433:
  case_433();
  break;
case 434:
#line 3202 "cs-parser.jay"
  { yyVal = null; }
  break;
case 436:
  case_436();
  break;
case 437:
  case_437();
  break;
case 438:
#line 3225 "cs-parser.jay"
  { yyVal = null; }
  break;
case 439:
#line 3229 "cs-parser.jay"
  {
		yyVal = yyVals[0+yyTop];
	}
  break;
case 440:
  case_440();
  break;
case 441:
  case_441();
  break;
case 442:
  case_442();
  break;
case 443:
  case_443();
  break;
case 444:
#line 3262 "cs-parser.jay"
  {
		yyVal = new CompletionElementInitializer (null, GetLocation (yyVals[0+yyTop]));
	  }
  break;
case 445:
  case_445();
  break;
case 446:
  case_446();
  break;
case 447:
  case_447();
  break;
case 450:
#line 3292 "cs-parser.jay"
  { yyVal = null; }
  break;
case 452:
  case_452();
  break;
case 453:
  case_453();
  break;
case 454:
  case_454();
  break;
case 455:
  case_455();
  break;
case 456:
  case_456();
  break;
case 457:
#line 3344 "cs-parser.jay"
  {
		yyVal = new Argument ((Expression) yyVals[0+yyTop]);
	  }
  break;
case 461:
  case_461();
  break;
case 462:
  case_462();
  break;
case 463:
  case_463();
  break;
case 464:
  case_464();
  break;
case 466:
  case_466();
  break;
case 467:
  case_467();
  break;
case 468:
  case_468();
  break;
case 469:
  case_469();
  break;
case 470:
  case_470();
  break;
case 471:
  case_471();
  break;
case 472:
  case_472();
  break;
case 473:
  case_473();
  break;
case 474:
#line 3441 "cs-parser.jay"
  {
	  	yyVal = new Argument ((Expression) yyVals[0+yyTop]);
	  }
  break;
case 476:
#line 3449 "cs-parser.jay"
  {
		yyVal = new This (GetLocation (yyVals[0+yyTop]));
	  }
  break;
case 477:
  case_477();
  break;
case 478:
  case_478();
  break;
case 479:
#line 3469 "cs-parser.jay"
  {
		yyVal = new UnaryMutator (UnaryMutator.Mode.PostIncrement, (Expression) yyVals[-1+yyTop], GetLocation (yyVals[0+yyTop]));
	  }
  break;
case 480:
#line 3476 "cs-parser.jay"
  {
		yyVal = new UnaryMutator (UnaryMutator.Mode.PostDecrement, (Expression) yyVals[-1+yyTop], GetLocation (yyVals[0+yyTop]));
	  }
  break;
case 481:
  case_481();
  break;
case 482:
  case_482();
  break;
case 483:
  case_483();
  break;
case 484:
  case_484();
  break;
case 485:
  case_485();
  break;
case 486:
  case_486();
  break;
case 487:
  case_487();
  break;
case 488:
#line 3543 "cs-parser.jay"
  {
		++lexer.parsing_type;
	  }
  break;
case 489:
  case_489();
  break;
case 490:
  case_490();
  break;
case 493:
#line 3570 "cs-parser.jay"
  { yyVal = null; }
  break;
case 495:
  case_495();
  break;
case 496:
  case_496();
  break;
case 497:
  case_497();
  break;
case 498:
  case_498();
  break;
case 499:
  case_499();
  break;
case 500:
  case_500();
  break;
case 504:
  case_504();
  break;
case 505:
  case_505();
  break;
case 506:
  case_506();
  break;
case 507:
#line 3648 "cs-parser.jay"
  {
		yyVal = 2;
	  }
  break;
case 508:
#line 3652 "cs-parser.jay"
  {
		yyVal = ((int) yyVals[-1+yyTop]) + 1;
	  }
  break;
case 509:
#line 3659 "cs-parser.jay"
  {
		yyVal = null;
	  }
  break;
case 510:
#line 3663 "cs-parser.jay"
  {
		yyVal = yyVals[0+yyTop];
	  }
  break;
case 511:
  case_511();
  break;
case 512:
  case_512();
  break;
case 513:
  case_513();
  break;
case 514:
  case_514();
  break;
case 515:
#line 3707 "cs-parser.jay"
  {
	  	lexer.TypeOfParsing = true;
	  }
  break;
case 516:
  case_516();
  break;
case 519:
  case_519();
  break;
case 520:
  case_520();
  break;
case 521:
  case_521();
  break;
case 522:
  case_522();
  break;
case 523:
  case_523();
  break;
case 524:
  case_524();
  break;
case 525:
  case_525();
  break;
case 526:
  case_526();
  break;
case 527:
  case_527();
  break;
case 528:
  case_528();
  break;
case 529:
  case_529();
  break;
case 530:
  case_530();
  break;
case 531:
#line 3827 "cs-parser.jay"
  {
		start_anonymous (false, (ParametersCompiled) yyVals[0+yyTop], false, GetLocation (yyVals[-1+yyTop]));
	  }
  break;
case 532:
  case_532();
  break;
case 533:
#line 3840 "cs-parser.jay"
  {
		start_anonymous (false, (ParametersCompiled) yyVals[0+yyTop], true, GetLocation (yyVals[-2+yyTop]));
	  }
  break;
case 534:
  case_534();
  break;
case 535:
#line 3857 "cs-parser.jay"
  {
		yyVal = ParametersCompiled.Undefined;
	  }
  break;
case 537:
#line 3865 "cs-parser.jay"
  {
	  	valid_param_mod = ParameterModifierType.Ref | ParameterModifierType.Out;
	  }
  break;
case 538:
  case_538();
  break;
case 539:
  case_539();
  break;
case 541:
#line 3891 "cs-parser.jay"
  {
		yyVal = new Unary (Unary.Operator.LogicalNot, (Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }
  break;
case 542:
#line 3895 "cs-parser.jay"
  {
		yyVal = new Unary (Unary.Operator.OnesComplement, (Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }
  break;
case 543:
  case_543();
  break;
case 544:
  case_544();
  break;
case 546:
#line 3931 "cs-parser.jay"
  { 
	  	yyVal = new Unary (Unary.Operator.UnaryPlus, (Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }
  break;
case 547:
#line 3935 "cs-parser.jay"
  { 
		yyVal = new Unary (Unary.Operator.UnaryNegation, (Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }
  break;
case 548:
#line 3939 "cs-parser.jay"
  {
		yyVal = new UnaryMutator (UnaryMutator.Mode.PreIncrement, (Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }
  break;
case 549:
#line 3943 "cs-parser.jay"
  {
		yyVal = new UnaryMutator (UnaryMutator.Mode.PreDecrement, (Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }
  break;
case 550:
#line 3947 "cs-parser.jay"
  {
		yyVal = new Indirection ((Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }
  break;
case 551:
#line 3951 "cs-parser.jay"
  {
		yyVal = new Unary (Unary.Operator.AddressOf, (Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }
  break;
case 553:
  case_553();
  break;
case 554:
  case_554();
  break;
case 555:
  case_555();
  break;
case 557:
  case_557();
  break;
case 558:
#line 3983 "cs-parser.jay"
  {
		yyVal = new Binary (Binary.Operator.Subtraction, (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }
  break;
case 559:
  case_559();
  break;
case 560:
#line 3992 "cs-parser.jay"
  {
		yyVal = new As ((Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }
  break;
case 561:
#line 3996 "cs-parser.jay"
  {
		yyVal = new Is ((Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }
  break;
case 563:
  case_563();
  break;
case 564:
  case_564();
  break;
case 566:
  case_566();
  break;
case 567:
  case_567();
  break;
case 568:
  case_568();
  break;
case 569:
  case_569();
  break;
case 571:
  case_571();
  break;
case 572:
  case_572();
  break;
case 574:
  case_574();
  break;
case 576:
  case_576();
  break;
case 578:
  case_578();
  break;
case 580:
  case_580();
  break;
case 582:
  case_582();
  break;
case 584:
  case_584();
  break;
case 586:
  case_586();
  break;
case 587:
  case_587();
  break;
case 588:
#line 4125 "cs-parser.jay"
  {
		yyVal = new SimpleAssign ((Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }
  break;
case 589:
  case_589();
  break;
case 590:
  case_590();
  break;
case 591:
  case_591();
  break;
case 592:
  case_592();
  break;
case 593:
  case_593();
  break;
case 594:
  case_594();
  break;
case 595:
  case_595();
  break;
case 596:
  case_596();
  break;
case 597:
  case_597();
  break;
case 598:
  case_598();
  break;
case 599:
  case_599();
  break;
case 600:
  case_600();
  break;
case 601:
  case_601();
  break;
case 602:
  case_602();
  break;
case 603:
  case_603();
  break;
case 604:
#line 4222 "cs-parser.jay"
  { yyVal = ParametersCompiled.EmptyReadOnlyParameters; }
  break;
case 605:
  case_605();
  break;
case 608:
#line 4238 "cs-parser.jay"
  {
		start_block (Location.Null);
	  }
  break;
case 609:
  case_609();
  break;
case 611:
  case_611();
  break;
case 612:
  case_612();
  break;
case 613:
  case_613();
  break;
case 614:
  case_614();
  break;
case 615:
  case_615();
  break;
case 616:
#line 4283 "cs-parser.jay"
  {
	  	valid_param_mod = ParameterModifierType.Ref | ParameterModifierType.Out;
	  }
  break;
case 617:
  case_617();
  break;
case 618:
  case_618();
  break;
case 619:
#line 4297 "cs-parser.jay"
  {
	  	valid_param_mod = ParameterModifierType.Ref | ParameterModifierType.Out;	  
	  }
  break;
case 620:
  case_620();
  break;
case 621:
  case_621();
  break;
case 627:
#line 4322 "cs-parser.jay"
  {
		yyVal = new ArglistAccess (GetLocation (yyVals[0+yyTop]));
	  }
  break;
case 628:
  case_628();
  break;
case 629:
  case_629();
  break;
case 630:
  case_630();
  break;
case 632:
#line 4351 "cs-parser.jay"
  {
		yyVal = new BooleanExpression ((Expression) yyVals[0+yyTop]);
	  }
  break;
case 633:
#line 4364 "cs-parser.jay"
  {
		lexer.ConstraintsParsing = true;
	  }
  break;
case 634:
  case_634();
  break;
case 635:
  case_635();
  break;
case 636:
  case_636();
  break;
case 637:
  case_637();
  break;
case 638:
#line 4409 "cs-parser.jay"
  { yyVal = null; }
  break;
case 639:
#line 4411 "cs-parser.jay"
  { yyVal = yyVals[0+yyTop]; StoreModifierLocation (Modifiers.PARTIAL, GetLocation (yyVals[0+yyTop])); }
  break;
case 640:
  case_640();
  break;
case 641:
#line 4424 "cs-parser.jay"
  {
		lexer.parsing_modifiers = false;		
	  }
  break;
case 643:
  case_643();
  break;
case 644:
  case_644();
  break;
case 645:
  case_645();
  break;
case 646:
  case_646();
  break;
case 647:
  case_647();
  break;
case 648:
  case_648();
  break;
case 649:
  case_649();
  break;
case 650:
  case_650();
  break;
case 651:
  case_651();
  break;
case 652:
  case_652();
  break;
case 653:
  case_653();
  break;
case 654:
  case_654();
  break;
case 655:
  case_655();
  break;
case 656:
  case_656();
  break;
case 657:
  case_657();
  break;
case 658:
  case_658();
  break;
case 660:
  case_660();
  break;
case 661:
  case_661();
  break;
case 663:
#line 4550 "cs-parser.jay"
  {
		yyVal = yyVals[0+yyTop];
	  }
  break;
case 664:
  case_664();
  break;
case 665:
  case_665();
  break;
case 666:
  case_666();
  break;
case 667:
  case_667();
  break;
case 668:
  case_668();
  break;
case 669:
  case_669();
  break;
case 670:
  case_670();
  break;
case 671:
  case_671();
  break;
case 672:
#line 4643 "cs-parser.jay"
  {
		yyVal = new SpecialContraintExpr (SpecialConstraint.Class, GetLocation (yyVals[0+yyTop]));
	  }
  break;
case 673:
#line 4647 "cs-parser.jay"
  {
		yyVal = new SpecialContraintExpr (SpecialConstraint.Struct, GetLocation (yyVals[0+yyTop]));
	  }
  break;
case 674:
#line 4654 "cs-parser.jay"
  {
		yyVal = Variance.None;
	  }
  break;
case 675:
  case_675();
  break;
case 676:
  case_676();
  break;
case 677:
  case_677();
  break;
case 678:
  case_678();
  break;
case 679:
#line 4699 "cs-parser.jay"
  {
		yyVal = yyVals[0+yyTop];
	  }
  break;
case 680:
  case_680();
  break;
case 681:
  case_681();
  break;
case 682:
  case_682();
  break;
case 683:
  case_683();
  break;
case 684:
  case_684();
  break;
case 689:
#line 4748 "cs-parser.jay"
  {
		current_block.AddStatement ((Statement) yyVals[0+yyTop]);
	  }
  break;
case 690:
#line 4752 "cs-parser.jay"
  {
		current_block.AddStatement ((Statement) yyVals[0+yyTop]);
	  }
  break;
case 692:
  case_692();
  break;
case 693:
  case_693();
  break;
case 696:
#line 4786 "cs-parser.jay"
  {
		current_block.AddStatement ((Statement) yyVals[0+yyTop]);
	  }
  break;
case 697:
#line 4790 "cs-parser.jay"
  {
		current_block.AddStatement ((Statement) yyVals[0+yyTop]);
	  }
  break;
case 726:
  case_726();
  break;
case 727:
  case_727();
  break;
case 728:
  case_728();
  break;
case 729:
  case_729();
  break;
case 730:
  case_730();
  break;
case 733:
  case_733();
  break;
case 734:
  case_734();
  break;
case 735:
  case_735();
  break;
case 736:
  case_736();
  break;
case 737:
#line 4934 "cs-parser.jay"
  {
		yyVal = new ComposedCast ((FullNamedExpression) yyVals[-1+yyTop], (ComposedTypeSpecifier) yyVals[0+yyTop]);
	  }
  break;
case 738:
#line 4938 "cs-parser.jay"
  {
		yyVal = new ComposedCast (new TypeExpression (compiler.BuiltinTypes.Void, GetLocation (yyVals[-1+yyTop])), (ComposedTypeSpecifier) yyVals[0+yyTop]);
	  }
  break;
case 739:
  case_739();
  break;
case 741:
  case_741();
  break;
case 742:
#line 4959 "cs-parser.jay"
  {
		yyVal = ComposedTypeSpecifier.CreatePointer (GetLocation (yyVals[0+yyTop]));
	  }
  break;
case 744:
  case_744();
  break;
case 745:
  case_745();
  break;
case 746:
  case_746();
  break;
case 747:
  case_747();
  break;
case 748:
  case_748();
  break;
case 750:
  case_750();
  break;
case 752:
  case_752();
  break;
case 753:
  case_753();
  break;
case 754:
  case_754();
  break;
case 758:
  case_758();
  break;
case 761:
  case_761();
  break;
case 762:
  case_762();
  break;
case 763:
#line 5094 "cs-parser.jay"
  {
		report.Error (145, lexer.Location, "A const field requires a value to be provided");
	  }
  break;
case 764:
  case_764();
  break;
case 769:
  case_769();
  break;
case 771:
  case_771();
  break;
case 772:
  case_772();
  break;
case 773:
  case_773();
  break;
case 774:
#line 5144 "cs-parser.jay"
  { yyVal = yyVals[-1+yyTop]; }
  break;
case 775:
  case_775();
  break;
case 776:
#line 5154 "cs-parser.jay"
  { yyVal = yyVals[-1+yyTop]; }
  break;
case 777:
#line 5155 "cs-parser.jay"
  { yyVal = yyVals[-1+yyTop]; }
  break;
case 778:
  case_778();
  break;
case 779:
  case_779();
  break;
case 780:
  case_780();
  break;
case 783:
  case_783();
  break;
case 784:
  case_784();
  break;
case 785:
  case_785();
  break;
case 786:
#line 5230 "cs-parser.jay"
  {
		start_block (GetLocation (yyVals[0+yyTop]));
	  }
  break;
case 787:
  case_787();
  break;
case 788:
  case_788();
  break;
case 789:
  case_789();
  break;
case 791:
  case_791();
  break;
case 792:
  case_792();
  break;
case 793:
  case_793();
  break;
case 794:
#line 5281 "cs-parser.jay"
  {
		current_block = current_block.CreateSwitchBlock (lexer.Location);
	  }
  break;
case 795:
#line 5285 "cs-parser.jay"
  {
		yyVal = new SwitchSection ((List<SwitchLabel>) yyVals[-2+yyTop], current_block);
	  }
  break;
case 796:
  case_796();
  break;
case 797:
  case_797();
  break;
case 798:
  case_798();
  break;
case 799:
  case_799();
  break;
case 800:
#line 5319 "cs-parser.jay"
  {
		yyVal = new SwitchLabel (null, GetLocation (yyVals[0+yyTop]));
	  }
  break;
case 805:
  case_805();
  break;
case 806:
  case_806();
  break;
case 807:
  case_807();
  break;
case 808:
  case_808();
  break;
case 809:
  case_809();
  break;
case 810:
  case_810();
  break;
case 811:
#line 5380 "cs-parser.jay"
  {
		yyVal = yyVals[0+yyTop];
	  }
  break;
case 812:
  case_812();
  break;
case 813:
#line 5395 "cs-parser.jay"
  {
		yyVal = yyVals[0+yyTop];
	  }
  break;
case 814:
  case_814();
  break;
case 815:
  case_815();
  break;
case 816:
#line 5416 "cs-parser.jay"
  {
		yyVal = yyVals[0+yyTop];
	  }
  break;
case 817:
  case_817();
  break;
case 818:
  case_818();
  break;
case 819:
  case_819();
  break;
case 820:
#line 5449 "cs-parser.jay"
  { yyVal = new EmptyStatement (lexer.Location); }
  break;
case 822:
  case_822();
  break;
case 823:
  case_823();
  break;
case 825:
#line 5470 "cs-parser.jay"
  { yyVal = null; }
  break;
case 827:
#line 5475 "cs-parser.jay"
  { yyVal = new EmptyStatement (lexer.Location); }
  break;
case 831:
  case_831();
  break;
case 832:
  case_832();
  break;
case 833:
  case_833();
  break;
case 834:
  case_834();
  break;
case 835:
  case_835();
  break;
case 836:
  case_836();
  break;
case 837:
  case_837();
  break;
case 844:
  case_844();
  break;
case 845:
  case_845();
  break;
case 846:
  case_846();
  break;
case 847:
  case_847();
  break;
case 848:
  case_848();
  break;
case 849:
  case_849();
  break;
case 850:
  case_850();
  break;
case 851:
  case_851();
  break;
case 852:
  case_852();
  break;
case 853:
  case_853();
  break;
case 854:
  case_854();
  break;
case 855:
  case_855();
  break;
case 858:
#line 5692 "cs-parser.jay"
  {
		yyVal = new TryCatch ((Block) yyVals[-1+yyTop], (List<Catch>) yyVals[0+yyTop], GetLocation (yyVals[-2+yyTop]), false);
	  }
  break;
case 859:
  case_859();
  break;
case 860:
  case_860();
  break;
case 861:
  case_861();
  break;
case 862:
  case_862();
  break;
case 863:
  case_863();
  break;
case 866:
#line 5742 "cs-parser.jay"
  {
		yyVal = new Catch ((Block) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }
  break;
case 867:
  case_867();
  break;
case 868:
#line 5761 "cs-parser.jay"
  {
		yyVal = yyVals[-1+yyTop];
	  }
  break;
case 869:
  case_869();
  break;
case 870:
#line 5779 "cs-parser.jay"
  {
		yyVal = new Checked ((Block) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }
  break;
case 871:
#line 5786 "cs-parser.jay"
  {
		yyVal = new Unchecked ((Block) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }
  break;
case 872:
  case_872();
  break;
case 873:
#line 5796 "cs-parser.jay"
  {
		yyVal = new Unsafe ((Block) yyVals[0+yyTop], GetLocation (yyVals[-2+yyTop]));
	  }
  break;
case 874:
  case_874();
  break;
case 875:
  case_875();
  break;
case 876:
  case_876();
  break;
case 877:
  case_877();
  break;
case 878:
  case_878();
  break;
case 879:
  case_879();
  break;
case 880:
  case_880();
  break;
case 881:
  case_881();
  break;
case 882:
  case_882();
  break;
case 883:
  case_883();
  break;
case 885:
  case_885();
  break;
case 886:
#line 5901 "cs-parser.jay"
  {
		Error_MissingInitializer (lexer.Location);
	  }
  break;
case 887:
  case_887();
  break;
case 888:
  case_888();
  break;
case 889:
  case_889();
  break;
case 890:
  case_890();
  break;
case 891:
  case_891();
  break;
case 892:
  case_892();
  break;
case 893:
  case_893();
  break;
case 894:
  case_894();
  break;
case 895:
  case_895();
  break;
case 896:
#line 6006 "cs-parser.jay"
  {
		current_block = new Linq.QueryBlock (current_block, lexer.Location);
	  }
  break;
case 897:
  case_897();
  break;
case 898:
#line 6022 "cs-parser.jay"
  {
		current_block = new Linq.QueryBlock (current_block, lexer.Location);
	  }
  break;
case 899:
  case_899();
  break;
case 900:
  case_900();
  break;
case 901:
  case_901();
  break;
case 903:
  case_903();
  break;
case 904:
  case_904();
  break;
case 905:
#line 6086 "cs-parser.jay"
  {
	  	current_block = new Linq.QueryBlock (current_block, lexer.Location);
	  }
  break;
case 906:
  case_906();
  break;
case 907:
  case_907();
  break;
case 908:
  case_908();
  break;
case 909:
  case_909();
  break;
case 911:
  case_911();
  break;
case 917:
#line 6140 "cs-parser.jay"
  {
	  	current_block = new Linq.QueryBlock (current_block, lexer.Location);
	  }
  break;
case 918:
  case_918();
  break;
case 919:
#line 6159 "cs-parser.jay"
  {
	  	current_block = new Linq.QueryBlock (current_block, lexer.Location);
	  }
  break;
case 920:
  case_920();
  break;
case 921:
  case_921();
  break;
case 922:
  case_922();
  break;
case 923:
  case_923();
  break;
case 924:
  case_924();
  break;
case 925:
  case_925();
  break;
case 926:
  case_926();
  break;
case 927:
  case_927();
  break;
case 928:
  case_928();
  break;
case 930:
  case_930();
  break;
case 931:
#line 6313 "cs-parser.jay"
  {
		current_block = new Linq.QueryBlock (current_block, lexer.Location);
	  }
  break;
case 932:
  case_932();
  break;
case 934:
  case_934();
  break;
case 935:
  case_935();
  break;
case 937:
  case_937();
  break;
case 938:
  case_938();
  break;
case 939:
#line 6359 "cs-parser.jay"
  {
		yyVal = new Linq.OrderByAscending ((Linq.QueryBlock) current_block, (Expression)yyVals[0+yyTop]);	
	  }
  break;
case 940:
  case_940();
  break;
case 941:
  case_941();
  break;
case 942:
#line 6376 "cs-parser.jay"
  {
		yyVal = new Linq.ThenByAscending ((Linq.QueryBlock) current_block, (Expression)yyVals[0+yyTop]);	
	  }
  break;
case 943:
  case_943();
  break;
case 944:
  case_944();
  break;
case 946:
  case_946();
  break;
case 947:
  case_947();
  break;
case 950:
  case_950();
  break;
case 951:
  case_951();
  break;
case 959:
#line 6498 "cs-parser.jay"
  {
		module.DocumentationBuilder.ParsedName = (MemberName) yyVals[0+yyTop];
	  }
  break;
case 960:
#line 6505 "cs-parser.jay"
  {
		module.DocumentationBuilder.ParsedParameters = (List<DocumentationParameter>)yyVals[0+yyTop];
	  }
  break;
case 961:
  case_961();
  break;
case 962:
  case_962();
  break;
case 963:
#line 6522 "cs-parser.jay"
  {
		yyVal = new MemberName ((MemberName) yyVals[-2+yyTop], MemberCache.IndexerNameAlias, Location.Null);
	  }
  break;
case 964:
#line 6526 "cs-parser.jay"
  {
		valid_param_mod = ParameterModifierType.Ref | ParameterModifierType.Out;
	  }
  break;
case 965:
  case_965();
  break;
case 966:
  case_966();
  break;
case 967:
  case_967();
  break;
case 968:
  case_968();
  break;
case 970:
#line 6562 "cs-parser.jay"
  {
		yyVal = new MemberName (((MemberName) yyVals[-2+yyTop]), (MemberName) yyVals[0+yyTop]);
	  }
  break;
case 972:
#line 6570 "cs-parser.jay"
  {
		valid_param_mod = ParameterModifierType.Ref | ParameterModifierType.Out;
	  }
  break;
case 973:
#line 6574 "cs-parser.jay"
  {
		yyVal = yyVals[-1+yyTop];
	  }
  break;
case 974:
#line 6581 "cs-parser.jay"
  {
		yyVal = new List<DocumentationParameter> (0);
	  }
  break;
case 976:
  case_976();
  break;
case 977:
  case_977();
  break;
case 978:
  case_978();
  break;
#line default
        }
        yyTop -= yyLen[yyN];
        yyState = yyStates[yyTop];
        int yyM = yyLhs[yyN];
        if (yyState == 0 && yyM == 0) {
//t          if (debug != null) debug.shift(0, yyFinal);
          yyState = yyFinal;
          if (yyToken < 0) {
            yyToken = yyLex.advance() ? yyLex.token() : 0;
//t            if (debug != null)
//t               debug.lex(yyState, yyToken,yyname(yyToken), yyLex.value());
          }
          if (yyToken == 0) {
//t            if (debug != null) debug.accept(yyVal);
            return yyVal;
          }
          goto continue_yyLoop;
        }
        if (((yyN = yyGindex[yyM]) != 0) && ((yyN += yyState) >= 0)
            && (yyN < yyTable.Length) && (yyCheck[yyN] == yyState))
          yyState = yyTable[yyN];
        else
          yyState = yyDgoto[yyM];
//t        if (debug != null) debug.shift(yyStates[yyTop], yyState);
	 goto continue_yyLoop;
      continue_yyDiscarded: ;	// implements the named-loop continue: 'continue yyDiscarded'
      }
    continue_yyLoop: ;		// implements the named-loop continue: 'continue yyLoop'
    }
  }

/*
 All more than 3 lines long rules are wrapped into a method
*/
void case_6()
#line 398 "cs-parser.jay"
{
		if (yyVals[0+yyTop] != null) {
			Attributes attrs = (Attributes) yyVals[0+yyTop];
			report.Error (1730, attrs.Attrs [0].Location,
				"Assembly and module attributes must precede all other elements except using clauses and extern alias declarations");

			current_namespace.UnattachedAttributes = attrs;
		}
	  }

void case_8()
#line 412 "cs-parser.jay"
{
		if (yyToken == Token.EXTERN_ALIAS)
			report.Error (439, lexer.Location, "An extern alias declaration must precede all other elements");
		else
			Error_SyntaxError (yyToken);
	  }

void case_13()
#line 432 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[-2+yyTop];
		string s = lt.Value;
		if (s != "alias") {
			syntax_error (lt.Location, "`alias' expected");
		} else {
			if (lang_version == LanguageVersion.ISO_1)
				FeatureIsNotAvailable (lt.Location, "external alias");

			lt = (Tokenizer.LocatedToken) yyVals[-1+yyTop];
			if (lt.Value == QualifiedAliasMember.GlobalAlias) {
				RootNamespace.Error_GlobalNamespaceRedefined (report, lt.Location);
			}
			
			var na = new UsingExternAlias (new SimpleMemberName (lt.Value, lt.Location), GetLocation (yyVals[-3+yyTop]));
			current_namespace.AddUsing (na);
			
			lbag.AddLocation (na, GetLocation (yyVals[-2+yyTop]), GetLocation (yyVals[0+yyTop]));
		}
	  }

void case_17()
#line 465 "cs-parser.jay"
{
		if (doc_support)
			Lexer.doc_state = XmlCommentState.Allowed;
	  }

void case_18()
#line 473 "cs-parser.jay"
{
		var un = new UsingNamespace ((ATypeNameExpression) yyVals[-1+yyTop], GetLocation (yyVals[-2+yyTop]));
		current_namespace.AddUsing (un);
		
		lbag.AddLocation (un, GetLocation (yyVals[0+yyTop]));
	  }

void case_19()
#line 480 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[-3+yyTop];
		if (lang_version != LanguageVersion.ISO_1 && lt.Value == "global") {
			report.Warning (440, 2, lt.Location,
			 "An alias named `global' will not be used when resolving `global::'. The global namespace will be used instead");
		}

		var un = new UsingAliasNamespace (new SimpleMemberName (lt.Value, lt.Location), (ATypeNameExpression) yyVals[-1+yyTop], GetLocation (yyVals[-4+yyTop]));
		current_namespace.AddUsing (un);
		lbag.AddLocation (un, GetLocation (yyVals[-2+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_20()
#line 492 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);
		yyVal = null;
	 }

void case_21()
#line 505 "cs-parser.jay"
{
		Attributes attrs = (Attributes) yyVals[-2+yyTop];
		var name = (MemberName) yyVals[0+yyTop];
		if (attrs != null) {
			bool valid_global_attrs = true;
			if ((current_namespace.DeclarationFound || current_namespace != file)) {
				valid_global_attrs = false;
			} else {
				foreach (var a in attrs.Attrs) {
					if (a.ExplicitTarget == "assembly" || a.ExplicitTarget == "module")
						continue;
						
					valid_global_attrs = false;
					break;
				}
			}
			
			if (!valid_global_attrs)
				report.Error (1671, name.Location, "A namespace declaration cannot have modifiers or attributes");
		}
	
		module.AddAttributes (attrs, current_namespace);
		
		var ns = new NamespaceContainer (name, current_namespace);
		current_namespace.AddTypeContainer (ns);
		current_container = current_namespace = ns;
	  }

void case_22()
#line 533 "cs-parser.jay"
{
		if (doc_support)
			Lexer.doc_state = XmlCommentState.Allowed;
	  }

void case_23()
#line 538 "cs-parser.jay"
{
		if (yyVals[0+yyTop] != null)
			lbag.AddLocation (current_container, GetLocation (yyVals[-9+yyTop]), GetLocation (yyVals[-6+yyTop]), GetLocation (yyVals[-1+yyTop]), GetLocation (yyVals[0+yyTop]));
		else
			lbag.AddLocation (current_container, GetLocation (yyVals[-9+yyTop]), GetLocation (yyVals[-6+yyTop]), GetLocation (yyVals[-1+yyTop]));
	  
		current_container = current_namespace = current_namespace.Parent;
	  }

void case_24()
#line 550 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[0+yyTop];
		yyVal = new MemberName (lt.Value, lt.Location);
	  }

void case_25()
#line 555 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[0+yyTop];
		yyVal = new MemberName ((MemberName) yyVals[-2+yyTop], lt.Value, lt.Location) {
			DotLocation = GetLocation (yyVals[-1+yyTop])
		};
	  }

void case_26()
#line 562 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);
		yyVal = new MemberName ("<invalid>", lexer.Location);
	  }

void case_39()
#line 600 "cs-parser.jay"
{
		if (yyVals[0+yyTop] != null) {
			TypeContainer ds = (TypeContainer)yyVals[0+yyTop];

			if ((ds.ModFlags & (Modifiers.PRIVATE | Modifiers.PROTECTED)) != 0){
				report.Error (1527, ds.Location, 
				"Namespace elements cannot be explicitly declared as private, protected or protected internal");
			}

			/* Here is a trick, for explicit attributes we don't know where they belong to until*/
			/* we parse succeeding declaration hence we parse them as normal and re-attach them*/
			/* when we know whether they are global (assembly:, module:) or local (type:).*/
			if (ds.OptAttributes != null) {
				ds.OptAttributes.ConvertGlobalAttributes (ds, current_namespace, !current_namespace.DeclarationFound && current_namespace == file);
			}
		}
		current_namespace.DeclarationFound = true;
	  }

void case_41()
#line 622 "cs-parser.jay"
{
		current_namespace.UnattachedAttributes = (Attributes) yyVals[-1+yyTop];
		report.Error (1518, lexer.Location, "Attributes must be attached to class, delegate, enum, interface or struct");
		lexer.putback ('}');
	  }

void case_49()
#line 655 "cs-parser.jay"
{
		var sect = (List<Attribute>) yyVals[0+yyTop];
		yyVal = new Attributes (sect);
		if (locationListStack.Count > 0)
			lbag.AddLocation (sect, locationListStack.Pop ());
		if (attributeCommas.Count > 0) {
			lbag.AppendTo (sect, attributeCommas);
			attributeCommas.Clear ();
		}
	  }

void case_50()
#line 666 "cs-parser.jay"
{
		Attributes attrs = yyVals[-1+yyTop] as Attributes;
		var sect = (List<Attribute>) yyVals[0+yyTop];
		
		if (locationListStack.Count > 0)
			lbag.AddLocation (sect, locationListStack.Pop ());
		if (attrs == null)
			attrs = new Attributes (sect);
		else
			attrs.AddAttributes (sect);
		yyVal = attrs;
	  }

void case_51()
#line 682 "cs-parser.jay"
{
		lexer.parsing_attribute_section = true;
		savedOpenLocation = GetLocation (yyVals[0+yyTop]);
	  }

void case_52()
#line 687 "cs-parser.jay"
{
		lexer.parsing_attribute_section = false;
		yyVal = yyVals[0+yyTop];
	  }

void case_53()
#line 695 "cs-parser.jay"
{
		current_attr_target = (string) yyVals[-1+yyTop];
		if (current_attr_target == "assembly" || current_attr_target == "module") {
			Lexer.check_incorrect_doc_comment ();
		}
	  }

void case_54()
#line 702 "cs-parser.jay"
{
		/* when attribute target is invalid*/
		if (current_attr_target == string.Empty)
			yyVal = new List<Attribute> (0);
		else
			yyVal = yyVals[-2+yyTop];
	  
		current_attr_target = null;
		lexer.parsing_attribute_section = false;
		if (yyVals[-1+yyTop] != null) {
			locationListStack.Push (new List<Location>(new [] { savedOpenLocation, savedCloseLocation, GetLocation (yyVals[-4+yyTop]), GetLocation (yyVals[-1+yyTop]), GetLocation (yyVals[0+yyTop]) }));
		} else {
			locationListStack.Push (new List<Location>(new [] { savedOpenLocation, savedCloseLocation, GetLocation (yyVals[-4+yyTop]), GetLocation (yyVals[0+yyTop]) }));
		}
 	  }

void case_55()
#line 718 "cs-parser.jay"
{
		yyVal = yyVals[-2+yyTop];
		if (yyVals[-1+yyTop] != null) {
			locationListStack.Push (new List<Location>(new [] { savedOpenLocation, GetLocation (yyVals[-1+yyTop]), GetLocation (yyVals[0+yyTop]) }));
		} else {
			locationListStack.Push (new List<Location>(new [] { savedOpenLocation, GetLocation (yyVals[0+yyTop]) }));
		}
	  }

void case_56()
#line 730 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[0+yyTop];
		yyVal = CheckAttributeTarget (lt.Value, lt.Location);
		savedCloseLocation = GetLocation (yyVals[0+yyTop]);
	  }

void case_59()
#line 738 "cs-parser.jay"
{
		if (yyToken == Token.IDENTIFIER) {
			Error_SyntaxError (yyToken);
			yyVal = null;
		} else {
			string name = GetTokenName (yyToken);
			yyVal = CheckAttributeTarget (name, GetLocation (yyVals[0+yyTop]));
		}
	  }

void case_61()
#line 755 "cs-parser.jay"
{
		var attrs = (List<Attribute>) yyVals[-2+yyTop];
		attrs.Add ((Attribute) yyVals[0+yyTop]);
		attributeCommas.Add (GetLocation (yyVals[-1+yyTop]));

		yyVal = attrs;
	  }

void case_63()
#line 770 "cs-parser.jay"
{
		--lexer.parsing_block;
		
		var tne = (ATypeNameExpression) yyVals[-2+yyTop];
		if (tne.HasTypeArguments) {
			report.Error (404, tne.Location, "Attributes cannot be generic");
		}
		Arguments [] arguments = (Arguments []) yyVals[0+yyTop];

		yyVal = new Attribute (current_attr_target, tne, (Arguments[]) yyVals[0+yyTop], GetLocation (yyVals[-2+yyTop]), lexer.IsEscapedIdentifier (tne));
		if (arguments != null) {
			attributeArgumentCommas.Insert (0, savedAttrParenOpenLocation);
			attributeArgumentCommas.Add (savedAttrParenCloseLocation);
			lbag.AddLocation (yyVal, attributeArgumentCommas);
			attributeArgumentCommas.Clear ();
		} else if (HadAttributeParens) {
			lbag.AddLocation (yyVal, savedAttrParenOpenLocation, savedAttrParenCloseLocation);
		}
	  }

void case_66()
#line 798 "cs-parser.jay"
{
		savedAttrParenOpenLocation = GetLocation (yyVals[-2+yyTop]);
		savedAttrParenCloseLocation = GetLocation (yyVals[0+yyTop]);
		yyVal = yyVals[-1+yyTop];
		HadAttributeParens = true;
	  }

void case_68()
#line 810 "cs-parser.jay"
{
	  	Arguments a = new Arguments (4);
		a.Add ((Argument) yyVals[0+yyTop]);
		yyVal = new Arguments [] { a, null };
	  }

void case_69()
#line 816 "cs-parser.jay"
{
	  	Arguments a = new Arguments (4);
		a.Add ((Argument) yyVals[0+yyTop]);  
		yyVal = new Arguments [] { null, a };
	  }

void case_70()
#line 822 "cs-parser.jay"
{
		Arguments[] o = (Arguments[]) yyVals[-2+yyTop];
		if (o [1] != null) {
			report.Error (1016, ((Argument) yyVals[0+yyTop]).Expr.Location, "Named attribute arguments must appear after the positional arguments");
			o [0] = new Arguments (4);
		}
		
		Arguments args = ((Arguments) o [0]);
		if (args.Count > 0 && !(yyVals[0+yyTop] is NamedArgument) && args [args.Count - 1] is NamedArgument)
			Error_NamedArgumentExpected ((NamedArgument) args [args.Count - 1]);
		
		args.Add ((Argument) yyVals[0+yyTop]);
		attributeArgumentCommas.Add (GetLocation (yyVals[-1+yyTop]));
	  }

void case_71()
#line 837 "cs-parser.jay"
{
		Arguments[] o = (Arguments[]) yyVals[-2+yyTop];
		if (o [1] == null) {
			o [1] = new Arguments (4);
		}

		((Arguments) o [1]).Add ((Argument) yyVals[0+yyTop]);
		attributeArgumentCommas.Add (GetLocation (yyVals[-1+yyTop]));
	  }

void case_75()
#line 862 "cs-parser.jay"
{
	  	--lexer.parsing_block;
	  	var lt = (Tokenizer.LocatedToken) yyVals[-3+yyTop];
		yyVal = new NamedArgument (lt.Value, lt.Location, (Expression) yyVals[0+yyTop]);	  
		lbag.AddLocation (yyVal, GetLocation(yyVals[-2+yyTop]));
	  }

void case_76()
#line 872 "cs-parser.jay"
{
		if (lang_version <= LanguageVersion.V_3)
			FeatureIsNotAvailable (GetLocation (yyVals[-3+yyTop]), "named argument");
			
		/* Avoid boxing in common case (no modifier)*/
		var arg_mod = yyVals[-1+yyTop] == null ? Argument.AType.None : (Argument.AType) yyVals[-1+yyTop];
			
		var lt = (Tokenizer.LocatedToken) yyVals[-3+yyTop];
		yyVal = new NamedArgument (lt.Value, lt.Location, (Expression) yyVals[0+yyTop], arg_mod);
		lbag.AddLocation (yyVal, GetLocation(yyVals[-2+yyTop]));
	  }

void case_95()
#line 926 "cs-parser.jay"
{
		report.Error (1519, lexer.Location, "Unexpected symbol `{0}' in class, struct, or interface member declaration",
			GetSymbolName (yyToken));
		yyVal = null;
		lexer.parsing_generic_declaration = false;
	  }

void case_97()
#line 943 "cs-parser.jay"
{ 
		push_current_container (new Struct (current_container, (MemberName) yyVals[0+yyTop], (Modifiers) yyVals[-4+yyTop], (Attributes) yyVals[-5+yyTop]), yyVals[-3+yyTop]);
		lbag.AddMember (current_container, GetModifierLocations (), GetLocation (yyVals[-2+yyTop]));
	  }

void case_98()
#line 949 "cs-parser.jay"
{
		lexer.ConstraintsParsing = false;

		if (yyVals[0+yyTop] != null)
			current_container.SetConstraints ((List<Constraints>) yyVals[0+yyTop]);

		if (doc_support)
			current_container.PartialContainer.DocComment = Lexer.consume_doc_comment ();

		
		lexer.parsing_modifiers = true;
	  }

void case_99()
#line 962 "cs-parser.jay"
{
		if (doc_support)
			Lexer.doc_state = XmlCommentState.Allowed;
	  }

void case_100()
#line 967 "cs-parser.jay"
{
		--lexer.parsing_declaration;
		if (doc_support)
			Lexer.doc_state = XmlCommentState.Allowed;
	  }

void case_101()
#line 973 "cs-parser.jay"
{
		if (yyVals[0+yyTop] == null) {
			lbag.AppendToMember (current_container, GetLocation (yyVals[-5+yyTop]), GetLocation (yyVals[-2+yyTop]));
		} else {
			lbag.AppendToMember (current_container, GetLocation (yyVals[-5+yyTop]), GetLocation (yyVals[-2+yyTop]), GetLocation (yyVals[0+yyTop]));
		}
		yyVal = pop_current_class ();
	  }

void case_103()
#line 991 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[0+yyTop];
		var mod = (Modifiers) yyVals[-3+yyTop];
		current_field = new Const (current_type, (FullNamedExpression) yyVals[-1+yyTop], mod, new MemberName (lt.Value, lt.Location), (Attributes) yyVals[-4+yyTop]);
		current_type.AddMember (current_field);
		
		if ((mod & Modifiers.STATIC) != 0) {
			report.Error (504, current_field.Location, "The constant `{0}' cannot be marked static", current_field.GetSignatureForError ());
		}
		
		yyVal = current_field;
	  }

void case_104()
#line 1004 "cs-parser.jay"
{
		if (doc_support) {
			current_field.DocComment = Lexer.consume_doc_comment ();
			Lexer.doc_state = XmlCommentState.Allowed;
		}
		
		current_field.Initializer = (ConstInitializer) yyVals[-2+yyTop];
		lbag.AddMember (current_field, GetModifierLocations (), GetLocation (yyVals[-6+yyTop]), GetLocation (yyVals[0+yyTop]));
		current_field = null;
	  }

void case_109()
#line 1034 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[-1+yyTop];
	  	yyVal = new FieldDeclarator (new SimpleMemberName (lt.Value, lt.Location), (ConstInitializer) yyVals[0+yyTop]);
	  	lbag.AddLocation (yyVal, GetLocation (yyVals[-2+yyTop]));
	  }

void case_111()
#line 1047 "cs-parser.jay"
{
		--lexer.parsing_block;
		yyVal = new ConstInitializer (current_field, (Expression) yyVals[0+yyTop], GetLocation (yyVals[-2+yyTop]));
	  	lbag.AddLocation (yyVal, GetLocation (yyVals[-2+yyTop]));
	  }

void case_112()
#line 1053 "cs-parser.jay"
{
		report.Error (145, lexer.Location, "A const field requires a value to be provided");
		yyVal = null;
	  }

void case_115()
#line 1068 "cs-parser.jay"
{
	  	lexer.parsing_generic_declaration = false;

		FullNamedExpression type = (FullNamedExpression) yyVals[-1+yyTop];
		if (type.Type != null && type.Type.Kind == MemberKind.Void)
			report.Error (670, GetLocation (yyVals[-1+yyTop]), "Fields cannot have void type");
			
		var lt = (Tokenizer.LocatedToken) yyVals[0+yyTop];
		current_field = new Field (current_type, type, (Modifiers) yyVals[-2+yyTop], new MemberName (lt.Value, lt.Location), (Attributes) yyVals[-3+yyTop]);
		current_type.AddField (current_field);
		yyVal = current_field;
	  }

void case_116()
#line 1083 "cs-parser.jay"
{ 
		if (doc_support) {
			current_field.DocComment = Lexer.consume_doc_comment ();
			Lexer.doc_state = XmlCommentState.Allowed;
		}
			
		lbag.AddMember (current_field, GetModifierLocations (), GetLocation (yyVals[0+yyTop]));
		yyVal = current_field;
		current_field = null;
	  }

void case_117()
#line 1096 "cs-parser.jay"
{ 
		if (lang_version < LanguageVersion.ISO_2)
			FeatureIsNotAvailable (GetLocation (yyVals[-2+yyTop]), "fixed size buffers");

		var lt = (Tokenizer.LocatedToken) yyVals[0+yyTop];
		current_field = new FixedField (current_type, (FullNamedExpression) yyVals[-1+yyTop], (Modifiers) yyVals[-3+yyTop],
			new MemberName (lt.Value, lt.Location), (Attributes) yyVals[-4+yyTop]);
			
		current_type.AddField (current_field);
	  }

void case_118()
#line 1107 "cs-parser.jay"
{
		if (doc_support) {
			current_field.DocComment = Lexer.consume_doc_comment ();
			Lexer.doc_state = XmlCommentState.Allowed;
	    }

		current_field.Initializer = (ConstInitializer) yyVals[-2+yyTop];	    
		lbag.AddMember (current_field, GetModifierLocations (), GetLocation (yyVals[-6+yyTop]), GetLocation (yyVals[0+yyTop]));
		yyVal = current_field;
	    current_field = null;
	  }

void case_121()
#line 1130 "cs-parser.jay"
{
	  	++lexer.parsing_block;
		current_local_parameters = ParametersCompiled.EmptyReadOnlyParameters;
	  	start_block (GetLocation (yyVals[0+yyTop]));
	  }

void case_122()
#line 1136 "cs-parser.jay"
{
	  	--lexer.parsing_block;
		current_field.Initializer = (Expression) yyVals[0+yyTop];
		lbag.AppendToMember (current_field, GetLocation (yyVals[-2+yyTop]));
		end_block (lexer.Location);
		current_local_parameters = null;
	  }

void case_127()
#line 1163 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[0+yyTop];
	  	yyVal = new FieldDeclarator (new SimpleMemberName (lt.Value, lt.Location), null);
	  	lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_129()
#line 1173 "cs-parser.jay"
{
		--lexer.parsing_block;
		var lt = (Tokenizer.LocatedToken) yyVals[-3+yyTop];	  
	  	yyVal = new FieldDeclarator (new SimpleMemberName (lt.Value, lt.Location), (Expression) yyVals[0+yyTop]);
	  	lbag.AddLocation (yyVal, GetLocation (yyVals[-4+yyTop]), GetLocation (yyVals[-2+yyTop]));
	  }

void case_134()
#line 1199 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[-1+yyTop];	  
		yyVal = new FieldDeclarator (new SimpleMemberName (lt.Value, lt.Location), (ConstInitializer) yyVals[0+yyTop]);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-2+yyTop]));
	  }

void case_136()
#line 1212 "cs-parser.jay"
{
		--lexer.parsing_block;
		yyVal = new ConstInitializer (current_field, (Expression) yyVals[-1+yyTop], GetLocation (yyVals[-3+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_137()
#line 1218 "cs-parser.jay"
{
		report.Error (443, lexer.Location, "Value or constant expected");
		yyVal = null;
	  }

void case_140()
#line 1228 "cs-parser.jay"
{
		/* It has to be here for the parent to safely restore artificial block*/
	  	Error_SyntaxError (yyToken);
	  	yyVal = null;
	  }

void case_141()
#line 1237 "cs-parser.jay"
{
		if (doc_support)
			Lexer.doc_state = XmlCommentState.NotAllowed;

		/* Add it early in the case of body being eof for full ast*/
		Method m = (Method) yyVals[0+yyTop];
		async_block = (m.ModFlags & Modifiers.ASYNC) != 0;
		current_type.AddMember (m);
	  }

void case_142()
#line 1247 "cs-parser.jay"
{
		Method method = (Method) yyVals[-2+yyTop];
		method.Block = (ToplevelBlock) yyVals[0+yyTop];
		async_block = false;
		
		if (method.Block == null) {
			lbag.AppendToMember (method, savedLocation); /* semicolon*/
			method.ParameterInfo.CheckParameters (method);

			if ((method.ModFlags & Modifiers.ASYNC) != 0) {
				report.Error (1994, method.Location, "`{0}': The async modifier can only be used with methods that have a body",
					method.GetSignatureForError ());
			}
		} else {
			if (current_container.Kind == MemberKind.Interface) {
				report.Error (531, method.Location, "`{0}': interface members cannot have a definition",
					method.GetSignatureForError ());
			}
		}

		current_local_parameters = null;

		if (doc_support)
			Lexer.doc_state = XmlCommentState.Allowed;
	  }

void case_145()
#line 1287 "cs-parser.jay"
{
		lexer.ConstraintsParsing = false;
		valid_param_mod = 0;
		MemberName name = (MemberName) yyVals[-6+yyTop];
		current_local_parameters = (ParametersCompiled) yyVals[-3+yyTop];

		var method = Method.Create (current_type, (FullNamedExpression) yyVals[-7+yyTop], (Modifiers) yyVals[-8+yyTop],
				     name, current_local_parameters, (Attributes) yyVals[-9+yyTop], yyVals[0+yyTop] != null);

		if (yyVals[0+yyTop] != null)
			method.SetConstraints ((List<Constraints>) yyVals[0+yyTop]);
				     
		if (doc_support)
			method.DocComment = Lexer.consume_doc_comment ();

		lbag.AddMember (method, GetModifierLocations (), GetLocation (yyVals[-5+yyTop]), GetLocation (yyVals[-2+yyTop]));
		yyVal = method;
	  }

void case_147()
#line 1314 "cs-parser.jay"
{
		lexer.parsing_generic_declaration = false;
	  	valid_param_mod = ParameterModifierType.All;
	  }

void case_149()
#line 1323 "cs-parser.jay"
{
		lexer.ConstraintsParsing = false;
		valid_param_mod = 0;

		MemberName name = (MemberName) yyVals[-6+yyTop];
		current_local_parameters = (ParametersCompiled) yyVals[-3+yyTop];

		var modifiers = (Modifiers) yyVals[-10+yyTop];
		modifiers |= Modifiers.PARTIAL;

		var method = Method.Create (current_type, new TypeExpression (compiler.BuiltinTypes.Void, GetLocation (yyVals[-8+yyTop])),
				     modifiers, name, current_local_parameters, (Attributes) yyVals[-11+yyTop], yyVals[-1+yyTop] != null);

		if (yyVals[-1+yyTop] != null)
			method.SetConstraints ((List<Constraints>) yyVals[-1+yyTop]);

		if (doc_support)
			method.DocComment = Lexer.consume_doc_comment ();

		StoreModifierLocation (Modifiers.PARTIAL, GetLocation (yyVals[-9+yyTop]));
		lbag.AddMember (method, GetModifierLocations (), GetLocation (yyVals[-5+yyTop]), GetLocation (yyVals[-2+yyTop]));
		yyVal = method;
	  }

void case_150()
#line 1350 "cs-parser.jay"
{
		MemberName name = (MemberName) yyVals[-3+yyTop];
		report.Error (1585, name.Location, 
			"Member modifier `{0}' must precede the member type and name", ModifiersExtensions.Name ((Modifiers) yyVals[-4+yyTop]));

		var method = Method.Create (current_type, (FullNamedExpression) yyVals[-5+yyTop],
					    0, name, (ParametersCompiled) yyVals[-1+yyTop], (Attributes) yyVals[-7+yyTop], false);

		current_local_parameters = (ParametersCompiled) yyVals[-1+yyTop];

		if (doc_support)
			method.DocComment = Lexer.consume_doc_comment ();

		yyVal = method;
	  }

void case_151()
#line 1369 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);
		current_local_parameters = ParametersCompiled.Undefined;

		MemberName name = (MemberName) yyVals[-1+yyTop];
		var method = Method.Create (current_type, (FullNamedExpression) yyVals[-2+yyTop], (Modifiers) yyVals[-3+yyTop],
									name, current_local_parameters, (Attributes) yyVals[-4+yyTop], false);

		if (doc_support)
			method.DocComment = Lexer.consume_doc_comment ();

		yyVal = method;
	  }

void case_156()
#line 1396 "cs-parser.jay"
{
		var pars_list = (List<Parameter>) yyVals[0+yyTop];
	  	yyVal = new ParametersCompiled (pars_list.ToArray ());
	  	lbag.AddLocation (yyVal, parameterListCommas);
	  }

void case_157()
#line 1402 "cs-parser.jay"
{
		var pars_list = (List<Parameter>) yyVals[-2+yyTop];
		pars_list.Add ((Parameter) yyVals[0+yyTop]);
		parameterListCommas.Add (GetLocation (yyVals[-1+yyTop]));
		
		yyVal = new ParametersCompiled (pars_list.ToArray ()); 
	  	lbag.AddLocation (yyVal, parameterListCommas);
	  }

void case_158()
#line 1411 "cs-parser.jay"
{
		var pars_list = (List<Parameter>) yyVals[-2+yyTop];
		pars_list.Add (new ArglistParameter (GetLocation (yyVals[0+yyTop])));
		parameterListCommas.Add (GetLocation (yyVals[-1+yyTop]));
		
		yyVal = new ParametersCompiled (pars_list.ToArray (), true);
	  	lbag.AddLocation (yyVal, parameterListCommas);
	  }

void case_159()
#line 1420 "cs-parser.jay"
{
		if (yyVals[-2+yyTop] != null)
			report.Error (231, ((Parameter) yyVals[-2+yyTop]).Location, "A params parameter must be the last parameter in a formal parameter list");

		yyVal = new ParametersCompiled (new Parameter[] { (Parameter) yyVals[-2+yyTop] } );			
	  	lbag.AddLocation (yyVal, parameterListCommas);
	  }

void case_160()
#line 1428 "cs-parser.jay"
{
		if (yyVals[-2+yyTop] != null)
			report.Error (231, ((Parameter) yyVals[-2+yyTop]).Location, "A params parameter must be the last parameter in a formal parameter list");

		var pars_list = (List<Parameter>) yyVals[-4+yyTop];
		pars_list.Add (new ArglistParameter (GetLocation (yyVals[-2+yyTop])));
		parameterListCommas.Add (GetLocation (yyVals[-3+yyTop]));
		parameterListCommas.Add (GetLocation (yyVals[-1+yyTop]));
		
		yyVal = new ParametersCompiled (pars_list.ToArray (), true);
	  	lbag.AddLocation (yyVal, parameterListCommas);
	  }

void case_161()
#line 1441 "cs-parser.jay"
{
		report.Error (257, GetLocation (yyVals[-2+yyTop]), "An __arglist parameter must be the last parameter in a formal parameter list");

		yyVal = new ParametersCompiled (new Parameter [] { new ArglistParameter (GetLocation (yyVals[-2+yyTop])) }, true);
	  	lbag.AddLocation (yyVal, parameterListCommas);
	  }

void case_162()
#line 1448 "cs-parser.jay"
{
		report.Error (257, GetLocation (yyVals[-2+yyTop]), "An __arglist parameter must be the last parameter in a formal parameter list");

		var pars_list = (List<Parameter>) yyVals[-4+yyTop];
		pars_list.Add (new ArglistParameter (GetLocation (yyVals[-2+yyTop])));
		parameterListCommas.Add (GetLocation (yyVals[-3+yyTop]));
		parameterListCommas.Add (GetLocation (yyVals[-1+yyTop]));

		yyVal = new ParametersCompiled (pars_list.ToArray (), true);
	  	lbag.AddLocation (yyVal, parameterListCommas);
	  }

void case_165()
#line 1468 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);
		yyVal = ParametersCompiled.EmptyReadOnlyParameters;
	  }

void case_166()
#line 1476 "cs-parser.jay"
{
		parameters_bucket.Clear ();
		Parameter p = (Parameter) yyVals[0+yyTop];
		parameters_bucket.Add (p);
		parameterListCommas.Clear ();
		default_parameter_used = p.HasDefaultValue;
		yyVal = parameters_bucket;
	  }

void case_167()
#line 1485 "cs-parser.jay"
{
		var pars = (List<Parameter>) yyVals[-2+yyTop];
		Parameter p = (Parameter) yyVals[0+yyTop];
		if (p != null) {
			if (p.HasExtensionMethodModifier)
				report.Error (1100, p.Location, "The parameter modifier `this' can only be used on the first parameter");
			else if (!p.HasDefaultValue && default_parameter_used)
				report.Error (1737, p.Location, "Optional parameter cannot precede required parameters");

			default_parameter_used |= p.HasDefaultValue;
			pars.Add (p);
			
			parameterListCommas.Add (GetLocation (yyVals[-1+yyTop]));
		}
		
		yyVal = yyVals[-2+yyTop];
	  }

void case_168()
#line 1509 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[0+yyTop];
		yyVal = new Parameter ((FullNamedExpression) yyVals[-1+yyTop], lt.Value, (Parameter.Modifier) yyVals[-2+yyTop], (Attributes) yyVals[-3+yyTop], lt.Location);
		lbag.AddLocation (yyVal, parameterModifierLocation);
	  }

void case_169()
#line 1518 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[-2+yyTop];
		report.Error (1552, lt.Location, "Array type specifier, [], must appear before parameter name");
		yyVal = new Parameter ((FullNamedExpression) yyVals[-3+yyTop], lt.Value, (Parameter.Modifier) yyVals[-4+yyTop], (Attributes) yyVals[-5+yyTop], lt.Location);
		lbag.AddLocation (yyVal, parameterModifierLocation);
	  }

void case_170()
#line 1525 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);
	  	Location l = GetLocation (yyVals[0+yyTop]);
		yyVal = new Parameter (null, null, Parameter.Modifier.NONE, (Attributes) yyVals[-1+yyTop], l);
	  }

void case_171()
#line 1534 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);
	  	Location l = GetLocation (yyVals[0+yyTop]);
		yyVal = new Parameter ((FullNamedExpression) yyVals[-1+yyTop], null, (Parameter.Modifier) yyVals[-2+yyTop], (Attributes) yyVals[-3+yyTop], l);
		lbag.AddLocation (yyVal, parameterModifierLocation);
	  }

void case_173()
#line 1549 "cs-parser.jay"
{
	  	--lexer.parsing_block;
		if (lang_version <= LanguageVersion.V_3) {
			FeatureIsNotAvailable (GetLocation (yyVals[-2+yyTop]), "optional parameter");
		}
		
		Parameter.Modifier mod = (Parameter.Modifier) yyVals[-5+yyTop];
		if (mod != Parameter.Modifier.NONE) {
			switch (mod) {
			case Parameter.Modifier.REF:
			case Parameter.Modifier.OUT:
				report.Error (1741, GetLocation (yyVals[-5+yyTop]), "Cannot specify a default value for the `{0}' parameter",
					Parameter.GetModifierSignature (mod));
				break;
				
			case Parameter.Modifier.This:
				report.Error (1743, GetLocation (yyVals[-5+yyTop]), "Cannot specify a default value for the `{0}' parameter",
					Parameter.GetModifierSignature (mod));
				break;
			default:
				throw new NotImplementedException (mod.ToString ());
			}
				
			mod = Parameter.Modifier.NONE;
		}
		
		if ((valid_param_mod & ParameterModifierType.DefaultValue) == 0)
			report.Error (1065, GetLocation (yyVals[-2+yyTop]), "Optional parameter is not valid in this context");
		
		var lt = (Tokenizer.LocatedToken) yyVals[-3+yyTop];
		yyVal = new Parameter ((FullNamedExpression) yyVals[-4+yyTop], lt.Value, mod, (Attributes) yyVals[-6+yyTop], lt.Location);
		lbag.AddLocation (yyVal, parameterModifierLocation, GetLocation (yyVals[-2+yyTop])); /* parameterModifierLocation should be ignored when mod == NONE*/
		
		if (yyVals[0+yyTop] != null)
			((Parameter) yyVal).DefaultValue = new DefaultParameterValueExpression ((Expression) yyVals[0+yyTop]);
	  }

void case_177()
#line 1598 "cs-parser.jay"
{
		Parameter.Modifier p2 = (Parameter.Modifier)yyVals[0+yyTop];
  		Parameter.Modifier mod = (Parameter.Modifier)yyVals[-1+yyTop] | p2;
  		if (((Parameter.Modifier)yyVals[-1+yyTop] & p2) == p2) {
  			Error_DuplicateParameterModifier (lexer.Location, p2);
  		} else {
	  		switch (mod & ~Parameter.Modifier.This) {
  				case Parameter.Modifier.REF:
					report.Error (1101, lexer.Location, "The parameter modifiers `this' and `ref' cannot be used altogether");
  					break;
   				case Parameter.Modifier.OUT:
					report.Error (1102, lexer.Location, "The parameter modifiers `this' and `out' cannot be used altogether");
  					break;
  				default:
 					report.Error (1108, lexer.Location, "A parameter cannot have specified more than one modifier");
 					break;
 			}
  		}
  		yyVal = mod;
	  }

void case_178()
#line 1622 "cs-parser.jay"
{
	  	if ((valid_param_mod & ParameterModifierType.Ref) == 0)
	  		Error_ParameterModifierNotValid ("ref", GetLocation (yyVals[0+yyTop]));
		parameterModifierLocation = GetLocation (yyVals[0+yyTop]);
	  	yyVal = Parameter.Modifier.REF;
	  }

void case_179()
#line 1629 "cs-parser.jay"
{
	  	if ((valid_param_mod & ParameterModifierType.Out) == 0)
	  		Error_ParameterModifierNotValid ("out", GetLocation (yyVals[0+yyTop]));
		parameterModifierLocation = GetLocation (yyVals[0+yyTop]);
	  	yyVal = Parameter.Modifier.OUT;
	  }

void case_180()
#line 1636 "cs-parser.jay"
{
		if ((valid_param_mod & ParameterModifierType.This) == 0)
	  		Error_ParameterModifierNotValid ("this", GetLocation (yyVals[0+yyTop]));

	  	if (lang_version <= LanguageVersion.ISO_2)
	  		FeatureIsNotAvailable (GetLocation (yyVals[0+yyTop]), "extension methods");
		parameterModifierLocation = GetLocation (yyVals[0+yyTop]);
		yyVal = Parameter.Modifier.This;
	  }

void case_181()
#line 1649 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[0+yyTop];
		yyVal = new ParamsParameter ((FullNamedExpression) yyVals[-1+yyTop], lt.Value, (Attributes) yyVals[-3+yyTop], lt.Location);
		lbag.AddLocation (yyVal, savedLocation);
	  }

void case_182()
#line 1655 "cs-parser.jay"
{
		report.Error (1751, GetLocation (yyVals[-4+yyTop]), "Cannot specify a default value for a parameter array");
		
		var lt = (Tokenizer.LocatedToken) yyVals[-2+yyTop];
		yyVal = new ParamsParameter ((FullNamedExpression) yyVals[-3+yyTop], lt.Value, (Attributes) yyVals[-5+yyTop], lt.Location);		
		lbag.AddLocation (yyVal, savedLocation);
	  }

void case_183()
#line 1663 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);
		yyVal = null;
	  }

void case_184()
#line 1671 "cs-parser.jay"
{
		if ((valid_param_mod & ParameterModifierType.Params) == 0)
			report.Error (1670, (GetLocation (yyVals[0+yyTop])), "The `params' modifier is not allowed in current context");
		savedLocation = GetLocation (yyVals[0+yyTop]);
	  }

void case_185()
#line 1677 "cs-parser.jay"
{
		Parameter.Modifier mod = (Parameter.Modifier)yyVals[0+yyTop];
		if ((mod & Parameter.Modifier.This) != 0) {
			report.Error (1104, GetLocation (yyVals[-1+yyTop]), "The parameter modifiers `this' and `params' cannot be used altogether");
		} else {
			report.Error (1611, GetLocation (yyVals[-1+yyTop]), "The params parameter cannot be declared as ref or out");
		}	  
		savedLocation = GetLocation (yyVals[-1+yyTop]);
	  }

void case_187()
#line 1694 "cs-parser.jay"
{
	  	if ((valid_param_mod & ParameterModifierType.Arglist) == 0)
	  		report.Error (1669, GetLocation (yyVals[0+yyTop]), "__arglist is not valid in this context");
	  }

void case_188()
#line 1705 "cs-parser.jay"
{
		if (doc_support)
			tmpComment = Lexer.consume_doc_comment ();
	  }

void case_189()
#line 1710 "cs-parser.jay"
{
		var type = (FullNamedExpression) yyVals[-3+yyTop];
		current_property = new Property (current_type, type, (Modifiers) yyVals[-4+yyTop],
			(MemberName) yyVals[-2+yyTop], (Attributes) yyVals[-5+yyTop]);
			
		if (type.Type != null && type.Type.Kind == MemberKind.Void)
			report.Error (547, GetLocation (yyVals[-3+yyTop]), "`{0}': property or indexer cannot have void type", current_property.GetSignatureForError ());					
			
		current_type.AddMember (current_property);
		lbag.AddMember (current_property, GetModifierLocations (), GetLocation (yyVals[0+yyTop]));
		
		lexer.PropertyParsing = true;
	  }

void case_190()
#line 1724 "cs-parser.jay"
{
		lexer.PropertyParsing = false;
		
		if (doc_support)
			current_property.DocComment = ConsumeStoredComment ();				
	  }

void case_191()
#line 1731 "cs-parser.jay"
{
		lbag.AppendToMember (current_property, GetLocation (yyVals[0+yyTop]));
		current_property = null;
	  }

void case_193()
#line 1745 "cs-parser.jay"
{
		valid_param_mod = 0;
		var type = (FullNamedExpression) yyVals[-6+yyTop];
		Indexer indexer = new Indexer (current_type, type, (MemberName) yyVals[-5+yyTop], (Modifiers) yyVals[-7+yyTop], (ParametersCompiled) yyVals[-2+yyTop], (Attributes) yyVals[-8+yyTop]);
			
		current_property = indexer;

  		current_type.AddIndexer (indexer);
		lbag.AddMember (current_property, GetModifierLocations (), GetLocation (yyVals[-4+yyTop]), GetLocation (yyVals[-1+yyTop]), GetLocation (yyVals[0+yyTop]));
  		
		if (type.Type != null && type.Type.Kind == MemberKind.Void)
			report.Error (620, GetLocation (yyVals[-6+yyTop]), "`{0}': indexer return type cannot be `void'", indexer.GetSignatureForError ());  		

		if (indexer.ParameterInfo.IsEmpty) {
			report.Error (1551, GetLocation (yyVals[-4+yyTop]), "Indexers must have at least one parameter");
		}

		if (doc_support) {
			tmpComment = Lexer.consume_doc_comment ();
			Lexer.doc_state = XmlCommentState.Allowed;
		}

		lexer.PropertyParsing = true;
	  }

void case_195()
#line 1774 "cs-parser.jay"
{
		if (current_property.AccessorFirst != null && current_property.AccessorFirst.Block == null)
			((Indexer) current_property).ParameterInfo.CheckParameters (current_property);
	  
		if (doc_support)
			current_property.DocComment = ConsumeStoredComment ();
			
		lbag.AppendToMember (current_property, GetLocation (yyVals[-1+yyTop]));
		current_property = null;		
	  }

void case_200()
#line 1793 "cs-parser.jay"
{
	  	if (yyToken == Token.CLOSE_BRACE) {
	  		report.Error (548, lexer.Location, "`{0}': property or indexer must have at least one accessor", current_property.GetSignatureForError ());
		} else {
			if (yyToken == Token.SEMICOLON)
				report.Error (1597, lexer.Location, "Semicolon after method or accessor block is not valid");
			else
				report.Error (1014, GetLocation (yyVals[0+yyTop]), "A get or set accessor expected");
		}
	  }

void case_201()
#line 1807 "cs-parser.jay"
{
		if (yyVals[-1+yyTop] != ModifierNone && lang_version == LanguageVersion.ISO_1) {
			FeatureIsNotAvailable (GetLocation (yyVals[-1+yyTop]), "access modifiers on properties");
		}
	  
		if (current_property.Get != null) {
			report.Error (1007, GetLocation (yyVals[0+yyTop]), "Property accessor already defined");
		}
		
		if (current_property is Indexer) {
			current_property.Get = new Indexer.GetIndexerMethod (current_property, (Modifiers) yyVals[-1+yyTop], ((Indexer)current_property).ParameterInfo.Clone (),
				(Attributes) yyVals[-2+yyTop], GetLocation (yyVals[0+yyTop]));
		} else {
			current_property.Get = new Property.GetMethod (current_property,
				(Modifiers) yyVals[-1+yyTop], (Attributes) yyVals[-2+yyTop], GetLocation (yyVals[0+yyTop]));
		}	
	  
		current_local_parameters = current_property.Get.ParameterInfo;	  
		lexer.PropertyParsing = false;
	  }

void case_202()
#line 1828 "cs-parser.jay"
{
	  	if (yyVals[0+yyTop] != null) {
	  		current_property.Get.Block = (ToplevelBlock) yyVals[0+yyTop];			
	  	
			if (current_container.Kind == MemberKind.Interface) {
				report.Error (531, current_property.Get.Block.StartLocation,
					"`{0}': interface members cannot have a definition", current_property.Get.GetSignatureForError ());
			}
			lbag.AddMember (current_property.Get, GetModifierLocations ());
		} else {
			lbag.AddMember (current_property.Get, GetModifierLocations (), savedLocation);
		}
	  
		current_local_parameters = null;
		lexer.PropertyParsing = true;

		if (doc_support)
			if (Lexer.doc_state == XmlCommentState.Error)
				Lexer.doc_state = XmlCommentState.NotAllowed;
	  }

void case_203()
#line 1852 "cs-parser.jay"
{
		if (yyVals[-1+yyTop] != ModifierNone && lang_version == LanguageVersion.ISO_1) {
			FeatureIsNotAvailable (GetLocation (yyVals[-1+yyTop]), "access modifiers on properties");
		}
		
		if (current_property.Set != null) {
			report.Error (1007, GetLocation (yyVals[0+yyTop]), "Property accessor already defined");
		}
	  
		if (current_property is Indexer) {
			current_property.Set = new Indexer.SetIndexerMethod (current_property, (Modifiers) yyVals[-1+yyTop],
				ParametersCompiled.MergeGenerated (compiler,
				((Indexer)current_property).ParameterInfo, true, new Parameter (
					current_property.TypeExpression, "value", Parameter.Modifier.NONE, null, GetLocation (yyVals[0+yyTop])),
					null),
				(Attributes) yyVals[-2+yyTop], GetLocation (yyVals[0+yyTop]));
		} else {
			current_property.Set = new Property.SetMethod (current_property, (Modifiers) yyVals[-1+yyTop], 
				ParametersCompiled.CreateImplicitParameter (current_property.TypeExpression, GetLocation (yyVals[0+yyTop])),
				(Attributes) yyVals[-2+yyTop], GetLocation (yyVals[0+yyTop]));
		}
		
		current_local_parameters = current_property.Set.ParameterInfo;	
		lexer.PropertyParsing = false;
	  }

void case_204()
#line 1878 "cs-parser.jay"
{
		if (yyVals[0+yyTop] != null) {		
			current_property.Set.Block = (ToplevelBlock) yyVals[0+yyTop];
		
			if (current_container.Kind == MemberKind.Interface) {
				report.Error (531, current_property.Set.Block.StartLocation,
					"`{0}': interface members cannot have a definition", current_property.Set.GetSignatureForError ());
			}
			lbag.AddMember (current_property.Set, GetModifierLocations ());
		} else {
			lbag.AddMember (current_property.Set, GetModifierLocations (), savedLocation);
		}
		
		current_local_parameters = null;
		lexer.PropertyParsing = true;

		if (doc_support
			&& Lexer.doc_state == XmlCommentState.Error)
			Lexer.doc_state = XmlCommentState.NotAllowed;
	  }

void case_206()
#line 1903 "cs-parser.jay"
{
		savedLocation = GetLocation (yyVals[0+yyTop]);
	  	yyVal = null;
	  }

void case_207()
#line 1908 "cs-parser.jay"
{
	  	Error_SyntaxError (1043, yyToken, "Invalid accessor body");
	  	yyVal = null;
	  }

void case_209()
#line 1923 "cs-parser.jay"
{
		push_current_container (new Interface (current_container, (MemberName) yyVals[0+yyTop], (Modifiers) yyVals[-4+yyTop], (Attributes) yyVals[-5+yyTop]), yyVals[-3+yyTop]);
		lbag.AddMember (current_container, GetModifierLocations (), GetLocation (yyVals[-2+yyTop]));		
	  }

void case_210()
#line 1929 "cs-parser.jay"
{
		lexer.ConstraintsParsing = false;

		if (yyVals[0+yyTop] != null)
			current_container.SetConstraints ((List<Constraints>) yyVals[0+yyTop]);

		if (doc_support) {
			current_container.PartialContainer.DocComment = Lexer.consume_doc_comment ();
			Lexer.doc_state = XmlCommentState.Allowed;
		}
		
		lexer.parsing_modifiers = true;
	  }

void case_211()
#line 1943 "cs-parser.jay"
{
		--lexer.parsing_declaration;	  
		if (doc_support)
			Lexer.doc_state = XmlCommentState.Allowed;
	  }

void case_212()
#line 1949 "cs-parser.jay"
{
		if (yyVals[0+yyTop] == null) {
			lbag.AppendToMember (current_container, GetLocation (yyVals[-4+yyTop]), GetLocation (yyVals[-2+yyTop]));
		} else {
			lbag.AppendToMember (current_container, GetLocation (yyVals[-4+yyTop]), GetLocation (yyVals[-2+yyTop]), GetLocation (yyVals[0+yyTop]));
		}
		yyVal = pop_current_class ();
	  }

void case_228()
#line 2011 "cs-parser.jay"
{
		OperatorDeclaration decl = (OperatorDeclaration) yyVals[-2+yyTop];
		if (decl != null) {
			Operator op = new Operator (
				current_type, decl.optype, decl.ret_type, (Modifiers) yyVals[-3+yyTop], 
				current_local_parameters,
				(ToplevelBlock) yyVals[0+yyTop], (Attributes) yyVals[-4+yyTop], decl.location);
				
			if (op.Block == null)
				op.ParameterInfo.CheckParameters (op);

			if (doc_support) {
				op.DocComment = tmpComment;
				Lexer.doc_state = XmlCommentState.Allowed;
			}

			/* Note again, checking is done in semantic analysis*/
			current_type.AddOperator (op);

			lbag.AddMember (op, GetModifierLocations (), lbag.GetLocations (decl));
			if (yyVals[0+yyTop] == null) { /* Semicolon*/
				lbag.AppendTo (op, savedLocation); 
			}
		}
		
		current_local_parameters = null;
	  }

void case_232()
#line 2048 "cs-parser.jay"
{
		report.Error (590, GetLocation (yyVals[0+yyTop]), "User-defined operators cannot return void");
		yyVal = new TypeExpression (compiler.BuiltinTypes.Void, GetLocation (yyVals[0+yyTop]));
	  }

void case_234()
#line 2060 "cs-parser.jay"
{
		valid_param_mod = 0;

		Location loc = GetLocation (yyVals[-5+yyTop]);
		Operator.OpType op = (Operator.OpType) yyVals[-4+yyTop];
		current_local_parameters = (ParametersCompiled)yyVals[-1+yyTop];
		
		int p_count = current_local_parameters.Count;
		if (p_count == 1) {
			if (op == Operator.OpType.Addition)
				op = Operator.OpType.UnaryPlus;
			else if (op == Operator.OpType.Subtraction)
				op = Operator.OpType.UnaryNegation;
		}
		
		if (IsUnaryOperator (op)) {
			if (p_count == 2) {
				report.Error (1020, loc, "Overloadable binary operator expected");
			} else if (p_count != 1) {
				report.Error (1535, loc, "Overloaded unary operator `{0}' takes one parameter",
					Operator.GetName (op));
			}
		} else {
			if (p_count > 2) {
				report.Error (1534, loc, "Overloaded binary operator `{0}' takes two parameters",
					Operator.GetName (op));
			} else if (p_count != 2) {
				report.Error (1019, loc, "Overloadable unary operator expected");
			}
		}
		
		if (doc_support) {
			tmpComment = Lexer.consume_doc_comment ();
			Lexer.doc_state = XmlCommentState.NotAllowed;
		}

		yyVal = new OperatorDeclaration (op, (FullNamedExpression) yyVals[-6+yyTop], loc);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-5+yyTop]), savedOperatorLocation, GetLocation (yyVals[-3+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_259()
#line 2136 "cs-parser.jay"
{
		valid_param_mod = 0;

		Location loc = GetLocation (yyVals[-5+yyTop]);
		current_local_parameters = (ParametersCompiled)yyVals[-1+yyTop];  
		  
		if (doc_support) {
			tmpComment = Lexer.consume_doc_comment ();
			Lexer.doc_state = XmlCommentState.NotAllowed;
		}

		yyVal = new OperatorDeclaration (Operator.OpType.Implicit, (FullNamedExpression) yyVals[-4+yyTop], loc);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-6+yyTop]), GetLocation (yyVals[-5+yyTop]), GetLocation (yyVals[-3+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_261()
#line 2155 "cs-parser.jay"
{
		valid_param_mod = 0;
		
		Location loc = GetLocation (yyVals[-5+yyTop]);
		current_local_parameters = (ParametersCompiled)yyVals[-1+yyTop];  
		  
		if (doc_support) {
			tmpComment = Lexer.consume_doc_comment ();
			Lexer.doc_state = XmlCommentState.NotAllowed;
		}

		yyVal = new OperatorDeclaration (Operator.OpType.Explicit, (FullNamedExpression) yyVals[-4+yyTop], loc);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-6+yyTop]), GetLocation (yyVals[-5+yyTop]), GetLocation (yyVals[-3+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_262()
#line 2170 "cs-parser.jay"
{
	  	Error_SyntaxError (yyToken);
		current_local_parameters = ParametersCompiled.EmptyReadOnlyParameters;
		yyVal = new OperatorDeclaration (Operator.OpType.Implicit, null, GetLocation (yyVals[-1+yyTop]));
	  }

void case_263()
#line 2176 "cs-parser.jay"
{
	  	Error_SyntaxError (yyToken);
		current_local_parameters = ParametersCompiled.EmptyReadOnlyParameters;
	  	yyVal = new OperatorDeclaration (Operator.OpType.Explicit, null, GetLocation (yyVals[-1+yyTop]));
	  }

void case_264()
#line 2186 "cs-parser.jay"
{ 
		Constructor c = (Constructor) yyVals[-1+yyTop];
		c.Block = (ToplevelBlock) yyVals[0+yyTop];
		
		if (doc_support)
			c.DocComment = ConsumeStoredComment ();

		current_local_parameters = null;
		if (doc_support)
			Lexer.doc_state = XmlCommentState.Allowed;
	  }

void case_265()
#line 2203 "cs-parser.jay"
{
		if (doc_support) {
			tmpComment = Lexer.consume_doc_comment ();
			Lexer.doc_state = XmlCommentState.Allowed;
		}
		
		valid_param_mod = ParameterModifierType.All;
	  }

void case_266()
#line 2212 "cs-parser.jay"
{
		valid_param_mod = 0;
		current_local_parameters = (ParametersCompiled) yyVals[-1+yyTop];
		
		var lt = (Tokenizer.LocatedToken) yyVals[-4+yyTop];
		var mods = (Modifiers) yyVals[-5+yyTop];
		var c = new Constructor (current_type, lt.Value, mods, (Attributes) yyVals[-6+yyTop], current_local_parameters, lt.Location);

		if (lt.Value != current_container.MemberName.Name) {
			report.Error (1520, c.Location, "Class, struct, or interface method must have a return type");
		} else if ((mods & Modifiers.STATIC) != 0) {
			if ((mods & Modifiers.AccessibilityMask) != 0){
				report.Error (515, c.Location,
					"`{0}': static constructor cannot have an access modifier",
					c.GetSignatureForError ());
			}
		}

		current_type.AddConstructor (c);
		lbag.AddMember (c, GetModifierLocations (), GetLocation (yyVals[-2+yyTop]), GetLocation (yyVals[0+yyTop]));
		yyVal = c;

		/**/
		/* start block here, so possible anonymous methods inside*/
		/* constructor initializer can get correct parent block*/
		/**/
	  	start_block (lexer.Location);
	  }

void case_267()
#line 2241 "cs-parser.jay"
{
		if (yyVals[0+yyTop] != null) {
			var c = (Constructor) yyVals[-1+yyTop];
			c.Initializer = (ConstructorInitializer) yyVals[0+yyTop];
			
			if (c.IsStatic) {
				report.Error (514, c.Location,
					"`{0}': static constructor cannot have an explicit `this' or `base' constructor call",
					c.GetSignatureForError ());
			}
		}

		yyVal = yyVals[-1+yyTop];
	  }

void case_273()
#line 2273 "cs-parser.jay"
{
	  	--lexer.parsing_block;
		yyVal = new ConstructorBaseInitializer ((Arguments) yyVals[-1+yyTop], GetLocation (yyVals[-4+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[-5+yyTop]), GetLocation (yyVals[-3+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_275()
#line 2283 "cs-parser.jay"
{
	  	--lexer.parsing_block;
		yyVal = new ConstructorThisInitializer ((Arguments) yyVals[-1+yyTop], GetLocation (yyVals[-4+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[-5+yyTop]), GetLocation (yyVals[-3+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_276()
#line 2289 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);	  
		yyVal = new ConstructorThisInitializer (null, GetLocation (yyVals[0+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_277()
#line 2295 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);
		yyVal = null;
	  }

void case_278()
#line 2303 "cs-parser.jay"
{
		if (doc_support) {
			tmpComment = Lexer.consume_doc_comment ();
			Lexer.doc_state = XmlCommentState.NotAllowed;
		}
		
		current_local_parameters = ParametersCompiled.EmptyReadOnlyParameters;
	  }

void case_279()
#line 2312 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[-3+yyTop];
		if (lt.Value != current_container.MemberName.Name){
			report.Error (574, lt.Location, "Name of destructor must match name of class");
		} else if (current_container.Kind != MemberKind.Class){
			report.Error (575, lt.Location, "Only class types can contain destructor");
		}
		
		Destructor d = new Destructor (current_type, (Modifiers) yyVals[-6+yyTop],
			ParametersCompiled.EmptyReadOnlyParameters, (Attributes) yyVals[-7+yyTop], lt.Location);
		d.Identifier = lt.Value;
		if (doc_support)
			d.DocComment = ConsumeStoredComment ();
		  
		d.Block = (ToplevelBlock) yyVals[0+yyTop];
		current_type.AddMember (d);
		lbag.AddMember (d, GetModifierLocations (), GetLocation (yyVals[-5+yyTop]), GetLocation (yyVals[-2+yyTop]), GetLocation (yyVals[-1+yyTop]));

		current_local_parameters = null;
	  }

void case_280()
#line 2338 "cs-parser.jay"
{
		current_event_field = new EventField (current_type, (FullNamedExpression) yyVals[-1+yyTop], (Modifiers) yyVals[-3+yyTop], (MemberName) yyVals[0+yyTop], (Attributes) yyVals[-4+yyTop]);
		current_type.AddMember (current_event_field);
		
		if (current_event_field.MemberName.ExplicitInterface != null) {
			report.Error (71, current_event_field.Location, "`{0}': An explicit interface implementation of an event must use property syntax",
			current_event_field.GetSignatureForError ());
		}
		
		yyVal = current_event_field;
	  }

void case_281()
#line 2352 "cs-parser.jay"
{
		if (doc_support) {
			current_event_field.DocComment = Lexer.consume_doc_comment ();
			Lexer.doc_state = XmlCommentState.Allowed;
		}
		
		lbag.AddMember (current_event_field, GetModifierLocations (), GetLocation (yyVals[-6+yyTop]), GetLocation (yyVals[0+yyTop]));
		current_event_field = null;
	  }

void case_282()
#line 2365 "cs-parser.jay"
{
		current_event = new EventProperty (current_type, (FullNamedExpression) yyVals[-2+yyTop], (Modifiers) yyVals[-4+yyTop], (MemberName) yyVals[-1+yyTop], (Attributes) yyVals[-5+yyTop]);
		current_type.AddMember (current_event);
		lbag.AddMember (current_event, GetModifierLocations (), GetLocation (yyVals[-3+yyTop]), GetLocation (yyVals[0+yyTop]));
		
		lexer.EventParsing = true;
	  }

void case_283()
#line 2373 "cs-parser.jay"
{
		if (current_container.Kind == MemberKind.Interface)
			report.Error (69, GetLocation (yyVals[-2+yyTop]), "Event in interface cannot have add or remove accessors");
	  
		lexer.EventParsing = false;
	  }

void case_284()
#line 2380 "cs-parser.jay"
{
		if (doc_support) {
			current_event.DocComment = Lexer.consume_doc_comment ();
			Lexer.doc_state = XmlCommentState.Allowed;
		}
		
		lbag.AppendToMember (current_event, GetLocation (yyVals[-1+yyTop]));
	  	current_event = null;	
		current_local_parameters = null;
	  }

void case_287()
#line 2399 "cs-parser.jay"
{
	  	--lexer.parsing_block;
		current_event_field.Initializer = (Expression) yyVals[0+yyTop];
	  }

void case_292()
#line 2423 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[0+yyTop];
	  	yyVal = new FieldDeclarator (new SimpleMemberName (lt.Value, lt.Location), null);
	  	lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_294()
#line 2433 "cs-parser.jay"
{
		--lexer.parsing_block;
		var lt = (Tokenizer.LocatedToken) yyVals[-3+yyTop];	  
	  	yyVal = new FieldDeclarator (new SimpleMemberName (lt.Value, lt.Location), (Expression) yyVals[0+yyTop]);
	  	lbag.AddLocation (yyVal, GetLocation (yyVals[-4+yyTop]), GetLocation (yyVals[-2+yyTop]));
	  }

void case_295()
#line 2442 "cs-parser.jay"
{
		if (current_container.Kind == MemberKind.Interface) {
			report.Error (68, lexer.Location, "`{0}': event in interface cannot have an initializer",
				current_event_field.GetSignatureForError ());
		}
		
	  	if ((current_event_field.ModFlags & Modifiers.ABSTRACT) != 0) {
			report.Error (74, lexer.Location, "`{0}': abstract event cannot have an initializer",
				current_event_field.GetSignatureForError ());
	  	}		
	  }

void case_299()
#line 2463 "cs-parser.jay"
{
		report.Error (65, lexer.Location, "`{0}': event property must have both add and remove accessors",
			current_event.GetSignatureForError ());
	  }

void case_300()
#line 2468 "cs-parser.jay"
{
		report.Error (65, lexer.Location, "`{0}': event property must have both add and remove accessors",
			current_event.GetSignatureForError ());
	  }

void case_301()
#line 2473 "cs-parser.jay"
{ 
		report.Error (1055, GetLocation (yyVals[0+yyTop]), "An add or remove accessor expected");
		yyVal = null;
	  }

void case_302()
#line 2481 "cs-parser.jay"
{
	  	if (yyVals[-1+yyTop] != ModifierNone) {
			report.Error (1609, GetLocation (yyVals[-1+yyTop]), "Modifiers cannot be placed on event accessor declarations");
	  	}
	  	
	  	current_event.Add = new EventProperty.AddDelegateMethod (current_event, (Attributes) yyVals[-2+yyTop], GetLocation (yyVals[0+yyTop]));
		current_local_parameters = current_event.Add.ParameterInfo;
		
		lbag.AddMember (current_event.Add, GetModifierLocations ());
		lexer.EventParsing = false;		
	  }

void case_303()
#line 2493 "cs-parser.jay"
{
		lexer.EventParsing = true;
	  
	  	current_event.Add.Block = (ToplevelBlock) yyVals[0+yyTop];
		
		if (current_container.Kind == MemberKind.Interface) {
			report.Error (531, current_event.Add.Block.StartLocation,
				"`{0}': interface members cannot have a definition", current_event.Add.GetSignatureForError ());
		}
		
		current_local_parameters = null;
	  }

void case_304()
#line 2509 "cs-parser.jay"
{
	  	if (yyVals[-1+yyTop] != ModifierNone) {
			report.Error (1609, GetLocation (yyVals[-1+yyTop]), "Modifiers cannot be placed on event accessor declarations");
	  	}
	  	
	  	current_event.Remove = new EventProperty.RemoveDelegateMethod (current_event, (Attributes) yyVals[-2+yyTop], GetLocation (yyVals[0+yyTop]));
		current_local_parameters = current_event.Remove.ParameterInfo;

		lbag.AddMember (current_event.Remove, GetModifierLocations ());
		lexer.EventParsing = false;		
	  }

void case_305()
#line 2521 "cs-parser.jay"
{
		lexer.EventParsing = true;
	  
	  	current_event.Remove.Block = (ToplevelBlock) yyVals[0+yyTop];
		
		if (current_container.Kind == MemberKind.Interface) {
			report.Error (531, current_event.Remove.Block.StartLocation,
				"`{0}': interface members cannot have a definition", current_event.Remove.GetSignatureForError ());
		}
		
		current_local_parameters = null;
	  }

void case_306()
#line 2537 "cs-parser.jay"
{
		report.Error (73, lexer.Location, "An add or remove accessor must have a body");
		yyVal = null;
	  }

void case_308()
#line 2546 "cs-parser.jay"
{
		current_type.UnattachedAttributes = (Attributes) yyVals[-1+yyTop];
		report.Error (1519, GetLocation (yyVals[-1+yyTop]), "An attribute is missing member declaration");
		lexer.putback ('}');
	  }

void case_309()
#line 2559 "cs-parser.jay"
{
		if (doc_support)
			enumTypeComment = Lexer.consume_doc_comment ();
	  }

void case_310()
#line 2564 "cs-parser.jay"
{
		if (doc_support)
			Lexer.doc_state = XmlCommentState.Allowed;

		MemberName name = (MemberName) yyVals[-3+yyTop];
		if (name.IsGeneric) {
			report.Error (1675, name.Location, "Enums cannot have type parameters");
		}
		
		push_current_container (new Enum (current_container, (FullNamedExpression) yyVals[-2+yyTop], (Modifiers) yyVals[-5+yyTop], name, (Attributes) yyVals[-6+yyTop]), null);
		if (yyVals[-2+yyTop] != null) {
			lbag.AddMember (current_container, GetModifierLocations (), GetLocation (yyVals[-4+yyTop]), savedLocation, GetLocation (yyVals[0+yyTop]));
		} else {
			lbag.AddMember (current_container, GetModifierLocations (), GetLocation (yyVals[-4+yyTop]), GetLocation (yyVals[0+yyTop]));
		}
	  }

void case_311()
#line 2581 "cs-parser.jay"
{
	  	/* here will be evaluated after CLOSE_BLACE is consumed.*/
		if (doc_support)
			Lexer.doc_state = XmlCommentState.Allowed;
	  }

void case_312()
#line 2587 "cs-parser.jay"
{
		lbag.AppendToMember (current_container, GetLocation (yyVals[-1+yyTop]));
		if (yyVals[0+yyTop] != null) {
			lbag.AppendToMember (current_container, GetLocation (yyVals[0+yyTop]));
		}
		if (doc_support)
			current_container.DocComment = enumTypeComment;
			
		--lexer.parsing_declaration;

/*			if (doc_support)*/
/*				em.DocComment = ev.DocComment;*/

		yyVal = pop_current_class ();
	  }

void case_314()
#line 2607 "cs-parser.jay"
{
		savedLocation = GetLocation (yyVals[-1+yyTop]);
		yyVal = yyVals[0+yyTop];
	 }

void case_315()
#line 2612 "cs-parser.jay"
{
	 	Error_TypeExpected (GetLocation (yyVals[-1+yyTop]));
		yyVal = null;
	 }

void case_320()
#line 2630 "cs-parser.jay"
{
		lbag.AppendToMember (current_container, GetLocation (yyVals[-1+yyTop]));
	  	yyVal = yyVals[0+yyTop];
	  }

void case_321()
#line 2638 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[0+yyTop];
	  	var em = new EnumMember ((Enum) current_type, new MemberName (lt.Value, lt.Location), (Attributes) yyVals[-1+yyTop]);
	  	((Enum) current_type).AddEnumMember (em);

		if (doc_support) {
			em.DocComment = Lexer.consume_doc_comment ();
			Lexer.doc_state = XmlCommentState.Allowed;
		}

		yyVal = em;
	  }

void case_322()
#line 2651 "cs-parser.jay"
{
	  	++lexer.parsing_block;
		if (doc_support) {
			tmpComment = Lexer.consume_doc_comment ();
			Lexer.doc_state = XmlCommentState.NotAllowed;
		}
	  }

void case_323()
#line 2659 "cs-parser.jay"
{ 
		--lexer.parsing_block;
		
		var lt = (Tokenizer.LocatedToken) yyVals[-3+yyTop];
	  	var em = new EnumMember ((Enum) current_type, new MemberName (lt.Value, lt.Location), (Attributes) yyVals[-4+yyTop]);
	  	em.Initializer = new ConstInitializer (em, (Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  	((Enum) current_type).AddEnumMember (em);
		
		if (doc_support)
			em.DocComment = ConsumeStoredComment ();

		yyVal = em;
	  }

void case_325()
#line 2684 "cs-parser.jay"
{
		valid_param_mod = 0;

		ParametersCompiled p = (ParametersCompiled) yyVals[-1+yyTop];

		Delegate del = new Delegate (current_container, (FullNamedExpression) yyVals[-5+yyTop], (Modifiers) yyVals[-7+yyTop], (MemberName) yyVals[-4+yyTop], p, (Attributes) yyVals[-8+yyTop]);

		p.CheckParameters (del);

		current_container.AddTypeContainer (del);

		current_delegate = del;
		lexer.ConstraintsParsing = true;
	  }

void case_327()
#line 2703 "cs-parser.jay"
{
		if (doc_support) {
			current_delegate.DocComment = Lexer.consume_doc_comment ();
			Lexer.doc_state = XmlCommentState.Allowed;
		}
	  
		if (yyVals[-2+yyTop] != null)
			current_delegate.SetConstraints ((List<Constraints>) yyVals[-2+yyTop]);
		lbag.AddMember (current_delegate, GetModifierLocations (), GetLocation (yyVals[-10+yyTop]), GetLocation (yyVals[-7+yyTop]), GetLocation (yyVals[-4+yyTop]), GetLocation (yyVals[0+yyTop]));

		yyVal = current_delegate;

		current_delegate = null;
	  }

void case_329()
#line 2722 "cs-parser.jay"
{
		if (lang_version < LanguageVersion.ISO_2)
			FeatureIsNotAvailable (GetLocation (yyVals[0+yyTop]), "nullable types");
	  
	  	yyVal = ComposedTypeSpecifier.CreateNullable (GetLocation (yyVals[0+yyTop]));
	  }

void case_331()
#line 2733 "cs-parser.jay"
{
		var lt1 = (Tokenizer.LocatedToken) yyVals[-2+yyTop];
		var lt2 = (Tokenizer.LocatedToken) yyVals[-1+yyTop];
		
		yyVal = new QualifiedAliasMember (lt1.Value, lt2.Value, (TypeArguments) yyVals[0+yyTop], lt1.Location);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_333()
#line 2745 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[-1+yyTop];
		yyVal = new MemberAccess ((Expression) yyVals[-3+yyTop], lt.Value, (TypeArguments) yyVals[0+yyTop], lt.Location);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-2+yyTop]));
	  }

void case_334()
#line 2754 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[-1+yyTop];
		yyVal = new SimpleName (lt.Value, (TypeArguments)yyVals[0+yyTop], lt.Location);
	  }

void case_336()
#line 2766 "cs-parser.jay"
{
		if (lang_version < LanguageVersion.ISO_2)
			FeatureIsNotAvailable (GetLocation (yyVals[-2+yyTop]), "generics");
		var list = locationListStack.Pop ();
		list.Add (GetLocation (yyVals[-2+yyTop]));
		list.Add (GetLocation (yyVals[-1+yyTop]));
		lbag.AddLocation (yyVals[-1+yyTop], list);
	
		yyVal = yyVals[-1+yyTop];;
	  }

void case_337()
#line 2777 "cs-parser.jay"
{
		Error_TypeExpected (lexer.Location);
		yyVal = new TypeArguments ();
	  }

void case_338()
#line 2785 "cs-parser.jay"
{
		TypeArguments type_args = new TypeArguments ();
		type_args.Add ((FullNamedExpression) yyVals[0+yyTop]);
		yyVal = type_args;
		locationListStack.Push (new List<Location> ());
	  }

void case_339()
#line 2792 "cs-parser.jay"
{
		TypeArguments type_args = (TypeArguments) yyVals[-2+yyTop];
		type_args.Add ((FullNamedExpression) yyVals[0+yyTop]);
		yyVal = type_args;
		locationListStack.Peek ().Add (GetLocation (yyVals[-1+yyTop]));
	  }

void case_341()
#line 2809 "cs-parser.jay"
{
		lexer.parsing_generic_declaration = false;
		var lt = (Tokenizer.LocatedToken) yyVals[-2+yyTop];
		yyVal = new MemberName (lt.Value, (TypeParameters)yyVals[0+yyTop], lt.Location);
	  }

void case_342()
#line 2818 "cs-parser.jay"
{
	  	MemberName mn = (MemberName)yyVals[0+yyTop];
	  	if (mn.TypeParameters != null)
	  		syntax_error (mn.Location, string.Format ("Member `{0}' cannot declare type arguments",
	  			mn.GetSignatureForError ()));
	  }

void case_344()
#line 2829 "cs-parser.jay"
{
		lexer.parsing_generic_declaration = false;	  
		var lt = (Tokenizer.LocatedToken) yyVals[-1+yyTop];
		yyVal = new MemberName (lt.Value, (TypeParameters) yyVals[0+yyTop], (ATypeNameExpression) yyVals[-2+yyTop], lt.Location);
	  }

void case_345()
#line 2838 "cs-parser.jay"
{
		lexer.parsing_generic_declaration = false;	  
		yyVal = new MemberName (TypeDefinition.DefaultIndexerName, GetLocation (yyVals[0+yyTop]));
	  }

void case_346()
#line 2843 "cs-parser.jay"
{
		lexer.parsing_generic_declaration = false;
		yyVal = new MemberName (TypeDefinition.DefaultIndexerName, null, (ATypeNameExpression) yyVals[-1+yyTop], GetLocation (yyVals[0+yyTop]));
	  }

void case_347()
#line 2851 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[-2+yyTop];
		yyVal = new SimpleName (lt.Value, (TypeArguments) yyVals[-1+yyTop], lt.Location);
		lbag.AddLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_348()
#line 2857 "cs-parser.jay"
{
		var lt1 = (Tokenizer.LocatedToken) yyVals[-3+yyTop];
		var lt2 = (Tokenizer.LocatedToken) yyVals[-2+yyTop];

		yyVal = new QualifiedAliasMember (lt1.Value, lt2.Value, (TypeArguments) yyVals[-1+yyTop], lt1.Location);
		lbag.AddLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_349()
#line 2865 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[-2+yyTop];
		yyVal = new MemberAccess ((ATypeNameExpression) yyVals[-3+yyTop], lt.Value, (TypeArguments) yyVals[-1+yyTop], lt.Location);
		lbag.AddLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_351()
#line 2875 "cs-parser.jay"
{
		if (lang_version < LanguageVersion.ISO_2)
			FeatureIsNotAvailable (GetLocation (yyVals[-2+yyTop]), "generics");
	  
		yyVal = yyVals[-1+yyTop];
		var list = locationListStack.Pop ();
		list.Add (GetLocation (yyVals[-2+yyTop]));
		list.Add (GetLocation (yyVals[-1+yyTop]));
		lbag.AddLocation (yyVals[-1+yyTop], list);
	  }

void case_352()
#line 2889 "cs-parser.jay"
{
		var tparams = new TypeParameters ();
		tparams.Add ((TypeParameter)yyVals[0+yyTop]);
		yyVal = tparams;
		locationListStack.Push (new List<Location> ());
	  }

void case_353()
#line 2896 "cs-parser.jay"
{
		var tparams = (TypeParameters) yyVals[-2+yyTop];
		tparams.Add ((TypeParameter)yyVals[0+yyTop]);
		yyVal = tparams;
		locationListStack.Peek ().Add (GetLocation (yyVals[-1+yyTop]));
	  }

void case_354()
#line 2906 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken)yyVals[0+yyTop];
		yyVal = new TypeParameter (new MemberName (lt.Value, lt.Location), (Attributes)yyVals[-2+yyTop], (Variance) yyVals[-1+yyTop]);
  	  }

void case_355()
#line 2911 "cs-parser.jay"
{
  	  	if (GetTokenName (yyToken) == "type")
			report.Error (81, GetLocation (yyVals[0+yyTop]), "Type parameter declaration must be an identifier not a type");
		else
			Error_SyntaxError (yyToken);
			
  	  	yyVal = new TypeParameter (MemberName.Null, null, Variance.None);
  	  }

void case_360()
#line 2945 "cs-parser.jay"
{
	  	Expression.Error_VoidInvalidInTheContext (GetLocation (yyVals[0+yyTop]), report);
		yyVal = new TypeExpression (compiler.BuiltinTypes.Void, GetLocation (yyVals[0+yyTop]));
	  }

void case_362()
#line 2954 "cs-parser.jay"
{
	  	Expression.Error_VoidInvalidInTheContext (GetLocation (yyVals[0+yyTop]), report);
		yyVal = new TypeExpression (compiler.BuiltinTypes.Void, GetLocation (yyVals[0+yyTop]));
	  }

void case_364()
#line 2963 "cs-parser.jay"
{
	  	report.Error (1536, GetLocation (yyVals[0+yyTop]), "Invalid parameter type `void'");
		yyVal = new TypeExpression (compiler.BuiltinTypes.Void, GetLocation (yyVals[0+yyTop]));
	  }

void case_367()
#line 2979 "cs-parser.jay"
{
		if (yyVals[0+yyTop] != null) {
			yyVal = new ComposedCast ((ATypeNameExpression) yyVals[-1+yyTop], (ComposedTypeSpecifier) yyVals[0+yyTop]);
		} else {
			var sn = yyVals[-1+yyTop] as SimpleName;
			if (sn != null && sn.Name == "var")
				yyVal = new VarExpr (sn.Location);
			else
				yyVal = yyVals[-1+yyTop];
		}
	  }

void case_369()
#line 2995 "cs-parser.jay"
{
		if (yyVals[0+yyTop] != null)
			yyVal = new ComposedCast ((FullNamedExpression) yyVals[-1+yyTop], (ComposedTypeSpecifier) yyVals[0+yyTop]);
	  }

void case_372()
#line 3011 "cs-parser.jay"
{
		var types = new List<FullNamedExpression> (2);
		types.Add ((FullNamedExpression) yyVals[0+yyTop]);
		yyVal = types;
	  }

void case_373()
#line 3017 "cs-parser.jay"
{
		var types = (List<FullNamedExpression>) yyVals[-2+yyTop];
		types.Add ((FullNamedExpression) yyVals[0+yyTop]);
		lbag.AppendTo (types, GetLocation (yyVals[-1+yyTop]));
		yyVal = types;
	  }

void case_374()
#line 3027 "cs-parser.jay"
{
		if (yyVals[0+yyTop] is ComposedCast) {
			report.Error (1521, GetLocation (yyVals[0+yyTop]), "Invalid base type `{0}'", ((ComposedCast)yyVals[0+yyTop]).GetSignatureForError ());
		}
		yyVal = yyVals[0+yyTop];
	  }

void case_411()
#line 3091 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[-1+yyTop];
		yyVal = new SimpleName (lt.Value, (TypeArguments)yyVals[0+yyTop], lt.Location);	  
	  }

void case_412()
#line 3095 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[-1+yyTop];
	       yyVal = new CompletionSimpleName (MemberName.MakeName (lt.Value, null), lt.Location);
	  }

void case_423()
#line 3136 "cs-parser.jay"
{
		yyVal = new ParenthesizedExpression ((Expression) yyVals[-1+yyTop]);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-2+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_425()
#line 3148 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[-1+yyTop];
		yyVal = new MemberAccess ((Expression) yyVals[-3+yyTop], lt.Value, (TypeArguments) yyVals[0+yyTop], lt.Location) {
			DotLocation = GetLocation (yyVals[-2+yyTop])
		};
	  }

void case_426()
#line 3155 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[-1+yyTop];
		yyVal = new MemberAccess ((Expression) yyVals[-3+yyTop], lt.Value, (TypeArguments) yyVals[0+yyTop], lt.Location) {
			DotLocation = GetLocation (yyVals[-2+yyTop])
		};
	  }

void case_427()
#line 3162 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[-1+yyTop];
		yyVal = new MemberAccess (new BaseThis (GetLocation (yyVals[-3+yyTop])), lt.Value, (TypeArguments) yyVals[0+yyTop], lt.Location) {
			DotLocation = GetLocation (yyVals[-2+yyTop])
		};
	  }

void case_428()
#line 3169 "cs-parser.jay"
{
		var lt1 = (Tokenizer.LocatedToken) yyVals[-2+yyTop];
		var lt2 = (Tokenizer.LocatedToken) yyVals[-1+yyTop];

		yyVal = new QualifiedAliasMember (lt1.Value, lt2.Value, (TypeArguments) yyVals[0+yyTop], lt1.Location);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_430()
#line 3179 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[-1+yyTop];
		yyVal = new CompletionMemberAccess ((Expression) yyVals[-3+yyTop], lt.Value, lt.Location);
	  }

void case_432()
#line 3187 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[-1+yyTop];
		yyVal = new CompletionMemberAccess ((Expression) yyVals[-3+yyTop], lt.Value, lt.Location);
 	  }

void case_433()
#line 3195 "cs-parser.jay"
{
		yyVal = new Invocation ((Expression) yyVals[-3+yyTop], (Arguments) yyVals[-1+yyTop]);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-2+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_436()
#line 3208 "cs-parser.jay"
{
	  	if (yyVals[-1+yyTop] == null) {
	  		yyVal = CollectionOrObjectInitializers.Empty;
	  		/* TODO: lbag*/
	  	} else {
	  		yyVal = new CollectionOrObjectInitializers ((List<Expression>) yyVals[-1+yyTop], GetLocation (yyVals[-2+yyTop]));
	  		lbag.AddLocation (yyVal, GetLocation (yyVals[-2+yyTop]), GetLocation (yyVals[0+yyTop]));
	  	}
	  }

void case_437()
#line 3218 "cs-parser.jay"
{
	  	yyVal = new CollectionOrObjectInitializers ((List<Expression>) yyVals[-2+yyTop], GetLocation (yyVals[-3+yyTop]));
	  	lbag.AddLocation (yyVal, GetLocation (yyVals[-3+yyTop]), GetLocation (yyVals[-1+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_440()
#line 3234 "cs-parser.jay"
{
	  	var a = new List<Expression> ();
	  	a.Add ((Expression) yyVals[0+yyTop]);
	  	yyVal = a;
	  }

void case_441()
#line 3240 "cs-parser.jay"
{
	  	var a = (List<Expression>)yyVals[-2+yyTop];
	  	a.Add ((Expression) yyVals[0+yyTop]);
		lbag.AppendTo (a, GetLocation (yyVals[-1+yyTop]));
	  	yyVal = a;
	  }

void case_442()
#line 3246 "cs-parser.jay"
{
	  	Error_SyntaxError (yyToken);
		yyVal = yyVals[-1+yyTop];
	  }

void case_443()
#line 3254 "cs-parser.jay"
{
	  	var lt = (Tokenizer.LocatedToken) yyVals[-2+yyTop];
	  	yyVal = new ElementInitializer (lt.Value, (Expression)yyVals[0+yyTop], lt.Location);
	  	lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_445()
#line 3263 "cs-parser.jay"
{
		CompletionSimpleName csn = yyVals[-1+yyTop] as CompletionSimpleName;
		if (csn == null)
			yyVal = new CollectionElementInitializer ((Expression)yyVals[-1+yyTop]);
		else
			yyVal = new CompletionElementInitializer (csn.Prefix, csn.Location);
	  }

void case_446()
#line 3271 "cs-parser.jay"
{
		if (yyVals[-1+yyTop] == null)
			yyVal = null;
		else {
	  		yyVal = new CollectionElementInitializer ((List<Expression>)yyVals[-1+yyTop], GetLocation (yyVals[-2+yyTop]));
			lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  	}
	  }

void case_447()
#line 3280 "cs-parser.jay"
{
	  	report.Error (1920, GetLocation (yyVals[-1+yyTop]), "An element initializer cannot be empty");
		yyVal = null;
	  }

void case_452()
#line 3298 "cs-parser.jay"
{ 
		Arguments list = new Arguments (4);
		list.Add ((Argument) yyVals[0+yyTop]);
		yyVal = list;
	  }

void case_453()
#line 3304 "cs-parser.jay"
{
		Arguments list = (Arguments) yyVals[-2+yyTop];
		if (list [list.Count - 1] is NamedArgument)
			Error_NamedArgumentExpected ((NamedArgument) list [list.Count - 1]);
		
		list.Add ((Argument) yyVals[0+yyTop]);
		lbag.AppendTo (list, GetLocation (yyVals[-1+yyTop]));
		yyVal = list;
	  }

void case_454()
#line 3314 "cs-parser.jay"
{
		Arguments list = (Arguments) yyVals[-2+yyTop];
		NamedArgument a = (NamedArgument) yyVals[0+yyTop];
		for (int i = 0; i < list.Count; ++i) {
			NamedArgument na = list [i] as NamedArgument;
			if (na != null && na.Name == a.Name)
				report.Error (1740, na.Location, "Named argument `{0}' specified multiple times",
					na.Name);
		}
		
		list.Add (a);
		lbag.AppendTo (list, GetLocation (yyVals[-1+yyTop]));
		yyVal = list;
	  }

void case_455()
#line 3329 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);
		yyVal = yyVals[-2+yyTop];
	  }

void case_456()
#line 3334 "cs-parser.jay"
{
	  	report.Error (839, GetLocation (yyVals[-1+yyTop]), "An argument is missing");
	  	yyVal = null;
	  }

void case_461()
#line 3355 "cs-parser.jay"
{ 
		yyVal = new Argument ((Expression) yyVals[0+yyTop], Argument.AType.Ref);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_462()
#line 3360 "cs-parser.jay"
{ 
		yyVal = new Argument ((Expression) yyVals[0+yyTop], Argument.AType.Out);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_463()
#line 3365 "cs-parser.jay"
{
		yyVal = new Argument (new Arglist ((Arguments) yyVals[-1+yyTop], GetLocation (yyVals[-3+yyTop])));
		lbag.AddLocation (yyVal, GetLocation (yyVals[-2+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_464()
#line 3370 "cs-parser.jay"
{
		yyVal = new Argument (new Arglist (GetLocation (yyVals[-2+yyTop])));
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_466()
#line 3382 "cs-parser.jay"
{
		yyVal = new ElementAccess ((Expression) yyVals[-3+yyTop], (Arguments) yyVals[-1+yyTop], GetLocation (yyVals[-2+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_467()
#line 3387 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);
		yyVal = new ElementAccess ((Expression) yyVals[-3+yyTop], (Arguments) yyVals[-1+yyTop], GetLocation (yyVals[-2+yyTop]));
	  }

void case_468()
#line 3392 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);
		yyVal = new ElementAccess ((Expression) yyVals[-2+yyTop], null, GetLocation (yyVals[-1+yyTop]));
	  }

void case_469()
#line 3400 "cs-parser.jay"
{
		var list = new List<Expression> (4);
		list.Add ((Expression) yyVals[0+yyTop]);
		yyVal = list;
	  }

void case_470()
#line 3406 "cs-parser.jay"
{
		var list = (List<Expression>) yyVals[-2+yyTop];
		list.Add ((Expression) yyVals[0+yyTop]);
		lbag.AppendTo (list, GetLocation (yyVals[-1+yyTop]));
		yyVal = list;
	  }

void case_471()
#line 3412 "cs-parser.jay"
{
	  	Error_SyntaxError (yyToken);
		yyVal = yyVals[-1+yyTop];
	  }

void case_472()
#line 3420 "cs-parser.jay"
{
		Arguments args = new Arguments (4);
		args.Add ((Argument) yyVals[0+yyTop]);
		yyVal = args;
	  }

void case_473()
#line 3426 "cs-parser.jay"
{
		Arguments args = (Arguments) yyVals[-2+yyTop];
		if (args [args.Count - 1] is NamedArgument && !(yyVals[0+yyTop] is NamedArgument))
			Error_NamedArgumentExpected ((NamedArgument) args [args.Count - 1]);
	  
		args.Add ((Argument) yyVals[0+yyTop]);
		lbag.AppendTo (args, GetLocation (yyVals[-1+yyTop]));
		yyVal = args;	  
	  }

void case_477()
#line 3454 "cs-parser.jay"
{
	  	yyVal = new ElementAccess (new BaseThis (GetLocation (yyVals[-3+yyTop])), (Arguments) yyVals[-1+yyTop], GetLocation (yyVals[-2+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_478()
#line 3459 "cs-parser.jay"
{
	  	Error_SyntaxError (yyToken);
		yyVal = new ElementAccess (null, null, GetLocation (yyVals[-1+yyTop]));
	  }

void case_481()
#line 3481 "cs-parser.jay"
{
		if (yyVals[0+yyTop] != null) {
			if (lang_version <= LanguageVersion.ISO_2)
				FeatureIsNotAvailable (GetLocation (yyVals[-5+yyTop]), "object initializers");
				
			yyVal = new NewInitialize ((FullNamedExpression) yyVals[-4+yyTop], (Arguments) yyVals[-2+yyTop], (CollectionOrObjectInitializers) yyVals[0+yyTop], GetLocation (yyVals[-5+yyTop]));
		} else {
			yyVal = new New ((FullNamedExpression) yyVals[-4+yyTop], (Arguments) yyVals[-2+yyTop], GetLocation (yyVals[-5+yyTop]));
		}
		
		lbag.AddLocation (yyVal, GetLocation (yyVals[-3+yyTop]), GetLocation (yyVals[-1+yyTop]));
	  }

void case_482()
#line 3494 "cs-parser.jay"
{
		if (lang_version <= LanguageVersion.ISO_2)
			FeatureIsNotAvailable (GetLocation (yyVals[-2+yyTop]), "collection initializers");
	  
		yyVal = new NewInitialize ((FullNamedExpression) yyVals[-1+yyTop], null, (CollectionOrObjectInitializers) yyVals[0+yyTop], GetLocation (yyVals[-2+yyTop]));
	  }

void case_483()
#line 3506 "cs-parser.jay"
{
		yyVal = new ArrayCreation ((FullNamedExpression) yyVals[-5+yyTop], (List<Expression>) yyVals[-3+yyTop],
				new ComposedTypeSpecifier (((List<Expression>) yyVals[-3+yyTop]).Count, GetLocation (yyVals[-4+yyTop])) {
	  				Next = (ComposedTypeSpecifier) yyVals[-1+yyTop]
			  	}, (ArrayInitializer) yyVals[0+yyTop], GetLocation (yyVals[-6+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[-4+yyTop]), GetLocation (yyVals[-2+yyTop]));
	  }

void case_484()
#line 3514 "cs-parser.jay"
{
	  	if (yyVals[0+yyTop] == null)
	  		report.Error (1586, GetLocation (yyVals[-3+yyTop]), "Array creation must have array size or array initializer");

		yyVal = new ArrayCreation ((FullNamedExpression) yyVals[-2+yyTop], (ComposedTypeSpecifier) yyVals[-1+yyTop], (ArrayInitializer) yyVals[0+yyTop], GetLocation (yyVals[-3+yyTop]));
	  }

void case_485()
#line 3521 "cs-parser.jay"
{
		if (lang_version <= LanguageVersion.ISO_2)
			FeatureIsNotAvailable (GetLocation (yyVals[-2+yyTop]), "implicitly typed arrays");
	  
		yyVal = new ImplicitlyTypedArrayCreation ((ComposedTypeSpecifier) yyVals[-1+yyTop], (ArrayInitializer) yyVals[0+yyTop], GetLocation (yyVals[-2+yyTop]));
	  }

void case_486()
#line 3528 "cs-parser.jay"
{
		report.Error (178, GetLocation (yyVals[-1+yyTop]), "Invalid rank specifier, expecting `,' or `]'");
		yyVal = new ArrayCreation ((FullNamedExpression) yyVals[-5+yyTop], null, GetLocation (yyVals[-6+yyTop]));
	  }

void case_487()
#line 3533 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);
		/* It can be any of new expression, create the most common one*/
		yyVal = new New ((FullNamedExpression) yyVals[-1+yyTop], null, GetLocation (yyVals[-2+yyTop]));
	  }

void case_489()
#line 3545 "cs-parser.jay"
{
		--lexer.parsing_type;
		yyVal = yyVals[0+yyTop];
	  }

void case_490()
#line 3553 "cs-parser.jay"
{
		if (lang_version <= LanguageVersion.ISO_2)
	  		FeatureIsNotAvailable (GetLocation (yyVals[-3+yyTop]), "anonymous types");

		yyVal = new NewAnonymousType ((List<AnonymousTypeParameter>) yyVals[-1+yyTop], current_container, GetLocation (yyVals[-3+yyTop]));
		
		/* TODO: lbag comma location*/
		lbag.AddLocation (yyVal, GetLocation (yyVals[-2+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_495()
#line 3576 "cs-parser.jay"
{
	  	var a = new List<AnonymousTypeParameter> (4);
	  	a.Add ((AnonymousTypeParameter) yyVals[0+yyTop]);
	  	yyVal = a;
	  }

void case_496()
#line 3582 "cs-parser.jay"
{
	  	var a = (List<AnonymousTypeParameter>) yyVals[-2+yyTop];
	  	a.Add ((AnonymousTypeParameter) yyVals[0+yyTop]);
	  	lbag.AppendTo (a, GetLocation (yyVals[-1+yyTop]));

	  	yyVal = a;
	  }

void case_497()
#line 3593 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken)yyVals[-2+yyTop];
	  	yyVal = new AnonymousTypeParameter ((Expression)yyVals[0+yyTop], lt.Value, lt.Location);
	  	lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_498()
#line 3599 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken)yyVals[0+yyTop];
	  	yyVal = new AnonymousTypeParameter (new SimpleName (lt.Value, lt.Location),
	  		lt.Value, lt.Location);
	  }

void case_499()
#line 3605 "cs-parser.jay"
{
	  	MemberAccess ma = (MemberAccess) yyVals[0+yyTop];
	  	yyVal = new AnonymousTypeParameter (ma, ma.Name, ma.Location);
	  }

void case_500()
#line 3610 "cs-parser.jay"
{
		report.Error (746, lexer.Location,
			"Invalid anonymous type member declarator. Anonymous type members must be a member assignment, simple name or member access expression");
		yyVal = null;
	  }

void case_504()
#line 3625 "cs-parser.jay"
{
	  	((ComposedTypeSpecifier) yyVals[-1+yyTop]).Next = (ComposedTypeSpecifier) yyVals[0+yyTop];
	  	yyVal = yyVals[-1+yyTop];
	  }

void case_505()
#line 3633 "cs-parser.jay"
{
		yyVal = ComposedTypeSpecifier.CreateArrayDimension (1, GetLocation (yyVals[-1+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_506()
#line 3638 "cs-parser.jay"
{
		yyVal = ComposedTypeSpecifier.CreateArrayDimension ((int)yyVals[-1+yyTop], GetLocation (yyVals[-2+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_511()
#line 3668 "cs-parser.jay"
{
		var ai = new ArrayInitializer (0, GetLocation (yyVals[-1+yyTop]));
		ai.VariableDeclaration = current_variable;
		lbag.AddLocation (ai, GetLocation (yyVals[0+yyTop]));
		yyVal = ai;
	  }

void case_512()
#line 3675 "cs-parser.jay"
{
		var ai = new ArrayInitializer ((List<Expression>) yyVals[-2+yyTop], GetLocation (yyVals[-3+yyTop]));
		ai.VariableDeclaration = current_variable;
		if (yyVals[-1+yyTop] != null) {
			lbag.AddLocation (ai, GetLocation (yyVals[-1+yyTop]), GetLocation (yyVals[0+yyTop]));
		} else {
			lbag.AddLocation (ai, GetLocation (yyVals[0+yyTop]));
		}
		yyVal = ai;
	  }

void case_513()
#line 3689 "cs-parser.jay"
{
		var list = new List<Expression> (4);
		list.Add ((Expression) yyVals[0+yyTop]);
		yyVal = list;
	  }

void case_514()
#line 3695 "cs-parser.jay"
{
		var list = (List<Expression>) yyVals[-2+yyTop];
		list.Add ((Expression) yyVals[0+yyTop]);
		lbag.AppendTo (list, GetLocation (yyVals[-1+yyTop]));
		yyVal = list;
	  }

void case_516()
#line 3709 "cs-parser.jay"
{
	  	lexer.TypeOfParsing = false;
		yyVal = new TypeOf ((FullNamedExpression) yyVals[-1+yyTop], GetLocation (yyVals[-4+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[-2+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_519()
#line 3720 "cs-parser.jay"
{
	 	Error_TypeExpected (lexer.Location);
	 	yyVal = null;
	 }

void case_520()
#line 3728 "cs-parser.jay"
{  
		var lt = (Tokenizer.LocatedToken) yyVals[-1+yyTop];

		yyVal = new SimpleName (lt.Value, (int) yyVals[0+yyTop], lt.Location);
	  }

void case_521()
#line 3734 "cs-parser.jay"
{
		var lt1 = (Tokenizer.LocatedToken) yyVals[-2+yyTop];
		var lt2 = (Tokenizer.LocatedToken) yyVals[-1+yyTop];

		yyVal = new QualifiedAliasMember (lt1.Value, lt2.Value, (int) yyVals[0+yyTop], lt1.Location);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_522()
#line 3742 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[0+yyTop];
		
		yyVal = new MemberAccess ((Expression) yyVals[-2+yyTop], lt.Value, lt.Location) {
			DotLocation = GetLocation (yyVals[-1+yyTop])
		};
	  }

void case_523()
#line 3750 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[-1+yyTop];
		
		yyVal = new MemberAccess ((Expression) yyVals[-3+yyTop], lt.Value, (int) yyVals[0+yyTop], lt.Location) {
			DotLocation = GetLocation (yyVals[-2+yyTop])
		};
	  }

void case_524()
#line 3758 "cs-parser.jay"
{
		var tne = (ATypeNameExpression) yyVals[-3+yyTop];
		if (tne.HasTypeArguments)
			Error_TypeExpected (GetLocation (yyVals[0+yyTop]));

		var lt = (Tokenizer.LocatedToken) yyVals[-1+yyTop];
		yyVal = new MemberAccess (tne, lt.Value, (int) yyVals[0+yyTop], lt.Location) {
			DotLocation = GetLocation (yyVals[-2+yyTop])
		};		
	  }

void case_525()
#line 3772 "cs-parser.jay"
{
		if (lang_version < LanguageVersion.ISO_2)
			FeatureIsNotAvailable (GetLocation (yyVals[0+yyTop]), "generics");

		yyVal = yyVals[0+yyTop];
	  }

void case_526()
#line 3782 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[-1+yyTop];
		if (lang_version == LanguageVersion.ISO_1)
			FeatureIsNotAvailable (lt.Location, "namespace alias qualifier");

		yyVal = lt;		
	  }

void case_527()
#line 3793 "cs-parser.jay"
{ 
		yyVal = new SizeOf ((Expression) yyVals[-1+yyTop], GetLocation (yyVals[-3+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[-2+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_528()
#line 3801 "cs-parser.jay"
{
		yyVal = new CheckedExpr ((Expression) yyVals[-1+yyTop], GetLocation (yyVals[-3+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[-2+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_529()
#line 3809 "cs-parser.jay"
{
		yyVal = new UnCheckedExpr ((Expression) yyVals[-1+yyTop], GetLocation (yyVals[-3+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[-2+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_530()
#line 3817 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[-1+yyTop];
		yyVal = new MemberAccess (new Indirection ((Expression) yyVals[-3+yyTop], GetLocation (yyVals[-2+yyTop])), lt.Value, (TypeArguments) yyVals[0+yyTop], lt.Location);
	  }

void case_532()
#line 3829 "cs-parser.jay"
{
		yyVal = end_anonymous ((ParametersBlock) yyVals[0+yyTop]);
		if ((ParametersCompiled) yyVals[-2+yyTop] != ParametersCompiled.Undefined) {
			lbag.AddLocation (yyVal, GetLocation (yyVals[-3+yyTop]), savedOpenLocation, savedCloseLocation);
		} else {
			lbag.AddLocation (yyVal, GetLocation (yyVals[-3+yyTop]));
		}
	  }

void case_534()
#line 3842 "cs-parser.jay"
{
		yyVal = end_anonymous ((ParametersBlock) yyVals[0+yyTop]);
		
		if ((ParametersCompiled) yyVals[-2+yyTop] != ParametersCompiled.Undefined) {
			lbag.AddLocation (yyVal, GetLocation (yyVals[-4+yyTop]), GetLocation (yyVals[-3+yyTop]), savedOpenLocation, savedCloseLocation);
		} else {
			lbag.AddLocation (yyVal, GetLocation (yyVals[-4+yyTop]), GetLocation (yyVals[-3+yyTop]));
		}
	  }

void case_538()
#line 3867 "cs-parser.jay"
{
		valid_param_mod = 0;
	  	yyVal = yyVals[-1+yyTop];
	  	savedOpenLocation = GetLocation (yyVals[-3+yyTop]);
	  	savedCloseLocation = GetLocation (yyVals[-2+yyTop]);
	  }

void case_539()
#line 3877 "cs-parser.jay"
{
		if (lang_version < LanguageVersion.ISO_2)
			FeatureIsNotAvailable (GetLocation (yyVals[-3+yyTop]), "default value expression");

		yyVal = new DefaultValueExpression ((Expression) yyVals[-1+yyTop], GetLocation (yyVals[-3+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[-2+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_543()
#line 3897 "cs-parser.jay"
{
		yyVal = new Cast ((FullNamedExpression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop], GetLocation (yyVals[-3+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_544()
#line 3902 "cs-parser.jay"
{
		if (!async_block) {
			 if (current_anonymous_method is LambdaExpression) {
				report.Error (4034, GetLocation (yyVals[-1+yyTop]),
					"The `await' operator can only be used when its containing lambda expression is marked with the `async' modifier");
			} else if (current_anonymous_method is AnonymousMethodExpression) {
				report.Error (4035, GetLocation (yyVals[-1+yyTop]),
					"The `await' operator can only be used when its containing anonymous method is marked with the `async' modifier");
			} else {
				report.Error (4033, GetLocation (yyVals[-1+yyTop]),
					"The `await' operator can only be used when its containing method is marked with the `async' modifier");
			}
		} else {
			current_block.Explicit.RegisterAsyncAwait ();
		}
		
		yyVal = new Await ((Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }

void case_553()
#line 3957 "cs-parser.jay"
{
		yyVal = new Binary (Binary.Operator.Multiply, 
			         (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }

void case_554()
#line 3962 "cs-parser.jay"
{
		yyVal = new Binary (Binary.Operator.Division, 
			         (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }

void case_555()
#line 3967 "cs-parser.jay"
{
		yyVal = new Binary (Binary.Operator.Modulus, 
			         (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }

void case_557()
#line 3976 "cs-parser.jay"
{
		yyVal = new Binary (Binary.Operator.Addition, 
			         (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }

void case_559()
#line 3985 "cs-parser.jay"
{
	  	/* Shift/Reduce conflict*/
		yyVal = new Binary (Binary.Operator.Subtraction, (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
  	  }

void case_563()
#line 4002 "cs-parser.jay"
{
		yyVal = new Binary (Binary.Operator.LeftShift, 
			         (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }

void case_564()
#line 4007 "cs-parser.jay"
{
		yyVal = new Binary (Binary.Operator.RightShift, 
			         (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }

void case_566()
#line 4016 "cs-parser.jay"
{
		yyVal = new Binary (Binary.Operator.LessThan, 
			         (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }

void case_567()
#line 4021 "cs-parser.jay"
{
		yyVal = new Binary (Binary.Operator.GreaterThan, 
			         (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }

void case_568()
#line 4026 "cs-parser.jay"
{
		yyVal = new Binary (Binary.Operator.LessThanOrEqual, 
			         (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }

void case_569()
#line 4031 "cs-parser.jay"
{
		yyVal = new Binary (Binary.Operator.GreaterThanOrEqual, 
			         (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }

void case_571()
#line 4040 "cs-parser.jay"
{
		yyVal = new Binary (Binary.Operator.Equality, 
			         (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }

void case_572()
#line 4045 "cs-parser.jay"
{
		yyVal = new Binary (Binary.Operator.Inequality, 
			         (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }

void case_574()
#line 4054 "cs-parser.jay"
{
		yyVal = new Binary (Binary.Operator.BitwiseAnd, 
			         (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }

void case_576()
#line 4063 "cs-parser.jay"
{
		yyVal = new Binary (Binary.Operator.ExclusiveOr, 
			         (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }

void case_578()
#line 4072 "cs-parser.jay"
{
		yyVal = new Binary (Binary.Operator.BitwiseOr, 
			         (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }

void case_580()
#line 4081 "cs-parser.jay"
{
		yyVal = new Binary (Binary.Operator.LogicalAnd, 
			         (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }

void case_582()
#line 4090 "cs-parser.jay"
{
		yyVal = new Binary (Binary.Operator.LogicalOr, 
			         (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }

void case_584()
#line 4099 "cs-parser.jay"
{
		if (lang_version < LanguageVersion.ISO_2)
			FeatureIsNotAvailable (GetLocation (yyVals[-1+yyTop]), "null coalescing operator");
			
		yyVal = new Nullable.NullCoalescingOperator ((Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }

void case_586()
#line 4110 "cs-parser.jay"
{
		yyVal = new Conditional (new BooleanExpression ((Expression) yyVals[-4+yyTop]), (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop], GetLocation (yyVals[-3+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_587()
#line 4115 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);
		yyVal = new Conditional (new BooleanExpression ((Expression) yyVals[-3+yyTop]), (Expression) yyVals[-1+yyTop], null, GetLocation (yyVals[-2+yyTop]));
	  }

void case_589()
#line 4127 "cs-parser.jay"
{
		yyVal = new CompoundAssign (
			Binary.Operator.Multiply, (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }

void case_590()
#line 4132 "cs-parser.jay"
{
		yyVal = new CompoundAssign (
			Binary.Operator.Division, (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }

void case_591()
#line 4137 "cs-parser.jay"
{
		yyVal = new CompoundAssign (
			Binary.Operator.Modulus, (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }

void case_592()
#line 4142 "cs-parser.jay"
{
		yyVal = new CompoundAssign (
			Binary.Operator.Addition, (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }

void case_593()
#line 4147 "cs-parser.jay"
{
		yyVal = new CompoundAssign (
			Binary.Operator.Subtraction, (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }

void case_594()
#line 4152 "cs-parser.jay"
{
		yyVal = new CompoundAssign (
			Binary.Operator.LeftShift, (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }

void case_595()
#line 4157 "cs-parser.jay"
{
		yyVal = new CompoundAssign (
			Binary.Operator.RightShift, (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }

void case_596()
#line 4162 "cs-parser.jay"
{
		yyVal = new CompoundAssign (
			Binary.Operator.BitwiseAnd, (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }

void case_597()
#line 4167 "cs-parser.jay"
{
		yyVal = new CompoundAssign (
			Binary.Operator.BitwiseOr, (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }

void case_598()
#line 4172 "cs-parser.jay"
{
		yyVal = new CompoundAssign (
			Binary.Operator.ExclusiveOr, (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }

void case_599()
#line 4180 "cs-parser.jay"
{
		var pars = new List<Parameter> (4);
		pars.Add ((Parameter) yyVals[0+yyTop]);
		parameterListCommas.Clear ();
		yyVal = pars;
	  }

void case_600()
#line 4187 "cs-parser.jay"
{
		var pars = (List<Parameter>) yyVals[-2+yyTop];
		Parameter p = (Parameter)yyVals[0+yyTop];
		if (pars[0].GetType () != p.GetType ()) {
			report.Error (748, p.Location, "All lambda parameters must be typed either explicitly or implicitly");
		}
		
		pars.Add (p);
		parameterListCommas.Add (GetLocation (yyVals[-1+yyTop]));

		yyVal = pars;
	  }

void case_601()
#line 4203 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[0+yyTop];

		yyVal = new Parameter ((FullNamedExpression) yyVals[-1+yyTop], lt.Value, (Parameter.Modifier) yyVals[-2+yyTop], null, lt.Location);
	  }

void case_602()
#line 4209 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[0+yyTop];

		yyVal = new Parameter ((FullNamedExpression) yyVals[-1+yyTop], lt.Value, Parameter.Modifier.NONE, null, lt.Location);
	  }

void case_603()
#line 4215 "cs-parser.jay"
{
	  	var lt = (Tokenizer.LocatedToken) yyVals[0+yyTop];
		yyVal = new ImplicitLambdaParameter (lt.Value, lt.Location);
	  }

void case_605()
#line 4223 "cs-parser.jay"
{ 
		var pars_list = (List<Parameter>) yyVals[0+yyTop];
		yyVal = new ParametersCompiled (pars_list.ToArray ());
		lbag.AddLocation (yyVal, parameterListCommas);
	  }

void case_609()
#line 4240 "cs-parser.jay"
{
		Block b = end_block (Location.Null);
		b.IsCompilerGenerated = true;
		b.AddStatement (new ContextualReturn ((Expression) yyVals[0+yyTop]));
		yyVal = b;
	  }

void case_611()
#line 4251 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);	
		yyVal = EmptyExpression.Null;
	  }

void case_612()
#line 4259 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[-1+yyTop];	
		Parameter p = new ImplicitLambdaParameter (lt.Value, lt.Location);
		start_anonymous (true, new ParametersCompiled (p), false, lt.Location);
	  }

void case_613()
#line 4265 "cs-parser.jay"
{
		yyVal = end_anonymous ((ParametersBlock) yyVals[0+yyTop]);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-2+yyTop]));
	  }

void case_614()
#line 4270 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[-1+yyTop];
		Parameter p = new ImplicitLambdaParameter (lt.Value, lt.Location);
		start_anonymous (true, new ParametersCompiled (p), true, lt.Location);
	  }

void case_615()
#line 4276 "cs-parser.jay"
{
		yyVal = end_anonymous ((ParametersBlock) yyVals[0+yyTop]);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-4+yyTop]), GetLocation (yyVals[-2+yyTop]));
	  }

void case_617()
#line 4285 "cs-parser.jay"
{
	  	valid_param_mod = 0;
		start_anonymous (true, (ParametersCompiled) yyVals[-2+yyTop], false, GetLocation (yyVals[-4+yyTop]));
	  }

void case_618()
#line 4290 "cs-parser.jay"
{
		yyVal = end_anonymous ((ParametersBlock) yyVals[0+yyTop]);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-6+yyTop]), GetLocation (yyVals[-3+yyTop]), GetLocation (yyVals[-2+yyTop]));
	  }

void case_620()
#line 4299 "cs-parser.jay"
{
	  	valid_param_mod = 0;
		start_anonymous (true, (ParametersCompiled) yyVals[-2+yyTop], true, GetLocation (yyVals[-5+yyTop]));
	  }

void case_621()
#line 4304 "cs-parser.jay"
{
		yyVal = end_anonymous ((ParametersBlock) yyVals[0+yyTop]);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-7+yyTop]), GetLocation (yyVals[-6+yyTop]), GetLocation (yyVals[-3+yyTop]), GetLocation (yyVals[-2+yyTop]));
	  }

void case_628()
#line 4327 "cs-parser.jay"
{
		yyVal = new RefValueExpr ((Expression) yyVals[-3+yyTop], (FullNamedExpression) yyVals[-1+yyTop], GetLocation (yyVals[-5+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[-4+yyTop]), GetLocation (yyVals[-2+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_629()
#line 4332 "cs-parser.jay"
{
		yyVal = new RefTypeExpr ((Expression) yyVals[-1+yyTop], GetLocation (yyVals[-3+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[-2+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_630()
#line 4337 "cs-parser.jay"
{
		yyVal = new MakeRefExpr ((Expression) yyVals[-1+yyTop], GetLocation (yyVals[-3+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[-2+yyTop]), GetLocation (yyVals[0+yyTop]));	  
	  }

void case_634()
#line 4366 "cs-parser.jay"
{
		Class c = new Class (current_container, (MemberName) yyVals[0+yyTop], (Modifiers) yyVals[-4+yyTop], (Attributes) yyVals[-5+yyTop]);
		if (((c.ModFlags & Modifiers.STATIC) != 0) && lang_version == LanguageVersion.ISO_1) {
			FeatureIsNotAvailable (c.Location, "static classes");
		}
			
		push_current_container (c, yyVals[-3+yyTop]);
		lbag.AddMember (current_container, GetModifierLocations (), GetLocation (yyVals[-2+yyTop]));
	  }

void case_635()
#line 4377 "cs-parser.jay"
{
		lexer.ConstraintsParsing = false;

		if (yyVals[0+yyTop] != null)
			current_container.SetConstraints ((List<Constraints>) yyVals[0+yyTop]);

		if (doc_support) {
			current_container.PartialContainer.DocComment = Lexer.consume_doc_comment ();
			Lexer.doc_state = XmlCommentState.Allowed;
		}
		
		lexer.parsing_modifiers = true;
	  }

void case_636()
#line 4391 "cs-parser.jay"
{
		--lexer.parsing_declaration;
		if (doc_support)
			Lexer.doc_state = XmlCommentState.Allowed;
	  }

void case_637()
#line 4397 "cs-parser.jay"
{
		if (yyVals[0+yyTop] == null) {
			lbag.AppendToMember (current_container, GetLocation (yyVals[-4+yyTop]), GetLocation (yyVals[-2+yyTop]));
		} else {
			lbag.AppendToMember (current_container, GetLocation (yyVals[-4+yyTop]), GetLocation (yyVals[-2+yyTop]), GetLocation (yyVals[0+yyTop]));
		}
		yyVal = pop_current_class ();
	  }

void case_640()
#line 4416 "cs-parser.jay"
{
	    mod_locations = null;
		yyVal = ModifierNone;
		lexer.parsing_modifiers = false;
	  }

void case_643()
#line 4430 "cs-parser.jay"
{ 
		var m1 = (Modifiers) yyVals[-1+yyTop];
		var m2 = (Modifiers) yyVals[0+yyTop];

		if ((m1 & m2) != 0) {
			report.Error (1004, lexer.Location - ModifiersExtensions.Name (m2).Length,
				"Duplicate `{0}' modifier", ModifiersExtensions.Name (m2));
		} else if ((m2 & Modifiers.AccessibilityMask) != 0 && (m1 & Modifiers.AccessibilityMask) != 0 &&
			((m2 | m1 & Modifiers.AccessibilityMask) != (Modifiers.PROTECTED | Modifiers.INTERNAL))) {
			report.Error (107, lexer.Location - ModifiersExtensions.Name (m2).Length,
				"More than one protection modifier specified");
		}
		
		yyVal = m1 | m2;
	  }

void case_644()
#line 4449 "cs-parser.jay"
{
		yyVal = Modifiers.NEW;
		StoreModifierLocation (yyVal, GetLocation (yyVals[0+yyTop]));
		
		if (current_container.Kind == MemberKind.Namespace)
			report.Error (1530, GetLocation (yyVals[0+yyTop]), "Keyword `new' is not allowed on namespace elements");
	  }

void case_645()
#line 4457 "cs-parser.jay"
{
		yyVal = Modifiers.PUBLIC;
		StoreModifierLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_646()
#line 4462 "cs-parser.jay"
{
		yyVal = Modifiers.PROTECTED;
		StoreModifierLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_647()
#line 4467 "cs-parser.jay"
{
		yyVal = Modifiers.INTERNAL;
		StoreModifierLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_648()
#line 4472 "cs-parser.jay"
{
		yyVal = Modifiers.PRIVATE;
		StoreModifierLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_649()
#line 4477 "cs-parser.jay"
{
		yyVal = Modifiers.ABSTRACT;
		StoreModifierLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_650()
#line 4482 "cs-parser.jay"
{
		yyVal = Modifiers.SEALED;
		StoreModifierLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_651()
#line 4487 "cs-parser.jay"
{
		yyVal = Modifiers.STATIC;
		StoreModifierLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_652()
#line 4492 "cs-parser.jay"
{
		yyVal = Modifiers.READONLY;
		StoreModifierLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_653()
#line 4497 "cs-parser.jay"
{
		yyVal = Modifiers.VIRTUAL;
		StoreModifierLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_654()
#line 4502 "cs-parser.jay"
{
		yyVal = Modifiers.OVERRIDE;
		StoreModifierLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_655()
#line 4507 "cs-parser.jay"
{
		yyVal = Modifiers.EXTERN;
		StoreModifierLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_656()
#line 4512 "cs-parser.jay"
{
		yyVal = Modifiers.VOLATILE;
		StoreModifierLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_657()
#line 4517 "cs-parser.jay"
{
		yyVal = Modifiers.UNSAFE;
		StoreModifierLocation (yyVal, GetLocation (yyVals[0+yyTop]));
		if (!settings.Unsafe)
			Error_UnsafeCodeNotAllowed (GetLocation (yyVals[0+yyTop]));
	  }

void case_658()
#line 4524 "cs-parser.jay"
{
		yyVal = Modifiers.ASYNC;
		StoreModifierLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_660()
#line 4533 "cs-parser.jay"
{
		current_type.AddBasesForPart ((List<FullNamedExpression>) yyVals[0+yyTop]);
		lbag.AppendToMember (current_type, GetLocation (yyVals[-1+yyTop]));
	 }

void case_661()
#line 4538 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);

		current_type.AddBasesForPart ((List<FullNamedExpression>) yyVals[-1+yyTop]);
	  }

void case_664()
#line 4555 "cs-parser.jay"
{
		var constraints = new List<Constraints> (1);
		constraints.Add ((Constraints) yyVals[0+yyTop]);
		yyVal = constraints;
	  }

void case_665()
#line 4561 "cs-parser.jay"
{
		var constraints = (List<Constraints>) yyVals[-1+yyTop];
		Constraints new_constraint = (Constraints)yyVals[0+yyTop];

		foreach (Constraints c in constraints) {
			if (new_constraint.TypeParameter.Value == c.TypeParameter.Value) {
				report.Error (409, new_constraint.Location,
					"A constraint clause has already been specified for type parameter `{0}'",
					new_constraint.TypeParameter.Value);
			}
		}

		constraints.Add (new_constraint);
		yyVal = constraints;
	  }

void case_666()
#line 4580 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[-2+yyTop];
		yyVal = new Constraints (new SimpleMemberName (lt.Value, lt.Location), (List<FullNamedExpression>) yyVals[0+yyTop], GetLocation (yyVals[-3+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_667()
#line 4586 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);
	  
		var lt = (Tokenizer.LocatedToken) yyVals[-1+yyTop];
		yyVal = new Constraints (new SimpleMemberName (lt.Value, lt.Location), null, GetLocation (yyVals[-2+yyTop]));
	  }

void case_668()
#line 4596 "cs-parser.jay"
{
		var constraints = new List<FullNamedExpression> (1);
		constraints.Add ((FullNamedExpression) yyVals[0+yyTop]);
		yyVal = constraints;
	  }

void case_669()
#line 4602 "cs-parser.jay"
{
		var constraints = (List<FullNamedExpression>) yyVals[-2+yyTop];
		var prev = constraints [constraints.Count - 1] as SpecialContraintExpr;
		if (prev != null && (prev.Constraint & SpecialConstraint.Constructor) != 0) {			
			report.Error (401, GetLocation (yyVals[-1+yyTop]), "The `new()' constraint must be the last constraint specified");
		}
		
		prev = yyVals[0+yyTop] as SpecialContraintExpr;
		if (prev != null) {
			if ((prev.Constraint & (SpecialConstraint.Class | SpecialConstraint.Struct)) != 0) {
				report.Error (449, prev.Location, "The `class' or `struct' constraint must be the first constraint specified");			
			} else {
			 	prev = constraints [0] as SpecialContraintExpr;
			 	if (prev != null && (prev.Constraint & SpecialConstraint.Struct) != 0) {			
					report.Error (451, GetLocation (yyVals[0+yyTop]), "The `new()' constraint cannot be used with the `struct' constraint");
				}
			}
		}

		constraints.Add ((FullNamedExpression) yyVals[0+yyTop]);
		lbag.AppendTo (constraints, GetLocation (yyVals[-1+yyTop]));
		yyVal = constraints;
	  }

void case_670()
#line 4629 "cs-parser.jay"
{
		if (yyVals[0+yyTop] is ComposedCast)
			report.Error (706, GetLocation (yyVals[0+yyTop]), "Invalid constraint type `{0}'", ((ComposedCast)yyVals[0+yyTop]).GetSignatureForError ());
	  
	  	yyVal = yyVals[0+yyTop];
	  }

void case_671()
#line 4636 "cs-parser.jay"
{
		yyVal = new SpecialContraintExpr (SpecialConstraint.Constructor, GetLocation (yyVals[-2+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_675()
#line 4656 "cs-parser.jay"
{
		if (lang_version <= LanguageVersion.V_3)
			FeatureIsNotAvailable (lexer.Location, "generic type variance");
		
		yyVal = yyVals[0+yyTop];
	  }

void case_676()
#line 4666 "cs-parser.jay"
{
		yyVal = Variance.Covariant;
		savedLocation = GetLocation (yyVals[0+yyTop]);
	  }

void case_677()
#line 4671 "cs-parser.jay"
{
		yyVal = Variance.Contravariant;
		savedLocation = GetLocation (yyVals[0+yyTop]);
	  }

void case_678()
#line 4692 "cs-parser.jay"
{
		++lexer.parsing_block;
		start_block (GetLocation (yyVals[0+yyTop]));
	  }

void case_680()
#line 4704 "cs-parser.jay"
{
	 	--lexer.parsing_block;
		yyVal = end_block (GetLocation (yyVals[0+yyTop]));
	  }

void case_681()
#line 4709 "cs-parser.jay"
{
	 	--lexer.parsing_block;
		yyVal = end_block (lexer.Location);
	  }

void case_682()
#line 4718 "cs-parser.jay"
{
		++lexer.parsing_block;
		current_block.StartLocation = GetLocation (yyVals[0+yyTop]);
	  }

void case_683()
#line 4723 "cs-parser.jay"
{
		--lexer.parsing_block;
		yyVal = end_block (GetLocation (yyVals[0+yyTop]));
	  }

void case_684()
#line 4727 "cs-parser.jay"
{
		report.Error (1525, GetLocation (yyVals[0+yyTop]), "Unexpected symbol '}', expected '{'");
		lexer.putback ('}');
		yyVal = end_block (GetLocation (yyVals[0+yyTop]));
	  }

void case_692()
#line 4756 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);
		var lt =(Tokenizer.LocatedToken) yyVals[-1+yyTop];
		var sn = new SimpleName (lt.Value, lt.Location);
		current_block.AddStatement(new StatementErrorExpression (sn));
		yyVal = null;
	}

void case_693()
#line 4765 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);
		yyVal = null;
	  }

void case_726()
#line 4829 "cs-parser.jay"
{
		  report.Error (1023, GetLocation (yyVals[0+yyTop]), "An embedded statement may not be a declaration or labeled statement");
		  yyVal = null;
	  }

void case_727()
#line 4834 "cs-parser.jay"
{
		  report.Error (1023, GetLocation (yyVals[0+yyTop]), "An embedded statement may not be a declaration or labeled statement");
		  yyVal = null;
	  }

void case_728()
#line 4839 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);
		yyVal = new EmptyStatement (GetLocation (yyVals[0+yyTop]));
	  }

void case_729()
#line 4847 "cs-parser.jay"
{
		/* Uses lexer.Location because semicolon location is not kept in quick mode*/
		yyVal = new EmptyStatement (lexer.Location);
	  }

void case_730()
#line 4855 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[-1+yyTop];
		LabeledStatement labeled = new LabeledStatement (lt.Value, current_block, lt.Location);
		lbag.AddLocation (labeled, GetLocation (yyVals[0+yyTop]));
		current_block.AddLabel (labeled);
		current_block.AddStatement (labeled);
	  }

void case_733()
#line 4868 "cs-parser.jay"
{
		if (yyVals[-1+yyTop] is VarExpr)
			yyVals[-1+yyTop] = new SimpleName ("var", ((VarExpr) yyVals[-1+yyTop]).Location);
	  
		yyVal = new ComposedCast ((FullNamedExpression) yyVals[-1+yyTop], (ComposedTypeSpecifier) yyVals[0+yyTop]);
	  }

void case_734()
#line 4884 "cs-parser.jay"
{ 
		/* Ok, the above "primary_expression" is there to get rid of*/
		/* both reduce/reduce and shift/reduces in the grammar, it should*/
		/* really just be "type_name".  If you use type_name, a reduce/reduce*/
		/* creeps up.  If you use namespace_or_type_name (which is all we need*/
		/* really) two shift/reduces appear.*/
		/* */

		/* So the super-trick is that primary_expression*/
		/* can only be either a SimpleName or a MemberAccess. */
		/* The MemberAccess case arises when you have a fully qualified type-name like :*/
		/* Foo.Bar.Blah i;*/
		/* SimpleName is when you have*/
		/* Blah i;*/
		
		Expression expr = (Expression) yyVals[-1+yyTop];
		if (yyVals[0+yyTop] == null) {
			SimpleName sn = expr as SimpleName;
			if (sn != null && sn.Name == "var")
				yyVal = new VarExpr (sn.Location);
			else
				yyVal = yyVals[-1+yyTop];
		} else if (expr is ATypeNameExpression) {
			yyVal = new ComposedCast ((ATypeNameExpression)expr, (ComposedTypeSpecifier) yyVals[0+yyTop]);
		} else {
			Error_ExpectingTypeName (expr);
			yyVal = null;
		}
	  }

void case_735()
#line 4914 "cs-parser.jay"
{
		ATypeNameExpression expr = yyVals[-1+yyTop] as ATypeNameExpression;

		if (expr != null) {
			yyVal = new ComposedCast (expr, (ComposedTypeSpecifier) yyVals[0+yyTop]);
		} else {
			Error_ExpectingTypeName ((Expression)yyVals[-1+yyTop]);
			yyVal = expr;
		}
	  }

void case_736()
#line 4925 "cs-parser.jay"
{
		if (yyVals[0+yyTop] == null)
			yyVal = yyVals[-1+yyTop];
		else
			yyVal = new ComposedCast ((FullNamedExpression) yyVals[-1+yyTop], (ComposedTypeSpecifier) yyVals[0+yyTop]);
	  }

void case_739()
#line 4940 "cs-parser.jay"
{
		Expression.Error_VoidInvalidInTheContext (GetLocation (yyVals[0+yyTop]), report);
		yyVal = new TypeExpression (compiler.BuiltinTypes.Void, GetLocation (yyVals[0+yyTop]));
	  }

void case_741()
#line 4949 "cs-parser.jay"
{
	  	((ComposedTypeSpecifier) yyVals[-1+yyTop]).Next = (ComposedTypeSpecifier) yyVals[0+yyTop];
	  	yyVal = yyVals[-1+yyTop];
	  }

void case_744()
#line 4965 "cs-parser.jay"
{
		if (async_block) {
			report.Error (4003, GetLocation (yyVals[0+yyTop]), "`await' cannot be used as an identifier within an async method or lambda expression");
			yyVal = Tokenizer.LocatedToken.Create ("await", GetLocation (yyVals[0+yyTop]));
		}
	  }

void case_745()
#line 4975 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[0+yyTop];
		var li = new LocalVariable (current_block, lt.Value, lt.Location);
		current_block.AddLocalName (li);
		current_variable = new BlockVariableDeclaration ((FullNamedExpression) yyVals[-1+yyTop], li);
	  }

void case_746()
#line 4982 "cs-parser.jay"
{
		yyVal = current_variable;
		current_variable = null;
		lbag.AppendTo (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_747()
#line 4988 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[0+yyTop];
		var li = new LocalVariable (current_block, lt.Value, LocalVariable.Flags.Constant, lt.Location);
		current_block.AddLocalName (li);
		current_variable = new BlockConstantDeclaration ((FullNamedExpression) yyVals[-1+yyTop], li);
	  }

void case_748()
#line 4995 "cs-parser.jay"
{
		if (current_variable.Initializer != null) {
			lbag.AddLocation (current_variable, GetLocation (yyVals[-6+yyTop]), savedLocation, GetLocation (yyVals[0+yyTop]));
		} else {
			lbag.AddLocation (current_variable, GetLocation (yyVals[-6+yyTop]), GetLocation (yyVals[0+yyTop]));
		}
		yyVal = current_variable;;
		current_variable = null;
	  }

void case_750()
#line 5008 "cs-parser.jay"
{
		/* Redundant, but wont regress*/
		report.Error (1525, lexer.Location, "Unexpected symbol }");
		lexer.putback ('}');
		yyVal = yyVals[0+yyTop];
	  }

void case_752()
#line 5019 "cs-parser.jay"
{
		current_variable.Initializer = (Expression) yyVals[0+yyTop];
		lbag.AppendTo (current_variable, GetLocation (yyVals[-1+yyTop]));
	  }

void case_753()
#line 5024 "cs-parser.jay"
{
	  	if (yyToken == Token.OPEN_BRACKET_EXPR) {
			report.Error (650, lexer.Location,
				"Syntax error, bad array declarator. To declare a managed array the rank specifier precedes the variable's identifier. To declare a fixed size buffer field, use the fixed keyword before the field type");
			current_variable.Initializer = ErrorExpression.Create (650, lexer.Location,
					"Syntax error, bad array declarator. To declare a managed array the rank specifier precedes the variable's identifier. To declare a fixed size buffer field, use the fixed keyword before the field type");
		} else {
			Error_SyntaxError (yyToken);
			current_variable.Initializer = ErrorExpression.Create (0, lexer.Location,
					"Syntax error");
		}
		lbag.AppendTo (current_variable, GetLocation (yyVals[-1+yyTop]));
	  }

void case_754()
#line 5038 "cs-parser.jay"
{
	  	if (yyToken == Token.OPEN_BRACKET_EXPR) {
			report.Error (650, lexer.Location,
				"Syntax error, bad array declarator. To declare a managed array the rank specifier precedes the variable's identifier. To declare a fixed size buffer field, use the fixed keyword before the field type");
		} else {
			Error_SyntaxError (yyToken);
		}
	  }

void case_758()
#line 5056 "cs-parser.jay"
{
		foreach (var d in current_variable.Declarators) {
			if (d.Initializer == null)
				Error_MissingInitializer (d.Variable.Location);
		}
	  }

void case_761()
#line 5071 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[0+yyTop];	  
		var li = new LocalVariable (current_variable.Variable, lt.Value, lt.Location);
		var d = new BlockVariableDeclaration.Declarator (li, null);
		current_variable.AddDeclarator (d);
		current_block.AddLocalName (li);
	  	lbag.AddLocation (d, GetLocation (yyVals[-1+yyTop]));
	  }

void case_762()
#line 5080 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[-2+yyTop];	  
		var li = new LocalVariable (current_variable.Variable, lt.Value, lt.Location);
		var d = new BlockVariableDeclaration.Declarator (li, (Expression) yyVals[0+yyTop]);
		current_variable.AddDeclarator (d);
		current_block.AddLocalName (li);
	  	lbag.AddLocation (d, GetLocation (yyVals[-3+yyTop]), GetLocation (yyVals[-1+yyTop]));
	  }

void case_764()
#line 5096 "cs-parser.jay"
{
		savedLocation = GetLocation (yyVals[-1+yyTop]);
		current_variable.Initializer = (Expression) yyVals[0+yyTop];
	  }

void case_769()
#line 5114 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[-2+yyTop];	  
		var li = new LocalVariable (current_block, lt.Value, LocalVariable.Flags.Constant, lt.Location);
		var d = new BlockVariableDeclaration.Declarator (li, (Expression) yyVals[0+yyTop]);
		current_variable.AddDeclarator (d);
		current_block.AddLocalName (li);
	  	lbag.AddLocation (d, GetLocation (yyVals[-3+yyTop]), GetLocation (yyVals[-1+yyTop]));
	  }

void case_771()
#line 5127 "cs-parser.jay"
{
		yyVal = new StackAlloc ((Expression) yyVals[-3+yyTop], (Expression) yyVals[-1+yyTop], GetLocation (yyVals[-4+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[-2+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_772()
#line 5132 "cs-parser.jay"
{
		report.Error (1575, GetLocation (yyVals[-1+yyTop]), "A stackalloc expression requires [] after type");
		yyVal = new StackAlloc ((Expression) yyVals[0+yyTop], null, GetLocation (yyVals[-1+yyTop]));		
	  }

void case_773()
#line 5140 "cs-parser.jay"
{
		yyVal = yyVals[-1+yyTop];
		lbag.AddStatement (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_775()
#line 5146 "cs-parser.jay"
{
		yyVal = yyVals[-1+yyTop];
		report.Error (1002, GetLocation (yyVals[0+yyTop]), "; expected");
		lexer.putback ('}');
	  }

void case_778()
#line 5164 "cs-parser.jay"
{
		ExpressionStatement s = yyVals[0+yyTop] as ExpressionStatement;
		if (s == null) {
			Expression.Error_InvalidExpressionStatement (report, GetLocation (yyVals[0+yyTop]));
			yyVal = new StatementErrorExpression (yyVals[0+yyTop] as Expression);
		} else {
			yyVal = new StatementExpression (s);
		}
	  }

void case_779()
#line 5177 "cs-parser.jay"
{
		Expression expr = (Expression) yyVals[0+yyTop];
		ExpressionStatement s;

	        s = new OptionalAssign (new SimpleName ("$retval", lexer.Location), expr, lexer.Location);
		yyVal = new StatementExpression (s);
	  }

void case_780()
#line 5185 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);
		yyVal = new EmptyStatement (GetLocation (yyVals[0+yyTop]));
	  }

void case_783()
#line 5199 "cs-parser.jay"
{ 
		if (yyVals[0+yyTop] is EmptyStatement)
			Warning_EmptyStatement (GetLocation (yyVals[0+yyTop]));
		
		yyVal = new If ((BooleanExpression) yyVals[-2+yyTop], (Statement) yyVals[0+yyTop], GetLocation (yyVals[-4+yyTop]));
		lbag.AddStatement (yyVal, GetLocation (yyVals[-3+yyTop]), GetLocation (yyVals[-1+yyTop]));
	  }

void case_784()
#line 5208 "cs-parser.jay"
{
		yyVal = new If ((BooleanExpression) yyVals[-4+yyTop], (Statement) yyVals[-2+yyTop], (Statement) yyVals[0+yyTop], GetLocation (yyVals[-6+yyTop]));
		lbag.AddStatement (yyVal, GetLocation (yyVals[-5+yyTop]), GetLocation (yyVals[-3+yyTop]), GetLocation (yyVals[-1+yyTop]));
		
		if (yyVals[-2+yyTop] is EmptyStatement)
			Warning_EmptyStatement (GetLocation (yyVals[-2+yyTop]));
		if (yyVals[0+yyTop] is EmptyStatement)
			Warning_EmptyStatement (GetLocation (yyVals[0+yyTop]));
	  }

void case_785()
#line 5218 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);
		
		yyVal = new If ((BooleanExpression) yyVals[-1+yyTop], null, GetLocation (yyVals[-3+yyTop]));
		lbag.AddStatement (yyVal, GetLocation (yyVals[-2+yyTop]));
	  }

void case_787()
#line 5232 "cs-parser.jay"
{
		yyVal = new Switch ((Expression) yyVals[-5+yyTop], (ExplicitBlock) current_block.Explicit, (List<SwitchSection>) yyVals[-1+yyTop], GetLocation (yyVals[-7+yyTop]));	
		end_block (GetLocation (yyVals[0+yyTop]));
		lbag.AddStatement (yyVal, GetLocation (yyVals[-6+yyTop]), GetLocation (yyVals[-4+yyTop]), GetLocation (yyVals[-3+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_788()
#line 5238 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);
	  
		yyVal = new Switch ((Expression) yyVals[-1+yyTop], null, null, GetLocation (yyVals[-3+yyTop]));	
		lbag.AddStatement (yyVal, GetLocation (yyVals[-2+yyTop]));
	  }

void case_789()
#line 5248 "cs-parser.jay"
{
		report.Warning (1522, 1, current_block.StartLocation, "Empty switch block"); 
		yyVal = new List<SwitchSection> ();
	  }

void case_791()
#line 5257 "cs-parser.jay"
{
		var sections = new List<SwitchSection> (4);

		sections.Add ((SwitchSection) yyVals[0+yyTop]);
		yyVal = sections;
	  }

void case_792()
#line 5264 "cs-parser.jay"
{
		var sections = (List<SwitchSection>) yyVals[-1+yyTop];

		sections.Add ((SwitchSection) yyVals[0+yyTop]);
		yyVal = sections;
	  }

void case_793()
#line 5271 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);
		yyVal = new List<SwitchSection> ();
	  }

void case_796()
#line 5290 "cs-parser.jay"
{
		var labels = new List<SwitchLabel> (2);

		labels.Add ((SwitchLabel) yyVals[0+yyTop]);
		yyVal = labels;
	  }

void case_797()
#line 5297 "cs-parser.jay"
{
		var labels = (List<SwitchLabel>) (yyVals[-1+yyTop]);
		labels.Add ((SwitchLabel) yyVals[0+yyTop]);

		yyVal = labels;
	  }

void case_798()
#line 5307 "cs-parser.jay"
{
	 	yyVal = new SwitchLabel ((Expression) yyVals[-1+yyTop], GetLocation (yyVals[-2+yyTop]));
	 	lbag.AddLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	 }

void case_799()
#line 5312 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);
		yyVal = new SwitchLabel ((Expression) yyVals[-1+yyTop], GetLocation (yyVals[-2+yyTop]));
	  }

void case_805()
#line 5331 "cs-parser.jay"
{
		if (yyVals[0+yyTop] is EmptyStatement && lexer.peek_token () == Token.OPEN_BRACE)
			Warning_EmptyStatement (GetLocation (yyVals[0+yyTop]));
	  
		yyVal = new While ((BooleanExpression) yyVals[-2+yyTop], (Statement) yyVals[0+yyTop], GetLocation (yyVals[-4+yyTop]));
		lbag.AddStatement (yyVal, GetLocation (yyVals[-3+yyTop]), GetLocation (yyVals[-1+yyTop]));
	  }

void case_806()
#line 5339 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);
		
		yyVal = new While ((BooleanExpression) yyVals[-1+yyTop], null, GetLocation (yyVals[-3+yyTop]));
		lbag.AddStatement (yyVal, GetLocation (yyVals[-2+yyTop]));
	  }

void case_807()
#line 5349 "cs-parser.jay"
{
		yyVal = new Do ((Statement) yyVals[-5+yyTop], (BooleanExpression) yyVals[-2+yyTop], GetLocation (yyVals[-6+yyTop]));
		lbag.AddStatement (yyVal, GetLocation (yyVals[-4+yyTop]), GetLocation (yyVals[-3+yyTop]), GetLocation (yyVals[-1+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_808()
#line 5354 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);
		yyVal = new Do ((Statement) yyVals[-1+yyTop], null, GetLocation (yyVals[-2+yyTop]));
	  }

void case_809()
#line 5359 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);
	  
		yyVal = new Do ((Statement) yyVals[-4+yyTop], (BooleanExpression) yyVals[-1+yyTop], GetLocation (yyVals[-5+yyTop]));
		lbag.AddStatement (yyVal, GetLocation (yyVals[-3+yyTop]), GetLocation (yyVals[-2+yyTop]));
	  }

void case_810()
#line 5369 "cs-parser.jay"
{
		start_block (GetLocation (yyVals[0+yyTop]));
		current_block.IsCompilerGenerated = true;
		For f = new For (GetLocation (yyVals[-1+yyTop]));
		current_block.AddStatement (f);
		lbag.AddStatement (f, current_block.StartLocation);
		yyVal = f;
	  }

void case_812()
#line 5386 "cs-parser.jay"
{
		For f =  (For) yyVals[-2+yyTop];
		f.Initializer = (Statement) yyVals[-1+yyTop];
		lbag.AppendTo (f, GetLocation (yyVals[0+yyTop]));
		yyVal = f;
	  }

void case_814()
#line 5396 "cs-parser.jay"
{
		report.Error (1525, GetLocation (yyVals[0+yyTop]), "Unexpected symbol ')', expected ';'");
		For f =  (For) yyVals[-2+yyTop];
		f.Initializer = (Statement) yyVals[-1+yyTop];
		lbag.AppendTo (f, GetLocation (yyVals[0+yyTop]));
		yyVal = end_block (GetLocation (yyVals[0+yyTop]));
	}

void case_815()
#line 5407 "cs-parser.jay"
{
		For f =  (For) yyVals[-2+yyTop];
		f.Condition = (BooleanExpression) yyVals[-1+yyTop];
		lbag.AppendTo (f, GetLocation (yyVals[0+yyTop]));
		yyVal = f;
	  }

void case_817()
#line 5417 "cs-parser.jay"
{
		report.Error (1525, GetLocation (yyVals[0+yyTop]), "Unexpected symbol ')', expected ';'");
		For f =  (For) yyVals[-2+yyTop];
		f.Condition = (BooleanExpression) yyVals[-1+yyTop];
		lbag.AppendTo (f, GetLocation (yyVals[0+yyTop]));
		yyVal = end_block (GetLocation (yyVals[0+yyTop]));
	}

void case_818()
#line 5429 "cs-parser.jay"
{
		For f =  (For) yyVals[-3+yyTop];
		f.Iterator = (Statement) yyVals[-2+yyTop];
		
		if (yyVals[0+yyTop] is EmptyStatement && lexer.peek_token () == Token.OPEN_BRACE)
			Warning_EmptyStatement (GetLocation (yyVals[0+yyTop]));
	  
		f.Statement = (Statement) yyVals[0+yyTop];
		lbag.AppendTo (f, GetLocation (yyVals[-1+yyTop]));

		yyVal = end_block (GetLocation (yyVals[-1+yyTop]));
	  }

void case_819()
#line 5442 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);
		yyVal = end_block (current_block.StartLocation);
	  }

void case_822()
#line 5455 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[0+yyTop];
		var li = new LocalVariable (current_block, lt.Value, lt.Location);
		current_block.AddLocalName (li);
		current_variable = new BlockVariableDeclaration ((FullNamedExpression) yyVals[-1+yyTop], li);
	  }

void case_823()
#line 5462 "cs-parser.jay"
{
		yyVal = current_variable;
		current_variable = null;
	  }

void case_831()
#line 5486 "cs-parser.jay"
{
	  	var sl = yyVals[-2+yyTop] as StatementList;
	  	if (sl == null) {
	  		sl = new StatementList ((Statement) yyVals[-2+yyTop], (Statement) yyVals[0+yyTop]);
			lbag.AddStatement (sl, GetLocation (yyVals[-1+yyTop]));
	  	} else {
	  		sl.Add ((Statement) yyVals[0+yyTop]);
	  		lbag.AppendTo (sl, GetLocation (yyVals[-1+yyTop]));
	  		
	  	}
	  		
		yyVal = sl;
	  }

void case_832()
#line 5503 "cs-parser.jay"
{
		report.Error (230, GetLocation (yyVals[-3+yyTop]), "Type and identifier are both required in a foreach statement");

		start_block (GetLocation (yyVals[-2+yyTop]));
		current_block.IsCompilerGenerated = true;
		
		Foreach f = new Foreach ((Expression) yyVals[-1+yyTop], null, null, null, null, GetLocation (yyVals[-3+yyTop]));
		current_block.AddStatement (f);
		
		lbag.AddStatement (f, GetLocation (yyVals[-2+yyTop]));
		yyVal = end_block (GetLocation (yyVals[0+yyTop]));
	  }

void case_833()
#line 5516 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);
	
		start_block (GetLocation (yyVals[-3+yyTop]));
		current_block.IsCompilerGenerated = true;
		
		var lt = (Tokenizer.LocatedToken) yyVals[-1+yyTop];
		var li = new LocalVariable (current_block, lt.Value, LocalVariable.Flags.ForeachVariable | LocalVariable.Flags.Used, lt.Location);
		current_block.AddLocalName (li);
		
		Foreach f = new Foreach ((Expression) yyVals[-2+yyTop], li, null, null, null, GetLocation (yyVals[-4+yyTop]));
		current_block.AddStatement (f);
		
		lbag.AddStatement (f, GetLocation (yyVals[-3+yyTop]));
		yyVal = end_block (GetLocation (yyVals[0+yyTop]));
	  }

void case_834()
#line 5533 "cs-parser.jay"
{
		start_block (GetLocation (yyVals[-5+yyTop]));
		current_block.IsCompilerGenerated = true;
		var lt = (Tokenizer.LocatedToken) yyVals[-3+yyTop];
		var li = new LocalVariable (current_block, lt.Value, LocalVariable.Flags.ForeachVariable | LocalVariable.Flags.Used, lt.Location);
		current_block.AddLocalName (li);
		yyVal = li;
	  }

void case_835()
#line 5542 "cs-parser.jay"
{
		if (yyVals[0+yyTop] is EmptyStatement && lexer.peek_token () == Token.OPEN_BRACE)
			Warning_EmptyStatement (GetLocation (yyVals[0+yyTop]));
		
		Foreach f = new Foreach ((Expression) yyVals[-6+yyTop], (LocalVariable) yyVals[-1+yyTop], (Expression) yyVals[-3+yyTop], (Statement) yyVals[0+yyTop], current_block, GetLocation (yyVals[-8+yyTop]));
		lbag.AddStatement (f, GetLocation (yyVals[-7+yyTop]), GetLocation (yyVals[-4+yyTop]), GetLocation (yyVals[-2+yyTop]));
		end_block (GetLocation (yyVals[-2+yyTop]));
		
		yyVal = f;
	  }

void case_836()
#line 5553 "cs-parser.jay"
{
		start_block (GetLocation (yyVals[-3+yyTop]));
		current_block.IsCompilerGenerated = true;
		var lt = yyVals[-1+yyTop] as Tokenizer.LocatedToken;
		var li = lt != null ? new LocalVariable (current_block, lt.Value, LocalVariable.Flags.ForeachVariable | LocalVariable.Flags.Used, lt.Location) : null;
		
		Foreach f = new Foreach ((Expression) yyVals[-2+yyTop], li, null, null, null, GetLocation (yyVals[-4+yyTop]));
		current_block.AddStatement (f);
		
		lbag.AddStatement (f, GetLocation (yyVals[-3+yyTop]));
		yyVal = end_block (GetLocation (yyVals[0+yyTop]));
	  }

void case_837()
#line 5566 "cs-parser.jay"
{
		Foreach f = new Foreach ((Expression) yyVals[-1+yyTop], null, null, null, null, GetLocation (yyVals[-3+yyTop]));
		current_block.AddStatement (f);
		
		lbag.AddStatement (f, GetLocation (yyVals[-2+yyTop]));
		yyVal = f;
	  }

void case_844()
#line 5586 "cs-parser.jay"
{
		yyVal = new Break (GetLocation (yyVals[-1+yyTop]));
		lbag.AddStatement (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_845()
#line 5594 "cs-parser.jay"
{
		yyVal = new Continue (GetLocation (yyVals[-1+yyTop]));
		lbag.AddStatement (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_846()
#line 5599 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);
		yyVal = new Continue (GetLocation (yyVals[-1+yyTop]));
	  }

void case_847()
#line 5607 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[-1+yyTop];
		yyVal = new Goto (lt.Value, GetLocation (yyVals[-2+yyTop]));
		lbag.AddStatement (yyVal, GetLocation (yyVals[-1+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_848()
#line 5613 "cs-parser.jay"
{
		yyVal = new GotoCase ((Expression) yyVals[-1+yyTop], GetLocation (yyVals[-3+yyTop]));
		lbag.AddStatement (yyVal, GetLocation (yyVals[-2+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_849()
#line 5618 "cs-parser.jay"
{
		yyVal = new GotoDefault (GetLocation (yyVals[-2+yyTop]));
		lbag.AddStatement (yyVal, GetLocation (yyVals[-1+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_850()
#line 5626 "cs-parser.jay"
{
		yyVal = new Return ((Expression) yyVals[-1+yyTop], GetLocation (yyVals[-2+yyTop]));
		lbag.AddStatement (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_851()
#line 5631 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);
		yyVal = new Return (null, GetLocation (yyVals[-1+yyTop]));
	  }

void case_852()
#line 5639 "cs-parser.jay"
{
		yyVal = new Throw ((Expression) yyVals[-1+yyTop], GetLocation (yyVals[-2+yyTop]));
		lbag.AddStatement (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_853()
#line 5644 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);
		yyVal = new Throw (null, GetLocation (yyVals[-1+yyTop]));
	  }

void case_854()
#line 5652 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[-3+yyTop];
		string s = lt.Value;
		if (s != "yield"){
			report.Error (1003, lt.Location, "; expected");
		} else if (yyVals[-1+yyTop] == null) {
			report.Error (1627, GetLocation (yyVals[0+yyTop]), "Expression expected after yield return");
		} else if (lang_version == LanguageVersion.ISO_1){
			FeatureIsNotAvailable (lt.Location, "iterators");
		}
		
		current_block.Explicit.RegisterIteratorYield ();
		yyVal = new Yield ((Expression) yyVals[-1+yyTop], lt.Location);
		lbag.AddStatement (yyVal, GetLocation (yyVals[-2+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_855()
#line 5668 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[-2+yyTop];
		string s = lt.Value;
		if (s != "yield"){
			report.Error (1003, lt.Location, "; expected");
		} else if (lang_version == LanguageVersion.ISO_1){
			FeatureIsNotAvailable (lt.Location, "iterators");
		}
		
		current_block.Explicit.RegisterIteratorYield ();
		yyVal = new YieldBreak (lt.Location);
		lbag.AddStatement (yyVal, GetLocation (yyVals[-1+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_859()
#line 5694 "cs-parser.jay"
{
		yyVal = new TryFinally ((Statement) yyVals[-2+yyTop], (Block) yyVals[0+yyTop], GetLocation (yyVals[-3+yyTop]));
		lbag.AddStatement (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_860()
#line 5699 "cs-parser.jay"
{
		var loc = GetLocation (yyVals[-4+yyTop]);
		yyVal = new TryFinally (new TryCatch ((Block) yyVals[-3+yyTop], (List<Catch>) yyVals[-2+yyTop], loc, true), (Block) yyVals[0+yyTop], loc);
		lbag.AddStatement (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_861()
#line 5705 "cs-parser.jay"
{
		Error_SyntaxError (1524, yyToken);
		yyVal = new TryCatch ((Block) yyVals[-1+yyTop], null, GetLocation (yyVals[-2+yyTop]), false);
	  }

void case_862()
#line 5713 "cs-parser.jay"
{
		var l = new List<Catch> (2);

		l.Add ((Catch) yyVals[0+yyTop]);
		yyVal = l;
	  }

void case_863()
#line 5720 "cs-parser.jay"
{
		var l = (List<Catch>) yyVals[-1+yyTop];
		
		Catch c = (Catch) yyVals[0+yyTop];
		if (l [l.Count - 1].IsGeneral) {
			report.Error (1017, c.loc, "Try statement already has an empty catch block");
		}
		
		l.Add (c);
		yyVal = l;
	  }

void case_867()
#line 5744 "cs-parser.jay"
{
		start_block (GetLocation (yyVals[-3+yyTop]));
		var c = new Catch (current_block, GetLocation (yyVals[-4+yyTop]));
		c.TypeExpression = (FullNamedExpression) yyVals[-2+yyTop];

		if (yyVals[-1+yyTop] != null) {
			var lt = (Tokenizer.LocatedToken) yyVals[-1+yyTop];
			c.Variable = new LocalVariable (current_block, lt.Value, lt.Location);
			current_block.AddLocalName (c.Variable);
		}

		lbag.AddLocation (c, GetLocation (yyVals[-3+yyTop]), GetLocation (yyVals[0+yyTop]));
		yyVal = c;
	  }

void case_869()
#line 5763 "cs-parser.jay"
{
	  	if (yyToken == Token.CLOSE_PARENS) {
			report.Error (1015, lexer.Location,
				"A type that derives from `System.Exception', `object', or `string' expected");
		} else {
			Error_SyntaxError (yyToken);
		}
		
		yyVal = new Catch (null, GetLocation (yyVals[-2+yyTop]));
	  }

void case_872()
#line 5791 "cs-parser.jay"
{
		if (!settings.Unsafe)
			Error_UnsafeCodeNotAllowed (GetLocation (yyVals[0+yyTop]));
	  }

void case_874()
#line 5801 "cs-parser.jay"
{
		if (yyVals[0+yyTop] is EmptyStatement && lexer.peek_token () == Token.OPEN_BRACE)
			Warning_EmptyStatement (GetLocation (yyVals[0+yyTop]));
	  
		yyVal = new Lock ((Expression) yyVals[-2+yyTop], (Statement) yyVals[0+yyTop], GetLocation (yyVals[-4+yyTop]));
		lbag.AddStatement (yyVal, GetLocation (yyVals[-3+yyTop]), GetLocation (yyVals[-1+yyTop]));
	  }

void case_875()
#line 5809 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);

		yyVal = new Lock ((Expression) yyVals[-1+yyTop], null, GetLocation (yyVals[-3+yyTop]));
		lbag.AddStatement (yyVal, GetLocation (yyVals[-2+yyTop]));
	  }

void case_876()
#line 5819 "cs-parser.jay"
{
	    start_block (GetLocation (yyVals[-2+yyTop]));
	    
		current_block.IsCompilerGenerated = true;
		var lt = (Tokenizer.LocatedToken) yyVals[0+yyTop];
		var li = new LocalVariable (current_block, lt.Value, LocalVariable.Flags.FixedVariable | LocalVariable.Flags.Used, lt.Location);
		current_block.AddLocalName (li);
		current_variable = new Fixed.VariableDeclaration ((FullNamedExpression) yyVals[-1+yyTop], li);
	  }

void case_877()
#line 5829 "cs-parser.jay"
{
		yyVal = current_variable;
		current_variable = null;
	  }

void case_878()
#line 5834 "cs-parser.jay"
{
		if (yyVals[0+yyTop] is EmptyStatement && lexer.peek_token () == Token.OPEN_BRACE)
			Warning_EmptyStatement (GetLocation (yyVals[0+yyTop]));
	  
		Fixed f = new Fixed ((Fixed.VariableDeclaration) yyVals[-1+yyTop], (Statement) yyVals[0+yyTop], GetLocation (yyVals[-9+yyTop]));
		current_block.AddStatement (f);
		lbag.AddStatement (f, GetLocation (yyVals[-8+yyTop]), GetLocation (yyVals[-2+yyTop]));
		yyVal = end_block (GetLocation (yyVals[-2+yyTop]));
	  }

void case_879()
#line 5847 "cs-parser.jay"
{
	    start_block (GetLocation (yyVals[-2+yyTop]));
	    
		current_block.IsCompilerGenerated = true;
		var lt = (Tokenizer.LocatedToken) yyVals[0+yyTop];
		var li = new LocalVariable (current_block, lt.Value, LocalVariable.Flags.UsingVariable | LocalVariable.Flags.Used, lt.Location);
		current_block.AddLocalName (li);
		current_variable = new Using.VariableDeclaration ((FullNamedExpression) yyVals[-1+yyTop], li);
	  }

void case_880()
#line 5857 "cs-parser.jay"
{
		yyVal = current_variable;	  
		current_variable = null;
	  }

void case_881()
#line 5862 "cs-parser.jay"
{
		if (yyVals[0+yyTop] is EmptyStatement && lexer.peek_token () == Token.OPEN_BRACE)
			Warning_EmptyStatement (GetLocation (yyVals[0+yyTop]));
	  
		Using u = new Using ((Using.VariableDeclaration) yyVals[-1+yyTop], (Statement) yyVals[0+yyTop], GetLocation (yyVals[-8+yyTop]));
		lbag.AddStatement (u, GetLocation (yyVals[-7+yyTop]), GetLocation (yyVals[-2+yyTop]));
		current_block.AddStatement (u);
		yyVal = end_block (GetLocation (yyVals[-2+yyTop]));
	  }

void case_882()
#line 5872 "cs-parser.jay"
{
		if (yyVals[0+yyTop] is EmptyStatement && lexer.peek_token () == Token.OPEN_BRACE)
			Warning_EmptyStatement (GetLocation (yyVals[0+yyTop]));
	  
		yyVal = new Using ((Expression) yyVals[-2+yyTop], (Statement) yyVals[0+yyTop], GetLocation (yyVals[-4+yyTop]));
		lbag.AddStatement (yyVal, GetLocation (yyVals[-3+yyTop]), GetLocation (yyVals[-1+yyTop]));
	  }

void case_883()
#line 5880 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);
		
		yyVal = new Using ((Expression) yyVals[-1+yyTop], null, GetLocation (yyVals[-3+yyTop]));
		lbag.AddStatement (yyVal, GetLocation (yyVals[-2+yyTop]));
	  }

void case_885()
#line 5891 "cs-parser.jay"
{
		/* It has to be here for the parent to safely restore artificial block*/
	  	Error_SyntaxError (yyToken);
	  }

void case_887()
#line 5903 "cs-parser.jay"
{
		current_variable.Initializer = (Expression) yyVals[0+yyTop];
		lbag.AppendTo (current_variable, GetLocation (yyVals[-1+yyTop]));
		yyVal = current_variable;
	  }

void case_888()
#line 5915 "cs-parser.jay"
{
		lexer.query_parsing = false;
			
		Linq.AQueryClause from = yyVals[-1+yyTop] as Linq.AQueryClause;
			
		from.Tail.Next = (Linq.AQueryClause)yyVals[0+yyTop];
		yyVal = from;
		
		current_block.SetEndLocation (lexer.Location);
		current_block = current_block.Parent;
	  }

void case_889()
#line 5927 "cs-parser.jay"
{
		Linq.AQueryClause from = yyVals[-1+yyTop] as Linq.AQueryClause;
			
		from.Tail.Next = (Linq.AQueryClause)yyVals[0+yyTop];
		yyVal = from;
		
		current_block.SetEndLocation (lexer.Location);
		current_block = current_block.Parent;
	  }

void case_890()
#line 5938 "cs-parser.jay"
{
	        lexer.query_parsing = false;
		yyVal = yyVals[-1+yyTop];

		current_block.SetEndLocation (lexer.Location);
		current_block = current_block.Parent;
	  }

void case_891()
#line 5945 "cs-parser.jay"
{
	        yyVal = yyVals[-1+yyTop];
		current_block.SetEndLocation (lexer.Location);
		current_block = current_block.Parent;
	  }

void case_892()
#line 5954 "cs-parser.jay"
{
		current_block = new Linq.QueryBlock (current_block, lexer.Location);
	  
		var lt = (Tokenizer.LocatedToken) yyVals[-2+yyTop];
		var rv = new Linq.RangeVariable (lt.Value, lt.Location);
		var start = new Linq.QueryStartClause ((Linq.QueryBlock)current_block, (Expression)yyVals[0+yyTop], rv, GetLocation (yyVals[-3+yyTop]));
		lbag.AddLocation (start, GetLocation (yyVals[-1+yyTop]));
		yyVal = new Linq.QueryExpression (start);
	  }

void case_893()
#line 5964 "cs-parser.jay"
{
		current_block = new Linq.QueryBlock (current_block, lexer.Location);
	  
		var lt = (Tokenizer.LocatedToken) yyVals[-2+yyTop];
		var rv = new Linq.RangeVariable (lt.Value, lt.Location);
		var start = new Linq.QueryStartClause ((Linq.QueryBlock)current_block, (Expression)yyVals[0+yyTop], rv, GetLocation (yyVals[-4+yyTop])) {
			IdentifierType = (FullNamedExpression)yyVals[-3+yyTop]
		};
		lbag.AddLocation (start, GetLocation (yyVals[-1+yyTop]));
		yyVal = new Linq.QueryExpression (start);
	  }

void case_894()
#line 5979 "cs-parser.jay"
{
		current_block = new Linq.QueryBlock (current_block, lexer.Location);
	  
		var lt = (Tokenizer.LocatedToken) yyVals[-2+yyTop];
		var rv = new Linq.RangeVariable (lt.Value, lt.Location);
		var start = new Linq.QueryStartClause ((Linq.QueryBlock)current_block, (Expression)yyVals[0+yyTop], rv, GetLocation (yyVals[-3+yyTop]));
		lbag.AddLocation (start, GetLocation (yyVals[-1+yyTop]));
		yyVal = new Linq.QueryExpression (start);
	  }

void case_895()
#line 5989 "cs-parser.jay"
{
		current_block = new Linq.QueryBlock (current_block, lexer.Location);
	  
		var lt = (Tokenizer.LocatedToken) yyVals[-2+yyTop];
		var rv = new Linq.RangeVariable (lt.Value, lt.Location);
		var start = new Linq.QueryStartClause ((Linq.QueryBlock)current_block, (Expression)yyVals[0+yyTop], rv, GetLocation (yyVals[-4+yyTop])) {
			IdentifierType = (FullNamedExpression)yyVals[-3+yyTop]
		};
		lbag.AddLocation (start, GetLocation (yyVals[-1+yyTop]));
		yyVal = new Linq.QueryExpression (start);
	  }

void case_897()
#line 6008 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[-3+yyTop];
		var sn = new Linq.RangeVariable (lt.Value, lt.Location);
		yyVal = new Linq.SelectMany ((Linq.QueryBlock)current_block, sn, (Expression)yyVals[0+yyTop], GetLocation (yyVals[-4+yyTop]));
		
		current_block.SetEndLocation (lexer.Location);
		current_block = current_block.Parent;
		((Linq.QueryBlock)current_block).AddRangeVariable (sn);

		lbag.AddLocation (yyVal, GetLocation (yyVals[-2+yyTop]));
	  }

void case_899()
#line 6024 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[-3+yyTop];
		var sn = new Linq.RangeVariable (lt.Value, lt.Location);

		yyVal = new Linq.SelectMany ((Linq.QueryBlock)current_block, sn, (Expression)yyVals[0+yyTop], GetLocation (yyVals[-5+yyTop])) {
			IdentifierType = (FullNamedExpression)yyVals[-4+yyTop]
		};
		
		current_block.SetEndLocation (lexer.Location);
		current_block = current_block.Parent;
		
		((Linq.QueryBlock)current_block).AddRangeVariable (sn);
		
		lbag.AddLocation (yyVal, GetLocation (yyVals[-2+yyTop]));
	  }

void case_900()
#line 6043 "cs-parser.jay"
{
	  	Linq.AQueryClause head = (Linq.AQueryClause)yyVals[-1+yyTop];
		
		if (yyVals[0+yyTop] != null)
			head.Next = (Linq.AQueryClause)yyVals[0+yyTop];
				
		if (yyVals[-2+yyTop] != null) {
			Linq.AQueryClause clause = (Linq.AQueryClause)yyVals[-2+yyTop];
			clause.Tail.Next = head;
			head = clause;
		}
		
		yyVal = head;
	  }

void case_901()
#line 6058 "cs-parser.jay"
{
	  	Linq.AQueryClause head = (Linq.AQueryClause)yyVals[0+yyTop];

		if (yyVals[-1+yyTop] != null) {
			Linq.AQueryClause clause = (Linq.AQueryClause)yyVals[-1+yyTop];
			clause.Tail.Next = head;
			head = clause;
		}
		
		yyVal = head;
	  }

void case_903()
#line 6071 "cs-parser.jay"
{
		report.Error (742, GetLocation (yyVals[0+yyTop]), "Unexpected symbol `{0}'. A query body must end with select or group clause", GetSymbolName (yyToken));
		yyVal = yyVals[-1+yyTop];
	  }

void case_904()
#line 6076 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);
		yyVal = null;
	  }

void case_906()
#line 6088 "cs-parser.jay"
{
		yyVal = new Linq.Select ((Linq.QueryBlock)current_block, (Expression)yyVals[0+yyTop], GetLocation (yyVals[-2+yyTop]));

		current_block.SetEndLocation (lexer.Location);
		current_block = current_block.Parent;
	  }

void case_907()
#line 6095 "cs-parser.jay"
{
	  	if (linq_clause_blocks == null)
	  		linq_clause_blocks = new Stack<Linq.QueryBlock> ();
	  		
	  	current_block = new Linq.QueryBlock (current_block, lexer.Location);
	  	linq_clause_blocks.Push ((Linq.QueryBlock)current_block);
	  }

void case_908()
#line 6103 "cs-parser.jay"
{
		current_block.SetEndLocation (lexer.Location);
		current_block = current_block.Parent;
	  
		current_block = new Linq.QueryBlock (current_block, lexer.Location);
	  }

void case_909()
#line 6110 "cs-parser.jay"
{
		yyVal = new Linq.GroupBy ((Linq.QueryBlock)current_block, (Expression)yyVals[-3+yyTop], linq_clause_blocks.Pop (), (Expression)yyVals[0+yyTop], GetLocation (yyVals[-5+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
		
		current_block.SetEndLocation (lexer.Location);
		current_block = current_block.Parent;
	  }

void case_911()
#line 6122 "cs-parser.jay"
{
		((Linq.AQueryClause)yyVals[-1+yyTop]).Tail.Next = (Linq.AQueryClause)yyVals[0+yyTop];
		yyVal = yyVals[-1+yyTop];
	  }

void case_918()
#line 6142 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[-3+yyTop];
		var sn = new Linq.RangeVariable (lt.Value, lt.Location);
	  	yyVal = new Linq.Let ((Linq.QueryBlock) current_block, sn, (Expression)yyVals[0+yyTop], GetLocation (yyVals[-4+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[-2+yyTop]));
	  	
		current_block.SetEndLocation (lexer.Location);
		current_block = current_block.Parent;
		
		((Linq.QueryBlock)current_block).AddRangeVariable (sn);
	  }

void case_920()
#line 6161 "cs-parser.jay"
{
		yyVal = new Linq.Where ((Linq.QueryBlock)current_block, (Expression)yyVals[0+yyTop], GetLocation (yyVals[-2+yyTop]));

		current_block.SetEndLocation (lexer.Location);
		current_block = current_block.Parent;
	  }

void case_921()
#line 6171 "cs-parser.jay"
{
		if (linq_clause_blocks == null)
			linq_clause_blocks = new Stack<Linq.QueryBlock> ();
	  		
		current_block = new Linq.QueryBlock (current_block, lexer.Location);
		linq_clause_blocks.Push ((Linq.QueryBlock) current_block);
	  }

void case_922()
#line 6179 "cs-parser.jay"
{
		current_block.SetEndLocation (lexer.Location);
		current_block = current_block.Parent;

		current_block = new Linq.QueryBlock (current_block, lexer.Location);
		linq_clause_blocks.Push ((Linq.QueryBlock) current_block);
	  }

void case_923()
#line 6187 "cs-parser.jay"
{
		current_block.AddStatement (new ContextualReturn ((Expression) yyVals[-1+yyTop]));
		current_block.SetEndLocation (lexer.Location);
		current_block = current_block.Parent;

		current_block = new Linq.QueryBlock (current_block, lexer.Location);
	  }

void case_924()
#line 6195 "cs-parser.jay"
{
		current_block.AddStatement (new ContextualReturn ((Expression) yyVals[-1+yyTop]));
		current_block.SetEndLocation (lexer.Location);
	  
		var outer_selector = linq_clause_blocks.Pop ();
		var block = linq_clause_blocks.Pop ();

		var lt = (Tokenizer.LocatedToken) yyVals[-10+yyTop];	
		var sn = new Linq.RangeVariable (lt.Value, lt.Location);
		Linq.RangeVariable into;
		
		if (yyVals[0+yyTop] == null) {
			into = sn;
	  		yyVal = new Linq.Join (block, sn, (Expression)yyVals[-7+yyTop], outer_selector, (Linq.QueryBlock) current_block, GetLocation (yyVals[-11+yyTop]));
			lbag.AddLocation (yyVal, GetLocation (yyVals[-9+yyTop]), GetLocation (yyVals[-6+yyTop]), GetLocation (yyVals[-3+yyTop]));
		} else {
			/**/
			/* Set equals right side parent to beginning of linq query, it is not accessible therefore cannot cause name collisions*/
			/**/
			var parent = block.Parent;
			while (parent is Linq.QueryBlock) {
				parent = parent.Parent;
			}
			current_block.Parent = parent;
			
			((Linq.QueryBlock)current_block).AddRangeVariable (sn);
		
			lt = (Tokenizer.LocatedToken) yyVals[0+yyTop];
			into = new Linq.RangeVariable (lt.Value, lt.Location);

			yyVal = new Linq.GroupJoin (block, sn, (Expression)yyVals[-7+yyTop], outer_selector, (Linq.QueryBlock) current_block, into, GetLocation (yyVals[-11+yyTop]));	
			lbag.AddLocation (yyVal, GetLocation (yyVals[-9+yyTop]), GetLocation (yyVals[-6+yyTop]), GetLocation (yyVals[-3+yyTop]), opt_intoStack.Pop ());
		}

		current_block = block.Parent;
		((Linq.QueryBlock)current_block).AddRangeVariable (into);
	  }

void case_925()
#line 6233 "cs-parser.jay"
{
		if (linq_clause_blocks == null)
			linq_clause_blocks = new Stack<Linq.QueryBlock> ();
	  		
		current_block = new Linq.QueryBlock (current_block, lexer.Location);
		linq_clause_blocks.Push ((Linq.QueryBlock) current_block);
	  }

void case_926()
#line 6241 "cs-parser.jay"
{
		current_block.SetEndLocation (lexer.Location);
		current_block = current_block.Parent;

		current_block = new Linq.QueryBlock (current_block, lexer.Location);
		linq_clause_blocks.Push ((Linq.QueryBlock) current_block);
	  }

void case_927()
#line 6249 "cs-parser.jay"
{
		current_block.AddStatement (new ContextualReturn ((Expression) yyVals[-1+yyTop]));
		current_block.SetEndLocation (lexer.Location);
		current_block = current_block.Parent;

		current_block = new Linq.QueryBlock (current_block, lexer.Location);
	  }

void case_928()
#line 6257 "cs-parser.jay"
{
		current_block.AddStatement (new ContextualReturn ((Expression) yyVals[-1+yyTop]));
		current_block.SetEndLocation (lexer.Location);
	  
		var outer_selector = linq_clause_blocks.Pop ();
		var block = linq_clause_blocks.Pop ();
		
		var lt = (Tokenizer.LocatedToken) yyVals[-10+yyTop];
		var sn = new Linq.RangeVariable (lt.Value, lt.Location);
		Linq.RangeVariable into;
		
		if (yyVals[0+yyTop] == null) {
			into = sn;		
	  		yyVal = new Linq.Join (block, sn, (Expression)yyVals[-7+yyTop], outer_selector, (Linq.QueryBlock) current_block, GetLocation (yyVals[-12+yyTop])) {
	  			IdentifierType = (FullNamedExpression)yyVals[-11+yyTop]
	  		};
			lbag.AddLocation (yyVal, GetLocation (yyVals[-10+yyTop]), GetLocation (yyVals[-7+yyTop]), GetLocation (yyVals[-4+yyTop]));
		} else {
			/**/
			/* Set equals right side parent to beginning of linq query, it is not accessible therefore cannot cause name collisions*/
			/**/
			var parent = block.Parent;
			while (parent is Linq.QueryBlock) {
				parent = parent.Parent;
			}
			current_block.Parent = parent;
		
			((Linq.QueryBlock)current_block).AddRangeVariable (sn);
		
			lt = (Tokenizer.LocatedToken) yyVals[0+yyTop];
			into = new Linq.RangeVariable (lt.Value, lt.Location); /* TODO:*/
			
			yyVal = new Linq.GroupJoin (block, sn, (Expression)yyVals[-7+yyTop], outer_selector, (Linq.QueryBlock) current_block, into, GetLocation (yyVals[-12+yyTop])) {
	  			IdentifierType = (FullNamedExpression)yyVals[-11+yyTop]
	  		};			
			lbag.AddLocation (yyVal, GetLocation (yyVals[-10+yyTop]), GetLocation (yyVals[-7+yyTop]), GetLocation (yyVals[-4+yyTop]), opt_intoStack.Pop ());
		}
		
		current_block = block.Parent;
		((Linq.QueryBlock)current_block).AddRangeVariable (into);		
	  }

void case_930()
#line 6303 "cs-parser.jay"
{
		opt_intoStack.Push (GetLocation (yyVals[-1+yyTop]));
		yyVal = yyVals[0+yyTop];
	  }

void case_932()
#line 6315 "cs-parser.jay"
{
		current_block.SetEndLocation (lexer.Location);
		current_block = current_block.Parent;
	  
		yyVal = yyVals[0+yyTop];
	  }

void case_934()
#line 6326 "cs-parser.jay"
{
		current_block.SetEndLocation (lexer.Location);
		current_block = current_block.Parent;
	  
		current_block = new Linq.QueryBlock (current_block, lexer.Location);
	  }

void case_935()
#line 6333 "cs-parser.jay"
{
		((Linq.AQueryClause)yyVals[-3+yyTop]).Next = (Linq.AQueryClause)yyVals[0+yyTop];
		yyVal = yyVals[-3+yyTop];
	  }

void case_937()
#line 6342 "cs-parser.jay"
{
		current_block.SetEndLocation (lexer.Location);
		current_block = current_block.Parent;
	  
		current_block = new Linq.QueryBlock ((Linq.QueryBlock) current_block, lexer.Location);	 
	 }

void case_938()
#line 6349 "cs-parser.jay"
{
		((Linq.AQueryClause)yyVals[-3+yyTop]).Tail.Next = (Linq.AQueryClause)yyVals[0+yyTop];
		yyVal = yyVals[-3+yyTop];
	 }

void case_940()
#line 6361 "cs-parser.jay"
{
		yyVal = new Linq.OrderByAscending ((Linq.QueryBlock) current_block, (Expression)yyVals[-1+yyTop]);	
		lbag.AddLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_941()
#line 6366 "cs-parser.jay"
{
		yyVal = new Linq.OrderByDescending ((Linq.QueryBlock) current_block, (Expression)yyVals[-1+yyTop]);	
		lbag.AddLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_943()
#line 6378 "cs-parser.jay"
{
		yyVal = new Linq.ThenByAscending ((Linq.QueryBlock) current_block, (Expression)yyVals[-1+yyTop]);	
		lbag.AddLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_944()
#line 6383 "cs-parser.jay"
{
		yyVal = new Linq.ThenByDescending ((Linq.QueryBlock) current_block, (Expression)yyVals[-1+yyTop]);	
		lbag.AddLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_946()
#line 6393 "cs-parser.jay"
{
		/* query continuation block is not linked with query block but with block*/
		/* before. This means each query can use same range variable names for*/
		/* different identifiers.*/

		current_block.SetEndLocation (GetLocation (yyVals[-1+yyTop]));
		current_block = current_block.Parent;
	
		current_block = new Linq.QueryBlock (current_block, lexer.Location);
		
		if (linq_clause_blocks == null)
			linq_clause_blocks = new Stack<Linq.QueryBlock> ();
	  		
		linq_clause_blocks.Push ((Linq.QueryBlock) current_block);		
	  }

void case_947()
#line 6409 "cs-parser.jay"
{
		var current_block = linq_clause_blocks.Pop ();	  
		var lt = (Tokenizer.LocatedToken) yyVals[-2+yyTop];
		var rv = new Linq.RangeVariable (lt.Value, lt.Location);
  		yyVal = new Linq.QueryStartClause ((Linq.QueryBlock)current_block, null, rv, GetLocation (yyVals[-3+yyTop])) {
  			next = (Linq.AQueryClause)yyVals[0+yyTop]
  		};
	  }

void case_950()
#line 6436 "cs-parser.jay"
{ 
		current_container = current_type = new Class (current_container, new MemberName ("<InteractiveExpressionClass>"), Modifiers.PUBLIC, null);

		/* (ref object retval)*/
		Parameter [] mpar = new Parameter [1];
		mpar [0] = new Parameter (new TypeExpression (compiler.BuiltinTypes.Object, Location.Null), "$retval", Parameter.Modifier.REF, null, Location.Null);

		ParametersCompiled pars = new ParametersCompiled (mpar);
		var mods = Modifiers.PUBLIC | Modifiers.STATIC;
		if (settings.Unsafe)
			mods |= Modifiers.UNSAFE;

		current_local_parameters = pars;
		Method method = new Method (
			current_type,
			new TypeExpression (compiler.BuiltinTypes.Void, Location.Null),
			mods,
			new MemberName ("Host"),
			pars,
			null /* attributes */);
			
		current_type.AddMember (method);			

		oob_stack.Push (method);
		++lexer.parsing_block;
		start_block (lexer.Location);
	  }

void case_951()
#line 6464 "cs-parser.jay"
{
		--lexer.parsing_block;
		Method method = (Method) oob_stack.Pop ();

		method.Block = (ToplevelBlock) end_block(lexer.Location);

		InteractiveResult = (Class) pop_current_class ();
		current_local_parameters = null;
	  }

void case_961()
#line 6507 "cs-parser.jay"
{
		module.DocumentationBuilder.ParsedBuiltinType = (TypeExpression)yyVals[-1+yyTop];
		module.DocumentationBuilder.ParsedParameters = (List<DocumentationParameter>)yyVals[0+yyTop];
		yyVal = null;
	  }

void case_962()
#line 6513 "cs-parser.jay"
{
		module.DocumentationBuilder.ParsedBuiltinType = (TypeExpression)yyVals[-3+yyTop];
		module.DocumentationBuilder.ParsedParameters = (List<DocumentationParameter>)yyVals[0+yyTop];
		var lt = (Tokenizer.LocatedToken) yyVals[-1+yyTop];
		yyVal = new MemberName (lt.Value);
	  }

void case_965()
#line 6528 "cs-parser.jay"
{
		module.DocumentationBuilder.ParsedParameters = (List<DocumentationParameter>)yyVals[-1+yyTop];
		yyVal = new MemberName ((MemberName) yyVals[-6+yyTop], MemberCache.IndexerNameAlias, Location.Null);
	  }

void case_966()
#line 6533 "cs-parser.jay"
{
		var p = (List<DocumentationParameter>)yyVals[0+yyTop] ?? new List<DocumentationParameter> (1);
		p.Add (new DocumentationParameter ((FullNamedExpression) yyVals[-1+yyTop]));
		module.DocumentationBuilder.ParsedParameters = p;
		module.DocumentationBuilder.ParsedOperator = Operator.OpType.Explicit;
		yyVal = null;
	  }

void case_967()
#line 6541 "cs-parser.jay"
{
		var p = (List<DocumentationParameter>)yyVals[0+yyTop] ?? new List<DocumentationParameter> (1);
		p.Add (new DocumentationParameter ((FullNamedExpression) yyVals[-1+yyTop]));
		module.DocumentationBuilder.ParsedParameters = p;
		module.DocumentationBuilder.ParsedOperator = Operator.OpType.Implicit;
		yyVal = null;
	  }

void case_968()
#line 6549 "cs-parser.jay"
{
		var p = (List<DocumentationParameter>)yyVals[0+yyTop] ?? new List<DocumentationParameter> (1);
		module.DocumentationBuilder.ParsedParameters = p;
		module.DocumentationBuilder.ParsedOperator = (Operator.OpType) yyVals[-1+yyTop];
		yyVal = null;
	  }

void case_976()
#line 6587 "cs-parser.jay"
{
		var parameters = new List<DocumentationParameter> ();
		parameters.Add ((DocumentationParameter) yyVals[0+yyTop]);
		yyVal = parameters;
	  }

void case_977()
#line 6593 "cs-parser.jay"
{
		var parameters = yyVals[-2+yyTop] as List<DocumentationParameter>;
		parameters.Add ((DocumentationParameter) yyVals[0+yyTop]);
		yyVal = parameters;
	  }

void case_978()
#line 6602 "cs-parser.jay"
{
		if (yyVals[-1+yyTop] != null)
			yyVal = new DocumentationParameter ((Parameter.Modifier) yyVals[-1+yyTop], (FullNamedExpression) yyVals[0+yyTop]);
		else
			yyVal = new DocumentationParameter ((FullNamedExpression) yyVals[0+yyTop]);
	  }

#line default
   static readonly short [] yyLhs  = {              -1,
    0,    4,    0,    0,    1,    1,    1,    1,    2,    2,
   11,   11,   12,   12,   13,   13,   14,   15,   15,   15,
   19,   20,   17,   18,   18,   18,   22,   22,   23,   23,
    7,    7,    6,    6,   21,   21,    8,    8,   24,   24,
   24,   25,   25,   25,   25,   25,    9,    9,   10,   10,
   33,   31,   36,   32,   32,   34,   34,   34,   34,   35,
   35,   40,   37,   38,   39,   39,   41,   41,   41,   41,
   41,   42,   42,   46,   43,   45,   48,   48,   48,   49,
   49,   50,   50,   51,   51,   51,   51,   51,   51,   51,
   51,   51,   51,   51,   51,   65,   67,   69,   70,   71,
   27,   27,   74,   52,   75,   75,   76,   76,   77,   79,
   73,   73,   78,   78,   84,   53,   88,   53,   53,   83,
   91,   83,   85,   85,   92,   92,   93,   94,   93,   89,
   89,   95,   95,   96,   97,   87,   87,   90,   90,   90,
  100,   54,  103,  104,   98,  105,  106,  107,   98,   98,
   98,   99,   99,  102,  102,  110,  110,  110,  110,  110,
  110,  110,  110,  110,  110,  111,  111,  114,  114,  114,
  114,  117,  114,  115,  115,  118,  118,  119,  119,  119,
  112,  112,  112,  120,  120,  120,  113,  122,  124,  125,
   55,  127,  128,  129,   57,  123,  123,  123,  123,  123,
  133,  130,  134,  131,  132,  132,  132,  135,  136,  137,
  139,   28,   28,  138,  138,  140,  140,  141,  141,  141,
  141,  141,  141,  141,  141,  141,  144,   58,  143,  143,
  145,  145,  148,  142,  142,  147,  147,  147,  147,  147,
  147,  147,  147,  147,  147,  147,  147,  147,  147,  147,
  147,  147,  147,  147,  147,  147,  147,  150,  149,  151,
  149,  149,  149,   59,  154,  156,  152,  153,  153,  155,
  155,  160,  158,  161,  158,  158,  158,  162,   60,  164,
   56,  167,  168,   56,  163,  170,  163,  165,  165,  171,
  171,  172,  173,  172,  174,  169,  166,  166,  166,  166,
  166,  178,  175,  179,  176,  177,  177,   61,  181,  183,
  184,   29,  180,  180,  180,  182,  182,  182,  185,  185,
  186,  187,  186,  188,  189,  190,   30,  191,  191,   16,
   16,  192,  192,  195,  194,  194,  194,  196,  196,  198,
   64,  121,  101,  101,  126,  126,  199,  199,  199,  197,
  197,  200,  200,  201,  201,  203,  203,   82,   72,   72,
   86,   86,  116,  116,  146,  146,  204,  204,  204,  204,
  204,  208,  208,  209,  207,  207,  207,  207,  207,  207,
  207,  210,  210,  210,  210,  210,  210,  210,  210,  210,
  211,  211,  211,  211,  211,  211,  211,  211,  211,  211,
  211,  211,  211,  211,  211,  211,  211,  211,  211,  211,
  212,  212,  212,  213,  213,  213,  233,  233,  234,  234,
  235,  235,  215,  215,  232,  232,  232,  232,  232,  232,
  232,  232,  217,  236,  236,  237,  237,  238,  238,  240,
  240,  240,  241,  241,  241,  241,  241,  242,  242,  159,
  159,  246,  246,  246,  246,  246,  248,  248,  247,  247,
  249,  249,  249,  249,  250,  218,  218,  218,  245,  245,
  245,  251,  251,  252,  252,  219,  220,  220,  221,  222,
  223,  223,  214,  214,  214,  214,  214,  257,  253,  224,
  258,  258,  259,  259,  260,  260,  261,  261,  261,  261,
  254,  254,  205,  205,  256,  256,  262,  262,  255,  255,
   81,   81,  263,  263,  264,  225,  265,  265,  265,  266,
  266,  266,  266,  266,  267,  193,  226,  227,  228,  229,
  269,  230,  270,  230,  268,  268,  272,  271,  216,  273,
  273,  273,  273,  273,  274,  274,  274,  274,  274,  274,
  274,  275,  275,  275,  275,  276,  276,  276,  276,  276,
  276,  277,  277,  277,  278,  278,  278,  278,  278,  279,
  279,  279,  280,  280,  281,  281,  282,  282,  283,  283,
  284,  284,  285,  285,  286,  286,  286,  288,  288,  288,
  288,  288,  288,  288,  288,  288,  288,  288,  289,  289,
  290,  290,  290,  291,  291,  292,  292,  294,  293,  287,
  287,  296,  295,  297,  295,  298,  299,  295,  300,  301,
  295,   44,   44,  243,  243,  243,  243,  231,  231,  231,
   80,  303,  304,  305,  306,  307,   26,   63,   63,   62,
   62,  108,  108,  308,  308,  308,  308,  308,  308,  308,
  308,  308,  308,  308,  308,  308,  308,  308,   66,   66,
   66,   68,   68,  309,  309,  310,  310,  311,  311,  312,
  312,  312,  312,  202,  202,  313,  313,  315,  109,  316,
  316,  317,  157,  157,  314,  314,  318,  318,  319,  319,
  319,  319,  319,  323,  323,  324,  324,  324,  321,  321,
  321,  321,  321,  321,  321,  321,  321,  321,  321,  321,
  321,  325,  325,  325,  325,  325,  325,  325,  325,  325,
  325,  325,  325,  325,  339,  339,  339,  339,  326,  340,
  322,  341,  341,  342,  342,  342,  342,  342,  342,  206,
  206,  343,   47,   47,  345,  320,  349,  320,  347,  347,
  344,  344,  344,  344,  346,  346,  353,  353,  352,  352,
  354,  354,  348,  348,  350,  350,  355,  355,  356,  351,
  351,  351,  327,  327,  327,  338,  338,  357,  358,  358,
  328,  328,  359,  359,  359,  362,  360,  360,  361,  361,
  363,  363,  363,  366,  364,  365,  365,  367,  367,  367,
  329,  329,  329,  329,  368,  368,  369,  369,  369,  373,
  370,  376,  372,  372,  379,  375,  375,  378,  378,  374,
  374,  382,  381,  381,  377,  377,  380,  380,  384,  383,
  383,  371,  371,  385,  371,  371,  371,  330,  330,  330,
  330,  330,  330,  386,  387,  387,  388,  388,  388,  389,
  389,  390,  390,  391,  391,  392,  392,  331,  331,  331,
  331,  393,  393,  395,  395,  394,  396,  394,  394,  332,
  333,  397,  336,  334,  334,  399,  400,  337,  402,  403,
  335,  335,  335,  401,  401,  398,  398,  302,  302,  302,
  302,  404,  404,  406,  406,  408,  407,  409,  407,  405,
  405,  405,  405,  405,  413,  411,  414,  415,  411,  410,
  410,  416,  416,  416,  416,  416,  421,  417,  422,  418,
  423,  424,  425,  419,  427,  428,  429,  419,  426,  426,
  431,  420,  430,  434,  430,  433,  436,  433,  432,  432,
  432,  435,  435,  435,  412,  437,  412,    3,    3,  438,
    3,    3,  439,  439,  244,  244,  239,  239,    5,  440,
  440,  440,  440,  444,  440,  440,  440,  440,  441,  441,
  442,  445,  442,  443,  443,  446,  446,  447,
  };
   static readonly short [] yyLen = {           2,
    2,    0,    3,    1,    2,    4,    3,    1,    0,    1,
    1,    2,    4,    2,    1,    2,    1,    3,    5,    2,
    0,    0,   11,    1,    3,    1,    0,    1,    0,    1,
    0,    1,    0,    1,    0,    1,    1,    2,    1,    1,
    2,    1,    1,    1,    1,    1,    0,    1,    1,    2,
    0,    3,    0,    6,    3,    1,    1,    1,    1,    1,
    3,    0,    3,    1,    0,    3,    0,    1,    1,    3,
    3,    1,    1,    0,    4,    4,    0,    1,    1,    0,
    1,    1,    2,    1,    1,    1,    1,    1,    1,    1,
    1,    1,    1,    1,    1,    0,    0,    0,    0,    0,
   16,    5,    0,    9,    0,    1,    1,    2,    3,    0,
    3,    1,    1,    1,    0,    8,    0,    9,    6,    0,
    0,    3,    0,    1,    1,    2,    2,    0,    5,    0,
    1,    1,    2,    3,    0,    4,    2,    1,    1,    1,
    0,    3,    0,    0,   10,    0,    0,    0,   12,    8,
    5,    1,    1,    0,    1,    1,    3,    3,    3,    5,
    3,    5,    1,    1,    1,    1,    3,    4,    6,    2,
    4,    0,    7,    0,    1,    1,    2,    1,    1,    1,
    4,    6,    4,    1,    2,    2,    1,    0,    0,    0,
   10,    0,    0,    0,   13,    1,    2,    1,    2,    1,
    0,    5,    0,    5,    1,    1,    1,    0,    0,    0,
    0,   15,    5,    0,    1,    1,    2,    1,    1,    1,
    1,    1,    1,    1,    1,    1,    0,    5,    1,    1,
    1,    1,    0,    7,    1,    1,    1,    1,    1,    1,
    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
    1,    1,    1,    1,    1,    1,    1,    0,    7,    0,
    7,    2,    2,    2,    0,    0,    9,    1,    1,    0,
    1,    0,    6,    0,    6,    2,    1,    0,    8,    0,
    9,    0,    0,   10,    0,    0,    3,    0,    1,    1,
    2,    2,    0,    5,    0,    2,    2,    2,    1,    1,
    1,    0,    5,    0,    5,    1,    1,    2,    0,    0,
    0,   12,    0,    2,    2,    0,    1,    2,    1,    3,
    2,    0,    5,    0,    0,    0,   13,    0,    1,    1,
    3,    1,    4,    2,    0,    3,    2,    1,    3,    0,
    3,    1,    1,    3,    1,    2,    3,    4,    4,    0,
    3,    1,    3,    3,    1,    1,    1,    1,    1,    1,
    1,    1,    1,    1,    1,    2,    2,    2,    2,    2,
    2,    1,    3,    1,    1,    1,    1,    1,    1,    1,
    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
    2,    2,    1,    1,    1,    1,    1,    1,    1,    1,
    1,    1,    3,    3,    4,    4,    4,    3,    3,    4,
    3,    4,    4,    0,    1,    3,    4,    0,    1,    1,
    3,    2,    3,    1,    2,    3,    2,    1,    1,    0,
    1,    1,    3,    3,    3,    2,    1,    1,    1,    1,
    2,    2,    4,    3,    1,    4,    4,    3,    1,    3,
    2,    1,    3,    1,    1,    1,    4,    3,    2,    2,
    6,    3,    7,    4,    3,    7,    3,    0,    2,    4,
    1,    2,    0,    1,    1,    3,    3,    1,    1,    1,
    0,    1,    1,    2,    2,    3,    1,    2,    0,    1,
    2,    4,    1,    3,    0,    5,    1,    1,    1,    2,
    3,    3,    4,    4,    1,    2,    4,    4,    4,    4,
    0,    4,    0,    5,    0,    1,    0,    4,    4,    1,
    2,    2,    4,    2,    1,    2,    2,    2,    2,    2,
    2,    1,    3,    3,    3,    1,    3,    3,    3,    3,
    3,    1,    3,    3,    1,    3,    3,    3,    3,    1,
    3,    3,    1,    3,    1,    3,    1,    3,    1,    3,
    1,    3,    1,    3,    1,    5,    4,    3,    3,    3,
    3,    3,    3,    3,    3,    3,    3,    3,    1,    3,
    3,    2,    1,    0,    1,    1,    1,    0,    2,    1,
    1,    0,    4,    0,    5,    0,    0,    7,    0,    0,
    8,    1,    1,    1,    1,    1,    1,    6,    4,    4,
    1,    1,    0,    0,    0,    0,   15,    0,    1,    0,
    1,    1,    2,    1,    1,    1,    1,    1,    1,    1,
    1,    1,    1,    1,    1,    1,    1,    1,    0,    2,
    3,    0,    1,    1,    2,    4,    3,    1,    3,    1,
    3,    1,    1,    0,    1,    1,    1,    0,    4,    1,
    1,    0,    4,    1,    0,    1,    1,    2,    1,    1,
    1,    2,    1,    1,    2,    1,    1,    1,    1,    1,
    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
    1,    1,    1,    1,    1,    1,    1,    1,    1,    0,
    4,    1,    2,    2,    2,    2,    2,    2,    1,    1,
    2,    1,    1,    1,    0,    6,    0,    7,    1,    1,
    0,    2,    2,    1,    0,    1,    0,    1,    1,    2,
    2,    4,    0,    2,    0,    1,    1,    2,    4,    1,
    5,    2,    2,    2,    2,    2,    2,    1,    1,    1,
    1,    1,    5,    7,    4,    0,    8,    4,    0,    1,
    1,    2,    1,    0,    3,    1,    2,    3,    3,    1,
    1,    1,    1,    1,    5,    4,    7,    3,    6,    0,
    4,    0,    4,    2,    0,    4,    2,    3,    1,    0,
    1,    0,    5,    1,    0,    1,    0,    1,    1,    1,
    3,    4,    5,    0,    9,    5,    4,    1,    1,    1,
    1,    1,    1,    2,    2,    2,    3,    4,    3,    3,
    2,    3,    2,    4,    3,    0,    1,    3,    4,    5,
    3,    1,    2,    0,    1,    2,    0,    7,    3,    2,
    2,    0,    3,    5,    4,    0,    0,   10,    0,    0,
    9,    5,    4,    2,    1,    0,    2,    2,    2,    2,
    2,    4,    5,    4,    5,    0,    5,    0,    6,    3,
    2,    2,    2,    1,    0,    3,    0,    0,    6,    1,
    2,    1,    1,    1,    1,    1,    0,    5,    0,    3,
    0,    0,    0,   12,    0,    0,    0,   13,    0,    2,
    0,    3,    1,    0,    4,    1,    0,    4,    1,    2,
    2,    1,    2,    2,    0,    0,    4,    2,    3,    0,
    4,    2,    2,    3,    0,    1,    1,    1,    2,    2,
    2,    4,    3,    0,    7,    4,    4,    3,    1,    3,
    0,    0,    4,    0,    1,    1,    3,    2,
  };
   static readonly short [] yyDefRed = {            0,
    8,    0,    0,    0,    0,    0,    0,    0,    2,    4,
    0,    0,   11,   14,    0,  948,    0,    0,  952,    0,
    0,   15,   17,  377,  383,  390,  378,  380,    0,  379,
    0,  386,  388,  375,    0,  382,  384,  376,  387,  389,
  385,  340,  969,    0,  381,  959,    0,   10,    1,    0,
    0,    0,   12,    0,  780,    0,    0,    0,    0,    0,
    0,    0,    0,  418,    0,    0,    0,    0,    0,    0,
    0,  416,    0,    0,    0,  476,    0,  417,    0,  515,
    0,  872,    0,    0,    0,  627,    0,    0,    0,    0,
    0,    0,    0,  678,    0,  729,    0,    0,    0,    0,
    0,    0,    0,    0,  415,    0,  616,    0,  779,    0,
  712,    0,    0,    0,    0,  392,  393,    0,  395,  396,
  397,  398,  399,  400,  401,  402,  403,  404,  405,  406,
  407,  408,  409,  410,  413,  414,  623,  545,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
  624,  622,  625,  626,  696,  698,    0,  694,  697,  713,
  715,  716,  717,  718,  719,  720,  721,  722,  723,  724,
  714,    0,    0,    0,  781,  782,  801,  802,  803,  804,
  838,  839,  840,  841,  842,  843,    0,    0,    0,   20,
    0,    0,  330,    0,  332,  956,   16,  949,    0,    0,
  241,  240,  237,  242,  243,  236,  255,  254,  247,  248,
  244,  246,  245,  249,  238,  239,  250,  251,  257,  256,
  252,  253,    0,    0,  972,    0,  961,    0,  960,    3,
   51,    0,    0,    0,   40,   37,   39,   42,   43,   44,
   45,   46,   49,   13,    0,    0,    0,  844,  419,  420,
  870,    0,    0,    0,    0,    0,    0,  394,    0,  846,
  845,    0,  537,  531,  536,  728,  778,  699,  726,  725,
  727,  700,  701,  702,  703,  704,  705,  706,  707,  708,
  709,  710,  711,    0,    0,    0,  810,    0,    0,    0,
  744,  743,    0,    0,    0,    0,    0,    0,    0,    0,
  851,    0,    0,  857,    0,  391,    0,    0,    0,  853,
    0,    0,    0,  871,    0,    0,    0,  742,  738,    0,
    0,    0,    0,    0,    0,    0,  359,    0,    0,    0,
    0,    0,    0,    0,    0,  619,    0,  544,    0,    0,
  542,  546,  547,  541,  551,  550,  548,  549,  612,  526,
    0,  412,  411,    0,    0,    0,    0,    0,  730,    0,
  329,    0,  736,  737,    0,  479,  480,    0,    0,    0,
  734,  735,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,  951,  695,  745,  733,
    0,  776,  777,  904,  919,    0,    0,  905,  907,    0,
  931,  890,  888,  912,    0,    0,  910,  913,  914,  915,
  916,  891,  889,    0,    0,    0,  334,    0,   18,    0,
    0,    0,  968,    0,  341,    0,    0,    0,  970,    0,
    0,   38,  649,  655,  647,    0,  644,  654,  648,  646,
  645,  652,  650,  651,  657,  653,  656,  658,    0,    0,
  642,   41,   50,  478,    0,  474,  475,    0,    0,  472,
    0,  747,    0,    0,    0,  808,    0,  775,  773,  774,
    0,    0,    0,  631,    0,  849,  847,  632,    0,    0,
  500,    0,    0,    0,  491,    0,  495,  505,  507,    0,
  487,    0,    0,    0,    0,    0,  482,    0,  485,    0,
  489,  361,  850,    0,    0,  852,  861,    0,    0,    0,
  862,    0,    0,  873,    0,    0,  741,    0,  371,  367,
  368,    0,    0,  366,  369,  370,    0,    0,    0,  552,
    0,    0,  533,    0,  614,  693,    0,    0,    0,  687,
  689,  690,  691,  423,  424,    0,  337,  338,    0,  179,
  178,  180,    0,    0,    0,    0,  363,    0,  599,    0,
    0,  855,    0,    0,  428,    0,  431,    0,  429,    0,
  468,    0,    0,    0,    0,    0,  457,  460,    0,    0,
  452,  459,  458,    0,  588,  589,  590,  591,  592,  593,
  594,  595,  596,  598,  597,  553,  555,  554,  560,  561,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,  584,    0,    0,  504,    0,
    0,    0,    0,    0,    0,    0,    0,    0,  903,  902,
    0,  911,    0,  901,    0,    0,  331,  966,  967,  355,
    0,    0,    0,  352,    0,    0,  176,    0,    0,  976,
  962,  964,   59,   57,   58,    0,    0,   52,    0,    0,
   60,   62,   26,   24,    0,    0,    0,  639,    0,  643,
  427,    0,  477,    0,  528,    0,  539,  165,  187,    0,
    0,    0,  155,    0,    0,    0,  166,  532,    0,  876,
    0,  830,  811,    0,  821,    0,  832,    0,  848,  785,
    0,  875,    0,    0,  490,    0,  506,  508,    0,    0,
  444,    0,    0,  440,    0,    0,  469,    0,  510,  484,
    0,  140,  511,  138,  139,  513,    0,  527,  788,    0,
  866,    0,  859,    0,  863,  519,    0,    0,    0,  356,
    0,  517,    0,    0,  529,  883,    0,  879,  806,    0,
  894,    0,  892,    0,    0,  629,  630,    0,    0,    0,
  692,  680,  681,  679,  688,  607,  613,  606,    0,    0,
  336,  602,    0,    0,    0,  543,  854,  731,  432,  426,
  430,  425,  530,  467,  466,  465,  462,  461,    0,  456,
  421,  422,  433,    0,  587,    0,  754,    0,    0,  611,
  610,  920,  896,    0,  921,    0,  906,  908,  917,    0,
  932,    0,  900,  946,   19,  333,  677,  676,    0,  675,
    0,  351,  978,  177,  973,    0,    0,   53,    0,    0,
    0,    0,    0,    0,  358,    0,  633,    0,    0,   79,
   78,    0,  473,    0,    0,    0,    0,    0,  170,  538,
    0,    0,    0,    0,    0,  822,  814,  812,    0,  833,
    0,    0,  874,  497,  496,  447,    0,    0,  957,  958,
  436,  442,    0,  445,    0,  471,    0,    0,    0,    0,
    0,  786,  869,    0,  860,    0,  525,  520,    0,    0,
  516,    0,  882,    0,  805,  895,  893,    0,  534,    0,
  615,  609,  339,  601,  600,  617,  464,    0,  455,  454,
  453,  586,  140,    0,  770,  752,    0,    0,    0,  759,
    0,  898,    0,  925,    0,    0,  940,  941,  934,    0,
  354,  353,  977,    0,    0,   61,   55,    0,   63,   25,
   22,    0,    0,  309,    0,  213,    0,  102,    0,   76,
  764,  113,  114,    0,    0,    0,  767,  185,  186,    0,
    0,    0,    0,  158,  167,  159,  161,  809,    0,    0,
    0,    0,    0,  831,    0,    0,  446,  448,  449,  443,
  437,  441,    0,  502,    0,  470,  481,  435,  514,  512,
    0,  865,    0,    0,    0,  521,    0,  885,    0,    0,
  628,  620,    0,  463,    0,    0,  750,  749,  746,  760,
  897,    0,    0,    0,    0,  918,    0,  947,  965,    0,
    0,    0,   68,   69,   72,   73,    0,  324,  315,  314,
    0,  634,  209,   97,    0,  748,  768,  171,    0,  183,
    0,    0,    0,  807,  887,    0,    0,    0,    0,  813,
    0,  834,  784,  486,  483,  793,    0,  800,    0,    0,
  791,    0,  796,  867,  524,  523,  884,  880,    0,  618,
    0,    0,  899,  922,    0,  909,    0,    0,  936,    0,
   74,   66,    0,    0,    0,  310,    0,    0,    0,    0,
    0,  172,    0,  162,  160,  877,  823,  817,  815,    0,
    0,  787,  792,    0,  797,    0,    0,  621,    0,  762,
    0,  926,  943,  944,  937,   54,    0,   70,   71,    0,
    0,    0,    0,    0,    0,    0,  769,  169,    0,  182,
    0,    0,  835,  799,  798,    0,  682,  684,  868,  881,
  771,    0,    0,    0,   75,    0,    0,  325,    0,  311,
    0,  319,  374,    0,  372,    0,  635,    0,  664,  210,
   98,  173,  878,  819,  816,    0,    0,  828,    0,  923,
    0,  938,    0,    0,    0,    0,    0,  661,    0,    0,
    0,  665,    0,    0,    0,    0,    0,  927,   28,   23,
  326,    0,    0,  320,  373,  667,    0,    0,    0,   99,
  818,  683,    0,    0,    0,    0,  312,  672,    0,  673,
  670,    0,  668,   95,    0,    0,   93,    0,    0,   82,
   84,   85,   86,   87,   88,   89,   90,   91,   92,   94,
  141,    0,    0,  226,  218,  219,  220,  221,  222,  223,
  224,  225,    0,    0,  216,    0,    0,  924,    0,  327,
  323,    0,    0,    0,  308,  636,   83,    0,  269,  264,
  268,    0,  211,  217,    0,  930,  928,  671,  669,    0,
    0,    0,    0,    0,    0,    0,  278,    0,    0,  227,
    0,    0,  235,    0,  153,  142,  152,    0,  100,    0,
    0,  263,    0,    0,  262,    0,  146,    0,    0,  345,
    0,  343,    0,    0,  188,    0,    0,    0,    0,    0,
  637,  212,    0,  103,    0,  342,    0,    0,    0,    0,
  117,    0,    0,    0,    0,    0,    0,  151,  143,    0,
    0,  192,    0,  346,    0,  230,  229,  228,    0,  101,
    0,  282,    0,  260,  119,    0,  258,    0,    0,    0,
  121,    0,  347,    0,    0,  189,    0,    0,    0,  344,
  233,  112,  110,    0,    0,  286,    0,    0,    0,    0,
    0,  147,    0,  266,    0,    0,    0,    0,  125,    0,
    0,    0,    0,  348,  349,    0,    0,    0,    0,    0,
  107,  301,    0,  283,    0,    0,  295,    0,    0,    0,
  290,    0,  137,    0,    0,    0,    0,  132,    0,    0,
  279,    0,  122,    0,  116,  126,  144,  150,  200,    0,
  190,    0,    0,    0,    0,  111,    0,  104,  108,    0,
    0,    0,  297,    0,  298,  287,    0,    0,  281,  291,
  261,    0,    0,  118,  133,  259,    0,  277,    0,  267,
  271,  128,    0,    0,    0,  197,  199,  193,  234,  109,
  302,  304,  284,    0,    0,  296,  293,  136,  134,  148,
  276,    0,    0,    0,  145,  201,  203,  191,    0,    0,
    0,  295,    0,  272,  274,  129,    0,    0,  194,  306,
  307,  303,  305,  294,  149,    0,    0,  207,  206,  205,
  202,  204,    0,    0,    0,  195,  273,  275,
  };
  protected static readonly short [] yyDgoto  = {             7,
    8,   49,    9,   50,   10,   11,   51,  232,  700,  662,
   12,   13,   52,   22,   23,  324,  235,  685,  853, 1047,
 1167, 1510,  850,  236,  237,  238,  239,  240,  241,  242,
  243,  678,  450,  679,  680,  955,  681,  682,  959,  851,
 1042, 1043, 1044,  267,  598, 1137,  110,  862, 1238, 1239,
 1240, 1241, 1242, 1243, 1244, 1245, 1246, 1247, 1248, 1249,
 1250,  469,  689, 1322,  969, 1144, 1109, 1177, 1204, 1266,
 1333, 1173, 1384, 1361, 1409, 1410, 1411,  971, 1407,  972,
  745, 1299, 1372, 1346, 1397,  521, 1390, 1366, 1426,  935,
 1395, 1398, 1399, 1494, 1427, 1428, 1424, 1251, 1306, 1278,
 1323,  702, 1374, 1473, 1343, 1430, 1503,  470,  268,  703,
  704,  705,  706,  707,  665,  575, 1149,  666,  667,  868,
 1325, 1351, 1441, 1402, 1475, 1326, 1377, 1499, 1523, 1442,
 1443, 1521, 1507, 1508,  967, 1108, 1203, 1263, 1308, 1264,
 1265, 1300, 1358, 1329, 1301,  327,  223, 1406, 1303, 1391,
 1388, 1252, 1280, 1319, 1470, 1432, 1159, 1471,  599, 1516,
 1517, 1318, 1387, 1363, 1419, 1414, 1385, 1451, 1456, 1417,
 1420, 1421, 1502, 1457, 1415, 1416, 1512, 1500, 1501,  964,
 1051, 1170, 1142, 1196, 1171, 1172, 1212, 1105, 1194, 1225,
  540,  193,  112,  353,  195,  569,  445,  224, 1338,  663,
  664,  839,  855,  328,  410,  539,  305, 1174, 1175,   45,
  114,  306,  116,  117,  118,  119,  120,  121,  122,  123,
  124,  125,  126,  127,  128,  129,  130,  131,  132,  133,
  134,  135,  136,  252,  813, 1007,  517,  732,  891,  733,
  734, 1000,  137,  198,  738,  600,  601,  602,  603,  807,
  479,  480,  298, 1005,  740,  411,  300,  504,  505,  506,
  507,  510,  747,  313,  763,  764,  908,  264,  485,  778,
  265,  484,  138,  139,  140,  141,  142,  143,  144,  145,
  146,  147,  148,  149,  150,  151,  822,  152,  578,  579,
  580,  787,  788,  789,  153,  566,  780,  354, 1023,  554,
 1089,  154,  499,  965, 1107, 1201, 1304,  471, 1178, 1179,
 1232, 1233,  840,  558,  339,  784, 1189,  559,  560,  269,
  270,  271,  157,  158,  159,  272,  273,  274,  275,  276,
  277,  278,  279,  280,  281,  282,  283,  171,  284,  584,
  172,  173,  320,  819,  638,  938, 1029,  865,  696,  975,
  936,  939, 1067,  940,  976,  977,  285,  174,  175,  176,
 1079, 1011, 1080, 1081, 1082, 1124, 1083,  177,  178,  179,
  180,  713,  492,  714, 1070,  993, 1071, 1185, 1152, 1186,
  715,  992,  716, 1188, 1120,  181,  182,  183,  184,  185,
  186,  307,  530,  531, 1013, 1126,  316,  991,  875, 1151,
 1020,  914, 1127,  187,  423,  188,  424,  941, 1032,  425,
  426,  654,  645,  646,  945,  427,  428,  429,  430,  431,
  946,  640,  943, 1131, 1207, 1268, 1034, 1163, 1224,  831,
  648,  832, 1098, 1037, 1099, 1164,  950,   17,   19,   46,
   47,  227,  668,  847,  446,  669,  670,
  };
  protected static readonly short [] yySindex = {         -175,
    0, -180, -100,  -38,  249,12550,    0,  124,    0,    0,
  249,  -38,    0,    0,  200,    0, 6884,  249,    0, -171,
 -242,    0,    0,    0,    0,    0,    0,    0,  319,    0,
  397,    0,    0,    0, 3907,    0,    0,    0,    0,    0,
    0,    0,    0,  289,    0,    0,  712,    0,    0,  124,
  367,  249,    0,  374,    0,  214,  401,  244,12032,  -83,
 -255,  420, 7041,    0, -255, -255, -255,  -90, -255, -255,
  720,    0, 8730, -255, -255,    0, 8887,    0,  429,    0,
  244,    0, -255,  458, -255,    0,12594,12594,  491, -255,
 -255, -191,11815,    0,11135,    0,11815,11815,11815,11815,
11815,11815,11815,11815,    0,  258,    0, 8590,    0,  218,
    0,  468,   11,  522,  387,    0,    0,  527,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0, 1299,  685,
   89, -273, -265,  413,  529,  561,  553,  557,  123,  588,
    0,    0,    0,    0,    0,    0, 3608,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,   -8,  617, -261,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,  306,  330,  367,    0,
  403,  344,    0,  577,    0,    0,    0,    0, 8590, 8590,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,  651,  612,    0,  616,    0, -248,    0,    0,
    0,  367,13162,  470,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,  788,  661,11271,    0,    0,    0,
    0,11135, -255, -255,  781,  412,  522,    0,   -8,    0,
    0, 8590,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0, -146,  138,12032,    0, 8590,11135,  740,
    0,    0,  750,11135,11135, 4875,  157, -165,  764, 8747,
    0,11815,  258,    0,  762,    0,  789, 8590,11135,    0,
  826,  442, -255,    0,11135,  429,10591,    0,    0,  458,
11135,  458,  228,  443,  848,   -8,    0,  617,  387,  851,
   -8,11135,11135,11135,  420,    0,  818,    0, 7198,  -50,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
 4491,    0,    0,12505,  228,  804,  827,11135,    0,  791,
    0, -298,    0,    0,  441,    0,    0,  786, 9044,10455,
    0,    0,11815,11135,11135,11135,11135,11135,11135,11135,
11135,11135,11135,11135,11815,11815,11815, 8590, 8590,11815,
11815,11815,11815,11815,11815,11815,11815,11815,11815,11815,
11815,11815,11815,11815,11815,11135,    0,    0,    0,    0,
  617,    0,    0,    0,    0,12594,12594,    0,    0,   -8,
    0,    0,    0,    0,  469,  850,    0,    0,    0,    0,
    0,    0,    0,  367,  470,  792,    0,  795,    0,  791,
  651,  651,    0,   71,    0,  559,  651,  839,    0, -195,
13162,    0,    0,    0,    0, -164,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,  202,13194,
    0,    0,    0,    0,  791,    0,    0,  837,  586,    0,
  842,    0,  847,   59,  429,    0, -255,    0,    0,    0,
   -8,10591, -184,    0,  844,    0,    0,    0, -174,   58,
    0,  423,    0,  858,    0,  853,    0,    0,    0,  607,
    0, 8414,  618,11135,  764,10455,    0, 7669,    0,  458,
    0,    0,    0,  856,   63,    0,    0,  244,  429,  516,
    0, 4332,  859,    0,   65,   -8,    0,   94,    0,    0,
    0,11135,  936,    0,    0,    0,11135,  939,  860,    0,
  863,  865,    0,12505,    0,    0, -182,  -28, 7198,    0,
    0,    0,    0,    0,    0,  429,    0,    0,    6,    0,
    0,    0,  458,  228,   -8, 8904,    0,  864,    0,  870,
11815,    0,  867, 7198,    0, -289,    0,  304,    0,  791,
    0,  -65,11135,11135,  873,  992,    0,    0,  -47,  883,
    0,    0,    0,  685,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
  685,  685,   89,   89, -273, -273, -273, -273, -265, -265,
  413,  529,  561,  553,  557,    0, -149, -181,    0, 9201,
  964,   -8,  965,   -8, 9201, 9201,  879,11135,    0,    0,
  850,    0,   -8,    0,  512,  791,    0,    0,    0,    0,
  240,  367,   16,    0, 8904,  559,    0,  889,  888,    0,
    0,    0,    0,    0,    0,  228,  891,    0,  892,  897,
    0,    0,    0,    0,  893, 9061,  855,    0,  398,    0,
    0,  220,    0,11271,    0,  896,    0,    0,    0,  555,
   90,  908,    0,  907,  911,  912,    0,    0,11135,    0,
   -8,    0,    0,  624,    0,  914,    0,  266,    0,    0,
 7041,    0, 7041, 8573,    0, 4875,    0,    0,10727,  161,
    0,  -12,  -66,    0,  862,  866,    0,  -64,    0,    0,
  910,    0,    0,    0,    0,    0,  919,    0,    0,  928,
    0, 7686,    0,  429,    0,    0,  458,  463,  875,    0,
   39,    0,  925,  930,    0,    0, 7041,    0,    0, 7041,
    0,11135,    0,11135, 8590,    0,    0,  429,  926,  429,
    0,    0,    0,    0,    0,    0,    0,    0, 9201, 8590,
    0,    0,   -8,12505,  961,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,10319,    0,
    0,    0,    0, 7826,    0, 9201,    0, 7983,  931,    0,
    0,    0,    0, 1012,    0, 1014,    0,    0,    0,  652,
    0,  935,    0,    0,    0,    0,    0,    0,  894,    0,
   71,    0,    0,    0,    0,  559,  559,    0,  792,  940,
  943,  900,  948,  855,    0,  944,    0, 1064, 1065,    0,
    0,11135,    0,10863,  950,  555, 8904, 8590,    0,    0,
  180, 1066, 1070,  122,  946,    0,    0,    0,11135,    0,
11135, 1049,    0,    0,    0,    0,   40,10999,    0,    0,
    0,    0, 8119,    0, 1074,    0,  617,11135,  968, 8573,
  970,    0,    0,   -8,    0,  195,    0,    0,  791,  875,
    0,   -8,    0, -161,    0,    0,    0,  967,    0,  997,
    0,    0,    0,    0,    0,    0,    0,  730,    0,    0,
    0,    0,    0, 8747,    0,    0,   -8,  549,  931,    0,
 9201,    0, 9201,    0,  998, 9201,    0,    0,    0,  680,
    0,    0,    0,  980,  792,    0,    0,11407,    0,    0,
    0,  972, 7843,    0,  855,    0,  855,    0,  855,    0,
    0,    0,    0,   -8,  975,  950,    0,    0,    0, -162,
 -156,  978,  979,    0,    0,    0,    0,    0,  981, 8573,
  931, -181,11135,    0,  983, 7041,    0,    0,    0,    0,
    0,    0,  986,    0,  764,    0,    0,    0,    0,    0,
 -189,    0,  987,  791,  875,    0,  875,    0,  931,  988,
    0,    0,  429,    0,  938,  977,    0,    0,    0,    0,
    0, 9201, 1015, 9201, 9201,    0,11135,    0,    0,  897,
  239,  731,    0,    0,    0,    0,  -38,    0,    0,    0,
 1002,    0,    0,    0,  989,    0,    0,    0,  523,    0,
  990, 1116, 1117,    0,    0,  931, 1003,  931, 1005,    0,
 1006,    0,    0,    0,    0,    0,11135,    0, 1013, -154,
    0, -154,    0,    0,    0,    0,    0,    0,  429,    0,
11135, 8278,    0,    0, 1027,    0,  736, 1009,    0, 1016,
    0,    0,11407,  249,   59,    0, 1017, 1017, 1017,10863,
 1018,    0,11135,    0,    0,    0,    0,    0,    0, 7041,
  -80,    0,    0, 7198,    0,  743, 7041,    0, 1019,    0,
 9201,    0,    0,    0,    0,    0,11135,    0,    0,  367,
 1026,  367, 8590, 1045, 1045, 1045,    0,    0,11135,    0,
 7041, 9358,    0,    0,    0, 7198,    0,    0,    0,    0,
    0, 1043, 9201,11135,    0,  367, 1029,    0,  982,    0,
 1028,    0,    0,   38,    0,  985,    0, 1045,    0,    0,
    0,    0,    0,    0,    0, 1032,  914,    0, 7198,    0,
 1051,    0, 1030, 1045,    0, 1033,  367,    0, 8590,  -76,
 1038,    0, 1041, 1044, 7041, 1042, 9201,    0,    0,    0,
    0, 1031, 1030,    0,    0,    0,12111,  120,  367,    0,
    0,    0, 1059, 9201, 1040,11135,    0,    0, 1046,    0,
    0, 1047,    0,    0,13194,  800,    0, 1050,  120,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,  540,13194,    0,    0,    0,    0,    0,    0,    0,
    0,    0, 1054,  367,    0,  120,   -8,    0, 1059,    0,
    0, 1061,12111,12277,    0,    0,    0,   27,    0,    0,
    0,12309,    0,    0, 1055,    0,    0,    0,    0, 8590,
 8590,  309, 8747,  312,  458, 1082,    0,  228, 4646,    0,
 1129,    0,    0, 1030,    0,    0,    0, 1030,    0, 1021,
 1034,    0, 8590, -147,    0, 8590,    0, 1056, 1072,    0,
  228,    0,   62, 5003,    0, 1067, 1057,   24,  511, 3907,
    0,    0, 1030,    0,  228,    0, 1068, 1058, 1073, 1071,
    0, 1075, 1034, 1078,   59, 1080, 1083,    0,    0, 1091,
 1097,    0,  791,    0,  766,    0,    0,    0, 1096,    0,
  -97,    0, 1087,    0,    0, 1103,    0, 1107, 1108, 1110,
    0, 1063,    0,   59,   59,    0,   59, 1106, 1112,    0,
    0,    0,    0, 1109,  127,    0, 1115,   59, 1234, 1118,
   59,    0,   27,    0, 8573, 1079, 1120, 1063,    0, 1119,
 1121,  129, 1128,    0,    0,   59,10863, 1084, 1125, 1109,
    0,    0,13194,    0,  367,  367,    0, 1085, 1130, 1115,
    0, 1132,    0,11135, 1090, 1133, 1118,    0, 1139,   59,
    0,  -74,    0, 1124,    0,    0,    0,    0,    0,13194,
    0,  129,  129, 1145, 1141,    0,  -97,    0,    0,  106,
 1146,13194,    0,13194,    0,    0, 8573, 1134,    0,    0,
    0, 1149, 1103,    0,    0,    0, 1151,    0,  445,    0,
    0,    0, 1045,  794, 1150,    0,    0,    0,    0,    0,
    0,    0,    0, 1206, 1261,    0,    0,    0,    0,    0,
    0, 1155, 1157, 8573,    0,    0,    0,    0,  129,  542,
  542,    0, 1045,    0,    0,    0,  -79,  -79,    0,    0,
    0,    0,    0,    0,    0,10455,10455,    0,    0,    0,
    0,    0, 1161, 1158, 1159,    0,    0,    0,
  };
  protected static readonly short [] yyRindex = {         1916,
    0,    0, 7355, 1916,    0,    0,    0, 1532,    0,    0,
 3243, 1827,    0,    0,    0,    0,    0, 3243,    0,    0,
   55,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0, 1533,    0,    0, 1533,    0,    0, 1532,
 3286, 3157,    0,    0,    0,    0,    0,    0,    0,    0,
    0, 1167,    0,    0,    0,    0,    0,    0,    0,    0,
 9218,    0, 1160,    0,    0,    0, 1160,    0,    0,    0,
    0,    0,    0, -280,    0,    0,    0,    0,    0,    0,
    0,    0,  234,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0, 4714,    0,    0,    0,    0,
    0,    0,  182, 4873, 4084,    0,    0, 4649,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0, 5029, 5097,
 5441, 5645, 5985, 6189, 6325, 6461, 6597, 1264, 1413, 2967,
    0,    0,    0,    0,    0,    0,   55,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,  207,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0, 3329,    0,
  599,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0, 1533,  136,    0,    0,    0,    0,    0,    0,
    0, 3372,  355, 3415,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0, 3695,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0, 1172,    0,    0,    0,    0,
    0,    0, 3695,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0, 2517,
    0, 3027,  119, 2647,    0,    0,    0, 2777, 2647,    0,
    0,    0,    0,    0, 1167,    0,    0,    0,   51,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0, 1163, 2881,    0,    0, 1160,    0, 3695,
    0,    0,    0,    0,    0,    0,    0,    0,    0,  -41,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
 1656,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0, 3975,    0,    0,    0,    0,
    0,    0,    0, 3482, 3529,    0,    0,    0,    0, 2371,
 1533, 1533,    0, -132,    0, 8000, 1533, 1541,    0,    0,
  197,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,  417,11964,
    0,    0,    0,    0, 3695,    0,    0,    0,    0,    0,
    0,    0,    0,12353,    0,    0,    0,    0,    0,    0,
    0,  637,    0,    0,    0,    0,    0,    0,    0,    0,
    0,  591,  973,    0,    0, 1176,    0,    0,    0,    0,
    0,  140,    0,    0, 4172, 1173,    0,    0,    0,  407,
    0,    0,    0,    0,    0,    0,    0,    0,    0, 2078,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0, 1163,    0,    0, 6724,    0,  145,    0,
    0,    0,    0,    0,    0, 9515,    0,    0,    0,    0,
    0,    0, -158,  380,    0,    0,    0, 1174,    0,    0,
    0,    0,    0,    0,    0, 3695,    0, 3695,    0, 4331,
    0,    0,    0,    0, -284,    0,    0,    0,    0,  130,
    0,    0,    0, 5201,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
 5269, 5373, 5509, 5577, 5713, 5781, 5849, 5917, 6053, 6121,
 6257, 6393, 6529, 6665, 1918,    0,    0,  563,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
 3975,    0,    0,    0,    0, 2371,    0,    0,    0,    0,
 1131, 9719,    0,    0,    0, 9375,    0,    0,  737,    0,
    0,    0,    0,    0,    0,  693, -247,    0,    0, 1177,
    0,    0,    0,    0, 1181,    0,    0,    0,    0,    0,
    0,11543,    0,    0,    0,  741,    0,    0,    0,12618,
12429,    0,    0,  752,  757,  768,    0,    0,    0,    0,
    0,    0,    0,    0,    0,  640,    0,    0,    0,    0,
    0,    0,    0,    0,    0, 1183,    0,    0,    0, 3761,
    0,    0,  151,    0,   57, 3854,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0, 1184,    0,    0,    0,
    0,    0,    0,    0,    0,    0,  236,  709,    0,    0,
    0,    0,    0, 1182,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0, 9515,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,  606,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0, -186,
    0,  504,    0,    0,    0,    0,    0,    0,    0,    0,
 -132,    0,    0,    0,    0,12618, 8295,    0, 1185,    0,
  666,    0,    0,    0,    0, 1189,    0, 1140, 1142,    0,
    0,    0,    0,    0, 1186,12672,    0,    0,    0,    0,
12461,    0,    0,    0,  769,    0,    0,    0,    0,    0,
    0, 2245,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0, 4013,    0, 4490, 1191,
    0,    0,    0, 1192,    0,    0,    0,    0,  318,    0,
    0,    0,    0,  769,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,  579,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,  778,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0, 1193,    0,    0,    0,    0,
    0,  784,  785,    0,    0,    0,    0,    0,    0,    0,
 1195,  649, 1194,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0, 4172,    0,    0,    0,    0,    0,
 1197,    0,    0,  318,    0,    0,  816,    0, 1195,    0,
    0,    0, 9515,    0,  572,  595,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0, 1177,
 9565,    0,    0,    0,    0,    0,12714,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,  665,    0,
  678,    0,    0,    0,    0, 1199,    0,  671, 1198,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0, 1212,
    0, 7512,    0,    0,    0,    0,    0,    0, 9515,    0,
    0,    0,    0,    0,    0,    0,  294,  550,    0,    0,
    0,    0,    0,12790,12353,    0,  371,  371,  371,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,12895,
    0, -271,    0, 1214, 1214, 1214,    0,    0,    0,    0,
    0, 1210,    0,    0,    0, -157,    0,    0,    0,    0,
    0,    0,    0,    0,    0,12938,    0,    0,    0,    0,
 1217,    0,    0,  375,    0,    0,    0,  544,    0,    0,
    0,    0,    0,    0,    0,    0, 1216,    0, 1218,    0,
    0,    0, 3200, 1213,  414,    0,  -14,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0, 1553,    0,    0,    0,    0, 9824,10022,    0,
    0,    0,  641,    0,    0,    0,    0,    0,    0,    0,
    0,  534,    0,    0,12135,10116,    0,    0, 9923,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,12203,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,10202,    0, 9824,    0,    0,  641,    0,
    0,    0,    0,  417,    0,    0,    0,    0,    0,    0,
    0,  417,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,  744,  433,    0,10244,    0,    0,
    0, 1148,    0, 1553,    0,    0,    0, 1553,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
  190,    0, 1224,    0,    0,    0,    0,    0,    0,    0,
    0,    0, 1553,    0,  763,    0,  623,    0,    0,    0,
    0,    0,    0,    0,12353,  790,    0,    0,    0,    0,
    0,    0, 1188,    0,  221,    0,    0,    0,    0,    0,
    0,    0,  798,    0,    0,    0,    0,    0,    0,    0,
    0, 1219,    0,12353,12353,    0,12385,    0,    0,    0,
    0,    0,    0, 1220,13132,    0, 1221,12353,11679, 1222,
12353,    0,    0,    0,    0,    0,    0, 1229,    0,    0,
    0, 1266,    0,    0,    0,12353,    0,    0,    0, 1230,
    0,    0,  232,    0,13056,13094,    0,    0,    0, 1231,
    0,    0,    0,    0,    0,    0, 1245,    0,    0,12353,
    0,  554,    0,  803,    0,    0,    0,    0,    0,  828,
    0,12980,13018,    0,    0,    0,    0,    0,    0,    0,
    0, 1277,    0, 1330,    0,    0,    0,  811,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,  556,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0, 1266,11851,
12832,    0,  556,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0, 1173, 1173,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,
  };
  protected static readonly short [] yyGindex = {            0,
    0, 1544,    0,    0,    0,   -2,   -9, -179,  -48,  -43,
    0, 1588, 1617,  589,    0,    3,    0,    0,    0,    0,
    0,-1109, -711, -213, -432,    0,    0,    0,    0,    0,
 -228,    0,    0,    0,  668,    0,  775,    0,    0,    0,
    0,  524,  530,  -17, -236,    0,  -46,    0,  359,    0,
  396,-1114, -607, -598, -534, -519, -516, -513, -500,    0,
    0,-1173,    0,    1,    0,   86,    0,-1098,    0,    0,
    0,  -44,  179,    0,    0,    0,  227,-1059,    0, -272,
 -279,  955,    0,    0,    0, -894,  181,    0,    0, -505,
    0,    0,  245,    0,    0,  215,    0,    0,  252,    0,
 -721, -968,    0,    0,    0,    0,    0,  349,  -13,    0,
    0,  779,  780,  782,  949, -537,    0,    0, -323,  796,
  341,    0,-1330,    0,    0,    0,    0,    0,    0,    0,
    0,  149,    0,    0,    0,    0,    0,    0,    0,    0,
  394,    0,    0,    0,    0, -339,  331,    0,    0,    0,
    0,    0,    0,    0,    0,    0,  408,    0, -515,    0,
    0,    0,    0,    0,    0,    0,    0,    0,  165,    0,
    0,  248,    0,    0,  254,  256,  172,    0,    0,    0,
    0,    0,    0,    0,    0,  477,    0,    0,    0,    0,
  -42,    0,  373, -138,    0,    0,  320,    0,  377,    0,
  838,    0, 1153, -295, -263,  -63, 1025,    0,  479,    0,
  -33,  112,    0,    0, 1152,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0, -262,    0, 1209,    0,    0, -130,    0,    0,    0,
  799,    0, -302, -129,  952,  874,    0,  868,    0, 1093,
 1319, 1000,    0,    0,  686, 1624,    0,    0,    0,    0,
 1008,    0,    0,    0,    0,    0, -599, 1363,    0,    0,
    0,    0,    0, 1327,  343,  806,  704,  802, 1315, 1298,
 1333, 1335, 1332,    0, 1334,    0, -608,    0,    0,  947,
 1190, -747,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0, -294,    0,    0,    0,    0, -454,    0,  562,
    0,  472,    0,  558,    0,    0,    0,  619, -530,   -5,
 -314,   -3,    0, 1585,    0,   46,    0,   82,   84,   85,
   91,  117,  118,  125,  126,  132,  134,    0, -664,    0,
  -27,    0,    0,  758,    0,  681,    0,    0,    0,    0,
  659, -145,  734, -870,    0,  797, -468,    0,    0,    0,
    0,    0,    0,  674,    0,    0,  673,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,  604,    0,    0,    0,    0,    0,    0,    0,
    0,  -19,    0, 1228,    0,    0,    0,  857,    0,    0,
    0,    0,    0,    0, -170,    0,    0,    0,    0,    0,
 1345, 1123,    0,    0,    0, 1347,    0,    0,    0,    0,
    0,    0,    0,    0,    0,  506,    0,    0,    0,    0,
    0,    0,    0,    0,  614,    0,    0,    0,    0,    0,
    0,    2,  929,    0,    0,    0,  933,
  };
  protected static readonly short [] yyTable = {           109,
  741,   18,  233,  111,  522,  473,   43,  234,  189,  434,
  477,  155,  746,  156,  577,  690,  495,  433,  452,  519,
  319,  293,  192,  712,  562,  257,  538,  407,  785,  549,
  576,  259,  921,  503,  515,  901,  827,  828,  793, 1025,
  325,  330,  326,  331,  251,  337, 1180, 1181,  229,  364,
 1147,  372,  437,  798,  955,  304,  882,  311,  883,  304,
  673, 1274,  160,  356,  544,  312, 1076,  314, 1030,  939,
  363,  717,  371,  781,  817,   14,  448,  340, 1077, 1282,
    1,  720,  739, 1210,  190,  335,  674,  627,  739,  627,
  511,  683,   20, 1058, 1018, 1211,  316,  364,  161, 1060,
  162,  163,  913, 1227, 1255,  915,  815,  164, 1340,  486,
  795, 1476, 1477, 1077,  412,  249,  394,  395,  675,  586,
  392,  393,   64,   64,  351,  409,   64,  843,  115,  587,
  396,  397,  477,  165,  166,  350, 1141,  739,  799,  109,
  233,  167,  168,  111,  627,  435,   47,  639,  169, 1255,
  170,  155,  939,  156,  441,  442,   16,  939, 1382,  939,
  349,   47,  939,  939,  250,  939,  939,  413, 1509,   42,
  115,  291,  260,   47,  115, 1154, 1518,  289,  291, 1216,
  922, 1468,    2,  451,  437,  290,  196,  939,  435,  892,
  804,  896,  760,  487, 1331, 1030,    6,  721, 1332,  818,
  478,  512,  160,  513,  364,  249,  473,  932,  350,  735,
  795,  364,  482,  364,  577,  364,  437,  483,  884,  990,
  452,  585,  676, 1360,  443,  816,  292,  336,  449,  476,
  576,  351, 1078,  292,  481,  739,  577,   15,  161, 1450,
  162,  163,  939,  493,  562,  352,  191,  164,    3,    4,
    5,    6,  257,  684,  250, 1059,  537,  514,  491,  364,
  541, 1061,  257,  524,  795,  546, 1474, 1078,  115,  562,
 1341,  494,  291,  165,  166, 1090,  498,  500, 1484,  543,
 1485,  167,  168, 1383,  548,   47,  545,   94,  169,  536,
  170,  525,  261, 1198, 1155,  896, 1519,  533, 1217,  535,
 1469,  657,  534,  498,  805,  897,  568,  893,  694,  898,
 1016,  955,  955,  722,  698,  551,  552, 1348,  749,    2,
  766,  564,  478,  478,  811,  577,  660,  292, 1100,  980,
  450, 1073, 1031,  561, 1033,  563,  691, 1036,  583,  782,
  304, 1128,  844,  619,  620,  869,  760, 1446, 1354,  769,
  388,  476,  597,  318,  291,  889,  605,  606,  607,  608,
  609,  610,  611,  612,  613,  614,  615,  361, 1481,  641,
  643,  642,  644,  647, 1495, 1234, 1370,  988,  565,  790,
   48,  812, 1412,  362, 1439,  233,  389,  450,  637,  841,
  435,  350,  194,   94, 1009,  661,  318,  115, 1314,  699,
  783,  291, 1305,   47, 1515, 1400, 1401,  997, 1403,  292,
  994, 1199,  743,  898,  874, 1085,  890, 1086,  685, 1422,
 1482,  791, 1429, 1093,  955, 1095, 1096,  231,  115,  723,
  955,  842, 1349,  473,  750,  437,  767, 1445,  655,  231,
  701, 1355,  658,  659,  710,  340,  718,  800,  671,  802,
  115,  803,  677,    6,  577, 1153,  909,  477,  231,  194,
  194, 1467, 1160,  503,  711,  770,  390,  391,  640,  478,
  576,  708,  473,  640,  350,  335,  350,  640,  686,  685,
  194,  335,  687,  357, 1065,  759, 1183,  335,  231,  768,
  335,  335,  640,  989,  640,  231,  737,  231,  597,  744,
  744,  451,  350,  349,  335,  488,  350,  438,  350,  350,
  350,  350,  686,  489,  751,  753,  350,  836,  439,  640,
  982,  880, 1162,  404,  771,  860,  508,  577,  792,  773,
  509,  358,  861,  837,  758,  405,  335,  437,  640,  743,
 1221,  888,  978,  688,  328,  838,  640,  744,  231,  942,
  328,  350,  786,  561, 1191,  563,  340,  291,  451,  881,
  340,  414,  335,  115, 1312,  115,  490, 1315,  438,  732,
  115,  194,  194,  686,  351,  806,  806,  930,  561,  439,
  563,  349,  245,   20,  973,  414,  246,  350,  352, 1336,
  735,  350,  359,  335,  350,  824,  350,  826, 1223,  328,
  349,  350, 1350,  115,  340,  894,  834,  357,  744,  197,
   94, 1256, 1014, 1313,  249, 1269, 1316,   54,  350, 1101,
 1257, 1368,  821,  199,  732,  785,  640,  821,  821,  350,
  830,  640,  942, 1004,  194,  640,  247,  942,  522,  942,
  197,  351,  942,  942,  415,  942,  942,  478,  350,  416,
  640,  417,  351,  357,  418,  419, 1256,  420,  421,  225,
  194,  226,  362,  250,  876, 1257,  352,  942,  415,  857,
  115,  351,  194,  416,  335,  417,  476,  640,  418,  419,
  194,  420,  421,  712, 1258,  352,  335,  856,  638,  335,
  335,  498,  257,  858,  541,  115,  640,  527, 1069, 1259,
 1491,  200, 1260,  335,  639, 1261,  744,  904, 1492,  659,
  528,  737,  638,  660,  910,  604,  438,  351, 1262,  439,
  859, 1046,  942,  194,  649,  739,  194,  529,  639, 1258,
  918,  801,  621,  622,  422,  231,  335,  659,  743,  638,
  905,  660,  335,  361, 1259,  923,  924, 1260,  335,  244,
 1261,  603,  335,  603,  916,  639,  917,  999,  432,  933,
  194,  194,  478, 1262,  919,  335,  786,  478, 1008, 1493,
  657,  821,  318,  362,  362,  362,  248,  362,  362, 1038,
  362,  321,  362,  436,  528, 1237, 1254,  321,  194,  194,
  263,  597,  661,  350,  322,   94,  597,  335,  821,  361,
  744,  754,  350,  724, 1121,  935, 1237,  415,  194,  562,
  398,  399,  416,  350,  417,  438,  351,  418,  419,  361,
  420,  421,  194,  981,  362,  351,  362,  701,  318,  362,
  973, 1254,  115, 1237,  115,  906,  351,  472,  231,  352,
 1150,  562,  933,  318,  970, 1066,  494,  933,  318,  933,
  352,  677,  933,  933,  962,  933,  933, 1012,  588, 1015,
  570,  332,  866,  995,  570, 1017, 1046,  571,  589,  690,
  998,  571,  666, 1066,  562,  836, 1182,   94,  115,  572,
 1006,  115,  744,  572,  438,  360, 1356,  835,  935, 1433,
 1026, 1111,  249,  935,  365,  935,  929,  650,  935,  935,
  666,  935,  935, 1112,  761,  373, 1157, 1158,   94,  666,
  663,  478,  400,  366,  367, 1279, 1027, 1209, 1050,  663,
  270,  270,  662,  821, 1028,  821,  194, 1055,  821,  270,
  751,  662,  933,  368, 1302,  414,  751,  402,  751,  772,
 1045,  250, 1302,  772,  369,  772,  756,  772,  194,  401,
  756, 1486,  452, 1271,  756,  693,  403,  677,  498,  694,
 1166,  335,  761,  335,  498, 1052,  761, 1053,  761, 1054,
  761,  335,  744,  755,  335,  498,  727,  406,  935,  929,
  728,  755,  335,  335,  929,  297,  929,  736, 1506,  929,
  929,  509,  929,  929,  440,  877,  280,  522,  280,  878,
 1524, 1525,  335,  280,  357,  947,  948,  473,  820,  786,
  335,  824,  820,  335,  821,  824,  821,  821,  415, 1097,
  751,  225,  751,  416,  751,  417,  444,  357,  418,  419,
   44,  420,  421,  447,  168,   65,  168,  194,  168,   65,
  357,  113,  755,  474, 1104,  357,  755,  181,  232,  181,
  357,  181,  357,  357,  357,  357,  478,  335,  194,  494,
  357,  701,  335,  335,  357,  335,  335,   56,  357,  929,
  385,  386,  387, 1129,  744,  786,  357,  328,  475,  357,
  328,  357,  225,  113,  228, 1045,  296,  113,  297, 1133,
 1134,  233,  494, 1169, 1140,  494,  435,  625,  626,  627,
  628, 1024, 1102,  814, 1103,  357,  975,  115,  975, 1157,
 1158,  329,  329,  821,  763,  496,  763,  233,  561, 1165,
  563,  156,  435,  156,  194,  497,  163,  973,  163,  340,
  518,  494,  329,  340,  362,  335,  340,  164,  340,  164,
  886,  542,  886,  340,  547,  821, 1097,  194, 1169,   67,
  561,   67,  563,  187,  157,  187,  157, 1496, 1497,  437,
  555,  357,  194,  120,  523,  120,  194, 1275,  231, 1235,
 1253,  285, 1231,  285, 1236,  581,  127,  340,  127,  351,
  444,  113, 1347,  561,  292,  563,  292,  522,  522,  821,
 1235,  640,  640, 1145, 1146, 1236, 1347,  623,  624,  629,
  630,  526,  582,  590,  351,  653,  821,  672,  494,  355,
  258,  692,  656,  695, 1378, 1253, 1379, 1235,  697,  719,
 1286,  194, 1236,  329,  329,  725,  726,  748, 1231,  772,
  765,  115,  774,  775,  776,  115,  777,  794,  115,  194,
  194,  795,  797,  809,  258, 1310, 1311,  810,  258,  258,
  258,  258,  258,  258,  258,  258,  814,  823,  825,  829,
  845,  846,  115,  438, 1307,  852,  848,  115, 1339,  262,
  849, 1342,   42,  286,  287,  288,  864,  294,  295,  870,
  871,  899,  308,  309,  872,  873,  329,  879,  895,  315,
  196,  317,  900,  321,  902,  907,  911,  920,  333,  334,
  115,  701,  912,  926,  937,  942,  194,  944,  949,  957,
  113,  951,  329,  958,  961, 1357,  115,  960,  963,  966,
  968,  986,  370,  974,  329,  987,  990,  194,  996, 1003,
  701,  701,  329,  701,  512,  194, 1413, 1010, 1021, 1022,
  499,  113, 1048,  413,  701,  413,  499,  701, 1035, 1039,
 1056, 1062, 1063, 1440, 1072, 1074, 1064, 1092, 1084, 1088,
 1091, 1094,  701,  113,  413,  413, 1452, 1454, 1106, 1110,
 1113, 1114, 1115, 1132, 1116,  329, 1118,  744,  329, 1307,
 1122, 1119, 1135, 1176,  413, 1136,  701, 1148, 1161,  494,
 1190, 1143,  413, 1440, 1440,  413, 1193, 1168, 1208, 1195,
 1213, 1197, 1200, 1205, 1218, 1209, 1462, 1219,  356, 1222,
 1220, 1226,  329,  329, 1267, 1270, 1272, 1276, 1317,  338,
 1273, 1283, 1309,  341,  342,  343,  344,  345,  346,  347,
  348,  356, 1288, 1330, 1362, 1352, 1396,  258, 1334,  744,
  329,  329, 1345, 1364,  356, 1367, 1365,  258, 1369,  356,
 1440, 1335,  231,  258,  356, 1373,  356,  356,  356,  356,
 1371, 1375,  315, 1376,  356,  370, 1381, 1386,  356,  478,
  478, 1389,  356, 1344, 1353, 1355,  744, 1392, 1404, 1393,
  356, 1394, 1408,  356, 1405,  356, 1511, 1511, 1418, 1423,
 1437, 1425, 1438, 1520, 1520, 1435, 1434, 1444,  597,  597,
 1448, 1447, 1458, 1461, 1472, 1459,  516, 1463, 1464,  356,
 1466, 1478, 1479, 1483, 1487,  194,  113, 1498, 1488,  581,
 1482,  532, 1490, 1481,  258, 1504,   47, 1505, 1526, 1527,
 1528,    9,  971,  535,  604,  856,  258,  258,  258,  493,
  963,  258,  258,  494,  450,  605,   29,   21,  674,   47,
  492,   29,   27,  518,   30,  313,  329,  208,   30,   96,
  335,  765,   47,  864,  789,  356,  757,   47,  766,  825,
  758,  194,   47,  826,   47,   47,   47,   47,  329,  790,
  662,  827,   47,  113,  317,  685,   47,  829,  662,  194,
  342,  640,  640,  230,  123,  105,  288,  130,   47,   53,
  329,   47,  581,   47,  124,  106,  289,  581,  113,  581,
  581,  581,  581,  581,  581,  581,  581,  581,  581,  581,
  131,   21, 1040,  956, 1285, 1480, 1138,   47,  338,   47,
   47,  581, 1139,  581, 1277,  581, 1449,  581,  581,  581,
  854, 1465, 1436, 1489, 1431,  194,  194, 1324,  867,  983,
  984, 1337,  985,  581,  194,  503, 1522, 1284,  550, 1281,
 1359,  979,  194,  194,  581,  194, 1514, 1460,  583, 1455,
 1453, 1327, 1513, 1214, 1380, 1328,  581, 1215,  952,  374,
  887,  931,  928, 1327,  762,  194,  808,  592,  194,  329,
 1075, 1002,  581,  863,  299,  709, 1327,  553,  632,  550,
  375,  376,  377,  378,  379,  380,  381,  382,  383,  384,
  329,  616,  617,  618,  631, 1327,  550,  550,  550,  550,
  550,  550,  550,  550,  550,  550,  550,  550,  550,  550,
  550,  550,  258,  885,  633,  635,  752,  634,  636, 1202,
  925,  408, 1156,  779, 1289,  113, 1206,  113, 1117, 1068,
 1130,  583, 1087, 1123, 1125, 1187,  583,  755,  583,  583,
  583,  583,  583,  583,  583,  583,  583,  583,  583,  651,
 1019,  652, 1057,  833, 1287,  954,  329, 1192,  953,    0,
  583,    0,  583,    0,  583,    0,  583,  583,  583,    0,
    0,  113,    0,    0,  113,    0,    0,    0,    0,  329,
    0,    0,  583,    0,    0,    0,    0,    0,   27,   27,
    0,    0,    0,   27,  329,    0,    0,   27,  329,   27,
    0,    0,   27,    0,   27,   27,   34,   27,    0,   27,
    0,   27,    0,   27,   27,   27,   27,    0,  550,   27,
   27,  583,    0,    0,    0,   27,    0,   27,   27,   27,
    0,    0,   27,   27,   27,    0,   27,    0,    0,   27,
    0,   27,   27,   27,   27,    0,    0,    0,   27,   27,
   27,    0,    0,   27,   27,   27,    0,  258,    0,    0,
    0,    0,   27,   27,    0,   27,   27,    0,   27,   27,
   27,  329,  329,    0,   27,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,  796,    0,    0,
    0,  503,    0,    0,   27,   33,  503,  503,    0,    0,
   27,   27,    0,    0,    0,    0,    0,    0,    0,   27,
    0,    0,    0,    0,    0,    0,    0,    0,    0,  503,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,  503,  503,    0,    0,    0,  503,  329,    0,
  503,    0,  503,    0,  503,  503,  503,  503,    0,    0,
   27,    0,  503,    0,    0,    0,  503,    0,    0,    0,
  503,    0,    0,    0,    0,    0,    0,  329,  503,    0,
    0,  503,    0,  503,  503,    0,    0,    0,    0,  503,
    0,  503,  503,  503,  503,  503,  503,  503,  503,  503,
  503,  503,    0,    0,    0,    0,    0,  503,  503,    0,
  113,    0,  503,  503,    0,  503,  503,  503,  503,  503,
  503,  503,    0,  503,  503,    0,  503,  503,  503,  503,
  503,  503,  503,  503,  503,  503,    0,  503,  503,  503,
  503,  503,  503,  503,  503,  503,  503,  503,  503,  503,
  503,  503,  503,  503,  503,  503,  503,  503,  503,    0,
    0,  503,    0,  503,    0,  503,    0,  858,  503,    0,
    0,    0,    0,   34,  503,    0,    0,   34,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,   34,    0,
    0,    0,    0,   34,    0,    0,    0,   34,    0,    0,
   34,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,   34,   34,    0,    0,    0,   34,   34,    0,
    0,    0,    0,   34,    0,   34,   34,   34,   34,    0,
    0,    0,    0,   34,  113,    0,    0,   34,  113,   34,
    0,  113,    0,    0,    0,    0,    0,    0,    0,   34,
    0,   34,   34,    0,   34,    0,    0,  329,   34,    0,
    0,    0,   33,  582,    0,  113,   33,    0,    0,    0,
  113,    0,    0,    0,    0,    0,    0,   33,   34,    0,
    0,    0,   33,    0,   34,   34,   33,    0,    0,   33,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,   33,   33,  113,    0,    0,   33,   33,    0,  550,
    0,    0,   33,  329,   33,   33,   33,   33,    0,  113,
    0,    0,   33,    0,    0,    0,   33,    0,   33,    0,
    0,  329,    0,    0,  783,    0,    0,    0,   33,    0,
   33,   33,    0,   33,    0,    0,  582,   33,    0,    0,
    0,  582,    0,  582,  582,  582,  582,  582,  582,  582,
  582,  582,  582,  582,    0,    0,    0,   33,    0,    0,
    0,    0,    0,    0,   33,  582,    0,  582,    0,  582,
    0,  582,  582,  582,    0,    0,    0,  329,  329,    0,
    0,    0,    0,    0,    0,    0,  329,  582,    0,    0,
    0,    0,    0,    0,  329,  329,    0,  329,  582,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
  582,    0,    0,  858,  858,    0,    0,  329,    0,    0,
  329,  858,  858,  858,  858,  858,  582,  858,  858,    0,
  858,  858,  858,  858,  858,  858,  858,  858,    0,    0,
    0,    0,  858,    0,  858,  858,  858,  858,  858,  858,
  335,    0,  858,    0,    0,    0,  858,  858,    0,  858,
  858,  858,    0,    0,    0,    0,    0,    0,    0,    0,
    0,  858,    0,  858,    0,  858,  858,    0,    0,  858,
    0,  858,  858,  858,  858,  858,  858,  858,  858,  858,
  858,  858,  858,    0,  858,    0,    0,  858,  858,    0,
    0,  858,  858,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,  858,  858,  858,  858,
  858,    0,    0,    0,  858,  858,    0,    0,  858,    0,
    0,    0,    0,  858,  858,  858,  858,  858,    0,    0,
    0,  858,    0,  858,    0,    0,    0,    0,    0,  858,
  858,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,  858,  858,  858,  858,    0,  858,
  783,  783,    0,    0,    0,    0,  858,    0,  783,  783,
  783,  783,  783,    0,  783,  783,  740,  783,  783,  783,
  783,  783,  783,  783,    0,    0,    0,    0,    0,  783,
    0,  783,  783,  783,  783,  783,  783,    0,    0,  783,
    0,    0,    0,  783,  783,    0,  783,  783,  783,    0,
    0,    0,    0,    0,    0,    0,    0,    0,  783,    0,
  783,    0,  783,  783,    0,    0,  783,    0,  783,  783,
  783,  783,  783,  783,  783,  783,  783,  783,  783,  783,
    0,  783,    0,    0,  783,  783,    0,    0,  783,  783,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,  783,  783,  783,  783,  783,    0,    0,
    0,  783,  783,    0,    0,  783,    0,    0,    0,    0,
  783,  783,  783,  783,  783,    0,  335,    0,  783,    0,
  783,  335,  335,    0,    0,    0,  783,  783,    0,    0,
    0,    0,    0,    0,    0,    0,  328,    0,    0,    0,
    0,    0,    0,    0,  335,    0,    0,    0,    0,    0,
    0,  783,  783,  783,  783,    0,  783,  335,  335,    0,
    0,    0,  335,  783,    0,  335,    0,  335,    0,  335,
  335,  335,  335,    0,    0,    0,    0,  335,    0,    0,
    0,  335,    0,    0,    0,  335,    0,    0,    0,    0,
    0,    0,    0,  335,    0,    0,  335,    0,  335,  335,
    0,    0,    0,    0,  335,    0,  335,  335,  335,  335,
  335,  335,  335,  335,  335,  335,  335,  335,    0,    0,
    0,    0,  335,  335,    0,    0,    0,  335,  335,  335,
  335,  335,  335,  335,  335,  335,  335,    0,  335,  335,
    0,    0,  335,  335,  335,  335,  335,    0,    0,  335,
  335,    0,    0,    0,  335,  335,  335,  335,  335,  335,
  335,  335,  740,    0,    0,    0,  365,  740,  740,    0,
    0,    0,    0,  335,    0,    0,  335,    0,  335,    0,
  335,    0,    0,  335,    0,    0,    0,    0,    0,  335,
  740,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,  740,  740,    0,    0,    0,  740,    0,
    0,  740,    0,  740,    0,  740,  740,  740,  740,    0,
    0,    0,    0,  740,    0,    0,    0,  740,    0,    0,
    0,  740,    0,    0,    0,    0,    0,    0,    0,  740,
    0,    0,  740,    0,  740,  740,    0,    0,    0,    0,
  740,    0,  740,  740,  740,  740,  740,  740,  740,  740,
  740,  740,  740,    0,    0,    0,    0,    0,  740,  740,
  335,    0,    0,  740,  740,  740,  740,  740,  740,    0,
  740,  740,  740,    0,  740,  740,    0,    0,  740,  740,
  740,  740,  328,    0,    0,  740,  740,  328,  328,    0,
  740,  740,  740,  740,  740,  740,  740,  740,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,  740,
  328,    0,  740,    0,  740,    0,  740,    0,    0,  740,
    0,    0,    0,  328,  328,  740,    0,    0,  328,    0,
    0,  328,    0,  328,    0,  328,  328,  328,  328,    0,
    0,    0,    0,  328,    0,    0,    0,  328,    0,    0,
    0,  328,    0,    0,    0,    0,    0,    0,    0,  328,
    0,    0,  328,    0,  328,  328,    0,    0,    0,    0,
  328,    0,  328,  328,  328,  328,  328,  328,  328,  328,
  328,  328,  328,    0,    0,    0,    0,    0,  328,  328,
    0,    0,    0,  328,  328,  328,  328,  328,  328,    0,
  328,  328,  328,    0,  328,  328,  360,    0,  328,  328,
  328,  328,  365,    0,    0,  328,  328,  365,  365,    0,
  328,  328,  328,  328,  328,  328,  328,  328,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,  328,
  365,    0,  328,    0,  328,    0,  328,    0,    0,  328,
    0,    0,    0,  365,  365,  328,    0,    0,  365,    0,
    0,  365,    0,  365,    0,  365,  365,  365,  365,    0,
    0,    0,    0,  365,    0,    0,    0,  365,    0,    0,
    0,  365,    0,    0,    0,    0,    0,    0,    0,  365,
    0,    0,  365,    0,  365,  365,    0,    0,    0,    0,
  365,    0,  365,  365,  365,  365,  365,  365,  365,  365,
  365,  365,  365,    0,    0,    0,  335,    0,  365,  365,
    0,    0,  335,  365,  365,    0,  365,  365,  365,    0,
  365,  365,  365,    0,  365,  365,   32,    0,  365,  365,
  365,  365,    0,    0,    0,  365,  365,    0,    0,    0,
  365,  365,  365,  365,  365,  365,  365,  365,  335,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,  365,
    0,    0,  365,    0,  365,    0,    0,    0,    0,   27,
    0,    0,    0,    0,    0,  365,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,  335,
    0,    0,  585,    0,  335,    0,  335,  335,  335,  335,
  335,  335,  335,  335,  335,  335,  335,  335,    0,    0,
    0,    0,   31,  335,    0,    0,    0,  335,  335,  335,
  335,  335,  335,  335,  335,  335,  335,    0,  335,  335,
    0,    0,  335,  335,  335,  335,  335,    0,    0,  335,
  335,    0,    0,    0,  335,  335,  335,  335,  335,  335,
  335,  335,  360,    0,    0,    5,    0,    0,  360,    0,
    0,    0,    0,  335,    0,    0,  335,    0,  335,    0,
  335,    0,    0,  335,    0,  585,    0,    0,    0,  335,
  585,    0,  585,  585,  585,  585,  585,  585,  585,  585,
  585,  585,  585,    0,  360,    0,    0,    0,  953,    0,
    0,    0,    0,    0,  585,    0,  585,    0,  585,    0,
  585,  585,  585,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,  360,    0,    0,    0,    0,
  360,   47,  360,  360,  360,  360,  360,  360,  360,  360,
  360,  360,  360,    0,    0,    0,    0,    0,    0,  360,
    0,    0,    0,  360,  360,  585,  360,  360,  360,    0,
  360,  360,  360,    0,  360,  360,    0,    0,  360,  360,
  360,  360,    0,   32,    7,  360,  360,   32,    0,    0,
  360,  360,  360,  360,  360,  360,  360,  360,   32,    0,
    0,    0,    0,   32,    0,    0,    0,   32,    0,  360,
   32,    0,  360,    0,  360,    0,    0,    0,    0,    0,
    0,    0,   32,   32,    0,  360,   27,   32,   32,    0,
   27,    0,    0,   32,    0,   32,   32,   32,   32,    0,
    0,   27,    0,   32,    0,    0,   27,   32,    0,   32,
   27,  954,    0,   27,    0,    0,    0,    0,    0,   32,
    0,    0,   32,    0,   32,   27,   27,    0,   32,   31,
   27,   27,    0,   31,    0,    0,   27,    0,   27,   27,
   27,   27,    0,    0,   31,    0,   27,    0,   32,   31,
   27,    0,   27,   31,   32,   32,   31,    0,   48,    0,
    0,    0,   27,    0,    0,   27,    0,   27,   31,   31,
    0,   27,    5,   31,   31,    0,   47,    0,    0,   31,
    0,   31,   31,   31,   31,    0,    0,   47,    0,   31,
    0,   27,   47,   31,    0,   31,   47,   27,   27,   47,
    0,    0,    0,    0,    0,   31,    0,    0,   31,    0,
   31,   47,   47,    0,   31,  953,   47,   47,    0,   47,
    0,    0,   47,    0,   47,   47,   47,   47,    0,    0,
   47,    0,   47,    0,   31,   47,   47,    0,   47,   47,
    0,   31,   47,    0,    0,    0,    0,    0,   47,    0,
    0,   47,    0,   47,   47,   47,    0,   47,   47,   47,
   47,    0,   47,    0,    0,   47,    0,   47,   47,   47,
   47,    0,    0,   47,    0,   47,    0,   47,   47,   47,
    0,   47,   47,    0,    0,   47,    0,    0,    0,    0,
    0,   47,    0,    0,   47,    0,   47,   47,   47,    0,
   47,    7,   47,   47,    0,   48,    0,    0,   47,    0,
   47,   47,   47,   47,    0,    0,   48,    0,   47,    0,
   47,   48,   47,    0,   47,   48,    0,    0,   48,    0,
    0,    0,    0,    0,   47,    0,    0,   47,    0,   47,
   48,   48,    0,   47,    0,   48,   48,    0,    0,    0,
    0,   48,    0,   48,   48,   48,   48,    0,    0,    0,
    0,   48,    0,   47,    0,   48,    0,   48,  954,    0,
    0,    0,   47,    0,    0,    0,    0,   48,    0,    0,
   48,    0,   48,   47,    0,    0,   48,    0,   47,    0,
    0,    0,   47,    0,    0,   47,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,   48,   47,   47,    0,
    0,    0,   47,   47,    0,   48,    0,    0,   47,   48,
   47,   47,   47,   47,    0,    0,    0,    0,   47,    0,
   48,    0,   47,    0,   47,   48,    0,    0,    0,   48,
    0,    0,   48,    0,   47,    0,    0,   47,    0,   47,
    0,    0,    0,   47,   48,   48,    0,    0,    0,   48,
   48,    0,    0,    0,    0,   48,    0,   48,   48,   48,
   48,    0,    0,   47,    0,   48,    0,    0,    0,   48,
    0,   48,    0,    0,    0,    0,    0,    0,    0,    0,
    0,   48,    0,   55,   48,    0,   48,    0,    0,    0,
   48,   56,   24,   57,   25,    0,    0,   26,   58,    0,
   59,   60,   27,   61,   62,   63,   28,    0,    0,    0,
   48,    0,   64,    0,   65,   30,   66,   67,   68,   69,
    0,    0,   32,    0,    0,    0,   70,   33,    0,   71,
   72,   34,    0,    0,    0,    0,    0,    0,    0,    0,
    0,   73,    0,   36,    0,   37,   74,    0,    0,   38,
    0,   75,   76,   77,   78,   79,   80,   39,   40,   81,
   82,   41,   83,    0,   84,    0,    0,   85,   86,    0,
  335,   87,   88,    0,    0,    0,  335,    0,    0,    0,
    0,    0,    0,    0,    0,    0,   89,   90,   91,   92,
   93,    0,    0,    0,   94,    0,    0,    0,   95,    0,
    0,    0,    0,   96,   97,   98,   99,  100,    0,    0,
    0,  101,  335,  102,    0,    0,    0,    0,    0,  103,
  104,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,  335,    0,    0,    0,
    0,    0,  335,    0,  105,  106,  107,  108,    0,    0,
    0,    0,    0,  335,    0,    0,  196,    0,  335,    0,
  335,  335,  335,  335,  335,  335,  335,  335,  335,  335,
  335,  335,    0,    0,    0,    0,    0,  335,  335,    0,
    0,    0,  335,  335,  335,  335,  335,  335,  335,  335,
  335,    0,  335,  335,    0,  335,  335,  335,  335,  335,
  335,  335,  335,  335,  335,    0,  335,  335,  335,  335,
  335,  335,  335,  335,  335,  335,  335,  335,  335,  335,
  335,  335,  335,  335,  335,  335,  335,  335,    0,  505,
    0,    0,  335,    0,  335,  505,    0,  335,    0,    0,
    0,    0,    0,  335,    0,    0,    0,    0,  335,    0,
    0,  335,    0,  335,  335,    0,    0,    0,  335,  335,
    0,    0,  335,  335,  335,  335,  335,  335,  335,  335,
  335,  505,  335,  335,  335,  335,  335,  335,  335,  335,
  335,  335,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,  335,  335,    0,    0,    0,    0,    0,    0,
  335,    0,    0,  335,    0,    0,    0,    0,    0,  335,
    0,  201,  505,    0,    0,    0,    0,  505,    0,  505,
  505,  505,  505,  505,  505,  505,  505,  505,  505,  505,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
  505,  505,  505,  505,  505,  505,  505,  505,  505,  505,
  945,  505,  505,  202,  505,  505,  505,  505,  505,  505,
  505,  505,  505,  505,    0,  505,  505,  505,  505,  505,
  505,  505,  505,  505,  505,  505,  505,  505,  505,  505,
  505,  505,  505,  505,  505,  505,  505,    0,  501,    0,
    0,    0,    0,  505,  501,    0,    0,    0,    0,    0,
    0,    0,  505,  203,  204,  205,  206,    0,  207,  208,
  209,  210,  211,  212,  213,  214,    0,    0,  215,  216,
  217,  218,  219,  220,  221,  222,    0,    0,    0,    0,
  501,    0,    0,  945,    0,    0,    0,    0,  945,    0,
  945,  945,  945,  945,  945,  945,  945,  945,  945,  945,
    0,    0,    0,    0,    0,    0,    0,    0,    0,  391,
    0,    0,  945,    0,  945,  391,  945,    0,  945,  945,
  945,  501,    0,    0,    0,    0,  501,    0,  501,  501,
  501,  501,  501,  501,  501,  501,  501,  501,  501,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,  501,
  501,  391,  501,  501,  501,  501,  501,  501,  501,    0,
  501,  501,    0,  501,  501,  501,  501,  501,  501,  501,
  501,  501,  501,  945,  501,  501,  501,  501,  501,  501,
  501,  501,  501,  501,  501,  501,  501,  501,  501,  501,
  501,  501,  501,  501,  501,  501,    0,  509,    0,    0,
    0,    0,  501,  509,    0,  501,    0,    0,    0,    0,
    0,  501,    0,    0,    0,    0,  328,    0,    0,    0,
    0,  391,  328,    0,  391,  391,  391,  391,    0,  391,
    0,  391,  391,    0,  391,  391,  391,  391,  391,  509,
  391,  391,  391,  391,    0,  391,  391,  391,  391,  391,
  391,  391,  391,  391,  391,  391,  391,  391,  391,  391,
  391,  391,  391,  391,  391,  391,  391,    0,    0,    0,
    0,  328,    0,  391,    0,    0,  391,    0,    0,    0,
  509,    0,  391,    0,    0,  509,    0,  509,  509,  509,
  509,  509,  509,  509,  509,  509,  509,  509,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,  509,
    0,  509,  509,  509,  509,  509,  509,  509,    0,  509,
  509,    0,  509,  509,  509,  509,  509,  509,  509,  509,
  509,  509,    0,  509,  509,  509,  509,  509,  509,  509,
  509,  509,  509,  509,  509,  509,  509,  509,  509,  509,
  509,  509,  509,  509,  509,    0,  335,  756,    0,    0,
    0,  509,  335,    0,  509,    0,   24,    0,   25,    0,
  509,   26,    0,    0,    0,    0,   27,    0,    0,    0,
   28,    0,    0,    0,    0,    0,    0,    0,    0,   30,
    0,    0,    0,    0,    0,    0,   32,    0,  335,    0,
    0,   33,    0,    0,    0,   34,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,   36,    0,   37,
    0,    0,    0,   38,    0,    0,    0,    0,    0,    0,
    0,   39,   40,    0,    0,   41,    0,    0,  757,  335,
    0,    0,    0,    0,  335,    0,  335,  335,  335,  335,
  335,  335,  335,  335,  335,  335,  335,    0,    0,    0,
    0,    0,    0,    0,  291,    0,    0,    0,  335,    0,
  335,  335,  335,  335,  335,  335,  335,    0,  335,  335,
    0,  335,  335,  335,  335,  335,  335,  335,  335,  335,
  335,    0,  335,  335,  335,  335,  335,  335,  335,  335,
  335,  335,  335,  335,  335,  335,  335,  335,  335,  335,
  335,  335,  335,  335,    0,  434,  567,    0,    0,  323,
  335,  434,    0,  335,    0,   24,    0,   25,    0,  335,
   26,    0,    0,    0,    0,   27,    0,    0,    0,   28,
    0,    0,    0,    0,    0,    0,    0,    0,   30,    0,
    0,    0,    0,    0,    0,   32,    0,  434,    0,    0,
   33,    0,    0,    0,   34,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,   36,    0,   37,    0,
    0,    0,   38,    0,    0,    0,    0,    0,    0,    0,
   39,   40,    0,    0,   41,    0,    0,  322,  434,    0,
    0,    0,    0,  434,    0,  434,  434,  434,  434,  434,
  434,  434,  434,  434,  434,  434,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,  434,    0,  434,
  434,  434,  434,  434,  434,  434,    0,  434,  434,    0,
  434,  434,  434,  434,  434,  434,  434,  434,  434,  434,
    0,  434,  434,  434,  434,  434,  434,  434,  434,  434,
  434,  434,  434,  434,  434,  434,  434,  434,  434,  434,
  434,  434,  434,    0,  394,    0,  453,    0,  355,  434,
  394,    0,  434,    0,    0,    0,    0,    0,  434,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,  454,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,  455,    0,    0,    0,  394,  457,    0,    0,
    0,    0,  458,    0,  459,  460,  461,  462,    0,    0,
    0,    0,  463,    0,    0,    0,  464,    0,    0,  335,
 1320,    0,    0,    0,    0,  335,    0,    0,  465,  743,
    0,  466,    0,  467,    0,    0,    0,  394,    0,    0,
    0,    0,  394,    0,  394,  394,  394,  394,  394,  394,
  394,  394,  394,  394,  394,    0,    0,  468,    0,    0,
    0,  335,    0,    0,    0,    0,  394,    0,  394,  394,
  394,  394,  394,  394,  394,    0,  394,  743,    0,  394,
  394,  394,  394,  394,  394,  394,  394,  394,  394,    0,
  394,  394,  394,  394,  394,  394,  394,  394,  394,  394,
  394,  394,  394,  394,  394,  394,  394,  394,  394,  394,
  394,  394,    0, 1321,    0,    0,    0,    0,  394,    0,
  335,  394,    0,    0,    0,    0,  335,  394,    0,    0,
    0,  335,  335,  335,  335,  335,  335,  335,  743,  335,
    0,  335,  335,    0,  335,  335,  335,  335,  335,  335,
  335,  335,  335,  335,    0,  335,  335,  335,  335,  335,
  335,  335,  335,  335,  335,  335,  335,  335,  335,  335,
  335,  335,  335,  335,  335,  335,  335,    0,  540,    0,
  501,  335,    0,  335,  540,    0,  335,    0,   56,   24,
    0,   25,  335,    0,   26,  253,    0,    0,    0,   27,
   61,   62,    0,   28,    0,    0,    0,    0,    0,   64,
    0,    0,   30,    0,    0,    0,    0,    0,    0,   32,
  540,    0,    0,    0,   33,    0,   71,   72,   34,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
   36,    0,   37,   74,    0,    0,   38,    0,    0,   76,
    0,   78,    0,   80,   39,   40,  254,    0,   41,    0,
    0,  540,    0,    0,    0,    0,  540,    0,  540,  540,
  540,  540,  540,  540,  540,  540,  540,  540,  540,    0,
    0,    0,    0,   89,   90,   91,  255,    0,    0,    0,
  540,    0,  540,    0,  540,   95,  540,  540,  540,    0,
  540,  540,    0,  540,  540,  540,  540,  540,  540,  540,
  540,  540,  540,  453,    0,    0,  540,  540,  540,  540,
  540,  540,  540,  540,  540,  540,  540,  540,  540,  540,
  540,  540,  540,  540,  552,  540,  454,    0,    0,    0,
  552,  105,  502,    0,    0,    0,    0,    0,    0,  455,
    0,  540,    0,    0,  457,    0,    0,    0,    0,  458,
    0,  459,  460,  461,  462,    0,    0,    0,    0,  463,
    0,    0,    0,  464,    0,    0,  552,    0,    0,    0,
    0,    0,    0,    0,    0,  465,    0,    0,  466,    0,
  467,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,  556,    0,    0,    0,    0,    0,  556,    0,
    0,    0,    0,    0,  468,    0,    0,  552,    0,    0,
    0,    0,  552,    0,  552,  552,  552,  552,  552,  552,
  552,  552,  552,  552,  552,    0,    0,    0,    0,    0,
    0,    0,    0,    0,  556,    0,  552,    0,  552,    0,
  552,    0,  552,  552,  552,    0,  552,  552,    0,    0,
  552,  552,  552,  552,  552,  552,  552,  552,  552,    0,
 1335,    0,  552,  552,  552,  552,  552,  552,  552,  552,
    0,    0,    0,    0,    0,  556,    0,    0,    0,    0,
  556,  552,  556,  556,  556,  556,  556,  556,  556,  556,
  556,  556,  556,    0,    0,    0,  559,  552,    0,    0,
    0,    0,  559,    0,  556,    0,  556,    0,  556,    0,
  556,  556,  556,    0,  556,  556,    0,    0,  556,  556,
  556,  556,    0,    0,    0,  556,  556,    0,    0,    0,
  556,  556,  556,  556,  556,  556,  556,  556,  559,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,  556,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,  557,  556,    0,    0,    0,    0,
  557,    0,    0,    0,    0,    0,    0,    0,    0,  559,
    0,    0,    0,    0,  559,    0,  559,  559,  559,  559,
  559,  559,  559,  559,  559,  559,  559,    0,    0,    0,
    0,    0,    0,    0,    0,    0,  557,    0,  559,    0,
  559,    0,  559,    0,  559,  559,  559,    0,  559,  559,
    0,    0,  559,  559,  559,  559,    0,    0,    0,  559,
  559,    0,    0,    0,  559,  559,  559,  559,  559,  559,
  559,  559,    0,    0,    0,    0,    0,  557,    0,    0,
    0,    0,  557,  559,  557,  557,  557,  557,  557,  557,
  557,  557,  557,  557,  557,    0,    0,    0,  558,  559,
    0,    0,    0,    0,  558,    0,  557,    0,  557,    0,
  557,    0,  557,  557,  557,    0,  557,  557,    0,    0,
  557,  557,  557,  557,    0,    0,    0,  557,  557,    0,
    0,    0,  557,  557,  557,  557,  557,  557,  557,  557,
  558,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,  557,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,  562,  557,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,  558,    0,    0,    0,    0,  558,    0,  558,  558,
  558,  558,  558,  558,  558,  558,  558,  558,  558,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
  558,    0,  558,    0,  558,    0,  558,  558,  558,    0,
  558,  558,    0,    0,  558,  558,  558,  558,    0,    0,
    0,  558,  558,    0,  563,    0,  558,  558,  558,  558,
  558,  558,  558,  558,    0,    0,    0,    0,    0,  562,
    0,    0,    0,    0,  562,  558,  562,  562,  562,  562,
  562,  562,  562,  562,  562,  562,  562,    0,    0,    0,
    0,  558,    0,    0,    0,    0,    0,    0,  562,    0,
  562,    0,  562,    0,  562,  562,  562,    0,    0,    0,
    0,    0,  562,  562,  562,  562,    0,    0,    0,  562,
  562,    0,  564,    0,  562,  562,  562,  562,  562,  562,
  562,  562,    0,    0,    0,    0,    0,  563,    0,    0,
    0,    0,  563,  562,  563,  563,  563,  563,  563,  563,
  563,  563,  563,  563,  563,    0,    0,    0,    0,  562,
    0,    0,    0,    0,    0,    0,  563,    0,  563,    0,
  563,    0,  563,  563,  563,    0,    0,    0,    0,    0,
  563,  563,  563,  563,    0,    0,    0,  563,  563,    0,
  565,    0,  563,  563,  563,  563,  563,  563,  563,  563,
    0,    0,    0,    0,    0,  564,    0,    0,    0,    0,
  564,  563,  564,  564,  564,  564,  564,  564,  564,  564,
  564,  564,  564,    0,    0,    0,    0,  563,    0,    0,
    0,    0,    0,    0,  564,    0,  564,    0,  564,    0,
  564,  564,  564,    0,    0,    0,    0,    0,  564,  564,
  564,  564,    0,    0,    0,  564,  564,    0,  566,    0,
  564,  564,  564,  564,  564,  564,  564,  564,    0,    0,
    0,    0,    0,  565,    0,    0,    0,    0,  565,  564,
  565,  565,  565,  565,  565,  565,  565,  565,  565,  565,
  565,    0,    0,    0,    0,  564,    0,    0,    0,    0,
    0,    0,  565,    0,  565,    0,  565,    0,  565,  565,
  565,    0,    0,    0,    0,    0,  565,  565,  565,  565,
    0,    0,    0,  565,  565,    0,  567,    0,    0,    0,
  565,  565,  565,  565,  565,  565,    0,    0,    0,    0,
    0,  566,    0,    0,    0,    0,  566,  565,  566,  566,
  566,  566,  566,  566,  566,  566,  566,  566,  566,    0,
    0,    0,    0,  565,    0,    0,    0,    0,    0,    0,
  566,    0,  566,    0,  566,    0,  566,  566,  566,    0,
    0,    0,    0,    0,  566,  566,  566,  566,    0,    0,
    0,  566,  566,    0,  568,    0,    0,    0,  566,  566,
  566,  566,  566,  566,    0,    0,    0,    0,    0,  567,
    0,    0,    0,    0,  567,  566,  567,  567,  567,  567,
  567,  567,  567,  567,  567,  567,  567,    0,    0,    0,
    0,  566,    0,    0,    0,    0,    0,    0,  567,    0,
  567,    0,  567,    0,  567,  567,  567,    0,    0,    0,
    0,    0,  567,  567,  567,  567,    0,    0,    0,  567,
  567,    0,  569,    0,    0,    0,  567,  567,  567,  567,
  567,  567,    0,    0,    0,    0,    0,  568,    0,    0,
    0,    0,  568,  567,  568,  568,  568,  568,  568,  568,
  568,  568,  568,  568,  568,    0,    0,    0,    0,  567,
    0,    0,    0,    0,    0,    0,  568,    0,  568,    0,
  568,    0,  568,  568,  568,    0,    0,    0,    0,    0,
  568,  568,  568,  568,    0,    0,    0,  568,  568,    0,
  570,    0,    0,    0,  568,  568,  568,  568,  568,  568,
    0,    0,    0,    0,    0,  569,    0,    0,    0,    0,
  569,  568,  569,  569,  569,  569,  569,  569,  569,  569,
  569,  569,  569,    0,    0,    0,    0,  568,    0,    0,
    0,    0,    0,    0,  569,    0,  569,    0,  569,    0,
  569,  569,  569,    0,    0,    0,    0,    0,  569,  569,
  569,  569,    0,    0,    0,  569,  569,    0,  571,    0,
    0,    0,  569,  569,  569,  569,  569,  569,    0,    0,
    0,    0,    0,  570,    0,    0,    0,    0,  570,  569,
  570,  570,  570,  570,  570,  570,  570,  570,  570,  570,
  570,    0,    0,    0,    0,  569,    0,    0,    0,    0,
    0,    0,  570,    0,  570,    0,  570,    0,  570,  570,
  570,    0,    0,    0,    0,    0,    0,    0,  570,  570,
    0,    0,    0,  570,  570,    0,  572,    0,    0,    0,
    0,    0,  570,  570,  570,  570,    0,    0,    0,    0,
    0,  571,    0,    0,    0,    0,  571,  570,  571,  571,
  571,  571,  571,  571,  571,  571,  571,  571,  571,    0,
    0,    0,    0,  570,    0,    0,    0,    0,    0,    0,
  571,    0,  571,    0,  571,    0,  571,  571,  571,    0,
    0,    0,    0,    0,    0,    0,  571,  571,    0,    0,
    0,  571,  571,    0,  573,    0,    0,    0,    0,    0,
  571,  571,  571,  571,    0,    0,    0,    0,    0,  572,
    0,    0,    0,    0,  572,  571,  572,  572,  572,  572,
  572,  572,  572,  572,  572,  572,  572,    0,    0,    0,
    0,  571,    0,    0,    0,    0,    0,    0,  572,    0,
  572,    0,  572,    0,  572,  572,  572,    0,    0,    0,
    0,    0,    0,    0,  572,  572,    0,    0,    0,  572,
  572,    0,  574,    0,    0,    0,    0,    0,  572,  572,
  572,  572,    0,    0,    0,    0,    0,  573,    0,    0,
    0,    0,  573,  572,  573,  573,  573,  573,  573,  573,
  573,  573,  573,  573,  573,    0,    0,    0,    0,  572,
    0,    0,    0,    0,    0,    0,  573,    0,  573,    0,
  573,    0,  573,  573,  573,    0,    0,    0,    0,    0,
    0,    0,  573,  573,    0,    0,    0,  573,  573,    0,
  575,    0,    0,    0,    0,    0,    0,    0,  573,  573,
    0,    0,    0,    0,    0,  574,    0,    0,    0,    0,
  574,  573,  574,  574,  574,  574,  574,  574,  574,  574,
  574,  574,  574,    0,    0,    0,    0,  573,    0,    0,
    0,    0,    0,    0,  574,    0,  574,    0,  574,    0,
  574,  574,  574,    0,    0,    0,    0,    0,    0,    0,
  574,  574,    0,    0,    0,  574,  574,    0,  576,    0,
    0,    0,    0,    0,    0,    0,  574,  574,    0,    0,
    0,    0,    0,  575,    0,    0,    0,    0,  575,  574,
  575,  575,  575,  575,  575,  575,  575,  575,  575,  575,
  575,    0,    0,    0,    0,  574,    0,    0,    0,    0,
    0,    0,  575,    0,  575,    0,  575,    0,  575,  575,
  575,    0,    0,    0,    0,    0,    0,    0,    0,  575,
    0,    0,    0,  575,  575,    0,  577,    0,    0,    0,
    0,    0,    0,    0,  575,  575,    0,    0,    0,    0,
    0,  576,    0,    0,    0,    0,  576,  575,  576,  576,
  576,  576,  576,  576,  576,  576,  576,  576,  576,    0,
    0,    0,    0,  575,    0,    0,    0,    0,    0,    0,
  576,    0,  576,    0,  576,    0,  576,  576,  576,    0,
    0,    0,    0,    0,    0,    0,    0,  576,    0,    0,
    0,  576,  576,    0,  578,    0,    0,    0,    0,    0,
    0,    0,  576,  576,    0,    0,    0,    0,    0,  577,
    0,    0,    0,    0,  577,  576,  577,  577,  577,  577,
  577,  577,  577,  577,  577,  577,  577,    0,    0,    0,
    0,  576,    0,    0,    0,    0,    0,    0,  577,    0,
  577,    0,  577,    0,  577,  577,  577,    0,    0,    0,
    0,    0,    0,    0,    0,  577,    0,    0,    0,    0,
  577,    0,  579,    0,    0,    0,    0,    0,    0,    0,
  577,  577,    0,    0,    0,    0,    0,  578,    0,    0,
    0,    0,  578,  577,  578,  578,  578,  578,  578,  578,
  578,  578,  578,  578,  578,    0,    0,    0,    0,  577,
    0,    0,    0,    0,    0,    0,  578,    0,  578,    0,
  578,    0,  578,  578,  578,    0,    0,    0,    0,    0,
    0,    0,    0,  578,    0,    0,    0,    0,  578,    0,
  580,    0,    0,    0,    0,    0,    0,    0,  578,  578,
    0,    0,    0,    0,    0,  579,    0,    0,    0,    0,
  579,  578,  579,  579,  579,  579,  579,  579,  579,  579,
  579,  579,  579,    0,    0,    0,    0,  578,    0,    0,
    0,    0,    0,    0,  579,    0,  579,    0,  579,    0,
  579,  579,  579,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,  335,  579,    0,    0,  743,
    0,    0,    0,    0,    0,    0,  579,  579,    0,    0,
    0,    0,    0,  580,    0,    0,    0,    0,  580,  579,
  580,  580,  580,  580,  580,  580,  580,  580,  580,  580,
  580,  335,    0,    0,    0,  579,    0,    0,    0,    0,
    0,    0,  580,    0,  580,    0,  580,  743,  580,  580,
  580,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,  580,    0,    0,    0,    0,    0,
    0,    0,    0,    0,  580,  580,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,  580,    0,    0,
  335,    0,    0,    0,    0,    0,  335,    0,    0,    0,
    0,  335,  335,  580,  335,    0,  335,    0,  743,  335,
    0,  335,  335,    0,  335,  335,  335,  335,  335,  335,
  335,  335,  335,  335,    0,  335,  335,  335,  335,  335,
  335,  335,  335,  335,  335,  335,  335,  335,  335,  335,
  335,  335,  335,  335,  335,  335,  335,    0,    0,   55,
    0,  335,    0,  335,    0,    0,  335,   56,   24,   57,
   25,    0,  335,   26,   58,    0,   59,   60,   27,   61,
   62,   63,   28,    0,    0,    0,    0,    0,   64,    0,
   65,   30,   66,   67,   68,   69,    0,    0,   32,    0,
    0,    0,   70,   33,    0,   71,   72,   34,    0,    0,
    0,    0,    0,    0,    0,    0,    0,   73,    0,   36,
    0,   37,   74,    0,    0,   38,    0,   75,   76,   77,
   78,   79,   80,   39,   40,   81,   82,   41,   83,    0,
   84,    0,    0,   85,   86,    0,    0,   87,   88,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,   89,   90,   91,   92,   93,    0,    0,    0,
   94,    0,    0,    0,   95,    0,    0,    0,    0,   96,
   97,   98,   99,  100,    0,    0,    0,  101,    0,  102,
    0,    0,    0,    0,    0,  103,  104,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,  266,    0,    0,    0,
  105,  106,  107,  108,   56,   24,   57,   25,    0,    0,
   26,   58,    0,   59,   60,   27,   61,   62,   63,   28,
    0,    0,    0,    0,    0,   64,    0,   65,   30,   66,
   67,   68,   69,    0,    0,   32,    0,    0,    0,   70,
   33,    0,   71,   72,   34,    0,    0,    0,    0,    0,
    0,    0,    0,    0,   73,    0,   36,    0,   37,   74,
    0,    0,   38,    0,   75,   76,   77,   78,   79,   80,
   39,   40,   81,   82,   41,   83,    0,   84,    0,    0,
   85,   86,    0,    0,   87,   88,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,   89,
   90,   91,   92,   93,    0,    0,    0,   94,    0,    0,
    0,   95,    0,    0,    0,    0,   96,   97,   98,   99,
  100,    0,    0,    0,  101,    0,  102,    0,    0,    0,
    0,    0,  103,  104,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,  556,    0,    0,    0,  105,  106,  107,
  108,   56,   24,   57,   25,    0,    0,   26,   58,    0,
   59,   60,   27,   61,   62,   63,   28,    0,    0,    0,
    0,    0,   64,    0,   65,   30,   66,   67,   68,   69,
    0,    0,   32,    0,    0,    0,   70,   33,    0,   71,
   72,   34,    0,    0,    0,    0,    0,    0,    0,    0,
    0,   73,    0,   36,    0,   37,   74,    0,    0,   38,
    0,   75,   76,   77,   78,   79,   80,   39,   40,   81,
   82,   41,   83,    0,   84,    0,    0,   85,   86,    0,
    0,   87,   88,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,   89,   90,   91,   92,
   93,    0,    0,    0,   94,    0,    0,    0,   95,    0,
    0,    0,    0,   96,   97,   98,   99,  100,    0,    0,
    0,  101,    0,  102,    0,    0,    0,    0,    0,  103,
  104,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
  950,    0,    0,    0,  105,  557,  107,  108,  950,  950,
  950,  950,    0,    0,  950,  950,    0,  950,  950,  950,
  950,  950,  950,  950,    0,    0,    0,    0,    0,  950,
    0,  950,  950,  950,  950,  950,  950,    0,    0,  950,
    0,    0,    0,  950,  950,    0,  950,  950,  950,    0,
    0,    0,    0,    0,    0,    0,    0,    0,  950,    0,
  950,    0,  950,  950,    0,    0,  950,    0,  950,  950,
  950,  950,  950,  950,  950,  950,  950,  950,  950,  950,
    0,  950,    0,    0,  950,  950,    0,    0,  950,  950,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,  950,  950,  950,  950,  950,    0,    0,
    0,  950,    0,    0,    0,  950,    0,    0,    0,    0,
  950,  950,  950,  950,  950,    0,    0,    0,  950,    0,
  950,    0,    0,    0,    0,    0,  950,  950,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,  794,    0,    0,
    0,  950,  950,  950,  950,  794,  794,  794,  794,    0,
    0,  794,  794,    0,  794,  794,  794,  794,  794,  794,
  794,    0,    0,    0,    0,    0,  794,    0,  794,  794,
  794,  794,  794,  794,    0,    0,  794,    0,    0,    0,
  794,  794,    0,  794,  794,  794,    0,    0,    0,    0,
    0,    0,    0,    0,    0,  794,    0,  794,    0,  794,
  794,    0,    0,  794,    0,  794,  794,  794,  794,  794,
  794,  794,  794,  794,  794,  794,  794,    0,  794,    0,
    0,  794,  794,    0,    0,  794,  794,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
  794,  794,  794,  794,  794,    0,    0,    0,  794,    0,
    0,    0,  794,    0,    0,    0,    0,  794,  794,  794,
  794,  794,    0,    0,    0,  794,    0,  794,    0,    0,
    0,    0,    0,  794,  794,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,  742,    0,    0,    0,  794,  794,
  794,  794,   56,   24,    0,   25,    0,    0,   26,  253,
    0,  903,    0,   27,   61,   62,    0,   28,    0,    0,
   24,    0,   25,   64,    0,   26,   30,    0,    0,    0,
   27,    0,    0,   32,   28,    0,    0,    0,   33,    0,
   71,   72,   34,   30,    0,    0,    0,    0,    0,    0,
   32,    0,    0,    0,   36,   33,   37,   74,    0,   34,
   38,    0,    0,   76,    0,   78,    0,   80,   39,   40,
  254,   36,   41,   37,    0,    0,    0,   38,    0,   86,
    0,    0,   87,   88,    0,   39,   40,    0,    0,   41,
    0,    0,  322,    0,    0,    0,    0,   89,   90,   91,
   92,  302,    0,    0,    0,  518,  743,    0,    0,   95,
    0,    0,    0,    0,    0,   97,   98,   99,  100,    0,
    0,    0,  101,    0,  102,    0,    0,    0,    0,    0,
  103,  104,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,  929,    0,    0,    0,  105,  303,  107,  108,   56,
   24,    0,   25,    0,    0,   26,  253,    0, 1049,    0,
   27,   61,   62,  355,   28,    0,    0,   24,    0,   25,
   64,    0,   26,   30,    0,    0,    0,   27,    0,    0,
   32,   28,    0,    0,    0,   33,    0,   71,   72,   34,
   30,  593,    0,    0,    0,    0,    0,   32,  594,    0,
    0,   36,   33,   37,   74,    0,   34,   38,    0,    0,
   76,    0,   78,    0,   80,   39,   40,  254,   36,   41,
   37,    0,    0,    0,   38,    0,  595,    0,    0,   87,
   88,    0,   39,   40,    0,    0,   41,    0,    0,  322,
    0,    0,    0,    0,   89,   90,   91,   92,   93,    0,
    0,    0,    0,    0,    0,    0,   95,    0,    0,    0,
    0,    0,   97,   98,   99,  100,    0,    0,    0,  101,
    0,  102,    0,    0,    0,    0,    0,  103,  104,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,  933,    0,
    0,    0,  105,  106,  107,  108,   56,   24,    0,   25,
    0,    0,   26,  253,    0,    0,    0,   27,   61,   62,
  355,   28,    0,    0,  174,    0,  174,   64,    0,  174,
   30,    0,    0,    0,  174,    0,    0,   32,  174,    0,
    0,    0,   33,    0,   71,   72,   34,  174,    0,    0,
    0,    0,    0,    0,  174,    0,    0,    0,   36,  174,
   37,   74,  934,  174,   38,    0,    0,   76,    0,   78,
    0,   80,   39,   40,  254,  174,   41,  174,    0,    0,
    0,  174,    0,   86,    0,    0,   87,   88,    0,  174,
  174,    0,    0,  174,    0,    0,  174,    0,    0,    0,
    0,   89,   90,   91,   92,  302,    0,    0,    0,  518,
    0,    0,    0,   95,    0,    0,    0,    0,    0,   97,
   98,   99,  100,    0,    0,    0,  101,    0,  102,    0,
    0,  974,    0,    0,  103,  104,    0,    0,    0,    0,
    0,    0,   56,   24,    0,   25,    0,    0,   26,  253,
    0,    0,    0,   27,   61,   62,    0,   28,    0,  105,
  303,  107,  108,   64,    0,    0,   30,    0,    0,    0,
    0,    0,    0,   32,    0,    0,    0,  174,   33,    0,
   71,   72,   34,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,   36,    0,   37,   74,    0,    0,
   38,    0,    0,   76,    0,   78,    0,   80,   39,   40,
  254,    0,   41,    0,    0,    0,    0,    0,    0,   86,
    0,    0,   87,   88,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,   89,   90,   91,
   92,  302,    0,    0,    0,  729, 1001,    0,    0,   95,
    0,    0,    0,    0,    0,   97,   98,   99,  100,    0,
    0,    0,  101,    0,  102,    0,    0,    0,    0,    0,
  103,  104,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,  742,    0,  105,  730,  107,  108,    0,
    0,   56,   24,    0,   25,    0,  731,   26,  253,    0,
    0,    0,   27,   61,   62,    0,   28,    0,    0,  174,
    0,  174,   64,    0,  174,   30,    0,    0,    0,  174,
    0,    0,   32,  174,    0,    0,    0,   33,    0,   71,
   72,   34,  174,    0,    0,    0,    0,    0,    0,  174,
    0,    0,    0,   36,  174,   37,   74,  934,  174,   38,
    0,    0,   76,    0,   78,    0,   80,   39,   40,  254,
  174,   41,  174,    0,    0,    0,  174,    0,   86,    0,
    0,   87,   88,    0,  174,  174,    0,    0,  174,    0,
    0,  174,    0,    0,    0,    0,   89,   90,   91,   92,
  302,    0,    0,    0,  518,    0,    0,    0,   95,    0,
    0,    0,    0,    0,   97,   98,   99,  100,    0,    0,
    0,  101,    0,  102,  974,    0,    0,    0,    0,  103,
  104,    0,    0,    0,    0,    0,    0,   56,   24,    0,
   25,    0,    0,   26,  253,    0,    0,    0,   27,   61,
   62,    0,   28,    0,  105,  303,  107,  108,   64,    0,
    0,   30,    0,    0,    0,    0,    0,    0,   32,    0,
    0,    0,  174,   33,    0,   71,   72,   34,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,   36,
    0,   37,   74,    0,    0,   38,    0,    0,   76,    0,
   78,    0,   80,   39,   40,  254,    0,   41,    0,    0,
    0,    0,    0,    0,   86,    0,    0,   87,   88,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,   89,   90,   91,   92,  302,    0,    0,    0,
  729,    0,    0,    0,   95,    0,    0,    0,    0,    0,
   97,   98,   99,  100,    0,    0,    0,  101,    0,  102,
    0,    0,    0,    0,    0,  103,  104,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,  742,    0,
  105,  730,  107,  108,    0,    0,   56,   24,    0,   25,
    0,  731,   26,  253,    0,    0,    0,   27,   61,   62,
    0,   28,    0,    0,   24,    0,   25,   64,    0,   26,
   30,    0,    0,    0,   27,    0,    0,   32,   28,    0,
    0,    0,   33,    0,   71,   72,   34,   30,    0,    0,
    0,    0,    0,    0,   32,    0,    0,    0,   36,   33,
   37,   74,    0,   34,   38,    0,    0,   76,    0,   78,
    0,   80,   39,   40,  254,   36,   41,   37,    0,    0,
    0,   38,    0,   86,    0,    0,   87,   88,    0,   39,
   40,    0,    0,   41,    0,    0,  322,    0,    0,    0,
    0,   89,   90,   91,   92,  302,    0,    0,    0,  518,
    0,    0,    0,   95,    0,    0,    0,    0,    0,   97,
   98,   99,  100,    0,    0,    0,  101,    0,  102,    0,
    0,    0,    0,    0,  103,  104,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,  301,    0,    0,    0,  105,
  303,  107,  108,   56,   24,    0,   25,    0,    0,   26,
  253,    0,    0,    0,   27,   61,   62,  355,   28,    0,
    0,   24,    0,   25,   64,    0,   26,   30,    0,    0,
    0,   27,    0,    0,   32,   28,    0,    0,    0,   33,
    0,   71,   72,   34,   30,    0,    0,    0,    0,    0,
    0,   32,    0,    0,    0,   36,   33,   37,   74,    0,
   34,   38,    0,    0,   76,    0,   78,    0,   80,   39,
   40,  254,   36,   41,   37,    0,    0,    0,   38,    0,
   86,    0,    0,   87,   88,    0,   39,   40,    0,    0,
   41,    0,    0,  520,    0,    0,    0,    0,   89,   90,
   91,   92,  302,    0,    0,    0,    0,    0,    0,    0,
   95,    0,    0,    0,    0,    0,   97,   98,   99,  100,
    0,    0,    0,  101,    0,  102,    0,    0,    0,    0,
    0,  103,  104,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,  310,    0,    0,    0,  105,  303,  107,  108,
   56,   24,    0,   25,    0,    0,   26,  253,    0,    0,
    0,   27,   61,   62,  355,   28,    0,    0,   24,    0,
   25,   64,    0,   26,   30,    0,    0,    0,   27,    0,
    0,   32,   28,    0,    0,    0,   33,    0,   71,   72,
   34,   30,    0,    0,    0,    0,    0,    0,   32,    0,
    0,    0,   36,   33,   37,   74,    0,   34,   38,    0,
    0,   76,    0,   78,    0,   80,   39,   40,  254,   36,
   41,   37,    0,    0,    0,   38,    0,   86,    0,    0,
   87,   88,    0,   39,   40,    0,    0,   41,    0,    0,
  573,    0,    0,    0,    0,   89,   90,   91,   92,  302,
    0,    0,    0,    0,    0,    0,    0,   95,    0,    0,
    0,    0,    0,   97,   98,   99,  100,    0,    0,    0,
  101,    0,  102,    0,    0,    0,    0,    0,  103,  104,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,  591,
    0,    0,    0,  105,  303,  107,  108,   56,   24,    0,
   25,    0,    0,   26,  253,    0,    0,    0,   27,   61,
   62,  355,   28,    0,    0,   24,    0,   25,   64,    0,
   26,   30,    0,    0,    0,   27,    0,    0,   32,   28,
    0,    0,    0,   33,    0,   71,   72,   34,   30,    0,
    0,    0,    0,    0,    0,   32,    0,    0,    0,   36,
   33,   37,   74,    0,   34,   38,    0,    0,   76,    0,
   78,    0,   80,   39,   40,  254,   36,   41,   37,    0,
    0,    0,   38,    0,   86,    0,    0,   87,   88,    0,
   39,   40,    0,    0,   41,    0,    0,  757,    0,    0,
    0,    0,   89,   90,   91,   92,   93,    0,    0,    0,
    0,    0,    0,    0,   95,    0,    0,    0,    0,    0,
   97,   98,   99,  100,    0,    0,    0,  101,    0,  102,
    0,    0,    0,    0,    0,  103,  104,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,  820,    0,    0,    0,
  105,  106,  107,  108,   56,   24,    0,   25,    0,    0,
   26,  253,    0,    0,    0,   27,   61,   62,  355,   28,
    0,    0,  488,    0,  488,   64,    0,  488,   30,    0,
    0,    0,  488,    0,    0,   32,  488,    0,    0,    0,
   33,    0,   71,   72,   34,  488,    0,    0,    0,    0,
    0,    0,  488,    0,    0,    0,   36,  488,   37,   74,
    0,  488,   38,    0,    0,   76,    0,   78,    0,   80,
   39,   40,  254,  488,   41,  488,    0,    0,    0,  488,
    0,   86,    0,    0,   87,   88,    0,  488,  488,    0,
    0,  488,    0,    0,  488,    0,    0,    0,    0,   89,
   90,   91,   92,  302,    0,    0,    0,    0,    0,    0,
    0,   95,    0,    0,    0,    0,    0,   97,   98,   99,
  100,    0,    0,    0,  101,    0,  102,    0,    0,    0,
    0,    0,  103,  104,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0, 1184,    0,    0,    0,  105,  303,  107,
  108,   56,   24,    0,   25,    0,    0,   26,  253,    0,
    0,    0,   27,   61,   62,  488,   28,    0,    0,  175,
    0,  175,   64,    0,  175,   30,    0,    0,    0,  175,
    0,    0,   32,  175,    0,    0,    0,   33,    0,   71,
   72,   34,  175,    0,    0,    0,    0,    0,    0,  175,
    0,    0,    0,   36,  175,   37,   74,    0,  175,   38,
    0,    0,   76,    0,   78,    0,   80,   39,   40,  254,
  175,   41,  175,    0,    0,    0,  175,    0,   86,    0,
    0,   87,   88,    0,  175,  175,    0,    0,  175,    0,
    0,  175,    0,    0,    0,    0,   89,   90,   91,   92,
  302,    0,    0,    0,    0,    0,    0,    0,   95,    0,
    0,    0,    0,    0,   97,   98,   99,  100,    0,    0,
    0,  101,    0,  102,    0,    0,    0,    0,    0,  103,
  104,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
  608,    0,    0,    0,  105,  303,  107,  108,  608,  608,
    0,  608,    0,    0,  608,  608,    0,    0,    0,  608,
  608,  608,  175,  608,    0,    0,    0,    0,    0,  608,
    0,    0,  608,    0,    0,    0,    0,    0,    0,  608,
    0,    0,    0,    0,  608,    0,  608,  608,  608,    0,
    0,    0,    0,    0,    0,    0,  335,    0,    0,    0,
  608,    0,  608,  608,    0,    0,  608,    0,    0,  608,
    0,  608,    0,  608,  608,  608,  608,    0,  608,    0,
    0,    0,    0,    0,    0,  608,    0,    0,  608,  608,
    0,    0,  335,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,  608,  608,  608,  608,  608,    0,    0,
    0,    0,    0,    0,    0,  608,    0,    0,    0,    0,
    0,  608,  608,  608,  608,    0,    0,    0,  608,    0,
  608,    0,    0,    0,    0,    0,  608,  608,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,  608,  608,  608,  608,  335,  335,  335,  335,  743,
    0,    0,  335,  335,    0,    0,  335,  335,  335,  335,
  335,  335,  335,  335,  335,    0,  335,  335,  335,  335,
  335,  335,  335,  335,  335,  335,  335,  335,  335,  335,
  335,  335,  335,  335,  335,  335,  335,  335,    0,   48,
    0,   48,    0,   48,  335,   48,    0,  335,   48,    0,
   48,   48,    0,   48,    0,   48,    0,   48,    0,   48,
   48,   48,   48,    0,    0,   48,   48,    0,    0,    0,
    0,   48,   48,   48,   48,   48,    0,    0,   48,    0,
   48,    0,   48,    0,   48,   48,    0,   48,   48,   48,
   48,    0,    0,   48,   48,   48,   48,    0,    0,   48,
   48,   48,    0,    0,    0,    0,    0,    0,   48,   48,
    0,   48,   48,    0,   48,   48,   48,    0,    0,    0,
   48,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
   48,    0,   48,   48,   47,    0,    0,    0,   47,    0,
   47,    0,    0,   47,    0,   47,   47,    0,   47,    0,
   47,    0,   47,    0,   47,   47,   47,   47,    0,    0,
   47,   47,    0,    0,    0,    0,   47,    0,   47,   47,
   47,    0,    0,   47,    0,   47,    0,   47,    0,    0,
   47,    0,   47,   47,   47,   47,   48,    0,    0,   47,
   47,   47,    0,    0,   47,   47,   47,    0,    0,    0,
    0,    0,    0,   47,   47,    0,   47,   47,    0,   47,
   47,   47,    0,    0,    0,   47,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,   47,    0,   47,    0,   47,    0,   47,
    0,   80,   47,    0,   47,   47,    0,   47,    0,   47,
   47,   47,    0,   47,   47,   47,   47,    0,    0,   47,
   47,    0,    0,    0,    0,   47,    0,   47,   47,   47,
    0,    0,   47,    0,   47,    0,   47,    0,    0,   47,
    0,   47,   47,   47,   47,    0,    0,    0,   47,   47,
   47,   47,    0,   47,   47,   47,    0,    0,    0,    0,
    0,    0,   47,   47,    0,   47,   47,    0,   47,   47,
   47,    0,    0,    0,   47,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,   47,    0,   47,    0,   47,    0,   47,    0,
   81,   47,    0,   47,   47,    0,   47,    0,   47,   47,
   47,    0,   47,   47,   47,   47,    0,    0,   47,   47,
    0,    0,    0,    0,   47,    0,   47,   47,   47,    0,
    0,   47,    0,   47,    0,   47,    0,    0,   47,    0,
   47,   47,   47,   47,    0,    0,    0,   47,   47,   47,
   47,    0,   47,   47,   47,    0,    0,    0,    0,    0,
    0,   47,   47,    0,   47,   47,    0,   47,   47,   47,
    0,    0,    0,   47,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,   48,    0,    0,    0,
   48,    0,   48,   47,    0,   48,    0,   48,   48,  214,
   48,    0,   48,    0,   48,    0,   48,   48,   48,   48,
    0,    0,   48,   48,    0,    0,    0,    0,   48,    0,
   48,   48,   48,    0,    0,   48,    0,   48,    0,   48,
    0,    0,   48,    0,   48,   48,   48,   48,    0,    0,
    0,   48,   48,   48,    0,    0,   48,   48,   48,   47,
    0,    0,    0,    0,    0,   48,   48,    0,   48,   48,
    0,   48,   48,   48,    0,    0,    0,   48,    0,    0,
    0,    0,   47,    0,    0,    0,   47,    0,   47,    0,
    0,   47,    0,   47,   47,    0,   47,   48,   47,    0,
   47,    0,   47,   47,   47,   47,    0,    0,   47,   47,
    0,    0,   48,    0,   47,    0,   47,   47,   47,    0,
    0,   47,    0,   47,  335,   47,    0,    0,   47,    0,
   47,   47,   47,   47,    0,    0,    0,   47,   47,   47,
    0,    0,   47,   47,   47,    0,    0,  335,    0,    0,
    0,   47,   47,   48,   47,   47,    0,   47,   47,   47,
  335,    0,    0,   47,    0,  335,    0,    0,  335,    0,
  335,    0,  335,  335,  335,  335,    0,    0,    0,    0,
  335,    0,    0,   47,  335,    0,    0,    0,  335,  215,
    0,    0,    0,    0,    0,    0,  335,    0,    0,  335,
    0,  335,   56,   24,    0,   25,    0,    0,   26,  253,
    0,    0,    0,   27,   61,   62,    0,   28,    0,    0,
  335,    0,    0,   64,    0,  335,   30,    0,    0,    0,
    0,    0,  335,   32,  265,    0,  335,    0,   33,   47,
   71,   72,   34,    0,  593,    0,    0,    0,    0,  335,
    0,  594,    0,    0,   36,    0,   37,   74,    0,    0,
   38,    0,    0,   76,    0,   78,    0,   80,   39,   40,
  254,    0,   41,    0,    0,    0,    0,    0,    0,  595,
    0,  335,   87,   88,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,   89,   90,   91,
   92,   93,    0,    0,    0,    0,    0,    0,    0,   95,
  927,    0,  596,    0,    0,   97,   98,   99,  100,    0,
    0,    0,  101,    0,  102,    0,    0,    0,    0,    0,
  103,  104,    0,    0,    0,    0,    0,    0,   56,   24,
    0,   25,    0,    0,   26,  253,    0,    0,    0,   27,
   61,   62,    0,   28,    0,  105,  106,  107,  108,   64,
    0,    0,   30,    0,    0,    0,    0,    0,    0,   32,
    0,    0,    0,    0,   33,    0,   71,   72,   34,    0,
  593,    0,    0,    0,    0,    0,    0,  594,    0,    0,
   36,    0,   37,   74,    0,    0,   38,    0,    0,   76,
    0,   78,    0,   80,   39,   40,  254,    0,   41,    0,
    0,    0,    0,    0,    0,  595,    0,    0,   87,   88,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,   89,   90,   91,   92,   93,    0,    0,
    0,    0,    0,    0,    0,   95,    0,    0,  596,    0,
    0,   97,   98,   99,  100,    0,    0,    0,  101,    0,
  102,    0,    0,    0,    0,    0,  103,  104,    0,    0,
    0,    0,    0,    0,   56,   24,    0,   25,    0,    0,
   26,  253,    0,    0,    0,   27,   61,   62,    0,   28,
    0,  105,  106,  107,  108,   64,    0,    0,   30,    0,
    0,    0,    0,    0,    0,   32,    0,    0,    0,    0,
   33,    0,   71,   72,   34,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,   36,    0,   37,   74,
    0,    0,   38,    0,    0,   76,    0,   78,    0,   80,
   39,   40,  254,    0,   41,    0,    0,   84,    0,    0,
    0,   86,    0,    0,   87,   88,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,   89,
   90,   91,   92,  302,    0,    0,    0,    0,    0,    0,
    0,   95,    0,    0,    0,    0,    0,   97,   98,   99,
  100,    0,    0,    0,  101,    0,  102,    0,    0,    0,
    0,    0,  103,  104,    0,    0,    0,    0,    0,    0,
   56,   24,    0,   25,    0,    0,   26,  253,    0,    0,
    0,   27,   61,   62,    0,   28,    0,  105,  303,  107,
  108,   64,    0,    0,   30,    0,    0,    0,    0,    0,
    0,   32,    0,    0,    0,    0,   33,    0,   71,   72,
   34,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,   36,    0,   37,   74,    0,    0,   38,    0,
    0,   76,    0,   78,    0,   80,   39,   40,  254,    0,
   41,    0,    0,    0,    0,    0,    0,   86,    0,    0,
   87,   88,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,   89,   90,   91,   92,  302,
    0,    0,    0,    0,  886,    0,    0,   95,    0,    0,
    0,    0,    0,   97,   98,   99,  100,    0,    0,    0,
  101,    0,  102,    0,    0,    0,    0,    0,  103,  104,
    0,    0,    0,    0,    0,    0,   56,   24,    0,   25,
    0,    0,   26,  253,    0,    0,    0,   27,   61,   62,
    0,   28,    0,  105,  303,  107,  108,   64,    0,    0,
   30,    0,    0,    0,    0,    0,    0,   32,    0,    0,
    0,    0,   33,    0,   71,   72,   34,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,   36,    0,
   37,   74,    0,    0,   38,    0,    0,   76,    0,   78,
    0,   80,   39,   40,  254,    0,   41,    0,    0,    0,
    0,    0,    0,   86,    0,    0,   87,   88,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,   89,   90,   91,   92,  302,    0,    0,    0,  518,
    0,    0,    0,   95,    0,    0,    0,    0,    0,   97,
   98,   99,  100,    0,    0,    0,  101,    0,  102,    0,
    0,    0,    0,    0,  103,  104,    0,    0,    0,    0,
    0,    0,   56,   24,    0,   25,    0,    0,   26,  253,
    0,    0,    0,   27,   61,   62,    0,   28,    0,  105,
  303,  107,  108,   64,    0,    0,   30,    0,    0,    0,
    0,    0,    0,   32,    0,    0,    0,    0,   33,    0,
   71,   72,   34,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,   36,    0,   37,   74,    0,    0,
   38,    0,    0,   76,    0,   78,    0,   80,   39,   40,
  254,    0,   41,    0,    0,    0,    0,    0,    0,   86,
    0,    0,   87,   88,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,   89,   90,   91,
   92,  302,    0,    0,    0,  512,    0,    0,    0,   95,
    0,    0,    0,    0,    0,   97,   98,   99,  100,    0,
    0,    0,  101,    0,  102,    0,    0,    0,    0,    0,
  103,  104,    0,    0,    0,    0,    0,    0,   56,   24,
    0,   25,    0,    0,   26,  253,    0,    0,    0,   27,
   61,   62,    0,   28,    0,  105,  303,  107,  108,   64,
    0,    0,   30,    0,    0,    0,    0,    0,    0,   32,
    0,    0,    0,    0,   33,    0,   71,   72,   34,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
   36,    0,   37,   74,    0,    0,   38,    0,    0,   76,
    0,   78,    0,   80,   39,   40,  254,    0,   41,    0,
    0,    0,    0,    0,    0,   86,    0,    0,   87,   88,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,   89,   90,   91,   92,  302,    0,    0,
    0,    0,    0,    0,    0,   95,    0,    0,    0,    0,
    0,   97,   98,   99,  100,    0,    0,    0,  101,    0,
  102,    0,    0,    0,    0,    0,  103,  104,    0,    0,
    0,    0,    0,    0,   56,   24,    0,   25,    0,    0,
   26,  253,    0,    0,    0,   27,   61,   62,    0,   28,
    0,  105,  303,  107,  108,   64,    0,    0,   30,    0,
    0,    0,    0,    0,    0,   32,    0,    0,    0,    0,
   33,    0,   71,   72,   34,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,   36,    0,   37,   74,
    0,    0,   38,    0,    0,   76,    0,   78,    0,   80,
   39,   40,  254,    0,   41,    0,    0,    0,    0,    0,
    0,   86,    0,    0,   87,   88,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,   89,
   90,   91,   92,   93,    0,    0,    0,    0,    0,    0,
    0,   95,    0,    0,    0,    0,    0,   97,   98,   99,
  100,    0,    0,    0,  101,    0,  102,    0,    0,    0,
    0,    0,  103,  104,    0,    0,    0,    0,    0,    0,
   56,   24,    0,   25,    0,    0,   26,  253,    0,    0,
    0,   27,   61,   62,    0,   28,    0,  105,  106,  107,
  108,   64,    0,    0,   30,    0,    0,    0,    0,    0,
    0,   32,    0,    0,    0,    0,   33,    0,   71,   72,
   34,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,   36,    0,   37,   74,    0,    0,   38,    0,
    0,   76,    0,   78,    0,   80,   39,   40,  254,    0,
   41,    0,    0,    0,    0,    0,    0,   86,    0,    0,
   87,   88,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,   89,   90,   91,   92,   93,
    0,    0,    0,    0,    0,    0,    0,   95,    0,    0,
    0,    0,    0,   97,   98,   99,  100,    0,    0,    0,
  101,    0,  102,    0,    0,    0,    0,    0,  103,  104,
    0,    0,    0,    0,    0,    0,   77,   77,    0,   77,
    0,    0,   77,   77,    0,    0,    0,   77,   77,   77,
    0,   77,    0,  105, 1041,  107,  108,   77,    0,    0,
   77,    0,    0,    0,    0,    0,    0,   77,    0,    0,
    0,    0,   77,    0,   77,   77,   77,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,   77,    0,
   77,   77,    0,    0,   77,    0,    0,   77,    0,   77,
    0,   77,   77,   77,   77,    0,   77,    0,    0,    0,
    0,    0,    0,   77,    0,    0,   77,   77,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,   77,   77,   77,   77,   77,    0,    0,    0,    0,
    0,    0,    0,   77,    0,    0,    0,    0,    0,   77,
   77,   77,   77,    0,    0,    0,   77,    0,   77,    0,
    0,    0,    0,    0,   77,   77,    0,    0,    0,    0,
    0,    0,  135,  135,    0,  135,    0,    0,  135,  135,
    0,    0,    0,  135,  135,  135,    0,  135,    0,   77,
   77,   77,   77,  135,    0,    0,  135,    0,    0,    0,
    0,    0,    0,  135,    0,    0,    0,    0,  135,    0,
  135,  135,  135,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,  135,    0,  135,  135,    0,    0,
  135,    0,    0,  135,    0,  135,    0,  135,  135,  135,
  135,    0,  135,    0,    0,    0,    0,    0,    0,  135,
    0,    0,  135,  135,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,  135,  135,  135,
  135,  135,    0,    0,    0,    0,    0,    0,    0,  135,
    0,    0,    0,    0,    0,  135,  135,  135,  135,    0,
    0,    0,  135,    0,  135,    0,    0,    0,    0,    0,
  135,  135,    0,    0,    0,    0,    0,    0,   56,   24,
    0,   25,    0,    0,   26,  253,    0,    0,    0,   27,
   61,   62,    0,   28,    0,  135,  135,  135,  135,   64,
    0,    0,   30,    0,    0,    0,    0,    0,    0,   32,
    0,   27,    0,    0,   33,    0,   71,   72,   34,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
   36,    0,   37,   74,   27,    0,   38,    0,    0,   76,
    0,   78,    0,   80,   39,   40,  254,   27,   41,    0,
    0,    0,   27,    0,    0,    0,    0,   27,    0,   27,
   27,   27,   27,    0,    0,   27,    0,   27,    0,    0,
    0,   27,    0,   89,   90,   91,  255,  302,    0,    0,
    0,    0,    0,   27,    0,   95,   27,    0,   27,    0,
    0,   97,   98,   99,  100,    0,    0,    0,  101,    0,
  102,    0,    0,    0,    0,    0,  103,  104,    0,    0,
    0,    0,   27,    0,    0,    0,    0,    0,   27,   27,
    0,    0,    0,    0,    0,    0,  641,    0,  641,    0,
  641,  105,  256,  641,  108,  641,  641,    0,  641,    0,
  641,    0,  641,    0,  641,  641,  641,    0,    0,    0,
  641,  641,    0,    0,    0,    0,  641,    0,  641,  641,
    0,    0,    0,  641,    0,    0,    0,  641,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,  641,  641,
    0,  641,    0,    0,    0,  641,  641,    0,    0,    0,
    0,    0,    0,  641,  641,   56,   24,  641,   25,    0,
  641,   26,  253,    0,    0,  641,   27,   61,   62,    0,
   28,    0,    0,    0,    0,    0,   64,    0,    0,   30,
    0,    0,    0,    0,    0,    0,   32,  641,  641,    0,
    0,   33,    0,   71,   72,   34,    0,    0,    0,    0,
  641,    0,    0,    0,    0,    0,    0,   36,    0,   37,
   74,    0,    0,   38,    0,    0,   76,    0,   78,    0,
   80,   39,   40,  254,    0,   41,    0,    0,   84,    0,
    0,    0,    0,    0,    0,   24,    0,   25,    0,    0,
   26,  641, 1228,    0,    0,   27,    0,    0,    0,   28,
   89,   90,   91,  255,    0,    0,    0,    0,   30,  640,
    0,  640,   95,    0,  640,   32,  640,  640,    0,  640,
   33,  640, 1229,  640,   34,  640,  640,  640,    0,    0,
    0,  640,  640,    0,    0,    0,   36,  640,   37,  640,
  640,    0,   38, 1230,  640,    0,    0,    0,  640,    0,
   39,   40,    0,    0,   41,    0,    0,  322,  105,  256,
  640,    0,  640,    0,    0,    0,  640,  640,    0,    0,
    0,    0,    0,    0,  640,  640,    0,  640,  640,  640,
    0,  640,  640,    0,  640,  640,  640,  640,    0,  640,
    0,  640,    0,  640,  640,  640,    0,    0,    0,  640,
  640,    0,    0,    0,    0,  640,    0,  640,  640,    0,
    0,    0,  640,    0,    0,    0,  640,    0,    0,    0,
    0,  640,    0,    0,    0,    0,    0,    0,  640,    0,
  640,    0,    0,    0,  640,  640,    0,    0,  355,    0,
    0,    0,  640,  640,    0,    0,  640,    0,    0,  640,
    0,   24,    0,   25,  640,    0,   26,    0,    0, 1290,
    0,   27,  640,  686,    0,   28,    0,  687, 1291, 1292,
    0,    0,    0, 1293,   30,    0,    0,    0,    0, 1294,
    0,   32,    0,   24,    0,   25,   33,    0,   26,    0,
   34, 1290,    0,   27,    0,  686,    0,   28,    0,  687,
 1291, 1292,   36,    0,   37, 1293,   30,    0,   38,    0,
    0, 1294,    0,   32,    0,    0,   39,   40,   33,    0,
   41,    0,   34, 1295,    0,    0,    0,   47, 1296,   47,
  640,    0,   47,    0,   36,    0,   37,   47,    0,    0,
   38,   47,    0,    0,    0,    0,    0,    0,   39,   40,
   47,    0,   41,    0,    0, 1295,    0,   47,    0,   47,
 1296,   47,   47, 1297,   47,    0,   47,    0,   47,   47,
   47,    0,    0,   47,    0,   47,    0,    0,   47,    0,
   47,    0,   47,    0,   47,    0,    0,   47,    0,   47,
    0,    0,   47,   47,   47,    0,   47,    0,   47,   47,
   47,    0,   47,   48, 1298,   48,    0,   47,   48,    0,
   47,    0,   47,   48,    0,    0,   47,   48,    0,   47,
    0,    0,    0,    0,   47,   47,   48,    0,   47,    0,
    0,   47,    0,   48,  154,   47, 1298,   47,   48,    0,
   47,    0,   48,    0,   48,   47,   48,    0,    0,   47,
    0,   48,    0,    0,   48,    0,   48,    0,   47,    0,
   48,    0,    0,   48,  154,   47,    0,    0,   48,   48,
   47,    0,   48,    0,   47,   48,   47,    0,   47,   24,
   47,   25,    0,   47,   26,    0,   47,    0,   47,   27,
    0,    0,   47,   28,    0,   47,    0,    0,    0,    0,
   47,   47,   30,    0,   47,    0,    0,   47,    0,   32,
    0,    0,   47,    0,   33,    0,    0,    0,   34,    0,
  570,    0,    0,    0,   24,    0,   25,  571,    0,   26,
   36,    0,   37,    0,   27,    0,   38,    0,   28,  572,
    0,    0,   29,    0,   39,   40,    0,   30,   41,    0,
    0,  573,   31,    0,   32,    0,   48,    0,    0,   33,
    0,    0,    0,   34,   35,    0,    0,    0,   24,    0,
   25,    0,    0,   26,    0,   36,    0,   37,   27,    0,
    0,   38,   28,    0,    0,    0,    0,    0,   47,   39,
   40,   30,  174,   41,  174,    0,    0,  174,   32,    0,
    0,    0,  174,   33,    0,    0,  174,   34,    0,    0,
    0,    0,    0,    0,    0,  174,    0,    0,    0,   36,
    0,   37,  174,    0,    0,   38,    0,  174,    0,    0,
    0,  174,  574,   39,   40,    0,    0,   41,    0,    0,
  322,    0,    0,  174,    0,  174,  184,    0,  184,  174,
    0,  184,    0,    0,    0,    0,  184,  174,  174,    0,
  184,  174,    0,    0,  174,    0,  291,    0,    0,  184,
    0,    0,    0,    0,    0,    0,  184,   42,    0,    0,
    0,  184,    0,    0,   33,  184,    0,    0,    0,    0,
    0,    0,    0,    0,    0,   33,    0,  184,    0,  184,
   33,    0,    0,  184,   33,    0,    0,   33,    0,    0,
    0,  184,  184,    0,    0,  184,    0,    0,  184,   33,
   33,  323,    0,    0,   33,   33,    0,    0,    0,    0,
   33,    0,   33,   33,   33,   33,    0,    0,    0,    0,
   33,    0,    0,    0,   33,  174,   33,    0,    0,    0,
    0,    0,    0,    0,    0,    0,   33,    0,   33,   33,
   31,   33,    0,    0,    0,   33,    0,    0,    0,    0,
    0,   31,    0,    0,    0,    0,   31,    0,    0,    0,
   31,    0,    0,   31,    0,   33,    0,    0,    0,    0,
    0,   33,   33,    0,    0,   31,   31,    0,    0,  184,
   31,   31,   27,    0,   27,    0,   31,    0,   31,   31,
   31,   31,    0,    0,    0,    0,   31,    0,    0,    0,
   31,    0,   31,    0,    0,   27,    0,    0,    0,    0,
    0,    0,   31,    0,    0,   31,    0,   31,   27,    0,
    0,   31,    0,   27,    0,    0,    0,    0,   27,    0,
   27,   27,   27,   27,    0,    0,    0,    0,   27,    0,
    0,   31,   27,    0,    0,   47,    0,   31,   31,    0,
    0,    0,    0,    0,   27,    0,   47,   27,    0,   27,
    0,   47,    0,    0,    0,   47,    0,    0,   47,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
   47,   47,    0,   27,    0,   47,   47,    0,   47,   27,
   27,   47,    0,   47,   47,   47,   47,    0,    0,   47,
    0,   47,    0,    0,   47,   47,    0,   47,   47,    0,
    0,   47,    0,    0,    0,    0,    0,   47,    0,    0,
   47,    0,   47,   47,   47,    0,   47,    0,   47,   47,
   47,    0,    0,    0,   47,    0,   47,   47,   47,   47,
    0,    0,    0,    0,   47,    0,   47,    0,   47,    0,
   47,    0,   35,   47,    0,    0,    0,    0,    0,    0,
   47,    0,    0,   47,    0,   47,   47,    0,   47,   47,
    0,   47,    0,    0,    0,    0,   47,    0,   47,   47,
   47,   47,    0,    0,    0,    0,   47,    0,    0,   47,
   47,   47,    0,    0,    0,   36,    0,    0,    0,    0,
    0,    0,   47,    0,   47,   47,   47,   47,    0,   47,
    0,    0,    0,    0,   47,    0,   47,   47,   47,   47,
    0,    0,    0,    0,   47,    0,    0,    0,   47,   47,
    0,   47,    0,   47,   47,    0,    0,  196,    0,    0,
   47,    0,   47,   47,   47,   47,   47,   47,    0,    0,
    0,    0,   47,    0,   47,   47,   47,   47,    0,    0,
   47,    0,   47,    0,    0,    0,   47,   47,    0,   47,
    0,   47,   47,    0,    0,  198,    0,    0,   47,    0,
   47,   47,   47,   47,   47,   47,    0,    0,    0,    0,
   47,    0,   47,   47,   47,   47,    0,    0,    0,    0,
   47,    0,    0,    0,   47,   47,    0,   47,    0,    0,
    0,    0,  453,  299,    0,    0,   47,    0,   47,   47,
    0,   47,    0,   47,    0,    0,    0,    0,   47,    0,
   47,   47,   47,   47,    0,  454,   47,    0,   47,    0,
    0,    0,   47,    0,  453,   47,    0,    0,  455,    0,
    0,  300,  456,  457,   47,    0,    0,   47,  458,   47,
  459,  460,  461,  462,    0,    0,    0,  454,  463,    0,
    0,    0,  464,    0,    0,    0,    0,    0,    0,    0,
  455,    0,    0,   47,  465,  457,    0,  466,    0,  467,
  458,    0,  459,  460,  461,  462,    0,    0,    0,    0,
  463,    0,    0,    0,  464,    0,    0,    0,    0,    0,
    0,    0,    0,  468,    0,    0,  465,    0,    0,  466,
    0,  467,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,  468,
  };
  protected static readonly short [] yyCheck = {            17,
  516,    4,   51,   17,  300,  234,    6,   51,   18,  189,
  247,   17,  518,   17,  354,  470,  289,  188,  232,  299,
   84,   68,   20,  492,  339,   59,  321,  157,  559,  332,
  354,   59,  780,  296,  298,  747,  645,  646,  576,  934,
   87,   88,   87,   88,   58,   92, 1145, 1146,   47,  113,
 1110,  115,  191,  584,    0,   73,  721,   77,  723,   77,
  256, 1235,   17,  108,  328,   79,  256,   81,  939,  256,
  113,  256,  115,  256,  256,  256,  325,   95,  268, 1253,
  256,  256,  363, 1193,  256,  277,  282,  372,  369,  374,
  256,  256,  335,  256,  256, 1194,  368,  256,   17,  256,
   17,   17,  767, 1213, 1219,  770,  256,   17,  256,  256,
  268, 1442, 1443,  268,  376,  371,  382,  383,  314,  418,
  394,  395,  370,  371,  414,  172,  374,  665,   17,  428,
  396,  397,  369,   17,   17,    0, 1105,  418,  428,  157,
  189,   17,   17,  157,  429,  189,  418,  411,   17, 1264,
   17,  157,  339,  157,  199,  200,  257,  344,  256,  346,
  343,  294,  349,  350,  420,  352,  353,  429, 1499,  418,
   59,  363,  256,  306,   63,  256,  256,  268,  363,  256,
  789,  256,  358,  232,  323,  276,  429,  374,  232,  256,
  256,  256,  532,  340, 1304, 1066,    0,  372, 1308,  381,
  247,  367,  157,  369,  363,  371,  435,  816,  391,  512,
  368,  370,  259,  372,  554,  374,  355,  262,  724,  381,
  434,  360,  418, 1333,  223,  375,  418,  419,  228,  247,
  554,  414,  422,  418,  252,  515,  576,  418,  157, 1413,
  157,  157,  429,  288,  559,  428,  418,  157,  424,  425,
  426,  427,  286,  418,  420,  418,  320,  423,  286,  418,
  324,  418,  296,  308,  422,  329, 1440,  422,  157,  584,
  418,  289,  363,  157,  157, 1023,  294,  295, 1452,  326,
 1454,  157,  157,  381,  331,  418,  329,  367,  157,  317,
  157,  309,  376,  256,  375,  256,  376,  315,  375,  317,
  375,  440,  316,  321,  370,  370,  351,  374,  374,  374,
  910,  257,  256,  256,  256,  333,  334,  256,  256,  358,
  256,  372,  369,  370,  372,  665,  256,  418, 1040,  867,
  372,  996,  941,  339,  943,  339,  475,  946,  358,  368,
  358, 1089,  666,  388,  389,  256,  686, 1407,  325,  256,
  262,  369,  370,  368,  363,  368,  374,  375,  376,  377,
  378,  379,  380,  381,  382,  383,  384,  357,  263,  416,
  417,  416,  417,  420, 1473,  256, 1345,  256,  429,  374,
  257,  429,  256,  373,  256,  434,  298,  429,  406,  374,
  434,  256,   20,  367,  900,  444,  386,  286, 1293,  341,
  429,  363,  376,  418, 1503, 1374, 1375,  368, 1377,  418,
  879,  374,  294,  374,  709, 1015,  429, 1017,  368, 1388,
  315,  416, 1391, 1032,  368, 1034, 1035,  369,  317,  372,
  374,  416,  371,  662,  372,  574,  372, 1406,  436,  369,
  484,  418,  441,  442,  491,  256,  493,  586,  447,  588,
  339,  590,  450,  257,  794, 1120,  418,  694,  369,   87,
   88, 1430, 1127,  726,  492,  372,  378,  379,  272,  516,
  794,  485,  701,  277,  339,  357,  256,  281,  277,  429,
  108,  363,  281,  266,  990,  532, 1151,  369,  369,  536,
  372,  373,  296,  372,  263,  369,  514,  369,  516,  266,
  518,  372,  367,  343,  386,  368,  371,  368,  373,  374,
  375,  376,  368,  376,  528,  529,  381,  656,  368,  323,
  341,  256, 1131,  401,  542,  306,  370,  867,  575,  547,
  374,  314,  313,  294,  532,  413,  418,  676,  342,  421,
 1205,  381,  866,  342,  363,  306,  315,  314,  369,  256,
  369,  391,  566,  559, 1163,  559,  367,  363,  429,  294,
  371,  256,  373,  374,  256,  376,  429,  256,  429,  363,
  381,  199,  200,  429,  414,  593,  594,  814,  584,  429,
  584,  343,  369,  335,  864,  256,  373,  367,  428, 1311,
  893,  371,  375,  373,  374,  642,  376,  644, 1207,  418,
  343,  381, 1324,  492,  415,  735,  653,  372,  375,   21,
  367, 1219,  418,  305,  371, 1224,  305,  418,  391,  381,
 1219, 1343,  640,  305,  418, 1156,  272,  645,  646,  391,
  648,  277,  339,  897,  262,  281,  423,  344,  934,  346,
   52,  414,  349,  350,  339,  352,  353,  694,  391,  344,
  296,  346,  414,  418,  349,  350, 1264,  352,  353,  371,
  288,  373,  256,  420,  711, 1264,  428,  374,  339,  272,
  559,  414,  300,  344,  357,  346,  694,  323,  349,  350,
  308,  352,  353, 1152, 1219,  428,  369,  687,  272,  372,
  373,  709,  726,  296,  758,  584,  342,  256,  993, 1219,
  256,  305, 1219,  386,  272, 1219,  724,  752,  264,  339,
  269,  729,  296,  339,  761,  373,  373,  414, 1219,  376,
  323,  958,  429,  351,  256, 1005,  354,  286,  296, 1264,
  775,  428,  390,  391,  429,  369,  357,  367,  421,  323,
  754,  367,  363,  357, 1264,  790,  793, 1264,  369,  376,
 1264,  372,  373,  374,  772,  323,  774,  888,  429,  256,
  388,  389,  809, 1264,  778,  386,  780,  814,  899,  325,
  909,  789,  386,  367,  368,  369,  376,  371,  372,  950,
  374,  368,  376,  381,  269, 1218, 1219,  374,  416,  417,
  371,  809,  841,  391,  381,  367,  814,  418,  816,  357,
  818,  286,  391,  381, 1077,  256, 1239,  339,  436, 1124,
  398,  399,  344,  391,  346,  373,  414,  349,  350,  357,
  352,  353,  450,  868,  418,  414,  420,  871,  386,  423,
 1110, 1264,  721, 1266,  723,  373,  414,  368,  369,  428,
 1113, 1156,  339,  386,  862,  991,  864,  344,  386,  346,
  428,  849,  349,  350,  854,  352,  353,  904,  418,  906,
  306,  371,  308,  881,  306,  912, 1103,  313,  428, 1324,
  888,  313,  339, 1019, 1189, 1014, 1149,  367,  767,  325,
  898,  770,  900,  325,  373,  418,  376,  376,  339, 1395,
  937,  369,  371,  344,  373,  346,  256,  429,  349,  350,
  367,  352,  353,  381,  532,  379,  367,  368,  367,  376,
  367,  958,  384,  392,  393,  376,  368,  376,  963,  376,
  367,  368,  367,  941,  376,  943,  554,  974,  946,  376,
  368,  376,  429,  412, 1274,  256,  374,  385,  376,  368,
  958,  420, 1282,  372,  423,  374,  368,  376,  576,  389,
  372, 1457, 1166, 1226,  376,  370,  400,  955,  368,  374,
 1140,  371,  368,  373,  374,  965,  372,  967,  374,  969,
  376,  373,  990,  368,  376,  993,  370,  390,  429,  339,
  374,  376,  392,  393,  344,  369,  346,  370, 1494,  349,
  350,  374,  352,  353,  418,  372,  374, 1293,  376,  376,
 1516, 1517,  412,  381,  261,  354,  355, 1236,  372, 1023,
  420,  372,  376,  423, 1032,  376, 1034, 1035,  339, 1037,
  372,  371,  374,  344,  376,  346,  415,  284,  349,  350,
    6,  352,  353,  418,  370,  370,  372,  665,  374,  374,
  297,   17,  372,  256, 1047,  302,  376,  370,  305,  372,
  307,  374,  309,  310,  311,  312, 1103,  277,  686, 1077,
  317, 1105,  370,  371,  321,  373,  374,  375,  325,  429,
  386,  387,  388, 1091, 1092, 1089,  333,  369,  418,  336,
  372,  338,  371,   59,  373, 1103,  367,   63,  369,  354,
  355, 1140, 1110, 1142, 1104, 1113, 1140,  394,  395,  396,
  397,  372,  372,  374,  374,  362,  370,  996,  372,  367,
  368,   87,   88, 1131,  374,  376,  376, 1166, 1124, 1137,
 1124,  370, 1166,  372,  752,  376,  370, 1407,  372,  367,
  367, 1149,  108,  371,  373,  373,  374,  370,  376,  372,
  372,  294,  374,  381,  294, 1163, 1164,  775, 1197,  372,
 1156,  374, 1156,  370,  370,  372,  372,  364,  365, 1298,
  343,  418,  790,  374,  376,  376,  794,  368,  369, 1218,
 1219,  374, 1217,  376, 1218,  372,  374,  415,  376,  414,
  415,  157, 1321, 1189,  374, 1189,  376,  372,  373, 1207,
 1239,  364,  365, 1108, 1109, 1239, 1335,  392,  393,  398,
  399,  376,  376,  418,  414,  356, 1224,  369, 1226,  418,
   59,  375,  418,  372, 1353, 1264, 1355, 1266,  372,  376,
 1267,  849, 1266,  199,  200,  368,  374,  372, 1273,  294,
  372, 1120,  294,  374,  372, 1124,  372,  374, 1127,  867,
  868,  372,  376,  371,   93, 1290, 1291,  256,   97,   98,
   99,  100,  101,  102,  103,  104,  374,  294,  294,  381,
  372,  374, 1151,  373, 1278,  373,  375, 1156, 1313,   61,
  374, 1316,  418,   65,   66,   67,  381,   69,   70,  372,
  374,  372,   74,   75,  374,  374,  262,  374,  423,   81,
  429,   83,  374,   85,  367,  421,  372,  372,   90,   91,
 1189, 1345,  373,  343,  374,  294,  934,  294,  374,  370,
  286,  418,  288,  371,  367, 1329, 1205,  418,  375,  256,
  256,  256,  114,  374,  300,  256,  381,  955,  280,  256,
 1374, 1375,  308, 1377,  367,  963, 1385,  368,  372,  343,
  368,  317,  371,  371, 1388,  373,  374, 1391,  351,  370,
  376,  374,  374, 1402,  372,  370,  376,  381,  372,  372,
  423,  347, 1406,  339,  392,  393, 1415, 1416,  367,  381,
  381,  256,  256,  347,  372,  351,  372, 1395,  354, 1393,
  368,  376,  374,  339,  412,  370, 1430,  370,  370, 1407,
  348,  375,  420, 1442, 1443,  423,  368,  372,  348,  418,
  368,  374,  418,  372,  367,  376, 1424,  367,  261,  368,
  367,  381,  388,  389,  356,  376,  371,  368,  337,   93,
  374,  368,  368,   97,   98,   99,  100,  101,  102,  103,
  104,  284,  372,  305,  367,  369,  374,  286,  418, 1457,
  416,  417,  371,  371,  297,  371,  376,  296,  371,  302,
 1499,  418,  305,  302,  307,  373,  309,  310,  311,  312,
  381,  371,  254,  367,  317,  257,  371,  381,  321, 1516,
 1517,  369,  325,  418,  418,  418, 1494,  371,  373,  372,
  333,  372,  374,  336,  373,  338, 1500, 1501,  374,  256,
  372,  374,  372, 1507, 1508,  376,  418,  370, 1516, 1517,
  376,  418,  418,  372,  381,  376,  298,  418,  376,  362,
  372,  367,  372,  368,  381, 1143,  492,  368,  370,  256,
  315,  313,  372,  263,  373,  371,  261,  371,  368,  372,
  372,    0,    0,  367,  372,  376,  385,  386,  387,  368,
    0,  390,  391,  368,  372,  372,  370,  367,  418,  284,
  368,  368,    0,  372,  370,  367,  532,  418,  368,  418,
  373,  376,  297,  372,  368,  418,  372,  302,  376,  376,
  372, 1199,  307,  376,  309,  310,  311,  312,  554,  368,
  367,  372,  317,  559,  368,  368,  321,  372,  376, 1217,
  367,  315,  263,   50,  376,  376,  376,  376,  333,   12,
  576,  336,  339,  338,  376,  376,  376,  344,  584,  346,
  347,  348,  349,  350,  351,  352,  353,  354,  355,  356,
  376,    5,  955,  849, 1266, 1447, 1103,  362,  302,  364,
  365,  368, 1103,  370, 1239,  372, 1410,  374,  375,  376,
  686, 1427, 1398, 1463, 1393, 1273, 1274, 1299,  700,  871,
  871, 1311,  871,  390, 1282,    0, 1508, 1264,  332, 1252,
 1330,  866, 1290, 1291,  401, 1293, 1502, 1420,  256, 1416,
 1415, 1299, 1501, 1197, 1355, 1299,  413, 1199,  841,  381,
  729,  814,  809, 1311,  532, 1313,  594,  369, 1316,  665,
 1005,  893,  429,  694,   71,  487, 1324,  335,  401,  373,
  402,  403,  404,  405,  406,  407,  408,  409,  410,  411,
  686,  385,  386,  387,  400, 1343,  390,  391,  392,  393,
  394,  395,  396,  397,  398,  399,  400,  401,  402,  403,
  404,  405,  581,  726,  402,  404,  528,  403,  405, 1178,
  794,  157, 1124,  554, 1273,  721, 1189,  723, 1068,  992,
 1092,  339, 1019, 1080, 1082, 1152,  344,  530,  346,  347,
  348,  349,  350,  351,  352,  353,  354,  355,  356,  425,
  914,  425,  976,  651, 1269,  847,  752, 1164,  846,   -1,
  368,   -1,  370,   -1,  372,   -1,  374,  375,  376,   -1,
   -1,  767,   -1,   -1,  770,   -1,   -1,   -1,   -1,  775,
   -1,   -1,  390,   -1,   -1,   -1,   -1,   -1,  256,  257,
   -1,   -1,   -1,  261,  790,   -1,   -1,  265,  794,  267,
   -1,   -1,  270,   -1,  272,  273,    0,  275,   -1,  277,
   -1,  279,   -1,  281,  282,  283,  284,   -1,  512,  287,
  288,  429,   -1,   -1,   -1,  293,   -1,  295,  296,  297,
   -1,   -1,  300,  301,  302,   -1,  304,   -1,   -1,  307,
   -1,  309,  310,  311,  312,   -1,   -1,   -1,  316,  317,
  318,   -1,   -1,  321,  322,  323,   -1,  726,   -1,   -1,
   -1,   -1,  330,  331,   -1,  333,  334,   -1,  336,  337,
  338,  867,  868,   -1,  342,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  581,   -1,   -1,
   -1,  256,   -1,   -1,  362,    0,  261,  262,   -1,   -1,
  368,  369,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  377,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  284,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  297,  298,   -1,   -1,   -1,  302,  934,   -1,
  305,   -1,  307,   -1,  309,  310,  311,  312,   -1,   -1,
  418,   -1,  317,   -1,   -1,   -1,  321,   -1,   -1,   -1,
  325,   -1,   -1,   -1,   -1,   -1,   -1,  963,  333,   -1,
   -1,  336,   -1,  338,  339,   -1,   -1,   -1,   -1,  344,
   -1,  346,  347,  348,  349,  350,  351,  352,  353,  354,
  355,  356,   -1,   -1,   -1,   -1,   -1,  362,  363,   -1,
  996,   -1,  367,  368,   -1,  370,  371,  372,  373,  374,
  375,  376,   -1,  378,  379,   -1,  381,  382,  383,  384,
  385,  386,  387,  388,  389,  390,   -1,  392,  393,  394,
  395,  396,  397,  398,  399,  400,  401,  402,  403,  404,
  405,  406,  407,  408,  409,  410,  411,  412,  413,   -1,
   -1,  416,   -1,  418,   -1,  420,   -1,    0,  423,   -1,
   -1,   -1,   -1,  257,  429,   -1,   -1,  261,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  272,   -1,
   -1,   -1,   -1,  277,   -1,   -1,   -1,  281,   -1,   -1,
  284,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  296,  297,   -1,   -1,   -1,  301,  302,   -1,
   -1,   -1,   -1,  307,   -1,  309,  310,  311,  312,   -1,
   -1,   -1,   -1,  317, 1120,   -1,   -1,  321, 1124,  323,
   -1, 1127,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  333,
   -1,  335,  336,   -1,  338,   -1,   -1, 1143,  342,   -1,
   -1,   -1,  257,  256,   -1, 1151,  261,   -1,   -1,   -1,
 1156,   -1,   -1,   -1,   -1,   -1,   -1,  272,  362,   -1,
   -1,   -1,  277,   -1,  368,  369,  281,   -1,   -1,  284,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  296,  297, 1189,   -1,   -1,  301,  302,   -1,  893,
   -1,   -1,  307, 1199,  309,  310,  311,  312,   -1, 1205,
   -1,   -1,  317,   -1,   -1,   -1,  321,   -1,  323,   -1,
   -1, 1217,   -1,   -1,    0,   -1,   -1,   -1,  333,   -1,
  335,  336,   -1,  338,   -1,   -1,  339,  342,   -1,   -1,
   -1,  344,   -1,  346,  347,  348,  349,  350,  351,  352,
  353,  354,  355,  356,   -1,   -1,   -1,  362,   -1,   -1,
   -1,   -1,   -1,   -1,  369,  368,   -1,  370,   -1,  372,
   -1,  374,  375,  376,   -1,   -1,   -1, 1273, 1274,   -1,
   -1,   -1,   -1,   -1,   -1,   -1, 1282,  390,   -1,   -1,
   -1,   -1,   -1,   -1, 1290, 1291,   -1, 1293,  401,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  413,   -1,   -1,  256,  257,   -1,   -1, 1313,   -1,   -1,
 1316,  264,  265,  266,  267,  268,  429,  270,  271,   -1,
  273,  274,  275,  276,  277,  278,  279,  280,   -1,   -1,
   -1,   -1,  285,   -1,  287,  288,  289,  290,  291,  292,
    0,   -1,  295,   -1,   -1,   -1,  299,  300,   -1,  302,
  303,  304,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  314,   -1,  316,   -1,  318,  319,   -1,   -1,  322,
   -1,  324,  325,  326,  327,  328,  329,  330,  331,  332,
  333,  334,  335,   -1,  337,   -1,   -1,  340,  341,   -1,
   -1,  344,  345,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  359,  360,  361,  362,
  363,   -1,   -1,   -1,  367,  368,   -1,   -1,  371,   -1,
   -1,   -1,   -1,  376,  377,  378,  379,  380,   -1,   -1,
   -1,  384,   -1,  386,   -1,   -1,   -1,   -1,   -1,  392,
  393,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  417,  418,  419,  420,   -1,  422,
  256,  257,   -1,   -1,   -1,   -1,  429,   -1,  264,  265,
  266,  267,  268,   -1,  270,  271,    0,  273,  274,  275,
  276,  277,  278,  279,   -1,   -1,   -1,   -1,   -1,  285,
   -1,  287,  288,  289,  290,  291,  292,   -1,   -1,  295,
   -1,   -1,   -1,  299,  300,   -1,  302,  303,  304,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  314,   -1,
  316,   -1,  318,  319,   -1,   -1,  322,   -1,  324,  325,
  326,  327,  328,  329,  330,  331,  332,  333,  334,  335,
   -1,  337,   -1,   -1,  340,  341,   -1,   -1,  344,  345,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  359,  360,  361,  362,  363,   -1,   -1,
   -1,  367,  368,   -1,   -1,  371,   -1,   -1,   -1,   -1,
  376,  377,  378,  379,  380,   -1,  256,   -1,  384,   -1,
  386,  261,  262,   -1,   -1,   -1,  392,  393,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,    0,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  284,   -1,   -1,   -1,   -1,   -1,
   -1,  417,  418,  419,  420,   -1,  422,  297,  298,   -1,
   -1,   -1,  302,  429,   -1,  305,   -1,  307,   -1,  309,
  310,  311,  312,   -1,   -1,   -1,   -1,  317,   -1,   -1,
   -1,  321,   -1,   -1,   -1,  325,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  333,   -1,   -1,  336,   -1,  338,  339,
   -1,   -1,   -1,   -1,  344,   -1,  346,  347,  348,  349,
  350,  351,  352,  353,  354,  355,  356,  357,   -1,   -1,
   -1,   -1,  362,  363,   -1,   -1,   -1,  367,  368,  369,
  370,  371,  372,  373,  374,  375,  376,   -1,  378,  379,
   -1,   -1,  382,  383,  384,  385,  386,   -1,   -1,  389,
  390,   -1,   -1,   -1,  394,  395,  396,  397,  398,  399,
  400,  401,  256,   -1,   -1,   -1,    0,  261,  262,   -1,
   -1,   -1,   -1,  413,   -1,   -1,  416,   -1,  418,   -1,
  420,   -1,   -1,  423,   -1,   -1,   -1,   -1,   -1,  429,
  284,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  297,  298,   -1,   -1,   -1,  302,   -1,
   -1,  305,   -1,  307,   -1,  309,  310,  311,  312,   -1,
   -1,   -1,   -1,  317,   -1,   -1,   -1,  321,   -1,   -1,
   -1,  325,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  333,
   -1,   -1,  336,   -1,  338,  339,   -1,   -1,   -1,   -1,
  344,   -1,  346,  347,  348,  349,  350,  351,  352,  353,
  354,  355,  356,   -1,   -1,   -1,   -1,   -1,  362,  363,
    0,   -1,   -1,  367,  368,  369,  370,  371,  372,   -1,
  374,  375,  376,   -1,  378,  379,   -1,   -1,  382,  383,
  384,  385,  256,   -1,   -1,  389,  390,  261,  262,   -1,
  394,  395,  396,  397,  398,  399,  400,  401,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  413,
  284,   -1,  416,   -1,  418,   -1,  420,   -1,   -1,  423,
   -1,   -1,   -1,  297,  298,  429,   -1,   -1,  302,   -1,
   -1,  305,   -1,  307,   -1,  309,  310,  311,  312,   -1,
   -1,   -1,   -1,  317,   -1,   -1,   -1,  321,   -1,   -1,
   -1,  325,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  333,
   -1,   -1,  336,   -1,  338,  339,   -1,   -1,   -1,   -1,
  344,   -1,  346,  347,  348,  349,  350,  351,  352,  353,
  354,  355,  356,   -1,   -1,   -1,   -1,   -1,  362,  363,
   -1,   -1,   -1,  367,  368,  369,  370,  371,  372,   -1,
  374,  375,  376,   -1,  378,  379,    0,   -1,  382,  383,
  384,  385,  256,   -1,   -1,  389,  390,  261,  262,   -1,
  394,  395,  396,  397,  398,  399,  400,  401,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  413,
  284,   -1,  416,   -1,  418,   -1,  420,   -1,   -1,  423,
   -1,   -1,   -1,  297,  298,  429,   -1,   -1,  302,   -1,
   -1,  305,   -1,  307,   -1,  309,  310,  311,  312,   -1,
   -1,   -1,   -1,  317,   -1,   -1,   -1,  321,   -1,   -1,
   -1,  325,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  333,
   -1,   -1,  336,   -1,  338,  339,   -1,   -1,   -1,   -1,
  344,   -1,  346,  347,  348,  349,  350,  351,  352,  353,
  354,  355,  356,   -1,   -1,   -1,  256,   -1,  362,  363,
   -1,   -1,  262,  367,  368,   -1,  370,  371,  372,   -1,
  374,  375,  376,   -1,  378,  379,    0,   -1,  382,  383,
  384,  385,   -1,   -1,   -1,  389,  390,   -1,   -1,   -1,
  394,  395,  396,  397,  398,  399,  400,  401,  298,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  413,
   -1,   -1,  416,   -1,  418,   -1,   -1,   -1,   -1,    0,
   -1,   -1,   -1,   -1,   -1,  429,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  339,
   -1,   -1,  256,   -1,  344,   -1,  346,  347,  348,  349,
  350,  351,  352,  353,  354,  355,  356,  357,   -1,   -1,
   -1,   -1,    0,  363,   -1,   -1,   -1,  367,  368,  369,
  370,  371,  372,  373,  374,  375,  376,   -1,  378,  379,
   -1,   -1,  382,  383,  384,  385,  386,   -1,   -1,  389,
  390,   -1,   -1,   -1,  394,  395,  396,  397,  398,  399,
  400,  401,  256,   -1,   -1,    0,   -1,   -1,  262,   -1,
   -1,   -1,   -1,  413,   -1,   -1,  416,   -1,  418,   -1,
  420,   -1,   -1,  423,   -1,  339,   -1,   -1,   -1,  429,
  344,   -1,  346,  347,  348,  349,  350,  351,  352,  353,
  354,  355,  356,   -1,  298,   -1,   -1,   -1,    0,   -1,
   -1,   -1,   -1,   -1,  368,   -1,  370,   -1,  372,   -1,
  374,  375,  376,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  339,   -1,   -1,   -1,   -1,
  344,    0,  346,  347,  348,  349,  350,  351,  352,  353,
  354,  355,  356,   -1,   -1,   -1,   -1,   -1,   -1,  363,
   -1,   -1,   -1,  367,  368,  429,  370,  371,  372,   -1,
  374,  375,  376,   -1,  378,  379,   -1,   -1,  382,  383,
  384,  385,   -1,  257,    0,  389,  390,  261,   -1,   -1,
  394,  395,  396,  397,  398,  399,  400,  401,  272,   -1,
   -1,   -1,   -1,  277,   -1,   -1,   -1,  281,   -1,  413,
  284,   -1,  416,   -1,  418,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  296,  297,   -1,  429,  257,  301,  302,   -1,
  261,   -1,   -1,  307,   -1,  309,  310,  311,  312,   -1,
   -1,  272,   -1,  317,   -1,   -1,  277,  321,   -1,  323,
  281,    0,   -1,  284,   -1,   -1,   -1,   -1,   -1,  333,
   -1,   -1,  336,   -1,  338,  296,  297,   -1,  342,  257,
  301,  302,   -1,  261,   -1,   -1,  307,   -1,  309,  310,
  311,  312,   -1,   -1,  272,   -1,  317,   -1,  362,  277,
  321,   -1,  323,  281,  368,  369,  284,   -1,    0,   -1,
   -1,   -1,  333,   -1,   -1,  336,   -1,  338,  296,  297,
   -1,  342,  257,  301,  302,   -1,  261,   -1,   -1,  307,
   -1,  309,  310,  311,  312,   -1,   -1,  272,   -1,  317,
   -1,  362,  277,  321,   -1,  323,  281,  368,  369,  284,
   -1,   -1,   -1,   -1,   -1,  333,   -1,   -1,  336,   -1,
  338,  296,  297,   -1,  342,  257,  301,  302,   -1,  261,
   -1,   -1,  307,   -1,  309,  310,  311,  312,   -1,   -1,
  272,   -1,  317,   -1,  362,  277,  321,   -1,  323,  281,
   -1,  369,  284,   -1,   -1,   -1,   -1,   -1,  333,   -1,
   -1,  336,   -1,  338,  296,  297,   -1,  342,  257,  301,
  302,   -1,  261,   -1,   -1,  307,   -1,  309,  310,  311,
  312,   -1,   -1,  272,   -1,  317,   -1,  362,  277,  321,
   -1,  323,  281,   -1,   -1,  284,   -1,   -1,   -1,   -1,
   -1,  333,   -1,   -1,  336,   -1,  338,  296,  297,   -1,
  342,  257,  301,  302,   -1,  261,   -1,   -1,  307,   -1,
  309,  310,  311,  312,   -1,   -1,  272,   -1,  317,   -1,
  362,  277,  321,   -1,  323,  281,   -1,   -1,  284,   -1,
   -1,   -1,   -1,   -1,  333,   -1,   -1,  336,   -1,  338,
  296,  297,   -1,  342,   -1,  301,  302,   -1,   -1,   -1,
   -1,  307,   -1,  309,  310,  311,  312,   -1,   -1,   -1,
   -1,  317,   -1,  362,   -1,  321,   -1,  323,  257,   -1,
   -1,   -1,  261,   -1,   -1,   -1,   -1,  333,   -1,   -1,
  336,   -1,  338,  272,   -1,   -1,  342,   -1,  277,   -1,
   -1,   -1,  281,   -1,   -1,  284,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  362,  296,  297,   -1,
   -1,   -1,  301,  302,   -1,  257,   -1,   -1,  307,  261,
  309,  310,  311,  312,   -1,   -1,   -1,   -1,  317,   -1,
  272,   -1,  321,   -1,  323,  277,   -1,   -1,   -1,  281,
   -1,   -1,  284,   -1,  333,   -1,   -1,  336,   -1,  338,
   -1,   -1,   -1,  342,  296,  297,   -1,   -1,   -1,  301,
  302,   -1,   -1,   -1,   -1,  307,   -1,  309,  310,  311,
  312,   -1,   -1,  362,   -1,  317,   -1,   -1,   -1,  321,
   -1,  323,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  333,   -1,  256,  336,   -1,  338,   -1,   -1,   -1,
  342,  264,  265,  266,  267,   -1,   -1,  270,  271,   -1,
  273,  274,  275,  276,  277,  278,  279,   -1,   -1,   -1,
  362,   -1,  285,   -1,  287,  288,  289,  290,  291,  292,
   -1,   -1,  295,   -1,   -1,   -1,  299,  300,   -1,  302,
  303,  304,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  314,   -1,  316,   -1,  318,  319,   -1,   -1,  322,
   -1,  324,  325,  326,  327,  328,  329,  330,  331,  332,
  333,  334,  335,   -1,  337,   -1,   -1,  340,  341,   -1,
  256,  344,  345,   -1,   -1,   -1,  262,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  359,  360,  361,  362,
  363,   -1,   -1,   -1,  367,   -1,   -1,   -1,  371,   -1,
   -1,   -1,   -1,  376,  377,  378,  379,  380,   -1,   -1,
   -1,  384,  298,  386,   -1,   -1,   -1,   -1,   -1,  392,
  393,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  256,   -1,   -1,   -1,
   -1,   -1,  262,   -1,  417,  418,  419,  420,   -1,   -1,
   -1,   -1,   -1,  339,   -1,   -1,  429,   -1,  344,   -1,
  346,  347,  348,  349,  350,  351,  352,  353,  354,  355,
  356,  357,   -1,   -1,   -1,   -1,   -1,  363,  298,   -1,
   -1,   -1,  368,  369,  370,  371,  372,  373,  374,  375,
  376,   -1,  378,  379,   -1,  381,  382,  383,  384,  385,
  386,  387,  388,  389,  390,   -1,  392,  393,  394,  395,
  396,  397,  398,  399,  400,  401,  402,  403,  404,  405,
  406,  407,  408,  409,  410,  411,  412,  413,   -1,  256,
   -1,   -1,  418,   -1,  420,  262,   -1,  423,   -1,   -1,
   -1,   -1,   -1,  429,   -1,   -1,   -1,   -1,  368,   -1,
   -1,  371,   -1,  373,  374,   -1,   -1,   -1,  378,  379,
   -1,   -1,  382,  383,  384,  385,  386,  387,  388,  389,
  390,  298,  392,  393,  394,  395,  396,  397,  398,  399,
  400,  401,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  412,  413,   -1,   -1,   -1,   -1,   -1,   -1,
  420,   -1,   -1,  423,   -1,   -1,   -1,   -1,   -1,  429,
   -1,  285,  339,   -1,   -1,   -1,   -1,  344,   -1,  346,
  347,  348,  349,  350,  351,  352,  353,  354,  355,  356,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  367,  368,  369,  370,  371,  372,  373,  374,  375,  376,
  256,  378,  379,  327,  381,  382,  383,  384,  385,  386,
  387,  388,  389,  390,   -1,  392,  393,  394,  395,  396,
  397,  398,  399,  400,  401,  402,  403,  404,  405,  406,
  407,  408,  409,  410,  411,  412,  413,   -1,  256,   -1,
   -1,   -1,   -1,  420,  262,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  429,  377,  378,  379,  380,   -1,  382,  383,
  384,  385,  386,  387,  388,  389,   -1,   -1,  392,  393,
  394,  395,  396,  397,  398,  399,   -1,   -1,   -1,   -1,
  298,   -1,   -1,  339,   -1,   -1,   -1,   -1,  344,   -1,
  346,  347,  348,  349,  350,  351,  352,  353,  354,  355,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  256,
   -1,   -1,  368,   -1,  370,  262,  372,   -1,  374,  375,
  376,  339,   -1,   -1,   -1,   -1,  344,   -1,  346,  347,
  348,  349,  350,  351,  352,  353,  354,  355,  356,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  367,
  368,  298,  370,  371,  372,  373,  374,  375,  376,   -1,
  378,  379,   -1,  381,  382,  383,  384,  385,  386,  387,
  388,  389,  390,  429,  392,  393,  394,  395,  396,  397,
  398,  399,  400,  401,  402,  403,  404,  405,  406,  407,
  408,  409,  410,  411,  412,  413,   -1,  256,   -1,   -1,
   -1,   -1,  420,  262,   -1,  423,   -1,   -1,   -1,   -1,
   -1,  429,   -1,   -1,   -1,   -1,  363,   -1,   -1,   -1,
   -1,  368,  369,   -1,  371,  372,  373,  374,   -1,  376,
   -1,  378,  379,   -1,  381,  382,  383,  384,  385,  298,
  387,  388,  389,  390,   -1,  392,  393,  394,  395,  396,
  397,  398,  399,  400,  401,  402,  403,  404,  405,  406,
  407,  408,  409,  410,  411,  412,  413,   -1,   -1,   -1,
   -1,  418,   -1,  420,   -1,   -1,  423,   -1,   -1,   -1,
  339,   -1,  429,   -1,   -1,  344,   -1,  346,  347,  348,
  349,  350,  351,  352,  353,  354,  355,  356,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  368,
   -1,  370,  371,  372,  373,  374,  375,  376,   -1,  378,
  379,   -1,  381,  382,  383,  384,  385,  386,  387,  388,
  389,  390,   -1,  392,  393,  394,  395,  396,  397,  398,
  399,  400,  401,  402,  403,  404,  405,  406,  407,  408,
  409,  410,  411,  412,  413,   -1,  256,  256,   -1,   -1,
   -1,  420,  262,   -1,  423,   -1,  265,   -1,  267,   -1,
  429,  270,   -1,   -1,   -1,   -1,  275,   -1,   -1,   -1,
  279,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  288,
   -1,   -1,   -1,   -1,   -1,   -1,  295,   -1,  298,   -1,
   -1,  300,   -1,   -1,   -1,  304,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  316,   -1,  318,
   -1,   -1,   -1,  322,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  330,  331,   -1,   -1,  334,   -1,   -1,  337,  339,
   -1,   -1,   -1,   -1,  344,   -1,  346,  347,  348,  349,
  350,  351,  352,  353,  354,  355,  356,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  363,   -1,   -1,   -1,  368,   -1,
  370,  371,  372,  373,  374,  375,  376,   -1,  378,  379,
   -1,  381,  382,  383,  384,  385,  386,  387,  388,  389,
  390,   -1,  392,  393,  394,  395,  396,  397,  398,  399,
  400,  401,  402,  403,  404,  405,  406,  407,  408,  409,
  410,  411,  412,  413,   -1,  256,  256,   -1,   -1,  418,
  420,  262,   -1,  423,   -1,  265,   -1,  267,   -1,  429,
  270,   -1,   -1,   -1,   -1,  275,   -1,   -1,   -1,  279,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  288,   -1,
   -1,   -1,   -1,   -1,   -1,  295,   -1,  298,   -1,   -1,
  300,   -1,   -1,   -1,  304,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  316,   -1,  318,   -1,
   -1,   -1,  322,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  330,  331,   -1,   -1,  334,   -1,   -1,  337,  339,   -1,
   -1,   -1,   -1,  344,   -1,  346,  347,  348,  349,  350,
  351,  352,  353,  354,  355,  356,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  368,   -1,  370,
  371,  372,  373,  374,  375,  376,   -1,  378,  379,   -1,
  381,  382,  383,  384,  385,  386,  387,  388,  389,  390,
   -1,  392,  393,  394,  395,  396,  397,  398,  399,  400,
  401,  402,  403,  404,  405,  406,  407,  408,  409,  410,
  411,  412,  413,   -1,  256,   -1,  261,   -1,  418,  420,
  262,   -1,  423,   -1,   -1,   -1,   -1,   -1,  429,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  284,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  297,   -1,   -1,   -1,  298,  302,   -1,   -1,
   -1,   -1,  307,   -1,  309,  310,  311,  312,   -1,   -1,
   -1,   -1,  317,   -1,   -1,   -1,  321,   -1,   -1,  256,
  325,   -1,   -1,   -1,   -1,  262,   -1,   -1,  333,  266,
   -1,  336,   -1,  338,   -1,   -1,   -1,  339,   -1,   -1,
   -1,   -1,  344,   -1,  346,  347,  348,  349,  350,  351,
  352,  353,  354,  355,  356,   -1,   -1,  362,   -1,   -1,
   -1,  298,   -1,   -1,   -1,   -1,  368,   -1,  370,  371,
  372,  373,  374,  375,  376,   -1,  378,  314,   -1,  381,
  382,  383,  384,  385,  386,  387,  388,  389,  390,   -1,
  392,  393,  394,  395,  396,  397,  398,  399,  400,  401,
  402,  403,  404,  405,  406,  407,  408,  409,  410,  411,
  412,  413,   -1,  418,   -1,   -1,   -1,   -1,  420,   -1,
  357,  423,   -1,   -1,   -1,   -1,  363,  429,   -1,   -1,
   -1,  368,  369,  370,  371,  372,  373,  374,  375,  376,
   -1,  378,  379,   -1,  381,  382,  383,  384,  385,  386,
  387,  388,  389,  390,   -1,  392,  393,  394,  395,  396,
  397,  398,  399,  400,  401,  402,  403,  404,  405,  406,
  407,  408,  409,  410,  411,  412,  413,   -1,  256,   -1,
  256,  418,   -1,  420,  262,   -1,  423,   -1,  264,  265,
   -1,  267,  429,   -1,  270,  271,   -1,   -1,   -1,  275,
  276,  277,   -1,  279,   -1,   -1,   -1,   -1,   -1,  285,
   -1,   -1,  288,   -1,   -1,   -1,   -1,   -1,   -1,  295,
  298,   -1,   -1,   -1,  300,   -1,  302,  303,  304,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  316,   -1,  318,  319,   -1,   -1,  322,   -1,   -1,  325,
   -1,  327,   -1,  329,  330,  331,  332,   -1,  334,   -1,
   -1,  339,   -1,   -1,   -1,   -1,  344,   -1,  346,  347,
  348,  349,  350,  351,  352,  353,  354,  355,  356,   -1,
   -1,   -1,   -1,  359,  360,  361,  362,   -1,   -1,   -1,
  368,   -1,  370,   -1,  372,  371,  374,  375,  376,   -1,
  378,  379,   -1,  381,  382,  383,  384,  385,  386,  387,
  388,  389,  390,  261,   -1,   -1,  394,  395,  396,  397,
  398,  399,  400,  401,  402,  403,  404,  405,  406,  407,
  408,  409,  410,  411,  256,  413,  284,   -1,   -1,   -1,
  262,  417,  418,   -1,   -1,   -1,   -1,   -1,   -1,  297,
   -1,  429,   -1,   -1,  302,   -1,   -1,   -1,   -1,  307,
   -1,  309,  310,  311,  312,   -1,   -1,   -1,   -1,  317,
   -1,   -1,   -1,  321,   -1,   -1,  298,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  333,   -1,   -1,  336,   -1,
  338,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  256,   -1,   -1,   -1,   -1,   -1,  262,   -1,
   -1,   -1,   -1,   -1,  362,   -1,   -1,  339,   -1,   -1,
   -1,   -1,  344,   -1,  346,  347,  348,  349,  350,  351,
  352,  353,  354,  355,  356,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  298,   -1,  368,   -1,  370,   -1,
  372,   -1,  374,  375,  376,   -1,  378,  379,   -1,   -1,
  382,  383,  384,  385,  386,  387,  388,  389,  390,   -1,
  418,   -1,  394,  395,  396,  397,  398,  399,  400,  401,
   -1,   -1,   -1,   -1,   -1,  339,   -1,   -1,   -1,   -1,
  344,  413,  346,  347,  348,  349,  350,  351,  352,  353,
  354,  355,  356,   -1,   -1,   -1,  256,  429,   -1,   -1,
   -1,   -1,  262,   -1,  368,   -1,  370,   -1,  372,   -1,
  374,  375,  376,   -1,  378,  379,   -1,   -1,  382,  383,
  384,  385,   -1,   -1,   -1,  389,  390,   -1,   -1,   -1,
  394,  395,  396,  397,  398,  399,  400,  401,  298,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  413,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  256,  429,   -1,   -1,   -1,   -1,
  262,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  339,
   -1,   -1,   -1,   -1,  344,   -1,  346,  347,  348,  349,
  350,  351,  352,  353,  354,  355,  356,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  298,   -1,  368,   -1,
  370,   -1,  372,   -1,  374,  375,  376,   -1,  378,  379,
   -1,   -1,  382,  383,  384,  385,   -1,   -1,   -1,  389,
  390,   -1,   -1,   -1,  394,  395,  396,  397,  398,  399,
  400,  401,   -1,   -1,   -1,   -1,   -1,  339,   -1,   -1,
   -1,   -1,  344,  413,  346,  347,  348,  349,  350,  351,
  352,  353,  354,  355,  356,   -1,   -1,   -1,  256,  429,
   -1,   -1,   -1,   -1,  262,   -1,  368,   -1,  370,   -1,
  372,   -1,  374,  375,  376,   -1,  378,  379,   -1,   -1,
  382,  383,  384,  385,   -1,   -1,   -1,  389,  390,   -1,
   -1,   -1,  394,  395,  396,  397,  398,  399,  400,  401,
  298,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  413,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  256,  429,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  339,   -1,   -1,   -1,   -1,  344,   -1,  346,  347,
  348,  349,  350,  351,  352,  353,  354,  355,  356,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  368,   -1,  370,   -1,  372,   -1,  374,  375,  376,   -1,
  378,  379,   -1,   -1,  382,  383,  384,  385,   -1,   -1,
   -1,  389,  390,   -1,  256,   -1,  394,  395,  396,  397,
  398,  399,  400,  401,   -1,   -1,   -1,   -1,   -1,  339,
   -1,   -1,   -1,   -1,  344,  413,  346,  347,  348,  349,
  350,  351,  352,  353,  354,  355,  356,   -1,   -1,   -1,
   -1,  429,   -1,   -1,   -1,   -1,   -1,   -1,  368,   -1,
  370,   -1,  372,   -1,  374,  375,  376,   -1,   -1,   -1,
   -1,   -1,  382,  383,  384,  385,   -1,   -1,   -1,  389,
  390,   -1,  256,   -1,  394,  395,  396,  397,  398,  399,
  400,  401,   -1,   -1,   -1,   -1,   -1,  339,   -1,   -1,
   -1,   -1,  344,  413,  346,  347,  348,  349,  350,  351,
  352,  353,  354,  355,  356,   -1,   -1,   -1,   -1,  429,
   -1,   -1,   -1,   -1,   -1,   -1,  368,   -1,  370,   -1,
  372,   -1,  374,  375,  376,   -1,   -1,   -1,   -1,   -1,
  382,  383,  384,  385,   -1,   -1,   -1,  389,  390,   -1,
  256,   -1,  394,  395,  396,  397,  398,  399,  400,  401,
   -1,   -1,   -1,   -1,   -1,  339,   -1,   -1,   -1,   -1,
  344,  413,  346,  347,  348,  349,  350,  351,  352,  353,
  354,  355,  356,   -1,   -1,   -1,   -1,  429,   -1,   -1,
   -1,   -1,   -1,   -1,  368,   -1,  370,   -1,  372,   -1,
  374,  375,  376,   -1,   -1,   -1,   -1,   -1,  382,  383,
  384,  385,   -1,   -1,   -1,  389,  390,   -1,  256,   -1,
  394,  395,  396,  397,  398,  399,  400,  401,   -1,   -1,
   -1,   -1,   -1,  339,   -1,   -1,   -1,   -1,  344,  413,
  346,  347,  348,  349,  350,  351,  352,  353,  354,  355,
  356,   -1,   -1,   -1,   -1,  429,   -1,   -1,   -1,   -1,
   -1,   -1,  368,   -1,  370,   -1,  372,   -1,  374,  375,
  376,   -1,   -1,   -1,   -1,   -1,  382,  383,  384,  385,
   -1,   -1,   -1,  389,  390,   -1,  256,   -1,   -1,   -1,
  396,  397,  398,  399,  400,  401,   -1,   -1,   -1,   -1,
   -1,  339,   -1,   -1,   -1,   -1,  344,  413,  346,  347,
  348,  349,  350,  351,  352,  353,  354,  355,  356,   -1,
   -1,   -1,   -1,  429,   -1,   -1,   -1,   -1,   -1,   -1,
  368,   -1,  370,   -1,  372,   -1,  374,  375,  376,   -1,
   -1,   -1,   -1,   -1,  382,  383,  384,  385,   -1,   -1,
   -1,  389,  390,   -1,  256,   -1,   -1,   -1,  396,  397,
  398,  399,  400,  401,   -1,   -1,   -1,   -1,   -1,  339,
   -1,   -1,   -1,   -1,  344,  413,  346,  347,  348,  349,
  350,  351,  352,  353,  354,  355,  356,   -1,   -1,   -1,
   -1,  429,   -1,   -1,   -1,   -1,   -1,   -1,  368,   -1,
  370,   -1,  372,   -1,  374,  375,  376,   -1,   -1,   -1,
   -1,   -1,  382,  383,  384,  385,   -1,   -1,   -1,  389,
  390,   -1,  256,   -1,   -1,   -1,  396,  397,  398,  399,
  400,  401,   -1,   -1,   -1,   -1,   -1,  339,   -1,   -1,
   -1,   -1,  344,  413,  346,  347,  348,  349,  350,  351,
  352,  353,  354,  355,  356,   -1,   -1,   -1,   -1,  429,
   -1,   -1,   -1,   -1,   -1,   -1,  368,   -1,  370,   -1,
  372,   -1,  374,  375,  376,   -1,   -1,   -1,   -1,   -1,
  382,  383,  384,  385,   -1,   -1,   -1,  389,  390,   -1,
  256,   -1,   -1,   -1,  396,  397,  398,  399,  400,  401,
   -1,   -1,   -1,   -1,   -1,  339,   -1,   -1,   -1,   -1,
  344,  413,  346,  347,  348,  349,  350,  351,  352,  353,
  354,  355,  356,   -1,   -1,   -1,   -1,  429,   -1,   -1,
   -1,   -1,   -1,   -1,  368,   -1,  370,   -1,  372,   -1,
  374,  375,  376,   -1,   -1,   -1,   -1,   -1,  382,  383,
  384,  385,   -1,   -1,   -1,  389,  390,   -1,  256,   -1,
   -1,   -1,  396,  397,  398,  399,  400,  401,   -1,   -1,
   -1,   -1,   -1,  339,   -1,   -1,   -1,   -1,  344,  413,
  346,  347,  348,  349,  350,  351,  352,  353,  354,  355,
  356,   -1,   -1,   -1,   -1,  429,   -1,   -1,   -1,   -1,
   -1,   -1,  368,   -1,  370,   -1,  372,   -1,  374,  375,
  376,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  384,  385,
   -1,   -1,   -1,  389,  390,   -1,  256,   -1,   -1,   -1,
   -1,   -1,  398,  399,  400,  401,   -1,   -1,   -1,   -1,
   -1,  339,   -1,   -1,   -1,   -1,  344,  413,  346,  347,
  348,  349,  350,  351,  352,  353,  354,  355,  356,   -1,
   -1,   -1,   -1,  429,   -1,   -1,   -1,   -1,   -1,   -1,
  368,   -1,  370,   -1,  372,   -1,  374,  375,  376,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  384,  385,   -1,   -1,
   -1,  389,  390,   -1,  256,   -1,   -1,   -1,   -1,   -1,
  398,  399,  400,  401,   -1,   -1,   -1,   -1,   -1,  339,
   -1,   -1,   -1,   -1,  344,  413,  346,  347,  348,  349,
  350,  351,  352,  353,  354,  355,  356,   -1,   -1,   -1,
   -1,  429,   -1,   -1,   -1,   -1,   -1,   -1,  368,   -1,
  370,   -1,  372,   -1,  374,  375,  376,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  384,  385,   -1,   -1,   -1,  389,
  390,   -1,  256,   -1,   -1,   -1,   -1,   -1,  398,  399,
  400,  401,   -1,   -1,   -1,   -1,   -1,  339,   -1,   -1,
   -1,   -1,  344,  413,  346,  347,  348,  349,  350,  351,
  352,  353,  354,  355,  356,   -1,   -1,   -1,   -1,  429,
   -1,   -1,   -1,   -1,   -1,   -1,  368,   -1,  370,   -1,
  372,   -1,  374,  375,  376,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  384,  385,   -1,   -1,   -1,  389,  390,   -1,
  256,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  400,  401,
   -1,   -1,   -1,   -1,   -1,  339,   -1,   -1,   -1,   -1,
  344,  413,  346,  347,  348,  349,  350,  351,  352,  353,
  354,  355,  356,   -1,   -1,   -1,   -1,  429,   -1,   -1,
   -1,   -1,   -1,   -1,  368,   -1,  370,   -1,  372,   -1,
  374,  375,  376,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  384,  385,   -1,   -1,   -1,  389,  390,   -1,  256,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  400,  401,   -1,   -1,
   -1,   -1,   -1,  339,   -1,   -1,   -1,   -1,  344,  413,
  346,  347,  348,  349,  350,  351,  352,  353,  354,  355,
  356,   -1,   -1,   -1,   -1,  429,   -1,   -1,   -1,   -1,
   -1,   -1,  368,   -1,  370,   -1,  372,   -1,  374,  375,
  376,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  385,
   -1,   -1,   -1,  389,  390,   -1,  256,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  400,  401,   -1,   -1,   -1,   -1,
   -1,  339,   -1,   -1,   -1,   -1,  344,  413,  346,  347,
  348,  349,  350,  351,  352,  353,  354,  355,  356,   -1,
   -1,   -1,   -1,  429,   -1,   -1,   -1,   -1,   -1,   -1,
  368,   -1,  370,   -1,  372,   -1,  374,  375,  376,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  385,   -1,   -1,
   -1,  389,  390,   -1,  256,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  400,  401,   -1,   -1,   -1,   -1,   -1,  339,
   -1,   -1,   -1,   -1,  344,  413,  346,  347,  348,  349,
  350,  351,  352,  353,  354,  355,  356,   -1,   -1,   -1,
   -1,  429,   -1,   -1,   -1,   -1,   -1,   -1,  368,   -1,
  370,   -1,  372,   -1,  374,  375,  376,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  385,   -1,   -1,   -1,   -1,
  390,   -1,  256,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  400,  401,   -1,   -1,   -1,   -1,   -1,  339,   -1,   -1,
   -1,   -1,  344,  413,  346,  347,  348,  349,  350,  351,
  352,  353,  354,  355,  356,   -1,   -1,   -1,   -1,  429,
   -1,   -1,   -1,   -1,   -1,   -1,  368,   -1,  370,   -1,
  372,   -1,  374,  375,  376,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  385,   -1,   -1,   -1,   -1,  390,   -1,
  256,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  400,  401,
   -1,   -1,   -1,   -1,   -1,  339,   -1,   -1,   -1,   -1,
  344,  413,  346,  347,  348,  349,  350,  351,  352,  353,
  354,  355,  356,   -1,   -1,   -1,   -1,  429,   -1,   -1,
   -1,   -1,   -1,   -1,  368,   -1,  370,   -1,  372,   -1,
  374,  375,  376,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  262,  390,   -1,   -1,  266,
   -1,   -1,   -1,   -1,   -1,   -1,  400,  401,   -1,   -1,
   -1,   -1,   -1,  339,   -1,   -1,   -1,   -1,  344,  413,
  346,  347,  348,  349,  350,  351,  352,  353,  354,  355,
  356,  298,   -1,   -1,   -1,  429,   -1,   -1,   -1,   -1,
   -1,   -1,  368,   -1,  370,   -1,  372,  314,  374,  375,
  376,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  390,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  400,  401,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  413,   -1,   -1,
  357,   -1,   -1,   -1,   -1,   -1,  363,   -1,   -1,   -1,
   -1,  368,  369,  429,  371,   -1,  373,   -1,  375,  376,
   -1,  378,  379,   -1,  381,  382,  383,  384,  385,  386,
  387,  388,  389,  390,   -1,  392,  393,  394,  395,  396,
  397,  398,  399,  400,  401,  402,  403,  404,  405,  406,
  407,  408,  409,  410,  411,  412,  413,   -1,   -1,  256,
   -1,  418,   -1,  420,   -1,   -1,  423,  264,  265,  266,
  267,   -1,  429,  270,  271,   -1,  273,  274,  275,  276,
  277,  278,  279,   -1,   -1,   -1,   -1,   -1,  285,   -1,
  287,  288,  289,  290,  291,  292,   -1,   -1,  295,   -1,
   -1,   -1,  299,  300,   -1,  302,  303,  304,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  314,   -1,  316,
   -1,  318,  319,   -1,   -1,  322,   -1,  324,  325,  326,
  327,  328,  329,  330,  331,  332,  333,  334,  335,   -1,
  337,   -1,   -1,  340,  341,   -1,   -1,  344,  345,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  359,  360,  361,  362,  363,   -1,   -1,   -1,
  367,   -1,   -1,   -1,  371,   -1,   -1,   -1,   -1,  376,
  377,  378,  379,  380,   -1,   -1,   -1,  384,   -1,  386,
   -1,   -1,   -1,   -1,   -1,  392,  393,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  256,   -1,   -1,   -1,
  417,  418,  419,  420,  264,  265,  266,  267,   -1,   -1,
  270,  271,   -1,  273,  274,  275,  276,  277,  278,  279,
   -1,   -1,   -1,   -1,   -1,  285,   -1,  287,  288,  289,
  290,  291,  292,   -1,   -1,  295,   -1,   -1,   -1,  299,
  300,   -1,  302,  303,  304,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  314,   -1,  316,   -1,  318,  319,
   -1,   -1,  322,   -1,  324,  325,  326,  327,  328,  329,
  330,  331,  332,  333,  334,  335,   -1,  337,   -1,   -1,
  340,  341,   -1,   -1,  344,  345,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  359,
  360,  361,  362,  363,   -1,   -1,   -1,  367,   -1,   -1,
   -1,  371,   -1,   -1,   -1,   -1,  376,  377,  378,  379,
  380,   -1,   -1,   -1,  384,   -1,  386,   -1,   -1,   -1,
   -1,   -1,  392,  393,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  256,   -1,   -1,   -1,  417,  418,  419,
  420,  264,  265,  266,  267,   -1,   -1,  270,  271,   -1,
  273,  274,  275,  276,  277,  278,  279,   -1,   -1,   -1,
   -1,   -1,  285,   -1,  287,  288,  289,  290,  291,  292,
   -1,   -1,  295,   -1,   -1,   -1,  299,  300,   -1,  302,
  303,  304,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  314,   -1,  316,   -1,  318,  319,   -1,   -1,  322,
   -1,  324,  325,  326,  327,  328,  329,  330,  331,  332,
  333,  334,  335,   -1,  337,   -1,   -1,  340,  341,   -1,
   -1,  344,  345,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  359,  360,  361,  362,
  363,   -1,   -1,   -1,  367,   -1,   -1,   -1,  371,   -1,
   -1,   -1,   -1,  376,  377,  378,  379,  380,   -1,   -1,
   -1,  384,   -1,  386,   -1,   -1,   -1,   -1,   -1,  392,
  393,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  256,   -1,   -1,   -1,  417,  418,  419,  420,  264,  265,
  266,  267,   -1,   -1,  270,  271,   -1,  273,  274,  275,
  276,  277,  278,  279,   -1,   -1,   -1,   -1,   -1,  285,
   -1,  287,  288,  289,  290,  291,  292,   -1,   -1,  295,
   -1,   -1,   -1,  299,  300,   -1,  302,  303,  304,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  314,   -1,
  316,   -1,  318,  319,   -1,   -1,  322,   -1,  324,  325,
  326,  327,  328,  329,  330,  331,  332,  333,  334,  335,
   -1,  337,   -1,   -1,  340,  341,   -1,   -1,  344,  345,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  359,  360,  361,  362,  363,   -1,   -1,
   -1,  367,   -1,   -1,   -1,  371,   -1,   -1,   -1,   -1,
  376,  377,  378,  379,  380,   -1,   -1,   -1,  384,   -1,
  386,   -1,   -1,   -1,   -1,   -1,  392,  393,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  256,   -1,   -1,
   -1,  417,  418,  419,  420,  264,  265,  266,  267,   -1,
   -1,  270,  271,   -1,  273,  274,  275,  276,  277,  278,
  279,   -1,   -1,   -1,   -1,   -1,  285,   -1,  287,  288,
  289,  290,  291,  292,   -1,   -1,  295,   -1,   -1,   -1,
  299,  300,   -1,  302,  303,  304,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  314,   -1,  316,   -1,  318,
  319,   -1,   -1,  322,   -1,  324,  325,  326,  327,  328,
  329,  330,  331,  332,  333,  334,  335,   -1,  337,   -1,
   -1,  340,  341,   -1,   -1,  344,  345,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  359,  360,  361,  362,  363,   -1,   -1,   -1,  367,   -1,
   -1,   -1,  371,   -1,   -1,   -1,   -1,  376,  377,  378,
  379,  380,   -1,   -1,   -1,  384,   -1,  386,   -1,   -1,
   -1,   -1,   -1,  392,  393,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  256,   -1,   -1,   -1,  417,  418,
  419,  420,  264,  265,   -1,  267,   -1,   -1,  270,  271,
   -1,  256,   -1,  275,  276,  277,   -1,  279,   -1,   -1,
  265,   -1,  267,  285,   -1,  270,  288,   -1,   -1,   -1,
  275,   -1,   -1,  295,  279,   -1,   -1,   -1,  300,   -1,
  302,  303,  304,  288,   -1,   -1,   -1,   -1,   -1,   -1,
  295,   -1,   -1,   -1,  316,  300,  318,  319,   -1,  304,
  322,   -1,   -1,  325,   -1,  327,   -1,  329,  330,  331,
  332,  316,  334,  318,   -1,   -1,   -1,  322,   -1,  341,
   -1,   -1,  344,  345,   -1,  330,  331,   -1,   -1,  334,
   -1,   -1,  337,   -1,   -1,   -1,   -1,  359,  360,  361,
  362,  363,   -1,   -1,   -1,  367,  368,   -1,   -1,  371,
   -1,   -1,   -1,   -1,   -1,  377,  378,  379,  380,   -1,
   -1,   -1,  384,   -1,  386,   -1,   -1,   -1,   -1,   -1,
  392,  393,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  256,   -1,   -1,   -1,  417,  418,  419,  420,  264,
  265,   -1,  267,   -1,   -1,  270,  271,   -1,  256,   -1,
  275,  276,  277,  418,  279,   -1,   -1,  265,   -1,  267,
  285,   -1,  270,  288,   -1,   -1,   -1,  275,   -1,   -1,
  295,  279,   -1,   -1,   -1,  300,   -1,  302,  303,  304,
  288,  306,   -1,   -1,   -1,   -1,   -1,  295,  313,   -1,
   -1,  316,  300,  318,  319,   -1,  304,  322,   -1,   -1,
  325,   -1,  327,   -1,  329,  330,  331,  332,  316,  334,
  318,   -1,   -1,   -1,  322,   -1,  341,   -1,   -1,  344,
  345,   -1,  330,  331,   -1,   -1,  334,   -1,   -1,  337,
   -1,   -1,   -1,   -1,  359,  360,  361,  362,  363,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  371,   -1,   -1,   -1,
   -1,   -1,  377,  378,  379,  380,   -1,   -1,   -1,  384,
   -1,  386,   -1,   -1,   -1,   -1,   -1,  392,  393,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  256,   -1,
   -1,   -1,  417,  418,  419,  420,  264,  265,   -1,  267,
   -1,   -1,  270,  271,   -1,   -1,   -1,  275,  276,  277,
  418,  279,   -1,   -1,  265,   -1,  267,  285,   -1,  270,
  288,   -1,   -1,   -1,  275,   -1,   -1,  295,  279,   -1,
   -1,   -1,  300,   -1,  302,  303,  304,  288,   -1,   -1,
   -1,   -1,   -1,   -1,  295,   -1,   -1,   -1,  316,  300,
  318,  319,  320,  304,  322,   -1,   -1,  325,   -1,  327,
   -1,  329,  330,  331,  332,  316,  334,  318,   -1,   -1,
   -1,  322,   -1,  341,   -1,   -1,  344,  345,   -1,  330,
  331,   -1,   -1,  334,   -1,   -1,  337,   -1,   -1,   -1,
   -1,  359,  360,  361,  362,  363,   -1,   -1,   -1,  367,
   -1,   -1,   -1,  371,   -1,   -1,   -1,   -1,   -1,  377,
  378,  379,  380,   -1,   -1,   -1,  384,   -1,  386,   -1,
   -1,  372,   -1,   -1,  392,  393,   -1,   -1,   -1,   -1,
   -1,   -1,  264,  265,   -1,  267,   -1,   -1,  270,  271,
   -1,   -1,   -1,  275,  276,  277,   -1,  279,   -1,  417,
  418,  419,  420,  285,   -1,   -1,  288,   -1,   -1,   -1,
   -1,   -1,   -1,  295,   -1,   -1,   -1,  418,  300,   -1,
  302,  303,  304,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  316,   -1,  318,  319,   -1,   -1,
  322,   -1,   -1,  325,   -1,  327,   -1,  329,  330,  331,
  332,   -1,  334,   -1,   -1,   -1,   -1,   -1,   -1,  341,
   -1,   -1,  344,  345,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  359,  360,  361,
  362,  363,   -1,   -1,   -1,  367,  368,   -1,   -1,  371,
   -1,   -1,   -1,   -1,   -1,  377,  378,  379,  380,   -1,
   -1,   -1,  384,   -1,  386,   -1,   -1,   -1,   -1,   -1,
  392,  393,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  256,   -1,  417,  418,  419,  420,   -1,
   -1,  264,  265,   -1,  267,   -1,  428,  270,  271,   -1,
   -1,   -1,  275,  276,  277,   -1,  279,   -1,   -1,  265,
   -1,  267,  285,   -1,  270,  288,   -1,   -1,   -1,  275,
   -1,   -1,  295,  279,   -1,   -1,   -1,  300,   -1,  302,
  303,  304,  288,   -1,   -1,   -1,   -1,   -1,   -1,  295,
   -1,   -1,   -1,  316,  300,  318,  319,  320,  304,  322,
   -1,   -1,  325,   -1,  327,   -1,  329,  330,  331,  332,
  316,  334,  318,   -1,   -1,   -1,  322,   -1,  341,   -1,
   -1,  344,  345,   -1,  330,  331,   -1,   -1,  334,   -1,
   -1,  337,   -1,   -1,   -1,   -1,  359,  360,  361,  362,
  363,   -1,   -1,   -1,  367,   -1,   -1,   -1,  371,   -1,
   -1,   -1,   -1,   -1,  377,  378,  379,  380,   -1,   -1,
   -1,  384,   -1,  386,  370,   -1,   -1,   -1,   -1,  392,
  393,   -1,   -1,   -1,   -1,   -1,   -1,  264,  265,   -1,
  267,   -1,   -1,  270,  271,   -1,   -1,   -1,  275,  276,
  277,   -1,  279,   -1,  417,  418,  419,  420,  285,   -1,
   -1,  288,   -1,   -1,   -1,   -1,   -1,   -1,  295,   -1,
   -1,   -1,  418,  300,   -1,  302,  303,  304,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  316,
   -1,  318,  319,   -1,   -1,  322,   -1,   -1,  325,   -1,
  327,   -1,  329,  330,  331,  332,   -1,  334,   -1,   -1,
   -1,   -1,   -1,   -1,  341,   -1,   -1,  344,  345,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  359,  360,  361,  362,  363,   -1,   -1,   -1,
  367,   -1,   -1,   -1,  371,   -1,   -1,   -1,   -1,   -1,
  377,  378,  379,  380,   -1,   -1,   -1,  384,   -1,  386,
   -1,   -1,   -1,   -1,   -1,  392,  393,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  256,   -1,
  417,  418,  419,  420,   -1,   -1,  264,  265,   -1,  267,
   -1,  428,  270,  271,   -1,   -1,   -1,  275,  276,  277,
   -1,  279,   -1,   -1,  265,   -1,  267,  285,   -1,  270,
  288,   -1,   -1,   -1,  275,   -1,   -1,  295,  279,   -1,
   -1,   -1,  300,   -1,  302,  303,  304,  288,   -1,   -1,
   -1,   -1,   -1,   -1,  295,   -1,   -1,   -1,  316,  300,
  318,  319,   -1,  304,  322,   -1,   -1,  325,   -1,  327,
   -1,  329,  330,  331,  332,  316,  334,  318,   -1,   -1,
   -1,  322,   -1,  341,   -1,   -1,  344,  345,   -1,  330,
  331,   -1,   -1,  334,   -1,   -1,  337,   -1,   -1,   -1,
   -1,  359,  360,  361,  362,  363,   -1,   -1,   -1,  367,
   -1,   -1,   -1,  371,   -1,   -1,   -1,   -1,   -1,  377,
  378,  379,  380,   -1,   -1,   -1,  384,   -1,  386,   -1,
   -1,   -1,   -1,   -1,  392,  393,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  256,   -1,   -1,   -1,  417,
  418,  419,  420,  264,  265,   -1,  267,   -1,   -1,  270,
  271,   -1,   -1,   -1,  275,  276,  277,  418,  279,   -1,
   -1,  265,   -1,  267,  285,   -1,  270,  288,   -1,   -1,
   -1,  275,   -1,   -1,  295,  279,   -1,   -1,   -1,  300,
   -1,  302,  303,  304,  288,   -1,   -1,   -1,   -1,   -1,
   -1,  295,   -1,   -1,   -1,  316,  300,  318,  319,   -1,
  304,  322,   -1,   -1,  325,   -1,  327,   -1,  329,  330,
  331,  332,  316,  334,  318,   -1,   -1,   -1,  322,   -1,
  341,   -1,   -1,  344,  345,   -1,  330,  331,   -1,   -1,
  334,   -1,   -1,  337,   -1,   -1,   -1,   -1,  359,  360,
  361,  362,  363,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  371,   -1,   -1,   -1,   -1,   -1,  377,  378,  379,  380,
   -1,   -1,   -1,  384,   -1,  386,   -1,   -1,   -1,   -1,
   -1,  392,  393,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  256,   -1,   -1,   -1,  417,  418,  419,  420,
  264,  265,   -1,  267,   -1,   -1,  270,  271,   -1,   -1,
   -1,  275,  276,  277,  418,  279,   -1,   -1,  265,   -1,
  267,  285,   -1,  270,  288,   -1,   -1,   -1,  275,   -1,
   -1,  295,  279,   -1,   -1,   -1,  300,   -1,  302,  303,
  304,  288,   -1,   -1,   -1,   -1,   -1,   -1,  295,   -1,
   -1,   -1,  316,  300,  318,  319,   -1,  304,  322,   -1,
   -1,  325,   -1,  327,   -1,  329,  330,  331,  332,  316,
  334,  318,   -1,   -1,   -1,  322,   -1,  341,   -1,   -1,
  344,  345,   -1,  330,  331,   -1,   -1,  334,   -1,   -1,
  337,   -1,   -1,   -1,   -1,  359,  360,  361,  362,  363,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  371,   -1,   -1,
   -1,   -1,   -1,  377,  378,  379,  380,   -1,   -1,   -1,
  384,   -1,  386,   -1,   -1,   -1,   -1,   -1,  392,  393,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  256,
   -1,   -1,   -1,  417,  418,  419,  420,  264,  265,   -1,
  267,   -1,   -1,  270,  271,   -1,   -1,   -1,  275,  276,
  277,  418,  279,   -1,   -1,  265,   -1,  267,  285,   -1,
  270,  288,   -1,   -1,   -1,  275,   -1,   -1,  295,  279,
   -1,   -1,   -1,  300,   -1,  302,  303,  304,  288,   -1,
   -1,   -1,   -1,   -1,   -1,  295,   -1,   -1,   -1,  316,
  300,  318,  319,   -1,  304,  322,   -1,   -1,  325,   -1,
  327,   -1,  329,  330,  331,  332,  316,  334,  318,   -1,
   -1,   -1,  322,   -1,  341,   -1,   -1,  344,  345,   -1,
  330,  331,   -1,   -1,  334,   -1,   -1,  337,   -1,   -1,
   -1,   -1,  359,  360,  361,  362,  363,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  371,   -1,   -1,   -1,   -1,   -1,
  377,  378,  379,  380,   -1,   -1,   -1,  384,   -1,  386,
   -1,   -1,   -1,   -1,   -1,  392,  393,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  256,   -1,   -1,   -1,
  417,  418,  419,  420,  264,  265,   -1,  267,   -1,   -1,
  270,  271,   -1,   -1,   -1,  275,  276,  277,  418,  279,
   -1,   -1,  265,   -1,  267,  285,   -1,  270,  288,   -1,
   -1,   -1,  275,   -1,   -1,  295,  279,   -1,   -1,   -1,
  300,   -1,  302,  303,  304,  288,   -1,   -1,   -1,   -1,
   -1,   -1,  295,   -1,   -1,   -1,  316,  300,  318,  319,
   -1,  304,  322,   -1,   -1,  325,   -1,  327,   -1,  329,
  330,  331,  332,  316,  334,  318,   -1,   -1,   -1,  322,
   -1,  341,   -1,   -1,  344,  345,   -1,  330,  331,   -1,
   -1,  334,   -1,   -1,  337,   -1,   -1,   -1,   -1,  359,
  360,  361,  362,  363,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  371,   -1,   -1,   -1,   -1,   -1,  377,  378,  379,
  380,   -1,   -1,   -1,  384,   -1,  386,   -1,   -1,   -1,
   -1,   -1,  392,  393,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  256,   -1,   -1,   -1,  417,  418,  419,
  420,  264,  265,   -1,  267,   -1,   -1,  270,  271,   -1,
   -1,   -1,  275,  276,  277,  418,  279,   -1,   -1,  265,
   -1,  267,  285,   -1,  270,  288,   -1,   -1,   -1,  275,
   -1,   -1,  295,  279,   -1,   -1,   -1,  300,   -1,  302,
  303,  304,  288,   -1,   -1,   -1,   -1,   -1,   -1,  295,
   -1,   -1,   -1,  316,  300,  318,  319,   -1,  304,  322,
   -1,   -1,  325,   -1,  327,   -1,  329,  330,  331,  332,
  316,  334,  318,   -1,   -1,   -1,  322,   -1,  341,   -1,
   -1,  344,  345,   -1,  330,  331,   -1,   -1,  334,   -1,
   -1,  337,   -1,   -1,   -1,   -1,  359,  360,  361,  362,
  363,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  371,   -1,
   -1,   -1,   -1,   -1,  377,  378,  379,  380,   -1,   -1,
   -1,  384,   -1,  386,   -1,   -1,   -1,   -1,   -1,  392,
  393,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  256,   -1,   -1,   -1,  417,  418,  419,  420,  264,  265,
   -1,  267,   -1,   -1,  270,  271,   -1,   -1,   -1,  275,
  276,  277,  418,  279,   -1,   -1,   -1,   -1,   -1,  285,
   -1,   -1,  288,   -1,   -1,   -1,   -1,   -1,   -1,  295,
   -1,   -1,   -1,   -1,  300,   -1,  302,  303,  304,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  262,   -1,   -1,   -1,
  316,   -1,  318,  319,   -1,   -1,  322,   -1,   -1,  325,
   -1,  327,   -1,  329,  330,  331,  332,   -1,  334,   -1,
   -1,   -1,   -1,   -1,   -1,  341,   -1,   -1,  344,  345,
   -1,   -1,  298,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  359,  360,  361,  362,  363,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  371,   -1,   -1,   -1,   -1,
   -1,  377,  378,  379,  380,   -1,   -1,   -1,  384,   -1,
  386,   -1,   -1,   -1,   -1,   -1,  392,  393,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  417,  418,  419,  420,  371,  372,  373,  374,  375,
   -1,   -1,  378,  379,   -1,   -1,  382,  383,  384,  385,
  386,  387,  388,  389,  390,   -1,  392,  393,  394,  395,
  396,  397,  398,  399,  400,  401,  402,  403,  404,  405,
  406,  407,  408,  409,  410,  411,  412,  413,   -1,  261,
   -1,  263,   -1,  265,  420,  267,   -1,  423,  270,   -1,
  272,  273,   -1,  275,   -1,  277,   -1,  279,   -1,  281,
  282,  283,  284,   -1,   -1,  287,  288,   -1,   -1,   -1,
   -1,  293,  294,  295,  296,  297,   -1,   -1,  300,   -1,
  302,   -1,  304,   -1,  306,  307,   -1,  309,  310,  311,
  312,   -1,   -1,  315,  316,  317,  318,   -1,   -1,  321,
  322,  323,   -1,   -1,   -1,   -1,   -1,   -1,  330,  331,
   -1,  333,  334,   -1,  336,  337,  338,   -1,   -1,   -1,
  342,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  362,   -1,  364,  365,  261,   -1,   -1,   -1,  265,   -1,
  267,   -1,   -1,  270,   -1,  272,  273,   -1,  275,   -1,
  277,   -1,  279,   -1,  281,  282,  283,  284,   -1,   -1,
  287,  288,   -1,   -1,   -1,   -1,  293,   -1,  295,  296,
  297,   -1,   -1,  300,   -1,  302,   -1,  304,   -1,   -1,
  307,   -1,  309,  310,  311,  312,  418,   -1,   -1,  316,
  317,  318,   -1,   -1,  321,  322,  323,   -1,   -1,   -1,
   -1,   -1,   -1,  330,  331,   -1,  333,  334,   -1,  336,
  337,  338,   -1,   -1,   -1,  342,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  261,   -1,  362,   -1,  265,   -1,  267,
   -1,  368,  270,   -1,  272,  273,   -1,  275,   -1,  277,
  377,  279,   -1,  281,  282,  283,  284,   -1,   -1,  287,
  288,   -1,   -1,   -1,   -1,  293,   -1,  295,  296,  297,
   -1,   -1,  300,   -1,  302,   -1,  304,   -1,   -1,  307,
   -1,  309,  310,  311,  312,   -1,   -1,   -1,  316,  317,
  318,  418,   -1,  321,  322,  323,   -1,   -1,   -1,   -1,
   -1,   -1,  330,  331,   -1,  333,  334,   -1,  336,  337,
  338,   -1,   -1,   -1,  342,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  261,   -1,  362,   -1,  265,   -1,  267,   -1,
  368,  270,   -1,  272,  273,   -1,  275,   -1,  277,  377,
  279,   -1,  281,  282,  283,  284,   -1,   -1,  287,  288,
   -1,   -1,   -1,   -1,  293,   -1,  295,  296,  297,   -1,
   -1,  300,   -1,  302,   -1,  304,   -1,   -1,  307,   -1,
  309,  310,  311,  312,   -1,   -1,   -1,  316,  317,  318,
  418,   -1,  321,  322,  323,   -1,   -1,   -1,   -1,   -1,
   -1,  330,  331,   -1,  333,  334,   -1,  336,  337,  338,
   -1,   -1,   -1,  342,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  261,   -1,   -1,   -1,
  265,   -1,  267,  362,   -1,  270,   -1,  272,  273,  368,
  275,   -1,  277,   -1,  279,   -1,  281,  282,  283,  284,
   -1,   -1,  287,  288,   -1,   -1,   -1,   -1,  293,   -1,
  295,  296,  297,   -1,   -1,  300,   -1,  302,   -1,  304,
   -1,   -1,  307,   -1,  309,  310,  311,  312,   -1,   -1,
   -1,  316,  317,  318,   -1,   -1,  321,  322,  323,  418,
   -1,   -1,   -1,   -1,   -1,  330,  331,   -1,  333,  334,
   -1,  336,  337,  338,   -1,   -1,   -1,  342,   -1,   -1,
   -1,   -1,  261,   -1,   -1,   -1,  265,   -1,  267,   -1,
   -1,  270,   -1,  272,  273,   -1,  275,  362,  277,   -1,
  279,   -1,  281,  282,  283,  284,   -1,   -1,  287,  288,
   -1,   -1,  377,   -1,  293,   -1,  295,  296,  297,   -1,
   -1,  300,   -1,  302,  261,  304,   -1,   -1,  307,   -1,
  309,  310,  311,  312,   -1,   -1,   -1,  316,  317,  318,
   -1,   -1,  321,  322,  323,   -1,   -1,  284,   -1,   -1,
   -1,  330,  331,  418,  333,  334,   -1,  336,  337,  338,
  297,   -1,   -1,  342,   -1,  302,   -1,   -1,  305,   -1,
  307,   -1,  309,  310,  311,  312,   -1,   -1,   -1,   -1,
  317,   -1,   -1,  362,  321,   -1,   -1,   -1,  325,  368,
   -1,   -1,   -1,   -1,   -1,   -1,  333,   -1,   -1,  336,
   -1,  338,  264,  265,   -1,  267,   -1,   -1,  270,  271,
   -1,   -1,   -1,  275,  276,  277,   -1,  279,   -1,   -1,
  357,   -1,   -1,  285,   -1,  362,  288,   -1,   -1,   -1,
   -1,   -1,  369,  295,  371,   -1,  373,   -1,  300,  418,
  302,  303,  304,   -1,  306,   -1,   -1,   -1,   -1,  386,
   -1,  313,   -1,   -1,  316,   -1,  318,  319,   -1,   -1,
  322,   -1,   -1,  325,   -1,  327,   -1,  329,  330,  331,
  332,   -1,  334,   -1,   -1,   -1,   -1,   -1,   -1,  341,
   -1,  418,  344,  345,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  359,  360,  361,
  362,  363,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  371,
  372,   -1,  374,   -1,   -1,  377,  378,  379,  380,   -1,
   -1,   -1,  384,   -1,  386,   -1,   -1,   -1,   -1,   -1,
  392,  393,   -1,   -1,   -1,   -1,   -1,   -1,  264,  265,
   -1,  267,   -1,   -1,  270,  271,   -1,   -1,   -1,  275,
  276,  277,   -1,  279,   -1,  417,  418,  419,  420,  285,
   -1,   -1,  288,   -1,   -1,   -1,   -1,   -1,   -1,  295,
   -1,   -1,   -1,   -1,  300,   -1,  302,  303,  304,   -1,
  306,   -1,   -1,   -1,   -1,   -1,   -1,  313,   -1,   -1,
  316,   -1,  318,  319,   -1,   -1,  322,   -1,   -1,  325,
   -1,  327,   -1,  329,  330,  331,  332,   -1,  334,   -1,
   -1,   -1,   -1,   -1,   -1,  341,   -1,   -1,  344,  345,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  359,  360,  361,  362,  363,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  371,   -1,   -1,  374,   -1,
   -1,  377,  378,  379,  380,   -1,   -1,   -1,  384,   -1,
  386,   -1,   -1,   -1,   -1,   -1,  392,  393,   -1,   -1,
   -1,   -1,   -1,   -1,  264,  265,   -1,  267,   -1,   -1,
  270,  271,   -1,   -1,   -1,  275,  276,  277,   -1,  279,
   -1,  417,  418,  419,  420,  285,   -1,   -1,  288,   -1,
   -1,   -1,   -1,   -1,   -1,  295,   -1,   -1,   -1,   -1,
  300,   -1,  302,  303,  304,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  316,   -1,  318,  319,
   -1,   -1,  322,   -1,   -1,  325,   -1,  327,   -1,  329,
  330,  331,  332,   -1,  334,   -1,   -1,  337,   -1,   -1,
   -1,  341,   -1,   -1,  344,  345,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  359,
  360,  361,  362,  363,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  371,   -1,   -1,   -1,   -1,   -1,  377,  378,  379,
  380,   -1,   -1,   -1,  384,   -1,  386,   -1,   -1,   -1,
   -1,   -1,  392,  393,   -1,   -1,   -1,   -1,   -1,   -1,
  264,  265,   -1,  267,   -1,   -1,  270,  271,   -1,   -1,
   -1,  275,  276,  277,   -1,  279,   -1,  417,  418,  419,
  420,  285,   -1,   -1,  288,   -1,   -1,   -1,   -1,   -1,
   -1,  295,   -1,   -1,   -1,   -1,  300,   -1,  302,  303,
  304,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  316,   -1,  318,  319,   -1,   -1,  322,   -1,
   -1,  325,   -1,  327,   -1,  329,  330,  331,  332,   -1,
  334,   -1,   -1,   -1,   -1,   -1,   -1,  341,   -1,   -1,
  344,  345,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  359,  360,  361,  362,  363,
   -1,   -1,   -1,   -1,  368,   -1,   -1,  371,   -1,   -1,
   -1,   -1,   -1,  377,  378,  379,  380,   -1,   -1,   -1,
  384,   -1,  386,   -1,   -1,   -1,   -1,   -1,  392,  393,
   -1,   -1,   -1,   -1,   -1,   -1,  264,  265,   -1,  267,
   -1,   -1,  270,  271,   -1,   -1,   -1,  275,  276,  277,
   -1,  279,   -1,  417,  418,  419,  420,  285,   -1,   -1,
  288,   -1,   -1,   -1,   -1,   -1,   -1,  295,   -1,   -1,
   -1,   -1,  300,   -1,  302,  303,  304,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  316,   -1,
  318,  319,   -1,   -1,  322,   -1,   -1,  325,   -1,  327,
   -1,  329,  330,  331,  332,   -1,  334,   -1,   -1,   -1,
   -1,   -1,   -1,  341,   -1,   -1,  344,  345,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  359,  360,  361,  362,  363,   -1,   -1,   -1,  367,
   -1,   -1,   -1,  371,   -1,   -1,   -1,   -1,   -1,  377,
  378,  379,  380,   -1,   -1,   -1,  384,   -1,  386,   -1,
   -1,   -1,   -1,   -1,  392,  393,   -1,   -1,   -1,   -1,
   -1,   -1,  264,  265,   -1,  267,   -1,   -1,  270,  271,
   -1,   -1,   -1,  275,  276,  277,   -1,  279,   -1,  417,
  418,  419,  420,  285,   -1,   -1,  288,   -1,   -1,   -1,
   -1,   -1,   -1,  295,   -1,   -1,   -1,   -1,  300,   -1,
  302,  303,  304,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  316,   -1,  318,  319,   -1,   -1,
  322,   -1,   -1,  325,   -1,  327,   -1,  329,  330,  331,
  332,   -1,  334,   -1,   -1,   -1,   -1,   -1,   -1,  341,
   -1,   -1,  344,  345,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  359,  360,  361,
  362,  363,   -1,   -1,   -1,  367,   -1,   -1,   -1,  371,
   -1,   -1,   -1,   -1,   -1,  377,  378,  379,  380,   -1,
   -1,   -1,  384,   -1,  386,   -1,   -1,   -1,   -1,   -1,
  392,  393,   -1,   -1,   -1,   -1,   -1,   -1,  264,  265,
   -1,  267,   -1,   -1,  270,  271,   -1,   -1,   -1,  275,
  276,  277,   -1,  279,   -1,  417,  418,  419,  420,  285,
   -1,   -1,  288,   -1,   -1,   -1,   -1,   -1,   -1,  295,
   -1,   -1,   -1,   -1,  300,   -1,  302,  303,  304,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  316,   -1,  318,  319,   -1,   -1,  322,   -1,   -1,  325,
   -1,  327,   -1,  329,  330,  331,  332,   -1,  334,   -1,
   -1,   -1,   -1,   -1,   -1,  341,   -1,   -1,  344,  345,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  359,  360,  361,  362,  363,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  371,   -1,   -1,   -1,   -1,
   -1,  377,  378,  379,  380,   -1,   -1,   -1,  384,   -1,
  386,   -1,   -1,   -1,   -1,   -1,  392,  393,   -1,   -1,
   -1,   -1,   -1,   -1,  264,  265,   -1,  267,   -1,   -1,
  270,  271,   -1,   -1,   -1,  275,  276,  277,   -1,  279,
   -1,  417,  418,  419,  420,  285,   -1,   -1,  288,   -1,
   -1,   -1,   -1,   -1,   -1,  295,   -1,   -1,   -1,   -1,
  300,   -1,  302,  303,  304,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  316,   -1,  318,  319,
   -1,   -1,  322,   -1,   -1,  325,   -1,  327,   -1,  329,
  330,  331,  332,   -1,  334,   -1,   -1,   -1,   -1,   -1,
   -1,  341,   -1,   -1,  344,  345,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  359,
  360,  361,  362,  363,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  371,   -1,   -1,   -1,   -1,   -1,  377,  378,  379,
  380,   -1,   -1,   -1,  384,   -1,  386,   -1,   -1,   -1,
   -1,   -1,  392,  393,   -1,   -1,   -1,   -1,   -1,   -1,
  264,  265,   -1,  267,   -1,   -1,  270,  271,   -1,   -1,
   -1,  275,  276,  277,   -1,  279,   -1,  417,  418,  419,
  420,  285,   -1,   -1,  288,   -1,   -1,   -1,   -1,   -1,
   -1,  295,   -1,   -1,   -1,   -1,  300,   -1,  302,  303,
  304,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  316,   -1,  318,  319,   -1,   -1,  322,   -1,
   -1,  325,   -1,  327,   -1,  329,  330,  331,  332,   -1,
  334,   -1,   -1,   -1,   -1,   -1,   -1,  341,   -1,   -1,
  344,  345,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  359,  360,  361,  362,  363,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  371,   -1,   -1,
   -1,   -1,   -1,  377,  378,  379,  380,   -1,   -1,   -1,
  384,   -1,  386,   -1,   -1,   -1,   -1,   -1,  392,  393,
   -1,   -1,   -1,   -1,   -1,   -1,  264,  265,   -1,  267,
   -1,   -1,  270,  271,   -1,   -1,   -1,  275,  276,  277,
   -1,  279,   -1,  417,  418,  419,  420,  285,   -1,   -1,
  288,   -1,   -1,   -1,   -1,   -1,   -1,  295,   -1,   -1,
   -1,   -1,  300,   -1,  302,  303,  304,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  316,   -1,
  318,  319,   -1,   -1,  322,   -1,   -1,  325,   -1,  327,
   -1,  329,  330,  331,  332,   -1,  334,   -1,   -1,   -1,
   -1,   -1,   -1,  341,   -1,   -1,  344,  345,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  359,  360,  361,  362,  363,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  371,   -1,   -1,   -1,   -1,   -1,  377,
  378,  379,  380,   -1,   -1,   -1,  384,   -1,  386,   -1,
   -1,   -1,   -1,   -1,  392,  393,   -1,   -1,   -1,   -1,
   -1,   -1,  264,  265,   -1,  267,   -1,   -1,  270,  271,
   -1,   -1,   -1,  275,  276,  277,   -1,  279,   -1,  417,
  418,  419,  420,  285,   -1,   -1,  288,   -1,   -1,   -1,
   -1,   -1,   -1,  295,   -1,   -1,   -1,   -1,  300,   -1,
  302,  303,  304,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  316,   -1,  318,  319,   -1,   -1,
  322,   -1,   -1,  325,   -1,  327,   -1,  329,  330,  331,
  332,   -1,  334,   -1,   -1,   -1,   -1,   -1,   -1,  341,
   -1,   -1,  344,  345,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  359,  360,  361,
  362,  363,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  371,
   -1,   -1,   -1,   -1,   -1,  377,  378,  379,  380,   -1,
   -1,   -1,  384,   -1,  386,   -1,   -1,   -1,   -1,   -1,
  392,  393,   -1,   -1,   -1,   -1,   -1,   -1,  264,  265,
   -1,  267,   -1,   -1,  270,  271,   -1,   -1,   -1,  275,
  276,  277,   -1,  279,   -1,  417,  418,  419,  420,  285,
   -1,   -1,  288,   -1,   -1,   -1,   -1,   -1,   -1,  295,
   -1,  261,   -1,   -1,  300,   -1,  302,  303,  304,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  316,   -1,  318,  319,  284,   -1,  322,   -1,   -1,  325,
   -1,  327,   -1,  329,  330,  331,  332,  297,  334,   -1,
   -1,   -1,  302,   -1,   -1,   -1,   -1,  307,   -1,  309,
  310,  311,  312,   -1,   -1,  315,   -1,  317,   -1,   -1,
   -1,  321,   -1,  359,  360,  361,  362,  363,   -1,   -1,
   -1,   -1,   -1,  333,   -1,  371,  336,   -1,  338,   -1,
   -1,  377,  378,  379,  380,   -1,   -1,   -1,  384,   -1,
  386,   -1,   -1,   -1,   -1,   -1,  392,  393,   -1,   -1,
   -1,   -1,  362,   -1,   -1,   -1,   -1,   -1,  368,  369,
   -1,   -1,   -1,   -1,   -1,   -1,  263,   -1,  265,   -1,
  267,  417,  418,  270,  420,  272,  273,   -1,  275,   -1,
  277,   -1,  279,   -1,  281,  282,  283,   -1,   -1,   -1,
  287,  288,   -1,   -1,   -1,   -1,  293,   -1,  295,  296,
   -1,   -1,   -1,  300,   -1,   -1,   -1,  304,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  315,  316,
   -1,  318,   -1,   -1,   -1,  322,  323,   -1,   -1,   -1,
   -1,   -1,   -1,  330,  331,  264,  265,  334,  267,   -1,
  337,  270,  271,   -1,   -1,  342,  275,  276,  277,   -1,
  279,   -1,   -1,   -1,   -1,   -1,  285,   -1,   -1,  288,
   -1,   -1,   -1,   -1,   -1,   -1,  295,  364,  365,   -1,
   -1,  300,   -1,  302,  303,  304,   -1,   -1,   -1,   -1,
  377,   -1,   -1,   -1,   -1,   -1,   -1,  316,   -1,  318,
  319,   -1,   -1,  322,   -1,   -1,  325,   -1,  327,   -1,
  329,  330,  331,  332,   -1,  334,   -1,   -1,  337,   -1,
   -1,   -1,   -1,   -1,   -1,  265,   -1,  267,   -1,   -1,
  270,  418,  272,   -1,   -1,  275,   -1,   -1,   -1,  279,
  359,  360,  361,  362,   -1,   -1,   -1,   -1,  288,  265,
   -1,  267,  371,   -1,  270,  295,  272,  273,   -1,  275,
  300,  277,  302,  279,  304,  281,  282,  283,   -1,   -1,
   -1,  287,  288,   -1,   -1,   -1,  316,  293,  318,  295,
  296,   -1,  322,  323,  300,   -1,   -1,   -1,  304,   -1,
  330,  331,   -1,   -1,  334,   -1,   -1,  337,  417,  418,
  316,   -1,  318,   -1,   -1,   -1,  322,  323,   -1,   -1,
   -1,   -1,   -1,   -1,  330,  331,   -1,  265,  334,  267,
   -1,  337,  270,   -1,  272,  273,  342,  275,   -1,  277,
   -1,  279,   -1,  281,  282,  283,   -1,   -1,   -1,  287,
  288,   -1,   -1,   -1,   -1,  293,   -1,  295,  296,   -1,
   -1,   -1,  300,   -1,   -1,   -1,  304,   -1,   -1,   -1,
   -1,  377,   -1,   -1,   -1,   -1,   -1,   -1,  316,   -1,
  318,   -1,   -1,   -1,  322,  323,   -1,   -1,  418,   -1,
   -1,   -1,  330,  331,   -1,   -1,  334,   -1,   -1,  337,
   -1,  265,   -1,  267,  342,   -1,  270,   -1,   -1,  273,
   -1,  275,  418,  277,   -1,  279,   -1,  281,  282,  283,
   -1,   -1,   -1,  287,  288,   -1,   -1,   -1,   -1,  293,
   -1,  295,   -1,  265,   -1,  267,  300,   -1,  270,   -1,
  304,  273,   -1,  275,   -1,  277,   -1,  279,   -1,  281,
  282,  283,  316,   -1,  318,  287,  288,   -1,  322,   -1,
   -1,  293,   -1,  295,   -1,   -1,  330,  331,  300,   -1,
  334,   -1,  304,  337,   -1,   -1,   -1,  265,  342,  267,
  418,   -1,  270,   -1,  316,   -1,  318,  275,   -1,   -1,
  322,  279,   -1,   -1,   -1,   -1,   -1,   -1,  330,  331,
  288,   -1,  334,   -1,   -1,  337,   -1,  295,   -1,  265,
  342,  267,  300,  377,  270,   -1,  304,   -1,  306,  275,
  308,   -1,   -1,  279,   -1,  313,   -1,   -1,  316,   -1,
  318,   -1,  288,   -1,  322,   -1,   -1,  325,   -1,  295,
   -1,   -1,  330,  331,  300,   -1,  334,   -1,  304,  337,
  306,   -1,  308,  265,  418,  267,   -1,  313,  270,   -1,
  316,   -1,  318,  275,   -1,   -1,  322,  279,   -1,  325,
   -1,   -1,   -1,   -1,  330,  331,  288,   -1,  334,   -1,
   -1,  337,   -1,  295,  372,  265,  418,  267,  300,   -1,
  270,   -1,  304,   -1,  306,  275,  308,   -1,   -1,  279,
   -1,  313,   -1,   -1,  316,   -1,  318,   -1,  288,   -1,
  322,   -1,   -1,  325,  370,  295,   -1,   -1,  330,  331,
  300,   -1,  334,   -1,  304,  337,  306,   -1,  308,  265,
  418,  267,   -1,  313,  270,   -1,  316,   -1,  318,  275,
   -1,   -1,  322,  279,   -1,  325,   -1,   -1,   -1,   -1,
  330,  331,  288,   -1,  334,   -1,   -1,  337,   -1,  295,
   -1,   -1,  418,   -1,  300,   -1,   -1,   -1,  304,   -1,
  306,   -1,   -1,   -1,  265,   -1,  267,  313,   -1,  270,
  316,   -1,  318,   -1,  275,   -1,  322,   -1,  279,  325,
   -1,   -1,  283,   -1,  330,  331,   -1,  288,  334,   -1,
   -1,  337,  293,   -1,  295,   -1,  418,   -1,   -1,  300,
   -1,   -1,   -1,  304,  305,   -1,   -1,   -1,  265,   -1,
  267,   -1,   -1,  270,   -1,  316,   -1,  318,  275,   -1,
   -1,  322,  279,   -1,   -1,   -1,   -1,   -1,  418,  330,
  331,  288,  265,  334,  267,   -1,   -1,  270,  295,   -1,
   -1,   -1,  275,  300,   -1,   -1,  279,  304,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  288,   -1,   -1,   -1,  316,
   -1,  318,  295,   -1,   -1,  322,   -1,  300,   -1,   -1,
   -1,  304,  418,  330,  331,   -1,   -1,  334,   -1,   -1,
  337,   -1,   -1,  316,   -1,  318,  265,   -1,  267,  322,
   -1,  270,   -1,   -1,   -1,   -1,  275,  330,  331,   -1,
  279,  334,   -1,   -1,  337,   -1,  363,   -1,   -1,  288,
   -1,   -1,   -1,   -1,   -1,   -1,  295,  418,   -1,   -1,
   -1,  300,   -1,   -1,  261,  304,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  272,   -1,  316,   -1,  318,
  277,   -1,   -1,  322,  281,   -1,   -1,  284,   -1,   -1,
   -1,  330,  331,   -1,   -1,  334,   -1,   -1,  337,  296,
  297,  418,   -1,   -1,  301,  302,   -1,   -1,   -1,   -1,
  307,   -1,  309,  310,  311,  312,   -1,   -1,   -1,   -1,
  317,   -1,   -1,   -1,  321,  418,  323,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  333,   -1,  335,  336,
  261,  338,   -1,   -1,   -1,  342,   -1,   -1,   -1,   -1,
   -1,  272,   -1,   -1,   -1,   -1,  277,   -1,   -1,   -1,
  281,   -1,   -1,  284,   -1,  362,   -1,   -1,   -1,   -1,
   -1,  368,  369,   -1,   -1,  296,  297,   -1,   -1,  418,
  301,  302,  261,   -1,  263,   -1,  307,   -1,  309,  310,
  311,  312,   -1,   -1,   -1,   -1,  317,   -1,   -1,   -1,
  321,   -1,  323,   -1,   -1,  284,   -1,   -1,   -1,   -1,
   -1,   -1,  333,   -1,   -1,  336,   -1,  338,  297,   -1,
   -1,  342,   -1,  302,   -1,   -1,   -1,   -1,  307,   -1,
  309,  310,  311,  312,   -1,   -1,   -1,   -1,  317,   -1,
   -1,  362,  321,   -1,   -1,  261,   -1,  368,  369,   -1,
   -1,   -1,   -1,   -1,  333,   -1,  272,  336,   -1,  338,
   -1,  277,   -1,   -1,   -1,  281,   -1,   -1,  284,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  296,  297,   -1,  362,   -1,  301,  302,   -1,  261,  368,
  369,  307,   -1,  309,  310,  311,  312,   -1,   -1,  272,
   -1,  317,   -1,   -1,  277,  321,   -1,  323,  281,   -1,
   -1,  284,   -1,   -1,   -1,   -1,   -1,  333,   -1,   -1,
  336,   -1,  338,  296,  297,   -1,  342,   -1,  301,  302,
  261,   -1,   -1,   -1,  307,   -1,  309,  310,  311,  312,
   -1,   -1,   -1,   -1,  317,   -1,  362,   -1,  321,   -1,
  323,   -1,  368,  284,   -1,   -1,   -1,   -1,   -1,   -1,
  333,   -1,   -1,  336,   -1,  338,  297,   -1,  261,  342,
   -1,  302,   -1,   -1,   -1,   -1,  307,   -1,  309,  310,
  311,  312,   -1,   -1,   -1,   -1,  317,   -1,   -1,  362,
  321,  284,   -1,   -1,   -1,  368,   -1,   -1,   -1,   -1,
   -1,   -1,  333,   -1,  297,  336,  261,  338,   -1,  302,
   -1,   -1,   -1,   -1,  307,   -1,  309,  310,  311,  312,
   -1,   -1,   -1,   -1,  317,   -1,   -1,   -1,  321,  284,
   -1,  362,   -1,  364,  365,   -1,   -1,  368,   -1,   -1,
  333,   -1,  297,  336,  261,  338,  263,  302,   -1,   -1,
   -1,   -1,  307,   -1,  309,  310,  311,  312,   -1,   -1,
  315,   -1,  317,   -1,   -1,   -1,  321,  284,   -1,  362,
   -1,  364,  365,   -1,   -1,  368,   -1,   -1,  333,   -1,
  297,  336,  261,  338,  263,  302,   -1,   -1,   -1,   -1,
  307,   -1,  309,  310,  311,  312,   -1,   -1,   -1,   -1,
  317,   -1,   -1,   -1,  321,  284,   -1,  362,   -1,   -1,
   -1,   -1,  261,  368,   -1,   -1,  333,   -1,  297,  336,
   -1,  338,   -1,  302,   -1,   -1,   -1,   -1,  307,   -1,
  309,  310,  311,  312,   -1,  284,  315,   -1,  317,   -1,
   -1,   -1,  321,   -1,  261,  362,   -1,   -1,  297,   -1,
   -1,  368,  301,  302,  333,   -1,   -1,  336,  307,  338,
  309,  310,  311,  312,   -1,   -1,   -1,  284,  317,   -1,
   -1,   -1,  321,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  297,   -1,   -1,  362,  333,  302,   -1,  336,   -1,  338,
  307,   -1,  309,  310,  311,  312,   -1,   -1,   -1,   -1,
  317,   -1,   -1,   -1,  321,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  362,   -1,   -1,  333,   -1,   -1,  336,
   -1,  338,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  362,
  };

#line 6611 "cs-parser.jay"

// <summary>
//  A class used to hold info about an operator declarator
// </summary>
class OperatorDeclaration {
	public readonly Operator.OpType optype;
	public readonly FullNamedExpression ret_type;
	public readonly Location location;

	public OperatorDeclaration (Operator.OpType op, FullNamedExpression ret_type, Location location)
	{
		optype = op;
		this.ret_type = ret_type;
		this.location = location;
	}
}

void Error_ExpectingTypeName (Expression expr)
{
	if (expr is Invocation){
		report.Error (1002, expr.Location, "Expecting `;'");
	} else {
		Expression.Error_InvalidExpressionStatement (report, expr.Location);
	}
}

void Error_ParameterModifierNotValid (string modifier, Location loc)
{
	report.Error (631, loc, "The parameter modifier `{0}' is not valid in this context",
			              modifier);
}

void Error_DuplicateParameterModifier (Location loc, Parameter.Modifier mod)
{
	report.Error (1107, loc, "Duplicate parameter modifier `{0}'",
  		Parameter.GetModifierSignature (mod));
}

void Error_TypeExpected (Location loc)
{
	report.Error (1031, loc, "Type expected");
}

void Error_UnsafeCodeNotAllowed (Location loc)
{
	report.Error (227, loc, "Unsafe code requires the `unsafe' command line option to be specified");
}

void Warning_EmptyStatement (Location loc)
{
	report.Warning (642, 3, loc, "Possible mistaken empty statement");
}

void Error_NamedArgumentExpected (NamedArgument a)
{
	report.Error (1738, a.Location, "Named arguments must appear after the positional arguments");
}

void Error_MissingInitializer (Location loc)
{
	report.Error (210, loc, "You must provide an initializer in a fixed or using statement declaration");
}

void push_current_container (TypeDefinition tc, object partial_token)
{
	if (module.Evaluator != null){
		tc.Definition.Modifiers = tc.ModFlags = (tc.ModFlags & ~Modifiers.AccessibilityMask) | Modifiers.PUBLIC;
		if (undo == null)
			undo = new Undo ();

		undo.AddTypeContainer (current_container, tc);
	}
	
	if (partial_token != null)
		current_container.AddPartial (tc);
	else
		current_container.AddTypeContainer (tc);
		
	++lexer.parsing_declaration;
	current_container = tc;
	current_type = tc;
}

TypeContainer pop_current_class ()
{
	var retval = current_container;

	current_container = current_container.Parent;
	current_type = current_type.Parent as TypeDefinition;

	return retval;
}

[System.Diagnostics.Conditional ("FULL_AST")]
void StoreModifierLocation (object token, Location loc)
{
	if (lbag == null)
		return;

	if (mod_locations == null)
  		mod_locations = new List<Tuple<Modifiers, Location>> ();

	mod_locations.Add (Tuple.Create ((Modifiers) token, loc));
}

List<Tuple<Modifiers, Location>> GetModifierLocations ()
{
	var result = mod_locations;
	mod_locations = null;
	return result;
}

string CheckAttributeTarget (string a, Location l)
{
	switch (a) {
	case "assembly" : case "module" : case "field" : case "method" : case "param" : case "property" : case "type" :
			return a;
	}

	report.Warning (658, 1, l,
		 "`{0}' is invalid attribute target. All attributes in this attribute section will be ignored", a);
	return string.Empty;
}

static bool IsUnaryOperator (Operator.OpType op)
{
	switch (op) {
		
	case Operator.OpType.LogicalNot: 
	case Operator.OpType.OnesComplement: 
	case Operator.OpType.Increment:
	case Operator.OpType.Decrement:
	case Operator.OpType.True: 
	case Operator.OpType.False: 
	case Operator.OpType.UnaryPlus: 
	case Operator.OpType.UnaryNegation:
		return true;
	}
	return false;
}

void syntax_error (Location l, string msg)
{
	report.Error (1003, l, "Syntax error, " + msg);
}

Tokenizer lexer;

public Tokenizer Lexer {
	get {
		return lexer;
	}
}		   

static CSharpParser ()
{
	oob_stack = new Stack<object> ();
}

public CSharpParser (SeekableStreamReader reader, CompilationSourceFile file)
	: this (reader, file, file.Compiler.Report)
{
}

public CSharpParser (SeekableStreamReader reader, CompilationSourceFile file, Report report)
{
	this.file = file;
	current_container = current_namespace = file;
	
	this.module = file.Module;
	this.compiler = file.Compiler;
	this.settings = compiler.Settings;
	this.report = report;
	
	lang_version = settings.Version;
	yacc_verbose_flag = settings.VerboseParserFlag;
	doc_support = settings.DocumentationFile != null;
	oob_stack.Clear ();
	lexer = new Tokenizer (reader, file);

#if FULL_AST
	lbag = new LocationsBag ();
#else
	lbag = null;
#endif
	
	use_global_stacks = true;
}

public void parse ()
{
	eof_token = Token.EOF;
	Tokenizer.LocatedToken.Initialize ();
	
	try {
		if (yacc_verbose_flag > 1)
			yyparse (lexer, new yydebug.yyDebugSimple ());
		else
			yyparse (lexer);
			
		Tokenizer tokenizer = lexer as Tokenizer;
		tokenizer.cleanup ();		
	} catch (Exception e){
	  	if (e is yyParser.yyUnexpectedEof) {
			Error_SyntaxError (yyToken);
			UnexpectedEOF = true;
			return;
		}
			
		if (e is yyParser.yyException) {
			report.Error (-25, lexer.Location, "Parsing error");
		} else {
			// Used by compiler-tester to test internal errors
			if (yacc_verbose_flag > 0 || e is FatalException)
				throw;
		
			report.Error (589, lexer.Location, "Internal compiler error during parsing" + e);
		}
	}
}

void CheckToken (int error, int yyToken, string msg, Location loc)
{
	if (yyToken >= Token.FIRST_KEYWORD && yyToken <= Token.LAST_KEYWORD)
		report.Error (error, loc, "{0}: `{1}' is a keyword", msg, GetTokenName (yyToken));
	else
		report.Error (error, loc, msg);
}

string ConsumeStoredComment ()
{
	string s = tmpComment;
	tmpComment = null;
	Lexer.doc_state = XmlCommentState.Allowed;
	return s;
}

void FeatureIsNotAvailable (Location loc, string feature)
{
	report.FeatureIsNotAvailable (compiler, loc, feature);
}

Location GetLocation (object obj)
{
	var lt = obj as Tokenizer.LocatedToken;
	if (lt != null)
		return lt.Location;
		
	var mn = obj as MemberName;
	if (mn != null)
		return mn.Location;
		
	var expr = obj as Expression;
	if (expr != null)
		return expr.Location;

	return lexer.Location;
}

public LocationsBag LocationsBag {
	get {
		return lbag;
	}
}

void start_block (Location loc)
{
	if (current_block == null) {
		current_block = new ToplevelBlock (compiler, current_local_parameters, loc);
		parsing_anonymous_method = false;
	} else if (parsing_anonymous_method) {
		current_block = new ParametersBlock (current_block, current_local_parameters, loc);
		parsing_anonymous_method = false;
	} else {
		current_block = new ExplicitBlock (current_block, loc, Location.Null);
	}
}

Block
end_block (Location loc)
{
	Block retval = current_block.Explicit;
	retval.SetEndLocation (loc);
	current_block = retval.Parent;
	return retval;
}

void start_anonymous (bool isLambda, ParametersCompiled parameters, bool isAsync, Location loc)
{
	oob_stack.Push (current_anonymous_method);
	oob_stack.Push (current_local_parameters);
	oob_stack.Push (current_variable);
	oob_stack.Push (async_block);

	current_local_parameters = parameters;
	if (isLambda) {
		if (lang_version <= LanguageVersion.ISO_2)
			FeatureIsNotAvailable (loc, "lambda expressions");

		current_anonymous_method = new LambdaExpression (loc);
	} else {
		if (lang_version == LanguageVersion.ISO_1)
			FeatureIsNotAvailable (loc, "anonymous methods");
			
		current_anonymous_method = new AnonymousMethodExpression (loc);
	}
	current_anonymous_method.IsAsync = isAsync;
	
	async_block = isAsync;
	// Force the next block to be created as a ToplevelBlock
	parsing_anonymous_method = true;
}

/*
 * Completes the anonymous method processing, if lambda_expr is null, this
 * means that we have a Statement instead of an Expression embedded 
 */
AnonymousMethodExpression end_anonymous (ParametersBlock anon_block)
{
	AnonymousMethodExpression retval;

	if (async_block)
		anon_block.IsAsync = true;

	current_anonymous_method.Block = anon_block;
	retval = current_anonymous_method;

	async_block = (bool) oob_stack.Pop ();
	current_variable = (BlockVariableDeclaration) oob_stack.Pop ();
	current_local_parameters = (ParametersCompiled) oob_stack.Pop ();
	current_anonymous_method = (AnonymousMethodExpression) oob_stack.Pop ();

	return retval;
}

void Error_SyntaxError (int token)
{
	Error_SyntaxError (0, token);
}

void Error_SyntaxError (int error_code, int token)
{
	Error_SyntaxError (error_code, token, "Unexpected symbol");
}

void Error_SyntaxError (int error_code, int token, string msg)
{
	Lexer.CompleteOnEOF = false;

	// An error message has been reported by tokenizer
	if (token == Token.ERROR)
		return;

	string symbol = GetSymbolName (token);
	string expecting = GetExpecting ();
	var loc = lexer.Location - symbol.Length;
	
	if (error_code == 0) {
		if (expecting == "`identifier'") {
			if (token > Token.FIRST_KEYWORD && token < Token.LAST_KEYWORD) {
				report.Error (1041, loc, "Identifier expected, `{0}' is a keyword", symbol);
				return;
			}
			
			error_code = 1001;
			expecting = "identifier";
		} else if (expecting == "`)'") {
			error_code = 1026;
		} else {
			error_code = 1525;
		}
	}
	
	if (string.IsNullOrEmpty (expecting))
		report.Error (error_code, loc, "{1} `{0}'", symbol, msg);
	else
		report.Error (error_code, loc, "{2} `{0}', expecting {1}", symbol, expecting, msg);	  
}

string GetExpecting ()
{
	int [] tokens = yyExpectingTokens (yyExpectingState);
	var names = new List<string> (tokens.Length);
	bool has_type = false;
	bool has_identifier = false;
	for (int i = 0; i < tokens.Length; i++){
		int token = tokens [i];
		has_identifier |= token == Token.IDENTIFIER;
		
		string name = GetTokenName (token);
		if (name == "<internal>")
			continue;
			
		has_type |= name == "type";
		if (names.Contains (name))
			continue;
		
		names.Add (name);
	}

	//
	// Too many tokens to enumerate
	//
	if (names.Count > 8)
		return null;

	if (has_type && has_identifier)
		names.Remove ("identifier");

	if (names.Count == 1)
		return "`" + GetTokenName (tokens [0]) + "'";
	
	StringBuilder sb = new StringBuilder ();
	names.Sort ();
	int count = names.Count;
	for (int i = 0; i < count; i++){
		bool last = i + 1 == count;
		if (last)
			sb.Append ("or ");
		sb.Append ('`');
		sb.Append (names [i]);
		sb.Append (last ? "'" : count < 3 ? "' " : "', ");
	}
	return sb.ToString ();
}


string GetSymbolName (int token)
{
	switch (token){
	case Token.LITERAL:
		return ((Constant)lexer.Value).GetValue ().ToString ();
	case Token.IDENTIFIER:
		return ((Tokenizer.LocatedToken)lexer.Value).Value;

	case Token.BOOL:
		return "bool";
	case Token.BYTE:
		return "byte";
	case Token.CHAR:
		return "char";
	case Token.VOID:
		return "void";
	case Token.DECIMAL:
		return "decimal";
	case Token.DOUBLE:
		return "double";
	case Token.FLOAT:
		return "float";
	case Token.INT:
		return "int";
	case Token.LONG:
		return "long";
	case Token.SBYTE:
		return "sbyte";
	case Token.SHORT:
		return "short";
	case Token.STRING:
		return "string";
	case Token.UINT:
		return "uint";
	case Token.ULONG:
		return "ulong";
	case Token.USHORT:
		return "ushort";
	case Token.OBJECT:
		return "object";
		
	case Token.PLUS:
		return "+";
	case Token.UMINUS:
	case Token.MINUS:
		return "-";
	case Token.BANG:
		return "!";
	case Token.BITWISE_AND:
		return "&";
	case Token.BITWISE_OR:
		return "|";
	case Token.STAR:
		return "*";
	case Token.PERCENT:
		return "%";
	case Token.DIV:
		return "/";
	case Token.CARRET:
		return "^";
	case Token.OP_INC:
		return "++";
	case Token.OP_DEC:
		return "--";
	case Token.OP_SHIFT_LEFT:
		return "<<";
	case Token.OP_SHIFT_RIGHT:
		return ">>";
	case Token.OP_LT:
		return "<";
	case Token.OP_GT:
		return ">";
	case Token.OP_LE:
		return "<=";
	case Token.OP_GE:
		return ">=";
	case Token.OP_EQ:
		return "==";
	case Token.OP_NE:
		return "!=";
	case Token.OP_AND:
		return "&&";
	case Token.OP_OR:
		return "||";
	case Token.OP_PTR:
		return "->";
	case Token.OP_COALESCING:	
		return "??";
	case Token.OP_MULT_ASSIGN:
		return "*=";
	case Token.OP_DIV_ASSIGN:
		return "/=";
	case Token.OP_MOD_ASSIGN:
		return "%=";
	case Token.OP_ADD_ASSIGN:
		return "+=";
	case Token.OP_SUB_ASSIGN:
		return "-=";
	case Token.OP_SHIFT_LEFT_ASSIGN:
		return "<<=";
	case Token.OP_SHIFT_RIGHT_ASSIGN:
		return ">>=";
	case Token.OP_AND_ASSIGN:
		return "&=";
	case Token.OP_XOR_ASSIGN:
		return "^=";
	case Token.OP_OR_ASSIGN:
		return "|=";
	}

	return GetTokenName (token);
}

static string GetTokenName (int token)
{
	switch (token){
	case Token.ABSTRACT:
		return "abstract";
	case Token.AS:
		return "as";
	case Token.ADD:
		return "add";
	case Token.ASYNC:
		return "async";
	case Token.BASE:
		return "base";
	case Token.BREAK:
		return "break";
	case Token.CASE:
		return "case";
	case Token.CATCH:
		return "catch";
	case Token.CHECKED:
		return "checked";
	case Token.CLASS:
		return "class";
	case Token.CONST:
		return "const";
	case Token.CONTINUE:
		return "continue";
	case Token.DEFAULT:
		return "default";
	case Token.DELEGATE:
		return "delegate";
	case Token.DO:
		return "do";
	case Token.ELSE:
		return "else";
	case Token.ENUM:
		return "enum";
	case Token.EVENT:
		return "event";
	case Token.EXPLICIT:
		return "explicit";
	case Token.EXTERN:
	case Token.EXTERN_ALIAS:
		return "extern";
	case Token.FALSE:
		return "false";
	case Token.FINALLY:
		return "finally";
	case Token.FIXED:
		return "fixed";
	case Token.FOR:
		return "for";
	case Token.FOREACH:
		return "foreach";
	case Token.GOTO:
		return "goto";
	case Token.IF:
		return "if";
	case Token.IMPLICIT:
		return "implicit";
	case Token.IN:
		return "in";
	case Token.INTERFACE:
		return "interface";
	case Token.INTERNAL:
		return "internal";
	case Token.IS:
		return "is";
	case Token.LOCK:
		return "lock";
	case Token.NAMESPACE:
		return "namespace";
	case Token.NEW:
		return "new";
	case Token.NULL:
		return "null";
	case Token.OPERATOR:
		return "operator";
	case Token.OUT:
		return "out";
	case Token.OVERRIDE:
		return "override";
	case Token.PARAMS:
		return "params";
	case Token.PRIVATE:
		return "private";
	case Token.PROTECTED:
		return "protected";
	case Token.PUBLIC:
		return "public";
	case Token.READONLY:
		return "readonly";
	case Token.REF:
		return "ref";
	case Token.RETURN:
		return "return";
	case Token.REMOVE:
		return "remove";
	case Token.SEALED:
		return "sealed";
	case Token.SIZEOF:
		return "sizeof";
	case Token.STACKALLOC:
		return "stackalloc";
	case Token.STATIC:
		return "static";
	case Token.STRUCT:
		return "struct";
	case Token.SWITCH:
		return "switch";
	case Token.THIS:
		return "this";
	case Token.THROW:
		return "throw";
	case Token.TRUE:
		return "true";
	case Token.TRY:
		return "try";
	case Token.TYPEOF:
		return "typeof";
	case Token.UNCHECKED:
		return "unchecked";
	case Token.UNSAFE:
		return "unsafe";
	case Token.USING:
		return "using";
	case Token.VIRTUAL:
		return "virtual";
	case Token.VOLATILE:
		return "volatile";
	case Token.WHERE:
		return "where";
	case Token.WHILE:
		return "while";
	case Token.ARGLIST:
		return "__arglist";
	case Token.REFVALUE:
		return "__refvalue";
	case Token.REFTYPE:
		return "__reftype";
	case Token.MAKEREF:
		return "__makeref";
	case Token.PARTIAL:
		return "partial";
	case Token.ARROW:
		return "=>";
	case Token.FROM:
	case Token.FROM_FIRST:
		return "from";
	case Token.JOIN:
		return "join";
	case Token.ON:
		return "on";
	case Token.EQUALS:
		return "equals";
	case Token.SELECT:
		return "select";
	case Token.GROUP:
		return "group";
	case Token.BY:
		return "by";
	case Token.LET:
		return "let";
	case Token.ORDERBY:
		return "orderby";
	case Token.ASCENDING:
		return "ascending";
	case Token.DESCENDING:
		return "descending";
	case Token.INTO:
		return "into";
	case Token.GET:
		return "get";
	case Token.SET:
		return "set";
	case Token.OPEN_BRACE:
		return "{";
	case Token.CLOSE_BRACE:
		return "}";
	case Token.OPEN_BRACKET:
	case Token.OPEN_BRACKET_EXPR:
		return "[";
	case Token.CLOSE_BRACKET:
		return "]";
	case Token.OPEN_PARENS_CAST:
	case Token.OPEN_PARENS_LAMBDA:
	case Token.OPEN_PARENS:
		return "(";
	case Token.CLOSE_PARENS:
		return ")";
	case Token.DOT:
		return ".";
	case Token.COMMA:
		return ",";
	case Token.DEFAULT_COLON:
		return "default:";
	case Token.COLON:
		return ":";
	case Token.SEMICOLON:
		return ";";
	case Token.TILDE:
		return "~";
		
	case Token.PLUS:
	case Token.UMINUS:
	case Token.MINUS:
	case Token.BANG:
	case Token.OP_LT:
	case Token.OP_GT:
	case Token.BITWISE_AND:
	case Token.BITWISE_OR:
	case Token.STAR:
	case Token.PERCENT:
	case Token.DIV:
	case Token.CARRET:
	case Token.OP_INC:
	case Token.OP_DEC:
	case Token.OP_SHIFT_LEFT:
	case Token.OP_SHIFT_RIGHT:
	case Token.OP_LE:
	case Token.OP_GE:
	case Token.OP_EQ:
	case Token.OP_NE:
	case Token.OP_AND:
	case Token.OP_OR:
	case Token.OP_PTR:
	case Token.OP_COALESCING:	
	case Token.OP_MULT_ASSIGN:
	case Token.OP_DIV_ASSIGN:
	case Token.OP_MOD_ASSIGN:
	case Token.OP_ADD_ASSIGN:
	case Token.OP_SUB_ASSIGN:
	case Token.OP_SHIFT_LEFT_ASSIGN:
	case Token.OP_SHIFT_RIGHT_ASSIGN:
	case Token.OP_AND_ASSIGN:
	case Token.OP_XOR_ASSIGN:
	case Token.OP_OR_ASSIGN:
		return "<operator>";

	case Token.BOOL:
	case Token.BYTE:
	case Token.CHAR:
	case Token.VOID:
	case Token.DECIMAL:
	case Token.DOUBLE:
	case Token.FLOAT:
	case Token.INT:
	case Token.LONG:
	case Token.SBYTE:
	case Token.SHORT:
	case Token.STRING:
	case Token.UINT:
	case Token.ULONG:
	case Token.USHORT:
	case Token.OBJECT:
		return "type";
	
	case Token.ASSIGN:
		return "=";
	case Token.OP_GENERICS_LT:
	case Token.GENERIC_DIMENSION:
		return "<";
	case Token.OP_GENERICS_GT:
		return ">";
	case Token.INTERR:
	case Token.INTERR_NULLABLE:
		return "?";
	case Token.DOUBLE_COLON:
		return "::";
	case Token.LITERAL:
		return "value";
	case Token.IDENTIFIER:
	case Token.AWAIT:
		return "identifier";

	case Token.EOF:
		return "end-of-file";

		// All of these are internal.
	case Token.NONE:
	case Token.ERROR:
	case Token.FIRST_KEYWORD:
	case Token.EVAL_COMPILATION_UNIT_PARSER:
	case Token.EVAL_USING_DECLARATIONS_UNIT_PARSER:
	case Token.EVAL_STATEMENT_PARSER:
	case Token.LAST_KEYWORD:
	case Token.GENERATE_COMPLETION:
	case Token.COMPLETE_COMPLETION:
		return "<internal>";

		// A bit more robust.
	default:
		return yyNames [token];
        }
}

/* end end end */
}
#line default
namespace yydebug {
        using System;
	 internal interface yyDebug {
		 void push (int state, Object value);
		 void lex (int state, int token, string name, Object value);
		 void shift (int from, int to, int errorFlag);
		 void pop (int state);
		 void discard (int state, int token, string name, Object value);
		 void reduce (int from, int to, int rule, string text, int len);
		 void shift (int from, int to);
		 void accept (Object value);
		 void error (string message);
		 void reject ();
	 }
	 
	 class yyDebugSimple : yyDebug {
		 void println (string s){
			 Console.Error.WriteLine (s);
		 }
		 
		 public void push (int state, Object value) {
			 println ("push\tstate "+state+"\tvalue "+value);
		 }
		 
		 public void lex (int state, int token, string name, Object value) {
			 println("lex\tstate "+state+"\treading "+name+"\tvalue "+value);
		 }
		 
		 public void shift (int from, int to, int errorFlag) {
			 switch (errorFlag) {
			 default:				// normally
				 println("shift\tfrom state "+from+" to "+to);
				 break;
			 case 0: case 1: case 2:		// in error recovery
				 println("shift\tfrom state "+from+" to "+to
					     +"\t"+errorFlag+" left to recover");
				 break;
			 case 3:				// normally
				 println("shift\tfrom state "+from+" to "+to+"\ton error");
				 break;
			 }
		 }
		 
		 public void pop (int state) {
			 println("pop\tstate "+state+"\ton error");
		 }
		 
		 public void discard (int state, int token, string name, Object value) {
			 println("discard\tstate "+state+"\ttoken "+name+"\tvalue "+value);
		 }
		 
		 public void reduce (int from, int to, int rule, string text, int len) {
			 println("reduce\tstate "+from+"\tuncover "+to
				     +"\trule ("+rule+") "+text);
		 }
		 
		 public void shift (int from, int to) {
			 println("goto\tfrom state "+from+" to "+to);
		 }
		 
		 public void accept (Object value) {
			 println("accept\tvalue "+value);
		 }
		 
		 public void error (string message) {
			 println("error\t"+message);
		 }
		 
		 public void reject () {
			 println("reject");
		 }
		 
	 }
}
// %token constants
 class Token {
  public const int EOF = 257;
  public const int NONE = 258;
  public const int ERROR = 259;
  public const int FIRST_KEYWORD = 260;
  public const int ABSTRACT = 261;
  public const int AS = 262;
  public const int ADD = 263;
  public const int BASE = 264;
  public const int BOOL = 265;
  public const int BREAK = 266;
  public const int BYTE = 267;
  public const int CASE = 268;
  public const int CATCH = 269;
  public const int CHAR = 270;
  public const int CHECKED = 271;
  public const int CLASS = 272;
  public const int CONST = 273;
  public const int CONTINUE = 274;
  public const int DECIMAL = 275;
  public const int DEFAULT = 276;
  public const int DELEGATE = 277;
  public const int DO = 278;
  public const int DOUBLE = 279;
  public const int ELSE = 280;
  public const int ENUM = 281;
  public const int EVENT = 282;
  public const int EXPLICIT = 283;
  public const int EXTERN = 284;
  public const int FALSE = 285;
  public const int FINALLY = 286;
  public const int FIXED = 287;
  public const int FLOAT = 288;
  public const int FOR = 289;
  public const int FOREACH = 290;
  public const int GOTO = 291;
  public const int IF = 292;
  public const int IMPLICIT = 293;
  public const int IN = 294;
  public const int INT = 295;
  public const int INTERFACE = 296;
  public const int INTERNAL = 297;
  public const int IS = 298;
  public const int LOCK = 299;
  public const int LONG = 300;
  public const int NAMESPACE = 301;
  public const int NEW = 302;
  public const int NULL = 303;
  public const int OBJECT = 304;
  public const int OPERATOR = 305;
  public const int OUT = 306;
  public const int OVERRIDE = 307;
  public const int PARAMS = 308;
  public const int PRIVATE = 309;
  public const int PROTECTED = 310;
  public const int PUBLIC = 311;
  public const int READONLY = 312;
  public const int REF = 313;
  public const int RETURN = 314;
  public const int REMOVE = 315;
  public const int SBYTE = 316;
  public const int SEALED = 317;
  public const int SHORT = 318;
  public const int SIZEOF = 319;
  public const int STACKALLOC = 320;
  public const int STATIC = 321;
  public const int STRING = 322;
  public const int STRUCT = 323;
  public const int SWITCH = 324;
  public const int THIS = 325;
  public const int THROW = 326;
  public const int TRUE = 327;
  public const int TRY = 328;
  public const int TYPEOF = 329;
  public const int UINT = 330;
  public const int ULONG = 331;
  public const int UNCHECKED = 332;
  public const int UNSAFE = 333;
  public const int USHORT = 334;
  public const int USING = 335;
  public const int VIRTUAL = 336;
  public const int VOID = 337;
  public const int VOLATILE = 338;
  public const int WHERE = 339;
  public const int WHILE = 340;
  public const int ARGLIST = 341;
  public const int PARTIAL = 342;
  public const int ARROW = 343;
  public const int FROM = 344;
  public const int FROM_FIRST = 345;
  public const int JOIN = 346;
  public const int ON = 347;
  public const int EQUALS = 348;
  public const int SELECT = 349;
  public const int GROUP = 350;
  public const int BY = 351;
  public const int LET = 352;
  public const int ORDERBY = 353;
  public const int ASCENDING = 354;
  public const int DESCENDING = 355;
  public const int INTO = 356;
  public const int INTERR_NULLABLE = 357;
  public const int EXTERN_ALIAS = 358;
  public const int REFVALUE = 359;
  public const int REFTYPE = 360;
  public const int MAKEREF = 361;
  public const int ASYNC = 362;
  public const int AWAIT = 363;
  public const int GET = 364;
  public const int SET = 365;
  public const int LAST_KEYWORD = 366;
  public const int OPEN_BRACE = 367;
  public const int CLOSE_BRACE = 368;
  public const int OPEN_BRACKET = 369;
  public const int CLOSE_BRACKET = 370;
  public const int OPEN_PARENS = 371;
  public const int CLOSE_PARENS = 372;
  public const int DOT = 373;
  public const int COMMA = 374;
  public const int COLON = 375;
  public const int SEMICOLON = 376;
  public const int TILDE = 377;
  public const int PLUS = 378;
  public const int MINUS = 379;
  public const int BANG = 380;
  public const int ASSIGN = 381;
  public const int OP_LT = 382;
  public const int OP_GT = 383;
  public const int BITWISE_AND = 384;
  public const int BITWISE_OR = 385;
  public const int STAR = 386;
  public const int PERCENT = 387;
  public const int DIV = 388;
  public const int CARRET = 389;
  public const int INTERR = 390;
  public const int DOUBLE_COLON = 391;
  public const int OP_INC = 392;
  public const int OP_DEC = 393;
  public const int OP_SHIFT_LEFT = 394;
  public const int OP_SHIFT_RIGHT = 395;
  public const int OP_LE = 396;
  public const int OP_GE = 397;
  public const int OP_EQ = 398;
  public const int OP_NE = 399;
  public const int OP_AND = 400;
  public const int OP_OR = 401;
  public const int OP_MULT_ASSIGN = 402;
  public const int OP_DIV_ASSIGN = 403;
  public const int OP_MOD_ASSIGN = 404;
  public const int OP_ADD_ASSIGN = 405;
  public const int OP_SUB_ASSIGN = 406;
  public const int OP_SHIFT_LEFT_ASSIGN = 407;
  public const int OP_SHIFT_RIGHT_ASSIGN = 408;
  public const int OP_AND_ASSIGN = 409;
  public const int OP_XOR_ASSIGN = 410;
  public const int OP_OR_ASSIGN = 411;
  public const int OP_PTR = 412;
  public const int OP_COALESCING = 413;
  public const int OP_GENERICS_LT = 414;
  public const int OP_GENERICS_LT_DECL = 415;
  public const int OP_GENERICS_GT = 416;
  public const int LITERAL = 417;
  public const int IDENTIFIER = 418;
  public const int OPEN_PARENS_LAMBDA = 419;
  public const int OPEN_PARENS_CAST = 420;
  public const int GENERIC_DIMENSION = 421;
  public const int DEFAULT_COLON = 422;
  public const int OPEN_BRACKET_EXPR = 423;
  public const int EVAL_STATEMENT_PARSER = 424;
  public const int EVAL_COMPILATION_UNIT_PARSER = 425;
  public const int EVAL_USING_DECLARATIONS_UNIT_PARSER = 426;
  public const int DOC_SEE = 427;
  public const int GENERATE_COMPLETION = 428;
  public const int COMPLETE_COMPLETION = 429;
  public const int UMINUS = 430;
  public const int yyErrorCode = 256;
 }
 namespace yyParser {
  using System;
  /** thrown for irrecoverable syntax errors and stack overflow.
    */
  internal class yyException : System.Exception {
    public yyException (string message) : base (message) {
    }
  }
  internal class yyUnexpectedEof : yyException {
    public yyUnexpectedEof (string message) : base (message) {
    }
    public yyUnexpectedEof () : base ("") {
    }
  }

  /** must be implemented by a scanner object to supply input to the parser.
    */
  internal interface yyInput {
    /** move on to next token.
        @return false if positioned beyond tokens.
        @throws IOException on input error.
      */
    bool advance (); // throws java.io.IOException;
    /** classifies current token.
        Should not be called if advance() returned false.
        @return current %token or single character.
      */
    int token ();
    /** associated with current token.
        Should not be called if advance() returned false.
        @return value for token().
      */
    Object value ();
  }
 }
} // close outermost namespace, that MUST HAVE BEEN opened in the prolog
