/*
 * Decompiled with CFR 0.152.
 */
package org.homebrew;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;
import javax.tv.locator.Locator;
import javax.tv.service.SIManager;
import javax.tv.service.Service;
import javax.tv.service.selection.ServiceContextFactory;
import javax.tv.xlet.Xlet;
import javax.tv.xlet.XletContext;
import javax.tv.xlet.XletStateChangeException;
import org.bluray.net.BDLocator;
import org.bluray.system.RegisterAccess;
import org.bluray.ti.Title;
import org.bluray.ti.selection.TitleContext;
import org.dvb.event.EventManager;
import org.dvb.event.UserEvent;
import org.dvb.event.UserEventListener;
import org.dvb.event.UserEventRepository;
import org.homebrew.Debug;
import org.homebrew.ImageLoader;
import org.homebrew.MediaListener;
import org.homebrew.PlaylistPlayer;
import org.homebrew.Scene;
import org.homebrew.Screen;
import org.homebrew.XmlElement;
import org.homebrew.XmlParser;

public class MenuTo
implements Xlet,
UserEventListener,
MediaListener {
    public static final int SCREEN_WIDTH = 1920;
    public static final int SCREEN_HEIGHT = 1080;
    public static PlaylistPlayer player;
    public static int playlistCount;
    public static boolean loopPlay;
    public static boolean noMenu;
    private static int[] playlistIds;
    private static XletContext xletContent;
    private static ArrayList scenes;
    public static Scene currentScene;
    private static final int GPR_OP = 100;
    private static final int FIRST_PLAY_MAGIC = 64176;
    private static final int TOP_MENU_MAGIC = 64177;
    private static final int FIRST_PLAY = 0;
    private static final int TOP_MENU = 1;
    private static final int TITLE_PLAY = 2;
    private int op = 0;
    static /* synthetic */ Class class$org$homebrew$MenuTo;
    static /* synthetic */ Class class$org$homebrew$Scene;

    public MenuTo() {
        Debug.setLevel(0);
        Debug.info(class$org$homebrew$MenuTo == null ? (class$org$homebrew$MenuTo = MenuTo.class$("org.homebrew.MenuTo")) : class$org$homebrew$MenuTo, "MenuTo()");
    }

    public void initXlet(XletContext xletContext) throws XletStateChangeException {
        Debug.info(class$org$homebrew$MenuTo == null ? (class$org$homebrew$MenuTo = MenuTo.class$("org.homebrew.MenuTo")) : class$org$homebrew$MenuTo, "initXlet()");
        xletContent = xletContext;
        int n = RegisterAccess.getInstance().getGPR(100);
        RegisterAccess.getInstance().setGPR(100, 0);
        Debug.info(class$org$homebrew$MenuTo == null ? (class$org$homebrew$MenuTo = MenuTo.class$("org.homebrew.MenuTo")) : class$org$homebrew$MenuTo, "GPR(100): " + n);
        this.op = n == 64176 ? 0 : (n == 64177 ? 1 : 2);
        Debug.info(class$org$homebrew$MenuTo == null ? (class$org$homebrew$MenuTo = MenuTo.class$("org.homebrew.MenuTo")) : class$org$homebrew$MenuTo, "Op: " + this.op);
        UserEventRepository userEventRepository = new UserEventRepository("Blu-ray events");
        userEventRepository.addKey(10);
        userEventRepository.addAllArrowKeys();
        userEventRepository.addAllColourKeys();
        userEventRepository.addAllNumericKeys();
        EventManager.getInstance().addUserEventListener((UserEventListener)this, userEventRepository);
        try {
            Screen.initialise(1920, 1080);
            player = new PlaylistPlayer();
            player.initialise();
            player.setMediaListener(this);
            scenes = new ArrayList();
            String string = System.getProperty("bluray.vfs.root");
            if (!string.endsWith("/") && !string.endsWith("\\")) {
                string = string + "/";
            }
            String string2 = string + "BDMV/JAR/00000/AuthorData.xml";
            Debug.info(class$org$homebrew$MenuTo == null ? (class$org$homebrew$MenuTo = MenuTo.class$("org.homebrew.MenuTo")) : class$org$homebrew$MenuTo, string2);
            this.dataDriven(string2);
            if (playlistCount > 0) {
                int n2 = RegisterAccess.getInstance().getPSR(4);
                Debug.info(class$org$homebrew$MenuTo == null ? (class$org$homebrew$MenuTo = MenuTo.class$("org.homebrew.MenuTo")) : class$org$homebrew$MenuTo, "Title no: " + n2);
                if (noMenu) {
                    playlistIds = new int[playlistCount];
                    for (int i = 0; i < playlistCount; ++i) {
                        MenuTo.playlistIds[i] = i;
                    }
                } else if (this.op == 0) {
                    playlistIds = new int[playlistCount];
                    for (int i = 0; i < playlistCount; ++i) {
                        MenuTo.playlistIds[i] = i;
                    }
                } else if (this.op == 2) {
                    playlistIds = new int[1];
                    MenuTo.playlistIds[0] = n2 - 1;
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new XletStateChangeException();
        }
    }

    public void startXlet() throws XletStateChangeException {
        Debug.info(class$org$homebrew$MenuTo == null ? (class$org$homebrew$MenuTo = MenuTo.class$("org.homebrew.MenuTo")) : class$org$homebrew$MenuTo, "startXlet()");
        try {
            if (noMenu) {
                player.playPlaylists(playlistIds, false);
            } else if (this.op == 1) {
                Screen.show();
                MenuTo.homeScene();
            } else if (this.op == 0) {
                player.playPlaylists(playlistIds, loopPlay);
            } else if (this.op == 2) {
                player.playPlaylists(playlistIds, false);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new XletStateChangeException();
        }
    }

    public void pauseXlet() {
        Debug.info(class$org$homebrew$MenuTo == null ? (class$org$homebrew$MenuTo = MenuTo.class$("org.homebrew.MenuTo")) : class$org$homebrew$MenuTo, "pauseXlet()");
        try {
            if (this.op == 1) {
                Screen.hide();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void destroyXlet(boolean bl) throws XletStateChangeException {
        Debug.info(class$org$homebrew$MenuTo == null ? (class$org$homebrew$MenuTo = MenuTo.class$("org.homebrew.MenuTo")) : class$org$homebrew$MenuTo, "destroyXlet()");
        try {
            Screen.terminate();
            ImageLoader.removeTracker();
            System.gc();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void userEventReceived(UserEvent userEvent) {
        Debug.info(class$org$homebrew$MenuTo == null ? (class$org$homebrew$MenuTo = MenuTo.class$("org.homebrew.MenuTo")) : class$org$homebrew$MenuTo, "userEventReceived()");
        if (this.op != 1) {
            return;
        }
        if (player.playing()) {
            Debug.info(class$org$homebrew$MenuTo == null ? (class$org$homebrew$MenuTo = MenuTo.class$("org.homebrew.MenuTo")) : class$org$homebrew$MenuTo, "player.playing()");
            return;
        }
        if (userEvent.getType() == 401 && userEvent.getCode() != 403 && userEvent.getCode() != 404 && userEvent.getCode() != 405 && userEvent.getCode() != 406 && userEvent.getCode() != 48) {
            if (userEvent.getCode() == 38) {
                if (null != currentScene) {
                    currentScene.upKeyEvent();
                }
            } else if (userEvent.getCode() == 40) {
                if (null != currentScene) {
                    currentScene.downKeyEvent();
                }
            } else if (userEvent.getCode() == 37) {
                if (null != currentScene) {
                    currentScene.leftKeyEvent();
                }
            } else if (userEvent.getCode() == 39) {
                if (null != currentScene) {
                    currentScene.rightKeyEvent();
                }
            } else if (userEvent.getCode() == 10 && null != currentScene) {
                currentScene.enterKeyEvent();
            }
        }
    }

    public static void leftScene() {
        if (null == currentScene) {
            return;
        }
        for (int i = 0; i < scenes.size(); ++i) {
            Scene scene = (Scene)scenes.get(i);
            if (scene.id() != currentScene.id() - 1) continue;
            currentScene.setCurrent(false);
            currentScene = scene;
            currentScene.setCurrent(true);
            break;
        }
    }

    public static void homeScene() {
        for (int i = 0; i < scenes.size(); ++i) {
            Scene scene = (Scene)scenes.get(i);
            if (scene.id() != 1) continue;
            if (null != currentScene) {
                currentScene.setCurrent(false);
            }
            currentScene = scene;
            currentScene.setCurrent(true);
            break;
        }
    }

    public static void rightScene() {
        if (null == currentScene) {
            return;
        }
        for (int i = 0; i < scenes.size(); ++i) {
            Scene scene = (Scene)scenes.get(i);
            if (scene.id() != currentScene.id() + 1) continue;
            currentScene.setCurrent(false);
            currentScene = scene;
            currentScene.setCurrent(true);
            break;
        }
    }

    public static void playTitles(boolean bl) {
        int[] nArray = new int[playlistCount];
        for (int i = 0; i < playlistCount; ++i) {
            nArray[i] = i;
        }
        player.playPlaylists(nArray, bl);
    }

    public void jumpToTopMenu() {
        Debug.info(class$org$homebrew$MenuTo == null ? (class$org$homebrew$MenuTo = MenuTo.class$("org.homebrew.MenuTo")) : class$org$homebrew$MenuTo, "jumpToTopMenu()");
        try {
            ServiceContextFactory serviceContextFactory = ServiceContextFactory.getInstance();
            TitleContext titleContext = (TitleContext)serviceContextFactory.getServiceContext(xletContent);
            SIManager sIManager = SIManager.createInstance();
            Title title = (Title)sIManager.getService((Locator)new BDLocator("bd://0"));
            titleContext.select((Service)title);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void dataDriven(String string) {
        try {
            File file = new File(string);
            FileReader fileReader = new FileReader(file);
            BufferedReader bufferedReader = new BufferedReader(fileReader);
            XmlParser xmlParser = new XmlParser();
            XmlElement xmlElement = xmlParser.parse(bufferedReader);
            playlistCount = Integer.parseInt(xmlElement.getAttribute("playlist_count"));
            loopPlay = Integer.parseInt(xmlElement.getAttribute("loop_play")) != 0;
            noMenu = Integer.parseInt(xmlElement.getAttribute("no_menu")) != 0;
            Object[] objectArray = xmlElement.getChildElements();
            for (int i = 0; i < objectArray.length; ++i) {
                XmlElement xmlElement2 = (XmlElement)objectArray[i];
                Scene scene = new Scene(xmlElement2);
                scenes.add(scene);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void onMark(int n) {
    }

    public void onRateChanged(float f) {
    }

    public void onPlayItemChanged(int n) {
    }

    public void onMediaTimeEvent(long l, int n) {
    }

    public void onMediaStart() {
    }

    public void onMediaEnd() {
        Debug.info(class$org$homebrew$MenuTo == null ? (class$org$homebrew$MenuTo = MenuTo.class$("org.homebrew.MenuTo")) : class$org$homebrew$MenuTo, "onMediaEnd()");
        if (!noMenu) {
            if (this.op == 1) {
                Screen.show();
                if (null == currentScene) {
                    MenuTo.homeScene();
                }
                if (null != currentScene) {
                    currentScene.paintWholeScene();
                }
            } else {
                Debug.info(class$org$homebrew$Scene == null ? (class$org$homebrew$Scene = MenuTo.class$("org.homebrew.Scene")) : class$org$homebrew$Scene, "onMediaEnd() NOT TopMenu");
                this.jumpToTopMenu();
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        playlistCount = 0;
        loopPlay = false;
        noMenu = false;
        playlistIds = PlaylistPlayer.NO_PLAYLISTS;
        xletContent = null;
        currentScene = null;
    }
}

