/*
 * Decompiled with CFR 0.152.
 */
package hu.uw.pallergabor.dedexer;

import hu.uw.pallergabor.dedexer.DexParser;
import hu.uw.pallergabor.dedexer.DexStringIdsBlock;
import hu.uw.pallergabor.dedexer.DexTypeIdsBlock;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;

public class DexDebugInfoParser
extends DexParser {
    private static final int DBG_END_SEQUENCE = 0;
    private static final int DBG_ADVANCE_PC = 1;
    private static final int DBG_ADVANCE_LINE = 2;
    private static final int DBG_START_LOCAL = 3;
    private static final int DBG_START_LOCAL_EXTENDED = 4;
    private static final int DBG_END_LOCAL = 5;
    private static final int DBG_RESTART_LOCAL = 6;
    private static final int DBG_SET_PROLOGUE_END = 7;
    private static final int DBG_SET_EPILOGUE_BEGIN = 8;
    private static final int DBG_SET_FILE = 9;
    private static final int DBG_FIRST_SPECIAL = 10;
    private static final int DBG_LINE_BASE = -4;
    private static final int DBG_LINE_RANGE = 15;
    private DexStringIdsBlock dexStringIdsBlock;
    private DexTypeIdsBlock dexTypeIdsBlock;
    private ArrayList<LocalVariableHolder> variableList;
    private ArrayList<LineNumberHolder> lineNumberList;

    @Override
    public void parse() throws IOException {
        this.variableList = new ArrayList();
        this.lineNumberList = new ArrayList();
        int lineRegister = 0;
        int addressRegister = 0;
        HashMap<String, LocalVariableHolder> registers = new HashMap<String, LocalVariableHolder>();
        lineRegister = (int)this.readVLN();
        this.dump("Starting line: " + lineRegister);
        int parmSize = (int)this.readVLN();
        this.dump("Parameter number: " + parmSize);
        for (int i = 0; i < parmSize; ++i) {
            int parameter = (int)this.readVLN() - 1;
            LocalVariableHolder lvh = new LocalVariableHolder();
            lvh.variableName = parameter < 0 ? "unnamed" + Integer.toString(i) : this.dexStringIdsBlock.getString(parameter);
            this.dump("reg#" + lvh.regNum + " : " + lvh.variableName);
            this.variableList.add(lvh);
        }
        block13: while (true) {
            int b = this.read8Bit();
            switch (b) {
                case 0: {
                    this.dump("DBG_END_SEQUENCE");
                    break block13;
                }
                case 1: {
                    int offset = (int)this.readVLN();
                    this.dump("DBG_ADVANCE_PC: by " + offset + " bytes (new address is 0x" + Integer.toHexString(addressRegister += offset) + ")");
                    break;
                }
                case 2: {
                    int offset = (int)this.readSignedVLN();
                    this.dump("DBG_ADVANCE_LINE: by " + offset + " lines (new line counter: " + (lineRegister += offset) + ")");
                    break;
                }
                case 3: {
                    int regNum = (int)this.readVLN();
                    int nameIdx = (int)this.readVLN() - 1;
                    int typeIdx = (int)this.readVLN() - 1;
                    if (nameIdx >= 0 && typeIdx >= 0) {
                        LocalVariableHolder lvh = new LocalVariableHolder();
                        lvh.regNum = regNum;
                        lvh.variableName = this.dexStringIdsBlock.getString(nameIdx);
                        lvh.typeName = this.dexTypeIdsBlock.getType(typeIdx);
                        lvh.startOffset = addressRegister;
                        registers.put(Integer.toString(regNum), lvh);
                        this.dump("DBG_START_LOCAL: v" + regNum + "; name: " + lvh.variableName + "; type: " + lvh.typeName + "; address: 0x" + Integer.toHexString(addressRegister));
                        break;
                    }
                    this.dump("DBG_START_LOCAL: no name local variable allocated to v" + regNum);
                    break;
                }
                case 4: {
                    int regNum = (int)this.readVLN();
                    int nameIdx = (int)this.readVLN() - 1;
                    int typeIdx = (int)this.readVLN() - 1;
                    int sigIdx = (int)this.readVLN() - 1;
                    if (nameIdx >= 0 && typeIdx >= 0) {
                        LocalVariableHolder lvh = new LocalVariableHolder();
                        lvh.regNum = regNum;
                        lvh.variableName = this.dexStringIdsBlock.getString(nameIdx);
                        lvh.typeName = this.dexTypeIdsBlock.getType(typeIdx);
                        lvh.startOffset = addressRegister;
                        registers.put(Integer.toString(regNum), lvh);
                        this.dump("DBG_START_LOCAL_EXTENDED: v" + regNum + "; name: " + lvh.variableName + "; type: " + lvh.typeName + "; address: 0x" + Integer.toHexString(addressRegister) + "; signature index: " + sigIdx);
                        break;
                    }
                    this.dump("DBG_START_LOCAL_EXTENDED: no name local variable allocated to v" + regNum);
                    break;
                }
                case 5: {
                    int regNum = (int)this.readVLN();
                    LocalVariableHolder lvh = (LocalVariableHolder)registers.get(Integer.toString(regNum));
                    if (lvh == null) {
                        this.dump("DBG_END_LOCAL: v" + regNum + " has no associated DBB_START_LOCAL");
                        break;
                    }
                    lvh.endOffset = addressRegister;
                    this.variableList.add(lvh);
                    this.dump("DBG_END_LOCAL: v" + regNum + " (0x" + Integer.toHexString(lvh.startOffset) + " - 0x" + Integer.toHexString(lvh.endOffset) + ")");
                    break;
                }
                case 6: {
                    int regNum = (int)this.readVLN();
                    String regString = Integer.toString(regNum);
                    LocalVariableHolder lvh = (LocalVariableHolder)registers.get(regString);
                    if (lvh == null) {
                        this.dump("DBG_RESTART_LOCAL: v" + regNum + " has no associated DBB_START_LOCAL");
                        break;
                    }
                    LocalVariableHolder lvh2 = lvh.clone();
                    registers.put(regString, lvh2);
                    lvh2.startOffset = addressRegister;
                    this.dump("DBG_RESTART_LOCAL: v" + regNum + "; name: " + lvh2.variableName + "; type: " + lvh2.typeName + " restarted at 0x" + Integer.toHexString(lvh2.startOffset));
                    break;
                }
                case 7: {
                    this.dump("DBG_SET_PROLOGUE_END");
                    break;
                }
                case 8: {
                    this.dump("DBG_SET_EPILOGUE_BEGIN");
                    break;
                }
                case 9: {
                    int sourceFileIdx = (int)this.readVLN() - 1;
                    if (sourceFileIdx < 0) {
                        this.dump("DBG_SET_FILE: unspecified file name");
                        break;
                    }
                    String s = this.dexStringIdsBlock.getString(sourceFileIdx);
                    this.dump("DBG_SET_FILE: source file name set: " + s + " at 0x" + Integer.toHexString(addressRegister));
                    break;
                }
                default: {
                    int adjustedOpcode = b - 10;
                    LineNumberHolder lnh = new LineNumberHolder();
                    lnh.lineNumber = lineRegister += -4 + adjustedOpcode % 15;
                    lnh.address = addressRegister += adjustedOpcode / 15;
                    this.lineNumberList.add(lnh);
                    this.dump("Line register: " + lineRegister + "; address register: 0x" + Integer.toHexString(addressRegister));
                }
            }
        }
    }

    public void setDexStringIdsBlock(DexStringIdsBlock dexStringIdsBlock) {
        this.dexStringIdsBlock = dexStringIdsBlock;
    }

    public void setDexTypeIdsBlock(DexTypeIdsBlock dexTypeIdsBlock) {
        this.dexTypeIdsBlock = dexTypeIdsBlock;
    }

    public int getLineNumbers() {
        return this.lineNumberList.size();
    }

    public int getLineNumber(int idx) {
        return this.lineNumberList.get((int)idx).lineNumber;
    }

    public int getLineNumberAddress(int idx) {
        return this.lineNumberList.get((int)idx).address;
    }

    public int getLocalVariables() {
        return this.variableList.size();
    }

    public int getLocalVariableRegNum(int idx) {
        return this.variableList.get((int)idx).regNum;
    }

    public String getLocalVariableName(int idx) {
        return this.variableList.get((int)idx).variableName;
    }

    public String getLocalVariableType(int idx) {
        return this.variableList.get((int)idx).typeName;
    }

    public int getLocalVariableStartOffset(int idx) {
        return this.variableList.get((int)idx).startOffset;
    }

    public int getLocalVariableEndOffset(int idx) {
        return this.variableList.get((int)idx).endOffset;
    }

    class LocalVariableHolder {
        int regNum = -1;
        String variableName = null;
        String typeName = null;
        int startOffset = -1;
        int endOffset = -1;

        LocalVariableHolder() {
        }

        public LocalVariableHolder clone() {
            LocalVariableHolder result = new LocalVariableHolder();
            result.regNum = this.regNum;
            result.variableName = this.variableName;
            result.typeName = this.typeName;
            result.startOffset = this.startOffset;
            result.endOffset = this.endOffset;
            return result;
        }
    }

    class LineNumberHolder {
        int lineNumber;
        int address;

        LineNumberHolder() {
        }
    }
}

