/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.dex2jar.tools;

import java.io.FileInputStream;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.objectweb.asm.ClassAdapter;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.EmptyVisitor;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.InnerClassNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LocalVariableNode;
import org.objectweb.asm.tree.MemberNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TryCatchBlockNode;
import org.objectweb.asm.util.AbstractVisitor;

public class JasminifierClassAdapter
extends ClassAdapter {
    protected PrintWriter pw;
    protected final Map labelNames;

    public static void main(String[] args) throws Exception {
        int i = 0;
        int flags = 2;
        boolean ok = true;
        if (args.length < 1 || args.length > 2) {
            ok = false;
        }
        if (ok && "-debug".equals(args[0])) {
            i = 1;
            flags = 0;
            if (args.length != 2) {
                ok = false;
            }
        }
        if (!ok) {
            System.err.println("Prints a disassembled view of the given class.");
            System.err.println("Usage: JasminifierClassAdapter [-debug] <fully qualified class name or class file name>");
            return;
        }
        ClassReader cr = args[i].endsWith(".class") || args[i].indexOf(92) > -1 || args[i].indexOf(47) > -1 ? new ClassReader((InputStream)new FileInputStream(args[i])) : new ClassReader(args[i]);
        cr.accept((ClassVisitor)new JasminifierClassAdapter(new PrintWriter(System.out, true), null), flags | 8);
    }

    public JasminifierClassAdapter(PrintWriter pw, final ClassVisitor cv) {
        super((ClassVisitor)new ClassNode(){

            public void visitEnd() {
                if (cv != null) {
                    this.accept(cv);
                }
            }
        });
        this.pw = pw;
        this.labelNames = new HashMap();
    }

    public void visitEnd() {
        ClassNode cn = (ClassNode)this.cv;
        this.pw.print(".bytecode ");
        this.pw.print(cn.version & 0xFFFF);
        this.pw.print('.');
        this.pw.println(cn.version >>> 16);
        this.println(".source ", cn.sourceFile);
        this.pw.print(".class");
        this.pw.print(this.access(cn.access));
        this.pw.print(' ');
        this.pw.println(cn.name);
        if (cn.superName != null) {
            this.println(".super ", cn.superName);
        }
        int i = 0;
        while (i < cn.interfaces.size()) {
            this.println(".implements ", (String)cn.interfaces.get(i));
            ++i;
        }
        if (cn.signature != null) {
            this.println(".signature ", String.valueOf('\"') + cn.signature + '\"');
        }
        if (cn.outerClass != null) {
            this.pw.print(".enclosing method ");
            this.pw.print(cn.outerClass);
            if (cn.outerMethod != null) {
                this.pw.print('/');
                this.pw.print(cn.outerMethod);
                this.pw.println(cn.outerMethodDesc);
            } else {
                this.pw.println();
            }
        }
        if ((cn.access & 0x20000) != 0) {
            this.pw.println(".deprecated");
        }
        this.printAnnotations((MemberNode)cn);
        this.println(".debug ", cn.sourceDebug == null ? null : String.valueOf('\"') + cn.sourceDebug + '\"');
        i = 0;
        while (i < cn.innerClasses.size()) {
            InnerClassNode in = (InnerClassNode)cn.innerClasses.get(i);
            this.pw.print(".inner class");
            this.pw.print(this.access(in.access));
            if (in.innerName != null) {
                this.pw.print(' ');
                this.pw.print(in.innerName);
            }
            if (in.name != null) {
                this.pw.print(" inner ");
                this.pw.print(in.name);
            }
            if (in.outerName != null) {
                this.pw.print(" outer ");
                this.pw.print(in.outerName);
            }
            this.pw.println();
            ++i;
        }
        i = 0;
        while (i < cn.fields.size()) {
            FieldNode fn = (FieldNode)cn.fields.get(i);
            boolean annotations = false;
            if (fn.visibleAnnotations != null && fn.visibleAnnotations.size() > 0) {
                annotations = true;
            }
            if (fn.invisibleAnnotations != null && fn.invisibleAnnotations.size() > 0) {
                annotations = true;
            }
            boolean deprecated = (fn.access & 0x20000) != 0;
            this.pw.print("\n.field");
            this.pw.print(this.access(fn.access));
            this.pw.print(" '");
            this.pw.print(fn.name);
            this.pw.print("' ");
            this.pw.print(fn.desc);
            if (fn.signature != null && !deprecated && !annotations) {
                this.pw.print(" signature \"");
                this.pw.print(fn.signature);
                this.pw.print("\"");
            }
            if (fn.value instanceof String) {
                StringBuffer buf = new StringBuffer();
                AbstractVisitor.appendString((StringBuffer)buf, (String)((String)fn.value));
                this.pw.print(" = ");
                this.pw.print(buf.toString());
            } else if (fn.value != null) {
                this.pw.print(" = ");
                this.print(fn.value);
                this.pw.println();
            }
            this.pw.println();
            if (fn.signature != null && (deprecated || annotations)) {
                this.pw.print(".signature \"");
                this.pw.print(fn.signature);
                this.pw.println("\"");
            }
            if (deprecated) {
                this.pw.println(".deprecated");
            }
            this.printAnnotations((MemberNode)fn);
            if (deprecated || annotations) {
                this.pw.println(".end field");
            }
            ++i;
        }
        i = 0;
        while (i < cn.methods.size()) {
            int j;
            MethodNode mn = (MethodNode)cn.methods.get(i);
            this.pw.print("\n.method");
            this.pw.print(this.access(mn.access));
            this.pw.print(' ');
            this.pw.print(mn.name);
            this.pw.println(mn.desc);
            if (mn.signature != null) {
                this.pw.print(".signature \"");
                this.pw.print(mn.signature);
                this.pw.println("\"");
            }
            if (mn.annotationDefault != null) {
                this.pw.println(".annotation default");
                this.printAnnotationValue(mn.annotationDefault);
                this.pw.println(".end annotation");
            }
            this.printAnnotations((MemberNode)mn);
            if (mn.visibleParameterAnnotations != null) {
                j = 0;
                while (j < mn.visibleParameterAnnotations.length) {
                    List l = mn.visibleParameterAnnotations[j];
                    if (l != null) {
                        int k = 0;
                        while (k < l.size()) {
                            this.printAnnotation((AnnotationNode)l.get(k), 1, j + 1);
                            ++k;
                        }
                    }
                    ++j;
                }
            }
            if (mn.invisibleParameterAnnotations != null) {
                j = 0;
                while (j < mn.invisibleParameterAnnotations.length) {
                    List l = mn.invisibleParameterAnnotations[j];
                    if (l != null) {
                        int k = 0;
                        while (k < l.size()) {
                            this.printAnnotation((AnnotationNode)l.get(k), 2, j + 1);
                            ++k;
                        }
                    }
                    ++j;
                }
            }
            j = 0;
            while (j < mn.exceptions.size()) {
                this.println(".throws ", (String)mn.exceptions.get(j));
                ++j;
            }
            if ((mn.access & 0x20000) != 0) {
                this.pw.println(".deprecated");
            }
            if (mn.instructions != null && mn.instructions.size() > 0) {
                this.labelNames.clear();
                if (mn.tryCatchBlocks != null) {
                    j = 0;
                    while (j < mn.tryCatchBlocks.size()) {
                        TryCatchBlockNode tcb = (TryCatchBlockNode)mn.tryCatchBlocks.get(j);
                        this.pw.print(".catch ");
                        this.pw.print(tcb.type == null ? "all" : tcb.type);
                        this.pw.print(" from ");
                        this.print(tcb.start);
                        this.pw.print(" to ");
                        this.print(tcb.end);
                        this.pw.print(" using ");
                        this.print(tcb.handler);
                        this.pw.println();
                        ++j;
                    }
                }
                j = 0;
                while (j < mn.instructions.size()) {
                    AbstractInsnNode in = mn.instructions.get(j);
                    in.accept((MethodVisitor)new EmptyVisitor(){

                        public void visitFrame(int type, int local, Object[] locals, int stack, Object[] stacks) {
                            if (type != 0 && type != -1) {
                                throw new RuntimeException("Compressed frames unsupported, use EXPAND_FRAMES option");
                            }
                            JasminifierClassAdapter.this.pw.println(".stack");
                            int i = 0;
                            while (i < local) {
                                JasminifierClassAdapter.this.pw.print("locals ");
                                JasminifierClassAdapter.this.printFrameType(locals[i]);
                                JasminifierClassAdapter.this.pw.println();
                                ++i;
                            }
                            i = 0;
                            while (i < stack) {
                                JasminifierClassAdapter.this.pw.print("stack ");
                                JasminifierClassAdapter.this.printFrameType(stacks[i]);
                                JasminifierClassAdapter.this.pw.println();
                                ++i;
                            }
                            JasminifierClassAdapter.this.pw.println(".end stack");
                        }

                        public void visitInsn(int opcode) {
                            JasminifierClassAdapter.this.print(opcode);
                            JasminifierClassAdapter.this.pw.println();
                        }

                        public void visitIntInsn(int opcode, int operand) {
                            JasminifierClassAdapter.this.print(opcode);
                            if (opcode == 188) {
                                switch (operand) {
                                    case 4: {
                                        JasminifierClassAdapter.this.pw.println(" boolean");
                                        break;
                                    }
                                    case 5: {
                                        JasminifierClassAdapter.this.pw.println(" char");
                                        break;
                                    }
                                    case 6: {
                                        JasminifierClassAdapter.this.pw.println(" float");
                                        break;
                                    }
                                    case 7: {
                                        JasminifierClassAdapter.this.pw.println(" double");
                                        break;
                                    }
                                    case 8: {
                                        JasminifierClassAdapter.this.pw.println(" byte");
                                        break;
                                    }
                                    case 9: {
                                        JasminifierClassAdapter.this.pw.println(" short");
                                        break;
                                    }
                                    case 10: {
                                        JasminifierClassAdapter.this.pw.println(" int");
                                        break;
                                    }
                                    default: {
                                        JasminifierClassAdapter.this.pw.println(" long");
                                        break;
                                    }
                                }
                            } else {
                                JasminifierClassAdapter.this.pw.print(' ');
                                JasminifierClassAdapter.this.pw.println(operand);
                            }
                        }

                        public void visitVarInsn(int opcode, int var) {
                            JasminifierClassAdapter.this.print(opcode);
                            JasminifierClassAdapter.this.pw.print(' ');
                            JasminifierClassAdapter.this.pw.println(var);
                        }

                        public void visitTypeInsn(int opcode, String type) {
                            JasminifierClassAdapter.this.print(opcode);
                            JasminifierClassAdapter.this.pw.print(' ');
                            JasminifierClassAdapter.this.pw.println(type);
                        }

                        public void visitFieldInsn(int opcode, String owner, String name, String desc) {
                            JasminifierClassAdapter.this.print(opcode);
                            JasminifierClassAdapter.this.pw.print(' ');
                            JasminifierClassAdapter.this.pw.print(owner);
                            JasminifierClassAdapter.this.pw.print('/');
                            JasminifierClassAdapter.this.pw.print(name);
                            JasminifierClassAdapter.this.pw.print(' ');
                            JasminifierClassAdapter.this.pw.println(desc);
                        }

                        public void visitMethodInsn(int opcode, String owner, String name, String desc) {
                            JasminifierClassAdapter.this.print(opcode);
                            JasminifierClassAdapter.this.pw.print(' ');
                            JasminifierClassAdapter.this.pw.print(owner);
                            JasminifierClassAdapter.this.pw.print('/');
                            JasminifierClassAdapter.this.pw.print(name);
                            JasminifierClassAdapter.this.pw.print(desc);
                            if (opcode == 185) {
                                JasminifierClassAdapter.this.pw.print(' ');
                                JasminifierClassAdapter.this.pw.print((Type.getArgumentsAndReturnSizes((String)desc) >> 2) - 1);
                            }
                            JasminifierClassAdapter.this.pw.println();
                        }

                        public void visitJumpInsn(int opcode, Label label) {
                            JasminifierClassAdapter.this.print(opcode);
                            JasminifierClassAdapter.this.pw.print(' ');
                            JasminifierClassAdapter.this.print(label);
                            JasminifierClassAdapter.this.pw.println();
                        }

                        public void visitLabel(Label label) {
                            JasminifierClassAdapter.this.print(label);
                            JasminifierClassAdapter.this.pw.println(':');
                        }

                        public void visitLdcInsn(Object cst) {
                            if (cst instanceof Integer || cst instanceof Float) {
                                JasminifierClassAdapter.this.pw.print("ldc_w ");
                                JasminifierClassAdapter.this.print(cst);
                            } else if (cst instanceof Long || cst instanceof Double) {
                                JasminifierClassAdapter.this.pw.print("ldc2_w ");
                                JasminifierClassAdapter.this.print(cst);
                            } else {
                                JasminifierClassAdapter.this.pw.print("ldc ");
                                if (cst instanceof Type) {
                                    JasminifierClassAdapter.this.pw.print(((Type)cst).getInternalName());
                                } else {
                                    JasminifierClassAdapter.this.print(cst);
                                }
                            }
                            JasminifierClassAdapter.this.pw.println();
                        }

                        public void visitIincInsn(int var, int increment) {
                            JasminifierClassAdapter.this.pw.print("iinc ");
                            JasminifierClassAdapter.this.pw.print(var);
                            JasminifierClassAdapter.this.pw.print(' ');
                            JasminifierClassAdapter.this.pw.println(increment);
                        }

                        public void visitTableSwitchInsn(int min, int max, Label dflt, Label[] labels) {
                            JasminifierClassAdapter.this.pw.print("tableswitch ");
                            JasminifierClassAdapter.this.pw.println(min);
                            int i = 0;
                            while (i < labels.length) {
                                JasminifierClassAdapter.this.print(labels[i]);
                                JasminifierClassAdapter.this.pw.println();
                                ++i;
                            }
                            JasminifierClassAdapter.this.pw.print("default : ");
                            JasminifierClassAdapter.this.print(dflt);
                            JasminifierClassAdapter.this.pw.println();
                        }

                        public void visitLookupSwitchInsn(Label dflt, int[] keys, Label[] labels) {
                            JasminifierClassAdapter.this.pw.println("lookupswitch");
                            int i = 0;
                            while (i < keys.length) {
                                JasminifierClassAdapter.this.pw.print(keys[i]);
                                JasminifierClassAdapter.this.pw.print(" : ");
                                JasminifierClassAdapter.this.print(labels[i]);
                                JasminifierClassAdapter.this.pw.println();
                                ++i;
                            }
                            JasminifierClassAdapter.this.pw.print("default : ");
                            JasminifierClassAdapter.this.print(dflt);
                            JasminifierClassAdapter.this.pw.println();
                        }

                        public void visitMultiANewArrayInsn(String desc, int dims) {
                            JasminifierClassAdapter.this.pw.print("multianewarray ");
                            JasminifierClassAdapter.this.pw.print(desc);
                            JasminifierClassAdapter.this.pw.print(' ');
                            JasminifierClassAdapter.this.pw.println(dims);
                        }

                        public void visitLineNumber(int line, Label start) {
                            JasminifierClassAdapter.this.pw.print(".line ");
                            JasminifierClassAdapter.this.pw.println(line);
                        }
                    });
                    ++j;
                }
                if (mn.localVariables != null) {
                    j = 0;
                    while (j < mn.localVariables.size()) {
                        LocalVariableNode lv = (LocalVariableNode)mn.localVariables.get(j);
                        this.pw.print(".var ");
                        this.pw.print(lv.index);
                        this.pw.print(" is '");
                        this.pw.print(lv.name);
                        this.pw.print("' ");
                        this.pw.print(lv.desc);
                        if (lv.signature != null) {
                            this.pw.print(" signature \"");
                            this.pw.print(lv.signature);
                            this.pw.print("\"");
                        }
                        this.pw.print(" from ");
                        this.print(lv.start);
                        this.pw.print(" to ");
                        this.print(lv.end);
                        this.pw.println();
                        ++j;
                    }
                }
                this.println(".limit locals ", Integer.toString(mn.maxLocals));
                this.println(".limit stack ", Integer.toString(mn.maxStack));
            }
            this.pw.println(".end method");
            ++i;
        }
        super.visitEnd();
    }

    protected void println(String directive, String arg) {
        if (arg != null) {
            this.pw.print(directive);
            this.pw.println(arg);
        }
    }

    protected String access(int access) {
        StringBuffer b = new StringBuffer();
        if ((access & 1) != 0) {
            b.append(" public");
        }
        if ((access & 2) != 0) {
            b.append(" private");
        }
        if ((access & 4) != 0) {
            b.append(" protected");
        }
        if ((access & 8) != 0) {
            b.append(" static");
        }
        if ((access & 0x10) != 0) {
            b.append(" final");
        }
        if ((access & 0x20) != 0) {
            b.append(" synchronized");
        }
        if ((access & 0x40) != 0) {
            b.append(" volatile");
        }
        if ((access & 0x80) != 0) {
            b.append(" transient");
        }
        if ((access & 0x100) != 0) {
            b.append(" native");
        }
        if ((access & 0x400) != 0) {
            b.append(" abstract");
        }
        if ((access & 0x800) != 0) {
            b.append(" fpstrict");
        }
        if ((access & 0x1000) != 0) {
            b.append(" synthetic");
        }
        if ((access & 0x200) != 0) {
            b.append(" interface");
        }
        if ((access & 0x2000) != 0) {
            b.append(" annotation");
        }
        if ((access & 0x4000) != 0) {
            b.append(" enum");
        }
        return b.toString();
    }

    protected void print(int opcode) {
        this.pw.print(AbstractVisitor.OPCODES[opcode].toLowerCase());
    }

    protected void print(Object cst) {
        if (cst instanceof String) {
            StringBuffer buf = new StringBuffer();
            AbstractVisitor.appendString((StringBuffer)buf, (String)((String)cst));
            this.pw.print(buf.toString());
        } else if (cst instanceof Float) {
            Float f = (Float)cst;
            if (!f.isNaN() && !f.isInfinite()) {
                this.pw.print(cst + "F");
            } else if (f.isNaN()) {
                this.pw.print("0NAN_F");
            } else {
                double v = f.floatValue();
                if (v == Double.POSITIVE_INFINITY) {
                    this.pw.print("0POS_INFI_F");
                } else {
                    this.pw.print("0NEG_INFI_F");
                }
            }
        } else if (cst instanceof Double) {
            Double d = (Double)cst;
            if (!d.isNaN() && !d.isInfinite()) {
                this.pw.print(cst + "D");
            } else if (d.isNaN()) {
                this.pw.print("0NAN_D");
            } else {
                double v = d;
                if (v == Double.POSITIVE_INFINITY) {
                    this.pw.print("0POS_INFI_D");
                } else {
                    this.pw.print("0NEG_INFI_D");
                }
            }
        } else if (cst instanceof Long) {
            this.pw.print(cst + "L");
        } else {
            this.pw.print(cst);
        }
    }

    protected void print(Label l) {
        String name = (String)this.labelNames.get(l);
        if (name == null) {
            name = "L" + this.labelNames.size();
            this.labelNames.put(l, name);
        }
        this.pw.print(name);
    }

    protected void print(LabelNode l) {
        this.print(l.getLabel());
    }

    protected void printAnnotations(MemberNode n) {
        int j;
        if (n.visibleAnnotations != null) {
            j = 0;
            while (j < n.visibleAnnotations.size()) {
                this.printAnnotation((AnnotationNode)n.visibleAnnotations.get(j), 1, -1);
                ++j;
            }
        }
        if (n.invisibleAnnotations != null) {
            j = 0;
            while (j < n.invisibleAnnotations.size()) {
                this.printAnnotation((AnnotationNode)n.invisibleAnnotations.get(j), 2, -1);
                ++j;
            }
        }
    }

    protected void printAnnotation(AnnotationNode n, int visible, int param) {
        this.pw.print(".annotation ");
        if (visible > 0) {
            if (param == -1) {
                this.pw.print(visible == 1 ? "visible " : "invisible ");
            } else {
                this.pw.print(visible == 1 ? "visibleparam " : "invisibleparam ");
                this.pw.print(param);
                this.pw.print(' ');
            }
            this.pw.print(n.desc);
        }
        this.pw.println();
        if (n.values != null) {
            int i = 0;
            while (i < n.values.size()) {
                this.pw.print(n.values.get(i));
                this.pw.print(' ');
                this.printAnnotationValue(n.values.get(i + 1));
                i += 2;
            }
        }
        this.pw.println(".end annotation");
    }

    protected void printAnnotationValue(Object value) {
        if (value instanceof String[]) {
            this.pw.print("e ");
            this.pw.print(((String[])value)[0]);
            this.pw.print(" = ");
            this.print(((String[])value)[1]);
            this.pw.println();
        } else if (value instanceof AnnotationNode) {
            this.pw.print("@ ");
            this.pw.print(((AnnotationNode)value).desc);
            this.pw.print(" = ");
            this.printAnnotation((AnnotationNode)value, 0, -1);
        } else if (value instanceof byte[]) {
            byte[] v;
            this.pw.print("[B = ");
            byte[] byArray = v = (byte[])value;
            int n = v.length;
            int n2 = 0;
            while (n2 < n) {
                byte element = byArray[n2];
                this.pw.print(element);
                this.pw.print(' ');
                ++n2;
            }
            this.pw.println();
        } else if (value instanceof boolean[]) {
            boolean[] v;
            this.pw.print("[Z = ");
            boolean[] blArray = v = (boolean[])value;
            int n = v.length;
            int n3 = 0;
            while (n3 < n) {
                boolean element = blArray[n3];
                this.pw.print(element ? (char)'1' : '0');
                this.pw.print(' ');
                ++n3;
            }
            this.pw.println();
        } else if (value instanceof short[]) {
            short[] v;
            this.pw.print("[S = ");
            short[] sArray = v = (short[])value;
            int n = v.length;
            int n4 = 0;
            while (n4 < n) {
                short element = sArray[n4];
                this.pw.print(element);
                this.pw.print(' ');
                ++n4;
            }
            this.pw.println();
        } else if (value instanceof char[]) {
            char[] v;
            this.pw.print("[C = ");
            char[] cArray = v = (char[])value;
            int n = v.length;
            int n5 = 0;
            while (n5 < n) {
                char element = cArray[n5];
                this.pw.print(new Integer(element));
                this.pw.print(' ');
                ++n5;
            }
            this.pw.println();
        } else if (value instanceof int[]) {
            int[] v;
            this.pw.print("[I = ");
            int[] nArray = v = (int[])value;
            int n = v.length;
            int n6 = 0;
            while (n6 < n) {
                int element = nArray[n6];
                this.pw.print(element);
                this.pw.print(' ');
                ++n6;
            }
            this.pw.println();
        } else if (value instanceof long[]) {
            long[] v;
            this.pw.print("[J = ");
            long[] lArray = v = (long[])value;
            int n = v.length;
            int n7 = 0;
            while (n7 < n) {
                long element = lArray[n7];
                this.pw.print(element);
                this.pw.print(' ');
                ++n7;
            }
            this.pw.println();
        } else if (value instanceof float[]) {
            float[] v;
            this.pw.print("[F = ");
            float[] fArray = v = (float[])value;
            int n = v.length;
            int n8 = 0;
            while (n8 < n) {
                float element = fArray[n8];
                this.print(new Float(element));
                this.pw.print(' ');
                ++n8;
            }
            this.pw.println();
        } else if (value instanceof double[]) {
            double[] v;
            this.pw.print("[D = ");
            double[] dArray = v = (double[])value;
            int n = v.length;
            int n9 = 0;
            while (n9 < n) {
                double element = dArray[n9];
                this.print(new Double(element));
                this.pw.print(' ');
                ++n9;
            }
            this.pw.println();
        } else if (value instanceof List) {
            List l = (List)value;
            if (l.size() > 0) {
                Object o = l.get(0);
                if (o instanceof String[]) {
                    this.pw.print("[e ");
                    this.pw.print(((String[])o)[0]);
                    this.pw.print(" = ");
                } else if (o instanceof AnnotationNode) {
                    this.pw.print("[& ");
                    this.pw.print(((AnnotationNode)o).desc);
                    this.pw.print(" = ");
                    this.pw.print("[@ = ");
                } else if (o instanceof String) {
                    this.pw.print("[s = ");
                } else if (o instanceof Byte) {
                    this.pw.print("[B = ");
                } else if (o instanceof Boolean) {
                    this.pw.print("[Z = ");
                } else if (o instanceof Character) {
                    this.pw.print("[C = ");
                } else if (o instanceof Short) {
                    this.pw.print("[S = ");
                } else if (o instanceof Type) {
                    this.pw.print("[c = ");
                } else if (o instanceof Integer) {
                    this.pw.print("[I = ");
                } else if (o instanceof Float) {
                    this.pw.print("[F = ");
                } else if (o instanceof Long) {
                    this.pw.print("[J = ");
                } else if (o instanceof Double) {
                    this.pw.print("[D = ");
                }
                int j = 0;
                while (j < l.size()) {
                    this.printAnnotationArrayValue(l.get(j));
                    this.pw.print(' ');
                    ++j;
                }
            } else {
                this.pw.print("; empty array annotation value");
            }
            this.pw.println();
        } else if (value instanceof String) {
            this.pw.print("s = ");
            this.print(value);
            this.pw.println();
        } else if (value instanceof Byte) {
            this.pw.print("B = ");
            this.pw.println(((Byte)value).intValue());
        } else if (value instanceof Boolean) {
            this.pw.print("Z = ");
            this.pw.println((Boolean)value != false ? 1 : 0);
        } else if (value instanceof Character) {
            this.pw.print("C = ");
            this.pw.println(new Integer(((Character)value).charValue()));
        } else if (value instanceof Short) {
            this.pw.print("S = ");
            this.pw.println(((Short)value).intValue());
        } else if (value instanceof Type) {
            this.pw.print("c = ");
            this.pw.println(((Type)value).getDescriptor());
        } else if (value instanceof Integer) {
            this.pw.print("I = ");
            this.print(value);
            this.pw.println();
        } else if (value instanceof Float) {
            this.pw.print("F = ");
            this.print(value);
            this.pw.println();
        } else if (value instanceof Long) {
            this.pw.print("J = ");
            this.print(value);
            this.pw.println();
        } else if (value instanceof Double) {
            this.pw.print("D = ");
            this.print(value);
            this.pw.println();
        } else {
            throw new RuntimeException();
        }
    }

    protected void printAnnotationArrayValue(Object value) {
        if (value instanceof String[]) {
            this.print(((String[])value)[1]);
        } else if (value instanceof AnnotationNode) {
            this.printAnnotation((AnnotationNode)value, 0, -1);
        } else if (value instanceof String) {
            this.print(value);
        } else if (value instanceof Byte) {
            this.pw.print(((Byte)value).intValue());
        } else if (value instanceof Boolean) {
            this.pw.print((Boolean)value != false ? 1 : 0);
        } else if (value instanceof Character) {
            this.pw.print(new Integer(((Character)value).charValue()));
        } else if (value instanceof Short) {
            this.pw.print(((Short)value).intValue());
        } else if (value instanceof Type) {
            this.pw.print(((Type)value).getDescriptor());
        } else {
            this.print(value);
        }
    }

    protected void printFrameType(Object type) {
        if (type == Opcodes.TOP) {
            this.pw.print("Top");
        } else if (type == Opcodes.INTEGER) {
            this.pw.print("Integer");
        } else if (type == Opcodes.FLOAT) {
            this.pw.print("Float");
        } else if (type == Opcodes.LONG) {
            this.pw.print("Long");
        } else if (type == Opcodes.DOUBLE) {
            this.pw.print("Double");
        } else if (type == Opcodes.NULL) {
            this.pw.print("Null");
        } else if (type == Opcodes.UNINITIALIZED_THIS) {
            this.pw.print("UninitializedThis");
        } else if (type instanceof Label) {
            this.pw.print("Uninitialized ");
            this.print((Label)type);
        } else {
            this.pw.print("Object ");
            this.pw.print(type);
        }
    }
}

