/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.universalchardet.prober.statemachine;

public class PkgInt {
    public static final int BIT_SHIFT_16BITS = 4;
    public static final int BIT_SHIFT_4BITS = 2;
    public static final int BIT_SHIFT_8BITS = 3;
    public static final int INDEX_SHIFT_16BITS = 1;
    public static final int INDEX_SHIFT_4BITS = 3;
    public static final int INDEX_SHIFT_8BITS = 2;
    public static final int SHIFT_MASK_16BITS = 1;
    public static final int SHIFT_MASK_4BITS = 7;
    public static final int SHIFT_MASK_8BITS = 3;
    public static final int UNIT_MASK_16BITS = 65535;
    public static final int UNIT_MASK_4BITS = 15;
    public static final int UNIT_MASK_8BITS = 255;
    private int bitShift;
    private int[] data;
    private int indexShift;
    private int shiftMask;
    private int unitMask;

    public PkgInt(int n, int n2, int n3, int n4, int[] nArray) {
        this.indexShift = n;
        this.shiftMask = n2;
        this.bitShift = n3;
        this.unitMask = n4;
        this.data = nArray;
    }

    public static int pack16bits(int n, int n2) {
        return n | n2 << 16;
    }

    public static int pack4bits(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        return PkgInt.pack8bits(n | n2 << 4, n3 | n4 << 4, n5 | n6 << 4, n7 | n8 << 4);
    }

    public static int pack8bits(int n, int n2, int n3, int n4) {
        return PkgInt.pack16bits(n | n2 << 8, n3 | n4 << 8);
    }

    public int unpack(int n) {
        return this.data[n >> this.indexShift] >> ((n & this.shiftMask) << this.bitShift) & this.unitMask;
    }
}

