/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.universalchardet.prober.distributionanalysis;

public abstract class CharDistributionAnalysis {
    public static final int ENOUGH_DATA_THRESHOLD = 1024;
    public static final int MINIMUM_DATA_THRESHOLD = 4;
    public static final float SURE_NO = 0.01f;
    public static final float SURE_YES = 0.99f;
    protected int[] charToFreqOrder;
    protected boolean done;
    private int freqChars;
    private int totalChars;
    protected float typicalDistributionRatio;

    public CharDistributionAnalysis() {
        this.reset();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public float getConfidence() {
        if (this.totalChars <= 0) return 0.01f;
        if (this.freqChars <= 4) {
            return 0.01f;
        }
        if (this.totalChars == this.freqChars) return 0.99f;
        float f = (float)(this.freqChars / (this.totalChars - this.freqChars)) * this.typicalDistributionRatio;
        if (f < 0.99f) return f;
        return 0.99f;
    }

    protected abstract int getOrder(byte[] var1, int var2);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean gotEnoughData() {
        if (this.totalChars <= 1024) return false;
        return true;
    }

    public void handleData(byte[] byArray, int n, int n2) {
    }

    public void handleOneChar(byte[] byArray, int n, int n2) {
        int n3 = -1;
        if (n2 == 2) {
            n3 = this.getOrder(byArray, n);
        }
        if (n3 >= 0) {
            this.totalChars = 1 + this.totalChars;
            if (n3 < this.charToFreqOrder.length && 512 > this.charToFreqOrder[n3]) {
                this.freqChars = 1 + this.freqChars;
            }
        }
    }

    public void reset() {
        this.done = false;
        this.totalChars = 0;
        this.freqChars = 0;
    }

    public void setOption() {
    }
}

