/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.universalchardet.prober.contextanalysis;

import org.mozilla.universalchardet.prober.contextanalysis.JapaneseContextAnalysis;

public class SJISContextAnalysis
extends JapaneseContextAnalysis {
    public static final int HIGHBYTE_BEGIN_1 = 129;
    public static final int HIGHBYTE_BEGIN_2 = 224;
    public static final int HIGHBYTE_END_1 = 159;
    public static final int HIGHBYTE_END_2 = 239;
    public static final int HIRAGANA_HIGHBYTE = 130;
    public static final int HIRAGANA_LOWBYTE_BEGIN = 159;
    public static final int HIRAGANA_LOWBYTE_END = 241;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected int getOrder(byte[] byArray, int n) {
        if ((0xFF & byArray[n]) != 130) return -1;
        int n2 = 0xFF & byArray[n + 1];
        if (n2 < 159) return -1;
        if (n2 > 241) return -1;
        return n2 + -159;
    }

    @Override
    protected void getOrder(JapaneseContextAnalysis.Order order, byte[] byArray, int n) {
        int n2;
        order.order = -1;
        order.charLength = 1;
        int n3 = 0xFF & byArray[n];
        if (n3 >= 129 && n3 <= 159 || n3 >= 224 && n3 <= 239) {
            order.charLength = 2;
        }
        if (n3 == 130 && (n2 = 0xFF & byArray[n + 1]) >= 159 && n2 <= 241) {
            order.order = n2 + -159;
        }
    }
}

