/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.universalchardet.prober;

import java.nio.ByteBuffer;
import org.mozilla.universalchardet.prober.CharsetProber;
import org.mozilla.universalchardet.prober.HebrewProber;
import org.mozilla.universalchardet.prober.SingleByteCharsetProber;
import org.mozilla.universalchardet.prober.sequence.HebrewModel;
import org.mozilla.universalchardet.prober.sequence.Ibm855Model;
import org.mozilla.universalchardet.prober.sequence.Ibm866Model;
import org.mozilla.universalchardet.prober.sequence.Koi8rModel;
import org.mozilla.universalchardet.prober.sequence.Latin5BulgarianModel;
import org.mozilla.universalchardet.prober.sequence.Latin5Model;
import org.mozilla.universalchardet.prober.sequence.Latin7Model;
import org.mozilla.universalchardet.prober.sequence.MacCyrillicModel;
import org.mozilla.universalchardet.prober.sequence.SequenceModel;
import org.mozilla.universalchardet.prober.sequence.Win1251BulgarianModel;
import org.mozilla.universalchardet.prober.sequence.Win1251Model;
import org.mozilla.universalchardet.prober.sequence.Win1253Model;

public class SBCSGroupProber
extends CharsetProber {
    private static final SequenceModel hebrewModel;
    private static final SequenceModel ibm855Model;
    private static final SequenceModel ibm866Model;
    private static final SequenceModel koi8rModel;
    private static final SequenceModel latin5BulgarianModel;
    private static final SequenceModel latin5Model;
    private static final SequenceModel latin7Model;
    private static final SequenceModel macCyrillicModel;
    private static final SequenceModel win1251BulgarianModel;
    private static final SequenceModel win1251Model;
    private static final SequenceModel win1253Model;
    private int activeNum;
    private int bestGuess;
    private boolean[] isActive;
    private CharsetProber[] probers = new CharsetProber[13];
    private CharsetProber.ProbingState state;

    static {
        win1251Model = new Win1251Model();
        koi8rModel = new Koi8rModel();
        latin5Model = new Latin5Model();
        macCyrillicModel = new MacCyrillicModel();
        ibm866Model = new Ibm866Model();
        ibm855Model = new Ibm855Model();
        latin7Model = new Latin7Model();
        win1253Model = new Win1253Model();
        latin5BulgarianModel = new Latin5BulgarianModel();
        win1251BulgarianModel = new Win1251BulgarianModel();
        hebrewModel = new HebrewModel();
    }

    public SBCSGroupProber() {
        this.isActive = new boolean[13];
        this.probers[0] = new SingleByteCharsetProber(win1251Model);
        this.probers[1] = new SingleByteCharsetProber(koi8rModel);
        this.probers[2] = new SingleByteCharsetProber(latin5Model);
        this.probers[3] = new SingleByteCharsetProber(macCyrillicModel);
        this.probers[4] = new SingleByteCharsetProber(ibm866Model);
        this.probers[5] = new SingleByteCharsetProber(ibm855Model);
        this.probers[6] = new SingleByteCharsetProber(latin7Model);
        this.probers[7] = new SingleByteCharsetProber(win1253Model);
        this.probers[8] = new SingleByteCharsetProber(latin5BulgarianModel);
        this.probers[9] = new SingleByteCharsetProber(win1251BulgarianModel);
        HebrewProber hebrewProber = new HebrewProber();
        this.probers[10] = hebrewProber;
        this.probers[11] = new SingleByteCharsetProber(hebrewModel, false, hebrewProber);
        this.probers[12] = new SingleByteCharsetProber(hebrewModel, true, hebrewProber);
        hebrewProber.setModalProbers(this.probers[11], this.probers[12]);
        this.reset();
    }

    @Override
    public String getCharSetName() {
        if (this.bestGuess == -1) {
            this.getConfidence();
            if (this.bestGuess == -1) {
                this.bestGuess = 0;
            }
        }
        return this.probers[this.bestGuess].getCharSetName();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public float getConfidence() {
        float f = 0.0f;
        if (this.state == CharsetProber.ProbingState.FOUND_IT) {
            return 0.99f;
        }
        if (this.state == CharsetProber.ProbingState.NOT_ME) {
            return 0.01f;
        }
        int n = 0;
        while (n < this.probers.length) {
            float f2;
            if (this.isActive[n] && f < (f2 = this.probers[n].getConfidence())) {
                this.bestGuess = n;
                f = f2;
            }
            ++n;
        }
        return f;
    }

    @Override
    public CharsetProber.ProbingState getState() {
        return this.state;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public CharsetProber.ProbingState handleData(byte[] byArray, int n, int n2) {
        ByteBuffer byteBuffer = this.filterWithoutEnglishLetters(byArray, n, n2);
        if (byteBuffer.position() == 0) {
            return this.state;
        }
        int n3 = 0;
        while (n3 < this.probers.length) {
            if (this.isActive[n3]) {
                CharsetProber.ProbingState probingState = this.probers[n3].handleData(byteBuffer.array(), 0, byteBuffer.position());
                if (probingState == CharsetProber.ProbingState.FOUND_IT) {
                    this.bestGuess = n3;
                    this.state = CharsetProber.ProbingState.FOUND_IT;
                    return this.state;
                }
                if (probingState == CharsetProber.ProbingState.NOT_ME) {
                    this.isActive[n3] = false;
                    this.activeNum = -1 + this.activeNum;
                    if (this.activeNum <= 0) {
                        this.state = CharsetProber.ProbingState.NOT_ME;
                        return this.state;
                    }
                }
            }
            ++n3;
        }
        return this.state;
    }

    @Override
    public void reset() {
        int n;
        this.activeNum = n = 0;
        while (n < this.probers.length) {
            this.probers[n].reset();
            this.isActive[n] = true;
            this.activeNum = 1 + this.activeNum;
            ++n;
        }
        this.bestGuess = -1;
        this.state = CharsetProber.ProbingState.DETECTING;
    }

    @Override
    public void setOption() {
    }
}

