/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.universalchardet.prober;

import org.mozilla.universalchardet.prober.Big5Prober;
import org.mozilla.universalchardet.prober.CharsetProber;
import org.mozilla.universalchardet.prober.EUCJPProber;
import org.mozilla.universalchardet.prober.EUCKRProber;
import org.mozilla.universalchardet.prober.EUCTWProber;
import org.mozilla.universalchardet.prober.GB18030Prober;
import org.mozilla.universalchardet.prober.SJISProber;
import org.mozilla.universalchardet.prober.UTF8Prober;

public class MBCSGroupProber
extends CharsetProber {
    private int activeNum;
    private int bestGuess;
    private boolean[] isActive;
    private CharsetProber[] probers = new CharsetProber[7];
    private CharsetProber.ProbingState state;

    public MBCSGroupProber() {
        this.isActive = new boolean[7];
        this.probers[0] = new UTF8Prober();
        this.probers[1] = new SJISProber();
        this.probers[2] = new EUCJPProber();
        this.probers[3] = new GB18030Prober();
        this.probers[4] = new EUCKRProber();
        this.probers[5] = new Big5Prober();
        this.probers[6] = new EUCTWProber();
        this.reset();
    }

    @Override
    public String getCharSetName() {
        if (this.bestGuess == -1) {
            this.getConfidence();
            if (this.bestGuess == -1) {
                this.bestGuess = 0;
            }
        }
        return this.probers[this.bestGuess].getCharSetName();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public float getConfidence() {
        float f = 0.0f;
        if (this.state == CharsetProber.ProbingState.FOUND_IT) {
            return 0.99f;
        }
        if (this.state == CharsetProber.ProbingState.NOT_ME) {
            return 0.01f;
        }
        int n = 0;
        while (n < this.probers.length) {
            float f2;
            if (this.isActive[n] && f < (f2 = this.probers[n].getConfidence())) {
                this.bestGuess = n;
                f = f2;
            }
            ++n;
        }
        return f;
    }

    @Override
    public CharsetProber.ProbingState getState() {
        return this.state;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public CharsetProber.ProbingState handleData(byte[] byArray, int n, int n2) {
        byte[] byArray2 = new byte[n2];
        int n3 = n + n2;
        int n4 = 0;
        boolean bl = true;
        while (true) {
            boolean bl2;
            int n5;
            if (n >= n3) break;
            if ((0x80 & byArray[n]) != 0) {
                n5 = n4 + 1;
                byArray2[n4] = byArray[n];
                bl2 = true;
            } else if (bl) {
                n5 = n4 + 1;
                byArray2[n4] = byArray[n];
                bl2 = false;
            } else {
                int n6 = n4;
                bl2 = bl;
                n5 = n6;
            }
            ++n;
            int n7 = n5;
            bl = bl2;
            n4 = n7;
        }
        int n8 = 0;
        while (n8 < this.probers.length) {
            if (this.isActive[n8]) {
                CharsetProber.ProbingState probingState = this.probers[n8].handleData(byArray2, 0, n4);
                if (probingState == CharsetProber.ProbingState.FOUND_IT) {
                    this.bestGuess = n8;
                    this.state = CharsetProber.ProbingState.FOUND_IT;
                    return this.state;
                }
                if (probingState == CharsetProber.ProbingState.NOT_ME) {
                    this.isActive[n8] = false;
                    this.activeNum = -1 + this.activeNum;
                    if (this.activeNum <= 0) {
                        this.state = CharsetProber.ProbingState.NOT_ME;
                        return this.state;
                    }
                }
            }
            ++n8;
        }
        return this.state;
    }

    @Override
    public void reset() {
        int n;
        this.activeNum = n = 0;
        while (n < this.probers.length) {
            this.probers[n].reset();
            this.isActive[n] = true;
            this.activeNum = 1 + this.activeNum;
            ++n;
        }
        this.bestGuess = -1;
        this.state = CharsetProber.ProbingState.DETECTING;
    }

    @Override
    public void setOption() {
    }
}

