/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.universalchardet.prober;

import java.nio.ByteBuffer;
import org.mozilla.universalchardet.Constants;
import org.mozilla.universalchardet.prober.CharsetProber;

public class Latin1Prober
extends CharsetProber {
    public static final byte ACO = 5;
    public static final byte ACV = 4;
    public static final byte ASC = 2;
    public static final byte ASO = 7;
    public static final byte ASS = 3;
    public static final byte ASV = 6;
    public static final int CLASS_NUM = 8;
    public static final int FREQ_CAT_NUM = 4;
    public static final byte OTH = 1;
    public static final byte UDF;
    private static final byte[] latin1CharToClass;
    private static final byte[] latin1ClassModel;
    private int[] freqCounter = new int[4];
    private byte lastCharClass;
    private CharsetProber.ProbingState state;

    static {
        byte[] byArray = new byte[]{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 1, 1, 1, 1, 1, 1, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 1, 1, 1, 1, 1, 1, 0, 1, 7, 1, 1, 1, 1, 1, 1, 5, 1, 5, 0, 5, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 7, 1, 7, 0, 7, 5, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 4, 4, 4, 4, 4, 4, 5, 5, 4, 4, 4, 4, 4, 4, 4, 4, 5, 5, 4, 4, 4, 4, 4, 1, 4, 4, 4, 4, 4, 5, 5, 5, 6, 6, 6, 6, 6, 6, 7, 7, 6, 6, 6, 6, 6, 6, 6, 6, 7, 7, 6, 6, 6, 6, 6, 1, 6, 6, 6, 6, 6, 7, 7, 7};
        latin1CharToClass = byArray;
        byte[] byArray2 = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 3, 3, 3, 3, 3, 3, 0, 3, 3, 3, 3, 3, 3, 3, 0, 3, 3, 3, 1, 1, 3, 3, 0, 3, 3, 3, 1, 2, 1, 2, 0, 3, 3, 3, 3, 3, 3, 3, 0, 3, 1, 3, 1, 1, 1, 3, 0, 3, 1, 3, 1, 1, 3, 3};
        latin1ClassModel = byArray2;
    }

    public Latin1Prober() {
        this.reset();
    }

    @Override
    public String getCharSetName() {
        return Constants.CHARSET_WINDOWS_1252;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public float getConfidence() {
        int n;
        if (this.state == CharsetProber.ProbingState.NOT_ME) {
            return 0.01f;
        }
        int n2 = n;
        for (n = 0; n < this.freqCounter.length; n2 += this.freqCounter[n], ++n) {
        }
        float f = n2 <= 0 ? 0.0f : 1.0f * (float)this.freqCounter[3] / (float)n2 - 20.0f * (float)this.freqCounter[1] / (float)n2;
        if (!(f < 0.0f)) return f * 0.5f;
        return 0.0f;
    }

    @Override
    public CharsetProber.ProbingState getState() {
        return this.state;
    }

    @Override
    public CharsetProber.ProbingState handleData(byte[] byArray, int n, int n2) {
        ByteBuffer byteBuffer = this.filterWithEnglishLetters(byArray, n, n2);
        byte[] byArray2 = byteBuffer.array();
        int n3 = byteBuffer.position();
        int n4 = 0;
        while (true) {
            byte by;
            byte by2;
            block4: {
                block3: {
                    if (n4 >= n3) break block3;
                    int n5 = 0xFF & byArray2[n4];
                    by2 = latin1CharToClass[n5];
                    by = latin1ClassModel[by2 + 8 * this.lastCharClass];
                    if (by != 0) break block4;
                    this.state = CharsetProber.ProbingState.NOT_ME;
                }
                return this.state;
            }
            int[] nArray = this.freqCounter;
            nArray[by] = 1 + nArray[by];
            this.lastCharClass = by2;
            ++n4;
        }
    }

    @Override
    public void reset() {
        this.state = CharsetProber.ProbingState.DETECTING;
        this.lastCharClass = 1;
        for (int i = 0; i < this.freqCounter.length; ++i) {
            this.freqCounter[i] = 0;
        }
    }

    @Override
    public void setOption() {
    }
}

