/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.universalchardet.prober;

import org.mozilla.universalchardet.Constants;
import org.mozilla.universalchardet.prober.CharsetProber;

public class HebrewProber
extends CharsetProber {
    public static final int FINAL_KAF = 234;
    public static final int FINAL_MEM = 237;
    public static final int FINAL_NUN = 239;
    public static final int FINAL_PE = 243;
    public static final int FINAL_TSADI = 245;
    public static final int MIN_FINAL_CHAR_DISTANCE = 5;
    public static final float MIN_MODEL_DISTANCE = 0.01f;
    public static final int NORMAL_KAF = 235;
    public static final int NORMAL_MEM = 238;
    public static final int NORMAL_NUN = 240;
    public static final int NORMAL_PE = 244;
    public static final int NORMAL_TSADI = 246;
    public static final byte SPACE = 32;
    private byte beforePrev;
    private int finalCharLogicalScore;
    private int finalCharVisualScore;
    private CharsetProber logicalProber = null;
    private byte prev;
    private CharsetProber visualProber = null;

    public HebrewProber() {
        this.reset();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected static boolean isFinal(byte by) {
        int n = by & 0xFF;
        if (n == 234) return true;
        if (n == 237) return true;
        if (n == 239) return true;
        if (n == 243) return true;
        if (n != 245) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected static boolean isNonFinal(byte by) {
        int n = by & 0xFF;
        if (n == 235) return true;
        if (n == 238) return true;
        if (n == 240) return true;
        if (n != 244) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public String getCharSetName() {
        int n = this.finalCharLogicalScore - this.finalCharVisualScore;
        if (n >= 5) {
            return Constants.CHARSET_WINDOWS_1255;
        }
        if (n <= -5) {
            return Constants.CHARSET_ISO_8859_8;
        }
        float f = this.logicalProber.getConfidence() - this.visualProber.getConfidence();
        if (f > 0.01f) {
            return Constants.CHARSET_WINDOWS_1255;
        }
        if (f < -0.01f) {
            return Constants.CHARSET_ISO_8859_8;
        }
        if (n >= 0) return Constants.CHARSET_WINDOWS_1255;
        return Constants.CHARSET_ISO_8859_8;
    }

    @Override
    public float getConfidence() {
        return 0.0f;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public CharsetProber.ProbingState getState() {
        if (this.logicalProber.getState() != CharsetProber.ProbingState.NOT_ME) return CharsetProber.ProbingState.DETECTING;
        if (this.visualProber.getState() != CharsetProber.ProbingState.NOT_ME) return CharsetProber.ProbingState.DETECTING;
        return CharsetProber.ProbingState.NOT_ME;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public CharsetProber.ProbingState handleData(byte[] byArray, int n, int n2) {
        if (this.getState() == CharsetProber.ProbingState.NOT_ME) {
            return CharsetProber.ProbingState.NOT_ME;
        }
        int n3 = n + n2;
        while (true) {
            byte by;
            block9: {
                block8: {
                    if (n >= n3) {
                        return CharsetProber.ProbingState.DETECTING;
                    }
                    by = byArray[n];
                    if (by != 32) break block8;
                    if (this.beforePrev != 32) {
                        if (HebrewProber.isFinal(this.prev)) {
                            this.finalCharLogicalScore = 1 + this.finalCharLogicalScore;
                            break block9;
                        } else if (HebrewProber.isNonFinal(this.prev)) {
                            this.finalCharVisualScore = 1 + this.finalCharVisualScore;
                        }
                    }
                    break block9;
                }
                if (this.beforePrev == 32 && HebrewProber.isFinal(this.prev) && by != 32) {
                    this.finalCharVisualScore = 1 + this.finalCharVisualScore;
                }
            }
            this.beforePrev = this.prev;
            this.prev = by;
            ++n;
        }
    }

    @Override
    public void reset() {
        this.finalCharLogicalScore = 0;
        this.finalCharVisualScore = 0;
        this.prev = (byte)32;
        this.beforePrev = (byte)32;
    }

    public void setModalProbers(CharsetProber charsetProber, CharsetProber charsetProber2) {
        this.logicalProber = charsetProber;
        this.visualProber = charsetProber2;
    }

    @Override
    public void setOption() {
    }
}

