/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.universalchardet.prober;

import java.util.Arrays;
import org.mozilla.universalchardet.Constants;
import org.mozilla.universalchardet.prober.CharsetProber;
import org.mozilla.universalchardet.prober.distributionanalysis.EUCKRDistributionAnalysis;
import org.mozilla.universalchardet.prober.statemachine.CodingStateMachine;
import org.mozilla.universalchardet.prober.statemachine.EUCKRSMModel;
import org.mozilla.universalchardet.prober.statemachine.SMModel;

public class EUCKRProber
extends CharsetProber {
    private static final SMModel smModel = new EUCKRSMModel();
    private CodingStateMachine codingSM = new CodingStateMachine(smModel);
    private EUCKRDistributionAnalysis distributionAnalyzer = new EUCKRDistributionAnalysis();
    private byte[] lastChar = new byte[2];
    private CharsetProber.ProbingState state;

    public EUCKRProber() {
        this.reset();
    }

    @Override
    public String getCharSetName() {
        return Constants.CHARSET_EUC_KR;
    }

    @Override
    public float getConfidence() {
        return this.distributionAnalyzer.getConfidence();
    }

    @Override
    public CharsetProber.ProbingState getState() {
        return this.state;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public CharsetProber.ProbingState handleData(byte[] byArray, int n, int n2) {
        int n3 = n + n2;
        int n4 = n;
        while (true) {
            int n5;
            block10: {
                block8: {
                    block9: {
                        if (n4 >= n3) break block8;
                        n5 = this.codingSM.nextState(byArray[n4]);
                        if (n5 != 1) break block9;
                        this.state = CharsetProber.ProbingState.NOT_ME;
                        break block8;
                    }
                    if (n5 != 2) break block10;
                    this.state = CharsetProber.ProbingState.FOUND_IT;
                }
                this.lastChar[0] = byArray[n3 + -1];
                if (this.state == CharsetProber.ProbingState.DETECTING && this.distributionAnalyzer.gotEnoughData() && this.getConfidence() > 0.95f) {
                    this.state = CharsetProber.ProbingState.FOUND_IT;
                }
                return this.state;
            }
            if (n5 == 0) {
                int n6 = this.codingSM.getCurrentCharLen();
                if (n4 == n) {
                    this.lastChar[1] = byArray[n];
                    this.distributionAnalyzer.handleOneChar(this.lastChar, 0, n6);
                } else {
                    this.distributionAnalyzer.handleOneChar(byArray, n4 + -1, n6);
                }
            }
            ++n4;
        }
    }

    @Override
    public void reset() {
        this.codingSM.reset();
        this.state = CharsetProber.ProbingState.DETECTING;
        this.distributionAnalyzer.reset();
        Arrays.fill(this.lastChar, (byte)0);
    }

    @Override
    public void setOption() {
    }
}

