/*
 * Decompiled with CFR 0.152.
 */
package it.evilsocket.dsploit.plugins;

import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.util.Log;
import android.view.View;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.ListView;
import android.widget.ProgressBar;
import android.widget.Toast;
import android.widget.ToggleButton;
import com.actionbarsherlock.view.Menu;
import com.actionbarsherlock.view.MenuItem;
import it.evilsocket.dsploit.core.Plugin;
import it.evilsocket.dsploit.core.System;
import it.evilsocket.dsploit.gui.dialogs.ConfirmDialog;
import it.evilsocket.dsploit.gui.dialogs.ErrorDialog;
import it.evilsocket.dsploit.gui.dialogs.InputDialog;
import it.evilsocket.dsploit.net.Network;
import it.evilsocket.dsploit.net.Target;
import it.evilsocket.dsploit.tools.NMap;
import java.util.ArrayList;
import java.util.Iterator;

public class PortScanner
extends Plugin {
    private String mCustomPorts;
    private ArrayAdapter<String> mListAdapter;
    private ArrayList<String> mPortList;
    private boolean mRunning;
    private ListView mScanList;
    private ProgressBar mScanProgress;
    private Receiver mScanReceiver;
    private ToggleButton mScanToggleButton;

    public PortScanner() {
        Target.Type[] typeArray = new Target.Type[]{Target.Type.ENDPOINT, Target.Type.REMOTE};
        super("Port Scanner", "Perform a SYN port scanning on target.", typeArray, 2130903079, 2130837609);
        this.mScanToggleButton = null;
        this.mScanList = null;
        this.mScanProgress = null;
        this.mRunning = false;
        this.mPortList = null;
        this.mListAdapter = null;
        this.mScanReceiver = null;
        this.mCustomPorts = null;
        this.mPortList = new ArrayList();
        this.mScanReceiver = new Receiver();
    }

    private void setStartedState() {
        this.mPortList.clear();
        System.getNMap().synScan(System.getCurrentTarget(), this.mScanReceiver, this.mCustomPorts).start();
        this.mRunning = true;
    }

    private void setStoppedState() {
        System.getNMap().kill();
        this.mScanProgress.setVisibility(4);
        this.mRunning = false;
        this.mScanToggleButton.setChecked(false);
        if (this.mPortList.size() == 0) {
            Toast.makeText((Context)this, (CharSequence)"No open ports found, check if the target is reachable.", (int)1).show();
        }
    }

    @Override
    public void onBackPressed() {
        this.setStoppedState();
        super.onBackPressed();
    }

    @Override
    public void onCreate(Bundle bundle) {
        super.onCreate(bundle);
        this.mScanToggleButton = (ToggleButton)this.findViewById(2131099766);
        this.mScanProgress = (ProgressBar)this.findViewById(2131099768);
        this.mScanToggleButton.setOnClickListener(new View.OnClickListener(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public void onClick(View view) {
                if (PortScanner.this.mRunning) {
                    PortScanner.this.setStoppedState();
                    return;
                }
                PortScanner.this.setStartedState();
            }
        });
        this.mScanList = (ListView)this.findViewById(2131099767);
        Iterator<Target.Port> iterator = System.getCurrentTarget().getOpenPorts().iterator();
        while (true) {
            if (!iterator.hasNext()) {
                this.mListAdapter = new ArrayAdapter((Context)this, 17367043, this.mPortList);
                this.mScanList.setAdapter(this.mListAdapter);
                this.mScanList.setOnItemLongClickListener(new AdapterView.OnItemLongClickListener(){

                    /*
                     * Enabled aggressive block sorting
                     */
                    public boolean onItemLongClick(AdapterView<?> adapterView, View view, int n, long l) {
                        int n2 = System.getCurrentTarget().getOpenPorts().get((int)n).number;
                        String string2 = n2 == 80 ? "http://" + System.getCurrentTarget().getCommandLineRepresentation() + "/" : (n2 == 443 ? "https://" + System.getCurrentTarget().getCommandLineRepresentation() + "/" : (n2 == 21 ? "ftp://" + System.getCurrentTarget().getCommandLineRepresentation() : (n2 == 22 ? "ssh://" + System.getCurrentTarget().getCommandLineRepresentation() : "telnet://" + System.getCurrentTarget().getCommandLineRepresentation() + ":" + n2)));
                        final String string3 = string2;
                        new ConfirmDialog("Open", "Open " + string2 + " ?", PortScanner.this, new ConfirmDialog.ConfirmDialogListener(){

                            @Override
                            public void onCancel() {
                            }

                            /*
                             * Enabled force condition propagation
                             * Lifted jumps to return sites
                             */
                            @Override
                            public void onConfirm() {
                                try {
                                    Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)string3));
                                    PortScanner.this.startActivity(intent);
                                    return;
                                }
                                catch (ActivityNotFoundException activityNotFoundException) {
                                    System.errorLogging("PORTSCANNER", (Exception)((Object)activityNotFoundException));
                                    new ErrorDialog("Error", "No activities to handle this type of url.", PortScanner.this).show();
                                    return;
                                }
                            }
                        }).show();
                        return false;
                    }
                });
                return;
            }
            Target.Port port = iterator.next();
            this.mPortList.add(String.valueOf(port.number) + " ( " + port.protocol.toString().toLowerCase() + " )");
        }
    }

    @Override
    public boolean onCreateOptionsMenu(Menu menu2) {
        this.getSupportMenuInflater().inflate(2131558404, menu2);
        return super.onCreateOptionsMenu(menu2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean onOptionsItemSelected(MenuItem menuItem) {
        switch (menuItem.getItemId()) {
            default: {
                return super.onOptionsItemSelected(menuItem);
            }
            case 2131099797: 
        }
        new InputDialog("Select Ports", "Enter a comma separated list of ports:", this, new InputDialog.InputDialogListener(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void onInputEntered(String string2) {
                String string3 = string2.trim();
                if (string3.isEmpty()) {
                    new ErrorDialog("Error", "Empty port list.", PortScanner.this).show();
                    return;
                }
                String[] stringArray = string3.split("[^\\d]+");
                int n = stringArray.length;
                int n2 = 0;
                while (true) {
                    if (n2 >= n) break;
                    String string4 = stringArray[n2];
                    try {
                        if (string4.isEmpty()) {
                            throw new Exception("Invalid port '" + string4 + "'.");
                        }
                        int n3 = Integer.parseInt(string4);
                        if (n3 <= 0) throw new Exception("Port must be greater than 0 and smaller than 65535.");
                        if (n3 > 65535) {
                            throw new Exception("Port must be greater than 0 and smaller than 65535.");
                        }
                    }
                    catch (Exception exception) {
                        new ErrorDialog("Error", exception.toString(), PortScanner.this).show();
                        return;
                    }
                    ++n2;
                }
                PortScanner.this.mCustomPorts = "";
                int n4 = 0;
                int n5 = -1 + stringArray.length;
                while (true) {
                    if (n4 >= stringArray.length) {
                        if (PortScanner.this.mCustomPorts.isEmpty()) {
                            PortScanner.this.mCustomPorts = null;
                            new ErrorDialog("Error", "Invalid ports specified.", PortScanner.this).show();
                        }
                        Log.d((String)"PORT", (String)("mCustomPorts = " + PortScanner.this.mCustomPorts));
                        return;
                    }
                    PortScanner portScanner = PortScanner.this;
                    portScanner.mCustomPorts = String.valueOf(portScanner.mCustomPorts) + stringArray[n4];
                    if (n4 != n5) {
                        PortScanner portScanner2 = PortScanner.this;
                        portScanner2.mCustomPorts = String.valueOf(portScanner2.mCustomPorts) + ",";
                    }
                    ++n4;
                }
            }
        }).show();
        return true;
    }

    private class Receiver
    extends NMap.SynScanOutputReceiver {
        private Receiver() {
        }

        @Override
        public void onEnd(int n) {
            super.onEnd(n);
            PortScanner.this.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    PortScanner.this.setStoppedState();
                }
            });
        }

        @Override
        public void onPortFound(final String string2, final String string3) {
            PortScanner.this.runOnUiThread(new Runnable(){

                /*
                 * Enabled aggressive block sorting
                 */
                @Override
                public void run() {
                    String string22 = System.getProtocolByPort(string2);
                    String string32 = string22 != null ? String.valueOf(string2) + " ( " + string22 + " )" : String.valueOf(string3) + " : " + string2;
                    PortScanner.this.mPortList.add(string32);
                    PortScanner.this.mListAdapter.notifyDataSetChanged();
                    System.addOpenPort(Integer.parseInt(string2), Network.Protocol.fromString(string3));
                }
            });
        }

        @Override
        public void onStart(String string2) {
            super.onStart(string2);
            PortScanner.this.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    PortScanner.this.mRunning = true;
                    PortScanner.this.mScanProgress.setVisibility(0);
                }
            });
        }
    }
}

