/*
 * Decompiled with CFR 0.152.
 */
package it.evilsocket.dsploit.net.http.proxy;

import android.util.Log;
import it.evilsocket.dsploit.core.Profiler;
import it.evilsocket.dsploit.core.System;
import it.evilsocket.dsploit.net.http.proxy.ProxyThread;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.UnknownHostException;
import java.util.ArrayList;

public class Proxy
implements Runnable {
    private static final int BACKLOG = 255;
    private static final String TAG = "HTTP.PROXY";
    private InetAddress mAddress = null;
    private ArrayList<ProxyFilter> mFilters = null;
    private String mHostRedirect = null;
    private int mPort = System.HTTP_PROXY_PORT;
    private int mPortRedirect = 80;
    private OnRequestListener mRequestListener = null;
    private boolean mRunning = false;
    private ServerSocket mSocket = null;

    public Proxy(String string2, int n) throws UnknownHostException, IOException {
        this(InetAddress.getByName(string2), n);
    }

    public Proxy(InetAddress inetAddress, int n) throws UnknownHostException, IOException {
        this.mAddress = inetAddress;
        this.mPort = n;
        this.mSocket = new ServerSocket(this.mPort, 255, this.mAddress);
        this.mFilters = new ArrayList();
    }

    public void addFilter(ProxyFilter proxyFilter) {
        this.mFilters.add(proxyFilter);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void run() {
        try {
            if (this.mSocket == null) {
                this.mSocket = new ServerSocket(this.mPort, 255, this.mAddress);
            }
            Log.d((String)TAG, (String)("Proxy started on " + this.mAddress + ":" + this.mPort));
            this.mRunning = true;
            while (true) {
                if (!this.mRunning || this.mSocket == null) {
                    Log.d((String)TAG, (String)"Proxy stopped.");
                    return;
                }
                try {
                    Profiler.instance().profile("client spawn");
                    new ProxyThread(this.mSocket.accept(), this.mRequestListener, this.mFilters, this.mHostRedirect, this.mPortRedirect).start();
                    Profiler.instance().profile("client spawn");
                }
                catch (Exception exception) {}
            }
        }
        catch (IOException iOException) {
            System.errorLogging(TAG, iOException);
            return;
        }
    }

    public void setFilter(ProxyFilter proxyFilter) {
        this.mFilters.clear();
        if (proxyFilter != null) {
            this.mFilters.add(proxyFilter);
        }
    }

    public void setOnRequestListener(OnRequestListener onRequestListener) {
        this.mRequestListener = onRequestListener;
    }

    public void setRedirection(String string2, int n) {
        this.mHostRedirect = string2;
        this.mPortRedirect = n;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void stop() {
        Log.d((String)TAG, (String)"Stopping proxy ...");
        try {
            if (this.mSocket != null) {
                this.mSocket.close();
            }
        }
        catch (IOException iOException) {}
        this.mRunning = false;
        this.mSocket = null;
    }

    public static interface OnRequestListener {
        public void onRequest(boolean var1, String var2, String var3, ArrayList<String> var4);
    }

    public static interface ProxyFilter {
        public String onDataReceived(String var1, String var2);
    }
}

