/*
 * Decompiled with CFR 0.152.
 */
package it.evilsocket.dsploit.net.http.proxy;

import android.content.Context;
import android.util.Log;
import it.evilsocket.dsploit.core.System;
import it.evilsocket.dsploit.net.http.RequestParser;
import it.evilsocket.dsploit.net.http.proxy.CookieCleaner;
import it.evilsocket.dsploit.net.http.proxy.HTTPSMonitor;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLSocket;

public class HTTPSRedirector
implements Runnable {
    private static final int BACKLOG = 255;
    private static final String KEYSTORE_FILE = "dsploit.keystore";
    private static final String KEYSTORE_PASS = "dsploit";
    private static final String TAG = "HTTPS.REDIRECTOR";
    private InetAddress mAddress = null;
    private Context mContext = null;
    private int mPort = System.HTTPS_REDIR_PORT;
    private boolean mRunning = false;
    private SSLServerSocket mSocket = null;

    public HTTPSRedirector(Context context, InetAddress inetAddress, int n) throws UnknownHostException, IOException, KeyStoreException, CertificateException, NoSuchAlgorithmException, UnrecoverableKeyException, KeyManagementException {
        this.mContext = context;
        this.mAddress = inetAddress;
        this.mPort = n;
        this.mSocket = this.getSSLSocket();
    }

    private SSLServerSocket getSSLSocket() throws IOException, KeyStoreException, CertificateException, NoSuchAlgorithmException, UnrecoverableKeyException, KeyManagementException {
        KeyStore keyStore = KeyStore.getInstance("PKCS12");
        keyStore.load(this.mContext.getAssets().open(KEYSTORE_FILE), KEYSTORE_PASS.toCharArray());
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        keyManagerFactory.init(keyStore, KEYSTORE_PASS.toCharArray());
        SSLContext sSLContext = SSLContext.getInstance("TLS");
        sSLContext.init(keyManagerFactory.getKeyManagers(), null, null);
        return (SSLServerSocket)sSLContext.getServerSocketFactory().createServerSocket(this.mPort, 255, this.mAddress);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        try {
            Log.d((String)TAG, (String)("HTTPS redirector started on " + this.mAddress + ":" + this.mPort));
            if (this.mSocket == null) {
                this.mSocket = this.getSSLSocket();
            }
            this.mRunning = true;
        }
        catch (Exception exception) {
            System.errorLogging(TAG, exception);
            return;
        }
        while (true) {
            if (!this.mRunning || this.mSocket == null) {
                Log.d((String)TAG, (String)"HTTPS redirector stopped.");
                return;
            }
            try {
                new Thread(new Runnable((SSLSocket)this.mSocket.accept()){
                    private final /* synthetic */ SSLSocket val$client;
                    {
                        this.val$client = sSLSocket;
                    }

                    /*
                     * Handled impossible loop by adding 'first' condition
                     * Enabled aggressive block sorting
                     * Enabled unnecessary exception pruning
                     * Enabled aggressive exception aggregation
                     */
                    @Override
                    public void run() {
                        try {
                            String string2 = this.val$client.getInetAddress().getHostAddress();
                            Log.d((String)HTTPSRedirector.TAG, (String)("Incoming connection from " + string2));
                            InputStream inputStream = this.val$client.getInputStream();
                            byte[] byArray = new byte[8192];
                            String string3 = null;
                            int n = inputStream.read(byArray, 0, 8192);
                            boolean bl = true;
                            while (true) {
                                String string4;
                                boolean bl2;
                                ArrayList<String> arrayList;
                                StringBuilder stringBuilder;
                                block16: {
                                    block15: {
                                        BufferedReader bufferedReader;
                                        block14: {
                                            if (!bl || (bl = false)) break block14;
                                            if (n <= 0) break block15;
                                            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray, 0, n);
                                            InputStreamReader inputStreamReader = new InputStreamReader(byteArrayInputStream);
                                            bufferedReader = new BufferedReader(inputStreamReader);
                                            stringBuilder = new StringBuilder();
                                            arrayList = new ArrayList<String>();
                                            bl2 = false;
                                        }
                                        if ((string4 = bufferedReader.readLine()) != null) break block16;
                                        if (string3 != null) {
                                            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(this.val$client.getOutputStream());
                                            String string5 = stringBuilder.toString();
                                            String string6 = RequestParser.getUrlFromRequest(string3, string5);
                                            String string7 = "HTTP/1.1 302 Found\nLocation: " + string6 + "\n" + "Connection: close\n\n";
                                            CookieCleaner.getInstance().addCleaned(string2, string3);
                                            HTTPSMonitor.getInstance().addURL(string2, string6);
                                            Log.w((String)HTTPSRedirector.TAG, (String)("Redirecting " + string2 + " to " + string6));
                                            bufferedOutputStream.write(string7.getBytes());
                                            bufferedOutputStream.flush();
                                            bufferedOutputStream.close();
                                        }
                                    }
                                    inputStream.close();
                                    return;
                                }
                                if (!bl2) {
                                    arrayList.add(string4);
                                    if (string4.trim().isEmpty()) {
                                        bl2 = true;
                                    } else if (string4.indexOf(58) != -1) {
                                        String[] stringArray = string4.split(":", 2);
                                        String string8 = stringArray[0].trim();
                                        String string9 = stringArray[1].trim();
                                        if (string8.equals("Host")) {
                                            string3 = string9;
                                        }
                                        if (string8 != null) {
                                            String string10;
                                            string4 = string10 = String.valueOf(string8) + ": " + string9;
                                        }
                                    }
                                }
                                stringBuilder.append(String.valueOf(string4) + "\n");
                            }
                        }
                        catch (IOException iOException) {
                            System.errorLogging(HTTPSRedirector.TAG, iOException);
                            return;
                        }
                    }
                }).start();
            }
            catch (Exception exception) {
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void stop() {
        Log.d((String)TAG, (String)"Stopping HTTPS redirector ...");
        try {
            if (this.mSocket != null) {
                this.mSocket.close();
            }
        }
        catch (IOException iOException) {}
        this.mRunning = false;
        this.mSocket = null;
    }
}

