/*
 * Decompiled with CFR 0.152.
 */
package it.evilsocket.dsploit.net;

import android.os.StrictMode;
import android.util.Log;
import it.evilsocket.dsploit.net.Endpoint;
import it.evilsocket.dsploit.net.Network;
import java.io.BufferedReader;
import java.net.InetAddress;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;

public class Target {
    private static final String TAG = "TARGET";
    private InetAddress mAddress;
    private String mAlias;
    private String mDeviceOS;
    private String mDeviceType;
    private Endpoint mEndpoint;
    private String mHostname;
    private Network mNetwork;
    private int mPort;
    private List<Port> mPorts;
    private Type mType;
    private HashMap<String, ArrayList<Vulnerability>> mVulnerabilities;

    public Target(Endpoint endpoint) {
        this.mNetwork = null;
        this.mEndpoint = null;
        this.mPort = 0;
        this.mHostname = null;
        this.mType = null;
        this.mAddress = null;
        this.mPorts = new ArrayList<Port>();
        this.mDeviceType = null;
        this.mDeviceOS = null;
        this.mAlias = null;
        this.mVulnerabilities = new HashMap();
        this.setEndpoint(endpoint);
    }

    public Target(Network network) {
        this.mNetwork = null;
        this.mEndpoint = null;
        this.mPort = 0;
        this.mHostname = null;
        this.mType = null;
        this.mAddress = null;
        this.mPorts = new ArrayList<Port>();
        this.mDeviceType = null;
        this.mDeviceOS = null;
        this.mAlias = null;
        this.mVulnerabilities = new HashMap();
        this.setNetwork(network);
    }

    /*
     * Enabled aggressive block sorting
     * Lifted jumps to return sites
     */
    public Target(BufferedReader bufferedReader) throws Exception {
        String string2 = null;
        this.mNetwork = string2;
        this.mEndpoint = string2;
        this.mPort = 0;
        this.mHostname = string2;
        this.mType = string2;
        this.mAddress = string2;
        this.mPorts = new ArrayList<Port>();
        this.mDeviceType = string2;
        this.mDeviceOS = string2;
        this.mAlias = string2;
        this.mVulnerabilities = new HashMap();
        this.mType = Type.fromString(bufferedReader.readLine());
        this.mDeviceType = bufferedReader.readLine();
        String string3 = this.mDeviceType.equals("null") ? string2 : this.mDeviceType;
        this.mDeviceType = string3;
        this.mDeviceOS = bufferedReader.readLine();
        String string4 = this.mDeviceOS.equals("null") ? string2 : this.mDeviceOS;
        this.mDeviceOS = string4;
        this.mAlias = bufferedReader.readLine();
        String string5 = this.mAlias.equals("null") ? string2 : this.mAlias;
        this.mAlias = string5;
        if (this.mType == Type.NETWORK) {
            return;
        }
        if (this.mType == Type.ENDPOINT) {
            this.mEndpoint = new Endpoint(bufferedReader);
        } else if (this.mType == Type.REMOTE) {
            this.mHostname = bufferedReader.readLine();
            if (!this.mHostname.equals("null")) {
                string2 = this.mHostname;
            }
            this.mHostname = string2;
            if (this.mHostname != null) {
                StrictMode.setThreadPolicy((StrictMode.ThreadPolicy)new StrictMode.ThreadPolicy.Builder().permitAll().build());
                this.mAddress = InetAddress.getByName(this.mHostname);
            }
        }
        int n = Integer.parseInt(bufferedReader.readLine());
        int n2 = 0;
        block0: while (n2 < n) {
            String string6 = bufferedReader.readLine();
            String[] stringArray = string6.split("\\|", 3);
            Port port = new Port(Integer.parseInt(stringArray[1]), Network.Protocol.fromString(stringArray[0]), stringArray[2]);
            this.mPorts.add(port);
            this.mVulnerabilities.put(string6, new ArrayList());
            int n3 = Integer.parseInt(bufferedReader.readLine());
            int n4 = 0;
            while (true) {
                if (n4 >= n3) {
                    ++n2;
                    continue block0;
                }
                Vulnerability vulnerability = new Vulnerability(bufferedReader);
                this.mVulnerabilities.get(string6).add(vulnerability);
                ++n4;
            }
            break;
        }
        return;
    }

    public Target(String string2, int n) {
        this.mNetwork = null;
        this.mEndpoint = null;
        this.mPort = 0;
        this.mHostname = null;
        this.mType = null;
        this.mAddress = null;
        this.mPorts = new ArrayList<Port>();
        this.mDeviceType = null;
        this.mDeviceOS = null;
        this.mAlias = null;
        this.mVulnerabilities = new HashMap();
        this.setHostname(string2, n);
    }

    public Target(InetAddress inetAddress, byte[] byArray) {
        this.mNetwork = null;
        this.mEndpoint = null;
        this.mPort = 0;
        this.mHostname = null;
        this.mType = null;
        this.mAddress = null;
        this.mPorts = new ArrayList<Port>();
        this.mDeviceType = null;
        this.mDeviceOS = null;
        this.mAlias = null;
        this.mVulnerabilities = new HashMap();
        this.setEndpoint(inetAddress, byArray);
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Target getFromString(String var0) {
        block7: {
            var1_1 = Pattern.compile("^(([a-z]+)://)?([0-9a-z\\-\\.]+)(:([\\d]+))?[0-9a-z\\-\\./]*$", 2);
            var2_2 = Pattern.compile("^[\\d]{1,3}\\.[\\d]{1,3}\\.[\\d]{1,3}\\.[\\d]{1,3}$");
            var3_3 = null;
            try {
                block10: {
                    var7_4 = var1_1.matcher(var0.trim());
                    if (var7_4 == null || !var7_4.find()) break block7;
                    var8_5 = var7_4.group(2);
                    var9_6 = var7_4.group(3);
                    var10_7 = var7_4.group(4);
                    var11_8 = var8_5 != null ? var8_5.toLowerCase() : null;
                    var12_9 = var10_7 != null ? var10_7.substring(1) : null;
                    if (var9_6 == null) break block7;
                    var13_10 = 0;
                    if (var12_9 == null) break block10;
                    var13_10 = Integer.parseInt(var12_9);
                    ** GOTO lbl21
                }
                if (var11_8 == null) ** GOTO lbl21
                var13_10 = it.evilsocket.dsploit.core.System.getPortByProtocol(var11_8);
lbl21:
                // 3 sources

                if (!var2_2.matcher(var9_6).find()) break block8;
                if (!it.evilsocket.dsploit.core.System.getNetwork().isInternal(var9_6)) break block9;
                var15_11 = new Target(new Endpoint(var9_6, null));
            }
            catch (Exception var4_13) {}
            {
                block8: {
                    block9: {
                        var15_11.setPort(var13_10);
                        var3_3 = var15_11;
                        break block7;
                    }
                    var3_3 = new Target(var9_6, var13_10);
                    break block7;
                }
                var3_3 = var14_12 = new Target(var9_6, var13_10);
            }
            ** GOTO lbl-1000
            catch (Exception var4_15) {
                var3_3 = var15_11;
            }
lbl-1000:
            // 2 sources

            {
                it.evilsocket.dsploit.core.System.errorLogging("TARGET", (Exception)var4_14);
            }
        }
        if (var3_3 == null) return var3_3;
        try {
            StrictMode.setThreadPolicy((StrictMode.ThreadPolicy)new StrictMode.ThreadPolicy.Builder().permitAll().build());
            InetAddress.getByName(var3_3.getCommandLineRepresentation());
            return var3_3;
        }
        catch (Exception var5_16) {
            return null;
        }
    }

    public void addOpenPort(int n, Network.Protocol protocol) {
        this.addOpenPort(new Port(n, protocol));
    }

    public void addOpenPort(int n, Network.Protocol protocol, String string2) {
        this.addOpenPort(new Port(n, protocol, string2));
    }

    /*
     * Enabled aggressive block sorting
     */
    public void addOpenPort(Port port) {
        int n = 0;
        while (true) {
            if (n >= this.mPorts.size()) {
                this.mPorts.add(port);
                return;
            }
            if (this.mPorts.get((int)n).number == port.number) {
                if (port.service == null) return;
                this.mPorts.get((int)n).service = port.service;
                return;
            }
            ++n;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void addVulnerability(Port port, Vulnerability vulnerability) {
        if (!this.mVulnerabilities.containsKey(port.toString())) {
            this.mVulnerabilities.put(port.toString(), new ArrayList());
        } else {
            Iterator<Vulnerability> iterator = this.mVulnerabilities.get(port.toString()).iterator();
            while (iterator.hasNext()) {
                if (!iterator.next().getIdentifier().equals(vulnerability.getIdentifier())) continue;
                return;
            }
        }
        this.mVulnerabilities.get(port.toString()).add(vulnerability);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean comesAfter(Target target) {
        boolean bl = false;
        if (this.mType == Type.NETWORK) {
            return bl;
        }
        if (this.mType != Type.ENDPOINT) return true;
        if (target.getType() != Type.ENDPOINT) return bl;
        if (this.mEndpoint.getAddressAsLong() <= target.getEndpoint().getAddressAsLong()) return bl;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Target target) {
        if (this.mType != target.getType()) return false;
        if (this.mType == Type.NETWORK) {
            return this.mNetwork.equals(target.getNetwork());
        }
        if (this.mType == Type.ENDPOINT) {
            return this.mEndpoint.equals(target.getEndpoint());
        }
        if (this.mType != Type.REMOTE) return false;
        return this.mHostname.equals(target.getHostname());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object object) {
        if (!(object instanceof Target)) return false;
        return this.equals((Target)object);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public InetAddress getAddress() {
        if (this.mType == Type.ENDPOINT) {
            return this.mEndpoint.getAddress();
        }
        if (this.mType != Type.REMOTE) return null;
        return this.mAddress;
    }

    public String getAlias() {
        return this.mAlias;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getCommandLineRepresentation() {
        if (this.mType == Type.NETWORK) {
            return this.mNetwork.getNetworkRepresentation();
        }
        if (this.mType == Type.ENDPOINT) {
            return this.mEndpoint.getAddress().getHostAddress();
        }
        if (this.mType != Type.REMOTE) return "???";
        return this.mHostname;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getDescription() {
        if (this.mType == Type.NETWORK) {
            return "This is your network subnet mask";
        }
        if (this.mType == Type.ENDPOINT) {
            String string2;
            block7: {
                String string3;
                String string4 = it.evilsocket.dsploit.core.System.getMacVendor(this.mEndpoint.getHardware());
                string2 = this.mEndpoint.getHardwareAsString();
                if (string4 != null) {
                    string2 = String.valueOf(string2) + " - " + string4;
                }
                if (!this.mEndpoint.getAddress().equals(it.evilsocket.dsploit.core.System.getNetwork().getGatewayAddress())) break block7;
                string2 = string3 = String.valueOf(string2) + " ( Your network gateway / router )";
                return string2.trim();
            }
            try {
                String string5;
                if (!this.mEndpoint.getAddress().equals(it.evilsocket.dsploit.core.System.getNetwork().getLocalAddress())) return string2.trim();
                string2 = string5 = String.valueOf(string2) + " ( This device )";
                return string2.trim();
            }
            catch (SocketException socketException) {
                it.evilsocket.dsploit.core.System.errorLogging(TAG, socketException);
            }
            return string2.trim();
        }
        if (this.mType != Type.REMOTE) return "";
        return this.mAddress.getHostAddress();
    }

    public String getDeviceOS() {
        return this.mDeviceOS;
    }

    public String getDeviceType() {
        return this.mDeviceType;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getDisplayAddress() {
        String string2;
        if (this.mType == Type.NETWORK) {
            return this.mNetwork.getNetworkRepresentation();
        }
        if (this.mType == Type.ENDPOINT) {
            String string3;
            StringBuilder stringBuilder = new StringBuilder(String.valueOf(this.mEndpoint.getAddress().getHostAddress()));
            if (this.mPort == 0) {
                string3 = "";
                return stringBuilder.append(string3).toString();
            }
            string3 = ":" + this.mPort;
            return stringBuilder.append(string3).toString();
        }
        if (this.mType != Type.REMOTE) return "???";
        StringBuilder stringBuilder = new StringBuilder(String.valueOf(this.mHostname));
        if (this.mPort == 0) {
            string2 = "";
            return stringBuilder.append(string2).toString();
        }
        string2 = ":" + this.mPort;
        return stringBuilder.append(string2).toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getDrawableResourceId() {
        int n = 2130837640;
        try {
            if (this.mType == Type.NETWORK) return n;
            if (this.mType == Type.ENDPOINT) {
                if (this.isRouter()) {
                    return 2130837642;
                }
                if (!this.mEndpoint.getAddress().equals(it.evilsocket.dsploit.core.System.getNetwork().getLocalAddress())) return 2130837639;
                return 2130837643;
            }
            Type type = this.mType;
            Type type2 = Type.REMOTE;
            if (type != type2) return n;
            return 2130837641;
        }
        catch (Exception exception) {
            it.evilsocket.dsploit.core.System.errorLogging(TAG, exception);
        }
        return n;
    }

    public Endpoint getEndpoint() {
        return this.mEndpoint;
    }

    public String getHostname() {
        return this.mHostname;
    }

    public Network getNetwork() {
        return this.mNetwork;
    }

    public List<Port> getOpenPorts() {
        return this.mPorts;
    }

    public int getPort() {
        return this.mPort;
    }

    public Type getType() {
        return this.mType;
    }

    public HashMap<String, ArrayList<Vulnerability>> getVulnerabilities() {
        return this.mVulnerabilities;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean hasAlias() {
        if (this.mAlias == null) return false;
        if (this.mAlias.isEmpty()) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean hasOpenPort(int n) {
        Iterator<Port> iterator = this.mPorts.iterator();
        do {
            if (iterator.hasNext()) continue;
            return false;
        } while (iterator.next().number != n);
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean hasOpenPorts() {
        if (!this.mPorts.isEmpty()) return true;
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean hasOpenPortsWithService() {
        Port port;
        if (this.mPorts.isEmpty()) return false;
        Iterator<Port> iterator = this.mPorts.iterator();
        do {
            if (!iterator.hasNext()) {
                return false;
            }
            port = iterator.next();
        } while (port.service == null || port.service.isEmpty());
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isRouter() {
        boolean bl = false;
        try {
            if (this.mType != Type.ENDPOINT) return bl;
            boolean bl2 = this.mEndpoint.getAddress().equals(it.evilsocket.dsploit.core.System.getNetwork().getGatewayAddress());
            if (!bl2) return bl;
            return true;
        }
        catch (Exception exception) {
            it.evilsocket.dsploit.core.System.errorLogging(TAG, exception);
            return bl;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void serialize(StringBuilder stringBuilder) {
        stringBuilder.append((Object)((Object)this.mType) + "\n");
        stringBuilder.append(String.valueOf(this.mDeviceType) + "\n");
        stringBuilder.append(String.valueOf(this.mDeviceOS) + "\n");
        stringBuilder.append(String.valueOf(this.mAlias) + "\n");
        if (this.mType != Type.NETWORK) {
            if (this.mType == Type.ENDPOINT) {
                this.mEndpoint.serialize(stringBuilder);
            } else if (this.mType == Type.REMOTE) {
                stringBuilder.append(String.valueOf(this.mHostname) + "\n");
            }
            stringBuilder.append(String.valueOf(this.mPorts.size()) + "\n");
            Iterator<Port> iterator = this.mPorts.iterator();
            while (iterator.hasNext()) {
                String string2 = iterator.next().toString();
                stringBuilder.append(String.valueOf(string2) + "\n");
                if (this.mVulnerabilities.containsKey(string2)) {
                    stringBuilder.append(String.valueOf(this.mVulnerabilities.get(string2).size()) + "\n");
                    Iterator<Vulnerability> iterator2 = this.mVulnerabilities.get(string2).iterator();
                    while (iterator2.hasNext()) {
                        stringBuilder.append(String.valueOf(iterator2.next().toString()) + "\n");
                    }
                    continue;
                }
                stringBuilder.append("0\n");
            }
        }
    }

    public void setAlias(String string2) {
        this.mAlias = string2.trim();
    }

    public void setDeviceOS(String string2) {
        this.mDeviceOS = string2;
    }

    public void setDeviceType(String string2) {
        this.mDeviceType = string2;
    }

    public void setEndpoint(Endpoint endpoint) {
        this.mEndpoint = endpoint;
        this.mType = Type.ENDPOINT;
    }

    public void setEndpoint(InetAddress inetAddress, byte[] byArray) {
        this.mEndpoint = new Endpoint(inetAddress, byArray);
        this.mType = Type.ENDPOINT;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setHostname(String string2, int n) {
        this.mHostname = string2;
        this.mPort = n;
        this.mType = Type.REMOTE;
        try {
            StrictMode.setThreadPolicy((StrictMode.ThreadPolicy)new StrictMode.ThreadPolicy.Builder().permitAll().build());
            this.mAddress = InetAddress.getByName(this.mHostname);
            return;
        }
        catch (Exception exception) {
            Log.d((String)"Target.setHostname()", (String)exception.toString());
            return;
        }
    }

    public void setNetwork(Network network) {
        this.mNetwork = network;
        this.mType = Type.NETWORK;
    }

    public void setPort(int n) {
        this.mPort = n;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String toString() {
        if (!this.hasAlias()) return this.getDisplayAddress();
        return this.mAlias;
    }

    public static class Port {
        public int number;
        public Network.Protocol protocol;
        public String service;

        public Port(int n, Network.Protocol protocol) {
            this(n, protocol, null);
        }

        /*
         * Enabled aggressive block sorting
         */
        public Port(int n, Network.Protocol protocol, String string2) {
            this.number = n;
            this.protocol = protocol;
            if (string2 != null) {
                if (string2.equals("null")) {
                    string2 = null;
                }
            } else {
                string2 = null;
            }
            this.service = string2;
        }

        public String getServiceQuery() {
            String string2 = "";
            if (this.service != null) {
                string2 = this.service.replaceAll("[\\d\\.]+", " ").replaceAll("[^a-zA-Z0-9\\-_]", " ").replaceAll("[\\s]{2,}", " ").trim();
            }
            return string2;
        }

        public String toString() {
            return String.valueOf(this.protocol.toString()) + "|" + this.number + "|" + this.service;
        }
    }

    public static final class Type
    extends Enum<Type> {
        public static final /* enum */ Type ENDPOINT;
        private static final /* synthetic */ Type[] ENUM$VALUES;
        public static final /* enum */ Type NETWORK;
        public static final /* enum */ Type REMOTE;

        static {
            NETWORK = new Type();
            ENDPOINT = new Type();
            REMOTE = new Type();
            Type[] typeArray = new Type[]{NETWORK, ENDPOINT, REMOTE};
            ENUM$VALUES = typeArray;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public static Type fromString(String string2) throws Exception {
            if (string2 == null) throw new Exception("Could not deserialize target type from string.");
            String string3 = string2.trim().toLowerCase();
            if (string3.equals("network")) {
                return NETWORK;
            }
            if (string3.equals("endpoint")) {
                return ENDPOINT;
            }
            if (!string3.equals("remote")) throw new Exception("Could not deserialize target type from string.");
            return REMOTE;
        }

        public static Type valueOf(String string2) {
            return Enum.valueOf(Type.class, string2);
        }

        public static Type[] values() {
            Type[] typeArray = ENUM$VALUES;
            int n = typeArray.length;
            Type[] typeArray2 = new Type[n];
            System.arraycopy(typeArray, 0, typeArray2, 0, n);
            return typeArray2;
        }
    }

    public static class Vulnerability {
        private String mIdentifier = null;
        private double mSeverity = 0.0;
        private String mSummary = null;

        public Vulnerability() {
        }

        public Vulnerability(BufferedReader bufferedReader) throws Exception {
            String[] stringArray = bufferedReader.readLine().split("\\|", 3);
            this.mIdentifier = stringArray[0];
            this.mSeverity = Double.parseDouble(stringArray[1]);
            this.mSummary = stringArray[2];
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public String getHtmlColor() {
            if (this.mSeverity < 5.0) {
                return "#59FF00";
            }
            if (!(this.mSeverity < 7.0)) return "#FF0000";
            return "#FFD732";
        }

        public String getIdentifier() {
            return this.mIdentifier;
        }

        public double getSeverity() {
            return this.mSeverity;
        }

        public String getSummary() {
            return this.mSummary;
        }

        public void setIdentifier(String string2) {
            this.mIdentifier = string2;
        }

        public void setSeverity(double d) {
            this.mSeverity = d;
        }

        public void setSummary(String string2) {
            this.mSummary = string2;
        }

        public String toString() {
            return String.valueOf(this.mIdentifier) + "|" + this.mSeverity + "|" + this.mSummary;
        }
    }
}

