/*
 * Decompiled with CFR 0.152.
 */
package it.evilsocket.dsploit.core;

import android.util.Log;
import it.evilsocket.dsploit.core.System;

public class Profiler {
    private static volatile Profiler mInstance = null;
    private volatile boolean mEnabled = System.getSettings().getBoolean("PREF_ENABLE_PROFILER", false);
    private volatile String mProfiling = null;
    private volatile long mTick = 0L;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String format(long l) {
        if (l < 1000L) {
            return String.valueOf(l) + " ms";
        }
        if (l >= 60000L) return String.valueOf((double)l / 60000.0) + " m";
        return String.valueOf((double)l / 1000.0) + " s";
    }

    public static Profiler instance() {
        if (mInstance == null) {
            mInstance = new Profiler();
        }
        return mInstance;
    }

    public void emit() {
        if (this.mEnabled && this.mTick > 0L && this.mProfiling != null) {
            long l = java.lang.System.currentTimeMillis() - this.mTick;
            Log.d((String)"PROFILER", (String)("[" + this.mProfiling + "] " + this.format(l)));
            this.mProfiling = null;
            this.mTick = 0L;
        }
    }

    public void profile(String string2) {
        this.emit();
        if (this.mEnabled) {
            this.mTick = java.lang.System.currentTimeMillis();
            this.mProfiling = string2;
        }
    }
}

