/*
 * Decompiled with CFR 0.152.
 */
package com.bugsense.trace.models;

import android.content.Context;
import android.os.AsyncTask;
import android.util.Log;
import com.bugsense.trace.BugSenseHandler;
import com.bugsense.trace.G;
import com.bugsense.trace.models.Event;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;

public final class EventsMechanism {
    private static final int MAX_LIST_SIZE = 12;
    private static final String fileName = "bevents";
    private static volatile EventsMechanism instance;
    private Context ctx;

    public static EventsMechanism getInstance(Context context) {
        if (instance == null) {
            instance = new EventsMechanism();
        }
        EventsMechanism.instance.ctx = context;
        return instance;
    }

    public void clearList() {
        if (BugSenseHandler.I_WANT_TO_DEBUG) {
            Log.d((String)G.TAG, (String)"clearing events list");
        }
        this.saveList(new ArrayList<Event>(0));
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ArrayList<Event> getList() {
        synchronized (this) {
            ArrayList<Event> arrayList;
            block8: {
                ObjectInputStream objectInputStream = new ObjectInputStream(this.ctx.openFileInput(fileName));
                arrayList = (ArrayList<Event>)objectInputStream.readObject();
                objectInputStream.close();
                break block8;
                {
                    catch (Exception exception) {}
                }
                catch (Exception exception) {
                    arrayList = null;
                    if (!BugSenseHandler.I_WANT_TO_DEBUG) break block8;
                    Log.d((String)G.TAG, (String)"Could not load events list or doesn't exist");
                }
            }
            if (arrayList == null) {
                arrayList = new ArrayList<Event>();
            }
            if (BugSenseHandler.I_WANT_TO_DEBUG) {
                Log.d((String)G.TAG, (String)("Events List has: " + arrayList.size() + " items"));
            }
            return arrayList;
        }
    }

    public void saveEvent(Event event) {
        synchronized (this) {
            ArrayList<Event> arrayList = this.getList();
            arrayList.add(event);
            this.saveList(arrayList);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void saveList(ArrayList<Event> arrayList) {
        synchronized (this) {
            block5: {
                if (arrayList.size() > 12) {
                    arrayList.remove(0);
                }
                try {
                    ObjectOutputStream objectOutputStream = new ObjectOutputStream(this.ctx.openFileOutput(fileName, 0));
                    objectOutputStream.writeObject(arrayList);
                    objectOutputStream.close();
                }
                catch (Exception exception) {
                    Log.d((String)G.TAG, (String)"Could not save events list");
                    if (!BugSenseHandler.I_WANT_TO_DEBUG) break block5;
                    exception.printStackTrace();
                }
            }
            return;
        }
    }

    public void sendSavedEventsREMOVED() {
        final ArrayList<Event> arrayList = this.getList();
        if (arrayList.size() > 0) {
            new AsyncTask<Object, Object, Object>(){

                protected Object doInBackground(Object ... objectArray) {
                    ArrayList arrayList2 = new ArrayList();
                    arrayList2.addAll(arrayList);
                    EventsMechanism.this.clearList();
                    int n = 0;
                    while (true) {
                        block7: {
                            block6: {
                                if (n >= arrayList2.size()) break block6;
                                Event event = (Event)arrayList2.get(n);
                                if (Event.transmitEvent(EventsMechanism.this.ctx, event)) break block7;
                                int n2 = arrayList2.size();
                                if (n2 > 12) {
                                    n2 -= n2 + -12;
                                }
                                if (BugSenseHandler.I_WANT_TO_DEBUG) {
                                    Log.d((String)G.TAG, (String)("Could not send event, saving the rest: " + String.valueOf(n2) + " items"));
                                }
                                arrayList.clear();
                                arrayList.addAll(arrayList2.subList(n, n2));
                                EventsMechanism.this.saveList(arrayList);
                            }
                            return null;
                        }
                        ++n;
                    }
                }

                protected void onPostExecute(Object object) {
                    super.onPostExecute(object);
                }

                protected void onPreExecute() {
                    super.onPreExecute();
                }
            }.execute(new Object[0]);
        }
    }
}

