/*
 * Decompiled with CFR 0.152.
 */
package com.bugsense.trace.models;

import android.content.Context;
import android.content.SharedPreferences;
import android.util.Log;
import com.bugsense.trace.BugSenseHandler;
import com.bugsense.trace.G;
import com.bugsense.trace.models.Crash;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;

public final class CrashMechanism {
    private static final int MAX_CRASHES = 5;
    private static final int MAX_EXCEPTIONS = 8;
    private static final int MAX_LOG_LINES = 100;
    private static SharedPreferences.Editor editor;
    public static final String fileName = "bcrashes";
    private static volatile CrashMechanism instance;
    private static SharedPreferences preferences;
    private Context ctx;

    public static CrashMechanism getInstance(Context context) {
        if (instance == null) {
            instance = new CrashMechanism();
            preferences = context.getSharedPreferences(G.TAG, 0);
            editor = preferences.edit();
        }
        CrashMechanism.instance.ctx = context;
        return instance;
    }

    public void clearList() {
        if (BugSenseHandler.I_WANT_TO_DEBUG) {
            Log.d((String)G.TAG, (String)"clearing pings list");
        }
        this.saveList(new ArrayList<Crash>(0));
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ArrayList<Crash> getList() {
        synchronized (this) {
            ArrayList<Crash> arrayList;
            block8: {
                editor.putBoolean("CRASH_READ_COMPLETED", false).commit();
                ObjectInputStream objectInputStream = new ObjectInputStream(this.ctx.openFileInput(fileName));
                arrayList = (ArrayList<Crash>)objectInputStream.readObject();
                objectInputStream.close();
                break block8;
                {
                    catch (Exception exception) {}
                }
                catch (Exception exception) {
                    arrayList = null;
                    if (!BugSenseHandler.I_WANT_TO_DEBUG) break block8;
                    Log.d((String)G.TAG, (String)"Could not load crashes list or doesn't exist");
                }
            }
            editor.putBoolean("CRASH_READ_COMPLETED", true).commit();
            if (arrayList == null) {
                arrayList = new ArrayList<Crash>();
            }
            if (BugSenseHandler.I_WANT_TO_DEBUG) {
                Log.d((String)G.TAG, (String)("Crash List has: " + arrayList.size() + " items"));
            }
            return arrayList;
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void saveCrash(Crash var1_1) {
        var2_2 = 0;
        synchronized (this) {
            block18: {
                block17: {
                    var4_3 = this.getList();
                    var5_4 = var2_2;
                    while (true) {
                        if (var5_4 >= var4_3.size()) {
                            var6_5 = var2_2;
                            if (var6_5 != 0) return;
                            var7_6 = var1_1.getStacktrace().split("[\\r\\n]+");
                            if (var7_6 != null && var7_6.length > 100) {
                                var18_7 = new StringBuilder();
                                var19_8 = -100 + var7_6.length;
                                if (var19_8 < 0) {
                                    var19_8 = var2_2;
                                }
                                while (var19_8 < var7_6.length) {
                                    var18_7.append(var7_6[var19_8]);
                                    ++var19_8;
                                }
                                var1_1.setStacktrace(var18_7.toString());
                            }
                            break;
                        }
                        if (var4_3.get(var5_4).getStacktrace().equals(var1_1.getStacktrace()) && var4_3.get(var5_4).getExtraData().equals(var1_1.getExtraData()) && var4_3.get(var5_4).getCustomData().equals(var1_1.getCustomData())) {
                            return;
                        }
                        ++var5_4;
                    }
                    var4_3.add(var1_1);
                    var9_9 = var2_2;
                    var10_10 = var2_2;
                    var11_11 = var2_2;
                    while (true) {
                        block21: {
                            block20: {
                                block19: {
                                    if (var9_9 >= var4_3.size()) break block19;
                                    if (var4_3.get(var9_9).getType() != 1) break block20;
                                    var16_14 = var11_11 + 1;
                                    var17_15 = var10_10;
                                    var15_13 = var16_14;
                                    var14_12 = var17_15;
                                    break block21;
                                }
                                if (var1_1.getType() == 1) {
                                    if (var11_11 > 5) {
                                        break;
                                    }
                                    break block17;
                                }
                                if (var10_10 <= 8) break block17;
                                break block18;
                            }
                            var14_12 = var10_10 + 1;
                            var15_13 = var11_11;
                        }
                        ++var9_9;
                        var11_11 = var15_13;
                        var10_10 = var14_12;
                    }
                    while (var2_2 < var4_3.size()) {
                        if (var4_3.get(var2_2).getType() == 1) {
                            var4_3.remove(var2_2);
                            break;
                        }
                        ++var2_2;
                    }
                }
lbl63:
                // 3 sources

                while (true) {
                    this.saveList(var4_3);
                    return;
                }
            }
            while (true) {
                if (var2_2 >= var4_3.size()) ** GOTO lbl63
                if (var4_3.get(var2_2).getType() == 0) {
                    var4_3.remove(var2_2);
                    ** continue;
                }
                ++var2_2;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void saveList(ArrayList<Crash> arrayList) {
        synchronized (this) {
            block5: {
                if (arrayList != null) {
                    try {
                        ObjectOutputStream objectOutputStream = new ObjectOutputStream(this.ctx.openFileOutput(fileName, 0));
                        objectOutputStream.writeObject(arrayList);
                        objectOutputStream.close();
                    }
                    catch (Exception exception) {
                        Log.d((String)G.TAG, (String)"Could not save crash list");
                        if (!BugSenseHandler.I_WANT_TO_DEBUG) break block5;
                        exception.printStackTrace();
                    }
                }
            }
            return;
        }
    }

    public void sendSavedCrashes() {
        synchronized (this) {
            final ArrayList<Crash> arrayList = this.getList();
            if (arrayList.size() > 0) {
                Thread thread = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        ArrayList arrayList2 = new ArrayList();
                        arrayList2.addAll(arrayList);
                        CrashMechanism.this.clearList();
                        int n = 0;
                        while (true) {
                            block7: {
                                block6: {
                                    if (n >= arrayList2.size()) break block6;
                                    Crash crash = (Crash)arrayList2.get(n);
                                    if (Crash.transmitCrash(CrashMechanism.this.ctx, crash)) break block7;
                                    int n2 = arrayList2.size();
                                    if (n2 > 13) {
                                        n2 -= n2 + -13;
                                    }
                                    if (BugSenseHandler.I_WANT_TO_DEBUG) {
                                        Log.d((String)G.TAG, (String)("Could not send crash, saving the rest: " + String.valueOf(n2) + " items"));
                                    }
                                    arrayList.clear();
                                    arrayList.addAll(arrayList2.subList(n, n2));
                                    CrashMechanism.this.saveList(arrayList);
                                }
                                return;
                            }
                            ++n;
                        }
                    }
                });
                BugSenseHandler.getExecutor().submit(thread);
            }
            return;
        }
    }
}

