/*
 * Decompiled with CFR 0.152.
 */
package com.bugsense.trace.models;

import android.content.Context;
import android.util.Log;
import com.bugsense.trace.ActivityAsyncTask;
import com.bugsense.trace.BugSense;
import com.bugsense.trace.BugSenseHandler;
import com.bugsense.trace.G;
import com.bugsense.trace.Utils;
import com.bugsense.trace.models.CrashMechanism;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.params.HttpProtocolParams;
import org.json.JSONObject;

public class Crash
implements Serializable {
    public static final int CRASH = 1;
    public static final int EXCEPTION = 0;
    private static final long serialVersionUID = 5665643267788332700L;
    private String androidVersion = "";
    private String appPackage = "";
    private String appVerCode = "";
    private String appVersion = "";
    private String breadcrumbs = "";
    private String consoleLogs = "";
    private HashMap<String, String> customData = new HashMap();
    private String date = "";
    private HashMap<String, String> extraData = new HashMap();
    private int handled = 1;
    private int isGPSOn = 2;
    private int isMobileNetworkOn = 2;
    private int isWifiOn = 2;
    private String ms_from_start = "";
    private String phoneBrand = "";
    private String phoneModel = "";
    private String rooted = "";
    private String[] screenProperties;
    private String stacktrace = "";

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String createJSON(Context context, String string2, String string3, String string4, String string5, String string6, String string7, String string8, int n, int n2, int n3, String[] stringArray, String string9, Map<String, String> map, int n4, String string10) throws Exception {
        JSONObject jSONObject = new JSONObject();
        JSONObject jSONObject2 = new JSONObject();
        JSONObject jSONObject3 = new JSONObject();
        JSONObject jSONObject4 = new JSONObject();
        JSONObject jSONObject5 = new JSONObject();
        JSONObject jSONObject6 = new JSONObject();
        jSONObject2.put("remote_ip", (Object)"");
        jSONObject2.put("tag", (Object)"");
        jSONObject.put("request", (Object)jSONObject2);
        BufferedReader bufferedReader = new BufferedReader(new StringReader(string8));
        if (string9 == null) {
            jSONObject3.put("occured_at", (Object)bufferedReader.readLine());
        } else {
            jSONObject3.put("occured_at", (Object)string9);
        }
        jSONObject3.put("message", (Object)bufferedReader.readLine());
        String string11 = bufferedReader.readLine();
        try {
            String string12;
            string11 = string12 = string11.substring(1 + string11.lastIndexOf("("), string11.lastIndexOf(")"));
        }
        catch (Exception exception) {}
        jSONObject3.put("where", (Object)string11);
        jSONObject3.put("handled", n4);
        jSONObject3.put("klass", (Object)Crash.getClass(string8));
        jSONObject3.put("backtrace", (Object)string8);
        jSONObject3.put("breadcrumbs", (Object)string10);
        jSONObject.put("exception", (Object)jSONObject3);
        bufferedReader.close();
        jSONObject5.put("uid", (Object)Utils.getUid(context));
        jSONObject5.put("phone", (Object)string5);
        jSONObject5.put("brand", (Object)string6);
        jSONObject5.put("appver", (Object)string3);
        jSONObject5.put("appname", (Object)string2);
        jSONObject5.put("internal_version", (Object)string4);
        jSONObject5.put("osver", (Object)string7);
        jSONObject5.put("wifi_on", n);
        jSONObject5.put("mobile_net_on", n2);
        jSONObject5.put("gps_on", n3);
        jSONObject5.put("screen:width", (Object)stringArray[0]);
        jSONObject5.put("screen:height", (Object)stringArray[1]);
        jSONObject5.put("screen:orientation", (Object)stringArray[2]);
        jSONObject5.put("screen_dpi(x:y)", (Object)(stringArray[3] + ":" + stringArray[4]));
        if (map != null && !map.isEmpty()) {
            for (Map.Entry<String, String> entry : map.entrySet()) {
                jSONObject4.put(entry.getKey(), (Object)entry.getValue());
            }
            jSONObject5.put("log_data", (Object)jSONObject4);
        }
        jSONObject.put("application_environment", (Object)jSONObject5);
        jSONObject6.put("version", (Object)"3.0.6");
        jSONObject6.put("name", (Object)"bugsense-android");
        jSONObject.put("client", (Object)jSONObject6);
        return jSONObject.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String getClass(String string2) {
        String string3 = "";
        try {
            int n = string2.indexOf(":");
            if (n == -1) return string3;
            if (n + 1 >= string2.length()) return string3;
            String string4 = string2.substring(0, n);
            return string4;
        }
        catch (Exception exception) {
            return string3;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void sendCrash(final Context context, final Crash crash) {
        String string2 = Thread.currentThread().getName();
        if (!string2.equals("main")) {
            Log.i((String)G.TAG, (String)("Error in thread: " + string2));
            Crash.transmitCrash(context, crash);
            return;
        }
        new ActivityAsyncTask<BugSense.Processor, Object, Object, Object>(new BugSense.Processor(){

            @Override
            public boolean beginSubmit() {
                return true;
            }

            @Override
            public void handlerInstalled() {
            }

            @Override
            public void submitDone() {
            }
        }){

            protected Object doInBackground(Object ... objectArray) {
                Crash.transmitCrash(context, crash);
                return null;
            }

            protected void onCancelled() {
                super.onCancelled();
            }

            protected void onPreExecute() {
                super.onPreExecute();
            }

            @Override
            protected void processPostExecute(Object object) {
                ((BugSense.Processor)this.mWrapped).submitDone();
            }
        }.execute(new Object[0]);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean transmitCrash(Context context, Crash crash) {
        HttpEntity httpEntity;
        if (BugSenseHandler.I_WANT_TO_DEBUG) {
            Log.d((String)G.TAG, (String)("URL: " + G.URL));
            Log.d((String)G.TAG, (String)("APIKEY: " + G.API_KEY));
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        ArrayList<BasicNameValuePair> arrayList = new ArrayList<BasicNameValuePair>();
        hashMap.put("rooted", crash.rooted);
        hashMap.put("ms_from_start", crash.ms_from_start);
        if (G.SEND_LOG && crash.handled == 1) {
            hashMap.put("log", crash.consoleLogs);
        }
        hashMap.putAll(crash.extraData);
        hashMap.putAll(crash.customData);
        DefaultHttpClient defaultHttpClient = new DefaultHttpClient();
        HttpParams httpParams = defaultHttpClient.getParams();
        HttpProtocolParams.setUseExpectContinue((HttpParams)httpParams, (boolean)false);
        HttpConnectionParams.setConnectionTimeout((HttpParams)httpParams, (int)20000);
        HttpConnectionParams.setSoTimeout((HttpParams)httpParams, (int)20000);
        HttpPost httpPost = new HttpPost(G.URL);
        httpPost.addHeader("X-BugSense-Api-Key", G.API_KEY);
        try {
            BasicNameValuePair basicNameValuePair = new BasicNameValuePair("data", Crash.createJSON(context, crash.appPackage, crash.appVersion, crash.appVerCode, crash.phoneModel, crash.phoneBrand, crash.androidVersion, crash.stacktrace, crash.isWifiOn, crash.isMobileNetworkOn, crash.isGPSOn, crash.screenProperties, crash.date, hashMap, crash.handled, crash.breadcrumbs));
            arrayList.add(basicNameValuePair);
            arrayList.add(new BasicNameValuePair("hash", Utils.MD5(crash.stacktrace)));
            httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(arrayList, "UTF-8"));
            httpEntity = defaultHttpClient.execute((HttpUriRequest)httpPost).getEntity();
            if (httpEntity == null) {
                Log.w((String)G.TAG, (String)"It seems that there is no internet connectivity");
                throw new Exception("no internet connection");
            }
        }
        catch (ClientProtocolException clientProtocolException) {
            CrashMechanism.getInstance(context).saveCrash(crash);
            Log.w((String)G.TAG, (String)("Transmitting crash ClientProtocolException " + clientProtocolException.getMessage()));
            if (!BugSenseHandler.I_WANT_TO_DEBUG) return false;
            clientProtocolException.printStackTrace();
            return false;
        }
        catch (IOException iOException) {
            CrashMechanism.getInstance(context).saveCrash(crash);
            Log.w((String)G.TAG, (String)("Transmitting crash IOException " + iOException.getMessage()));
            if (!BugSenseHandler.I_WANT_TO_DEBUG) return false;
            iOException.printStackTrace();
            return false;
        }
        catch (Exception exception) {
            CrashMechanism.getInstance(context).saveCrash(crash);
            Log.w((String)G.TAG, (String)("Transmitting crash Exception " + exception.getMessage()));
            if (!BugSenseHandler.I_WANT_TO_DEBUG) return false;
            exception.printStackTrace();
            return false;
        }
        {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(httpEntity.getContent()));
            String string2 = bufferedReader.readLine();
            bufferedReader.close();
            if (BugSenseHandler.I_WANT_TO_DEBUG) {
                Log.i((String)G.TAG, (String)("Crash Response: " + string2));
            }
            if (string2 == null) return true;
            if (!string2.contains("tickerText")) return true;
            if (!string2.contains("contentTitle")) return true;
            if (!string2.contains("url")) return true;
            BugSenseHandler.showUpgradeNotification(string2);
            return true;
        }
    }

    public HashMap<String, String> getCustomData() {
        if (this.customData == null) {
            this.customData = new HashMap(0);
        }
        return this.customData;
    }

    public HashMap<String, String> getExtraData() {
        if (this.extraData == null) {
            this.extraData = new HashMap(0);
        }
        return this.extraData;
    }

    public String getStacktrace() {
        return this.stacktrace;
    }

    public int getType() {
        return this.handled;
    }

    public void setAndroidVersion(String string2) {
        this.androidVersion = string2;
    }

    public void setAppPackage(String string2) {
        this.appPackage = string2;
    }

    public void setAppVerCode(String string2) {
        this.appVerCode = string2;
    }

    public void setAppVersion(String string2) {
        this.appVersion = string2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setBreadcrumbs(ArrayList<String> arrayList) {
        if (arrayList == null || arrayList.size() == 0) {
            this.breadcrumbs = "";
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        Iterator<String> iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            String string2 = iterator.next().replaceAll("|", "_");
            if (string2.charAt(0) == '_') {
                string2 = string2.replaceFirst("_", "-");
            }
            stringBuilder.append(string2);
            stringBuilder.append("|");
        }
        this.breadcrumbs = stringBuilder.toString().substring(0, -1 + stringBuilder.toString().length());
    }

    public void setConsoleLogs(String string2) {
        this.consoleLogs = string2;
    }

    public void setCustomData(HashMap<String, String> hashMap) {
        this.customData = hashMap;
    }

    public void setDate(String string2) {
        this.date = string2;
    }

    public void setExtraData(HashMap<String, String> hashMap) {
        this.extraData = hashMap;
    }

    public void setHandled(int n) {
        this.handled = n;
    }

    public void setIsGPSOn(int n) {
        this.isGPSOn = n;
    }

    public void setIsMobileNetworkOn(int n) {
        this.isMobileNetworkOn = n;
    }

    public void setIsWifiOn(int n) {
        this.isWifiOn = n;
    }

    public void setMs_from_start(String string2) {
        this.ms_from_start = string2;
    }

    public void setPhoneBrand(String string2) {
        this.phoneBrand = string2;
    }

    public void setPhoneModel(String string2) {
        this.phoneModel = string2;
    }

    public void setRooted(String string2) {
        this.rooted = string2;
    }

    public void setScreenProperties(String[] stringArray) {
        this.screenProperties = stringArray;
    }

    public void setStacktrace(String string2) {
        this.stacktrace = string2;
    }
}

