/*
 * Decompiled with CFR 0.152.
 */
package com.actionbarsherlock.widget;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ResolveInfo;
import android.database.DataSetObservable;
import android.os.Handler;
import android.text.TextUtils;
import android.util.Log;
import android.util.Xml;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import org.xmlpull.v1.XmlPullParserException;

class ActivityChooserModel
extends DataSetObservable {
    private static final String ATTRIBUTE_ACTIVITY = "activity";
    private static final String ATTRIBUTE_TIME = "time";
    private static final String ATTRIBUTE_WEIGHT = "weight";
    private static final boolean DEBUG = false;
    private static final int DEFAULT_ACTIVITY_INFLATION = 5;
    private static final float DEFAULT_HISTORICAL_RECORD_WEIGHT = 1.0f;
    public static final String DEFAULT_HISTORY_FILE_NAME = "activity_choser_model_history.xml";
    public static final int DEFAULT_HISTORY_MAX_LENGTH = 50;
    private static final String HISTORY_FILE_EXTENSION = ".xml";
    private static final int INVALID_INDEX = -1;
    private static final String LOG_TAG = ActivityChooserModel.class.getSimpleName();
    private static final SerialExecutor SERIAL_EXECUTOR;
    private static final String TAG_HISTORICAL_RECORD = "historical-record";
    private static final String TAG_HISTORICAL_RECORDS = "historical-records";
    private static final Map<String, ActivityChooserModel> sDataModelRegistry;
    private static final Object sRegistryLock;
    private final List<ActivityResolveInfo> mActivites;
    private OnChooseActivityListener mActivityChoserModelPolicy;
    private ActivitySorter mActivitySorter;
    private boolean mCanReadHistoricalData = true;
    private final Context mContext;
    private final Handler mHandler;
    private final List<HistoricalRecord> mHistoricalRecords;
    private boolean mHistoricalRecordsChanged = true;
    private final String mHistoryFileName;
    private int mHistoryMaxSize = 50;
    private final Object mInstanceLock = new Object();
    private Intent mIntent;
    private boolean mReadShareHistoryCalled = false;

    static {
        sRegistryLock = new Object();
        sDataModelRegistry = new HashMap<String, ActivityChooserModel>();
        SERIAL_EXECUTOR = new SerialExecutor();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private ActivityChooserModel(Context context, String string2) {
        this.mActivites = new ArrayList<ActivityResolveInfo>();
        this.mHistoricalRecords = new ArrayList<HistoricalRecord>();
        this.mActivitySorter = new DefaultSorter();
        this.mHandler = new Handler();
        this.mContext = context.getApplicationContext();
        if (!TextUtils.isEmpty((CharSequence)string2) && !string2.endsWith(HISTORY_FILE_EXTENSION)) {
            this.mHistoryFileName = String.valueOf(string2) + HISTORY_FILE_EXTENSION;
            return;
        }
        this.mHistoryFileName = string2;
    }

    static /* synthetic */ Context access$0(ActivityChooserModel activityChooserModel) {
        return activityChooserModel.mContext;
    }

    static /* synthetic */ String access$1(ActivityChooserModel activityChooserModel) {
        return activityChooserModel.mHistoryFileName;
    }

    static /* synthetic */ Object access$2(ActivityChooserModel activityChooserModel) {
        return activityChooserModel.mInstanceLock;
    }

    static /* synthetic */ List access$3(ActivityChooserModel activityChooserModel) {
        return activityChooserModel.mHistoricalRecords;
    }

    static /* synthetic */ void access$4(ActivityChooserModel activityChooserModel, boolean bl) {
        activityChooserModel.mHistoricalRecordsChanged = bl;
    }

    static /* synthetic */ Handler access$5(ActivityChooserModel activityChooserModel) {
        return activityChooserModel.mHandler;
    }

    static /* synthetic */ String access$8() {
        return LOG_TAG;
    }

    private boolean addHisoricalRecord(HistoricalRecord historicalRecord) {
        Object object = this.mInstanceLock;
        synchronized (object) {
            boolean bl = this.mHistoricalRecords.add(historicalRecord);
            if (bl) {
                this.mHistoricalRecordsChanged = true;
                this.pruneExcessiveHistoricalRecordsLocked();
                this.persistHistoricalData();
                this.sortActivities();
            }
            return bl;
        }
    }

    public static ActivityChooserModel get(Context context, String string2) {
        Object object = sRegistryLock;
        synchronized (object) {
            ActivityChooserModel activityChooserModel = sDataModelRegistry.get(string2);
            if (activityChooserModel == null) {
                activityChooserModel = new ActivityChooserModel(context, string2);
                sDataModelRegistry.put(string2, activityChooserModel);
            }
            activityChooserModel.readHistoricalData();
            return activityChooserModel;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void loadActivitiesLocked() {
        this.mActivites.clear();
        if (this.mIntent != null) {
            List list = this.mContext.getPackageManager().queryIntentActivities(this.mIntent, 0);
            int n = list.size();
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    this.sortActivities();
                    return;
                }
                ResolveInfo resolveInfo = (ResolveInfo)list.get(n2);
                this.mActivites.add(new ActivityResolveInfo(resolveInfo));
                ++n2;
            }
        }
        this.notifyChanged();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void persistHistoricalData() {
        Object object = this.mInstanceLock;
        synchronized (object) {
            if (!this.mReadShareHistoryCalled) {
                throw new IllegalStateException("No preceding call to #readHistoricalData");
            }
            if (!this.mHistoricalRecordsChanged) {
                return;
            }
            this.mHistoricalRecordsChanged = false;
            this.mCanReadHistoricalData = true;
            if (TextUtils.isEmpty((CharSequence)this.mHistoryFileName)) return;
            SERIAL_EXECUTOR.execute(new HistoryPersister());
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void pruneExcessiveHistoricalRecordsLocked() {
        List<HistoricalRecord> list = this.mHistoricalRecords;
        int n = list.size() - this.mHistoryMaxSize;
        if (n > 0) {
            this.mHistoricalRecordsChanged = true;
            for (int i = 0; i < n; ++i) {
                list.remove(0);
            }
        }
    }

    private void readHistoricalData() {
        Object object = this.mInstanceLock;
        synchronized (object) {
            if (!this.mCanReadHistoricalData || !this.mHistoricalRecordsChanged) {
            } else {
                this.mCanReadHistoricalData = false;
                this.mReadShareHistoryCalled = true;
                if (!TextUtils.isEmpty((CharSequence)this.mHistoryFileName)) {
                    SERIAL_EXECUTOR.execute(new HistoryLoader());
                }
            }
        }
    }

    private void sortActivities() {
        Object object = this.mInstanceLock;
        synchronized (object) {
            if (this.mActivitySorter != null && !this.mActivites.isEmpty()) {
                this.mActivitySorter.sort(this.mIntent, this.mActivites, Collections.unmodifiableList(this.mHistoricalRecords));
                this.notifyChanged();
            }
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Intent chooseActivity(int n) {
        Intent intent;
        ActivityResolveInfo activityResolveInfo = this.mActivites.get(n);
        ComponentName componentName = new ComponentName(activityResolveInfo.resolveInfo.activityInfo.packageName, activityResolveInfo.resolveInfo.activityInfo.name);
        Intent intent2 = new Intent(this.mIntent);
        intent2.setComponent(componentName);
        if (this.mActivityChoserModelPolicy != null && this.mActivityChoserModelPolicy.onChooseActivity(this, intent = new Intent(intent2))) {
            return null;
        }
        this.addHisoricalRecord(new HistoricalRecord(componentName, System.currentTimeMillis(), 1.0f));
        return intent2;
    }

    public ResolveInfo getActivity(int n) {
        Object object = this.mInstanceLock;
        synchronized (object) {
            ResolveInfo resolveInfo = this.mActivites.get((int)n).resolveInfo;
            return resolveInfo;
        }
    }

    public int getActivityCount() {
        Object object = this.mInstanceLock;
        synchronized (object) {
            int n = this.mActivites.size();
            return n;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getActivityIndex(ResolveInfo resolveInfo) {
        List<ActivityResolveInfo> list = this.mActivites;
        int n = list.size();
        int n2 = 0;
        while (n2 < n) {
            if (list.get((int)n2).resolveInfo == resolveInfo) return n2;
            ++n2;
        }
        return -1;
    }

    public ResolveInfo getDefaultActivity() {
        ResolveInfo resolveInfo;
        Object object = this.mInstanceLock;
        synchronized (object) {
            if (!this.mActivites.isEmpty()) {
                resolveInfo = this.mActivites.get((int)0).resolveInfo;
            } else {
                // MONITOREXIT @DISABLED, blocks:[0, 1, 3] lbl8 : MonitorExitStatement: MONITOREXIT : var1_1
                resolveInfo = null;
            }
        }
        return resolveInfo;
    }

    public int getHistoryMaxSize() {
        Object object = this.mInstanceLock;
        synchronized (object) {
            int n = this.mHistoryMaxSize;
            return n;
        }
    }

    public int getHistorySize() {
        Object object = this.mInstanceLock;
        synchronized (object) {
            int n = this.mHistoricalRecords.size();
            return n;
        }
    }

    public Intent getIntent() {
        Object object = this.mInstanceLock;
        synchronized (object) {
            Intent intent = this.mIntent;
            return intent;
        }
    }

    public void setActivitySorter(ActivitySorter activitySorter) {
        Object object = this.mInstanceLock;
        synchronized (object) {
            if (this.mActivitySorter == activitySorter) {
            } else {
                this.mActivitySorter = activitySorter;
                this.sortActivities();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setDefaultActivity(int n) {
        ActivityResolveInfo activityResolveInfo = this.mActivites.get(n);
        ActivityResolveInfo activityResolveInfo2 = this.mActivites.get(0);
        float f = activityResolveInfo2 != null ? 5.0f + (activityResolveInfo2.weight - activityResolveInfo.weight) : 1.0f;
        this.addHisoricalRecord(new HistoricalRecord(new ComponentName(activityResolveInfo.resolveInfo.activityInfo.packageName, activityResolveInfo.resolveInfo.activityInfo.name), System.currentTimeMillis(), f));
    }

    public void setHistoryMaxSize(int n) {
        Object object = this.mInstanceLock;
        synchronized (object) {
            if (this.mHistoryMaxSize == n) {
            } else {
                this.mHistoryMaxSize = n;
                this.pruneExcessiveHistoricalRecordsLocked();
                this.sortActivities();
            }
        }
    }

    public void setIntent(Intent intent) {
        Object object = this.mInstanceLock;
        synchronized (object) {
            if (this.mIntent == intent) {
            } else {
                this.mIntent = intent;
                this.loadActivitiesLocked();
            }
        }
    }

    public void setOnChooseActivityListener(OnChooseActivityListener onChooseActivityListener) {
        this.mActivityChoserModelPolicy = onChooseActivityListener;
    }

    public static interface ActivityChooserModelClient {
        public void setActivityChooserModel(ActivityChooserModel var1);
    }

    public final class ActivityResolveInfo
    implements Comparable<ActivityResolveInfo> {
        public final ResolveInfo resolveInfo;
        public float weight;

        public ActivityResolveInfo(ResolveInfo resolveInfo) {
            this.resolveInfo = resolveInfo;
        }

        @Override
        public int compareTo(ActivityResolveInfo activityResolveInfo) {
            return Float.floatToIntBits(activityResolveInfo.weight) - Float.floatToIntBits(this.weight);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object object) {
            boolean bl = true;
            if (this == object) {
                return bl;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            ActivityResolveInfo activityResolveInfo = (ActivityResolveInfo)object;
            if (Float.floatToIntBits(this.weight) == Float.floatToIntBits(activityResolveInfo.weight)) return bl;
            return false;
        }

        public int hashCode() {
            return 31 + Float.floatToIntBits(this.weight);
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("[");
            stringBuilder.append("resolveInfo:").append(this.resolveInfo.toString());
            stringBuilder.append("; weight:").append(new BigDecimal(this.weight));
            stringBuilder.append("]");
            return stringBuilder.toString();
        }
    }

    public static interface ActivitySorter {
        public void sort(Intent var1, List<ActivityResolveInfo> var2, List<HistoricalRecord> var3);
    }

    private final class DefaultSorter
    implements ActivitySorter {
        private static final float WEIGHT_DECAY_COEFFICIENT = 0.95f;
        private final Map<String, ActivityResolveInfo> mPackageNameToActivityMap = new HashMap<String, ActivityResolveInfo>();

        private DefaultSorter() {
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void sort(Intent intent, List<ActivityResolveInfo> list, List<HistoricalRecord> list2) {
            Map<String, ActivityResolveInfo> map = this.mPackageNameToActivityMap;
            map.clear();
            int n = list.size();
            int n2 = 0;
            while (true) {
                if (n2 >= n) break;
                ActivityResolveInfo activityResolveInfo = list.get(n2);
                activityResolveInfo.weight = 0.0f;
                map.put(activityResolveInfo.resolveInfo.activityInfo.packageName, activityResolveInfo);
                ++n2;
            }
            int n3 = -1 + list2.size();
            float f = 1.0f;
            int n4 = n3;
            while (true) {
                if (n4 < 0) {
                    Collections.sort(list);
                    return;
                }
                HistoricalRecord historicalRecord = list2.get(n4);
                ActivityResolveInfo activityResolveInfo = map.get(historicalRecord.activity.getPackageName());
                if (activityResolveInfo != null) {
                    activityResolveInfo.weight += f * historicalRecord.weight;
                    f *= 0.95f;
                }
                --n4;
            }
        }
    }

    public static final class HistoricalRecord {
        public final ComponentName activity;
        public final long time;
        public final float weight;

        public HistoricalRecord(ComponentName componentName, long l, float f) {
            this.activity = componentName;
            this.time = l;
            this.weight = f;
        }

        public HistoricalRecord(String string2, long l, float f) {
            this(ComponentName.unflattenFromString((String)string2), l, f);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object object) {
            boolean bl = true;
            if (this == object) {
                return bl;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            HistoricalRecord historicalRecord = (HistoricalRecord)object;
            if (this.activity == null ? historicalRecord.activity != null : !this.activity.equals((Object)historicalRecord.activity)) {
                return false;
            }
            if (this.time != historicalRecord.time) {
                return false;
            }
            if (Float.floatToIntBits(this.weight) == Float.floatToIntBits(historicalRecord.weight)) return bl;
            return false;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public int hashCode() {
            int n;
            if (this.activity == null) {
                n = 0;
                return 31 * (31 * (n + 31) + (int)(this.time ^ this.time >>> 32)) + Float.floatToIntBits(this.weight);
            }
            n = this.activity.hashCode();
            return 31 * (31 * (n + 31) + (int)(this.time ^ this.time >>> 32)) + Float.floatToIntBits(this.weight);
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("[");
            stringBuilder.append("; activity:").append(this.activity);
            stringBuilder.append("; time:").append(this.time);
            stringBuilder.append("; weight:").append(new BigDecimal(this.weight));
            stringBuilder.append("]");
            return stringBuilder.toString();
        }
    }

    private final class HistoryLoader
    implements Runnable {
        private HistoryLoader() {
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            var2_1 = ActivityChooserModel.access$0(ActivityChooserModel.this).openFileInput(ActivityChooserModel.access$1(ActivityChooserModel.this));
            {
                catch (FileNotFoundException var1_5) {
                    return;
                }
            }
            try {}
            catch (Throwable var3_15) {
                if (var2_1 == null) throw var3_15;
                try {
                    var2_1.close();
                    throw var3_15;
                }
                catch (IOException var4_18) {
                    throw var3_15;
                }
            }
            ** try [egrp 2[TRYBLOCK] [1, 2 : 18->63)] { 
lbl15:
            // 1 sources

            ** GOTO lbl32
lbl16:
            // 1 sources

            catch (XmlPullParserException var8_4) {
                Log.e((String)ActivityChooserModel.access$8(), (String)("Error reading historical recrod file: " + ActivityChooserModel.access$1(ActivityChooserModel.this)), (Throwable)var8_4);
                if (var2_1 == null) return;
                var2_1.close();
                return;
lbl23:
                // 1 sources

                catch (IOException var5_13) {
                    Log.e((String)ActivityChooserModel.access$8(), (String)("Error reading historical recrod file: " + ActivityChooserModel.access$1(ActivityChooserModel.this)), (Throwable)var5_13);
                    if (var2_1 == null) return;
                    try {
                        var2_1.close();
                        return;
                    }
                    catch (IOException var7_14) {
                        return;
                    }
                }
lbl32:
                // 1 sources

                var11_2 = Xml.newPullParser();
                var11_2.setInput((InputStream)var2_1, null);
                var12_3 = 0;
                while (var12_3 != 1 && var12_3 != 2) {
                    var12_3 = var11_2.next();
                }
lbl39:
                // 1 sources

                while (true) {
                    var13_6 = new ArrayList<HistoricalRecord>();
                    block28: while (true) {
                        if ((var14_7 = var11_2.next()) == 1) {
                            var16_8 = ActivityChooserModel.access$2(ActivityChooserModel.this);
                            synchronized (var16_8) {
                                var17_9 = new LinkedHashSet<HistoricalRecord>(var13_6);
                                var19_10 = ActivityChooserModel.access$3(ActivityChooserModel.this);
                                var20_11 = -1 + var19_10.size();
lbl48:
                                // 2 sources

                                while (true) {
                                    if (var20_11 >= 0) break block28;
                                    if (var19_10.size() == var17_9.size()) {
                                        // MONITOREXIT @DISABLED, blocks:[16, 17, 27, 28, 29, 30, 31] lbl51 : MonitorExitStatement: MONITOREXIT : var16_8
                                        if (var2_1 == null) return;
                                        try {
                                            var2_1.close();
                                            return;
                                        }
                                        catch (IOException var25_12) {
                                            return;
                                        }
                                    }
                                    break block32;
                                    break;
                                }
                            }
                        }
                        if (var14_7 == 3 || var14_7 == 4) continue;
                        {
                            if ("historical-record".equals(var11_2.getName())) ** GOTO lbl-1000
                            throw new XmlPullParserException("Share records file not well-formed.");
                        }
lbl-1000:
                        // 1 sources

                        {
                            var13_6.add(new HistoricalRecord(var11_2.getAttributeValue(null, "activity"), Long.parseLong(var11_2.getAttributeValue(null, "time")), Float.parseFloat(var11_2.getAttributeValue(null, "weight"))));
                            continue;
                        }
                        break;
                    }
                    {
                        block32: {
                            var17_9.add((HistoricalRecord)var19_10.get(var20_11));
                            --var20_11;
                            ** continue;
                        }
                        var19_10.clear();
                        var19_10.addAll(var17_9);
                        ActivityChooserModel.access$4(ActivityChooserModel.this, true);
                        ActivityChooserModel.access$5(ActivityChooserModel.this).post(new Runnable(){

                            @Override
                            public void run() {
                                ActivityChooserModel.this.pruneExcessiveHistoricalRecordsLocked();
                                ActivityChooserModel.this.sortActivities();
                            }
                        });
                    }
                    if (var2_1 == null) return;
                    try {
                        var2_1.close();
                        return;
                    }
                    catch (IOException var24_16) {
                        return;
                    }
                    break;
                }
                catch (IOException var10_17) {
                    return;
                }
            }
            ** while ("historical-records".equals((Object)var11_2.getName()))
lbl85:
            // 1 sources

            throw new XmlPullParserException("Share records file does not start with historical-records tag.");
        }
    }

    private final class HistoryPersister
    implements Runnable {
        private HistoryPersister() {
        }

        /*
         * Exception decompiling
         */
        @Override
        public void run() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 4[TRYBLOCK] [8 : 134->136)] java.lang.Throwable
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }

    public static interface OnChooseActivityListener {
        public boolean onChooseActivity(ActivityChooserModel var1, Intent var2);
    }

    private static class SerialExecutor
    implements Executor {
        Runnable mActive;
        final LinkedList<Runnable> mTasks = new LinkedList();

        private SerialExecutor() {
        }

        @Override
        public void execute(final Runnable runnable) {
            synchronized (this) {
                this.mTasks.offer(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            runnable.run();
                            return;
                        }
                        finally {
                            SerialExecutor.this.scheduleNext();
                        }
                    }
                });
                if (this.mActive == null) {
                    this.scheduleNext();
                }
                return;
            }
        }

        protected void scheduleNext() {
            synchronized (this) {
                Runnable runnable;
                this.mActive = runnable = this.mTasks.poll();
                if (runnable != null) {
                    this.mActive.run();
                }
                return;
            }
        }
    }
}

