/*
 * Decompiled with CFR 0.152.
 */
package com.actionbarsherlock.internal.widget;

import android.content.Context;
import android.database.DataSetObserver;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Handler;
import android.util.AttributeSet;
import android.view.ContextThemeWrapper;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.widget.AbsListView;
import android.widget.AdapterView;
import android.widget.LinearLayout;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.PopupWindow;
import com.actionbarsherlock.R;

public class IcsListPopupWindow {
    private static final int EXPAND_LIST_TIMEOUT = 250;
    public static final int POSITION_PROMPT_ABOVE = 0;
    public static final int POSITION_PROMPT_BELOW = 1;
    private ListAdapter mAdapter;
    private Context mContext;
    private View mDropDownAnchorView;
    private int mDropDownHeight = -2;
    private int mDropDownHorizontalOffset;
    private DropDownListView mDropDownList;
    private Drawable mDropDownListHighlight;
    private int mDropDownVerticalOffset;
    private boolean mDropDownVerticalOffsetSet;
    private int mDropDownWidth = -2;
    private Handler mHandler;
    private final ListSelectorHider mHideSelector;
    private AdapterView.OnItemClickListener mItemClickListener;
    private AdapterView.OnItemSelectedListener mItemSelectedListener;
    private int mListItemExpandMaximum = Integer.MAX_VALUE;
    private boolean mModal;
    private DataSetObserver mObserver;
    private PopupWindow mPopup;
    private int mPromptPosition = 0;
    private View mPromptView;
    private final ResizePopupRunnable mResizePopupRunnable = new ResizePopupRunnable();
    private final PopupScrollListener mScrollListener;
    private Rect mTempRect;
    private final PopupTouchInterceptor mTouchInterceptor = new PopupTouchInterceptor();

    public IcsListPopupWindow(Context context) {
        this(context, null, R.attr.listPopupWindowStyle);
    }

    public IcsListPopupWindow(Context context, AttributeSet attributeSet, int n) {
        this.mScrollListener = new PopupScrollListener();
        this.mHideSelector = new ListSelectorHider();
        this.mHandler = new Handler();
        this.mTempRect = new Rect();
        this.mContext = context;
        this.mPopup = new PopupWindow(context, attributeSet, n);
        this.mPopup.setInputMethodMode(1);
    }

    /*
     * Enabled aggressive block sorting
     */
    public IcsListPopupWindow(Context context, AttributeSet attributeSet, int n, int n2) {
        this.mScrollListener = new PopupScrollListener();
        this.mHideSelector = new ListSelectorHider();
        this.mHandler = new Handler();
        this.mTempRect = new Rect();
        this.mContext = context;
        this.mPopup = Build.VERSION.SDK_INT < 11 ? new PopupWindow((Context)new ContextThemeWrapper(context, n2), attributeSet, n) : new PopupWindow(context, attributeSet, n, n2);
        this.mPopup.setInputMethodMode(1);
    }

    /*
     * Enabled aggressive block sorting
     */
    private int buildDropDown() {
        int n = 0;
        if (this.mDropDownList == null) {
            Context context = this.mContext;
            boolean bl = !this.mModal;
            this.mDropDownList = new DropDownListView(context, bl);
            if (this.mDropDownListHighlight != null) {
                this.mDropDownList.setSelector(this.mDropDownListHighlight);
            }
            this.mDropDownList.setAdapter(this.mAdapter);
            this.mDropDownList.setOnItemClickListener(this.mItemClickListener);
            this.mDropDownList.setFocusable(true);
            this.mDropDownList.setFocusableInTouchMode(true);
            this.mDropDownList.setOnItemSelectedListener(new AdapterView.OnItemSelectedListener(){

                public void onItemSelected(AdapterView<?> adapterView, View view, int n, long l) {
                    DropDownListView dropDownListView;
                    if (n != -1 && (dropDownListView = IcsListPopupWindow.this.mDropDownList) != null) {
                        dropDownListView.mListSelectionHidden = false;
                    }
                }

                public void onNothingSelected(AdapterView<?> adapterView) {
                }
            });
            this.mDropDownList.setOnScrollListener(this.mScrollListener);
            if (this.mItemSelectedListener != null) {
                this.mDropDownList.setOnItemSelectedListener(this.mItemSelectedListener);
            }
            DropDownListView dropDownListView = this.mDropDownList;
            View view = this.mPromptView;
            if (view != null) {
                LinearLayout linearLayout = new LinearLayout(context);
                linearLayout.setOrientation(1);
                LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(-1, 0, 1.0f);
                switch (this.mPromptPosition) {
                    case 1: {
                        linearLayout.addView((View)dropDownListView, (ViewGroup.LayoutParams)layoutParams);
                        linearLayout.addView(view);
                        break;
                    }
                    case 0: {
                        linearLayout.addView(view);
                        linearLayout.addView((View)dropDownListView, (ViewGroup.LayoutParams)layoutParams);
                        break;
                    }
                }
                view.measure(View.MeasureSpec.makeMeasureSpec((int)this.mDropDownWidth, (int)Integer.MIN_VALUE), 0);
                LinearLayout.LayoutParams layoutParams2 = (LinearLayout.LayoutParams)view.getLayoutParams();
                n = view.getMeasuredHeight() + layoutParams2.topMargin + layoutParams2.bottomMargin;
                dropDownListView = linearLayout;
            }
            this.mPopup.setContentView((View)dropDownListView);
        } else {
            ViewGroup cfr_ignored_0 = (ViewGroup)this.mPopup.getContentView();
            View view = this.mPromptView;
            if (view != null) {
                LinearLayout.LayoutParams layoutParams = (LinearLayout.LayoutParams)view.getLayoutParams();
                n = view.getMeasuredHeight() + layoutParams.topMargin + layoutParams.bottomMargin;
            }
        }
        int n2 = 0;
        Drawable drawable2 = this.mPopup.getBackground();
        if (drawable2 != null) {
            drawable2.getPadding(this.mTempRect);
            n2 = this.mTempRect.top + this.mTempRect.bottom;
            if (!this.mDropDownVerticalOffsetSet) {
                this.mDropDownVerticalOffset = -this.mTempRect.top;
            }
        }
        boolean bl = this.mPopup.getInputMethodMode() == 2;
        int n3 = this.getMaxAvailableHeight(this.mDropDownAnchorView, this.mDropDownVerticalOffset, bl);
        if (this.mDropDownHeight == -1) {
            return n3 + n2;
        }
        int n4 = this.measureHeightOfChildren(0, 0, -1, n3 - n, -1);
        if (n4 <= 0) return n4 + n;
        n += n2;
        return n4 + n;
    }

    private int getMaxAvailableHeight(View view, int n, boolean bl) {
        Rect rect = new Rect();
        view.getWindowVisibleDisplayFrame(rect);
        int[] nArray = new int[2];
        view.getLocationOnScreen(nArray);
        int n2 = rect.bottom;
        if (bl) {
            n2 = view.getContext().getResources().getDisplayMetrics().heightPixels;
        }
        int n3 = Math.max(n2 - (nArray[1] + view.getHeight()) - n, n + (nArray[1] - rect.top));
        if (this.mPopup.getBackground() != null) {
            this.mPopup.getBackground().getPadding(this.mTempRect);
            n3 -= this.mTempRect.top + this.mTempRect.bottom;
        }
        return n3;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isInputMethodNotNeeded() {
        if (this.mPopup.getInputMethodMode() != 2) return false;
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    private int measureHeightOfChildren(int n, int n2, int n3, int n4, int n5) {
        ListAdapter listAdapter = this.mAdapter;
        if (listAdapter == null) {
            return this.mDropDownList.getListPaddingTop() + this.mDropDownList.getListPaddingBottom();
        }
        int n6 = this.mDropDownList.getListPaddingTop() + this.mDropDownList.getListPaddingBottom();
        int n7 = this.mDropDownList.getDividerHeight() > 0 && this.mDropDownList.getDivider() != null ? this.mDropDownList.getDividerHeight() : 0;
        int n8 = 0;
        if (n3 == -1) {
            n3 = -1 + listAdapter.getCount();
        }
        int n9 = n2;
        while (n9 <= n3) {
            View view = this.mAdapter.getView(n9, null, (ViewGroup)this.mDropDownList);
            if (this.mDropDownList.getCacheColorHint() != 0) {
                view.setDrawingCacheBackgroundColor(this.mDropDownList.getCacheColorHint());
            }
            this.measureScrapChild(view, n9, n);
            if (n9 > 0) {
                n6 += n7;
            }
            if ((n6 += view.getMeasuredHeight()) >= n4) {
                if (n5 < 0) return n4;
                if (n9 <= n5) return n4;
                if (n8 <= 0) return n4;
                if (n6 != n4) return n8;
                return n4;
            }
            if (n5 >= 0 && n9 >= n5) {
                n8 = n6;
            }
            ++n9;
        }
        return n6;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void measureScrapChild(View view, int n, int n2) {
        AbsListView.LayoutParams layoutParams = (AbsListView.LayoutParams)view.getLayoutParams();
        if (layoutParams == null) {
            layoutParams = new AbsListView.LayoutParams(-1, -2, 0);
            view.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        }
        int n3 = ViewGroup.getChildMeasureSpec((int)n2, (int)(this.mDropDownList.getPaddingLeft() + this.mDropDownList.getPaddingRight()), (int)layoutParams.width);
        int n4 = layoutParams.height;
        int n5 = n4 > 0 ? View.MeasureSpec.makeMeasureSpec((int)n4, (int)0x40000000) : View.MeasureSpec.makeMeasureSpec((int)0, (int)0);
        view.measure(n3, n5);
    }

    public void clearListSelection() {
        DropDownListView dropDownListView = this.mDropDownList;
        if (dropDownListView != null) {
            dropDownListView.mListSelectionHidden = true;
            dropDownListView.requestLayout();
        }
    }

    public void dismiss() {
        ViewParent viewParent;
        this.mPopup.dismiss();
        if (this.mPromptView != null && (viewParent = this.mPromptView.getParent()) instanceof ViewGroup) {
            ((ViewGroup)viewParent).removeView(this.mPromptView);
        }
        this.mPopup.setContentView(null);
        this.mDropDownList = null;
        this.mHandler.removeCallbacks((Runnable)this.mResizePopupRunnable);
    }

    public ListView getListView() {
        return this.mDropDownList;
    }

    public boolean isShowing() {
        return this.mPopup.isShowing();
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setAdapter(ListAdapter listAdapter) {
        if (this.mObserver == null) {
            this.mObserver = new PopupDataSetObserver();
        } else if (this.mAdapter != null) {
            this.mAdapter.unregisterDataSetObserver(this.mObserver);
        }
        this.mAdapter = listAdapter;
        if (this.mAdapter != null) {
            listAdapter.registerDataSetObserver(this.mObserver);
        }
        if (this.mDropDownList != null) {
            this.mDropDownList.setAdapter(this.mAdapter);
        }
    }

    public void setAnchorView(View view) {
        this.mDropDownAnchorView = view;
    }

    public void setBackgroundDrawable(Drawable drawable2) {
        this.mPopup.setBackgroundDrawable(drawable2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setContentWidth(int n) {
        Drawable drawable2 = this.mPopup.getBackground();
        if (drawable2 != null) {
            drawable2.getPadding(this.mTempRect);
            this.mDropDownWidth = n + (this.mTempRect.left + this.mTempRect.right);
            return;
        }
        this.mDropDownWidth = n;
    }

    public void setHorizontalOffset(int n) {
        this.mDropDownHorizontalOffset = n;
    }

    public void setInputMethodMode(int n) {
        this.mPopup.setInputMethodMode(n);
    }

    public void setModal(boolean bl) {
        this.mModal = true;
        this.mPopup.setFocusable(bl);
    }

    public void setOnDismissListener(PopupWindow.OnDismissListener onDismissListener) {
        this.mPopup.setOnDismissListener(onDismissListener);
    }

    public void setOnItemClickListener(AdapterView.OnItemClickListener onItemClickListener) {
        this.mItemClickListener = onItemClickListener;
    }

    public void setPromptPosition(int n) {
        this.mPromptPosition = n;
    }

    public void setVerticalOffset(int n) {
        this.mDropDownVerticalOffset = n;
        this.mDropDownVerticalOffsetSet = true;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void show() {
        int n = 0;
        int n2 = -1;
        int n3 = this.buildDropDown();
        int n4 = 0;
        int n5 = 0;
        boolean bl = this.isInputMethodNotNeeded();
        if (this.mPopup.isShowing()) {
            int n6;
            int n7 = this.mDropDownWidth == n2 ? -1 : (this.mDropDownWidth == -2 ? this.mDropDownAnchorView.getWidth() : this.mDropDownWidth);
            if (this.mDropDownHeight == n2) {
                n6 = bl ? n3 : n2;
                if (bl) {
                    PopupWindow popupWindow = this.mPopup;
                    if (this.mDropDownWidth != n2) {
                        n2 = n;
                    }
                    popupWindow.setWindowLayoutMode(n2, n);
                } else {
                    PopupWindow popupWindow = this.mPopup;
                    if (this.mDropDownWidth == n2) {
                        n = n2;
                    }
                    popupWindow.setWindowLayoutMode(n, n2);
                }
            } else {
                n6 = this.mDropDownHeight == -2 ? n3 : this.mDropDownHeight;
            }
            this.mPopup.setOutsideTouchable(true);
            this.mPopup.update(this.mDropDownAnchorView, this.mDropDownHorizontalOffset, this.mDropDownVerticalOffset, n7, n6);
            return;
        }
        if (this.mDropDownWidth == n2) {
            n4 = -1;
        } else if (this.mDropDownWidth == -2) {
            this.mPopup.setWidth(this.mDropDownAnchorView.getWidth());
        } else {
            this.mPopup.setWidth(this.mDropDownWidth);
        }
        if (this.mDropDownHeight == n2) {
            n5 = -1;
        } else if (this.mDropDownHeight == -2) {
            this.mPopup.setHeight(n3);
        } else {
            this.mPopup.setHeight(this.mDropDownHeight);
        }
        this.mPopup.setWindowLayoutMode(n4, n5);
        this.mPopup.setOutsideTouchable(true);
        this.mPopup.setTouchInterceptor((View.OnTouchListener)this.mTouchInterceptor);
        this.mPopup.showAsDropDown(this.mDropDownAnchorView, this.mDropDownHorizontalOffset, this.mDropDownVerticalOffset);
        this.mDropDownList.setSelection(n2);
        if (!this.mModal || this.mDropDownList.isInTouchMode()) {
            this.clearListSelection();
        }
        if (this.mModal) return;
        this.mHandler.post((Runnable)this.mHideSelector);
    }

    private static class DropDownListView
    extends ListView {
        private boolean mHijackFocus;
        private boolean mListSelectionHidden;

        public DropDownListView(Context context, boolean bl) {
            super(context, null, R.attr.dropDownListViewStyle);
            this.mHijackFocus = bl;
            this.setCacheColorHint(0);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean hasFocus() {
            if (this.mHijackFocus) return true;
            if (super.hasFocus()) return true;
            return false;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean hasWindowFocus() {
            if (this.mHijackFocus) return true;
            if (super.hasWindowFocus()) return true;
            return false;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean isFocused() {
            if (this.mHijackFocus) return true;
            if (super.isFocused()) return true;
            return false;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean isInTouchMode() {
            if (this.mHijackFocus) {
                if (this.mListSelectionHidden) return true;
            }
            if (super.isInTouchMode()) return true;
            return false;
        }
    }

    private class ListSelectorHider
    implements Runnable {
        private ListSelectorHider() {
        }

        @Override
        public void run() {
            IcsListPopupWindow.this.clearListSelection();
        }
    }

    private class PopupDataSetObserver
    extends DataSetObserver {
        private PopupDataSetObserver() {
        }

        public void onChanged() {
            if (IcsListPopupWindow.this.isShowing()) {
                IcsListPopupWindow.this.show();
            }
        }

        public void onInvalidated() {
            IcsListPopupWindow.this.dismiss();
        }
    }

    private class PopupScrollListener
    implements AbsListView.OnScrollListener {
        private PopupScrollListener() {
        }

        public void onScroll(AbsListView absListView, int n, int n2, int n3) {
        }

        public void onScrollStateChanged(AbsListView absListView, int n) {
            if (n == 1 && !IcsListPopupWindow.this.isInputMethodNotNeeded() && IcsListPopupWindow.this.mPopup.getContentView() != null) {
                IcsListPopupWindow.this.mHandler.removeCallbacks((Runnable)IcsListPopupWindow.this.mResizePopupRunnable);
                IcsListPopupWindow.this.mResizePopupRunnable.run();
            }
        }
    }

    private class PopupTouchInterceptor
    implements View.OnTouchListener {
        private PopupTouchInterceptor() {
        }

        /*
         * Enabled aggressive block sorting
         */
        public boolean onTouch(View view, MotionEvent motionEvent) {
            int n = motionEvent.getAction();
            int n2 = (int)motionEvent.getX();
            int n3 = (int)motionEvent.getY();
            if (n == 0 && IcsListPopupWindow.this.mPopup != null && IcsListPopupWindow.this.mPopup.isShowing() && n2 >= 0 && n2 < IcsListPopupWindow.this.mPopup.getWidth() && n3 >= 0 && n3 < IcsListPopupWindow.this.mPopup.getHeight()) {
                IcsListPopupWindow.this.mHandler.postDelayed((Runnable)IcsListPopupWindow.this.mResizePopupRunnable, 250L);
                return false;
            }
            if (n != 1) return false;
            IcsListPopupWindow.this.mHandler.removeCallbacks((Runnable)IcsListPopupWindow.this.mResizePopupRunnable);
            return false;
        }
    }

    private class ResizePopupRunnable
    implements Runnable {
        private ResizePopupRunnable() {
        }

        @Override
        public void run() {
            if (IcsListPopupWindow.this.mDropDownList != null && IcsListPopupWindow.this.mDropDownList.getCount() > IcsListPopupWindow.this.mDropDownList.getChildCount() && IcsListPopupWindow.this.mDropDownList.getChildCount() <= IcsListPopupWindow.this.mListItemExpandMaximum) {
                IcsListPopupWindow.this.mPopup.setInputMethodMode(2);
                IcsListPopupWindow.this.show();
            }
        }
    }
}

