/*
 * Decompiled with CFR 0.152.
 */
package com.actionbarsherlock.internal.widget;

import android.content.Context;
import android.database.DataSetObserver;
import android.graphics.Rect;
import android.os.Build;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.util.SparseArray;
import android.view.View;
import android.view.ViewGroup;
import android.widget.SpinnerAdapter;
import com.actionbarsherlock.internal.widget.IcsAdapterView;

public abstract class IcsAbsSpinner
extends IcsAdapterView<SpinnerAdapter> {
    private static final boolean IS_HONEYCOMB;
    SpinnerAdapter mAdapter;
    boolean mBlockLayoutRequests;
    private DataSetObserver mDataSetObserver;
    int mHeightMeasureSpec;
    final RecycleBin mRecycler;
    int mSelectionBottomPadding = 0;
    int mSelectionLeftPadding = 0;
    int mSelectionRightPadding = 0;
    int mSelectionTopPadding = 0;
    final Rect mSpinnerPadding = new Rect();
    private Rect mTouchFrame;
    int mWidthMeasureSpec;

    /*
     * Enabled aggressive block sorting
     */
    static {
        boolean bl = Build.VERSION.SDK_INT >= 11;
        IS_HONEYCOMB = bl;
    }

    public IcsAbsSpinner(Context context) {
        super(context);
        this.mRecycler = new RecycleBin();
        this.initAbsSpinner();
    }

    public IcsAbsSpinner(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0);
    }

    public IcsAbsSpinner(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
        this.mRecycler = new RecycleBin();
        this.initAbsSpinner();
    }

    private void initAbsSpinner() {
        this.setFocusable(true);
        this.setWillNotDraw(false);
    }

    protected ViewGroup.LayoutParams generateDefaultLayoutParams() {
        return new ViewGroup.LayoutParams(-1, -2);
    }

    @Override
    public SpinnerAdapter getAdapter() {
        return this.mAdapter;
    }

    int getChildHeight(View view) {
        return view.getMeasuredHeight();
    }

    int getChildWidth(View view) {
        return view.getMeasuredWidth();
    }

    @Override
    public int getCount() {
        return this.mItemCount;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public View getSelectedView() {
        if (this.mItemCount <= 0) return null;
        if (this.mSelectedPosition < 0) return null;
        return this.getChildAt(this.mSelectedPosition - this.mFirstPosition);
    }

    abstract void layout(int var1, boolean var2);

    /*
     * Enabled aggressive block sorting
     */
    protected void onMeasure(int n, int n2) {
        int n3;
        int n4;
        int n5 = View.MeasureSpec.getMode((int)n);
        int n6 = this.getPaddingLeft();
        int n7 = this.getPaddingTop();
        int n8 = this.getPaddingRight();
        int n9 = this.getPaddingBottom();
        Rect rect = this.mSpinnerPadding;
        if (n6 <= this.mSelectionLeftPadding) {
            n6 = this.mSelectionLeftPadding;
        }
        rect.left = n6;
        Rect rect2 = this.mSpinnerPadding;
        if (n7 <= this.mSelectionTopPadding) {
            n7 = this.mSelectionTopPadding;
        }
        rect2.top = n7;
        Rect rect3 = this.mSpinnerPadding;
        if (n8 <= this.mSelectionRightPadding) {
            n8 = this.mSelectionRightPadding;
        }
        rect3.right = n8;
        Rect rect4 = this.mSpinnerPadding;
        if (n9 <= this.mSelectionBottomPadding) {
            n9 = this.mSelectionBottomPadding;
        }
        rect4.bottom = n9;
        if (this.mDataChanged) {
            this.handleDataChanged();
        }
        int n10 = 0;
        int n11 = 0;
        boolean bl = true;
        int n12 = this.getSelectedItemPosition();
        if (n12 >= 0 && this.mAdapter != null && n12 < this.mAdapter.getCount()) {
            View view = this.mRecycler.get(n12);
            if (view == null) {
                view = this.mAdapter.getView(n12, null, (ViewGroup)this);
            }
            if (view != null) {
                this.mRecycler.put(n12, view);
            }
            if (view != null) {
                if (view.getLayoutParams() == null) {
                    this.mBlockLayoutRequests = true;
                    view.setLayoutParams(this.generateDefaultLayoutParams());
                    this.mBlockLayoutRequests = false;
                }
                this.measureChild(view, n, n2);
                n10 = this.getChildHeight(view) + this.mSpinnerPadding.top + this.mSpinnerPadding.bottom;
                n11 = this.getChildWidth(view) + this.mSpinnerPadding.left + this.mSpinnerPadding.right;
                bl = false;
            }
        }
        if (bl) {
            n10 = this.mSpinnerPadding.top + this.mSpinnerPadding.bottom;
            if (n5 == 0) {
                n11 = this.mSpinnerPadding.left + this.mSpinnerPadding.right;
            }
        }
        int n13 = Math.max(n10, this.getSuggestedMinimumHeight());
        int n14 = Math.max(n11, this.getSuggestedMinimumWidth());
        if (IS_HONEYCOMB) {
            n4 = IcsAbsSpinner.resolveSizeAndState((int)n13, (int)n2, (int)0);
            n3 = IcsAbsSpinner.resolveSizeAndState((int)n14, (int)n, (int)0);
        } else {
            n4 = IcsAbsSpinner.resolveSize((int)n13, (int)n2);
            n3 = IcsAbsSpinner.resolveSize((int)n14, (int)n);
        }
        this.setMeasuredDimension(n3, n4);
        this.mHeightMeasureSpec = n2;
        this.mWidthMeasureSpec = n;
    }

    public void onRestoreInstanceState(Parcelable parcelable) {
        SavedState savedState = (SavedState)parcelable;
        super.onRestoreInstanceState(savedState.getSuperState());
        if (savedState.selectedId >= 0L) {
            this.mDataChanged = true;
            this.mNeedSync = true;
            this.mSyncRowId = savedState.selectedId;
            this.mSyncPosition = savedState.position;
            this.mSyncMode = 0;
            this.requestLayout();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Parcelable onSaveInstanceState() {
        SavedState savedState = new SavedState(super.onSaveInstanceState());
        savedState.selectedId = this.getSelectedItemId();
        if (savedState.selectedId >= 0L) {
            savedState.position = this.getSelectedItemPosition();
            return savedState;
        }
        savedState.position = -1;
        return savedState;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int pointToPosition(int n, int n2) {
        Rect rect = this.mTouchFrame;
        if (rect == null) {
            rect = this.mTouchFrame = new Rect();
        }
        int n3 = -1 + this.getChildCount();
        while (n3 >= 0) {
            View view = this.getChildAt(n3);
            if (view.getVisibility() == 0) {
                view.getHitRect(rect);
                if (rect.contains(n, n2)) {
                    return n3 + this.mFirstPosition;
                }
            }
            --n3;
        }
        return -1;
    }

    void recycleAllViews() {
        int n = this.getChildCount();
        RecycleBin recycleBin = this.mRecycler;
        int n2 = this.mFirstPosition;
        int n3 = 0;
        while (n3 < n) {
            View view = this.getChildAt(n3);
            recycleBin.put(n2 + n3, view);
            ++n3;
        }
        return;
    }

    public void requestLayout() {
        if (!this.mBlockLayoutRequests) {
            super.requestLayout();
        }
    }

    void resetList() {
        this.mDataChanged = false;
        this.mNeedSync = false;
        this.removeAllViewsInLayout();
        this.mOldSelectedPosition = -1;
        this.mOldSelectedRowId = Long.MIN_VALUE;
        this.setSelectedPositionInt(-1);
        this.setNextSelectedPositionInt(-1);
        this.invalidate();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void setAdapter(SpinnerAdapter spinnerAdapter) {
        int n = -1;
        if (this.mAdapter != null) {
            this.mAdapter.unregisterDataSetObserver(this.mDataSetObserver);
            this.resetList();
        }
        this.mAdapter = spinnerAdapter;
        this.mOldSelectedPosition = n;
        this.mOldSelectedRowId = Long.MIN_VALUE;
        if (this.mAdapter != null) {
            this.mOldItemCount = this.mItemCount;
            this.mItemCount = this.mAdapter.getCount();
            this.checkFocus();
            this.mDataSetObserver = new IcsAdapterView.AdapterDataSetObserver();
            this.mAdapter.registerDataSetObserver(this.mDataSetObserver);
            if (this.mItemCount > 0) {
                n = 0;
            }
            this.setSelectedPositionInt(n);
            this.setNextSelectedPositionInt(n);
            if (this.mItemCount == 0) {
                this.checkSelectionChanged();
            }
        } else {
            this.checkFocus();
            this.resetList();
            this.checkSelectionChanged();
        }
        this.requestLayout();
    }

    @Override
    public void setSelection(int n) {
        this.setNextSelectedPositionInt(n);
        this.requestLayout();
        this.invalidate();
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setSelection(int n, boolean bl) {
        boolean bl2 = bl && this.mFirstPosition <= n && n <= -1 + (this.mFirstPosition + this.getChildCount());
        this.setSelectionInt(n, bl2);
    }

    void setSelectionInt(int n, boolean bl) {
        if (n != this.mOldSelectedPosition) {
            this.mBlockLayoutRequests = true;
            int n2 = n - this.mSelectedPosition;
            this.setNextSelectedPositionInt(n);
            this.layout(n2, bl);
            this.mBlockLayoutRequests = false;
        }
    }

    class RecycleBin {
        private final SparseArray<View> mScrapHeap = new SparseArray();

        RecycleBin() {
        }

        void clear() {
            SparseArray<View> sparseArray = this.mScrapHeap;
            int n = sparseArray.size();
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    sparseArray.clear();
                    return;
                }
                View view = (View)sparseArray.valueAt(n2);
                if (view != null) {
                    IcsAbsSpinner.this.removeDetachedView(view, true);
                }
                ++n2;
            }
        }

        View get(int n) {
            View view = (View)this.mScrapHeap.get(n);
            if (view != null) {
                this.mScrapHeap.delete(n);
            }
            return view;
        }

        public void put(int n, View view) {
            this.mScrapHeap.put(n, (Object)view);
        }
    }

    static class SavedState
    extends View.BaseSavedState {
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            public SavedState createFromParcel(Parcel parcel) {
                return new SavedState(parcel);
            }

            public SavedState[] newArray(int n) {
                return new SavedState[n];
            }
        };
        int position;
        long selectedId;

        private SavedState(Parcel parcel) {
            super(parcel);
            this.selectedId = parcel.readLong();
            this.position = parcel.readInt();
        }

        SavedState(Parcelable parcelable) {
            super(parcelable);
        }

        public String toString() {
            return "AbsSpinner.SavedState{" + Integer.toHexString(System.identityHashCode((Object)this)) + " selectedId=" + this.selectedId + " position=" + this.position + "}";
        }

        public void writeToParcel(Parcel parcel, int n) {
            super.writeToParcel(parcel, n);
            parcel.writeLong(this.selectedId);
            parcel.writeInt(this.position);
        }
    }
}

