/*
 * Decompiled with CFR 0.152.
 */
package com.actionbarsherlock.internal.widget;

import android.content.Context;
import android.content.res.Configuration;
import android.content.res.TypedArray;
import android.os.Build;
import android.util.AttributeSet;
import android.view.View;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;
import com.actionbarsherlock.R;
import com.actionbarsherlock.internal.ResourcesCompat;
import com.actionbarsherlock.internal.nineoldandroids.animation.Animator;
import com.actionbarsherlock.internal.nineoldandroids.animation.AnimatorSet;
import com.actionbarsherlock.internal.nineoldandroids.animation.ObjectAnimator;
import com.actionbarsherlock.internal.nineoldandroids.view.NineViewGroup;
import com.actionbarsherlock.internal.view.menu.ActionMenuPresenter;
import com.actionbarsherlock.internal.view.menu.ActionMenuView;
import com.actionbarsherlock.internal.widget.ActionBarContainer;

public abstract class AbsActionBarView
extends NineViewGroup {
    private static final int FADE_DURATION = 200;
    private static final Interpolator sAlphaInterpolator = new DecelerateInterpolator();
    protected ActionMenuPresenter mActionMenuPresenter;
    protected int mContentHeight;
    final Context mContext;
    protected ActionMenuView mMenuView;
    protected boolean mSplitActionBar;
    protected ActionBarContainer mSplitView;
    protected boolean mSplitWhenNarrow;
    protected final VisibilityAnimListener mVisAnimListener = new VisibilityAnimListener();
    protected Animator mVisibilityAnim;

    public AbsActionBarView(Context context) {
        super(context);
        this.mContext = context;
    }

    public AbsActionBarView(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.mContext = context;
    }

    public AbsActionBarView(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
        this.mContext = context;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void animateToVisibility(int n) {
        if (this.mVisibilityAnim != null) {
            this.mVisibilityAnim.cancel();
        }
        if (n == 0) {
            if (this.getVisibility() != 0) {
                this.setAlpha(0.0f);
                if (this.mSplitView != null && this.mMenuView != null) {
                    this.mMenuView.setAlpha(0.0f);
                }
            }
            float[] fArray = new float[]{1.0f};
            ObjectAnimator objectAnimator = ObjectAnimator.ofFloat((Object)this, "alpha", fArray);
            objectAnimator.setDuration(200L);
            objectAnimator.setInterpolator(sAlphaInterpolator);
            if (this.mSplitView != null && this.mMenuView != null) {
                AnimatorSet animatorSet = new AnimatorSet();
                ActionMenuView actionMenuView = this.mMenuView;
                float[] fArray2 = new float[]{1.0f};
                ObjectAnimator objectAnimator2 = ObjectAnimator.ofFloat(actionMenuView, "alpha", fArray2);
                objectAnimator2.setDuration(200L);
                animatorSet.addListener(this.mVisAnimListener.withFinalVisibility(n));
                animatorSet.play(objectAnimator).with(objectAnimator2);
                animatorSet.start();
                return;
            }
            objectAnimator.addListener(this.mVisAnimListener.withFinalVisibility(n));
            objectAnimator.start();
            return;
        }
        float[] fArray = new float[]{0.0f};
        ObjectAnimator objectAnimator = ObjectAnimator.ofFloat((Object)this, "alpha", fArray);
        objectAnimator.setDuration(200L);
        objectAnimator.setInterpolator(sAlphaInterpolator);
        if (this.mSplitView != null && this.mMenuView != null) {
            AnimatorSet animatorSet = new AnimatorSet();
            ActionMenuView actionMenuView = this.mMenuView;
            float[] fArray3 = new float[]{0.0f};
            ObjectAnimator objectAnimator3 = ObjectAnimator.ofFloat(actionMenuView, "alpha", fArray3);
            objectAnimator3.setDuration(200L);
            animatorSet.addListener(this.mVisAnimListener.withFinalVisibility(n));
            animatorSet.play(objectAnimator).with(objectAnimator3);
            animatorSet.start();
            return;
        }
        objectAnimator.addListener(this.mVisAnimListener.withFinalVisibility(n));
        objectAnimator.start();
    }

    public void dismissPopupMenus() {
        if (this.mActionMenuPresenter != null) {
            this.mActionMenuPresenter.dismissPopupMenus();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getAnimatedVisibility() {
        if (this.mVisibilityAnim == null) return this.getVisibility();
        return this.mVisAnimListener.mFinalVisibility;
    }

    public int getContentHeight() {
        return this.mContentHeight;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean hideOverflowMenu() {
        if (this.mActionMenuPresenter == null) return false;
        return this.mActionMenuPresenter.hideOverflowMenu();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isOverflowMenuShowing() {
        if (this.mActionMenuPresenter == null) return false;
        return this.mActionMenuPresenter.isOverflowMenuShowing();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isOverflowReserved() {
        if (this.mActionMenuPresenter == null) return false;
        if (!this.mActionMenuPresenter.isOverflowReserved()) return false;
        return true;
    }

    protected int measureChildView(View view, int n, int n2, int n3) {
        view.measure(View.MeasureSpec.makeMeasureSpec((int)n, (int)Integer.MIN_VALUE), n2);
        return Math.max(0, n - view.getMeasuredWidth() - n3);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void onConfigurationChanged(Configuration configuration) {
        if (Build.VERSION.SDK_INT >= 8) {
            super.onConfigurationChanged(configuration);
        } else if (this.mMenuView != null) {
            this.mMenuView.onConfigurationChanged(configuration);
        }
        TypedArray typedArray = this.getContext().obtainStyledAttributes(null, R.styleable.SherlockActionBar, R.attr.actionBarStyle, 0);
        this.setContentHeight(typedArray.getLayoutDimension(4, 0));
        typedArray.recycle();
        if (this.mSplitWhenNarrow) {
            this.setSplitActionBar(ResourcesCompat.getResources_getBoolean(this.getContext(), R.bool.abs__split_action_bar_is_narrow));
        }
        if (this.mActionMenuPresenter != null) {
            this.mActionMenuPresenter.onConfigurationChanged(configuration);
        }
    }

    protected int positionChild(View view, int n, int n2, int n3) {
        int n4 = view.getMeasuredWidth();
        int n5 = view.getMeasuredHeight();
        int n6 = n2 + (n3 - n5) / 2;
        view.layout(n, n6, n + n4, n6 + n5);
        return n4;
    }

    protected int positionChildInverse(View view, int n, int n2, int n3) {
        int n4 = view.getMeasuredWidth();
        int n5 = view.getMeasuredHeight();
        int n6 = n2 + (n3 - n5) / 2;
        view.layout(n - n4, n6, n, n6 + n5);
        return n4;
    }

    public void postShowOverflowMenu() {
        this.post(new Runnable(){

            @Override
            public void run() {
                AbsActionBarView.this.showOverflowMenu();
            }
        });
    }

    public void setContentHeight(int n) {
        this.mContentHeight = n;
        this.requestLayout();
    }

    public void setSplitActionBar(boolean bl) {
        this.mSplitActionBar = bl;
    }

    public void setSplitView(ActionBarContainer actionBarContainer) {
        this.mSplitView = actionBarContainer;
    }

    public void setSplitWhenNarrow(boolean bl) {
        this.mSplitWhenNarrow = bl;
    }

    @Override
    public void setVisibility(int n) {
        if (this.mVisibilityAnim != null) {
            this.mVisibilityAnim.end();
        }
        super.setVisibility(n);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean showOverflowMenu() {
        if (this.mActionMenuPresenter == null) return false;
        return this.mActionMenuPresenter.showOverflowMenu();
    }

    protected class VisibilityAnimListener
    implements Animator.AnimatorListener {
        private boolean mCanceled = false;
        int mFinalVisibility;

        protected VisibilityAnimListener() {
        }

        @Override
        public void onAnimationCancel(Animator animator) {
            this.mCanceled = true;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void onAnimationEnd(Animator animator) {
            if (this.mCanceled) {
                return;
            }
            AbsActionBarView.this.mVisibilityAnim = null;
            AbsActionBarView.this.setVisibility(this.mFinalVisibility);
            if (AbsActionBarView.this.mSplitView == null) return;
            if (AbsActionBarView.this.mMenuView == null) return;
            AbsActionBarView.this.mMenuView.setVisibility(this.mFinalVisibility);
        }

        @Override
        public void onAnimationRepeat(Animator animator) {
        }

        @Override
        public void onAnimationStart(Animator animator) {
            AbsActionBarView.this.setVisibility(0);
            AbsActionBarView.this.mVisibilityAnim = animator;
            this.mCanceled = false;
        }

        public VisibilityAnimListener withFinalVisibility(int n) {
            this.mFinalVisibility = n;
            return this;
        }
    }
}

