/*
 * Decompiled with CFR 0.152.
 */
package com.actionbarsherlock.internal.view.menu;

import android.content.Context;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.os.Build;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.SparseBooleanArray;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.widget.ImageButton;
import com.actionbarsherlock.R;
import com.actionbarsherlock.internal.ResourcesCompat;
import com.actionbarsherlock.internal.view.View_HasStateListenerSupport;
import com.actionbarsherlock.internal.view.View_OnAttachStateChangeListener;
import com.actionbarsherlock.internal.view.menu.ActionMenuItemView;
import com.actionbarsherlock.internal.view.menu.ActionMenuView;
import com.actionbarsherlock.internal.view.menu.BaseMenuPresenter;
import com.actionbarsherlock.internal.view.menu.MenuBuilder;
import com.actionbarsherlock.internal.view.menu.MenuItemImpl;
import com.actionbarsherlock.internal.view.menu.MenuPopupHelper;
import com.actionbarsherlock.internal.view.menu.MenuPresenter;
import com.actionbarsherlock.internal.view.menu.MenuView;
import com.actionbarsherlock.internal.view.menu.SubMenuBuilder;
import com.actionbarsherlock.view.ActionProvider;
import com.actionbarsherlock.view.MenuItem;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class ActionMenuPresenter
extends BaseMenuPresenter
implements ActionProvider.SubUiVisibilityListener {
    private final SparseBooleanArray mActionButtonGroups = new SparseBooleanArray();
    private ActionButtonSubmenu mActionButtonPopup;
    private int mActionItemWidthLimit;
    private boolean mExpandedActionViewsExclusive;
    private int mMaxItems;
    private boolean mMaxItemsSet;
    private int mMinCellSize;
    int mOpenSubMenuId;
    private View mOverflowButton;
    private OverflowPopup mOverflowPopup;
    final PopupPresenterCallback mPopupPresenterCallback = new PopupPresenterCallback();
    private OpenOverflowRunnable mPostedOpenRunnable;
    private boolean mReserveOverflow;
    private boolean mReserveOverflowSet;
    private View mScrapActionButtonView;
    private boolean mStrictWidthLimit;
    private int mWidthLimit;
    private boolean mWidthLimitSet;

    public ActionMenuPresenter(Context context) {
        super(context, R.layout.abs__action_menu_layout, R.layout.abs__action_menu_item_layout);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private View findViewForItem(MenuItem menuItem) {
        ViewGroup viewGroup = (ViewGroup)this.mMenuView;
        if (viewGroup == null) {
            return null;
        }
        int n = viewGroup.getChildCount();
        int n2 = 0;
        while (n2 < n) {
            View view = viewGroup.getChildAt(n2);
            if (view instanceof MenuView.ItemView) {
                if (((MenuView.ItemView)view).getItemData() == menuItem) return view;
            }
            ++n2;
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean reserveOverflow(Context context) {
        boolean bl = true;
        boolean bl2 = false;
        TypedArray typedArray = context.getTheme().obtainStyledAttributes(R.styleable.SherlockTheme);
        boolean bl3 = typedArray.getBoolean(52, bl2);
        typedArray.recycle();
        if (bl3) {
            return bl;
        }
        if (Build.VERSION.SDK_INT < 14) {
            if (Build.VERSION.SDK_INT >= 11) return bl;
            return bl2;
        }
        if (!HasPermanentMenuKey.get(context)) return bl;
        return bl2;
    }

    @Override
    public void bindItemView(MenuItemImpl menuItemImpl, MenuView.ItemView itemView) {
        itemView.initialize(menuItemImpl, 0);
        ActionMenuView actionMenuView = (ActionMenuView)this.mMenuView;
        ((ActionMenuItemView)itemView).setItemInvoker(actionMenuView);
    }

    public boolean dismissPopupMenus() {
        return this.hideOverflowMenu() | this.hideSubMenus();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean filterLeftoverView(ViewGroup viewGroup, int n) {
        if (viewGroup.getChildAt(n) != this.mOverflowButton) return super.filterLeftoverView(viewGroup, n);
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean flagActionItems() {
        int n;
        int n2;
        SparseBooleanArray sparseBooleanArray;
        int n3;
        ArrayList<MenuItemImpl> arrayList = this.mMenu.getVisibleItems();
        int n4 = arrayList.size();
        int n5 = this.mMaxItems;
        int n6 = this.mActionItemWidthLimit;
        int n7 = View.MeasureSpec.makeMeasureSpec((int)0, (int)0);
        ViewGroup viewGroup = (ViewGroup)this.mMenuView;
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        boolean bl = false;
        int n11 = 0;
        while (true) {
            if (n11 >= n4) {
                if (this.mReserveOverflow && (bl || n8 + n9 > n5)) {
                    --n5;
                }
                n3 = n5 - n8;
                sparseBooleanArray = this.mActionButtonGroups;
                sparseBooleanArray.clear();
                n2 = 0;
                n = 0;
                if (this.mStrictWidthLimit) {
                    n = n6 / this.mMinCellSize;
                    int n12 = n6 % this.mMinCellSize;
                    n2 = this.mMinCellSize + n12 / n;
                }
                break;
            }
            MenuItemImpl menuItemImpl = arrayList.get(n11);
            if (menuItemImpl.requiresActionButton()) {
                ++n8;
            } else if (menuItemImpl.requestsActionButton()) {
                ++n9;
            } else {
                bl = true;
            }
            if (this.mExpandedActionViewsExclusive && menuItemImpl.isActionViewExpanded()) {
                n5 = 0;
            }
            ++n11;
        }
        int n13 = 0;
        while (n13 < n4) {
            MenuItemImpl menuItemImpl = arrayList.get(n13);
            if (menuItemImpl.requiresActionButton()) {
                int n14;
                View view = this.getItemView(menuItemImpl, this.mScrapActionButtonView, viewGroup);
                if (this.mScrapActionButtonView == null) {
                    this.mScrapActionButtonView = view;
                }
                if (this.mStrictWidthLimit) {
                    n -= ActionMenuView.measureChildForCells(view, n2, n, n7, 0);
                } else {
                    view.measure(n7, n7);
                }
                int n15 = view.getMeasuredWidth();
                n6 -= n15;
                if (n10 == 0) {
                    n10 = n15;
                }
                if ((n14 = menuItemImpl.getGroupId()) != 0) {
                    sparseBooleanArray.put(n14, true);
                }
                menuItemImpl.setIsActionButton(true);
            } else if (menuItemImpl.requestsActionButton()) {
                int n16 = menuItemImpl.getGroupId();
                boolean bl2 = sparseBooleanArray.get(n16);
                boolean bl3 = !(n3 <= 0 && !bl2 || n6 <= 0 || this.mStrictWidthLimit && n <= 0);
                if (bl3) {
                    View view = this.getItemView(menuItemImpl, this.mScrapActionButtonView, viewGroup);
                    if (this.mScrapActionButtonView == null) {
                        this.mScrapActionButtonView = view;
                    }
                    if (this.mStrictWidthLimit) {
                        int n17 = ActionMenuView.measureChildForCells(view, n2, n, n7, 0);
                        n -= n17;
                        if (n17 == 0) {
                            bl3 = false;
                        }
                    } else {
                        view.measure(n7, n7);
                    }
                    int n18 = view.getMeasuredWidth();
                    n6 -= n18;
                    if (n10 == 0) {
                        n10 = n18;
                    }
                    if (this.mStrictWidthLimit) {
                        boolean bl4 = n6 >= 0;
                        bl3 &= bl4;
                    } else {
                        boolean bl5 = n6 + n10 > 0;
                        bl3 &= bl5;
                    }
                }
                if (bl3 && n16 != 0) {
                    sparseBooleanArray.put(n16, true);
                } else if (bl2) {
                    sparseBooleanArray.put(n16, false);
                    for (int i = 0; i < n13; ++i) {
                        MenuItemImpl menuItemImpl2 = arrayList.get(i);
                        if (menuItemImpl2.getGroupId() != n16) continue;
                        if (menuItemImpl2.isActionButton()) {
                            ++n3;
                        }
                        menuItemImpl2.setIsActionButton(false);
                    }
                }
                if (bl3) {
                    --n3;
                }
                menuItemImpl.setIsActionButton(bl3);
            }
            ++n13;
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public View getItemView(MenuItemImpl menuItemImpl, View view, ViewGroup viewGroup) {
        View view2 = menuItemImpl.getActionView();
        if (view2 == null || menuItemImpl.hasCollapsibleActionView()) {
            if (!(view instanceof ActionMenuItemView)) {
                view = null;
            }
            view2 = super.getItemView(menuItemImpl, view, viewGroup);
        }
        int n = menuItemImpl.isActionViewExpanded() ? 8 : 0;
        view2.setVisibility(n);
        ActionMenuView actionMenuView = (ActionMenuView)viewGroup;
        ViewGroup.LayoutParams layoutParams = view2.getLayoutParams();
        if (!actionMenuView.checkLayoutParams(layoutParams)) {
            view2.setLayoutParams((ViewGroup.LayoutParams)actionMenuView.generateLayoutParams(layoutParams));
        }
        return view2;
    }

    @Override
    public MenuView getMenuView(ViewGroup viewGroup) {
        MenuView menuView = super.getMenuView(viewGroup);
        ((ActionMenuView)menuView).setPresenter(this);
        return menuView;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean hideOverflowMenu() {
        if (this.mPostedOpenRunnable != null && this.mMenuView != null) {
            ((View)this.mMenuView).removeCallbacks((Runnable)this.mPostedOpenRunnable);
            this.mPostedOpenRunnable = null;
            return true;
        }
        OverflowPopup overflowPopup = this.mOverflowPopup;
        if (overflowPopup == null) return false;
        overflowPopup.dismiss();
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean hideSubMenus() {
        if (this.mActionButtonPopup == null) return false;
        this.mActionButtonPopup.dismiss();
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void initForMenu(Context context, MenuBuilder menuBuilder) {
        super.initForMenu(context, menuBuilder);
        Resources resources = context.getResources();
        if (!this.mReserveOverflowSet) {
            this.mReserveOverflow = ActionMenuPresenter.reserveOverflow(this.mContext);
        }
        if (!this.mWidthLimitSet) {
            this.mWidthLimit = resources.getDisplayMetrics().widthPixels / 2;
        }
        if (!this.mMaxItemsSet) {
            this.mMaxItems = ResourcesCompat.getResources_getInteger(context, R.integer.abs__max_action_buttons);
        }
        int n = this.mWidthLimit;
        if (this.mReserveOverflow) {
            if (this.mOverflowButton == null) {
                this.mOverflowButton = new OverflowMenuButton(this.mSystemContext);
                int n2 = View.MeasureSpec.makeMeasureSpec((int)0, (int)0);
                this.mOverflowButton.measure(n2, n2);
            }
            n -= this.mOverflowButton.getMeasuredWidth();
        } else {
            this.mOverflowButton = null;
        }
        this.mActionItemWidthLimit = n;
        this.mMinCellSize = (int)(56.0f * resources.getDisplayMetrics().density);
        this.mScrapActionButtonView = null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isOverflowMenuShowing() {
        if (this.mOverflowPopup == null) return false;
        if (!this.mOverflowPopup.isShowing()) return false;
        return true;
    }

    public boolean isOverflowReserved() {
        return this.mReserveOverflow;
    }

    @Override
    public void onCloseMenu(MenuBuilder menuBuilder, boolean bl) {
        this.dismissPopupMenus();
        super.onCloseMenu(menuBuilder, bl);
    }

    public void onConfigurationChanged(Configuration configuration) {
        if (!this.mMaxItemsSet) {
            this.mMaxItems = ResourcesCompat.getResources_getInteger(this.mContext, R.integer.abs__max_action_buttons);
            if (this.mMenu != null) {
                this.mMenu.onItemsChanged(true);
            }
        }
    }

    @Override
    public void onRestoreInstanceState(Parcelable parcelable) {
        MenuItem menuItem;
        SavedState savedState = (SavedState)parcelable;
        if (savedState.openSubMenuId > 0 && (menuItem = this.mMenu.findItem(savedState.openSubMenuId)) != null) {
            this.onSubMenuSelected((SubMenuBuilder)menuItem.getSubMenu());
        }
    }

    @Override
    public Parcelable onSaveInstanceState() {
        SavedState savedState = new SavedState();
        savedState.openSubMenuId = this.mOpenSubMenuId;
        return savedState;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean onSubMenuSelected(SubMenuBuilder subMenuBuilder) {
        boolean bl = false;
        if (!subMenuBuilder.hasVisibleItems()) {
            return bl;
        }
        SubMenuBuilder subMenuBuilder2 = subMenuBuilder;
        while (true) {
            if (subMenuBuilder2.getParentMenu() == this.mMenu) {
                View view = this.findViewForItem(subMenuBuilder2.getItem());
                if (view == null) {
                    if (this.mOverflowButton == null) return bl;
                    view = this.mOverflowButton;
                }
                this.mOpenSubMenuId = subMenuBuilder.getItem().getItemId();
                this.mActionButtonPopup = new ActionButtonSubmenu(this.mContext, subMenuBuilder);
                this.mActionButtonPopup.setAnchorView(view);
                this.mActionButtonPopup.show();
                super.onSubMenuSelected(subMenuBuilder);
                return true;
            }
            subMenuBuilder2 = (SubMenuBuilder)subMenuBuilder2.getParentMenu();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void onSubUiVisibilityChanged(boolean bl) {
        if (bl) {
            super.onSubMenuSelected(null);
            return;
        }
        this.mMenu.close(false);
    }

    public void setExpandedActionViewsExclusive(boolean bl) {
        this.mExpandedActionViewsExclusive = bl;
    }

    public void setItemLimit(int n) {
        this.mMaxItems = n;
        this.mMaxItemsSet = true;
    }

    public void setReserveOverflow(boolean bl) {
        this.mReserveOverflow = bl;
        this.mReserveOverflowSet = true;
    }

    public void setWidthLimit(int n, boolean bl) {
        this.mWidthLimit = n;
        this.mStrictWidthLimit = bl;
        this.mWidthLimitSet = true;
    }

    @Override
    public boolean shouldIncludeItem(int n, MenuItemImpl menuItemImpl) {
        return menuItemImpl.isActionButton();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean showOverflowMenu() {
        boolean bl = true;
        if (!this.mReserveOverflow) return false;
        if (this.isOverflowMenuShowing()) return false;
        if (this.mMenu == null) return false;
        if (this.mMenuView == null) return false;
        if (this.mPostedOpenRunnable != null) return false;
        if (this.mMenu.getNonActionItems().isEmpty()) return false;
        this.mPostedOpenRunnable = new OpenOverflowRunnable(new OverflowPopup(this.mContext, this.mMenu, this.mOverflowButton, bl));
        ((View)this.mMenuView).post((Runnable)this.mPostedOpenRunnable);
        super.onSubMenuSelected(null);
        return bl;
    }

    /*
     * Handled impossible loop by adding 'first' condition
     * Enabled aggressive block sorting
     */
    @Override
    public void updateMenuView(boolean bl) {
        boolean bl2;
        block11: {
            int n;
            super.updateMenuView(bl);
            boolean bl3 = true;
            while (true) {
                int n2;
                ArrayList<MenuItemImpl> arrayList;
                block14: {
                    block13: {
                        int n3;
                        block12: {
                            if (!bl3 || (bl3 = false)) break block12;
                            if (this.mMenu == null) break block13;
                            arrayList = this.mMenu.getActionItems();
                            n3 = arrayList.size();
                            n2 = 0;
                        }
                        if (n2 < n3) break block14;
                    }
                    ArrayList<MenuItemImpl> arrayList2 = this.mMenu != null ? this.mMenu.getNonActionItems() : null;
                    bl2 = false;
                    if (this.mReserveOverflow && arrayList2 != null) {
                        n = arrayList2.size();
                        if (n != 1) break;
                        bl2 = !arrayList2.get(0).isActionViewExpanded();
                    }
                    break block11;
                }
                ActionProvider actionProvider = arrayList.get(n2).getActionProvider();
                if (actionProvider != null) {
                    actionProvider.setSubUiVisibilityListener(this);
                }
                ++n2;
            }
            bl2 = n > 0;
        }
        if (bl2) {
            ViewGroup viewGroup;
            if (this.mOverflowButton == null) {
                this.mOverflowButton = new OverflowMenuButton(this.mSystemContext);
            }
            if ((viewGroup = (ViewGroup)this.mOverflowButton.getParent()) != this.mMenuView) {
                if (viewGroup != null) {
                    viewGroup.removeView(this.mOverflowButton);
                }
                ActionMenuView actionMenuView = (ActionMenuView)this.mMenuView;
                actionMenuView.addView(this.mOverflowButton, (ViewGroup.LayoutParams)actionMenuView.generateOverflowButtonLayoutParams());
            }
        } else if (this.mOverflowButton != null && this.mOverflowButton.getParent() == this.mMenuView) {
            ((ViewGroup)this.mMenuView).removeView(this.mOverflowButton);
        }
        ((ActionMenuView)this.mMenuView).setOverflowReserved(this.mReserveOverflow);
    }

    private class ActionButtonSubmenu
    extends MenuPopupHelper {
        /*
         * Enabled aggressive block sorting
         */
        public ActionButtonSubmenu(Context context, SubMenuBuilder subMenuBuilder) {
            super(context, subMenuBuilder);
            if (!((MenuItemImpl)subMenuBuilder.getItem()).isActionButton()) {
                View view = ActionMenuPresenter.this.mOverflowButton == null ? (View)ActionMenuPresenter.this.mMenuView : ActionMenuPresenter.this.mOverflowButton;
                this.setAnchorView(view);
            }
            this.setCallback(ActionMenuPresenter.this.mPopupPresenterCallback);
            boolean bl = false;
            int n = subMenuBuilder.size();
            int n2 = 0;
            while (true) {
                block6: {
                    block5: {
                        if (n2 >= n) break block5;
                        MenuItem menuItem = subMenuBuilder.getItem(n2);
                        if (!menuItem.isVisible() || menuItem.getIcon() == null) break block6;
                        bl = true;
                    }
                    this.setForceShowIcon(bl);
                    return;
                }
                ++n2;
            }
        }

        @Override
        public void onDismiss() {
            super.onDismiss();
            ActionMenuPresenter.this.mActionButtonPopup = null;
            ActionMenuPresenter.this.mOpenSubMenuId = 0;
        }
    }

    private static class HasPermanentMenuKey {
        private HasPermanentMenuKey() {
        }

        public static boolean get(Context context) {
            return ViewConfiguration.get((Context)context).hasPermanentMenuKey();
        }
    }

    private class OpenOverflowRunnable
    implements Runnable {
        private OverflowPopup mPopup;

        public OpenOverflowRunnable(OverflowPopup overflowPopup) {
            this.mPopup = overflowPopup;
        }

        @Override
        public void run() {
            ActionMenuPresenter.this.mMenu.changeMenuMode();
            View view = (View)ActionMenuPresenter.this.mMenuView;
            if (view != null && view.getWindowToken() != null && this.mPopup.tryShow()) {
                ActionMenuPresenter.this.mOverflowPopup = this.mPopup;
            }
            ActionMenuPresenter.this.mPostedOpenRunnable = null;
        }
    }

    private class OverflowMenuButton
    extends ImageButton
    implements ActionMenuView.ActionMenuChildView,
    View_HasStateListenerSupport {
        private final Set<View_OnAttachStateChangeListener> mListeners;

        public OverflowMenuButton(Context context) {
            super(context, null, R.attr.actionOverflowButtonStyle);
            this.mListeners = new HashSet<View_OnAttachStateChangeListener>();
            this.setClickable(true);
            this.setFocusable(true);
            this.setVisibility(0);
            this.setEnabled(true);
        }

        @Override
        public void addOnAttachStateChangeListener(View_OnAttachStateChangeListener view_OnAttachStateChangeListener) {
            this.mListeners.add(view_OnAttachStateChangeListener);
        }

        @Override
        public boolean needsDividerAfter() {
            return false;
        }

        @Override
        public boolean needsDividerBefore() {
            return false;
        }

        protected void onAttachedToWindow() {
            super.onAttachedToWindow();
            Iterator<View_OnAttachStateChangeListener> iterator = this.mListeners.iterator();
            while (iterator.hasNext()) {
                iterator.next().onViewAttachedToWindow((View)this);
            }
            return;
        }

        protected void onDetachedFromWindow() {
            super.onDetachedFromWindow();
            Iterator<View_OnAttachStateChangeListener> iterator = this.mListeners.iterator();
            while (iterator.hasNext()) {
                iterator.next().onViewDetachedFromWindow((View)this);
            }
            return;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean performClick() {
            if (super.performClick()) {
                return true;
            }
            this.playSoundEffect(0);
            ActionMenuPresenter.this.showOverflowMenu();
            return true;
        }

        @Override
        public void removeOnAttachStateChangeListener(View_OnAttachStateChangeListener view_OnAttachStateChangeListener) {
            this.mListeners.remove(view_OnAttachStateChangeListener);
        }
    }

    private class OverflowPopup
    extends MenuPopupHelper {
        public OverflowPopup(Context context, MenuBuilder menuBuilder, View view, boolean bl) {
            super(context, menuBuilder, view, bl);
            this.setCallback(ActionMenuPresenter.this.mPopupPresenterCallback);
        }

        @Override
        public void onDismiss() {
            super.onDismiss();
            ActionMenuPresenter.this.mMenu.close();
            ActionMenuPresenter.this.mOverflowPopup = null;
        }
    }

    private class PopupPresenterCallback
    implements MenuPresenter.Callback {
        private PopupPresenterCallback() {
        }

        @Override
        public void onCloseMenu(MenuBuilder menuBuilder, boolean bl) {
            if (menuBuilder instanceof SubMenuBuilder) {
                ((SubMenuBuilder)menuBuilder).getRootMenu().close(false);
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean onOpenSubMenu(MenuBuilder menuBuilder) {
            if (menuBuilder == null) {
                return false;
            }
            ActionMenuPresenter.this.mOpenSubMenuId = ((SubMenuBuilder)menuBuilder).getItem().getItemId();
            return false;
        }
    }

    private static class SavedState
    implements Parcelable {
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            public SavedState createFromParcel(Parcel parcel) {
                return new SavedState(parcel);
            }

            public SavedState[] newArray(int n) {
                return new SavedState[n];
            }
        };
        public int openSubMenuId;

        SavedState() {
        }

        SavedState(Parcel parcel) {
            this.openSubMenuId = parcel.readInt();
        }

        public int describeContents() {
            return 0;
        }

        public void writeToParcel(Parcel parcel, int n) {
            parcel.writeInt(this.openSubMenuId);
        }
    }
}

