/*
 * Decompiled with CFR 0.152.
 */
package com.actionbarsherlock.internal.nineoldandroids.view.animation;

import android.graphics.Matrix;
import android.graphics.RectF;
import android.os.Build;
import android.util.FloatMath;
import android.view.View;
import android.view.animation.Animation;
import android.view.animation.Transformation;
import java.lang.ref.WeakReference;
import java.util.WeakHashMap;

public final class AnimatorProxy
extends Animation {
    public static final boolean NEEDS_PROXY;
    private static final WeakHashMap<View, AnimatorProxy> PROXIES;
    private final RectF mAfter;
    private float mAlpha = 1.0f;
    private final RectF mBefore = new RectF();
    private float mScaleX = 1.0f;
    private float mScaleY = 1.0f;
    private final Matrix mTempMatrix;
    private float mTranslationX;
    private float mTranslationY;
    private final WeakReference<View> mView;

    /*
     * Enabled aggressive block sorting
     */
    static {
        boolean bl = Build.VERSION.SDK_INT < 11;
        NEEDS_PROXY = bl;
        PROXIES = new WeakHashMap();
    }

    private AnimatorProxy(View view) {
        this.mAfter = new RectF();
        this.mTempMatrix = new Matrix();
        this.setDuration(0L);
        this.setFillAfter(true);
        view.setAnimation((Animation)this);
        this.mView = new WeakReference<View>(view);
    }

    private void computeRect(RectF rectF, View view) {
        rectF.set(0.0f, 0.0f, (float)view.getWidth(), (float)view.getHeight());
        Matrix matrix = this.mTempMatrix;
        matrix.reset();
        this.transformMatrix(matrix, view);
        this.mTempMatrix.mapRect(rectF);
        rectF.offset((float)view.getLeft(), (float)view.getTop());
        if (rectF.right < rectF.left) {
            float f = rectF.right;
            rectF.right = rectF.left;
            rectF.left = f;
        }
        if (rectF.bottom < rectF.top) {
            float f = rectF.top;
            rectF.top = rectF.bottom;
            rectF.bottom = f;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void invalidateAfterUpdate() {
        View view = (View)this.mView.get();
        if (view == null) {
            return;
        }
        View view2 = (View)view.getParent();
        if (view2 == null) return;
        view.setAnimation((Animation)this);
        RectF rectF = this.mAfter;
        this.computeRect(rectF, view);
        rectF.union(this.mBefore);
        view2.invalidate((int)FloatMath.floor((float)rectF.left), (int)FloatMath.floor((float)rectF.top), (int)FloatMath.ceil((float)rectF.right), (int)FloatMath.ceil((float)rectF.bottom));
    }

    private void prepareForUpdate() {
        View view = (View)this.mView.get();
        if (view != null) {
            this.computeRect(this.mBefore, view);
        }
    }

    private void transformMatrix(Matrix matrix, View view) {
        float f = view.getWidth();
        float f2 = view.getHeight();
        float f3 = this.mScaleX;
        float f4 = this.mScaleY;
        if (f3 != 1.0f || f4 != 1.0f) {
            float f5 = (f3 * f - f) / 2.0f;
            float f6 = (f4 * f2 - f2) / 2.0f;
            matrix.postScale(f3, f4);
            matrix.postTranslate(-f5, -f6);
        }
        matrix.postTranslate(this.mTranslationX, this.mTranslationY);
    }

    public static AnimatorProxy wrap(View view) {
        AnimatorProxy animatorProxy = PROXIES.get(view);
        if (animatorProxy == null) {
            animatorProxy = new AnimatorProxy(view);
            PROXIES.put(view, animatorProxy);
        }
        return animatorProxy;
    }

    protected void applyTransformation(float f, Transformation transformation) {
        View view = (View)this.mView.get();
        if (view != null) {
            transformation.setAlpha(this.mAlpha);
            this.transformMatrix(transformation.getMatrix(), view);
        }
    }

    public float getAlpha() {
        return this.mAlpha;
    }

    public float getScaleX() {
        return this.mScaleX;
    }

    public float getScaleY() {
        return this.mScaleY;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getScrollX() {
        View view = (View)this.mView.get();
        if (view != null) return view.getScrollX();
        return 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getScrollY() {
        View view = (View)this.mView.get();
        if (view != null) return view.getScrollY();
        return 0;
    }

    public float getTranslationX() {
        return this.mTranslationX;
    }

    public float getTranslationY() {
        return this.mTranslationY;
    }

    public void reset() {
    }

    public void setAlpha(float f) {
        if (this.mAlpha != f) {
            this.mAlpha = f;
            View view = (View)this.mView.get();
            if (view != null) {
                view.invalidate();
            }
        }
    }

    public void setScaleX(float f) {
        if (this.mScaleX != f) {
            this.prepareForUpdate();
            this.mScaleX = f;
            this.invalidateAfterUpdate();
        }
    }

    public void setScaleY(float f) {
        if (this.mScaleY != f) {
            this.prepareForUpdate();
            this.mScaleY = f;
            this.invalidateAfterUpdate();
        }
    }

    public void setScrollX(int n) {
        View view = (View)this.mView.get();
        if (view != null) {
            view.scrollTo(n, view.getScrollY());
        }
    }

    public void setScrollY(int n) {
        View view = (View)this.mView.get();
        if (view != null) {
            view.scrollTo(view.getScrollY(), n);
        }
    }

    public void setTranslationX(float f) {
        if (this.mTranslationX != f) {
            this.prepareForUpdate();
            this.mTranslationX = f;
            this.invalidateAfterUpdate();
        }
    }

    public void setTranslationY(float f) {
        if (this.mTranslationY != f) {
            this.prepareForUpdate();
            this.mTranslationY = f;
            this.invalidateAfterUpdate();
        }
    }
}

