/*
 * Decompiled with CFR 0.152.
 */
package com.actionbarsherlock.internal.nineoldandroids.animation;

import android.view.animation.Interpolator;

public abstract class Keyframe
implements Cloneable {
    float mFraction;
    boolean mHasValue = false;
    private Interpolator mInterpolator = null;
    Class mValueType;

    public static Keyframe ofFloat(float f) {
        return new FloatKeyframe(f);
    }

    public static Keyframe ofFloat(float f, float f2) {
        return new FloatKeyframe(f, f2);
    }

    public static Keyframe ofInt(float f) {
        return new IntKeyframe(f);
    }

    public static Keyframe ofInt(float f, int n) {
        return new IntKeyframe(f, n);
    }

    public static Keyframe ofObject(float f) {
        return new ObjectKeyframe(f, null);
    }

    public static Keyframe ofObject(float f, Object object) {
        return new ObjectKeyframe(f, object);
    }

    public abstract Keyframe clone();

    public float getFraction() {
        return this.mFraction;
    }

    public Interpolator getInterpolator() {
        return this.mInterpolator;
    }

    public Class getType() {
        return this.mValueType;
    }

    public abstract Object getValue();

    public boolean hasValue() {
        return this.mHasValue;
    }

    public void setFraction(float f) {
        this.mFraction = f;
    }

    public void setInterpolator(Interpolator interpolator) {
        this.mInterpolator = interpolator;
    }

    public abstract void setValue(Object var1);

    static class FloatKeyframe
    extends Keyframe {
        float mValue;

        FloatKeyframe(float f) {
            this.mFraction = f;
            this.mValueType = Float.TYPE;
        }

        FloatKeyframe(float f, float f2) {
            this.mFraction = f;
            this.mValue = f2;
            this.mValueType = Float.TYPE;
            this.mHasValue = true;
        }

        @Override
        public FloatKeyframe clone() {
            FloatKeyframe floatKeyframe = new FloatKeyframe(this.getFraction(), this.mValue);
            floatKeyframe.setInterpolator(this.getInterpolator());
            return floatKeyframe;
        }

        public float getFloatValue() {
            return this.mValue;
        }

        @Override
        public Object getValue() {
            return Float.valueOf(this.mValue);
        }

        @Override
        public void setValue(Object object) {
            if (object != null && object.getClass() == Float.class) {
                this.mValue = ((Float)object).floatValue();
                this.mHasValue = true;
            }
        }
    }

    static class IntKeyframe
    extends Keyframe {
        int mValue;

        IntKeyframe(float f) {
            this.mFraction = f;
            this.mValueType = Integer.TYPE;
        }

        IntKeyframe(float f, int n) {
            this.mFraction = f;
            this.mValue = n;
            this.mValueType = Integer.TYPE;
            this.mHasValue = true;
        }

        @Override
        public IntKeyframe clone() {
            IntKeyframe intKeyframe = new IntKeyframe(this.getFraction(), this.mValue);
            intKeyframe.setInterpolator(this.getInterpolator());
            return intKeyframe;
        }

        public int getIntValue() {
            return this.mValue;
        }

        @Override
        public Object getValue() {
            return this.mValue;
        }

        @Override
        public void setValue(Object object) {
            if (object != null && object.getClass() == Integer.class) {
                this.mValue = (Integer)object;
                this.mHasValue = true;
            }
        }
    }

    static class ObjectKeyframe
    extends Keyframe {
        Object mValue;

        /*
         * WARNING - void declaration
         * Enabled aggressive block sorting
         */
        ObjectKeyframe(float f, Object object) {
            void var4_5;
            this.mFraction = f;
            this.mValue = object;
            boolean bl = object != null;
            this.mHasValue = bl;
            if (this.mHasValue) {
                Class<?> clazz = object.getClass();
            } else {
                Class<Object> clazz = Object.class;
            }
            this.mValueType = var4_5;
        }

        @Override
        public ObjectKeyframe clone() {
            ObjectKeyframe objectKeyframe = new ObjectKeyframe(this.getFraction(), this.mValue);
            objectKeyframe.setInterpolator(this.getInterpolator());
            return objectKeyframe;
        }

        @Override
        public Object getValue() {
            return this.mValue;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void setValue(Object object) {
            this.mValue = object;
            boolean bl = object != null;
            this.mHasValue = bl;
        }
    }
}

