/*
 * Decompiled with CFR 0.152.
 */
package com.actionbarsherlock.internal.app;

import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import android.content.res.Configuration;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Handler;
import android.support.v4.app.FragmentTransaction;
import android.util.TypedValue;
import android.view.ContextThemeWrapper;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.SpinnerAdapter;
import com.actionbarsherlock.R;
import com.actionbarsherlock.app.ActionBar;
import com.actionbarsherlock.app.SherlockFragmentActivity;
import com.actionbarsherlock.internal.ResourcesCompat;
import com.actionbarsherlock.internal.nineoldandroids.animation.Animator;
import com.actionbarsherlock.internal.nineoldandroids.animation.AnimatorListenerAdapter;
import com.actionbarsherlock.internal.nineoldandroids.animation.AnimatorSet;
import com.actionbarsherlock.internal.nineoldandroids.animation.ObjectAnimator;
import com.actionbarsherlock.internal.nineoldandroids.widget.NineFrameLayout;
import com.actionbarsherlock.internal.view.menu.MenuBuilder;
import com.actionbarsherlock.internal.view.menu.MenuPopupHelper;
import com.actionbarsherlock.internal.view.menu.SubMenuBuilder;
import com.actionbarsherlock.internal.widget.ActionBarContainer;
import com.actionbarsherlock.internal.widget.ActionBarContextView;
import com.actionbarsherlock.internal.widget.ActionBarView;
import com.actionbarsherlock.internal.widget.ScrollingTabContainerView;
import com.actionbarsherlock.view.ActionMode;
import com.actionbarsherlock.view.Menu;
import com.actionbarsherlock.view.MenuInflater;
import com.actionbarsherlock.view.MenuItem;
import java.lang.ref.WeakReference;
import java.util.ArrayList;

public class ActionBarImpl
extends ActionBar {
    private static final int CONTEXT_DISPLAY_NORMAL = 0;
    private static final int CONTEXT_DISPLAY_SPLIT = 1;
    private static final int INVALID_POSITION = -1;
    ActionModeImpl mActionMode;
    private ActionBarView mActionView;
    private Activity mActivity;
    private ActionBarContainer mContainerView;
    private NineFrameLayout mContentView;
    private Context mContext;
    private int mContextDisplayMode;
    private ActionBarContextView mContextView;
    private Animator mCurrentModeAnim;
    private Animator mCurrentShowAnim;
    ActionMode mDeferredDestroyActionMode;
    ActionMode.Callback mDeferredModeDestroyCallback;
    final Handler mHandler;
    private boolean mHasEmbeddedTabs;
    final Animator.AnimatorListener mHideListener;
    private boolean mLastMenuVisibility;
    private ArrayList<ActionBar.OnMenuVisibilityListener> mMenuVisibilityListeners;
    private int mSavedTabPosition = -1;
    private TabImpl mSelectedTab;
    private boolean mShowHideAnimationEnabled;
    final Animator.AnimatorListener mShowListener;
    private ActionBarContainer mSplitView;
    private ScrollingTabContainerView mTabScrollView;
    Runnable mTabSelector;
    private ArrayList<TabImpl> mTabs = new ArrayList();
    private Context mThemedContext;
    boolean mWasHiddenBeforeMode;

    public ActionBarImpl(Activity activity, int n) {
        this.mMenuVisibilityListeners = new ArrayList();
        this.mHandler = new Handler();
        this.mHideListener = new AnimatorListenerAdapter(){

            @Override
            public void onAnimationEnd(Animator animator) {
                if (ActionBarImpl.this.mContentView != null) {
                    ActionBarImpl.this.mContentView.setTranslationY(0.0f);
                    ActionBarImpl.this.mContainerView.setTranslationY(0.0f);
                }
                if (ActionBarImpl.this.mSplitView != null && ActionBarImpl.this.mContextDisplayMode == 1) {
                    ActionBarImpl.this.mSplitView.setVisibility(8);
                }
                ActionBarImpl.this.mContainerView.setVisibility(8);
                ActionBarImpl.this.mContainerView.setTransitioning(false);
                ActionBarImpl.this.mCurrentShowAnim = null;
                ActionBarImpl.this.completeDeferredDestroyActionMode();
            }
        };
        this.mShowListener = new AnimatorListenerAdapter(){

            @Override
            public void onAnimationEnd(Animator animator) {
                ActionBarImpl.this.mCurrentShowAnim = null;
                ActionBarImpl.this.mContainerView.requestLayout();
            }
        };
        this.mActivity = activity;
        View view = activity.getWindow().getDecorView();
        this.init(view);
        if ((n & 0x200) == 0) {
            this.mContentView = (NineFrameLayout)view.findViewById(0x1020002);
        }
    }

    public ActionBarImpl(Dialog dialog) {
        this.mMenuVisibilityListeners = new ArrayList();
        this.mHandler = new Handler();
        this.mHideListener = new /* invalid duplicate definition of identical inner class */;
        this.mShowListener = new /* invalid duplicate definition of identical inner class */;
        this.init(dialog.getWindow().getDecorView());
    }

    private void cleanupTabs() {
        if (this.mSelectedTab != null) {
            this.selectTab(null);
        }
        this.mTabs.clear();
        if (this.mTabScrollView != null) {
            this.mTabScrollView.removeAllTabs();
        }
        this.mSavedTabPosition = -1;
    }

    private void configureTab(ActionBar.Tab tab, int n) {
        TabImpl tabImpl = (TabImpl)tab;
        if (tabImpl.getCallback() == null) {
            throw new IllegalStateException("Action Bar Tab must have a Callback");
        }
        tabImpl.setPosition(n);
        this.mTabs.add(n, tabImpl);
        int n2 = this.mTabs.size();
        int n3 = n + 1;
        while (n3 < n2) {
            this.mTabs.get(n3).setPosition(n3);
            ++n3;
        }
        return;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void ensureTabsExist() {
        int n = 0;
        if (this.mTabScrollView != null) {
            return;
        }
        ScrollingTabContainerView scrollingTabContainerView = new ScrollingTabContainerView(this.mContext);
        if (this.mHasEmbeddedTabs) {
            scrollingTabContainerView.setVisibility(n);
            this.mActionView.setEmbeddedTabView(scrollingTabContainerView);
        } else {
            if (this.getNavigationMode() != 2) {
                n = 8;
            }
            scrollingTabContainerView.setVisibility(n);
            this.mContainerView.setTabContainer(scrollingTabContainerView);
        }
        this.mTabScrollView = scrollingTabContainerView;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void init(View view) {
        boolean bl = true;
        this.mContext = view.getContext();
        this.mActionView = (ActionBarView)view.findViewById(R.id.abs__action_bar);
        this.mContextView = (ActionBarContextView)view.findViewById(R.id.abs__action_context_bar);
        this.mContainerView = (ActionBarContainer)view.findViewById(R.id.abs__action_bar_container);
        this.mSplitView = (ActionBarContainer)view.findViewById(R.id.abs__split_action_bar);
        if (this.mActionView == null || this.mContextView == null || this.mContainerView == null) {
            throw new IllegalStateException(String.valueOf(this.getClass().getSimpleName()) + " can only be used " + "with a compatible window decor layout");
        }
        this.mActionView.setContextView(this.mContextView);
        boolean bl2 = this.mActionView.isSplitActionBar() ? bl : false;
        this.mContextDisplayMode = bl2;
        if (this.mContext.getApplicationInfo().targetSdkVersion >= 14) {
            bl = false;
        }
        this.setHomeButtonEnabled(bl);
        this.setHasEmbeddedTabs(ResourcesCompat.getResources_getBoolean(this.mContext, R.bool.abs__action_bar_embed_tabs));
    }

    /*
     * Enabled aggressive block sorting
     */
    private void setHasEmbeddedTabs(boolean bl) {
        boolean bl2 = true;
        this.mHasEmbeddedTabs = bl;
        if (!this.mHasEmbeddedTabs) {
            this.mActionView.setEmbeddedTabView(null);
            this.mContainerView.setTabContainer(this.mTabScrollView);
        } else {
            this.mContainerView.setTabContainer(null);
            this.mActionView.setEmbeddedTabView(this.mTabScrollView);
        }
        boolean bl3 = this.getNavigationMode() == 2 ? bl2 : false;
        if (this.mTabScrollView != null) {
            ScrollingTabContainerView scrollingTabContainerView = this.mTabScrollView;
            int n = bl3 ? 0 : 8;
            scrollingTabContainerView.setVisibility(n);
        }
        ActionBarView actionBarView = this.mActionView;
        if (this.mHasEmbeddedTabs || !bl3) {
            bl2 = false;
        }
        actionBarView.setCollapsable(bl2);
    }

    @Override
    public void addOnMenuVisibilityListener(ActionBar.OnMenuVisibilityListener onMenuVisibilityListener) {
        this.mMenuVisibilityListeners.add(onMenuVisibilityListener);
    }

    @Override
    public void addTab(ActionBar.Tab tab) {
        this.addTab(tab, this.mTabs.isEmpty());
    }

    @Override
    public void addTab(ActionBar.Tab tab, int n) {
        this.addTab(tab, n, this.mTabs.isEmpty());
    }

    @Override
    public void addTab(ActionBar.Tab tab, int n, boolean bl) {
        this.ensureTabsExist();
        this.mTabScrollView.addTab(tab, n, bl);
        this.configureTab(tab, n);
        if (bl) {
            this.selectTab(tab);
        }
    }

    @Override
    public void addTab(ActionBar.Tab tab, boolean bl) {
        this.ensureTabsExist();
        this.mTabScrollView.addTab(tab, bl);
        this.configureTab(tab, this.mTabs.size());
        if (bl) {
            this.selectTab(tab);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    void animateToMode(boolean bl) {
        int n = 8;
        if (bl) {
            this.show(false);
        }
        if (this.mCurrentModeAnim != null) {
            this.mCurrentModeAnim.end();
        }
        ActionBarView actionBarView = this.mActionView;
        int n2 = bl ? n : 0;
        actionBarView.animateToVisibility(n2);
        ActionBarContextView actionBarContextView = this.mContextView;
        int n3 = bl ? 0 : n;
        actionBarContextView.animateToVisibility(n3);
        if (this.mTabScrollView != null && !this.mActionView.hasEmbeddedTabs() && this.mActionView.isCollapsed()) {
            ScrollingTabContainerView scrollingTabContainerView = this.mTabScrollView;
            if (!bl) {
                n = 0;
            }
            scrollingTabContainerView.animateToVisibility(n);
        }
    }

    void completeDeferredDestroyActionMode() {
        if (this.mDeferredModeDestroyCallback != null) {
            this.mDeferredModeDestroyCallback.onDestroyActionMode(this.mDeferredDestroyActionMode);
            this.mDeferredDestroyActionMode = null;
            this.mDeferredModeDestroyCallback = null;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void dispatchMenuVisibilityChanged(boolean bl) {
        if (bl != this.mLastMenuVisibility) {
            this.mLastMenuVisibility = bl;
            int n = this.mMenuVisibilityListeners.size();
            for (int i = 0; i < n; ++i) {
                this.mMenuVisibilityListeners.get(i).onMenuVisibilityChanged(bl);
            }
        }
    }

    @Override
    public View getCustomView() {
        return this.mActionView.getCustomNavigationView();
    }

    @Override
    public int getDisplayOptions() {
        return this.mActionView.getDisplayOptions();
    }

    @Override
    public int getHeight() {
        return this.mContainerView.getHeight();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public int getNavigationItemCount() {
        int n = 0;
        switch (this.mActionView.getNavigationMode()) {
            case 2: {
                n = this.mTabs.size();
            }
            default: {
                return n;
            }
            case 1: 
        }
        SpinnerAdapter spinnerAdapter = this.mActionView.getDropdownAdapter();
        if (spinnerAdapter == null) return n;
        return spinnerAdapter.getCount();
    }

    @Override
    public int getNavigationMode() {
        return this.mActionView.getNavigationMode();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public int getSelectedNavigationIndex() {
        int n = -1;
        switch (this.mActionView.getNavigationMode()) {
            case 2: {
                if (this.mSelectedTab == null) return n;
                n = this.mSelectedTab.getPosition();
            }
            default: {
                return n;
            }
            case 1: 
        }
        return this.mActionView.getDropdownSelectedPosition();
    }

    @Override
    public ActionBar.Tab getSelectedTab() {
        return this.mSelectedTab;
    }

    @Override
    public CharSequence getSubtitle() {
        return this.mActionView.getSubtitle();
    }

    @Override
    public ActionBar.Tab getTabAt(int n) {
        return this.mTabs.get(n);
    }

    @Override
    public int getTabCount() {
        return this.mTabs.size();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Context getThemedContext() {
        block4: {
            block3: {
                if (this.mThemedContext != null) break block3;
                TypedValue typedValue = new TypedValue();
                this.mContext.getTheme().resolveAttribute(R.attr.actionBarWidgetTheme, typedValue, true);
                int n = typedValue.resourceId;
                if (n == 0) break block4;
                this.mThemedContext = new ContextThemeWrapper(this.mContext, n);
            }
            return this.mThemedContext;
        }
        this.mThemedContext = this.mContext;
        return this.mThemedContext;
    }

    @Override
    public CharSequence getTitle() {
        return this.mActionView.getTitle();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void hide() {
        if (this.mCurrentShowAnim != null) {
            this.mCurrentShowAnim.end();
        }
        if (this.mContainerView.getVisibility() == 8) {
            return;
        }
        if (this.mShowHideAnimationEnabled) {
            this.mContainerView.setAlpha(1.0f);
            this.mContainerView.setTransitioning(true);
            AnimatorSet animatorSet = new AnimatorSet();
            ActionBarContainer actionBarContainer = this.mContainerView;
            float[] fArray = new float[]{0.0f};
            AnimatorSet.Builder builder = animatorSet.play(ObjectAnimator.ofFloat((Object)actionBarContainer, "alpha", fArray));
            if (this.mContentView != null) {
                NineFrameLayout nineFrameLayout = this.mContentView;
                float[] fArray2 = new float[]{0.0f, -this.mContainerView.getHeight()};
                builder.with(ObjectAnimator.ofFloat((Object)nineFrameLayout, "translationY", fArray2));
                ActionBarContainer actionBarContainer2 = this.mContainerView;
                float[] fArray3 = new float[]{-this.mContainerView.getHeight()};
                builder.with(ObjectAnimator.ofFloat((Object)actionBarContainer2, "translationY", fArray3));
            }
            if (this.mSplitView != null && this.mSplitView.getVisibility() == 0) {
                this.mSplitView.setAlpha(1.0f);
                ActionBarContainer actionBarContainer3 = this.mSplitView;
                float[] fArray4 = new float[]{0.0f};
                builder.with(ObjectAnimator.ofFloat((Object)actionBarContainer3, "alpha", fArray4));
            }
            animatorSet.addListener(this.mHideListener);
            this.mCurrentShowAnim = animatorSet;
            animatorSet.start();
            return;
        }
        this.mHideListener.onAnimationEnd(null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isShowing() {
        if (this.mContainerView.getVisibility() != 0) return false;
        return true;
    }

    @Override
    public ActionBar.Tab newTab() {
        return new TabImpl();
    }

    public void onConfigurationChanged(Configuration configuration) {
        this.setHasEmbeddedTabs(ResourcesCompat.getResources_getBoolean(this.mContext, R.bool.abs__action_bar_embed_tabs));
        if (Build.VERSION.SDK_INT < 8) {
            this.mActionView.onConfigurationChanged(configuration);
            if (this.mContextView != null) {
                this.mContextView.onConfigurationChanged(configuration);
            }
        }
    }

    @Override
    public void removeAllTabs() {
        this.cleanupTabs();
    }

    @Override
    public void removeOnMenuVisibilityListener(ActionBar.OnMenuVisibilityListener onMenuVisibilityListener) {
        this.mMenuVisibilityListeners.remove(onMenuVisibilityListener);
    }

    @Override
    public void removeTab(ActionBar.Tab tab) {
        this.removeTabAt(tab.getPosition());
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void removeTabAt(int n) {
        if (this.mTabScrollView == null) {
            return;
        }
        int n2 = this.mSelectedTab != null ? this.mSelectedTab.getPosition() : this.mSavedTabPosition;
        this.mTabScrollView.removeTabAt(n);
        TabImpl tabImpl = this.mTabs.remove(n);
        if (tabImpl != null) {
            tabImpl.setPosition(-1);
        }
        int n3 = this.mTabs.size();
        int n4 = n;
        while (true) {
            if (n4 >= n3) {
                if (n2 != n) return;
                TabImpl tabImpl2 = this.mTabs.isEmpty() ? null : this.mTabs.get(Math.max(0, n + -1));
                this.selectTab(tabImpl2);
                return;
            }
            this.mTabs.get(n4).setPosition(n4);
            ++n4;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void selectTab(ActionBar.Tab tab) {
        int n = -1;
        if (this.getNavigationMode() != 2) {
            int n2 = tab != null ? tab.getPosition() : n;
            this.mSavedTabPosition = n2;
            return;
        }
        FragmentTransaction fragmentTransaction = null;
        if (this.mActivity instanceof SherlockFragmentActivity) {
            fragmentTransaction = ((SherlockFragmentActivity)this.mActivity).getSupportFragmentManager().beginTransaction().disallowAddToBackStack();
        }
        if (this.mSelectedTab == tab) {
            if (this.mSelectedTab != null) {
                this.mSelectedTab.getCallback().onTabReselected(this.mSelectedTab, fragmentTransaction);
                this.mTabScrollView.animateToTab(tab.getPosition());
            }
        } else {
            ScrollingTabContainerView scrollingTabContainerView = this.mTabScrollView;
            if (tab != null) {
                n = tab.getPosition();
            }
            scrollingTabContainerView.setTabSelected(n);
            if (this.mSelectedTab != null) {
                this.mSelectedTab.getCallback().onTabUnselected(this.mSelectedTab, fragmentTransaction);
            }
            this.mSelectedTab = (TabImpl)tab;
            if (this.mSelectedTab != null) {
                this.mSelectedTab.getCallback().onTabSelected(this.mSelectedTab, fragmentTransaction);
            }
        }
        if (fragmentTransaction == null) return;
        if (fragmentTransaction.isEmpty()) return;
        fragmentTransaction.commit();
    }

    @Override
    public void setBackgroundDrawable(Drawable drawable2) {
        this.mContainerView.setPrimaryBackground(drawable2);
    }

    @Override
    public void setCustomView(int n) {
        this.setCustomView(LayoutInflater.from((Context)this.getThemedContext()).inflate(n, (ViewGroup)this.mActionView, false));
    }

    @Override
    public void setCustomView(View view) {
        this.mActionView.setCustomNavigationView(view);
    }

    @Override
    public void setCustomView(View view, ActionBar.LayoutParams layoutParams) {
        view.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        this.mActionView.setCustomNavigationView(view);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void setDisplayHomeAsUpEnabled(boolean bl) {
        int n = bl ? 4 : 0;
        this.setDisplayOptions(n, 4);
    }

    @Override
    public void setDisplayOptions(int n) {
        this.mActionView.setDisplayOptions(n);
    }

    @Override
    public void setDisplayOptions(int n, int n2) {
        int n3 = this.mActionView.getDisplayOptions();
        this.mActionView.setDisplayOptions(n & n2 | n3 & ~n2);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void setDisplayShowCustomEnabled(boolean bl) {
        int n = bl ? 16 : 0;
        this.setDisplayOptions(n, 16);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void setDisplayShowHomeEnabled(boolean bl) {
        int n = bl ? 2 : 0;
        this.setDisplayOptions(n, 2);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void setDisplayShowTitleEnabled(boolean bl) {
        int n = bl ? 8 : 0;
        this.setDisplayOptions(n, 8);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void setDisplayUseLogoEnabled(boolean bl) {
        int n = bl ? 1 : 0;
        this.setDisplayOptions(n, 1);
    }

    @Override
    public void setHomeButtonEnabled(boolean bl) {
        this.mActionView.setHomeButtonEnabled(bl);
    }

    @Override
    public void setIcon(int n) {
        this.mActionView.setIcon(n);
    }

    @Override
    public void setIcon(Drawable drawable2) {
        this.mActionView.setIcon(drawable2);
    }

    @Override
    public void setListNavigationCallbacks(SpinnerAdapter spinnerAdapter, ActionBar.OnNavigationListener onNavigationListener) {
        this.mActionView.setDropdownAdapter(spinnerAdapter);
        this.mActionView.setCallback(onNavigationListener);
    }

    @Override
    public void setLogo(int n) {
        this.mActionView.setLogo(n);
    }

    @Override
    public void setLogo(Drawable drawable2) {
        this.mActionView.setLogo(drawable2);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void setNavigationMode(int n) {
        boolean bl = false;
        switch (this.mActionView.getNavigationMode()) {
            case 2: {
                this.mSavedTabPosition = this.getSelectedNavigationIndex();
                this.selectTab(null);
                this.mTabScrollView.setVisibility(8);
                break;
            }
        }
        this.mActionView.setNavigationMode(n);
        switch (n) {
            case 2: {
                this.ensureTabsExist();
                this.mTabScrollView.setVisibility(bl ? 1 : 0);
                if (this.mSavedTabPosition == -1) break;
                this.setSelectedNavigationItem(this.mSavedTabPosition);
                this.mSavedTabPosition = -1;
                break;
            }
        }
        ActionBarView actionBarView = this.mActionView;
        if (n == 2 && !this.mHasEmbeddedTabs) {
            bl = true;
        }
        actionBarView.setCollapsable(bl);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setSelectedNavigationItem(int n) {
        switch (this.mActionView.getNavigationMode()) {
            default: {
                throw new IllegalStateException("setSelectedNavigationIndex not valid for current navigation mode");
            }
            case 2: {
                this.selectTab(this.mTabs.get(n));
                return;
            }
            case 1: 
        }
        this.mActionView.setDropdownSelectedPosition(n);
    }

    public void setShowHideAnimationEnabled(boolean bl) {
        this.mShowHideAnimationEnabled = bl;
        if (!bl && this.mCurrentShowAnim != null) {
            this.mCurrentShowAnim.end();
        }
    }

    @Override
    public void setSplitBackgroundDrawable(Drawable drawable2) {
        if (this.mSplitView != null) {
            this.mSplitView.setSplitBackground(drawable2);
        }
    }

    @Override
    public void setStackedBackgroundDrawable(Drawable drawable2) {
        this.mContainerView.setStackedBackground(drawable2);
    }

    @Override
    public void setSubtitle(int n) {
        this.setSubtitle(this.mContext.getString(n));
    }

    @Override
    public void setSubtitle(CharSequence charSequence) {
        this.mActionView.setSubtitle(charSequence);
    }

    @Override
    public void setTitle(int n) {
        this.setTitle(this.mContext.getString(n));
    }

    @Override
    public void setTitle(CharSequence charSequence) {
        this.mActionView.setTitle(charSequence);
    }

    @Override
    public void show() {
        this.show(true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void show(boolean bl) {
        if (this.mCurrentShowAnim != null) {
            this.mCurrentShowAnim.end();
        }
        if (this.mContainerView.getVisibility() == 0) {
            if (bl) {
                this.mWasHiddenBeforeMode = false;
            }
            return;
        }
        this.mContainerView.setVisibility(0);
        if (this.mShowHideAnimationEnabled) {
            this.mContainerView.setAlpha(0.0f);
            AnimatorSet animatorSet = new AnimatorSet();
            ActionBarContainer actionBarContainer = this.mContainerView;
            float[] fArray = new float[]{1.0f};
            AnimatorSet.Builder builder = animatorSet.play(ObjectAnimator.ofFloat((Object)actionBarContainer, "alpha", fArray));
            if (this.mContentView != null) {
                NineFrameLayout nineFrameLayout = this.mContentView;
                float[] fArray2 = new float[]{-this.mContainerView.getHeight(), 0.0f};
                builder.with(ObjectAnimator.ofFloat((Object)nineFrameLayout, "translationY", fArray2));
                this.mContainerView.setTranslationY(-this.mContainerView.getHeight());
                ActionBarContainer actionBarContainer2 = this.mContainerView;
                float[] fArray3 = new float[]{0.0f};
                builder.with(ObjectAnimator.ofFloat((Object)actionBarContainer2, "translationY", fArray3));
            }
            if (this.mSplitView != null && this.mContextDisplayMode == 1) {
                this.mSplitView.setAlpha(0.0f);
                this.mSplitView.setVisibility(0);
                ActionBarContainer actionBarContainer3 = this.mSplitView;
                float[] fArray4 = new float[]{1.0f};
                builder.with(ObjectAnimator.ofFloat((Object)actionBarContainer3, "alpha", fArray4));
            }
            animatorSet.addListener(this.mShowListener);
            this.mCurrentShowAnim = animatorSet;
            animatorSet.start();
            return;
        }
        this.mContainerView.setAlpha(1.0f);
        this.mContainerView.setTranslationY(0.0f);
        this.mShowListener.onAnimationEnd(null);
    }

    /*
     * Enabled aggressive block sorting
     */
    public ActionMode startActionMode(ActionMode.Callback callback) {
        boolean bl = false;
        if (this.mActionMode != null) {
            bl = this.mWasHiddenBeforeMode;
            this.mActionMode.finish();
        }
        this.mContextView.killMode();
        ActionModeImpl actionModeImpl = new ActionModeImpl(callback);
        if (!actionModeImpl.dispatchOnCreate()) {
            return null;
        }
        boolean bl2 = !this.isShowing() || bl;
        this.mWasHiddenBeforeMode = bl2;
        actionModeImpl.invalidate();
        this.mContextView.initForMode(actionModeImpl);
        this.animateToMode(true);
        if (this.mSplitView != null && this.mContextDisplayMode == 1) {
            this.mSplitView.setVisibility(0);
        }
        this.mContextView.sendAccessibilityEvent(32);
        this.mActionMode = actionModeImpl;
        return actionModeImpl;
    }

    public class ActionModeImpl
    extends ActionMode
    implements MenuBuilder.Callback {
        private ActionMode.Callback mCallback;
        private WeakReference<View> mCustomView;
        private MenuBuilder mMenu;

        public ActionModeImpl(ActionMode.Callback callback) {
            this.mCallback = callback;
            this.mMenu = new MenuBuilder(ActionBarImpl.this.getThemedContext()).setDefaultShowAsAction(1);
            this.mMenu.setCallback(this);
        }

        public boolean dispatchOnCreate() {
            this.mMenu.stopDispatchingItemsChanged();
            try {
                boolean bl = this.mCallback.onCreateActionMode(this, this.mMenu);
                return bl;
            }
            finally {
                this.mMenu.startDispatchingItemsChanged();
            }
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void finish() {
            if (ActionBarImpl.this.mActionMode != this) {
                return;
            }
            if (ActionBarImpl.this.mWasHiddenBeforeMode) {
                ActionBarImpl.this.mDeferredDestroyActionMode = this;
                ActionBarImpl.this.mDeferredModeDestroyCallback = this.mCallback;
            } else {
                this.mCallback.onDestroyActionMode(this);
            }
            this.mCallback = null;
            ActionBarImpl.this.animateToMode(false);
            ActionBarImpl.this.mContextView.closeMode();
            ActionBarImpl.this.mActionView.sendAccessibilityEvent(32);
            ActionBarImpl.this.mActionMode = null;
            if (!ActionBarImpl.this.mWasHiddenBeforeMode) return;
            ActionBarImpl.this.hide();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public View getCustomView() {
            if (this.mCustomView == null) return null;
            return (View)this.mCustomView.get();
        }

        @Override
        public Menu getMenu() {
            return this.mMenu;
        }

        @Override
        public MenuInflater getMenuInflater() {
            return new MenuInflater(ActionBarImpl.this.getThemedContext());
        }

        @Override
        public CharSequence getSubtitle() {
            return ActionBarImpl.this.mContextView.getSubtitle();
        }

        @Override
        public CharSequence getTitle() {
            return ActionBarImpl.this.mContextView.getTitle();
        }

        @Override
        public void invalidate() {
            this.mMenu.stopDispatchingItemsChanged();
            try {
                this.mCallback.onPrepareActionMode(this, this.mMenu);
                return;
            }
            finally {
                this.mMenu.startDispatchingItemsChanged();
            }
        }

        public void onCloseMenu(MenuBuilder menuBuilder, boolean bl) {
        }

        public void onCloseSubMenu(SubMenuBuilder subMenuBuilder) {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean onMenuItemSelected(MenuBuilder menuBuilder, MenuItem menuItem) {
            if (this.mCallback == null) return false;
            return this.mCallback.onActionItemClicked(this, menuItem);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void onMenuModeChange(MenuBuilder menuBuilder) {
            if (this.mCallback == null) {
                return;
            }
            this.invalidate();
            ActionBarImpl.this.mContextView.showOverflowMenu();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean onSubMenuSelected(SubMenuBuilder subMenuBuilder) {
            boolean bl = true;
            if (this.mCallback == null) {
                return false;
            }
            if (!subMenuBuilder.hasVisibleItems()) return bl;
            new MenuPopupHelper(ActionBarImpl.this.getThemedContext(), subMenuBuilder).show();
            return bl;
        }

        @Override
        public void setCustomView(View view) {
            ActionBarImpl.this.mContextView.setCustomView(view);
            this.mCustomView = new WeakReference<View>(view);
        }

        @Override
        public void setSubtitle(int n) {
            this.setSubtitle(ActionBarImpl.this.mContext.getResources().getString(n));
        }

        @Override
        public void setSubtitle(CharSequence charSequence) {
            ActionBarImpl.this.mContextView.setSubtitle(charSequence);
        }

        @Override
        public void setTitle(int n) {
            this.setTitle(ActionBarImpl.this.mContext.getResources().getString(n));
        }

        @Override
        public void setTitle(CharSequence charSequence) {
            ActionBarImpl.this.mContextView.setTitle(charSequence);
        }
    }

    public class TabImpl
    extends ActionBar.Tab {
        private ActionBar.TabListener mCallback;
        private CharSequence mContentDesc;
        private View mCustomView;
        private Drawable mIcon;
        private int mPosition = -1;
        private Object mTag;
        private CharSequence mText;

        public ActionBar.TabListener getCallback() {
            return this.mCallback;
        }

        @Override
        public CharSequence getContentDescription() {
            return this.mContentDesc;
        }

        @Override
        public View getCustomView() {
            return this.mCustomView;
        }

        @Override
        public Drawable getIcon() {
            return this.mIcon;
        }

        @Override
        public int getPosition() {
            return this.mPosition;
        }

        @Override
        public Object getTag() {
            return this.mTag;
        }

        @Override
        public CharSequence getText() {
            return this.mText;
        }

        @Override
        public void select() {
            ActionBarImpl.this.selectTab(this);
        }

        @Override
        public ActionBar.Tab setContentDescription(int n) {
            return this.setContentDescription(ActionBarImpl.this.mContext.getResources().getText(n));
        }

        @Override
        public ActionBar.Tab setContentDescription(CharSequence charSequence) {
            this.mContentDesc = charSequence;
            if (this.mPosition >= 0) {
                ActionBarImpl.this.mTabScrollView.updateTab(this.mPosition);
            }
            return this;
        }

        @Override
        public ActionBar.Tab setCustomView(int n) {
            return this.setCustomView(LayoutInflater.from((Context)ActionBarImpl.this.getThemedContext()).inflate(n, null));
        }

        @Override
        public ActionBar.Tab setCustomView(View view) {
            this.mCustomView = view;
            if (this.mPosition >= 0) {
                ActionBarImpl.this.mTabScrollView.updateTab(this.mPosition);
            }
            return this;
        }

        @Override
        public ActionBar.Tab setIcon(int n) {
            return this.setIcon(ActionBarImpl.this.mContext.getResources().getDrawable(n));
        }

        @Override
        public ActionBar.Tab setIcon(Drawable drawable2) {
            this.mIcon = drawable2;
            if (this.mPosition >= 0) {
                ActionBarImpl.this.mTabScrollView.updateTab(this.mPosition);
            }
            return this;
        }

        public void setPosition(int n) {
            this.mPosition = n;
        }

        @Override
        public ActionBar.Tab setTabListener(ActionBar.TabListener tabListener) {
            this.mCallback = tabListener;
            return this;
        }

        @Override
        public ActionBar.Tab setTag(Object object) {
            this.mTag = object;
            return this;
        }

        @Override
        public ActionBar.Tab setText(int n) {
            return this.setText(ActionBarImpl.this.mContext.getResources().getText(n));
        }

        @Override
        public ActionBar.Tab setText(CharSequence charSequence) {
            this.mText = charSequence;
            if (this.mPosition >= 0) {
                ActionBarImpl.this.mTabScrollView.updateTab(this.mPosition);
            }
            return this;
        }
    }
}

