/*
 * Decompiled with CFR 0.152.
 */
package android.support.v4.view;

import android.content.Context;
import android.content.res.TypedArray;
import android.database.DataSetObserver;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.support.v4.view.PagerAdapter;
import android.support.v4.view.PagerTitleStripIcs;
import android.support.v4.view.ViewPager;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.widget.TextView;

public class PagerTitleStrip
extends ViewGroup
implements ViewPager.Decor {
    private static final int[] ATTRS;
    private static final PagerTitleStripImpl IMPL;
    private static final float SIDE_ALPHA = 0.6f;
    private static final String TAG = "PagerTitleStrip";
    private static final int[] TEXT_ATTRS;
    private static final int TEXT_SPACING = 16;
    TextView mCurrText;
    private int mGravity;
    private int mLastKnownCurrentPage = -1;
    private float mLastKnownPositionOffset = -1.0f;
    TextView mNextText;
    private int mNonPrimaryAlpha;
    private final PageListener mPageListener = new PageListener();
    ViewPager mPager;
    TextView mPrevText;
    private int mScaledTextSpacing;
    int mTextColor;
    private boolean mUpdatingPositions;
    private boolean mUpdatingText;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static {
        int[] nArray = new int[]{16842804, 16842901, 16842904, 16842927};
        ATTRS = nArray;
        int[] nArray2 = new int[]{16843660};
        TEXT_ATTRS = nArray2;
        if (Build.VERSION.SDK_INT >= 14) {
            IMPL = new PagerTitleStripImplIcs();
            return;
        }
        IMPL = new PagerTitleStripImplBase();
    }

    public PagerTitleStrip(Context context) {
        this(context, null);
    }

    /*
     * Enabled aggressive block sorting
     */
    public PagerTitleStrip(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        int n;
        TextView textView;
        TextView textView2;
        TextView textView3;
        this.mPrevText = textView3 = new TextView(context);
        this.addView((View)textView3);
        this.mCurrText = textView2 = new TextView(context);
        this.addView((View)textView2);
        this.mNextText = textView = new TextView(context);
        this.addView((View)textView);
        TypedArray typedArray = context.obtainStyledAttributes(attributeSet, ATTRS);
        int n2 = typedArray.getResourceId(0, 0);
        if (n2 != 0) {
            this.mPrevText.setTextAppearance(context, n2);
            this.mCurrText.setTextAppearance(context, n2);
            this.mNextText.setTextAppearance(context, n2);
        }
        if ((n = typedArray.getDimensionPixelSize(1, 0)) != 0) {
            this.setTextSize(0, n);
        }
        if (typedArray.hasValue(2)) {
            int n3 = typedArray.getColor(2, 0);
            this.mPrevText.setTextColor(n3);
            this.mCurrText.setTextColor(n3);
            this.mNextText.setTextColor(n3);
        }
        this.mGravity = typedArray.getInteger(3, 80);
        typedArray.recycle();
        this.mTextColor = this.mCurrText.getTextColors().getDefaultColor();
        this.setNonPrimaryAlpha(0.6f);
        this.mPrevText.setEllipsize(TextUtils.TruncateAt.END);
        this.mCurrText.setEllipsize(TextUtils.TruncateAt.END);
        this.mNextText.setEllipsize(TextUtils.TruncateAt.END);
        boolean bl = false;
        if (n2 != 0) {
            TypedArray typedArray2 = context.obtainStyledAttributes(n2, TEXT_ATTRS);
            bl = typedArray2.getBoolean(0, false);
            typedArray2.recycle();
        }
        if (bl) {
            PagerTitleStrip.setSingleLineAllCaps(this.mPrevText);
            PagerTitleStrip.setSingleLineAllCaps(this.mCurrText);
            PagerTitleStrip.setSingleLineAllCaps(this.mNextText);
        } else {
            this.mPrevText.setSingleLine();
            this.mCurrText.setSingleLine();
            this.mNextText.setSingleLine();
        }
        this.mScaledTextSpacing = (int)(16.0f * context.getResources().getDisplayMetrics().density);
    }

    private static void setSingleLineAllCaps(TextView textView) {
        IMPL.setSingleLineAllCaps(textView);
    }

    int getMinHeight() {
        int n = 0;
        Drawable drawable2 = this.getBackground();
        if (drawable2 != null) {
            n = drawable2.getIntrinsicHeight();
        }
        return n;
    }

    public int getTextSpacing() {
        return this.mScaledTextSpacing;
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        ViewParent viewParent = this.getParent();
        if (!(viewParent instanceof ViewPager)) {
            throw new IllegalStateException("PagerTitleStrip must be a direct child of a ViewPager.");
        }
        ViewPager viewPager = (ViewPager)viewParent;
        PagerAdapter pagerAdapter = viewPager.getAdapter();
        viewPager.setInternalPageChangeListener(this.mPageListener);
        viewPager.setOnAdapterChangeListener(this.mPageListener);
        this.mPager = viewPager;
        this.updateAdapter(null, pagerAdapter);
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (this.mPager != null) {
            this.updateAdapter(this.mPager.getAdapter(), null);
            this.mPager.setInternalPageChangeListener(null);
            this.mPager.setOnAdapterChangeListener(null);
            this.mPager = null;
        }
    }

    protected void onLayout(boolean bl, int n, int n2, int n3, int n4) {
        float f = 0.0f;
        if (this.mPager != null) {
            if (this.mLastKnownPositionOffset >= f) {
                f = this.mLastKnownPositionOffset;
            }
            this.updateTextPositions(this.mPager.getCurrentItem(), f, true);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void onMeasure(int n, int n2) {
        int n3 = View.MeasureSpec.getMode((int)n);
        int n4 = View.MeasureSpec.getMode((int)n2);
        int n5 = View.MeasureSpec.getSize((int)n);
        int n6 = View.MeasureSpec.getSize((int)n2);
        if (n3 != 0x40000000) {
            throw new IllegalStateException("Must measure with an exact width");
        }
        int n7 = this.getMinHeight();
        int n8 = this.getPaddingTop() + this.getPaddingBottom();
        int n9 = n6 - n8;
        int n10 = View.MeasureSpec.makeMeasureSpec((int)((int)(0.8f * (float)n5)), (int)Integer.MIN_VALUE);
        int n11 = View.MeasureSpec.makeMeasureSpec((int)n9, (int)Integer.MIN_VALUE);
        this.mPrevText.measure(n10, n11);
        this.mCurrText.measure(n10, n11);
        this.mNextText.measure(n10, n11);
        if (n4 == 0x40000000) {
            this.setMeasuredDimension(n5, n6);
            return;
        }
        this.setMeasuredDimension(n5, Math.max(n7, n8 + this.mCurrText.getMeasuredHeight()));
    }

    public void requestLayout() {
        if (!this.mUpdatingText) {
            super.requestLayout();
        }
    }

    public void setGravity(int n) {
        this.mGravity = n;
        this.requestLayout();
    }

    public void setNonPrimaryAlpha(float f) {
        this.mNonPrimaryAlpha = 0xFF & (int)(255.0f * f);
        int n = this.mNonPrimaryAlpha << 24 | 0xFFFFFF & this.mTextColor;
        this.mPrevText.setTextColor(n);
        this.mNextText.setTextColor(n);
    }

    public void setTextColor(int n) {
        this.mTextColor = n;
        this.mCurrText.setTextColor(n);
        int n2 = this.mNonPrimaryAlpha << 24 | 0xFFFFFF & this.mTextColor;
        this.mPrevText.setTextColor(n2);
        this.mNextText.setTextColor(n2);
    }

    public void setTextSize(int n, float f) {
        this.mPrevText.setTextSize(n, f);
        this.mCurrText.setTextSize(n, f);
        this.mNextText.setTextSize(n, f);
    }

    public void setTextSpacing(int n) {
        this.mScaledTextSpacing = n;
        this.requestLayout();
    }

    void updateAdapter(PagerAdapter pagerAdapter, PagerAdapter pagerAdapter2) {
        if (pagerAdapter != null) {
            pagerAdapter.unregisterDataSetObserver(this.mPageListener);
        }
        if (pagerAdapter2 != null) {
            pagerAdapter2.registerDataSetObserver(this.mPageListener);
        }
        if (this.mPager != null) {
            this.mLastKnownCurrentPage = -1;
            this.mLastKnownPositionOffset = -1.0f;
            this.updateText(this.mPager.getCurrentItem(), pagerAdapter2);
            this.requestLayout();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    void updateText(int n, PagerAdapter pagerAdapter) {
        int n2 = pagerAdapter != null ? pagerAdapter.getCount() : 0;
        this.mUpdatingText = true;
        CharSequence charSequence = null;
        if (n >= 1 && pagerAdapter != null) {
            charSequence = pagerAdapter.getPageTitle(n + -1);
        }
        this.mPrevText.setText(charSequence);
        TextView textView = this.mCurrText;
        CharSequence charSequence2 = pagerAdapter != null && n < n2 ? pagerAdapter.getPageTitle(n) : null;
        textView.setText(charSequence2);
        CharSequence charSequence3 = null;
        if (n + 1 < n2 && pagerAdapter != null) {
            charSequence3 = pagerAdapter.getPageTitle(n + 1);
        }
        this.mNextText.setText(charSequence3);
        int n3 = this.getWidth() - this.getPaddingLeft() - this.getPaddingRight();
        int n4 = this.getHeight() - this.getPaddingTop() - this.getPaddingBottom();
        int n5 = View.MeasureSpec.makeMeasureSpec((int)((int)(0.8f * (float)n3)), (int)Integer.MIN_VALUE);
        int n6 = View.MeasureSpec.makeMeasureSpec((int)n4, (int)Integer.MIN_VALUE);
        this.mPrevText.measure(n5, n6);
        this.mCurrText.measure(n5, n6);
        this.mNextText.measure(n5, n6);
        this.mLastKnownCurrentPage = n;
        if (!this.mUpdatingPositions) {
            this.updateTextPositions(n, this.mLastKnownPositionOffset, false);
        }
        this.mUpdatingText = false;
    }

    /*
     * Enabled aggressive block sorting
     */
    void updateTextPositions(int n, float f, boolean bl) {
        int n2;
        int n3;
        int n4;
        if (n != this.mLastKnownCurrentPage) {
            this.updateText(n, this.mPager.getAdapter());
        } else if (!bl && f == this.mLastKnownPositionOffset) {
            return;
        }
        this.mUpdatingPositions = true;
        int n5 = this.mPrevText.getMeasuredWidth();
        int n6 = this.mCurrText.getMeasuredWidth();
        int n7 = this.mNextText.getMeasuredWidth();
        int n8 = n6 / 2;
        int n9 = this.getWidth();
        int n10 = this.getHeight();
        int n11 = this.getPaddingLeft();
        int n12 = this.getPaddingRight();
        int n13 = this.getPaddingTop();
        int n14 = this.getPaddingBottom();
        int n15 = n11 + n8;
        int n16 = n12 + n8;
        int n17 = n9 - n15 - n16;
        float f2 = f + 0.5f;
        if (f2 > 1.0f) {
            f2 -= 1.0f;
        }
        int n18 = n9 - n16 - (int)(f2 * (float)n17) - n6 / 2;
        int n19 = n18 + n6;
        int n20 = this.mPrevText.getBaseline();
        int n21 = this.mCurrText.getBaseline();
        int n22 = this.mNextText.getBaseline();
        int n23 = Math.max(Math.max(n20, n21), n22);
        int n24 = n23 - n20;
        int n25 = n23 - n21;
        int n26 = n23 - n22;
        int n27 = n24 + this.mPrevText.getMeasuredHeight();
        int n28 = n25 + this.mCurrText.getMeasuredHeight();
        int n29 = n26 + this.mNextText.getMeasuredHeight();
        int n30 = Math.max(Math.max(n27, n28), n29);
        switch (0x70 & this.mGravity) {
            default: {
                n4 = n13 + n24;
                n3 = n13 + n25;
                n2 = n13 + n26;
                break;
            }
            case 16: {
                int n31 = (n10 - n13 - n14 - n30) / 2;
                n4 = n31 + n24;
                n3 = n31 + n25;
                n2 = n31 + n26;
                break;
            }
            case 80: {
                int n32 = n10 - n14 - n30;
                n4 = n32 + n24;
                n3 = n32 + n25;
                n2 = n32 + n26;
            }
        }
        TextView textView = this.mCurrText;
        int n33 = n3 + this.mCurrText.getMeasuredHeight();
        textView.layout(n18, n3, n19, n33);
        int n34 = Math.min(n11, n18 - this.mScaledTextSpacing - n5);
        TextView textView2 = this.mPrevText;
        int n35 = n34 + n5;
        int n36 = n4 + this.mPrevText.getMeasuredHeight();
        textView2.layout(n34, n4, n35, n36);
        int n37 = Math.max(n9 - n12 - n7, n19 + this.mScaledTextSpacing);
        TextView textView3 = this.mNextText;
        int n38 = n37 + n7;
        int n39 = n2 + this.mNextText.getMeasuredHeight();
        textView3.layout(n37, n2, n38, n39);
        this.mLastKnownPositionOffset = f;
        this.mUpdatingPositions = false;
    }

    private class PageListener
    extends DataSetObserver
    implements ViewPager.OnPageChangeListener,
    ViewPager.OnAdapterChangeListener {
        private int mScrollState;

        private PageListener() {
        }

        @Override
        public void onAdapterChanged(PagerAdapter pagerAdapter, PagerAdapter pagerAdapter2) {
            PagerTitleStrip.this.updateAdapter(pagerAdapter, pagerAdapter2);
        }

        public void onChanged() {
            PagerTitleStrip.this.updateText(PagerTitleStrip.this.mPager.getCurrentItem(), PagerTitleStrip.this.mPager.getAdapter());
        }

        @Override
        public void onPageScrollStateChanged(int n) {
            this.mScrollState = n;
        }

        @Override
        public void onPageScrolled(int n, float f, int n2) {
            if (f > 0.5f) {
                ++n;
            }
            PagerTitleStrip.this.updateTextPositions(n, f, false);
        }

        @Override
        public void onPageSelected(int n) {
            if (this.mScrollState == 0) {
                PagerTitleStrip.this.updateText(PagerTitleStrip.this.mPager.getCurrentItem(), PagerTitleStrip.this.mPager.getAdapter());
            }
        }
    }

    static class PagerTitleStripImplIcs
    implements PagerTitleStripImpl {
        PagerTitleStripImplIcs() {
        }

        @Override
        public void setSingleLineAllCaps(TextView textView) {
            PagerTitleStripIcs.setSingleLineAllCaps(textView);
        }
    }

    static class PagerTitleStripImplBase
    implements PagerTitleStripImpl {
        PagerTitleStripImplBase() {
        }

        @Override
        public void setSingleLineAllCaps(TextView textView) {
            textView.setSingleLine();
        }
    }

    static interface PagerTitleStripImpl {
        public void setSingleLineAllCaps(TextView var1);
    }
}

