/*
 * Decompiled with CFR 0.152.
 */
package android.support.v4.view;

import android.os.Build;
import android.support.v4.view.KeyEventCompatHoneycomb;
import android.view.KeyEvent;

public class KeyEventCompat {
    static final KeyEventVersionImpl IMPL;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static {
        if (Build.VERSION.SDK_INT >= 11) {
            IMPL = new HoneycombKeyEventVersionImpl();
            return;
        }
        IMPL = new BaseKeyEventVersionImpl();
    }

    public static boolean hasModifiers(KeyEvent keyEvent, int n) {
        return IMPL.metaStateHasModifiers(keyEvent.getMetaState(), n);
    }

    public static boolean hasNoModifiers(KeyEvent keyEvent) {
        return IMPL.metaStateHasNoModifiers(keyEvent.getMetaState());
    }

    public static boolean metaStateHasModifiers(int n, int n2) {
        return IMPL.metaStateHasModifiers(n, n2);
    }

    public static boolean metaStateHasNoModifiers(int n) {
        return IMPL.metaStateHasNoModifiers(n);
    }

    public static int normalizeMetaState(int n) {
        return IMPL.normalizeMetaState(n);
    }

    static class HoneycombKeyEventVersionImpl
    implements KeyEventVersionImpl {
        HoneycombKeyEventVersionImpl() {
        }

        @Override
        public boolean metaStateHasModifiers(int n, int n2) {
            return KeyEventCompatHoneycomb.metaStateHasModifiers(n, n2);
        }

        @Override
        public boolean metaStateHasNoModifiers(int n) {
            return KeyEventCompatHoneycomb.metaStateHasNoModifiers(n);
        }

        @Override
        public int normalizeMetaState(int n) {
            return KeyEventCompatHoneycomb.normalizeMetaState(n);
        }
    }

    static class BaseKeyEventVersionImpl
    implements KeyEventVersionImpl {
        private static final int META_ALL_MASK = 247;
        private static final int META_MODIFIER_MASK = 247;

        BaseKeyEventVersionImpl() {
        }

        /*
         * Enabled aggressive block sorting
         */
        private static int metaStateFilterDirectionalModifiers(int n, int n2, int n3, int n4, int n5) {
            boolean bl = true;
            boolean bl2 = (n2 & n3) != 0 ? bl : false;
            int n6 = n4 | n5;
            if ((n2 & n6) == 0) {
                bl = false;
            }
            if (!bl2) {
                if (!bl) return n;
                return n &= ~n3;
            }
            if (bl) {
                throw new IllegalArgumentException("bad arguments");
            }
            n &= ~n6;
            return n;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean metaStateHasModifiers(int n, int n2) {
            boolean bl = true;
            if (BaseKeyEventVersionImpl.metaStateFilterDirectionalModifiers(BaseKeyEventVersionImpl.metaStateFilterDirectionalModifiers(0xF7 & this.normalizeMetaState(n), n2, bl ? 1 : 0, 64, 128), n2, 2, 16, 32) != n2) return false;
            return bl;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean metaStateHasNoModifiers(int n) {
            if ((0xF7 & this.normalizeMetaState(n)) != 0) return false;
            return true;
        }

        @Override
        public int normalizeMetaState(int n) {
            if ((n & 0xC0) != 0) {
                n |= 1;
            }
            if ((n & 0x30) != 0) {
                n |= 2;
            }
            return n & 0xF7;
        }
    }

    static interface KeyEventVersionImpl {
        public boolean metaStateHasModifiers(int var1, int var2);

        public boolean metaStateHasNoModifiers(int var1);

        public int normalizeMetaState(int var1);
    }
}

