/*
 * Decompiled with CFR 0.152.
 */
package android.support.v4.util;

public class LongSparseArray<E>
implements Cloneable {
    private static final Object DELETED = new Object();
    private boolean mGarbage = false;
    private long[] mKeys;
    private int mSize;
    private Object[] mValues;

    public LongSparseArray() {
        this(10);
    }

    public LongSparseArray(int n) {
        int n2 = LongSparseArray.idealLongArraySize(n);
        this.mKeys = new long[n2];
        this.mValues = new Object[n2];
        this.mSize = 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static int binarySearch(long[] lArray, int n, int n2, long l) {
        int n3 = n + n2;
        int n4 = n + -1;
        while (n3 - n4 > 1) {
            int n5 = (n3 + n4) / 2;
            if (lArray[n5] < l) {
                n4 = n5;
                continue;
            }
            n3 = n5;
        }
        if (n3 == n + n2) {
            return 0xFFFFFFFF ^ n + n2;
        }
        if (lArray[n3] == l) return n3;
        n3 ^= 0xFFFFFFFF;
        return n3;
    }

    private void gc() {
        int n = this.mSize;
        int n2 = 0;
        long[] lArray = this.mKeys;
        Object[] objectArray = this.mValues;
        for (int i = 0; i < n; ++i) {
            Object object = objectArray[i];
            if (object == DELETED) continue;
            if (i != n2) {
                lArray[n2] = lArray[i];
                objectArray[n2] = object;
                objectArray[i] = null;
            }
            ++n2;
        }
        this.mGarbage = false;
        this.mSize = n2;
    }

    public static int idealByteArraySize(int n) {
        int n2 = 4;
        while (true) {
            block4: {
                block3: {
                    if (n2 >= 32) break block3;
                    if (n > -12 + (1 << n2)) break block4;
                    n = -12 + (1 << n2);
                }
                return n;
            }
            ++n2;
        }
    }

    public static int idealLongArraySize(int n) {
        return LongSparseArray.idealByteArraySize(n * 8) / 8;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void append(long l, E e) {
        int n;
        if (this.mSize != 0 && l <= this.mKeys[-1 + this.mSize]) {
            this.put(l, e);
            return;
        }
        if (this.mGarbage && this.mSize >= this.mKeys.length) {
            this.gc();
        }
        if ((n = this.mSize) >= this.mKeys.length) {
            int n2 = LongSparseArray.idealLongArraySize(n + 1);
            long[] lArray = new long[n2];
            Object[] objectArray = new Object[n2];
            System.arraycopy(this.mKeys, 0, lArray, 0, this.mKeys.length);
            System.arraycopy(this.mValues, 0, objectArray, 0, this.mValues.length);
            this.mKeys = lArray;
            this.mValues = objectArray;
        }
        this.mKeys[n] = l;
        this.mValues[n] = e;
        this.mSize = n + 1;
    }

    public void clear() {
        int n = this.mSize;
        Object[] objectArray = this.mValues;
        for (int i = 0; i < n; ++i) {
            objectArray[i] = null;
        }
        this.mSize = 0;
        this.mGarbage = false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public LongSparseArray<E> clone() {
        LongSparseArray longSparseArray = null;
        try {
            longSparseArray = (LongSparseArray)super.clone();
            longSparseArray.mKeys = (long[])this.mKeys.clone();
            longSparseArray.mValues = (Object[])this.mValues.clone();
            return longSparseArray;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return longSparseArray;
        }
    }

    public void delete(long l) {
        int n = LongSparseArray.binarySearch(this.mKeys, 0, this.mSize, l);
        if (n >= 0 && this.mValues[n] != DELETED) {
            this.mValues[n] = DELETED;
            this.mGarbage = true;
        }
    }

    public E get(long l) {
        return this.get(l, null);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public E get(long l, E object) {
        void var3_3;
        int n = LongSparseArray.binarySearch(this.mKeys, 0, this.mSize, l);
        if (n < 0 || this.mValues[n] == DELETED) {
            return var3_3;
        }
        Object object2 = this.mValues[n];
        return var3_3;
    }

    public int indexOfKey(long l) {
        if (this.mGarbage) {
            this.gc();
        }
        return LongSparseArray.binarySearch(this.mKeys, 0, this.mSize, l);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int indexOfValue(E e) {
        if (this.mGarbage) {
            this.gc();
        }
        int n = 0;
        while (n < this.mSize) {
            if (this.mValues[n] == e) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public long keyAt(int n) {
        if (this.mGarbage) {
            this.gc();
        }
        return this.mKeys[n];
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void put(long l, E e) {
        int n = LongSparseArray.binarySearch(this.mKeys, 0, this.mSize, l);
        if (n >= 0) {
            this.mValues[n] = e;
            return;
        }
        int n2 = ~n;
        if (n2 < this.mSize && this.mValues[n2] == DELETED) {
            this.mKeys[n2] = l;
            this.mValues[n2] = e;
            return;
        }
        if (this.mGarbage && this.mSize >= this.mKeys.length) {
            this.gc();
            n2 = 0xFFFFFFFF ^ LongSparseArray.binarySearch(this.mKeys, 0, this.mSize, l);
        }
        if (this.mSize >= this.mKeys.length) {
            int n3 = LongSparseArray.idealLongArraySize(1 + this.mSize);
            long[] lArray = new long[n3];
            Object[] objectArray = new Object[n3];
            System.arraycopy(this.mKeys, 0, lArray, 0, this.mKeys.length);
            System.arraycopy(this.mValues, 0, objectArray, 0, this.mValues.length);
            this.mKeys = lArray;
            this.mValues = objectArray;
        }
        if (this.mSize - n2 != 0) {
            System.arraycopy(this.mKeys, n2, this.mKeys, n2 + 1, this.mSize - n2);
            System.arraycopy(this.mValues, n2, this.mValues, n2 + 1, this.mSize - n2);
        }
        this.mKeys[n2] = l;
        this.mValues[n2] = e;
        this.mSize = 1 + this.mSize;
    }

    public void remove(long l) {
        this.delete(l);
    }

    public void removeAt(int n) {
        if (this.mValues[n] != DELETED) {
            this.mValues[n] = DELETED;
            this.mGarbage = true;
        }
    }

    public void setValueAt(int n, E e) {
        if (this.mGarbage) {
            this.gc();
        }
        this.mValues[n] = e;
    }

    public int size() {
        if (this.mGarbage) {
            this.gc();
        }
        return this.mSize;
    }

    public E valueAt(int n) {
        if (this.mGarbage) {
            this.gc();
        }
        return (E)this.mValues[n];
    }
}

