/*
 * Decompiled with CFR 0.152.
 */
package android.support.v4.content;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.Uri;
import android.os.Handler;
import android.os.Message;
import android.util.Log;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;

public class LocalBroadcastManager {
    private static final boolean DEBUG = false;
    static final int MSG_EXEC_PENDING_BROADCASTS = 1;
    private static final String TAG = "LocalBroadcastManager";
    private static LocalBroadcastManager mInstance;
    private static final Object mLock;
    private final HashMap<String, ArrayList<ReceiverRecord>> mActions;
    private final Context mAppContext;
    private final Handler mHandler;
    private final ArrayList<BroadcastRecord> mPendingBroadcasts;
    private final HashMap<BroadcastReceiver, ArrayList<IntentFilter>> mReceivers = new HashMap();

    static {
        mLock = new Object();
    }

    private LocalBroadcastManager(Context context) {
        this.mActions = new HashMap();
        this.mPendingBroadcasts = new ArrayList();
        this.mAppContext = context;
        this.mHandler = new Handler(context.getMainLooper()){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public void handleMessage(Message message) {
                switch (message.what) {
                    default: {
                        super.handleMessage(message);
                        return;
                    }
                    case 1: 
                }
                LocalBroadcastManager.this.executePendingBroadcasts();
            }
        };
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void executePendingBroadcasts() {
        block3: while (true) {
            BroadcastRecord[] broadcastRecordArray;
            HashMap<BroadcastReceiver, ArrayList<IntentFilter>> hashMap = this.mReceivers;
            synchronized (hashMap) {
                int n = this.mPendingBroadcasts.size();
                if (n <= 0) {
                    return;
                }
                broadcastRecordArray = new BroadcastRecord[n];
                this.mPendingBroadcasts.toArray(broadcastRecordArray);
                this.mPendingBroadcasts.clear();
            }
            int n = 0;
            while (true) {
                if (n >= broadcastRecordArray.length) continue block3;
                BroadcastRecord broadcastRecord = broadcastRecordArray[n];
                for (int i = 0; i < broadcastRecord.receivers.size(); ++i) {
                    broadcastRecord.receivers.get((int)i).receiver.onReceive(this.mAppContext, broadcastRecord.intent);
                }
                ++n;
            }
            break;
        }
    }

    public static LocalBroadcastManager getInstance(Context context) {
        Object object = mLock;
        synchronized (object) {
            if (mInstance == null) {
                mInstance = new LocalBroadcastManager(context.getApplicationContext());
            }
            LocalBroadcastManager localBroadcastManager = mInstance;
            return localBroadcastManager;
        }
    }

    public void registerReceiver(BroadcastReceiver broadcastReceiver, IntentFilter intentFilter) {
        HashMap<BroadcastReceiver, ArrayList<IntentFilter>> hashMap = this.mReceivers;
        synchronized (hashMap) {
            ReceiverRecord receiverRecord = new ReceiverRecord(intentFilter, broadcastReceiver);
            ArrayList<Object> arrayList = this.mReceivers.get(broadcastReceiver);
            if (arrayList == null) {
                arrayList = new ArrayList(1);
                this.mReceivers.put(broadcastReceiver, arrayList);
            }
            arrayList.add(intentFilter);
            for (int i = 0; i < intentFilter.countActions(); ++i) {
                String string2 = intentFilter.getAction(i);
                ArrayList<ReceiverRecord> arrayList2 = this.mActions.get(string2);
                if (arrayList2 == null) {
                    arrayList2 = new ArrayList(1);
                    this.mActions.put(string2, arrayList2);
                }
                arrayList2.add(receiverRecord);
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean sendBroadcast(Intent intent) {
        HashMap<BroadcastReceiver, ArrayList<IntentFilter>> hashMap = this.mReceivers;
        synchronized (hashMap) {
            ArrayList<ReceiverRecord> arrayList;
            String string2 = intent.getAction();
            String string3 = intent.resolveTypeIfNeeded(this.mAppContext.getContentResolver());
            Uri uri = intent.getData();
            String string4 = intent.getScheme();
            Set set = intent.getCategories();
            boolean bl = (8 & intent.getFlags()) != 0;
            if (bl) {
                Log.v((String)TAG, (String)("Resolving type " + string3 + " scheme " + string4 + " of intent " + intent));
            }
            if ((arrayList = this.mActions.get(intent.getAction())) == null) return false;
            if (bl) {
                Log.v((String)TAG, (String)("Action list: " + arrayList));
            }
            ArrayList<ReceiverRecord> arrayList2 = null;
            for (int i = 0; i < arrayList.size(); ++i) {
                String string5;
                ReceiverRecord receiverRecord = arrayList.get(i);
                if (bl) {
                    Log.v((String)TAG, (String)("Matching against filter " + receiverRecord.filter));
                }
                if (receiverRecord.broadcasting) {
                    if (!bl) continue;
                    Log.v((String)TAG, (String)"  Filter's target already added");
                    continue;
                }
                int n = receiverRecord.filter.match(string2, string3, string4, uri, set, TAG);
                if (n >= 0) {
                    if (bl) {
                        Log.v((String)TAG, (String)("  Filter matched!  match=0x" + Integer.toHexString(n)));
                    }
                    if (arrayList2 == null) {
                        arrayList2 = new ArrayList<ReceiverRecord>();
                    }
                    arrayList2.add(receiverRecord);
                    receiverRecord.broadcasting = true;
                    continue;
                }
                if (!bl) continue;
                switch (n) {
                    default: {
                        string5 = "unknown reason";
                        break;
                    }
                    case -3: {
                        string5 = "action";
                        break;
                    }
                    case -4: {
                        string5 = "category";
                        break;
                    }
                    case -2: {
                        string5 = "data";
                        break;
                    }
                    case -1: {
                        string5 = "type";
                    }
                }
                Log.v((String)TAG, (String)("  Filter did not match: " + string5));
            }
            if (arrayList2 == null) {
                return false;
            }
            for (int i = 0; i < arrayList2.size(); ++i) {
                ((ReceiverRecord)arrayList2.get((int)i)).broadcasting = false;
            }
            this.mPendingBroadcasts.add(new BroadcastRecord(intent, arrayList2));
            if (this.mHandler.hasMessages(1)) return true;
            this.mHandler.sendEmptyMessage(1);
            return true;
        }
    }

    public void sendBroadcastSync(Intent intent) {
        if (this.sendBroadcast(intent)) {
            this.executePendingBroadcasts();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void unregisterReceiver(BroadcastReceiver broadcastReceiver) {
        HashMap<BroadcastReceiver, ArrayList<IntentFilter>> hashMap = this.mReceivers;
        synchronized (hashMap) {
            ArrayList<IntentFilter> arrayList = this.mReceivers.remove(broadcastReceiver);
            if (arrayList == null) {
                return;
            }
            int n = 0;
            block2: while (n < arrayList.size()) {
                IntentFilter intentFilter = arrayList.get(n);
                int n2 = 0;
                while (true) {
                    block10: {
                        ArrayList<ReceiverRecord> arrayList2;
                        String string2;
                        block11: {
                            block9: {
                                if (n2 >= intentFilter.countActions()) break block9;
                                string2 = intentFilter.getAction(n2);
                                arrayList2 = this.mActions.get(string2);
                                if (arrayList2 == null) break block10;
                                break block11;
                            }
                            ++n;
                            continue block2;
                        }
                        int n3 = 0;
                        while (true) {
                            if (n3 < arrayList2.size()) {
                                if (arrayList2.get((int)n3).receiver == broadcastReceiver) {
                                    arrayList2.remove(n3);
                                    --n3;
                                }
                            } else {
                                if (arrayList2.size() > 0) break;
                                this.mActions.remove(string2);
                                break;
                            }
                            ++n3;
                        }
                    }
                    ++n2;
                }
                break;
            }
            return;
        }
    }

    private static class BroadcastRecord {
        final Intent intent;
        final ArrayList<ReceiverRecord> receivers;

        BroadcastRecord(Intent intent, ArrayList<ReceiverRecord> arrayList) {
            this.intent = intent;
            this.receivers = arrayList;
        }
    }

    private static class ReceiverRecord {
        boolean broadcasting;
        final IntentFilter filter;
        final BroadcastReceiver receiver;

        ReceiverRecord(IntentFilter intentFilter, BroadcastReceiver broadcastReceiver) {
            this.filter = intentFilter;
            this.receiver = broadcastReceiver;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder(128);
            stringBuilder.append("Receiver{");
            stringBuilder.append(this.receiver);
            stringBuilder.append(" filter=");
            stringBuilder.append(this.filter);
            stringBuilder.append("}");
            return stringBuilder.toString();
        }
    }
}

