/*
 * Decompiled with CFR 0.152.
 */
package android.support.v4.app;

import android.os.Bundle;
import android.os.Parcelable;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentManager;
import android.support.v4.app.FragmentTransaction;
import android.support.v4.view.PagerAdapter;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import java.util.ArrayList;

public abstract class FragmentStatePagerAdapter
extends PagerAdapter {
    private static final boolean DEBUG = false;
    private static final String TAG = "FragmentStatePagerAdapter";
    private FragmentTransaction mCurTransaction = null;
    private Fragment mCurrentPrimaryItem = null;
    private final FragmentManager mFragmentManager;
    private ArrayList<Fragment> mFragments;
    private ArrayList<Fragment.SavedState> mSavedState = new ArrayList();

    public FragmentStatePagerAdapter(FragmentManager fragmentManager) {
        this.mFragments = new ArrayList();
        this.mFragmentManager = fragmentManager;
    }

    @Override
    public void destroyItem(ViewGroup viewGroup, int n, Object object) {
        Fragment fragment = (Fragment)object;
        if (this.mCurTransaction == null) {
            this.mCurTransaction = this.mFragmentManager.beginTransaction();
        }
        while (this.mSavedState.size() <= n) {
            this.mSavedState.add(null);
        }
        this.mSavedState.set(n, this.mFragmentManager.saveFragmentInstanceState(fragment));
        this.mFragments.set(n, null);
        this.mCurTransaction.remove(fragment);
    }

    @Override
    public void finishUpdate(ViewGroup viewGroup) {
        if (this.mCurTransaction != null) {
            this.mCurTransaction.commitAllowingStateLoss();
            this.mCurTransaction = null;
            this.mFragmentManager.executePendingTransactions();
        }
    }

    public abstract Fragment getItem(int var1);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Object instantiateItem(ViewGroup viewGroup, int n) {
        Fragment.SavedState savedState;
        Fragment fragment;
        if (this.mFragments.size() > n && (fragment = this.mFragments.get(n)) != null) {
            return fragment;
        }
        if (this.mCurTransaction == null) {
            this.mCurTransaction = this.mFragmentManager.beginTransaction();
        }
        Fragment fragment2 = this.getItem(n);
        if (this.mSavedState.size() > n && (savedState = this.mSavedState.get(n)) != null) {
            fragment2.setInitialSavedState(savedState);
        }
        while (this.mFragments.size() <= n) {
            this.mFragments.add(null);
        }
        fragment2.setMenuVisibility(false);
        this.mFragments.set(n, fragment2);
        this.mCurTransaction.add(viewGroup.getId(), fragment2);
        return fragment2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isViewFromObject(View view, Object object) {
        if (((Fragment)object).getView() != view) return false;
        return true;
    }

    @Override
    public void restoreState(Parcelable parcelable, ClassLoader classLoader) {
        if (parcelable != null) {
            Bundle bundle = (Bundle)parcelable;
            bundle.setClassLoader(classLoader);
            Parcelable[] parcelableArray = bundle.getParcelableArray("states");
            this.mSavedState.clear();
            this.mFragments.clear();
            if (parcelableArray != null) {
                for (int i = 0; i < parcelableArray.length; ++i) {
                    this.mSavedState.add((Fragment.SavedState)parcelableArray[i]);
                }
            }
            for (String string2 : bundle.keySet()) {
                if (!string2.startsWith("f")) continue;
                int n = Integer.parseInt(string2.substring(1));
                Fragment fragment = this.mFragmentManager.getFragment(bundle, string2);
                if (fragment != null) {
                    while (this.mFragments.size() <= n) {
                        this.mFragments.add(null);
                    }
                    fragment.setMenuVisibility(false);
                    this.mFragments.set(n, fragment);
                    continue;
                }
                Log.w((String)TAG, (String)("Bad fragment at key " + string2));
            }
        }
    }

    @Override
    public Parcelable saveState() {
        Bundle bundle = null;
        if (this.mSavedState.size() > 0) {
            bundle = new Bundle();
            Parcelable[] parcelableArray = new Fragment.SavedState[this.mSavedState.size()];
            this.mSavedState.toArray(parcelableArray);
            bundle.putParcelableArray("states", parcelableArray);
        }
        for (int i = 0; i < this.mFragments.size(); ++i) {
            Fragment fragment = this.mFragments.get(i);
            if (fragment == null) continue;
            if (bundle == null) {
                bundle = new Bundle();
            }
            String string2 = "f" + i;
            this.mFragmentManager.putFragment(bundle, string2, fragment);
        }
        return bundle;
    }

    @Override
    public void setPrimaryItem(ViewGroup viewGroup, int n, Object object) {
        Fragment fragment = (Fragment)object;
        if (fragment != this.mCurrentPrimaryItem) {
            if (this.mCurrentPrimaryItem != null) {
                this.mCurrentPrimaryItem.setMenuVisibility(false);
            }
            if (fragment != null) {
                fragment.setMenuVisibility(true);
            }
            this.mCurrentPrimaryItem = fragment;
        }
    }

    @Override
    public void startUpdate(ViewGroup viewGroup) {
    }
}

