/*
 * Decompiled with CFR 0.152.
 */
package android.support.v4.app;

import android.os.Parcel;
import android.os.Parcelable;
import android.support.v4.app.BackStackRecord;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentManagerImpl;
import android.text.TextUtils;
import android.util.Log;
import java.util.ArrayList;

final class BackStackState
implements Parcelable {
    public static final Parcelable.Creator<BackStackState> CREATOR = new Parcelable.Creator<BackStackState>(){

        public BackStackState createFromParcel(Parcel parcel) {
            return new BackStackState(parcel);
        }

        public BackStackState[] newArray(int n) {
            return new BackStackState[n];
        }
    };
    final int mBreadCrumbShortTitleRes;
    final CharSequence mBreadCrumbShortTitleText;
    final int mBreadCrumbTitleRes;
    final CharSequence mBreadCrumbTitleText;
    final int mIndex;
    final String mName;
    final int[] mOps;
    final int mTransition;
    final int mTransitionStyle;

    public BackStackState(Parcel parcel) {
        this.mOps = parcel.createIntArray();
        this.mTransition = parcel.readInt();
        this.mTransitionStyle = parcel.readInt();
        this.mName = parcel.readString();
        this.mIndex = parcel.readInt();
        this.mBreadCrumbTitleRes = parcel.readInt();
        this.mBreadCrumbTitleText = (CharSequence)TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(parcel);
        this.mBreadCrumbShortTitleRes = parcel.readInt();
        this.mBreadCrumbShortTitleText = (CharSequence)TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(parcel);
    }

    /*
     * Enabled aggressive block sorting
     */
    public BackStackState(FragmentManagerImpl fragmentManagerImpl, BackStackRecord backStackRecord) {
        int n = 0;
        BackStackRecord.Op op = backStackRecord.mHead;
        while (op != null) {
            if (op.removed != null) {
                n += op.removed.size();
            }
            op = op.next;
        }
        this.mOps = new int[n + 7 * backStackRecord.mNumOp];
        if (!backStackRecord.mAddToBackStack) {
            throw new IllegalStateException("Not on back stack");
        }
        BackStackRecord.Op op2 = backStackRecord.mHead;
        int n2 = 0;
        while (true) {
            int n3;
            if (op2 == null) {
                this.mTransition = backStackRecord.mTransition;
                this.mTransitionStyle = backStackRecord.mTransitionStyle;
                this.mName = backStackRecord.mName;
                this.mIndex = backStackRecord.mIndex;
                this.mBreadCrumbTitleRes = backStackRecord.mBreadCrumbTitleRes;
                this.mBreadCrumbTitleText = backStackRecord.mBreadCrumbTitleText;
                this.mBreadCrumbShortTitleRes = backStackRecord.mBreadCrumbShortTitleRes;
                this.mBreadCrumbShortTitleText = backStackRecord.mBreadCrumbShortTitleText;
                return;
            }
            int[] nArray = this.mOps;
            int n4 = n2 + 1;
            nArray[n2] = op2.cmd;
            int[] nArray2 = this.mOps;
            int n5 = n4 + 1;
            int n6 = op2.fragment != null ? op2.fragment.mIndex : -1;
            nArray2[n4] = n6;
            int[] nArray3 = this.mOps;
            int n7 = n5 + 1;
            nArray3[n5] = op2.enterAnim;
            int[] nArray4 = this.mOps;
            int n8 = n7 + 1;
            nArray4[n7] = op2.exitAnim;
            int[] nArray5 = this.mOps;
            int n9 = n8 + 1;
            nArray5[n8] = op2.popEnterAnim;
            int[] nArray6 = this.mOps;
            int n10 = n9 + 1;
            nArray6[n9] = op2.popExitAnim;
            if (op2.removed != null) {
                int n11 = op2.removed.size();
                int[] nArray7 = this.mOps;
                int n12 = n10 + 1;
                nArray7[n10] = n11;
                int n13 = n12;
                for (int i = 0; i < n11; ++i) {
                    int[] nArray8 = this.mOps;
                    int n14 = n13 + 1;
                    nArray8[n13] = op2.removed.get((int)i).mIndex;
                    n13 = n14;
                }
                n3 = n13;
            } else {
                int[] nArray9 = this.mOps;
                n3 = n10 + 1;
                nArray9[n10] = 0;
            }
            op2 = op2.next;
            n2 = n3;
        }
    }

    public int describeContents() {
        return 0;
    }

    /*
     * Enabled aggressive block sorting
     */
    public BackStackRecord instantiate(FragmentManagerImpl fragmentManagerImpl) {
        BackStackRecord backStackRecord = new BackStackRecord(fragmentManagerImpl);
        int n = 0;
        while (true) {
            if (n >= this.mOps.length) {
                backStackRecord.mTransition = this.mTransition;
                backStackRecord.mTransitionStyle = this.mTransitionStyle;
                backStackRecord.mName = this.mName;
                backStackRecord.mIndex = this.mIndex;
                backStackRecord.mAddToBackStack = true;
                backStackRecord.mBreadCrumbTitleRes = this.mBreadCrumbTitleRes;
                backStackRecord.mBreadCrumbTitleText = this.mBreadCrumbTitleText;
                backStackRecord.mBreadCrumbShortTitleRes = this.mBreadCrumbShortTitleRes;
                backStackRecord.mBreadCrumbShortTitleText = this.mBreadCrumbShortTitleText;
                backStackRecord.bumpBackStackNesting(1);
                return backStackRecord;
            }
            BackStackRecord.Op op = new BackStackRecord.Op();
            int[] nArray = this.mOps;
            int n2 = n + 1;
            op.cmd = nArray[n];
            if (FragmentManagerImpl.DEBUG) {
                Log.v((String)"FragmentManager", (String)("BSE " + backStackRecord + " set base fragment #" + this.mOps[n2]));
            }
            int[] nArray2 = this.mOps;
            int n3 = n2 + 1;
            int n4 = nArray2[n2];
            op.fragment = n4 >= 0 ? fragmentManagerImpl.mActive.get(n4) : null;
            int[] nArray3 = this.mOps;
            int n5 = n3 + 1;
            op.enterAnim = nArray3[n3];
            int[] nArray4 = this.mOps;
            int n6 = n5 + 1;
            op.exitAnim = nArray4[n5];
            int[] nArray5 = this.mOps;
            int n7 = n6 + 1;
            op.popEnterAnim = nArray5[n6];
            int[] nArray6 = this.mOps;
            int n8 = n7 + 1;
            op.popExitAnim = nArray6[n7];
            int[] nArray7 = this.mOps;
            int n9 = n8 + 1;
            int n10 = nArray7[n8];
            if (n10 > 0) {
                op.removed = new ArrayList(n10);
                for (int i = 0; i < n10; ++i) {
                    if (FragmentManagerImpl.DEBUG) {
                        Log.v((String)"FragmentManager", (String)("BSE " + backStackRecord + " set remove fragment #" + this.mOps[n9]));
                    }
                    ArrayList<Fragment> arrayList = fragmentManagerImpl.mActive;
                    int[] nArray8 = this.mOps;
                    int n11 = n9 + 1;
                    Fragment fragment = arrayList.get(nArray8[n9]);
                    op.removed.add(fragment);
                    n9 = n11;
                }
            }
            n = n9;
            backStackRecord.addOp(op);
        }
    }

    public void writeToParcel(Parcel parcel, int n) {
        parcel.writeIntArray(this.mOps);
        parcel.writeInt(this.mTransition);
        parcel.writeInt(this.mTransitionStyle);
        parcel.writeString(this.mName);
        parcel.writeInt(this.mIndex);
        parcel.writeInt(this.mBreadCrumbTitleRes);
        TextUtils.writeToParcel((CharSequence)this.mBreadCrumbTitleText, (Parcel)parcel, (int)0);
        parcel.writeInt(this.mBreadCrumbShortTitleRes);
        TextUtils.writeToParcel((CharSequence)this.mBreadCrumbShortTitleText, (Parcel)parcel, (int)0);
    }
}

