/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.dex2jar.reader;

import com.googlecode.dex2jar.reader.DexCodeReader;
import com.googlecode.dex2jar.reader.DexFileReader;
import com.googlecode.dex2jar.reader.io.DataIn;
import com.googlecode.dex2jar.visitors.DexCodeVisitor;

class DexDebugInfoReader {
    public static final int DBG_END_SEQUENCE = 0;
    public static final int DBG_ADVANCE_PC = 1;
    public static final int DBG_ADVANCE_LINE = 2;
    public static final int DBG_START_LOCAL = 3;
    public static final int DBG_START_LOCAL_EXTENDED = 4;
    public static final int DBG_END_LOCAL = 5;
    public static final int DBG_RESTART_LOCAL = 6;
    public static final int DBG_SET_PROLOGUE_END = 7;
    public static final int DBG_SET_EPILOGUE_BEGIN = 8;
    public static final int DBG_SET_FILE = 9;
    public static final int DBG_FIRST_SPECIAL = 10;
    public static final int DBG_LINE_BASE = -4;
    public static final int DBG_LINE_RANGE = 15;
    private DataIn in;
    private DexFileReader dex;
    private int instruction_size;
    private DexCodeReader codeReader;
    LocalVariable[] variableList;
    int[] args;

    public DexDebugInfoReader(DataIn in, DexFileReader dex, int instruction_size, DexCodeReader codeReader, LocalVariable[] localVariables, int[] args) {
        this.in = in;
        this.dex = dex;
        this.instruction_size = instruction_size;
        this.codeReader = codeReader;
        this.variableList = localVariables;
        this.args = args;
    }

    public void accept(DexCodeVisitor dcv) {
        DataIn in = this.in;
        int line = (int)in.readULeb128();
        int szParams = (int)in.readULeb128();
        int offset = szParams == this.args.length ? 0 : 1;
        int i = 0;
        while (i < szParams) {
            int string_offset = (int)in.readULeb128() - 1;
            if (string_offset < 0) {
                this.variableList[this.args[i + offset]] = null;
            } else {
                String psName;
                this.variableList[this.args[i + offset]].name = psName = this.dex.getString(string_offset);
            }
            ++i;
        }
        int pcOffset = 0;
        this.codeReader.order(pcOffset);
        dcv.visitLineNumber(line, this.codeReader.labels.get(pcOffset));
        block13: while (true) {
            int opcode = in.readUByte();
            switch (opcode) {
                case 0: {
                    break block13;
                }
                case 1: {
                    int offset2 = (int)in.readULeb128();
                    pcOffset += offset2;
                    continue block13;
                }
                case 2: {
                    int offset2 = (int)in.readLeb128();
                    line += offset2;
                    continue block13;
                }
                case 3: {
                    LocalVariable localVariable;
                    int regNum = (int)in.readULeb128();
                    int nameIdx = (int)in.readULeb128() - 1;
                    int typeIdx = (int)in.readULeb128() - 1;
                    if (nameIdx < 0 || typeIdx < 0) continue block13;
                    this.codeReader.order(pcOffset);
                    this.variableList[regNum] = localVariable = new LocalVariable(regNum, pcOffset, -1, this.dex.getString(nameIdx), this.dex.getType(typeIdx), null);
                    continue block13;
                }
                case 4: {
                    LocalVariable localVariable;
                    int regNum = (int)in.readULeb128();
                    int nameIdx = (int)in.readULeb128() - 1;
                    int typeIdx = (int)in.readULeb128() - 1;
                    int sigIdx = (int)in.readULeb128() - 1;
                    if (nameIdx < 0 || typeIdx < 0) continue block13;
                    this.codeReader.order(pcOffset);
                    this.variableList[regNum] = localVariable = new LocalVariable(regNum, pcOffset, -1, this.dex.getString(nameIdx), this.dex.getType(typeIdx), this.dex.getString(sigIdx));
                    continue block13;
                }
                case 5: {
                    int regNum = (int)in.readULeb128();
                    LocalVariable v = this.variableList[regNum];
                    this.codeReader.order(pcOffset);
                    v.end = pcOffset;
                    dcv.visitLocalVariable(v.name, v.type, v.signature, this.codeReader.labels.get(v.start), this.codeReader.labels.get(pcOffset), v.reg);
                    continue block13;
                }
                case 6: {
                    int regNum = (int)in.readULeb128();
                    LocalVariable v = this.variableList[regNum];
                    v.start = pcOffset;
                    v.end = -1;
                    this.codeReader.order(pcOffset);
                    continue block13;
                }
                case 7: {
                    continue block13;
                }
                case 8: {
                    continue block13;
                }
                case 9: {
                    in.readULeb128();
                    continue block13;
                }
                default: {
                    int adjustedOpcode = opcode - 10;
                    line += -4 + adjustedOpcode % 15;
                    if (adjustedOpcode / 15 == 0) continue block13;
                    this.codeReader.order(pcOffset += adjustedOpcode / 15);
                    dcv.visitLineNumber(line, this.codeReader.labels.get(pcOffset));
                    continue block13;
                }
            }
            break;
        }
        LocalVariable[] localVariableArray = this.variableList;
        int n = this.variableList.length;
        int n2 = 0;
        while (n2 < n) {
            LocalVariable v = localVariableArray[n2];
            if (v != null && v.end < 0) {
                this.codeReader.order(this.instruction_size);
                dcv.visitLocalVariable(v.name, v.type, v.signature, this.codeReader.labels.get(v.start), this.codeReader.labels.get(this.instruction_size), v.reg);
            }
            ++n2;
        }
    }

    public static class LocalVariable {
        public int start;
        public int end;
        public String name;
        public String type;
        public String signature;
        public int reg;

        public LocalVariable(int reg, int start, int end, String name, String type, String signature) {
            this.reg = reg;
            this.start = start;
            this.end = end;
            this.name = name;
            this.type = type;
            this.signature = signature;
        }
    }
}

