from ScriptEngine import *
from globaldefine import *

class BrowBase:
	def __init__(self, display, layermanager, srcuin, dstuin):
		self.display = display
		self.layermanager = layermanager
		self.srcuin = srcuin
		self.dstuin = dstuin[0]
		
		self.gameobjectid = GAMEOBJECTID_AVATAR
		self.browplay = None
		self.onscriptend = self.OnScriptEnd
		self.onsize = self.OnSize		
		
		self.ImageFile = None
		#self.SoundFile = None

	def Run(self):
		RegisterEvent(self, GAMEEVENTID_ONSIZE, self.onsize)
		self.DstAvatarInfo = GetObjectInfoByID(self.dstuin, self.gameobjectid)
		if self.DstAvatarInfo != None:
			self.SetBrowParam()
			self.PlayBrow()
		
	def OnSize(self):	
		self.DstAvatarInfo = GetObjectInfoByID(self.dstuin, self.gameobjectid)
		self.ChangePosition(self.browplay)	

	def ChangePosition(self, image):
		if image != None:
			image.ChangePosition(self.DstAvatarInfo["X"], self.DstAvatarInfo["Y"])
		
	def PlayBrow(self):
		self.browplay = Image(self,self.display,self.layermanager)
		self.browplay.LoadImage(self.ImageFile)
		self.browplay.DrawImageAbove(self.DstAvatarInfo["X"], self.DstAvatarInfo["Y"],  GAMEOBJECTID_FOREGROUND, 1)
		#PlaySound(self.SoundFile)
		self.browplay.OnDelayEvent = self.onscriptend
		
		HideObjectByID(self.dstuin, GAMEOBJECTID_AVATAR)
		
	def OnScriptEnd(self):
		ShowObjectByID(self.dstuin, GAMEOBJECTID_AVATAR)
		ExitScript(self)
		return