// Copyright 2023 TigRig All rights reserved.

/**
 * /data/system/KeyConfig.js にて設定可能なアクション `toggle_menu_ks`
 * - menu.ks で定義したメニュー画面を開く
 * - すでに menu.ks 等 `.menu_close` ボタンが存在するメニュー画面が表示されている場合、対象の画面を閉じる
 */
tyrano.plugin.kag.key_mouse.toggle_menu_ks = function () {
    // 何らかのメニューが表示されている場合
    // → メニューを閉じる
    if ($(".layer_menu .menu_close").length > 0) {
        $(".layer_menu .menu_close").click();
        return;
    }
    if ($(".menu_close").length > 0) {
        $(".menu_close").click();
        return;
    }

    // メニューが非表示の場合
    // → メニューを開く（ sleepgame タグで menu.ks をコールする）
    const pm = {
        storage: "menu.ks",
        next: false,
    };
    TYRANO.kag.ftag.startTag("sleepgame", pm);
};

